#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"

int NP_Node::update_group( char *group )
{
   if ( group == NULL )
   {
      strcpy( error_message, "NP_Node: update_group(): "
              "NULL group name passed as argument." );
      return 1;
   }

   int i;
   NP_Group **pointer = groups;
   for( i = 0; i < total_groups; ++i )
   {
      if ( !strcmp( ( *pointer )->get_name(), group ))
         break;
      ++pointer;
   }
      
   if ( i == total_groups )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Node: update_group(): no such group has been added to "
                "this node object: %s", group );
      return 1;
   }

   if ( ( *pointer )->update() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update_group():"
                " %s", ( *pointer )->get_error() );
      return 1;
   }
   
   return 0;
}
