#include "npconfig.h"

void do_lists( int i, GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   GtkWidget *window =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "window" );

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "subscribed" );
   
   if ( i )
   {
      int total = config->temp_deleted.get_total();
      if ( total < 0 )
         config->temp_deleted.print_error();
      else
         if ( total )
            for( int j = 0; j < total; ++j )
            {
               int k;
               if (( k = config->deleted.add_item(
                  config->temp_deleted[ j ] )))
                  if ( k != 2 )
                  {
                     config->deleted.print_error();
                     break;
                  }
            }
            
      gtk_clist_clear( GTK_CLIST( config->group_clist ));
      if ( config->subscription.clear_server( config->current_server ) )
      {
         config->subscription.print_error();
         return;
      }

      gtk_clist_freeze( GTK_CLIST( clist ));
      gtk_clist_freeze( GTK_CLIST( config->group_clist ));

      char buffer[ 256 ];

      gchar *text[ 2 ];
      if ( config->group_clist_lines )
         for( int j = 0; j < config->group_clist_lines; ++j )
         {
            gtk_clist_get_text( GTK_CLIST( clist ), j, 0, &text[ 0 ] );
            gtk_clist_get_text( GTK_CLIST( clist ), j, 1, &text[ 1 ] );

            int result;
            if (( result =
                  config->subscription.add_group( config->current_server,
                                                  ( const char *)text[ 0 ],
                                                  ( const char *)text[ 1 ] )))
            {
               if ( result == 2 )
               {
                  snprintf( buffer, sizeof buffer,
                            "Duplicate entry for %s ignored", text[ 0 ] );
                  config->show_message( buffer, 0 );

                  while( config->message_window != NULL )
                     while( gtk_events_pending() )
                        gtk_main_iteration();
                  
                  continue;
               }
               
               config->subscription.print_error();
               return;
            }

            gtk_clist_append( GTK_CLIST( config->group_clist ), text );
         }

      snprintf( buffer, sizeof buffer, "%d Subscribed Newsgroups",
                config->group_clist_lines );
      gtk_clist_set_column_title( GTK_CLIST( config->group_clist ), 0,
                                  buffer );
      gtk_clist_thaw( GTK_CLIST( clist ));
      gtk_clist_thaw( GTK_CLIST( config->group_clist ));
   }
   else
      if ( config->temp_deleted.clear() )
         config->temp_deleted.print_error();
   
   gtk_grab_remove( window );
   gtk_widget_destroy( window );

   config->lists_window = NULL;

   if ( config->regex_alloc )
      regfree( &config->regex );

   config->regex_alloc = 0;
   config->dirty = 1;
   
   return;
}
