#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npgeneral.h"

int NP_General::load()
{
   char buffer[ 1024 ], *pointer;

   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", home );
   if ( config.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_General: "
                "load(): %s", config.get_error() );

      if ( errno != ENOENT )
         return 1;
      
      return 2;
   }
   
   if (( pointer = config.get_string() ) == NULL )
   {
      config.print_error();
      config.close();
      return 1;
   }

   if (( pointer = strtok( pointer, "\n" )) != NULL )
   {
      if ( email != NULL )
         free( email );
      if (( email = strdup( pointer )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
   }   

   if (( pointer = config.get_string() ) == NULL )
   {
      config.print_error();
      config.close();
      return 1;
   }

   if (( pointer = strtok( pointer, "\n" )) != NULL )
   {
      if ( editor != NULL )
         free( editor );

      if (( editor = strdup( pointer )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
   }

   if (( pointer = config.get_string() ) == NULL )
   {
      config.print_error();
      config.close();
      return 1;
   }

   if (( pointer = strtok( pointer, "\n" )) != NULL )
   {
      if ( browser != NULL )
         free( browser );

      if (( browser = strdup( pointer )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
   }

   if (( pointer = config.get_string() ) == NULL )
   {
      config.print_error();
      config.close();
      return 1;
   }

   if (( pointer = strtok( pointer, "\n" )) != NULL )
      expiry = atoi( pointer );

   config.close();
   
   return 0;
}
