#include "npconfig.h"

void NP_Config::update_server_buttons( int i )
{
   gtk_widget_destroy( server_buttons[ i ] );

   int total = subscription.get_total();
   if ( total < 0 )
   {
      subscription.print_error();
      return;
   }

   if ( !total )
   {
      if ( server_buttons != NULL )
         free( server_buttons );
      
      server_buttons = NULL;
      gtk_clist_clear( GTK_CLIST( group_clist ));
      return;
   }

   GtkWidget **temp_buttons;
   if (( temp_buttons =
         ( GtkWidget **)calloc( total, sizeof *server_buttons )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   GtkWidget **temp = temp_buttons;
   GtkWidget **pointer = server_buttons;

   int old_total = total + 1;
   for( int j = 0; j < old_total; ++j )
   {
      if ( j == i )
      {
         ++pointer;
         continue;
      }

      *temp++ = *pointer++;
   }

   free( server_buttons );
   server_buttons = temp_buttons;

   return;
}

      
