#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npnews.h"

int NP_News::remove_headers()
{
   if ( requests_list == NULL )
      return 0;

   NP_File spool, temp, read, temp_read;

   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, address, group );
   if ( spool.openr( spool_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", spool.get_error());
      return 1;
   }

   char temp_path[ 1024 ];
   snprintf( temp_path, sizeof temp_path, "%s:temp", spool_path );
   if ( temp.openw( temp_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", temp.get_error());
      return 1;
   }

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", spool_path );
   if ( read.openr( read_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", read.get_error());
      return 1;
   }

   char temp_read_path[ 1024 ];
   snprintf( temp_read_path, sizeof temp_read_path, "%s:temp", read_path );
   if ( temp_read.openw( temp_read_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", temp_read.get_error());
      return 1;
   }

   long position = spool.tell();
   if ( position < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", spool.get_error());
      return 1;
   }

   long read_position = read.tell();
   if ( read_position < 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "remove_headers(): %s", read.get_error());
      return 1;
   }

   char *line;
   while(( line = spool.get_string()) != NULL )
   {
      if ( *line != '@' )
      {
         if ( temp.put_string( line ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", temp.get_error());
            return 1;
         }

         do
         {
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "remove_headers(): %s", spool.get_error());
               return 1;
            }

            if ( temp.put_string( line ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "remove_headers(): %s", temp.get_error());
               return 1;
            }
         }
         while( strncmp( line, ".\r\n", 3 ));

         if (( line = read.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", read.get_error());
            return 1;
         }

         if ( temp_read.put_string( line ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", temp_read.get_error());
            return 1;
         }

         position = spool.tell();
         if ( position < 0 )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", spool.get_error());
            return 1;
         }

         read_position = read.tell();
         if ( read_position < 0 )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", read.get_error());
            return 1;
         }

         continue;
      }

      while(( line = spool.get_string()) != NULL )
         if ( !strncasecmp( line, "Message-ID:", 11 ))
            break;

      strtok( line, "\r\n" );

      np_requests_list_t *pointer = requests_list;
      int i;
      for( i = 0; i < total_requests; ++i )
      {
         char *body = line + 11 + strspn( line + 11, " \t" );
         if ( !strcmp( body, pointer->request ))
            break;

         ++pointer;
      }

      if ( spool.seek( position, SEEK_SET ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "remove_headers(): %s", spool.get_error());
         return 1;
      }

      if ( read.seek( read_position, SEEK_SET ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "remove_headers(): %s", read.get_error());
         return 1;
      }

      if ( i == total_requests || !pointer->found )
      {
         if (( line = read.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", read.get_error());
            return 1;
         }

         if ( temp_read.put_string( line ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", temp_read.get_error());
            return 1;
         }

         do
         {
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "remove_headers(): %s", spool.get_error());
               return 1;
            }

            if ( temp.put_string( line ))
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "remove_headers(): %s", temp.get_error());
               return 1;
            }
         }
         while( strncmp( line, ".\r\n", 3 ));
      }
      else
      {
         if (( line = read.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "remove_headers(): %s", read.get_error());
            return 1;
         }

         do
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "remove_headers(): %s", spool.get_error());
               return 1;
            }
         while( strncmp( line, ".\r\n", 3 ));
      }

      position = spool.tell();
      if ( position < 0 )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "remove_headers(): %s", spool.get_error());
         return 1;
      }

      read_position = read.tell();
      if ( read_position < 0 )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "remove_headers(): %s", read.get_error());
         return 1;
      }
   }

   spool.close();
   read.close();
   temp.close();
   temp_read.close();

   rename( temp_path, spool_path );
   rename( temp_read_path, read_path );

   strcat( spool_path, ":requests" );
   remove( spool_path );

   return 0;
}
