/* Copyright (C) 2000-2002 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _GPROGRESS_H
#define _GPROGRESS_H
#include "basics.h"

extern void GProgressStartIndicator(
    int delay,			/* in tenths of seconds */
    const unichar_t *win_title,	/* for the window decoration */
    const unichar_t *line1,	/* First line of description */
    const unichar_t *line2,	/* Second line */
    int tot,			/* Number of sub-entities in the operation */
    int stages			/* Number of stages, each processing tot sub-entities */
);
extern void GProgressStartIndicatorR(int delay, int win_titler, int line1r,
	int line2r, int tot, int stages);
extern void GProgressEndIndicator(void);	/* Ends the topmost indicator */
extern void GProgressChangeLine1(const unichar_t *line1); /* Changes the text in the topmost */
extern void GProgressChangeLine2(const unichar_t *line2); /* Changes the text in the topmost */
extern void GProgressChangeLine1R(int line1r);		/* Changes the text in the topmost */
extern void GProgressChangeLine2R(int line2r);		/* Changes the text in the topmost */
extern void GProgressChangeTotal(int tot);		/* Changes the expected length in the topmost */
extern void GProgressChangeStages(int stages);		/* Changes the expected number of stages in the topmost */
extern void GProgressEnableStop(int enabled);		/* Allows you to disable and enable the stop button if it can't be used in a section of code */
    /* if any of the next routines returns false, then abort processing */
extern int GProgressNextStage(void);	/* Move to the next stage in the topmost indicator */
extern int GProgressNext(void);		/* Increment progress by one sub-entity */
extern int GProgressIncrementBy(int cnt);	/* Increment progress by cnt sub-entities */
#endif
