#ifndef _PFE_FORTH_83_EXT_H
#define _PFE_FORTH_83_EXT_H 1002653676
/* generated 2001-1009-2054 ../../../pfe/../mk/Make-H.pl ../../../pfe/forth-83-ext.c */

#include <pfe/incl-ext.h>

/** 
 * --  Compatiblity with the FORTH-83 standard.
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: bln_mpt1!5.17 %
 *    (%date_modified: Tue Oct 02 15:46:57 2001 %)
 *
 *  @description
 *     All FORTH-83-Standard words are included here that are not 
 *     in the dpANS already.
 *     Though most of the "uncontrolled reference words" are omitted.
 */

#ifdef __cplusplus
extern "C" {
#endif




/** 2+ ( i -- i ) 
 *  add 2 to the value on stack (and leave the result there)
 simulate:
   : 2+ 2 + ;
 */
extern P4_CODE (p4_two_plus);

/** 2- ( i -- i )
 *  substract 2 from the value on stack (and leave the result there)
 simulate:
   : 2- 2 - ;
 */
extern P4_CODE (p4_two_minus);

/** COMPILE ( 'word' -- ) 
 * compile the next word. The next word should not be immediate,
 * in which case you would have to use =>'[COMPILE]'. For this
 * reason, you should use the word =>'POSTPONE', which takes care
 * it.
 simulate:
   : COMPILE  R> DUP @ , CELL+ >R ;  ( not immediate !!! )
 */
extern P4_CODE (p4_compile);

/** ((VOCABULARY)) ( -- )
 * runtime of a => VOCABULARY
 */
extern P4_CODE (p4_vocabulary_RT);

/** VOCABULARY ( 'name' -- )
 * create a vocabulary of that name. If the named vocabulary
 * is called later, it will run => ((VOCABULARY)) , thereby
 * putting it into the current search order.
 * Special pfe-extensions are accessible via 
 * => CASE-SENSITIVE-VOC and => SEARCH-ALSO-VOC
 simulate:
   : VOCABULARY  CREATE ALLOT-WORDLIST
        DOES> ( the ((VOCABULARY)) runtime )
          CONTEXT ! 
   ; IMMEDIATE
 */
extern P4_CODE (p4_vocabulary);

/** --> ( -- ) no-return
 * does increase => BLK and refills the input-buffer
 * from there. Does hence break interpretation of the
 * current BLK and starts with the next. Old-style
 * forth mechanism. You should use => INCLUDE
 */
extern P4_CODE (p4_next_block);

/** K ( -- counter-val )
 * the 3rd loop index just like => I and => J
 */
extern P4_CODE (p4_k);

/** OCTAL ( -- )
 * sets => BASE to 8. Compare with => HEX and => DECIMAL
 simulate:
   : OCTAL  8 BASE ! ;
 */
extern P4_CODE (p4_octal);

/** SP@ ( -- )
 * the address of the top of stack. Does save it onto
 * the stack. You could do 
   : DUP  SP@ @ ;
 */
extern P4_CODE (p4_s_p_fetch);

/** !BITS ( bits addr mask -- )
 * at the cell pointed to by addr, change only the bits that
 * are enabled in mask
 simulate:
   : !BITS  >R 2DUP @ R NOT AND SWAP R> AND OR SWAP ! DROP ;
 */
extern P4_CODE (p4_store_bits);

/** ** ( a b -- r )
 * raise second to top power
 */
extern P4_CODE (p4_power);

/** >< ( a -- a' )
 * byte-swap a word
 */
extern P4_CODE (p4_byte_swap);

/** >MOVE< ( from-addr to-addr count -- )
 * see => MOVE , does byte-swap for each word underway
 */
extern P4_CODE (p4_byte_swap_move);

/** @BITS ( addr mask -- value )
 * see the companion word => !BITS
 simulate:
   : @BITS  SWAP @ AND ;
 */
extern P4_CODE (p4_fetch_bits);

/** SEAL ( -- )
 * looks through the search-order and kills the ONLY wordset -
 * hence you can't access the primary vocabularies from there.
 */
extern P4_CODE (p4_seal);

/** NOT ( x - ~x )
 * a => SYNONYM for => INVERT - the word => NOT is not portable as in some
 * systems it is a => SYNONYM for => 0= ... therefore try to avoid it.
 * (may change later to be a real => SYNONYM of either => INVERT or =>"0=")
 : NOT INVERT LOG.WARN" forth' NOT is not portable, use INVERT or 0=" ;
 */
extern P4_CODE (p4_not);

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif
