# $Progeny: installer-text.sh,v 1.85 2002/04/23 23:49:03 branden Exp $

# Syntax: check_partition disk_partition_device
#   e.g., check_partition /dev/hda1
check_partition () {
    if [ -z "$1" ]; then
        pgilog "Internal error: check_partition() called without an argument."
        return 2
    else
        # XXX: erm, would be nice to support ext3, reiserfs, etc.
        # XXX: erm, not just nice, required in the case of ia64 (EFI)
        for type in ext2 vfat; do
            if mount -t $type -o ro $1 /mnt; then
                umount $1
                PARTTYPE=$type
                return 0
            fi
        done
        return 1
    fi;
}

# Syntax: build_partition_selection_menu
build_partition_selection_menu () {
    # build list of partitions available for selection
    PARTITION_LIST_MENU=
    for PARTITION in $PARTITION_LIST; do
        if [ -n "$PARTITION_LIST_MENU" ]; then
            PARTITION_LIST_MENU="$PARTITION_LIST_MENU $PARTITION ''"
        else
            PARTITION_LIST_MENU="$PARTITION ''"
        fi
    done

    # build list of disks available for viewing
    DISK_LIST_VIEW_MENU=
    for DISK in $DISK_LIST; do
        # don't change the text without changing the grep and sed in the next
        # block
        if [ -n "$DISK_LIST_VIEW_MENU" ]; then
            DISK_LIST_VIEW_MENU="$DISK_LIST_VIEW_MENU 'View partition table of $DISK' ''"
        else
            DISK_LIST_VIEW_MENU="'View partition table of $DISK' ''"
        fi
    done

    DIALOG_MENU_LIST="$PARTITION_LIST_MENU $DISK_LIST_VIEW_MENU"
    pgilog "\$DIALOG_MENU_LIST is \"$DIALOG_MENU_LIST\".";
}

# Syntax: display_partition_table disk_device
#  e.g., display_partition_table /dev/hda
display_partition_table () {
    if [ -z "$1" ]; then
        pgilog "Internal error: display_partition_table() called without an argument."
        return 2
    else
        TEMPFILE=$(tempfile)
        parted $1 print > $TEMPFILE
        $DIALOG --backtitle "PGI Debian Installer" \
            --title "Partition Report for $1" --textbox $TEMPFILE 19 70
        rm -f $TEMPFILE
    fi;
}

echo
echo
echo "Starting PGI Debian text-mode installer..."

# give the user time to read the above before the dialogs begin
sleep 2

DIALOG=$LIVE/bin/dialog
PARTED=$LIVE/bin/parted

EXTRA_PACKAGES=$LIVE/share/installer/extra_packages

pgilog "Prompting mode is \"$PROMPTING\"."
pgilog "Using Linux kernel $KERNEL_VERSION."

echo "lspci output:" >> $LOGFILE
lspci >> $LOGFILE
echo "*******************************************************" >> $LOGFILE

echo "lspci -n output (no different from above if PCI list not compiled into kernel):" >> $LOGFILE
lspci -n >> $LOGFILE
echo "*******************************************************" >> $LOGFILE

pgilog "Dumping dmesg to $DMESGLOG."
dmesg >> $DMESGLOG

for COMMAND in $DIALOG $PARTED; do
    while :; do
        pgilog -n "Checking for command $COMMAND..."
        if command -v $(basename $COMMAND) > /dev/null 2>&1; then
            pgilog "found."
            break
        else
            pgilog "not found.  Spawning shell."
            echo "Error in installer environment: can't find $COMMAND in $PATH."
            echo "Here's a shell prompt so you can set things right."
            envsh
        fi
    done
done

USER_HAPPY=
USE_GRUB=
CANCEL=

# ensure no filesystems from a previous install attempt are still mounted
unmount_targets

# sorry, folks, gotta turn off debugging for dialog's sake
set +x

# get welcome msg
python $LIVE/share/installer/get-message.py start | sed 's/"/\\"/g' \
    > /tmp/greet-msg
if [ ! -s /tmp/greet-msg ]; then
    cat > /tmp/greet-msg << EOF
Welcome to the PGI Debian GNU/Linux Installer.

There are four parts to the installation process:
  First, disks are partitioned.
  Second, the system packages are installed.
  Third, the boot loader is configured (if desired).
  Finally, the new system is entered and configured.

Be sure to back up any important data before installation.

Thank you for using Debian GNU/Linux!
EOF
fi

# welcome
pgilog "Prompting user with welcome screen."
$DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
    --title "Welcome to Debian GNU/Linux" --textbox /tmp/greet-msg 19 70
pgilog "Prompting user with proceed screen."
$DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
    --title "Start Installation Procedure" --yesno \
    "Proceed with installation of Debian GNU/Linux?" 5 70
# check for cancellation
if [ $? -ne 0 ]; then
    CANCEL=yes
    break
fi

# get list of available disk devices from parted
DISK_LIST=$(list-devices --disks)
pgilog "\$DISK_LIST is \"$DISK_LIST\"."

if [ -z "$DISK_LIST" ]; then
    pgilog "Prompting user that no disks could be found."
    $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
        --title "Error in Installer Environment" --msgbox \
        "GNU parted cannot find any disks on the system.\n\nThe Linux kernel used by this installer either does not support your hardware, or there are no hard drives installed.\n\nCancelling installation." 10 70
    CANCEL=yes
fi

while [ -z "$USER_HAPPY" -a -z "$CANCEL" ]; do
    ############################################################################
    # partition disks
    ############################################################################

    DIALOG_MENU_LIST=
    for DISK in $DISK_LIST; do
        DIALOG_MENU_LIST="$DIALOG_MENU_LIST $DISK ''"
    done

    DIALOG_MENU_LIST="$DIALOG_MENU_LIST 'Done Partitioning' ''"

    while :; do
        pgilog "Prompting user with list of disks to partition."
        eval $DIALOG --no-cancel --cr-wrap --backtitle \"PGI Debian Installer\" \
            --title \"Select Disk to Partition\" --menu \
            \"Which disk do you want to partition?\\\n\\\nThe GNU parted program will be launched to partiton the selected disk.  For help with GNU parted, simply type \'help\' at its prompt.\\\n\\\nDon\'t forget to create filesystems on the partition\(s\) you will be using \(except for swap partitions, of course\).\" 17 70 4 \
            $DIALOG_MENU_LIST \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
        DISK=$(cat /tmp/prompt)
        pgilog "User chose \"$DISK\"."

        if [ "$DISK" = "Done Partitioning" ]; then
            pgilog "User is done partitioning."
            # get list of known partitions from parted; this is newline-delimited
            PARTITION_LIST=$(list-devices)
            pgilog "\$PARTITION_LIST is:"
            pgilog "$PARTITION_LIST"
            # extra echo needed to work around bug in busybox sh or test
            NUM_PARTITIONS=$(echo "$PARTITION_LIST" | wc -l)
            if [ $NUM_PARTITIONS -lt 2 ]; then
                pgilog "Prompting user that there are not enough partitions (only $NUM_PARTITIONS)."
                $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
                    --title "Insufficient Number of Disk Partitions" --msgbox \
                    "GNU parted cannot find enough disk partitions on the system to support an installation of Debian GNU/Linux.\n\nAt least two partitions are required; one for the root filesystem and one for swap space.\n\nPlease create some partitions." 11 70
                # check for cancellation
                if [ $? -ne 0 ]; then
                    CANCEL=yes
                    break 2
                fi
            else
                break
            fi
        else
            pgilog "Running \"$PARTED --interactive $DISK\"."
            clear
            $PARTED --interactive $DISK
        fi
    done

    ############################################################################
    # associate partitions with mount points; we know there are at least two

    # choose a swap partition
    build_partition_selection_menu
    while :; do
        pgilog "Prompting user for swap device."
        eval $DIALOG --no-cancel --cr-wrap --backtitle \"PGI Debian Installer\" \
            --title \"Select a Partition to Use As the Swap Device\" \
            --menu \
            \"Choose a partition to use as your swap partition.\" 19 70 4 \
            $DIALOG_MENU_LIST \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break 2
        fi
        # check for partition viewing
        if grep -q View /tmp/prompt; then
            pgilog "User wants to \"$(cat /tmp/prompt)\"."
            # kludgey!
            DISK=$(sed 's/View partition table of //' < /tmp/prompt)
            display_partition_table $DISK
        else
            break
        fi
    done
    SWAPPART=$(cat /tmp/prompt)
    pgilog "User said \"$SWAPPART\" is the swap device."

    # eliminate this partition from future choices
    PARTITION_LIST=$(echo "$PARTITION_LIST" | grep -v ^$SWAPPART\$)
    pgilog "\$PARTITION_LIST is now:"
    pgilog "$PARTITION_LIST"

    # choose a root partition
    build_partition_selection_menu
    while :; do
        pgilog "Prompting user for root filesystem."
        eval $DIALOG --no-cancel --cr-wrap --backtitle \"PGI Debian Installer\" \
            --title \"Select a Partition to Use As the Filesystem Root\" \
            --menu \"Choose a partition to use as your root partition.\" 19 70 4 \
            $DIALOG_MENU_LIST \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break 2
        fi
        # check for partition viewing
        if grep -q View /tmp/prompt; then
            pgilog "User wants to \"$(cat /tmp/prompt)\"."
            # kludgey!
            DISK=$(sed 's/View partition table of //' < /tmp/prompt)
            display_partition_table $DISK
        else
            break
        fi
    done
    # for /etc/fstab, GRUB's menu.lst, and other purposes
    ROOTPART=$(cat /tmp/prompt)
    pgilog "User said \"$ROOTPART\" is the root filesystem."

    if ! check_partition $ROOTPART; then
        pgilog "Prompting user that $ROOTPART is not formatted."
        $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Disk Partition Not Formatted" --msgbox \
            "The partition $ROOTPART cannot be used as the root filesystem because it is not formatted.\n\nThe disk partitioning procedure will restart so that you may correct any errors." 9 70
        # no need to check for cancellation, we're going back to the top
        continue
    fi
    MNTPNTS="/ $ROOTPART ext2"
    # for grub-install
    ROOTDISK=$(echo $ROOTPART | sed 's/[[:digit:]]*$//')
    pgilog "Using \"$ROOTDISK\" as the root disk."

    # eliminate this partition from future choices
    PARTITION_LIST=$(echo "$PARTITION_LIST" | grep -v ^$ROOTPART\$)
    pgilog "\$PARTITION_LIST is now:"
    pgilog "$PARTITION_LIST"

    # are there any partitions left? if so, prompt for a mount point on each
    if [ -n "$PARTITION_LIST" ]; then
        MOUNTPOINT_LIST=$(printf '/home\n/tmp\n/usr\n/usr/local\n/var\n/var/mail\n/var/spool\n/var/tmp\nswap\n/boot/efi\nNONE')
        for PARTITION in $PARTITION_LIST; do
            # build list of partitions available for selection
            DIALOG_MENU_LIST=
            for  MOUNTPOINT in $MOUNTPOINT_LIST; do
                if [ -n "$DIALOG_MENU_LIST" ]; then
                    DIALOG_MENU_LIST="$DIALOG_MENU_LIST $MOUNTPOINT ''"
                else
                    DIALOG_MENU_LIST="$MOUNTPOINT ''"
                fi
            done
            # build list of disks available for viewing
            DISK_LIST_VIEW_MENU=
            for DISK in $DISK_LIST; do
                if [ -n "$DISK_LIST_VIEW_MENU" ]; then
                    DISK_LIST_VIEW_MENU="$DISK_LIST_VIEW_MENU 'View partition table of $DISK' ''"
                else
                    DISK_LIST_VIEW_MENU="'View partition table of $DISK' ''"
                fi
            done
            while :; do
                pgilog "Prompting user for mount point of $PARTITION."
                eval $DIALOG --no-cancel --cr-wrap \
                    --backtitle \"PGI Debian Installer\" \
                    --title \"Select Mount Point for $PARTITION\" \
                    --menu \
                    \"Please select a mount point for $PARTITION.  Choose from any of the mount points below.  You may select 'swap' to set up supplementary swap partitions, or 'NONE' to have Debian GNU/Linux ignore the partition completely.\" 19 70 9 \
                    $DIALOG_MENU_LIST \
                    2> /tmp/prompt
                # check for cancellation
                if [ $? -ne 0 ]; then
                    CANCEL=yes
                    break 2
                fi
                # check for partition viewing
                if grep -q View /tmp/prompt; then
                    pgilog "User wants to \"$(cat /tmp/prompt)\"."
                    # kludgey!
                    DISK=$(sed 's/View partition table of //' < /tmp/prompt)
                    display_partition_table $DISK
                else
                    break
                fi
            done
            SELECTED_MOUNTPOINT=$(cat /tmp/prompt)
            if ! check_partition $PARTITION; then
                pgilog "Prompting user that $PARTITION is not formatted."
                $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
                    --title "Disk Partition Not Formatted" --msgbox \
                    "The partition $PARTITION cannot be used as the $SELECTED_MOUNTPOINT mount point because it is not formatted.\n\nThe disk partitioning procedure will restart so that you may correct any errors." 9 70
                # no need to check for cancellation, we're going back to the top
                continue 2
            fi
            pgilog "User chose mount point of \"$SELECTED_MOUNTPOINT\" for \"$PARTITION\"."
            case "$SELECTED_MOUNTPOINT" in
            NONE)
                ;;
            swap)
                SWAPPART="$SWAPPART $SELECTED_MOUNTPOINT"
                ;;
            *)
                MNTPNTS="$MNTPNTS $SELECTED_MOUNTPOINT $PARTITION $PARTTYPE"
                # eliminate this mount point from future choices
                MOUNTPOINT_LIST=$(echo "$MOUNTPOINT_LIST" | grep -v ^$SELECTED_MOUNTPOINT$)
                ;;
            esac
            if [ "$SELECTED_MOUNTPOINT" = "/boot/efi" ]; then
                EFIPART="$SELECTED_MOUNTPOINT"
            fi
        done
    fi

    # XXX: maybe also report partition type.  Maybe.
    BASIC_TEXT=$(printf "You have selected $ROOTPART as your root filesystem.\\\n\\\nYour swap partition(s) are: $SWAPPART")
    EXTRA_TEXT=
    if [ -n "$MNTPNTS" ]; then
        set -- $MNTPNTS
        while [ -n "$1" ]; do
            if [ "$1" != "/" ]; then
                if [ -z "$EXTRA_TEXT" ]; then
                    EXTRA_TEXT="\n\nYou also have specified mount points for the following partitions:\n\n"
                fi
                EXTRA_TEXT=$(printf "${EXTRA_TEXT}$1\t$2\\\n")
            fi
            shift 3
        done
    fi

    pgilog "Prompting user to proceed with installation."
    # if there is a lot of text to display, use a separate message box for the
    # partitioning report
    if [ $(echo "$EXTRA_TEXT" | wc -l) -le 6 ]; then
        $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Proceed with Installation?" --menu \
            "$BASIC_TEXT$EXTRA_TEXT" 19 71 3 \
            "proceed" "Continue installation of Debian" \
            "re-partition" "Change partitioning, swap devices, and mount points" \
            "cancel" "Cancel installation of Debian" \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
    else
        $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Disk Partitioning Report" --msgbox \
            "$BASIC_TEXT$EXTRA_TEXT" 19 70
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
        $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Proceed with Installation?" --menu \
            "Would you like to continue with the installation process?\n\nThis is your last chance to cancel before irreversible changes are made to your system." 13 71 3 \
            "proceed" "Continue installation of Debian" \
            "re-partition" "Change partitioning, swap devices, and mount points" \
            "cancel" "Cancel installation of Debian" \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
    fi

    CHOICE=$(cat /tmp/prompt)
    pgilog "User chose to \"$CHOICE\"."

    case "$CHOICE" in
    proceed)
        USER_HAPPY=yes
        ;;
    re-partition)
        ;;
    cancel)
        CANCEL=yes
        ;;
    esac
done

if [ -z "$CANCEL" ]; then
    # install the packages
    ( if python $LIVE/share/installer/setup-base-text.py --target $TARGET \
        --mirror $MIRROR --suite $SUITE \
        --extra-packages "$EXTRA_PACKAGES" \
        --swaps $SWAPPART $MNTPNTS 2>&1 | tee -a $LOGFILE; then
          echo "Installation successful.  Press enter to continue." >> $LOGFILE
      else
          CANCEL=yes
          echo "Installation failed.  Press enter to cancel." >> $LOGFILE
      fi ) &

    $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
      --title "Running debootstrap..." \
      --tailbox $LOGFILE 19 70
fi

if [ -z "$CANCEL" ]; then
    # XXX: arch-specific tests shouldn't be done here
    if [ "$ARCH" != "ia64" ]; then
        # install the boot loader
        $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Select Desired Boot Method" --menu \
            "You have the option of installing the GNU GRUB boot loader to the master boot record of your primary disk, or to a partition on that disk.  Alternatively, you can skip the installation of GNU GRUB and use your own, alternative means of booting the system." 15 70 3 \
            "mbr" "Install GRUB to the master boot record" \
            "partition" "Install GRUB to the root partition" \
            "none" "Do not install the GRUB boot loader at all" \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
        CHOICE=$(cat /tmp/prompt)
        pgilog "User chose to install GRUB to \"$CHOICE\"."

        case "$CHOICE" in
            mbr|partition)
                USE_GRUB=yes
                ;;
            none)
                ;;
        esac

        if [ -n "$USE_GRUB" ]; then
            if [ "$CHOICE" = "mbr" ]; then
                pgilog "installing boot-loader to $ROOTDISK."
                python $LIVE/share/installer/setup-bootloader-text.py \
                    --root $ROOTPART --target $TARGET $ROOTDISK | tee -a $LOGFILE
            else
                pgilog "installing boot-loader to $ROOTPART."
                python $LIVE/share/installer/setup-bootloader-text.py \
                    --root $ROOTPART --target $TARGET $ROOTPART | tee -a $LOGFILE
            fi
        fi
    else
        python $LIVE/share/installer/setup-bootloader-text.py \
            --root $ROOTPART --target $TARGET $EFIPART | tee -a $LOGFILE
    fi

    # get congrat msg
    python $LIVE/share/installer/get-message.py finish | sed 's/"/\\"/g' \
        > /tmp/congrat-msg
    if [ ! -s /tmp/congrat-msg ]; then
        echo "Congratulations, the system packages have been installed.\n\nThe system will now restart, running your new Debian GNU/Linux installation." \
            > /tmp/congrat-msg
    fi

    # congratulations
    $DIALOG --cr-wrap --backtitle "PGI Debian Installer" \
        --title "System Installed" --textbox /tmp/congrat-msg 19 70
    # no need to check for cancellation on this dialog; it's a bit late
fi

# vim:ai:et:sts=4:sw=4:tw=0:
