/***************************************************************************
                          fftengine.cpp  -  description
                             -------------------
    begin                : Mon Oct 11 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>
#include "fftengine.h"

FftEngine::FftEngine()
{
   samples = 2048;       /* 1K, 2K */
   ffts = samples/2;     /* half of samples */
   delta = 64;           /*Offset in FFT - 64, 256 for 1K,2K fft */
   cnt = 0;
   calculateFlag = false;
   window( 20.0 );
}
FftEngine::~FftEngine(){
}


/**  */
void FftEngine::calc_power()
{
   int i, j;
   for (i=0, j=0; /*i<ffts-2*/ i < ffts - 1; /*i=i+2*/ i++, j++)
   {
      if( i != 0 && i != ffts - 1 )
         pwr[j] = sqr(buffer[i]) + sqr(buffer[i+1]);
      else
         pwr[j] = sqr (buffer[i == 0 ? 0 : 1]);
      //printf ("%d %f -- %d %f\n", j, pwr[j], j+1, pwr[j+1]);
      //printf ("%d %f %d %f\n", i, buffer[i], i+1, buffer[i+1]);
   }
}

/**  */
void FftEngine::getmax()
{
   int i;

   for (i=0; i<ffts-1; /*i=i+2*/ i++)
   {
      if (pwr[i] > max)
      {
         max = pwr[i];
         maxi = i;
      }
   }
   //printf ("%f @ %d\n", max, maxi);
}

/**  */
void FftEngine::scale_power( int limit )
{
   int i;

   for (i=0; i < ffts - 1; i++)
   {
      values[i] = (int)(( 10.0 * log10( pwr[i] ) + 27.1) *.9);
      //values[i] = (int)( 10 * log10( pwr[i] ) + 40);
      //printf ("%d %d\n", i, values[i]);
   }
}

/*
 *  Generate a window function for the puspose of reducing spectral leakage
 *  Code borrowed from XAnalyzer
 */

void FftEngine::window( float alpha )
{
  // normalised to 1

  float sum = 0.0;
  for( int i = 0; i < MAX_SAMPLES; i++ ) {
    float x = (float)( i - MAX_SAMPLES / 2 ) / MAX_SAMPLES;
    value_e[i] = exp( - alpha * sqr( x ) );
    sum += value_e[i];
  }
  sum /= MAX_SAMPLES;

  for( int i = 0; i < MAX_SAMPLES; i++ )
    value_e[i] /= sum;
}
/*
 *  The following are from:
 *  XAnalyser, frequence spectrum analyser for X Windows
 *  Copyright (C) 1998 Arvin Schnell
 */
void FftEngine::fft(float data[], int N, int isign)
{
  int n = N << 1;
  int i, j, m;

  /* bit reversal section */

  j = 0;
  for( i = 0; i < n; i += 2 ) {
    if( j > i ) {
      swap( data[j], data[i] );
      swap( data[j+1], data[i+1] );
    }
    m = N;
    while( m >= 2 && j >= m ) {
      j -= m;
      m >>= 1;
    }
    j += m;
  }

  /* Daniel-Lanczos section */

  long double theta, wr, wpr, wpi, wi, wtemp;
  float tempr, tempi;
  for( int mmax = 2; n > mmax; ) {
    int istep = mmax << 1;
    theta = isign * ( 2.0*M_PI / mmax );
    wpr = -2.0 *  sqr( sin( 0.5*theta ) );
    wpi = sin( theta );
    wr = 1.0;
    wi = 0.0;
    for( m = 0; m < mmax; m += 2 ) {
      for( i = m; i < n; i += istep ) {
        j = i + mmax;
        tempr = wr*data[j] - wi*data[j+1];
        tempi = wr*data[j+1] + wi*data[j];
        data[j] = data[i] - tempr;
        data[j+1] = data[i+1] - tempi;
        data[i] += tempr;
        data[i+1] += tempi;
      }
      wr = (wtemp=wr)*wpr - wi*wpi + wr;
      wi = wi*wpr + wtemp*wpi + wi;
    }
    mmax = istep;
  }

  /* normalisation section */

  long double sqrtN = sqrt( N );
  for( i = 0; i < n; i++ )
    data[i] /= sqrtN;
}

/**  main section */
void FftEngine::rfft(float data[], int N, int isign)
{
  long double c1 = 0.5, c2;
  long double theta = M_PI / (double)( N >> 1 );

  if( isign == 1 ) {
    c2 = -0.5;
    fft( data, N >> 1, +1 );
  } else {
    c2 = +0.5;
    theta = -theta;
  }

  long double wpr = -2.0 * sqr( sin( 0.5*theta ) );
  long double wpi = sin( theta );
  long double wr = 1.0 + wpr;
  long double wi = wpi;
  long double wtemp;

  int i, i1, i2, i3, i4;
  float h1r, h1i, h2r, h2i;
  for( i = 1; i < N >> 2; i++ ) {
    i1 = i+i; i2 = i1+1; i3 = N-i1; i4 = i3+1;
    h1r =  c1 * (data[i1] + data[i3]);
    h1i =  c1 * (data[i2] - data[i4]);
    h2r = -c2 * (data[i2] + data[i4]);
    h2i =  c2 * (data[i1] - data[i3]);
    data[i1] =  h1r + wr*h2r - wi*h2i;
    data[i2] =  h1i + wr*h2i + wi*h2r;
    data[i3] =  h1r - wr*h2r + wi*h2i;
    data[i4] = -h1i + wr*h2i + wi*h2r;
    wr = (wtemp=wr)*wpr - wi*wpi + wr;
    wi = wi*wpr + wtemp*wpi + wi;
  }

  if( isign == 1 ) {
    data[0] = (h1r=data[0]) + data[1];
    data[1] = h1r-data[1];
  } else {
    data[0] = c1*( (h1r=data[0]) + data[1] );
    data[1] = c1*( h1r-data[1] );
    fft( data, N >> 1, -1 );
  }

  /* normalisation section */

  if( isign == 1 )
    for( int k = 0; k < N; k++ )
      data[k] /= M_SQRT2;
  else
    for( int k = 0; k < N; k++ )
      data[k] *= M_SQRT2;
}

void FftEngine::setCalculateFlag()
{
    calculateFlag = true;
}











