# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

import Image
import cStringIO

class Counter:
    bytes = 0
    def write(self, data):
        self.bytes += len(data)

def get_size(im, format, **options):
    try:
        out = Counter()
        im.save(out, format, **options)
        return out.bytes
    except AttributeError:
        # fall back on full in-memory compression
        out = cStringIO.StringIO()
        im.save(out, format, **options)
        return len(out.getvalue())
    
def get_quality(im, size, format, down=0,up=100, delta=1000,options = {}):
    q = options['quality']  = (down+up)/2
    if q==down or q==up: return q
    s   = get_size(im, format, **options)
    if abs(s-size)<delta:
        return q
    elif s > size:
        return get_quality(im, size,format,down,up=q,options=options)
    else:
        return get_quality(im, size,format,down=q,up=up,options=options)
    
def test():
    filename    = '/home/stani/sync/Desktop/IMGA3345.JPG'
    im  = Image.open(filename)
    q   = get_quality(im,300000,"JPEG")
    im.save(filename.replace('.jpg','_sized.jpg'))
    
if __name__ == '__main__':
    test()