#ifndef PRINTERQUEUES_H
#define PRINTERQUEUES_H

#ifdef __cplusplus
        extern "C" {
#endif

struct pqprivate;

struct pqinfo
{
	void (*Dispose)(struct pqinfo *pq);

	/* For querying the available printer queues */

	int (*GetPrinterCount)(struct pqinfo *pq);
	char *(*GetPrinterName)(struct pqinfo *pq,int index);

	/* Select a printer queue with this function */

	void (*SetPrinterQueue)(struct pqinfo *pq,const char *queue);

	/* Returns the gutenprint driver associated with
	   the queue, or NULL if unknown.  */

	char *(*GetDriver)(struct pqinfo *pq);
	
	/* Returns the PPD associated with the the queue,
	   or NULL if unknown or not applicable. */

	char *(*GetPPD)(struct pqinfo *pq);

	/* Functions to delineate the beginning and end of pages and jobs. */
	int (*InitialiseJob)(struct pqinfo *pq);
	void (*InitialisePage)(struct pqinfo *pq);
	void (*EndPage)(struct pqinfo *pq);
	void (*EndJob)(struct pqinfo *pq);
	void (*CancelJob)(struct pqinfo *pq);

	/* Function to write data to the printer queue */
	int (*WriteData)(struct pqinfo *pq,const char *data,int bytecount);

	struct pqprivate *priv;
};

struct pqinfo *pqinfo_create();

#ifdef __cplusplus
    }
#endif

#endif
