<?php

// from html common in dcl http://dcl.sf.net Thanks Mike 

function GetHiddenVar($var, $val)
{
	return '<input type="hidden" name="' . $var . '" value="' . $val . '">';
}

function GetJSDateFormat()
{
	global $dcl_info;

	$calDateFormat = str_replace('m', 'MM', $dcl_info['DCL_DATE_FORMAT']);
	$calDateFormat = str_replace('d', 'DD', $calDateFormat);
	return str_replace('Y', 'yyyy', $calDateFormat);
}

function BeginChocoTable($lightColor = true, $width = '100%', $cellSpacing = 0, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}
	if ($lightColor == true)
		$bgColor = $lc;
	else
		$bgColor = $dc;

	print("<table border=\"0\" bgcolor=\"$bgColor\" ");
	if ($width != 0)
		print("width=\"$width\" ");
	print("cellspacing=\"$cellSpacing\" cellpadding=\"2\">");
}

function EndTable()
{
	print('</table>');
}

function PrintLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	print("<a class=\"$class\" href=\"$linkURL\" title=\"$rollover\">" ); 
	print($linkName) ;
	print('</a>&nbsp;');
}

function PrintLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	print(GetLinkSet($linkArray, $rolloverArray, $enclose, $dark, $printable));
}

function GetLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	$link = "<a class=\"$class\" href=\"$linkURL\" title=\"$rollover\">";
	$link .= $linkName;
	$link .= '</a>&nbsp;';

	return $link;
}

function GetLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	global $dcl_info;

	if (!is_array($linkArray) || !is_array($rolloverArray) || count($linkArray) < 1)
	{
			// Output _something_ in case we need to allow a TD or TH to background
			// fill properly.
		return '&nbsp';
	}

	$linkset = '';
	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">[</font>&nbsp;';

	while (list($linkName, $linkURL) = each($linkArray))
		$linkset .= GetLink($linkName, $rolloverArray[$linkName], $linkURL, $dark, $printable);

	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">]</font>';

	return $linkset;
}

function BeginChocoFont($dark = false, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}
	if ($dark == true)
		$fontColor = $dc;
	else
		$fontColor = $lc;

	print("<font color=\"$fontColor\">");
}

function EndFont()
{
	print('</font>');
}

function PrintWithChocoFont($thisString, $printable = false)
{
	print("<span class=\"highlight\">$thisString</span>");
}

function PrintArrayAsChocoTable($nameArray, $fieldArray, $title, $footer = '', $titleLinks = '', $printable=false)
{
	if (count($nameArray) < 1 || count($fieldArray) < 1 || !is_array($nameArray) || !is_array($fieldArray))
	{
		print('<center>');
		PrintWithChocoFont("STR_CMMN_ARRAYTABLEERR");
		printf("STR_CMMN_ARRAYTABLEERRHELP", $title);
		print('</center>');
		return;
	}
	print('<center>');
	BeginChocoTable(false, 0);
	print('<tr><th');
	if ($titleLinks != '')
		print(' align="left"');
	print('>');
	BeginChocoFont();
	print($title);
	if ($titleLinks != '')
		print('</th><th align="right">' . $titleLinks);
	EndFont();
	print('</th></tr><tr><td');
	if ($titleLinks != '')
		print(' colspan="2"');
	print('>');
	BeginChocoTable(false, '100%', 2);

	print('<tr>');
	for ($i = 0; $i < count($nameArray); $i++)
		PrintTH($nameArray[$i], true, $printable);
	print('</tr>');

	for ($i = 0; $i < count($fieldArray); $i++)
	{
		print('<tr>');
		for ($j = 0; $j < count($fieldArray[$i]); $j++)
		{
			$k = $fieldArray[$i][$j];
			$align = '';
                // Right justify all numbers (looks really swell)
			if (is_double($k) || is_long($k))
				$align = 'right';
			PrintTD($k, true, $align, $printable);
		}
		print('</tr>');
	}
	EndTable();
	print('</td></tr>');
	if ($footer != '')
	{
		print('<tr><th>');
		BeginChocoFont();
		print($footer);
		EndFont();
		print('</th></tr>');
	}
	EndTable();
	print('</center>');
}

function PrintTH($thisString, $choco = false, $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}

	print('<th');
	if ($choco)
		print(" bgcolor=\"$lc\"");
	print('>');
	if ($choco)
		print("<font color=\"$dc\">");
	if (trim($thisString) == '')
		print('&nbsp;');
	else
		print($thisString);
	if ($choco)
		EndFont();
	print('</th>');
}

function PrintTD($thisString, $choco = false, $align = '', $printable = false)
{
	global $dcl_info;

	if ($printable)
	{
		$lc = '#ffffff';
		$dc = '#000000';
	}
	else
	{
		$lc = $dcl_info['DCL_COLOR_LIGHT'];
		$dc = $dcl_info['DCL_COLOR_DARK'];
	}

	print('<td');
	if ($choco)
		print(" bgcolor=\"$lc\"");
	if ($align != '')
		print(' align="' . $align . '"');
	print('>');
	if (trim($thisString) == '')
		print('&nbsp;');
	else
		print($thisString);
	print('</td>');
}

function FormatPhone($phone)
{
	$retVal = trim($phone);
	if (strlen($retVal) == 7)
	{
		$retVal = substr($phone, 0, 3) . '-' . substr($phone, 3);
	}
	if (strlen($retVal) == 10)
	{
		$retVal = '(' . substr($phone, 0, 3) . ') ' . substr($phone, 3, 3) . '-' . substr($phone, 6);
	}

	return $retVal;
}

function GetCalendarLink($linkTo)
{
	$link = '<a href="javascript:doNothing()" ';
	$link .= 'onclick="setDateField(' . $linkTo . '); ';
	$link .= 'top.newWin = window.open(\'calendar.html\',\'cal\',\'dependent=yes,width=210,height=230,screenX=200,screenY=300,titlebar=yes\')">';
	$link .= '<img src="img/calendar.gif" border="0"></a>';

	return $link;
}

function CreateCalendarLink($linkTo)
{
	print(GetCalendarLink($linkTo));
}

function ShowDeleteYesNo($title, $action, $id, $name, $canBeDeactivated = true, $idfield = 'id')
{
	global $dcl_info;

	print('<center>');
	BeginChocoTable(false, 0);
	print('<tr><th>');
	BeginChocoFont();
	printf("STR_CMMN_DELETEITEM", $title);
	EndFont();
	print('</th></tr><tr><td>');
	BeginChocoTable();
	print('<tr><td bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
	print('<form method="post" action="index.php">');
	print("<input type=\"hidden\" name=\"menuAction\" value=\"$action\">");
	print("<input type=\"hidden\" name=\"$idfield\" value=\"$id\">");
	printf("STR_CMMN_DELETECONFIRM", $title, $name);
	if ($canBeDeactivated)
		print('<br>' . "STR_CMMN_DEACTIVATENOTE");
	print('<br></td></tr><tr><td align="center" bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
	printf('<input type="submit" value="%s">', "STR_CMMN_YES");
	printf('<input type="button" value="%s" onclick="history.back();">', "STR_CMMN_NO");
	print('</form>');
	print('</td></tr>');
	EndTable();
	print('</td></tr>');
	EndTable();
	print('</center>');
}

function GetYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	$str = "<select name=\"$cbName";
	if ($size > 0)
		$str .= '[]" multiple size=' . $size;
	else
		$str .= '"';
	$str .= '>';
	if ($size == 0 && $noneOption == true)
		$str .= sprintf('<option value="?">%s', "STR_CMMN_SELECTONE");

	$str .= '<option value="Y"';
	if ('Y' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', "STR_CMMN_YES");

	$str .= '<option value="N"';
	if ('N' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', "STR_CMMN_NO");

	$str .= '</select>';

	return $str;
}

function CreateYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	print GetYesNoCombo($default, $cbName, $size, $noneOption);
}


?>
