<?php

/**
 * Displays an article and associated comments.
 *
 * This file pulls the data associated with article sid from the mysql 
 * database and builds the "box" containing this data. It also shows 
 * the comments if any exist and if the site admin even wants them to 
 * be shown.
 *
 * @module article
 * @modulegroup content_handling
 * @package phpWebSite
 */

$phpgw_info['flags']['currentapp']='wcm';
$phpgw_info['flags']['noheader']=True;
include("../header.inc.php");
global $phpgw,$phpgw_info;

if(!isset($mainfile))
{
	/* Defines core functions. */
	include("mainfile.php");
}

/* Bail out if called incorrectly */
if(!isset($sid) && !isset($tid)) exit();

/* Global configuration data */
include("config.php");

if ($op == "Print")
{
	$phpgw->db->query("select aid, time, title, hometext, bodytext, topic, informant, notes FROM wcm_stories where sid=$sid");
	$phpgw->db->next_record();
	$aid = $phpgw->db->f("aid");
	$time = $phpgw->db->f("time");
	$title = $phpgw->db->f("title");
	$hometext = $phpgw->db->f("hometext");
	$bodytext = $phpgw->db->f("bodytext");
	$topic = $phpgw->db->f("topic");
	$informant = $phpgw->db->f("informant");
	$notes = $phpgw->db->f("notes");
	$phpgw->db->query("UPDATE wcm_stories SET counter=counter+1 where sid=$sid");

	formatTimestamp($time);
	
	$hometext = stripslashes(str_replace ("\n", "<br />", $hometext));
	$bodytext = stripslashes(str_replace ("\n", "<br />", $bodytext));

	echo "
<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" 
\"DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">
<head>
<title>$sitename - $titletag</title>
</head>
<body>
<table width=\"640\" border=\"1\" cellSpacing=\"0\" cellPadding=\"20\" bgColor=\"#ffffff\" bordercolorlight=\"#000000\" bordercolor=\"#000000\" bordercolordark=\"#000000\">
<tr><td>
	<p align=\"right\"><font face=\"Arial\" size=\"2\">$sitename</font></p>
	<center><font face=\"Arial\" size=\"+3\"><b>$title</b></font><br />
	<font face=\"Arial\" size=\"1\">" . lang("By") . " $aid - " . lang("Date") . ": $time</font></center>
	<br /><br />
	<font face=\"Arial\" size=\"2\"><p align=\"justify\">$hometext</p>
	<p align=\"justify\">$bodytext</p>
	<hr noshade><br /><center>
	" . lang("This story was printed from") . " $sitename<br />
	<a href=\"$nuke_url\">$nuke_url</a></br /><br />
	" . lang("The URL for this story is") . ":<br />
	<a href=\"$nuke_url/article.php?sid=$sid\">$nuke_url/article.php?sid=$sid</a></br /><br />
	</center></font>
</td></tr>
</table>
</body>
</html>
	";

}
else
{
	$phpgw->common->phpgw_header();
	/* Generates page header */
	include ("header.php");

	if($save)
	{
		cookiedecode($user);
		$phpgw->db->query("update wcm_users set umode='$mode', uorder='$order', thold='$thold' where uid='$cookie[0]'");
		getusrinfo($user);
		$info = base64_encode("$userinfo[uid]:$userinfo[uname]:$userinfo[pass]:$userinfo[storynum]:$userinfo[umode]:$userinfo[uorder]:$userinfo[thold]:$userinfo[noscore]");
		setcookie("user","$info",time()+$cookieusrtime);
	}
	
	if($op == "Reply") $phpgw->redirect($phpgw->link('comments.php',"op=Reply&pid=0&sid=$sid&mode=$mode&order=$order&thold=$thold"));
	
	$phpgw->db->query("select aid, time, title, hometext, bodytext, topic, informant, notes FROM wcm_stories where sid=$sid");
	$phpgw->db->next_record();
	$aid=$phpgw->db->f("aid");
	$time=$phpgw->db->f("time");
	$title=$phpgw->db->f("title");
	$hometext=$phpgw->db->f("hometext");
	$bodytext=$phpgw->db->f("bodytext");
	$topic=$phpgw->db->f("topic");
	$informant=$phpgw->db->f("informant");
	$notes=$phpgw->db->f("notes");
	$phpgw->db->query("UPDATE wcm_stories SET counter=counter+1 where sid=$sid");
	
	formatTimestamp($time);
	
	$hometext = stripslashes(str_replace ("\n", "<br />", $hometext));
	$bodytext = stripslashes(str_replace ("\n", "<br />", $bodytext));
	$notes = stripslashes($notes);
	
	if($bodytext == "") $bodytext = "$hometext $notes";
	else $bodytext = "$hometext $notes<br />$bodytext";
	
	if($informant == "") $informant = $anonymous;
	
	getTopics($sid);
	themearticle($aid, $informant, $datetime, $title, $bodytext, $topic, $topicname, $topicimage, $topictext);
	
	if($show_comments)
	echo "<div align=\"center\"><a href=\"comments.php?op=Reply&amp;pid=0&amp;sid=$sid\">Send Your Comment</a></div><br />\n";
	
	cookiedecode($user);
	
	if($mode != "nocomments" && $show_comments)
	{
	  /* Handles comments corresponding to article */
	  include("comments.php");
	}
	
	/* Generates page footer */
	include ("footer.php");
}
?>
