<?php
/**
 * Allows to send an article or the URL of the site to a friend.
 *
 * Allows to send the link of an article or the URL of the site to a friend.
 * Currently does not check for input (bad email, ...). Hopefully will be
 * fixed in next versions.
 *
 * @module
 * @modulegroup
 * @package phpWebSite
 */

include("open_session.php");

if(!isset($mainfile))
{
	/* Defines core functions. */
	include("mainfile.php");
}

/* Global configuration data */
include("config.php");

/* Generates page header */
include ("header.php");

function FriendSend($sid, $yname, $ymail, $fname, $fmail, $comments, $box_stuff)
{
	global $phpgw;
	if (!ereg("^.+@.+\\..+$", $ymail))
	{
		$ymail = "";
	}
	if (!ereg("^.+@.+\\..+$", $fmail))
	{
		$fmail = "";
	}

	global $user, $cookie;
	if(!isset($sid))
	{
		exit();
	}
	$phpgw->db->query("select title from wcm_stories where sid=$sid");
	$phpgw->db->next_record();
	$title=$phpgw->db->f("title");
	$box_stuff .= "
<br />
TRANSLATE[[You will send the story]] <b>" . check_html($title, "nohtml") . "</b> TRANSLATE[[to the following person]]:<br /><br />
<form action=\"friend.php\" method=\"post\">
<input type=\"hidden\" name=\"sid\" value=\"$sid\" />
	";

	if ($user)
	{
		cookiedecode($user);
		$phpgw->db->query("select name, email from wcm_users where uname='$cookie[1]'");
		$phpgw->db->next_record();
		$yname=$phpgw->db->f("name");
		$ymail=$phpgw->db->f("email");
	}
	$box_stuff .= "
<table>
<tr>
	<td><b>TRANSLATE[[Your name]]:*</b></td>
	<td><input type=\"text\" name=\"yname\" value=\"$yname\" /></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your email]]:*</b></td>
	<td><input type=\"text\" name=\"ymail\" value=\"$ymail\" /></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your friend name]]:*</b></td>
	<td><input type=\"text\" name=\"fname\" value=\"$fname\" /></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your friend email]]:*</b></td>
	<td><input type=\"text\" name=\"fmail\" value=\"$fmail\" /></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td colspan=\"2\"><b>TRANSLATE[[Your comments]]:</b></td>
</tr>
<tr>
	<td colspan=\"2\"><textarea name=\"comments\" rows=\"7\" cols=\"50\">$comments</textarea></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td><input type=\"hidden\" name=\"op\" value=\"SendStory\" /><input type=\"submit\" value=\"TRANSLATE[[Send]]\" /></td>
	<td></td>
</tr>
</table>
</form>
	";

	themesidebox("TRANSLATE[[Send a story to a friend]]", $box_stuff);

	/* Generates page footer */
	include ("footer.php");
}


function SendStory($sid, $yname, $ymail, $fname, $fmail, $comments)
{
	global $sitename, $nuke_url;
	global $phpgw;

	if (!$yname=="" && !$ymail=="" && ereg("^.+@.+\\..+$", $ymail) && !$fname=="" && !$fmail=="" && ereg("^.+@.+\\..+$", $fmail))
	{
		$phpgw->db->query("select title, time, topic from wcm_stories where sid=$sid");
		$phpgw->db->next_record();
		$title=$phpgw->db->f("title");
		$time=$phpgw->db->f("time");
		$topic=$phpgw->db->f("topic");

		$phpgw->db->query("select topictext from wcm_topics where topicid=$topic");
		$phpgw->db->next_record();
		$topictext=$phpgw->db->f("topictext");

		$subject = "TRANSLATE[[Interesting article at]] $sitename";
		if ($comments != "")
		{
			$message = "TRANSLATE[[Hello]] $fname:\n\nTRANSLATE[[Your friend]] $yname TRANSLATE[[considered the following article interesting and wanted to send it to you.]]\n\n\nTRANSLATE[[Title]]: " . check_html($title, "nohtml") . "\nTRANSLATE[[Date]]: $time\nTRANSLATE[[Topic]]: $topictext\nURL: $nuke_url/article.php?sid=$sid\n\n$yname TRANSLATE[[made the following comments]]: $comments\n\nTRANSLATE[[You can read other interesting articles at]] $sitename\n$nuke_url";
		}
		else
		{
			$message = "TRANSLATE[[Hello]] $fname:\n\nTRANSLATE[[Your friend]] $yname TRANSLATE[[considered the following article interesting and wanted to send it to you.]]\n\n\nTRANSLATE[[Title]]: " . check_html($title, "nohtml") . "\nTRANSLATE[[Date]]: $time\nTRANSLATE[[Topic]]: $topictext\nURL: $nuke_url/article.php?sid=$sid\n\nTRANSLATE[[You can read other interesting articles at]] $sitename\n$nuke_url";
		}
		mail($fmail, $subject, $message, "From: \"$yname\" <$ymail>\nX-Mailer: PHP/" . phpversion());
		$title = urlencode($title);
		$fname = urlencode($fname);
		StorySent($title,$fname);
	}
	else
	{
		FriendSend($sid, $yname, $ymail, $fname, $fmail, $comments, "<center><span class=\"onebiggerred\">TRANSLATE[[The fields marked with a * are mandatory]]</span></center>");
	}
}


function StorySent($title, $fname)
{
	$title = urldecode($title);
	$fname = urldecode($fname);

	$box_stuff = "TRANSLATE[[The story]] <b>" . check_html($title, "nohtml") . "</b> TRANSLATE[[has been successfully sent to]] $fname...<br /><br />TRANSLATE[[Thanks]]!<br />";
	themesidebox("TRANSLATE[[Story sent]]", $box_stuff);

	/* Generates page footer */
	include ("footer.php");
}


function RecommendSite($yname, $ymail, $fname, $fmail, $comments, $box_stuff)
{
	global $phpgw;
	if (!ereg("^.+@.+\\..+$", $ymail))
	{
		$ymail = "";
	}
	if (!ereg("^.+@.+\\..+$", $fmail))
	{
		$fmail = "";
	}

	global $user, $cookie;
	$box_stuff .= "
<br />
<form action=\"friend.php\" method=\"post\">
<input type=\"hidden\" name=\"op\" value=\"SendSite\" />
	";

	if ($user)
	{
		cookiedecode($user);
		$phpgw->db->query("select name, email from wcm_users where uname='$cookie[1]'");
		$phpgw->db->next_record();
		$yname=$phpgw->db->f("name");
		$ymail=$phpgw->db->f("email");
	}

	$box_stuff .= "
<table>
<tr>
	<td><b>TRANSLATE[[Your name]]:*</b></td>
	<td><input type=\"text\" name=\"yname\" value=\"$yname\" /></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your email]]:*</b></td>
	<td><input type=\"text\" name=\"ymail\" value=\"$ymail\" /></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your friend name]]:*</b></td>
	<td><input type=\"text\" name=\"fname\" value=\"$fname\" /></td>
</tr>
<tr>
	<td><b>TRANSLATE[[Your friend email]]:*</b></td>
	<td><input type=\"text\" name=\"fmail\" value=\"$fmail\" /></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td colspan=\"2\"><b>TRANSLATE[[Your comments]]:</b></td>
</tr>
<tr>
	<td colspan=\"2\"><textarea name=\"comments\" rows=\"7\" cols=\"50\">$comments</textarea></td>
</tr>
<tr>
	<td height=\"10\"></td>
	<td height=\"10\"></td>
</tr>
<tr>
	<td><input type=submit value=\"TRANSLATE[[Send]]\" /></td>
	<td></td>
</tr>
</table>
</form>
	";

	themesidebox("TRANSLATE[[Recommend this site to a friend]]", $box_stuff);

	/* Generates page footer */
	include ("footer.php");
}


function SendSite($yname, $ymail, $fname, $fmail, $comments)
{
	global $sitename, $titletag, $nuke_url;

	if (!$yname=="" && !$ymail=="" && ereg("^.+@.+\\..+$", $ymail) && !$fname=="" && !$fmail=="" && ereg("^.+@.+\\..+$", $fmail))
	{
		$subject = "TRANSLATE[[A friend recommends you to visit]] $sitename";
		if ($comments != "")
		{
			$message = "TRANSLATE[[Hello]] $fname:\n\nTRANSLATE[[Your friend]] $yname TRANSLATE[[recommends you to visit]] $sitename.\n\n\n$sitename\n$titletag\nURL: $nuke_url\n\n$yname TRANSLATE[[made the following comments]]: $comments\n\n";
		}
		else
		{
			$message = "TRANSLATE[[Hello]] $fname:\n\nTRANSLATE[[Your friend]] $yname TRANSLATE[[recommends you to visit]] $sitename.\n\n\n$sitename\n$titletag\nURL: $nuke_url\n\n";
		}
		mail($fmail, $subject, $message, "From: \"$yname\" <$ymail>\nX-Mailer: PHP/" . phpversion());
		SiteSent($fname);
	}
	else
	{
		RecommendSite($yname, $ymail, $fname, $fmail, $comments, "<center><span class=\"onebiggerred\">TRANSLATE[[The fields marked with a * are mandatory]]</span></center>");
	}
}


function SiteSent($fname)
{
	$box_stuff = "TRANSLATE[[The site URL was successfully sent to]] $fname...<br /><br />TRANSLATE[[Thanks]]!<br />";
	themesidebox("TRANSLATE[[URL sent]]", $box_stuff);

	/* Generates page footer */
	include ("footer.php");
}


switch($op)
{
    case "SendStory":
    SendStory($sid, $yname, $ymail, $fname, $fmail, $comments);
    break;

    case "SendSite":
    SendSite($yname, $ymail, $fname, $fmail, $comments);
    break;

    case "FriendSend":
    FriendSend($sid, "", "", "", "", "", "");
    break;

    default:
    RecommendSite("", "", "", "", "", "");
    break;
}

?>
