
// indices into processor definition arrays
//
#define PD_PGM_SIZEH	0		// size of the program space, in words
#define PD_PGM_SIZEL	1
								// 2-28: meaning unknown
#define PD_CFG_ADDRH	29		// address of the configuration bits
#define PD_CFG_ADDRL	30
								// 31: meaning unknown
#define PD_DATA_ADDRH	32		// address of data space? (always seems to be zero)
#define PD_DATA_ADDRL	33
#define PD_DATA_SIZEH	34		// EEPROM data space size, in bytes
#define PD_DATA_SIZEL	35
#define PD_CLK_ADDRH	36		// address of clock calibration space
#define PD_CLK_ADDRL	37
#define PD_CLK_SIZEH	38		// size of clock calibration space, in words
#define PD_CLK_SIZEL	39
								// 40-43: meaning unknown

#define PICDEV_DEFSIZE	44		// profile is 44 bytes long
#define PICDEV_DEFXSIZE	16		// extended profile is 16 bytes long

typedef struct
{
	const char *name;			// name of the device
	const UINT8 *def;			// definition (initialization) (always 44 bytes long)
	const UINT8 *defx;			// extended definition (initialization) (always 16 bytes long)
	const UINT16 cpbits;		// set of code protection bits in configuration word (0 = read protected)
	const UINT16 wdbit;			// watchdog enable bit in configuration word (1 = enabled)
} PIC_DEFINITION;


// return codes from blank check
//
#define BLANK_PGM	0x01		// 0 = program memory blank
#define BLANK_CFG	0x02		// 0 = configuration bits blank
#define BLANK_ID	0x04		// 0 = ID locations blank
#define BLANK_DATA	0x08		// 0 = EEPROM data blank

extern const PIC_DEFINITION *deviceList[];
