/* a simple prog to extract compression tables from jpeg files.
   tridge@samba.org
*/
#include "stdio.h"

int main(int argc, char *argv[])
{
	int c1, c2=0, i;
	while ((c1 = fgetc(stdin)) != EOF) {
		if (c2 == 0xff && c1 == 0xdb) {
			int len = (fgetc(stdin)<<8) | fgetc(stdin);
			printf("0xdbff, 0x%02x00, ", len);
			for (i=6;i<len+4;i+=2) {
				c1 = fgetc(stdin);
				c2 = fgetc(stdin);
				printf("0x%04x, ", (c2<<8)|c1);
				if (i % 16 == 0) printf("\n");
			}
			printf("\n\n");
			c1 = c2;
		}
		c2 = c1;
	}

	return 0;
}
