/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * GTK+ integration example
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#include <gtk/gtk.h>
#include <pgm/pgm.h>
#include <pgm/gtk/pgmgtk.h>

/* Key press handler */
static void
keypress_event_cb (PgmViewport *viewport,
                   PgmEventKey *event,
                   gpointer data)
{
  g_print ("Pigment has the keyboard focus\n");
}

/* Button press handler */
static void
button_clicked_cb (GtkButton *button,
                   gpointer data)
{
  g_print ("GTK+ button clicked\n");
}

/* Rotate the image */
static gboolean
update_pass_cb (PgmViewport *viewport,
                gpointer data)
{
  PgmDrawable *drawable = PGM_DRAWABLE (data);
  static gfloat angle = 0.0f;

  pgm_drawable_set_rotation_x (drawable, angle);
  pgm_drawable_set_rotation_y (drawable, angle);
  pgm_drawable_set_rotation_z (drawable, angle);

  angle += 0.03;

  return TRUE;
}

/* Start rotating the image when the pixbuf is loaded */
static void
pixbuf_loaded_cb (PgmImage *image,
                  gpointer data)
{
  PgmViewport *viewport = PGM_VIEWPORT (data);

  g_signal_connect (G_OBJECT (viewport), "update_pass",
                    G_CALLBACK (update_pass_cb), image);
}

int
main (int argc,
      char *argv[])
{
  GtkWidget *embed, *window, *vbox, *entry, *button;
  PgmViewport *viewport = NULL;
  PgmDrawable *img;
  PgmCanvas *canvas;

  /* Init */
  gtk_init (&argc, &argv);
  pgm_init (&argc, &argv);

  /* OpenGL viewport creation */
  pgm_viewport_factory_make ("opengl", &viewport);
  if (!viewport)
    {
      g_print ("Cannot create the 'opengl' viewport\n");
      return -1;
    }

  g_signal_connect (G_OBJECT (viewport), "key-press-event",
                    G_CALLBACK (keypress_event_cb), NULL);

  /* Scene setup */
  img = pgm_image_new_from_file ("examples/pictures/star.png", 0);
  g_signal_connect (G_OBJECT (img), "pixbuf-loaded",
                    G_CALLBACK (pixbuf_loaded_cb), viewport);
  pgm_drawable_set_size (img, 3.0f, 3.0f);
  pgm_drawable_set_position (img, 0.5f, 0.0f, 0.0f);
  pgm_drawable_set_bg_color (img, 1.0f, 1.0f, 1.0f, 0.0f);
  pgm_drawable_show (img);
  canvas = pgm_canvas_new ();
  pgm_canvas_add (canvas, PGM_DRAWABLE_MIDDLE, img);
  pgm_viewport_set_canvas (viewport, canvas);

  /* GTK+ window creation */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "GTK+ integration");
  gtk_window_resize (GTK_WINDOW (window), 400, 400);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);
  g_signal_connect (G_OBJECT (window), "delete-event",
                    G_CALLBACK (gtk_main_quit), NULL);

  /*Pigment GTK+ socket setup */
  embed = pgm_gtk_new ();
  pgm_gtk_set_viewport (PGM_GTK (embed), viewport);

  /* GTK+ interface creation */
  button = gtk_button_new_with_label ("GTK+ button");
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (button_clicked_cb), NULL);
  entry = gtk_entry_new ();
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), embed, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 0);
  gtk_widget_show_all (GTK_WIDGET (window));

  /* Start the mainloop */
  gtk_main ();

  /* Deinit */
  gst_object_unref (canvas);
  gst_object_unref (viewport);
  pgm_deinit ();

  return 0;
}
