/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

/*
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "pgmglesbackend.h"

GST_DEBUG_CATEGORY_STATIC (pgm_gles_backend_debug);
#define GST_CAT_DEFAULT pgm_gles_backend_debug

static GstObjectClass *parent_class = NULL;

/* GObject stuff */

PGM_DEFINE_DYNAMIC_TYPE_EXTENDED (PgmGlesBackend, pgm_gles_backend,
                                  GST_TYPE_OBJECT, G_TYPE_FLAG_ABSTRACT, {});

void
pgm_gles_backend_register (GTypeModule *module)
{
  pgm_gles_backend_register_type (module);
}

static void
pgm_gles_backend_dispose (GObject *object)
{
  GST_CALL_PARENT (G_OBJECT_CLASS, dispose, (object));
}

static void
pgm_gles_backend_class_init (PgmGlesBackendClass *klass)
{
  GObjectClass *gobject_class = (GObjectClass *) klass;

  GST_DEBUG_CATEGORY_INIT (pgm_gles_backend_debug, "pgm_gles_backend", 0,
                           "OpenGL ES plugin: PgmGlesBackend");

  parent_class = g_type_class_peek_parent (klass);

  gobject_class->dispose = GST_DEBUG_FUNCPTR (pgm_gles_backend_dispose);
}

static void
pgm_gles_backend_class_finalize (PgmGlesBackendClass *klass)
{
  return;
}

static void
pgm_gles_backend_init (PgmGlesBackend *glesbackend)
{
  GST_DEBUG_OBJECT (glesbackend, "init");

  glesbackend->context = NULL;
}

/* Public methods */

gboolean
pgm_gles_backend_create_window (PgmGlesBackend *glesbackend)
{
  PgmGlesBackendClass *klass;

  g_return_val_if_fail (PGM_IS_GLES_BACKEND (glesbackend), FALSE);

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->create_window)
    return klass->create_window (glesbackend);

  return FALSE;
}

gboolean
pgm_gles_backend_destroy_window (PgmGlesBackend *glesbackend)
{
  PgmGlesBackendClass *klass;

  g_return_val_if_fail (PGM_IS_GLES_BACKEND (glesbackend), FALSE);

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->destroy_window)
    return klass->destroy_window (glesbackend);

  return FALSE;
}

void
pgm_gles_backend_swap_buffers (PgmGlesBackend *glesbackend)
{
  PgmGlesBackendClass *klass;

  g_return_if_fail (PGM_IS_GLES_BACKEND (glesbackend));

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->swap_buffers)
    klass->swap_buffers (glesbackend);
}

gpointer
pgm_gles_backend_get_proc_address (PgmGlesBackend *glesbackend,
                                   const gchar *proc_name)
{
  PgmGlesBackendClass *klass;

  g_return_val_if_fail (PGM_IS_GLES_BACKEND (glesbackend), NULL);

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->get_proc_address)
    return klass->get_proc_address (glesbackend, proc_name);

  return NULL;
}

gboolean
pgm_gles_backend_set_visibility (PgmGlesBackend *glesbackend,
                                 gboolean visibility)
{
  PgmGlesBackendClass *klass;

  g_return_val_if_fail (PGM_IS_GLES_BACKEND (glesbackend), FALSE);

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->set_visibility)
    klass->set_visibility (glesbackend, visibility);

  return FALSE;
}

void
pgm_gles_backend_get_screen_size_mm (PgmGlesBackend *glesbackend,
                                     gint *width,
                                     gint *height)
{
  PgmGlesBackendClass *klass;

  g_return_if_fail (PGM_IS_GLES_BACKEND (glesbackend));

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->get_screen_size_mm)
    klass->get_screen_size_mm (glesbackend, width, height);
}

void
pgm_gles_backend_get_screen_resolution (PgmGlesBackend *glesbackend,
                                        gint *width,
                                        gint *height)
{
  PgmGlesBackendClass *klass;

  g_return_if_fail (PGM_IS_GLES_BACKEND (glesbackend));

  klass = PGM_GLES_BACKEND_GET_CLASS (glesbackend);

  if (klass->get_screen_resolution)
    klass->get_screen_resolution (glesbackend, width, height);
}
