sub parse_nessus_nsr_file($$$)
{
	my $nsr_file = shift; # .NSR file full path
	my $callback = shift; # function to call for each line
	my $callback_data = shift; # data to pass to this function

	if ( -f $nsr_file )
	{
		  # 2 sections in a NSR file : nessus configuration then scan results :
		my $in_DATA = 0;

		local *NSR;
		open( NSR, $nsr_file ) || die( "Can't open this nessus report : $!\n" );

		while( my $line = <NSR>)
		{
			  # Remove EOL :
			$line =~ s/\r|\n//g;

			  # If we are in the second part of the file :
			if ( $in_DATA )
			{
				  # www.leroutier.net|www (80/tcp)|10107|INFO|...
				my ( $host, $service_port_protocol, $nessus_id, $type, $text ) = split( /\|/, $line, 5 );

				if ( $nessus_id and $type and $text )
				{
					  # Handle INFO, REPORT or both :
					if ( $callback_data->{'nessus_allowed_types'}->{ $type } )
					{
						my ( $service, $port, $protocol ) = ( $service_port_protocol =~ m/^([^\s]+)\s+\((\d+)\/(.*)\)$/ );

						  # host could be either IP address or hostname :
						my $ip = '';
						$host =~ s/\s//g;
						if ( $host =~ m/[a-z]/i )
						{
							my $iaddr = gethostbyname( $host );
							if ( ! $iaddr ) {print "Can't resolve hostname '$Host'\n";exit();};
							$ip = inet_ntoa( $iaddr );
						}
						else
						{
							$ip = $host;
						}

						  # In .nsr files, ';' means EOL :
						$text =~ s/;/LINE_SEP/g;

						&{ $callback }( $callback_data, [ $ip, $port, $protocol, $type, $nessus_id, $text ] );
					}
				}
			}
			else
			{
				if ( $line =~ m/^\$DATA\$/ ) {$in_DATA = 1;};
			}
		}
	}
	else
	{
		print "NSR report not found : $nsr_file\n";
		return 0;
	}

	return 1;
}

sub add_nessus_entry_to_zone_port_list($$)
{
	my $data_ref = shift;
	my $report_line = shift;

	my ( $ip, $port, $protocol, $type, $nessus_id, $text ) = @{ $report_line };

	#

	my $line_zone = '';
	foreach my $zone ( sort keys %{ $data_ref->{'network_zone_list'} } )
	{
		if ( $ip =~ m/^$zone/ ) { $line_zone = $zone; };
	}

	  # Create empty structure at first use :
	if ( ! exists( $data_ref->{'nessus_port_list'}->{$line_zone} ) )
	{
		$data_ref->{'nessus_port_list'}->{$line_zone} = {
			'udp' => {},
			'tcp' => {}
		};
	}

	if ( ! exists( $data_ref->{'nessus_port_list'}->{$line_zone}->{$protocol}->{$port} ) )
	{
		$data_ref->{'nessus_port_list'}->{$line_zone}->{$protocol}->{$port} = {
			'additional_data' => [],
			'filter' => ''
		};
	}

	  # Add data to the port list :
	push @{ $data_ref->{'nessus_port_list'}->{$line_zone}->{$protocol}->{$port}->{'additional_data'} }, {
		'type' => $type,
		'nessus_id' => $nessus_id,
		'text' => $text
	};

	if ( ! $line_zone )
	{
		print "This host ($ip) does not match any defined zone, please fix this !!\n";
	}
}

sub add_nessus_entry_to_host_port_list($$)
{
	my $data_ref = shift;
	my $report_line = shift;

	my ( $ip, $port, $protocol, $type, $nessus_id, $text ) = @{ $report_line };

	  # Create empty structure at first use :
	if ( ! exists( $data_ref->{'nessus_port_list'}->{$ip} ) )
	{
		$data_ref->{'nessus_port_list'}->{$ip} = {
			'udp' => {},
			'tcp' => {}
		};
	}

	if ( ! exists( $data_ref->{'nessus_port_list'}->{$ip}->{$protocol}->{$port} ) )
	{
		$data_ref->{'nessus_port_list'}->{$ip}->{$protocol}->{$port} = {
			'additional_data' => [],
			'filter' => ''
		};
	}

	  # Add data to the port list :
	push @{ $data_ref->{'nessus_port_list'}->{$ip}->{$protocol}->{$port}->{'additional_data'} }, {
		'type' => $type,
		'nessus_id' => $nessus_id,
		'text' => $text
	};
}

sub create_filter_from_port_list($$$$)
{
	my $port_list = shift;
	my $match_type = shift;
	my $callback = shift;
	my $callback_data = shift;

	if ( $match_type eq 'ip' ) { $operator = '='; };
	if ( $match_type eq 'zone' ) { $operator = 'S'; };

	foreach my $ip ( sort keys %{ $port_list } )
	{
		if ( exists( $callback_data->{'callback_list'}->{'foreach_ip'} ) )
		{
			&{ $callback_data->{'callback_list'}->{'foreach_ip'} }( $callback_data, $ip );
		}

		my $Crit1 = Criteria->new();
		$Crit1->Table( 'Address' );
		$Crit1->Field( 'address' );
		$Crit1->Operator( $operator );
		$Crit1->Value( $ip );

		my $Crit1b = Criteria->new();
		$Crit1b->Table( 'Address' );
		$Crit1b->Field( 'parent_type' );
		$Crit1b->Operator( '=' );
		$Crit1b->Value( 'T' );

		foreach my $protocol ( keys %{ $port_list->{$ip} } )
		{
			if ( exists( $callback_data->{'callback_list'}->{'foreach_protocol'} ) )
			{
				&{ $callback_data->{'callback_list'}->{'foreach_protocol'} }( $callback_data, $ip, $protocol );
			}

			my $Crit2 = Criteria->new();
			$Crit2->Table( 'Service' );
			$Crit2->Field( 'protocol' );
			$Crit2->Operator( '=' );
			$Crit2->Value( $protocol );

			my $Crit2b = Criteria->new();
			$Crit2b->Table( 'Service' );
			$Crit2b->Field( 'parent_type' );
			$Crit2b->Operator( '=' );
			$Crit2b->Value( 'T' );

			foreach my $port ( sort {$a <=> $b} keys %{ $port_list->{$ip}->{$protocol} } )
			{
				if ( exists( $callback_data->{'callback_list'}->{'foreach_port'} ) )
				{
					&{ $callback_data->{'callback_list'}->{'foreach_port'} }( $callback_data, $ip, $protocol, $port );
				}

				my $Crit3 = Criteria->new();
				$Crit3->Table( 'Service' );
				$Crit3->Field( 'port' );
				$Crit3->Operator( '=' );
				$Crit3->Value( $port );

				  # Create an empty Filter :
				my $Filter = Filter->new();

				  # Add the 3 criteria to the filter :
				$Filter->Formula( 'A AND B AND C AND D AND E' );
				$Filter->add_Criteria ( $Crit1 );
				$Filter->add_Criteria ( $Crit1b );
				$Filter->add_Criteria ( $Crit2 );
				$Filter->add_Criteria ( $Crit2b );
				$Filter->add_Criteria ( $Crit3 );

				if ( $callback_data->{'filter_directory'} )
				{
					  # Set filter file name :
					$Filter->FileName( ( $callback_data->{'filter_directory'} )."/nessus-$ip-$protocol-$port.flt" );
				}

				  # Set filter comment :
				my @additional_data = ();
				foreach my $hash_ref ( @{ $port_list->{$ip}->{$protocol}->{$port}->{'additional_data'} } )
				{
					push @additional_data, join( 'ELT_SEP', ( $hash_ref->{'type'}, $hash_ref->{'nessus_id'}, $hash_ref->{'text'} ) );
				}
				$Filter->comment( join( 'SECTION_SEP', @additional_data ) );

				  # Associate new filter to its origin port :
				$port_list->{$ip}->{$protocol}->{$port}->{'filter'} = $Filter;

				  # Process this new filter :
				&{ $callback }( $callback_data, $Filter );
			}
		}
	}
}

1;
