/* 
 * Generate and parse HKP queries.
 * 
 * Non-standard extensions:  A time parameter can be given which 
 * is essentially an "if-modified-since".  The value is standard 
 * Unix time in decimal representation.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>

#include "hkp.h"
#include "uri.h"

void hkp_build_query (char *dest, size_t dlen,
		      const char *ksrv,
		      int port,
		      const char *qstr,
		      time_t t)
{
  char buff[1024];
  char uri[1024];
  char tmstr[32];

  if (!port)
    port = 11371;

  if (t > 0)
    snprintf (tmstr, sizeof (tmstr), "%d", t);

  snprintf (buff, sizeof (buff),
	    "/pks/lookup?search=%s&op=get%s%s",
	    qstr, t > 0 ? "&x-time=" : "",
	    t > 0 ? tmstr : "");

  uri_encode (uri, sizeof (uri), buff);

  snprintf (dest, dlen, "GET %s HTTP/1.0\r\nHost: %s:%d\r\n", uri, ksrv, port);
}

int hkp_parse_query (char *query,
		     char *search,
		     size_t slen,
		     time_t *tp)
{
  char *s, *t, *q;
  int res = 0;
  
  uri_decode (query, strlen (query) + 1, query);

  if (!(s = strtok (query, " \r\n")))
    return HKP_ERR;

  if (strcasecmp (s, "get"))
    return HKP_BADREQ;
  
  if (!(q = strtok (NULL, " \r\n")))
    return HKP_BADREQ;

  if (!(s = strtok (NULL, " \r\n")))
    res |= HKP_HTTP09;

  if (!(t = strchr (q, '?')))
    return HKP_BADREQ;

  s = strtok (t + 1, "&");
  while (s)
  {
    if ((t = strchr (s, '=')))
    {
      *t = '\0';
      
      if (!strcasecmp (s, "search"))
      {
	strncpy (search, t + 1, slen);
	search[slen - 1] = '\0';
	res |= HKP_SEARCH;
      }
      else if (!strcasecmp (s, "x-time") && tp)
      {
	*tp = atoi (t + 1);
	res |= HKP_TIME;
      }
      else if (!strcasecmp (s, "op") && !strcasecmp (t + 1, "get"))
	res |= HKP_OP_GET;
    }

    s = strtok (NULL, "&");
  }

  return res;
}

