/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_configure.cpp
 * \brief Implementation of the ptb::frame_configure class.
 * \author Julien Jorge
 */
#include "ptb/frame/frame_configure.hpp"

#include "ptb/game_variables.hpp"
#include "ptb/frame/frame_audio.hpp"
#include "ptb/frame/frame_game_options.hpp"
#include "ptb/frame/frame_password.hpp"
#include "ptb/frame/frame_player_controls.hpp"
#include "ptb/frame/frame_screen.hpp"
#include "ptb/frame/message_box.hpp"

#include <limits>
#include <libintl.h>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::frame_configure::frame_configure
( windows_layer* owning_layer )
  : menu_frame(owning_layer)
{
  create_controls();
} // frame_configure::frame_configure()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::frame_configure::validate() const
{
  unsigned int pos = get_menu().cursor_position();

  if ( pos == m_pos_first_player_controls )
    show_window( new frame_player_controls(m_owning_layer, 1) );
  else if ( pos == m_pos_second_player_controls )
    show_window( new frame_player_controls(m_owning_layer, 2) );
  else if ( pos == m_pos_game_options )
    show_window( new frame_game_options(m_owning_layer) );
  else if ( pos == m_pos_screen )
    show_window( new frame_screen(m_owning_layer) );
  else if ( pos == m_pos_audio )
    show_window( new frame_audio(m_owning_layer) );
  else if ( pos == m_pos_back )
    close_window();
  else if ( pos == m_pos_password )
    show_window( new frame_password(m_owning_layer) );
  else /* should not happend */
    show_window( new message_box(m_owning_layer, "not_available") );
} // frame_configure::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the static text components.
 */
void ptb::frame_configure::create_controls()
{
  std::vector<std::string> strings;
  unsigned int i(0);

  m_pos_first_player_controls = i++;
  m_pos_second_player_controls = i++;
  m_pos_game_options = i++;
  m_pos_screen = i++;
  m_pos_audio = i++;

  m_pos_password = std::numeric_limits<unsigned int>::max();

  strings.push_back( gettext("Player one's controls") );
  strings.push_back( gettext("Player two's controls") );
  strings.push_back( gettext("Game options") );
  strings.push_back( gettext("Screen") );
  strings.push_back( gettext("Audio") );

  if ( game_variables::get_password_menu_visibility() == true )
    {
      m_pos_password = i++;
      strings.push_back( gettext("Password") );
    }

  strings.push_back( gettext("Back") );
  m_pos_back = i++;
  get_menu().make( strings );

  set_size( get_menu().get_size() );
} // frame_configure::create_controls()
