/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file action_file_player_item.cpp
 * \brief Implementation of the ptb::action_file_player_item class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/action_file_player_item.hpp"

BASE_ITEM_EXPORT( action_file_player_item, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::action_file_player_item::action_file_player_item()
  : m_item(NULL)
{
  set_phantom(true);
  set_can_move_items(false);
  set_artificial(true);
} // action_file_player_item::action_file_player_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <std::string>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool ptb::action_file_player_item::set_string_field
( const std::string& name, const std::string& value )
{
  bool result(true);

  if ( name == "action_file_player_item.file_name" )
    set_action_file(bear::engine::resource_pool::get_instance(),value);
  else
    result = super::set_string_field( name, value );

  return result;
} // action_file_player_item::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c unsigned \c integer.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool ptb::action_file_player_item::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool result = true;

  if ( name == "action_file_player_item.player_index" )
    set_player_index(value);
  else
    result = super::set_u_integer_field(name,value);

  return result;
} // action_file_player_item:set_u_integer_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if the item is well initialized.
 */
bool ptb::action_file_player_item::is_valid() const
{
  return action_file_player::is_valid() && super::is_valid();
} // base_bonus::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the marionette state.
 * \param b The new state.
 */
void ptb::action_file_player_item::set_marionette( bool b )
{
  action_file_player::set_marionette(b);

  if ( b )
    m_item = get_player().get();
  else
    m_item = NULL;
} // action_file_player_item::set_marionette()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the items concerned by a progress/move of this one.
 * \param d (out) A list to which are added such items.
 */
void ptb::action_file_player_item::get_dependent_items
( std::list<physical_item*>& d ) const
{
  super::get_dependent_items(d);
  
  if ( m_item != NULL ) 
    d.push_front( m_item );
} // action_file_player_item::get_dependent_items()

/*----------------------------------------------------------------------------*/
/**
 * \brief Finish the action file.
 */
void ptb::action_file_player_item::finish()
{
  action_file_player::finish();
  
  toggle_off(this);
  kill();
} // action_file_player_item::finish()

/*----------------------------------------------------------------------------*/
/**
 * \brief Progress the item as it is turned on.
 * \param elapsed_time The duration of the activity.
 */
void ptb::action_file_player_item::progress_on
( bear::universe::time_type elapsed_time )
{
  progress_action_file(get_level_globals(),elapsed_time);

  if ( m_item != NULL )
    set_center_of_mass( m_item->get_center_of_mass() );
} // action_file_player_item::progress_on()
