/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "dt.h"


/* memory representing two arbitrary guest pages */
asm (
  ".comm   guest_page0,4096,4096 \n\t"
  ".comm   guest_page1,4096,4096 \n\t"
  );

unsigned char *gp0 = &guest_page0[0], *gp1 = &guest_page1[0];

Bit32u loop_count;

Bit8u guest_stack[GUEST_STACK_SIZE];

Bit32u jump_table[32];

Bit8u workload[] = {
#if DT_Workload==0
  /* nop */
  0x90
#else
  /*    pushl %ecx    */
  /*    movl $50, %ecx    */
  /* 0:           */
  /*    addl %eax, %ebx   */
  /*    addl %ebx, %edx   */
  /*    addl %edx, %esi   */
  /*    addl %esi, %edi   */
  /*    addl %edi, %eax   */
  /*    loop 0b       */
  /*    popl %ecx     */

  0x51, 0xb9, DT_MicroLoops, 0x00, 0x00, 0x00, 0x01, 0xc3, 0x01,
  0xda, 0x01, 0xd6, 0x01, 0xf7, 0x01, 0xf8, 0xe2,
  0xf4, 0x59
#endif
  };


/*
 *  Put some instructions in the guest pages, so we have something
 *  to work with.
 */

#if 1

void
hack_guest_code(void)
{
  unsigned i;
  unsigned char *switch_loop_addr, *outer_loop_addr;
  Bit32s displacement;

  loop_count = DT_MacroLoops;

/* outer_loop: */
  outer_loop_addr = gp0;
  *gp0++ = 0xff;    /* DEC loop_count */
  *gp0++ = 0x0d;
  *(Bit32u *) gp0 = (Bit32u) & loop_count;
  gp0 += 4;

  *gp0++ = 0x0f;    /* JNZ do_inner_loop */
  *gp0++ = 0x85;
  displacement = 1; /* jump past RET instruction */
  *(Bit32u *) gp0 = displacement;
  gp0 += 4;

  *gp0++ = 0xc3;    /* RET */

/* do_inner_loop: */
  *gp0++ = 0xb9;    /*   movl $32, %ecx */
  *(Bit32u *) gp0 = 32;
  gp0 += 4;

/* switch_loop: */
  switch_loop_addr = gp0;
  *gp0++ = 0x49;    /*   decl %ecx */

  *gp0++ = 0x0f;    /* JZ outer_loop */
  *gp0++ = 0x84;
  displacement = ((Bit32u) outer_loop_addr) - (((Bit32u) gp0) + 4);
  *(Bit32u *) gp0 = displacement;
  gp0 += 4;

/* do_switch: */
  *gp0++ = 0xff;    /* jmp *jump_table(,%ecx,4) */
  *gp0++ = 0x24;
  *gp0++ = 0x8d;
  *(Bit32u *) gp0 = (Bit32u) & jump_table;
  gp0 += 4;

  for (i = 0; i < 32; i++) {
    jump_table[i] = (Bit32u) gp0;

    /* A cascade of add instructions as a workload before OOP-branch */
    memcpy(gp0, workload, sizeof(workload));
    gp0 += sizeof(workload);

    *gp0++ = 0xe9;  /* jmp switch_loop */
    displacement = ((Bit32u) switch_loop_addr) - (((Bit32u) gp0) + 4);
    *(Bit32u *) gp0 = displacement;
    gp0 += 4;
    }
}

#else

void
hack_guest_code(void)
{
  unsigned i;
  Bit32s displacement;

  loop_count = DT_MacroLoops;

  /*
   *  Weave some code back and forth between pages to test the
   *  branch handler.
   */

  for (i = 0; i < 20; i++) {
    /* A cascade of add instructions as a workload before OOP-branch */
    memcpy(gp0, workload, sizeof(workload));
    gp0 += sizeof(workload);

    *gp0++ = 0xe9;  /* JMP_Jd */
    displacement = ((Bit32u) gp1) - (((Bit32u) gp0) + 4);
    *(Bit32u *) gp0 = displacement;
    gp0 += 4;

    /* A cascade of add instructions as a workload before OOP-branch */
    memcpy(gp1, workload, sizeof(workload));
    gp1 += sizeof(workload);

    *gp1++ = 0xe9;  /* JMP_Jd */
    displacement = ((Bit32u) gp0) - (((Bit32u) gp1) + 4);
    *(Bit32u *) gp1 = displacement;
    gp1 += 4;
    }

  /*
   *  Now, loop back to beginning of code until terminal condition
   *  is met.
   */

  *gp0++ = 0xff;    /* DEC loop_count */
  *gp0++ = 0x0d;
  *(Bit32u *) gp0 = (Bit32u) & loop_count;
  gp0 += 4;

  *gp0++ = 0x0f;    /* JNZ &guest_page0[0] */
  *gp0++ = 0x85;
  displacement = ((Bit32u) & guest_page0[0]) - (((Bit32u) gp0) + 4);
  *(Bit32u *) gp0 = displacement;
  gp0 += 4;

  *gp0++ = 0xc3;    /* RET */
}

#endif


asm (
  ".globl __execute_guest_code_native \n\t"
  "__execute_guest_code_native:       \n\t"
  "  pushal           \n\t"
  "  pushfl           \n\t"
  "  call guest_page0 \n\t"
  "  popfl            \n\t"
  "  popal            \n\t"
  "  ret              \n\t"
  );
