(module installer mzscheme
  (require (lib "compile.ss" "profj"))
  (provide installer)
  
  (define (installer plthome)
    (let ((draw-path (build-path (collection-path "htdch" "graphics"))))
      (let ((javac
             (lambda (file)
               (parameterize ([current-load-relative-directory draw-path]
                              [current-directory draw-path])
                 (compile-java 'file 'file 'full
                               (build-path draw-path file)
                               #f #f)))))
        (javac "Posn.java")
        (javac "Color.java")
        (javac "Image.djava")
        (javac "PictureFactory.djava")
        (javac "Black.java")
        (javac "Blue.java")
        (javac "Brown.java")
        (javac "Green.java")
        (javac "Orange.java")
        (javac "Purple.java")
        (javac "Red.java")
        (javac "White.java")
        (javac "Yellow.java")
        (javac "Command.djava")
        (javac "DrawLine.djava")
        (javac "DrawRectangle.djava")
        (javac "DrawImage.djava")
	(javac "View.djava")
        (javac "CommandSequence.java")
        (javac "LargerSeq.java")
        (javac "EmptySeq.java")
        (javac "World.java")
        (javac "GameWorld.djava")
        )))
  )
           
