/*
 * $Id: db.c,v 1.17 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "db.h"
#include "debug.h"


Err OpenDatabase( const LocalID dbID, const UInt16 cardNo, DmOpenRef* db,
        UInt16* version, Char* name, UInt32* date ) PLKRDB_SECTION;
void CloseDatabase( DmOpenRef db ) PLKRDB_SECTION;



/* Open the specified database, return the result from the database call */
Err OpenDatabase
    (
    const LocalID   dbID,       /* database ID */
    const UInt16    cardNo,     /* card number database resides on */
    DmOpenRef*      db,         /* upon successful return, the access pointer */
    UInt16*         version,    /* upon successful return, the specific version number */
    Char*           name,       /* upon successful return, the name */
    UInt32*         date        /* upon successful return, the creation date */
    )
{
    Err err;

    *db = DmOpenDatabase( cardNo, dbID, dmModeReadWrite );
    if ( *db == NULL ) {
        *db = DmOpenDatabase( cardNo, dbID, dmModeReadOnly );
        if ( *db == NULL ) {
            MSG( _( "error code %d\n", DmGetLastErr() ) );
            return DmGetLastErr();
        }
    }
    err = DmDatabaseInfo( cardNo, dbID, name, NULL, version, date, 
            NULL, NULL, NULL, NULL, NULL, NULL, NULL );
    MSG_IF( err != errNone, "DmDatabaseInfo failed" );

    return err;
}



/* Close the specified database */
void CloseDatabase
    (
    DmOpenRef dbRef /* database reference */
    )
{
    DmCloseDatabase( dbRef );
}
