# $Id: border.py,v 1.5 2001/12/06 11:08:08 petli Exp $
#
# border.py -- change border color on focused client
#
#    Copyright (C) 1999-2001  Peter Liljenberg <petli@ctrl-c.liu.se>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import wmevents, cfilter

class BorderClient:
    no_border_clients = cfilter.false
    border_default_width = 3
    
    def __client_init__(self):
	if self.no_border_clients(self):
	    self.border_color = None
	    self.border_focuscolor = None
	    self.setborderwidth(0)

	else:
	    self.border_color = self.screen.get_color_res('.border.color',
							  '.Border.Color',
							  '#000000')
	    self.border_focuscolor = self.screen.get_color_res('.border.focus.color',
							       '.Border.Focus.Color',
							       '#c0c0c0')

	    self.setborderwidth(self.border_default_width)
	    self.window.change_attributes(border_pixel = self.border_color) 

	    self.dispatch.add_handler(wmevents.ClientFocusIn, self.border_get_focus)
	    self.dispatch.add_handler(wmevents.ClientFocusOut, self.border_lose_focus)
   
    def border_get_focus(self, event):
	if self.border_focuscolor is not None:
	    self.window.change_attributes(border_pixel = self.border_focuscolor)

    def border_lose_focus(self, event):
	if self.border_color is not None:
	    self.window.change_attributes(border_pixel = self.border_color)

