#! /usr/bin/perl

use Getopt::Std;
use IO::Handle;

$opt_i = '';
getopts('i:');

my $out = new IO::Handle;
$out->fdopen(fileno(STDOUT), "w");

#     Tags containing text to translate
my @text = qw(
        author version abstract title date copyrightsummary
        heading p
);

#     Empty tags
my @empty = qw( date ref manref url );

#     Section tags
my @section = qw( chapt appendix sect sect1 sect2 sect3 sect4 );

#     Tags containing verbatim text
my @verbatim = qw( example );

#     Lists
my @list = qw( enumlist taglist );

#     List items
my @listitem = qw( item tag );

my %text = ();
foreach (@text) {
        $text{uc $_} = 1;
}
my %empty = ();
foreach (@empty) {
        $empty{uc $_} = 1;
}
my %section = ();
foreach (@section) {
        $section{uc $_} = 1;
}
my %verbatim = ();
foreach (@verbatim) {
        $verbatim{uc $_} = 1;
}
my %list = ();
foreach (@list) {
        $list{uc $_} = 1;
}
my %listitem = ();
foreach (@listitem) {
        $listitem{uc $_} = 1;
}

my $level = 0;
my $current = 0;
my $verbatim = 0;
my $listdepth = 0;
my $lastchar = '';

sub max {
        return ($_[0] > $_[1] ? $_[0] : $_[1]);
}

sgml('start', sub {
        push_output('handle', $out);
        output($opt_i."\n");
        pop_output();
        push_output('nul');
});
sgml('end', '');
sgml('start_element', sub {
        my $element = shift;
        $current = max($current, $SGMLS_PL::line);
        $lastchar = ">";
        $verbatim++ if $verbatim{$element->name()};
        if ($level) {
                if ($list{$element->name()}) {
                        output("\n" . ('  ' x $listdepth));
                        $listdepth++;
                }
                if ($listitem{$element->name()}) {
                        output("\n" . ('  ' x $listdepth));
                }
                output('<'.lc($element->name()));
                while (my ($attr, $val) = each %{$element->attributes()}) {
                        if ($val->type() eq 'IMPLIED') {
                                output(' '.lc($attr).'="'.lc($attr).'"');
                        } elsif ($val->type() eq 'CDATA') {
                                my $val = $val->value();
                                if ($val =~ m/"/) {
                                    $val = "'".$val."'";
                                } else {
                                    $val = '"'.$val.'"';
                                }
                                output(' '.lc($attr).'='.$val);
                        } else {
                                output(' '.lc($attr).'="'.lc($val->value()).'"');
                        }
                }
                output('>');
        }
        return unless $text{$element->name()} || $section{$element->name()};
        if ($level == 0) {
                push_output('handle', $out);
                if ($text{$element->name()}) {
                        output("START ");
                } else {
                        output("SECTION ");
                }
                output(lc $element->name());
                output(" ".$element->attribute("ID")->value)
                        if $element->attribute("ID");
                output("\n");
                output("LINES ".$current);
                output("\n") if $section{$element->name()};
                pop_output();
                return if $section{$element->name()};
                push_output('string');
        }
        $level ++;
});
sgml('end_element', sub {
        my $element = shift;

        $current = max($current, $SGMLS_PL::line);
        $lastchar = ">";
        $verbatim-- if $verbatim{$element->name()};
        if ($list{$element->name()}) {
                $listdepth--;
                output("\n" . ('  ' x $listdepth));
        }
        output('</'.lc($element->name()).'>')
                if ($level > 1 || !$text{$element->name()}) &&
                        !$empty{$element->name()};
        return unless $text{$element->name()};
        $level --;
        return if $level;
        $_ = pop_output();
        s/\\/\\\\/g;
        s/\n/\\n/sg;
        push_output('handle', $out);
        output(" ".$current."\n");
        output($_."\n");
        pop_output();
});
sgml('cdata', sub {
        my $cdata = shift;
        $current = max($current, $SGMLS_PL::line);
        if (!$verbatim) {
                $cdata =~ s/\\t/ /g;
                $cdata =~ s/\s+/ /g;
                $cdata =~ s/^\s//s if $lastchar eq ' ';
        }
        $lastchar = substr($cdata, -1, 1);
        output($cdata);
});
sgml('sdata', sub {
        my $sdata = shift;
        $current = max($current, $SGMLS_PL::line);
        $sdata =~ s/^\[//;
        $sdata =~ s/\s*\]$//;
        $lastchar = substr($sdata, -1, 1);
        output('&'.$sdata.';');
});
sgml('re', sub {
        $current = max($current, $SGMLS_PL::line);
        $current ++;
        if ($verbatim) {
                output("\n");
        } elsif ($lastchar ne ' ') {
                output(" ");
        }
        $lastchar = ' ';
});
#sgml('pi', '');
#sgml('entity', '');
#sgml('start_subdoc', '');
#sgml('end_subdoc', '');
#sgml('conforming', '');


