/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-seqeditorctxt.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmSeqEditorCtxt *
polyxedit_seqeditorctxt_new (void)
{
  PxmSeqEditorCtxt *seqeditorctxt = NULL;
  
  /* A number of pointers in this structure do point to widgets which
   * get only created upon displaying of the polymer sequence, so that
   * it is un-necessary to allocate them. These pointers are simply
   * holders.
   */
  
  seqeditorctxt = g_malloc0 (sizeof (PxmSeqEditorCtxt));
  
  /* The two variables elab_code and eval_code cannot be allocated
   * correctly here because we do not know the codelen (number of
   * allowed characters to describe a monomer code.
   *
   seqeditorctxt->elab_code = g_strdup ("");
   seqeditorctxt->eval_code = g_strdup ("");
  */

  seqeditorctxt->cursor = polyxedit_monicon_new ();
    
  /* When a polymer edition context is made, there is no current
   * selection.
   */
  seqeditorctxt->sel_mnm_idx1 = -1;
  seqeditorctxt->sel_mnm_idx2 = -1;
  
  seqeditorctxt->moniconGPA = g_ptr_array_new ();
  seqeditorctxt->labelGPA = g_ptr_array_new ();
  seqeditorctxt->visualGPA = g_ptr_array_new ();

   
  /* The usual property array system.
   */
  seqeditorctxt->propGPA = g_ptr_array_new ();
  
  return seqeditorctxt;
}


gboolean
polyxedit_seqeditorctxt_new_eval_code (PxmSeqEditorCtxt *seqeditorctxt, 
				    gint codelen)
{
  g_assert (seqeditorctxt != NULL);
  g_assert (codelen > 0);
  
  if (seqeditorctxt->eval_code != NULL)
    g_free (seqeditorctxt->eval_code);
  
  seqeditorctxt->eval_code = g_malloc0 (sizeof (gchar) * (codelen + 1));
  
  return TRUE;
}


gboolean
polyxedit_seqeditorctxt_new_elab_code (PxmSeqEditorCtxt *seqeditorctxt, 
				    gint codelen)
{
  g_assert (seqeditorctxt != NULL);
  g_assert (codelen > 0);
  
  if (seqeditorctxt->elab_code != NULL)
    g_free (seqeditorctxt->elab_code);
  
  seqeditorctxt->elab_code = g_malloc0 (sizeof (gchar) * (codelen + 1));
  
  return TRUE;
}



/* FREE'ING FUNCTIONS
 */

gboolean
polyxedit_seqeditorctxt_free (PxmSeqEditorCtxt *seqeditorctxt)
{
  GnomeCanvasItem *label = NULL;
  


  g_assert (seqeditorctxt != NULL);
  

  /* Start with internal data:
   */
  if (seqeditorctxt->visualGPA != NULL)
    libpolyxmass_prop_GPA_free (seqeditorctxt->visualGPA);

  if (seqeditorctxt->propGPA != NULL)
    libpolyxmass_prop_GPA_free (seqeditorctxt->propGPA);

  if (seqeditorctxt->moniconGPA != NULL)
    polyxedit_monicon_GPA_free (seqeditorctxt->moniconGPA);
  
  if (seqeditorctxt->labelGPA != NULL)
    {
      while (seqeditorctxt->labelGPA->len > 0)
	{
	  label = g_ptr_array_index (seqeditorctxt->labelGPA, 0);
	  g_ptr_array_remove_fast (seqeditorctxt->labelGPA, label);
	  gtk_object_destroy (GTK_OBJECT (label));
	}

      g_ptr_array_free (seqeditorctxt->labelGPA, TRUE);
    }
  
  if (seqeditorctxt->cursor != NULL)
    polyxedit_monicon_free (seqeditorctxt->cursor);
  
  if (seqeditorctxt->elab_code != NULL)
    g_free (seqeditorctxt->elab_code);
  if (seqeditorctxt->eval_code != NULL)
    g_free (seqeditorctxt->eval_code);
  
  /* Free the points thare are used to store the corner points of the
   * selection polygon and free the polygon itself.
   */
  if (seqeditorctxt->canvas_selection_points != NULL)
    {
      gnome_canvas_points_unref (seqeditorctxt->canvas_selection_points);
      seqeditorctxt->canvas_selection_points = NULL;
    }

  if (seqeditorctxt->canvas_selection_polygon != NULL)
    {
      gtk_object_destroy (GTK_OBJECT 
			  (seqeditorctxt->canvas_selection_polygon));
      seqeditorctxt->canvas_selection_polygon = NULL;
    }
  
  if (seqeditorctxt->canvas_scroll_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (seqeditorctxt->canvas_scroll_wnd));
  else
    debug_printf (("seqeditorctxt->canvas_scroll_wnd is NULL\n"));
  
  if (seqeditorctxt->sequence_editor_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (seqeditorctxt->sequence_editor_wnd));
  else
    debug_printf (("seqeditorctxt->sequence_editor_wnd is NULL\n"));

  /* Remember that we might have a completions' listview opened
     right now; so remove it...
  */
  if (seqeditorctxt->monomer_completions_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (seqeditorctxt->monomer_completions_wnd));

  g_free (seqeditorctxt);
    
  return TRUE;
}




/* GPtrArray-RELATED FUNCTIONS
 */


