/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxmass-timeoutmsg.h"



/* Timed-out messages in Gtk widgets.
 */
PxmTimeoutmsg *
polyxmass_timeoutmsg_new (void)
{
  PxmTimeoutmsg *timeoutmsg = g_malloc0 (sizeof (PxmTimeoutmsg));
  
  return timeoutmsg;
}

gint
polyxmass_timeoutmsg_free (PxmTimeoutmsg *timeoutmsg)
{
  g_assert (timeoutmsg != NULL);
  
  g_free (timeoutmsg);

  return 1;
}

guint
polyxmass_timeoutmsg_message_set (GtkWindow *window,
				       gchar *message, 
				       guint32 interval)
{
  PxmTimeoutmsg *timeoutmsg = NULL;
  
  GtkEntry *entry = NULL;
  
  g_assert (window != NULL);

  g_assert (message != NULL);

  /*
    Allocate the timeoutmsg object of which we'll fill the different
    data members below.
  */
  timeoutmsg = polyxmass_timeoutmsg_new ();
  
  entry = g_object_get_data (G_OBJECT (window), "messages_entry");
  g_assert (entry != NULL);
  
  /*
    And now set the &(window pointer) to the timeoutmsg struct.
  */
  timeoutmsg->window = window;

  /* 
     Now we can display the text and right after that set the
     timeoutmsg object to the global polyxmass_timeoutmsgGPA array.
  */
  gtk_entry_set_text (GTK_ENTRY (entry), message);
  g_ptr_array_add (polyxmass_timeoutmsgGPA, timeoutmsg);

  /* 
     Finally we can set the timeout event.
  */
  timeoutmsg->id = g_timeout_add 
    (interval,
     (GtkFunction) polyxmass_timeoutmsg_message_stop,
     timeoutmsg);

  return timeoutmsg->id;
}

gint
polyxmass_timeoutmsg_message_stop (PxmTimeoutmsg *timeoutmsg)
{
  GtkEntry *entry = NULL;

  g_assert (timeoutmsg != NULL);
  
  /* 
     We first have to locate the timeoutmsg object in the global GPtrArray.
  */
  if (FALSE == g_ptr_array_remove (polyxmass_timeoutmsgGPA, timeoutmsg))
    {
      g_warning (_("%s@%d: failed removing the timeoutmsg from "
		   "global arrray\n"),
	     __FILE__, __LINE__);
    }
  
  /* We now have to remove that specific timeout event from the queue.
     Old version:
     gtk_timeout_remove (timeoutmsg->id);
  */
  g_source_remove (timeoutmsg->id);

  /* 
     Finally we can empty the GtkEntry.
  */
  entry = g_object_get_data (G_OBJECT (timeoutmsg->window), 
			     "messages_entry");
  g_assert (entry != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  
  /* 
     Finally, we can free the timeoutmsg object itself.
  */
  polyxmass_timeoutmsg_free (timeoutmsg);

  return 1;
}



gint
polyxmass_timeoutmsg_messages_remove (GtkWindow *window)
{
  gint iter = 0;
  gint count = 0;


  PxmTimeoutmsg *timeoutmsg = NULL;


  g_assert (window != NULL);

  
  /* 
     This function is typically called from a widget for which a timed-out
     message was set. This widget might be either a window, in which 
     a GtkEntry widget holds the timed-out message, or the GtkEntry itself.
     
     When a timed-out message is set, a pointer to the pointer of the
     widget is passed as parameter. That pointer is going to be used here
     to trace back to the PxmTimeoutmsg object that was allocated and 
     filled while the timed-out message was set.
  */



  /* 
     We first have to locate the timeoutmsg object in the global
     GPtrArray.  Remember that if we encounter one timeoutmsg object
     that complies with our search criterium, we'll have to remove it
     from the array. Since we might remove one or more items, as
     usual, we iterate in the array in the reverse order.
  */
  for (iter = polyxmass_timeoutmsgGPA->len - 1; iter >= 0; iter--)
    {
      timeoutmsg = g_ptr_array_index (polyxmass_timeoutmsgGPA, iter);
      g_assert (timeoutmsg != NULL);
      
      /* 
	 Now try to find if the timeoutmsg->widget member corresponds
	 to the widget datum passed as parameter.
      */
      if (timeoutmsg->window == window)
	{
	  /*
	    We have found a timeoutmsg object that was set for the
	    window passed as parameter. All we need to do is remove
	    this timeoutmsg object and destroy it.
	  */
	  polyxmass_timeoutmsg_message_stop (timeoutmsg);

	  count++;
	}
    }

  return count;
}


gint
polyxmass_timeoutmsg_GPA_free (GPtrArray *GPA)
{
  PxmTimeoutmsg *timeoutmsg = NULL;
 
  gint count = 0;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      timeoutmsg = g_ptr_array_remove_index (GPA, 0);
      g_assert (timeoutmsg != NULL);
      
      polyxmass_timeoutmsg_free (timeoutmsg);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);
  
  return count;
}




