/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXMASS_TIMEOUTMSG_H
#define POLYXMASS_TIMEOUTMSG_H

#include "polyxmass-globals.h"



typedef struct _PxmTimeoutmsg PxmTimeoutmsg;



struct _PxmTimeoutmsg
{
  GtkWindow *window;
  
  guint id;
  
  guint32 interval;
};




/* Timed-out messages in Gtk widgets.
 */
PxmTimeoutmsg *
polyxmass_timeoutmsg_new (void);

gint
polyxmass_timeoutmsg_free (PxmTimeoutmsg *timeoutmsg);

guint
polyxmass_timeoutmsg_message_set (GtkWindow *window,
				       gchar *message, 
				       guint32 interval);

gint
polyxmass_timeoutmsg_message_stop (PxmTimeoutmsg *timeoutmsg);


gint
polyxmass_timeoutmsg_messages_remove (GtkWindow *window);


gint
polyxmass_timeoutmsg_GPA_free (GPtrArray *GPA);



#endif /* ifndef POLYXMASS_TIMEOUTMSG_H */
