/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PXMCHEM_IONIZERULE_H
#define PXMCHEM_IONIZERULE_H

#include "libpolyxmass-globals.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* typedef's
 */
typedef struct _PxmIonizerule PxmIonizerule;

struct _PxmIonizerule
{
  gchar *actform;
  gint charge;
  gint level;
};


/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmIonizerule * 
pxmchem_ionizerule_new (void);


PxmIonizerule * 
pxmchem_ionizerule_dup (const PxmIonizerule * ionizerule);


gboolean
pxmchem_ionizerule_set_actform (PxmIonizerule *ionizerule, gchar *actform);


gboolean
pxmchem_ionizerule_set_charge (PxmIonizerule *ionizerule, gint charge);


gboolean
pxmchem_ionizerule_set_level (PxmIonizerule *ionizerule, gint level);


/* INTEGRITY CHECKING FUNCTIONS
 */
gboolean
pxmchem_ionizerule_validate (PxmIonizerule *ionizerule, GPtrArray *atom_refGPA,
			     gchar **valid);


/* UTILITY FUNCTIONS
 */
gboolean
pxmchem_ionizerule_set_default (PxmIonizerule *ionizerule);



/* XML-format TRANSACTIONS
 */
gchar *
pxmchem_ionizerule_format_xml_string_ionizerule (PxmIonizerule *ionizerule, 
					  gchar *indent, gint offset);


PxmIonizerule *
pxmchem_ionizerule_render_xml_node_ionizerule (xmlDocPtr xml_doc,
					       xmlNodePtr xml_node,
					       gpointer user_data);
  


gboolean
pxmchem_ionizerule_free (PxmIonizerule * ionizerule);







#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* PXMCHEM_IONIZERULE_H */
