/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "libpolyxmass-init.h"
#include "pxmchem-atom.h"


gboolean
libpolyxmass_init_library (void)
{
  /*
    Initialize global variables related to the configuration of 
    the GNU polyxmass software suite...

    Note that CONFDIR was configured by the configure script,
    and should normally be "/etc/polyxmass"...
  */
  etc_polyxmass_data_cfg_file = g_strdup_printf ("%s/%s", CONFDIR,
						 "polyxmass-data.conf");
  
  etc_atom_defs_cat = g_strdup_printf ("%s/%s", CONFDIR,
				       "atom-defs/atom-defs.cat");
  
  etc_polchem_defs_cat = g_strdup_printf ("%s/%s", CONFDIR,
					  "polchem-defs/polchem-defs.cat");
  
  etc_polchem_defs_atom_defs_dic = 
    g_strdup_printf ("%s/%s", CONFDIR,
		   "polchem-defs/polchem-defs-atom-defs.dic");
  	   
  return TRUE;
}

  

gboolean
libpolyxmass_uninit_library (void)
{
  /* There are a number of data that were allocated dynamically,
     that we should free here, now.
  */
  if (etc_polyxmass_data_cfg_file != NULL)
    g_free (etc_polyxmass_data_cfg_file);
  if (etc_atom_defs_cat != NULL)
    g_free (etc_atom_defs_cat);
  if (etc_polchem_defs_cat != NULL)
    g_free (etc_polchem_defs_cat);
  if (etc_polchem_defs_atom_defs_dic != NULL)
    g_free (etc_polchem_defs_atom_defs_dic);
  
  return TRUE;
}


