//******************************************************************************
// Copyright (C) 1998-2000 TLK Games all rights reserved.
// project						: Powermanga shoot'm up game
// programmers				:	Jean-Michel Martin de Santero : main programmer & creator of game
//										: Bruno Ethvignot								: Linux port, score, about
//										: Etienne Sobole								: anim player, visuals effects
//										: Emmanuel Founaud							: sprites routines
// gfx								:	David Igreja									: modeling
//										: Jean-Michel Martin de Santero : design & modeling
// company						: TLK Games BP 24 81150 Florentin France
// 										: tel:++33(0)563532637 / fax:++33(0)563532637 
//------------------------------------------------------------------------------
// file 					: "powermanaga.hpp"
// updates 				: 2000-08-24
//------------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// *****************************************************************************
#ifndef __POWER_MANGA__
#define __POWER_MANGA__
//..............................................................................
//#define DEVELOPPEMENT				//flag pour compilation pour le developpement
#define UTILISE_SEAL					//utilise  Synthetic Audio Library (http://www.egerter.com/seal)
#define SCROLL_PRESENT				1
#define POWERMANGA_VERSION		"POWERMANGA 0.71c (2000-12-02)"


//..............................................................................
#define	DEUX_PI						6.28318530718
#define	PI								3.14159265359f
#define	PI_SUR_2					1.57079632679f
#define	PI_PLUS_PI_SUR_2	4.712388980385f
#define	PI_SUR_16					0.19634954085f
#define PI_SUR_32					0.19634954085
//..............................................................................
#define SP2MIJ							0		// Dfini la pos. du tir spcial 2 vertical de puissance 1 du joueur dans le tableau des tirs.
#define TIR1P1J							1		// Dfini la position du tir 1 de puissance 1 du joueur dans le tableau des tirs.
#define TIR1P1E							2		// Dfini la position du tir 1 de puissance 1 ennemi dans le tableau des tirs.
#define TIR1P2E							3		// Dfini la position du tir 1 de puissance 2 ennemi dans le tableau des tirs.
#define TIR1P3E							4		// Dfini la position du tir 1 de puissance 3 ennemi dans le tableau des tirs.
#define SP1V1J							5		// Dfini la pos. du tir spcial 1 vertical de puissance 1 du joueur dans le tableau des tirs.
#define SP1V2J							6		// Dfini la pos. du tir spcial 1 vertical de puissance 2 du joueur dans le tableau des tirs.
#define SP1V3J							7		// Dfini la pos. du tir spcial 1 vertical de puissance 3 du joueur dans le tableau des tirs.
#define SP1V4J							8		// Dfini la pos. du tir spcial 1 vertical de puissance 4 du joueur dans le tableau des tirs.
#define SP1V5J							9		// Dfini la pos. du tir spcial 1 vertical de puissance 5 du joueur dans le tableau des tirs.
#define SP1H1J							10	// Dfini la pos. du tir spcial 1 horizontal de puissance 1 du joueur dans le tableau des tirs.
#define SP1H2J							11	// Dfini la pos. du tir spcial 1 horizontal de puissance 2 du joueur dans le tableau des tirs.
#define SP1H3J							12	// Dfini la pos. du tir spcial 1 horizontal de puissance 3 du joueur dans le tableau des tirs.
#define SP1H4J							13	// Dfini la pos. du tir spcial 1 horizontal de puissance 4 du joueur dans le tableau des tirs.
#define SP1H5J							14	// Dfini la pos. du tir spcial 1 horizontal de puissance 5 du joueur dans le tableau des tirs.
#define T2NP1J							15	// Dfini la pos. du tir normal 2 de puissance 1 du joueur dans le tableau des tirs.
#define T2NP2J							16	// Dfini la pos. du tir normal 2 de puissance 2 du joueur dans le tableau des tirs.
#define V1TN1								17	// Dfini le tir normal avant 1 du vaisseau 1.
#define V1TN2								18	// Dfini le tir normal avant 2 du vaisseau 1.
#define V1TN3								19	// Dfini le tir normal avant 3 du vaisseau 1.
#define V1TGN1							20	// Dfini le tir normal gauche 1 du vaisseau 1.
#define V1TGN2							21	// Dfini le tir normal gauche 2 du vaisseau 1.
#define V1TGN3							22	// Dfini le tir normal gauche 3 du vaisseau 1.
#define V1TDN1							23	// Dfini le tir normal gauche 1 du vaisseau 1.
#define V1TDN2							24	// Dfini le tir normal gauche 2 du vaisseau 1.
#define V1TDN3							25	// Dfini le tir normal gauche 3 du vaisseau 1.
#define V2TN1								26	// Dfini le tir normal avant 1 du vaisseau 1.
#define V2TN2								27	// Dfini le tir normal avant 2 du vaisseau 1.
#define V2TN3								28	// Dfini le tir normal avant 3 du vaisseau 1.
#define V2TGN1							29	// Dfini le tir normal gauche 1 du vaisseau 1.
#define V2TGN2							30	// Dfini le tir normal gauche 2 du vaisseau 1.
#define V2TGN3							31	// Dfini le tir normal gauche 3 du vaisseau 1.
#define V2TDN1							32	// Dfini le tir normal gauche 1 du vaisseau 1.
#define V2TDN2							33	// Dfini le tir normal gauche 2 du vaisseau 1.
#define V2TDN3							34	// Dfini le tir normal gauche 3 du vaisseau 1.
#define V2THN1							35	// Dfini le tir du haut 1 du vaisseau 3.
#define V2THN2							36	// Dfini le tir du haut 2 du vaisseau 3.
#define V2THN3							37	// Dfini le tir du haut 3 du vaisseau 3.
#define V3THN1							38	// Dfini le tir du haut 1 du vaisseau 3.
#define V3THN2							39	// Dfini le tir du haut 2 du vaisseau 3.
#define V3THN3							40	// Dfini le tir du haut 3 du vaisseau 3.
#define MISSx0							41	// Dfini le missil x0.
#define MISSx1							42	// Dfini le missil x1.
#define MISSx2							43	// Dfini le missil x2.
#define MISSx3							44	// Dfini le missil x3.
#define MISSx4							45	// Dfini le missil x4 utilise par le gardien 6.
#define MISSx5							46	// Dfini le missil x5.

#define V3TBA							47
#define V3TBB							48
#define V3TBC							49
#define V3TDA							50
#define V3TDB							51
#define V3TDC							52
#define V3TGA							53
#define V3TGB							54
#define V3TGC							55
#define V3TSA							56
#define V3TSB							57
#define V3TSC							58
#define V3TSD							59
#define V3TSE							60

#define V4THA							61
#define V4THB							62
#define V4THC							63
#define V4TBA							64
#define V4TBB							65
#define V4TBC							66
#define V4TDA							67
#define V4TDB							68
#define V4TDC							69
#define V4TGA							70
#define V4TGB							71
#define V4TGC							72
#define V4TSA							73
#define V4TSB							74
#define V4TSC							75
#define V4TSD							76
#define V4TSE							77

#define BIG_EXPLOSION				1
#define NORM_EXPLOSION			0
#define MINI_EXPLOSION			2
#define AMI                 0
#define ENNEMI              1
#define GAUCHE              0
#define DROITE              1

//taille de notre ecran ========================================================
#define LARG_ECR_RAM_TOT		512 			//hauteur ecran d'affichage (xImage)
#define HAUT_ECR_RAM_TOT		440 			//hauteur ecran d'affichage (xImage)
#define LARG_ECRAN_PHY			320				//largeur ecran physique (fenetre x-window)
#define HAUT_ECRAN_PHY			200   		//hauteur ecran physique (fenetre x-window)
#define LARG_ECR_RAM        256				//largeur ecran visible (partie visible de notre ximage)
#define HAUT_ECR_RAM        184   		//hauteur ecran visible (partie visible de notre ximage)
#define BANDE_DE_CLIP       128 			//nombres de pixels utlises pour le clipping 
#define DEBUT_ECRAN_X				128				//abscisse debut ecran visible
#define DEBUT_ECRAN_Y				128 			//ordonnee debut ecran visible
#define OFFSETHAUTGAUCHE		(DEBUT_ECRAN_Y*LARG_ECR_RAM_TOT)+DEBUT_ECRAN_X
#define	OPT_LARGE						64				//largeur bande d'options en pixels
#define	OPT_HAUTE						184				//hauteur bande d'options en pixels
#define	SCR_LARGE						320				//largeur bande des scores en pixels
#define SCR_HAUTE						16				//hauteur bande des scores en pixels
//..............................................................................
#define LARG_GRILLE         16    // Largeur de la grille en nombre de positions pour l'affichage des sprites enemis.
#define HAUT_GRILLE         10    // Hauteur de la grille en nombre de positions pour l'affichage des sprites enemis.
#define X                   0     // Indice des coordonnes X.
#define Y                   1     // Indice des coordonnes Y.
#define L                   0     // Indice des largeurs.
#define H	                  1     // Indice des hauteurs.
#define POS_CURVE						0     // Indice de progression dans une courbe.
#define MAX_TYP_OF_EXPLOS		3			// Dfini le nombre maximum d'explosions diffrentes.
#define MAX_TYP_OF_ECLATS		5			// Dfini le nombre maximum d'clats diffrents.
#define MAX_TYP_OF_METEOR		3			// Dfini le nombre maximum de mtorites diffrentes (grosses, normales et petites).
#define NBR_IMAGES_METEOR		32    // Dfini le nombre maximum d'images pour les mtorites.
#define NBR_ANGLES					32    // Dfini le nombre d'angles diffrents.
//..............................................................................
#define MAX_TYP_OF_ENEMI		21    //nombre maximum d'enemis 
#define MAX_TYP_OF_S_ENEMI	21   	//nombre maximum de super-enemis 
#define MAX_TYP_OF_NMI_SPE	40		//nombre maximum d'enemis speciaux
#define MAX_TYP_OF_OBJ_SPE	8			//nombre maximum d'objets speciaux 
#define MAXTYPENMI					MAX_TYP_OF_ENEMI+MAX_TYP_OF_S_ENEMI+MAX_TYP_OF_NMI_SPE+MAX_TYP_OF_OBJ_SPE
//..............................................................................
#define MAX_TYP_OF_BONUS			6     // Dfini le nombre maximum de bonus diffrents.
#define MAX_TYP_OF_OPTIONS		13    // Dfini le nombre maximum d'animations pour les diffrentes options.
#define MAX_TYP_OF_BOULES			5     // Dfini le nombre maximum de boules diffrentes.
#define MAX_TYP_OF_CANONS			5     // Dfini le nombre maximum de canons diffrents.
#define MAX_NMI_ON_SCREEN			180   // Dfini le nombre maximum d'enemis grs au mme instant.
#define MAX_BONUS_ON_SCREEN		20		// Dfini le nombre maximum de bonus grs au mme instant.
#define MAX_BOULES_ON_SCREEN	20		// Dfini le nombre maximum de boules grs au mme instant.
#define MAX_CANONS_ON_SCREEN	10		// Dfini le nombre maximum de canons grs au mme instant.
#define MAX_PNT_OF_CURVE			2000  // Dfini le nombre maximum de points d'une courbe.
#define MAX_NBR_OF_SCR_CURV		5     // Dfini le nombre maximum de courbes simultanes  l'cran.
#define NUM_VAI_BY_CURVE			16    // Dfini le nombre maximum de vaisseaux par courbe  l'cran.
#define MAX_TYP_OF_TIR				78    // Dfini le nombre maximum de types de tirs diffrents.
#define NBR_PTS_COL_MAX				12    // Dfini le nombre de points de collision maximum.
#define NBR_PTS_TIR_MAX				12    // Dfini le nombre maximum de points de tir sur un sprite.
#define NBR_ZON_COL_MAX				6     // Dfini le nombre de zone de collision maximum.
#define NBR_IMAGES_MAX				40    // Dfini le nombre maximum d'images composant un sprite.
#define NBR_IMAGES_TIR				32    // Dfini le nombre maximum d'images pour les tirs.
#define NBR_IMAGES_EXP				32    // Dfini le nombre maximum d'images pour une explosion.
#define NBR_IMAGES_ECLATS			32    // Dfini le nombre maximum d'images pour un clat.
#define NBR_IMAGES_S_NMI			8    	// Dfini le nombre maximum d'images maximum pour les s_ennemi.
#define NBR_IMAGES_NMI_S			32   	// Dfini le nombre maximum d'images maximum pour les ennemi spciaux.
#define NBR_IMAGES_BONUS			32		// Dfini le nombre maximum d'images composant un bonus.
#define NBR_IMAGES_OPTIONS		33		// Dfini le nombre maximum d'images composant une option.
#define NBR_IMAGES_BOULES			16		// Dfini le nombre maximum d'images composant une boule.
#define NBR_IMAGES_CANONS			16		// Dfini le nombre maximum d'images composant une canon.
#define NBR_MAX_VAIS_J				5			// Dfini le nombre maximum de vaisseaux par joueur.
#define NBR_MAX_IMG_VAIS_J		5     // Dfini le nombre maximum d'images de vaisseaux par joueur.
#define NBR_MAX_J           	2     // Dfini le nombre maximum de joueurs.
#define TYPE_OF_STARS       	4     // Nombre de types d'toiles diffrent.
#define NBR_ETOILES         	8 	    // Nombre d'toiles, utilis pour le chargement des fichiers graphique.
#define NBR_STARS_BY_TYPE   	24    // Nombre d'toiles maximum  afficher par types d'toile.
#define NBR_OF_STARS        	72    // Dfini le nombre maximum d'toiles  afficher.
#define BIGSTAR             	0     // Dfini la constante utilise pour pointer sur les grosses toiles du starfield.
#define STAR                	1     // Dfini la constante utilise pour pointer sur les toiles du starfield.
#define LITSTAR             	2     // Dfini la constante utilise pour pointer sur les petites toiles du starfield.
#define PLAYERSTAR          	3     // Dfini la constante utilise pour pointer sur les toiles du joueur.
#define NBR_TIRS_MAX        	400   // Dfini le nombre de tirs maximum.
#define NBR_FNT_SCROLL_MAX		400		// Dfini le nombre de fontes qui scrollent maximum.
#define NBR_GRID_MAX        	3     // Dfini le nombre de grilles maximum.
#define NBR_CURVE_MAX       	122		// Dfini le nombre maximum de courbes de bzier charges au dpart du jeu.
#define NBR_LEVEL_MAX 				41		// Dfini le nombre maximum de niveaux du jeu.
#define NBR_COLOR_DEAD 				11		// Dfini le nombre de couleurs utilises lors de la disparition d'un vaisseau.
#define NBR_COLOR_ONDE_CHOC 	25		// Dfini le nombre de couleurs utilises pour l'affichage d'une onde de choc.
#define NBR_ANIM_GARDIAN			5			// Dfini le nombre d'animations maximum par gardien.
//..............................................................................
#define MENU_OFF						0
#define MENU_ON							1
#define APPARITION_MENU			2
#define DISPARITION_MENU		3
#define NBR_OPTION_MENU			4			// Dfini le nombre d'options du menu.
#define NBR_IMAGES_MENU			32		// Dfini le nombre d'images utilises pour un sprite du menu.
#define NBR_IMAGES_LOGOTLK	64		// Dfini le nombre d'images utilises pour le logo.
#define POS_Y_GAME					179		// Dfini la position Y d'affichage du mot GAME.
#define POS_Y_OVER					222		// Dfini la position Y d'affichage du mot OVER.
//..............................................................................
#define NBR_IMAGES_FONTE		16		// Dfini le nombre d'images utilises pour l'affichage d'une lettre.
#define LARG_FONTE_GAME			16    // Largeur d'une fonte pour le jeu.
#define HAUT_FONTE_GAME			16    // Hauteur d'une fonte pour le jeu.
#define NBR_FONTES_SCORE		10		// Dfini le nombre de lettres utilises pour l'affichage des scores pendant le jeu.
#define NBR_FONTES_GAME			90		// Dfini le nombre de lettres utilises pour les diffrents affichage pendant le jeu.
#define NBR_FONTES_BIG			27		// Dfini le nombre de lettres utilises pour l'affichage en grosse lettres pendant le jeu.
#define NBR_FONTES_SCROLL		58		// Dfini le nombre de lettres utilises pour l'affichage avec scrolling.
#define NBR_CHIF_SCORE			8			// Dfini le nombre de lettres utilises pour le comptage du score du joueur.
#define NBR_CHIF_LEVEL			7			// Dfini le nombre de lettres utilises pour l'affichage du niveau du joueur.
#define NBR_CHIF_GAME_OVER	4			// Dfini le nombre de lettres utilises pour le comptage du game over.
#define NBR_CHIF_PAUSE			5			// Dfini le nombre de lettres utilises pour le comptage de la pause.
#define TEMPS_INVINCIBLE		15		// Dfini le temps pendant lequel le joueur est invincible.
#define NBR_MAX_DEP_GARDIEN 100		// Dfini le nombre maximum de dplacements pour un gardien.
#define NBR_ONDE_CHOC_MAX		20 		// Dfini le nombre maximum d'ondes de choc.
#define NBR_ANO_ONDE_CHOC		55 		// Dfini le nombre maximum d'anneaux qui compose une onde de choc.
#define NBR_PTS_ONDE_CHOC		129		// Dfini le nombre maximum de points qui compose une onde de choc.
//#define debug                     // pour lancer le programme en mode DEBOGAGE
//..............................................................................

enum DEPLACEMENT {COURBE,GRILLE,SPECIAUX,GARDIEN} ; // Dfinition des constantes pour la gestion des ennemis.
enum JOUEUR {J1,J2,J3} ; // Dfini les constantes dsignant les joueurs.
enum TYPE_VAIS_J {V1J,V2J,V3J,V4J,V5J} ; // Dfini les constantes dsignant les diffrents types de vaisseaux par joueur.

enum TYPE_VAIS_E {
									BOONIES,MOOARCKS,ACHEES,EVILIANS,RAGOONS,
									FLABBIES,BOWANS,HIJACKERS,DISTASIANS,BRITTERS,
									SICKIES,ARIANS,STINCKIES,BZEURCKS,WEAKIES,
									MASKIES,SCRAPIES,SCROLLIANS,SHAMISTEES,FOOLINIANS,
									GLAMOOSH,
									BIGBOONIES,BIGMOOARCKS,BIGACHEES,BIGEVILIANS,BIGRAGOONS,
									BIGFLABBIES,BIGBOWANS,BIGHIJACKERS,BIGDISTASIANS,BIGBRITTERS,
									BIGSICKIES,BIGARIANS,BIGSTINCKIES,BIGBZEURCKS,BIGWEAKIES,
									BIGMASKIES,BIGSCRAPIES,BIGSCROLLIANS,BIGSHAMISTEES,BIGFOOLINIANS,
									BIGGLAMOOSH,
									//Ici commencent les vaisseaux speciaux.
									SUBJUGANEERS,MILLOUZ,SWORDINIANS,TOUBOUG,DISGOOSTEES,
									EARTHINIANS,BIRIANSTEES,BELCHOUTIES,VIONIEES,HOCKYS,
									TODHAIRIES,DEFECTINIANS,BLAVIRTHE,SOONIEES,ANGOUFF,
									GAFFIES,BITTERIANS,BLEUERCKS,ARCHINIANS,CLOWNIES,
									DEMONIANS,TOUTIES,FIDGETINIANS,EFFIES,DIMITINIANS,
									PAINIANS,ENSLAVEERS,FEABILIANS,DIVERTIZERS,SAPOUCH,
									HORRIBIANS,CARRYONIANS,DEVILIANS,ROUGHLEERS,ABASCUSIANS,
									ROTIES,STENCHIES,PERTURBIANS,MADIRIANS,BAINIES,
									//Ici commencent les objets speciaux.
									SHURIKY,NAGGYS,GOZUKY,SOUKEE,QUIBOULY,TOURNADEE,SAAKEY,SAAKAMIN,
									BIGMETEOR,NORMALMETEOR,SMALLMETEOR,ETB_SHURIKY,
									//Ici commencent les Gardiens.
									THANIKEE,BARYBOOG,PIKKIOU,NEGDEIS,FLASHY,MEECKY,TYPYBOON,MATHYDEE,OVYDOON,GATLEENY,NAUTEE,
									KAMEAMEA, SUPRALIS, GHOTTEN
									} ; // Dfini les constantes dsignant les diffrents types de vaisseaux ennemis.
enum COULEUR {NOIR,	GRIS_FONCE, GRIS,	GRIS_CLAIR, BLANC, ROUGE, VERT,	JAUNE, BLEUE, ROUGE_FONCE} ;


typedef struct pnt2D {
	short x;
	short y;
} pnt2D ;

typedef struct Eclair {
	int sx,sy;
	int dx,dy;
	int col1,col2;
	int r1,r2,r3;
} Eclair;

typedef struct poly {
	char taille;
	char zero;
	unsigned char coul;
	char nb_pnt;
	pnt2D P[5];
	int fin;
} poly ;

typedef struct onde_de_choc {
	int 		cmpt_cercle ; // Utilis pour compter sur quel anneau de base l'on se trouve.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des ondes de choc.
	int			orig_x, orig_y ; // Dfini le point central de l'onde de choc.
	int			cmpt_color_aff ; // Utilis pour compter le numro de couleur utilis pour l'affichage de l'onde de choc.
} onde_de_choc ;

typedef struct pcxheader {
	unsigned char griffe;
	unsigned char version;
	unsigned char codage;
	unsigned char bits_par_pxl;
	unsigned short x1;
	unsigned short y1;
	unsigned short x2;
	unsigned short y2;
	unsigned short hres;
	unsigned short vres;
	unsigned char pal[48];
	char bidon;
	char nbr_planes;
	unsigned short bytes_par_lgn;
	unsigned short type_pal;
	unsigned short shres;
	unsigned short svres;
	char rabdeplace[54];
} pcxheader ;

//use for fontes, TLK's logo, main menu text, scrolltext, options ..............
typedef struct fonte
{	int			nbr_pts_img ;			//number of pixels
	char*		img ;							//memory address
	int			nbr_data_comp ;		//table compression size
	char*		compress ;				//table compression data  (for assembler routine (rep;stosb) )
} fonte ;

//use for fontes animated (score, number of level) .............................
typedef struct play_score
{	int			old_val_font ;		//fonte's number
	int			old_img_font ;
	bool		anim_font ;				//1=fonte is animated
	short   img_act ; 				//number of animations
	short   nbr_tot_vbl ; 		//tempo
	short   add_vbl ; 				//
	short   nbr_vbl_act ; 		//tempo's conter
} play_score ;

typedef struct option {
	int			num_option ;
	bool		anim_open ;
	bool		anim_close ;
	bool		close_option ;
	short   img_act ; // Indique le numro de l'images actuelle.
	short   nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   add_vbl ; // Indique le nombre de vbl qu'il faut ajouter pour passer  l'image suivante.
	short   nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
} option ;

// use for all sprites .........................................................
typedef struct image
{	short	x_cg, y_cg ;			// X et Y du centre de gravit de l'image.
	short larg, haut ; //largeur et hauteur de l'image.
	short nbr_pts_col ; // Nombre de points de collisions.
	short xy_pts_col[NBR_PTS_COL_MAX][2] ; // Tableau des coordonnes de chaque points de collision en fonction du coin suprieur gauche de l'image.
	short nbr_zon_col ; // Nombre de points de collisions.
	short xy_zon_col[NBR_ZON_COL_MAX][2] ; // Tableau de coordonnes de chaque zones de collisions.
	short lh_zon_col[NBR_ZON_COL_MAX][2] ; // Tableau des largeurs et hauteurs de chaque zones de collisions.
	short nbr_pts_tir ; // Nombre de points de tir.
	short xy_pos_tir[NBR_PTS_TIR_MAX][2] ; // Tableau de coordonnes de chaque points de tir.
	short angle_tir[NBR_PTS_TIR_MAX] ; // Tableau de chaque angles de tir.
	int   nbr_pts_img ; // Indique le nombre de points composant l'image.
	char	*img ; // Adresse de l'image.
	int		nbr_data_comp ; // Indique le nombre de donnes de compression de l'image.
	char	*compress ; // Adresse des donnes de compression de l'image.
} image ;

typedef struct str_bonus {
	int			genre ; 								//type of bonus
	short   trajectoire ;						//0=trajectoire lineaire
	short   nbr_img ; 							//nombre d'image du sprite
	short   img_act ;								//numero de l'image actuelle
	short   nbr_tot_vbl ;						// Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   nbr_vbl_act ;						// Indique le compteur de vbl actuel pour l'animation de l'image.
	image   *img[NBR_IMAGES_MAX] ;	// Tableau contenant toutes les structures images des bonus.
	float   coor_x ;								//abscisse 
	float		coor_y ;								//ordonnee
	float   vitesse ;								//vitesse de deplacement
} str_bonus ;

typedef struct str_boule {
	bool    visible ; // Indique si le sprite est affich ou non  l'cran.
	bool    affich_white ; // Indique si on doit ou pas afficher le sprite en blanc.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des boules.
	short   app_vaisseau ; // Indique le vaisseau  qui appartient cette boule.
	short   nbr_pts_cercle ; // Indique le nombre de points composant le cercle.
	short   pos_pts_cercle ; // Indique la position du pointeur sur le tableau des points du cercle.
	short   pow_of_dest ; // puissance de destruction (utilis lors d'une collision).
	short   etat_dommages ; // si =< 0 cela indique que le vaisseau est mort, si > 0 cela   indique l'tat des dommages.
	short   nbr_img ; // Indique le nombre d'images composant le sprite.
	short   img_act ; // Indique le numro de l'images actuelle.
	short   nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
	image   *img[NBR_IMAGES_MAX] ; // Tableau contenant toutes les structures images du sprite.
	int			coor_x, coor_y ; // Coordonnes d'affichage X et Y de la boule.
	int     cad_tir ; // Variable utilise pour compter le temps qu'il faut  la boule avant de pouvoir tirer  nouveau.
	int     cad_tir_initiale ; // Corespond au temps qu'il faut  la boule avant de pouvoir tirer  nouveau.
} str_boule ;

typedef struct str_canon {
	bool    visible ; // Indique si le sprite est affich ou non  l'cran.
	bool    affich_white ; // Indique si on doit ou pas afficher le sprite en blanc.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des canons.
	short   app_vaisseau ; // Indique le vaisseau  qui appartient ce canon.
	short   pow_of_dest ; // puissance de destruction (utilis lors d'une collision).
	short   etat_dommages ; // si =< 0 cela indique que le vaisseau est mort, si > 0 cela   indique l'tat des dommages.
	short   nbr_img ; // Indique le nombre d'images composant le sprite.
	short   img_act ; // Indique le numro de l'images actuelle.
	short   nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
	image   *img[NBR_IMAGES_MAX] ; // Tableau contenant toutes les structures images du sprite.
	int			coor_x, coor_y ; // Coordonnes d'affichage X et Y du canon.
	int     cad_tir ; // Variable utilise pour compter le temps qu'il faut au canon avant de pouvoir tirer  nouveau.
	int     cad_tir_initiale ; // Corespond au temps qu'il faut au canon avant de pouvoir tirer  nouveau.
	int     position ; // 0 indique que le canon se trouve  la droite du vaisseau, 1 indique la gauche.
} str_canon ;

typedef struct sprite {
	bool    genre ; // 0 indique si c'est un sprite ami, 1 indique un sprite ennemi.
	short   trajectoire ; // 0 indique que le tir  une trajectoire linaire, 1 indique que sa trajectoire est recalcule  chaque VBL, 2 indique qu'il suit une courbe.
	short   pow_of_dest ; // puissance de destruction (utilis lors d'une collision).
	short   etat_dommages ; // si =< 0 cela indique que le vaisseau est mort, si > 0 cela   indique l'tat des dommages.
  short   etat_max ; // copie de l'etat initial des dommages
	short   pilote ; // 0 indique un pilotage par ordinateur, les chiffres suivant indique le numro du pilote humain.
	short   mode_commande ; // 0 indique un dplacement au clavier, 1  la souris et 2 un dplacement dirig au joystick.
	short   nbr_img ; // Indique le nombre d'images composant le sprite.
	short   img_act ; // Indique le numro de l'images actuelle.
	short   nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
	image   *img[NBR_IMAGES_MAX] ; // Tableau contenant toutes les structures des images du sprite.
	float   coor_x, coor_y ; // Coordonnes d'affichage X et Y du sprite.
	float   vitesse ; // Vitesse du sprit.
} sprite ;

typedef struct star {
	image   *img ; // Pointeur sur la structure images de l'toile.
	float   coor_x, coor_y ; // Coordonnes d'affichage X et Y du sprite.
	float   vitesse ; // Vitesse du sprit.
	int			type ;
	int			nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	int			nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
} star ;

typedef struct explosion {
	short   img_act ; // Indique le numro de l'images actuelle.
	short   nbr_tot_vbl ; // Indique le nombre de vbl qu'il faut avant de passer  l'image suivante.
	short   nbr_vbl_act ; // Indique le compteur de vbl actuel pour l'animation de l'image.
	image   *img[NBR_IMAGES_EXP] ; // Tableau contenant toutes les structures des images du sprite.
	float		coor_x, coor_y ; // Coordonnes d'affichage X et Y du sprite.
	float   vitesse ; // Vitesse du sprit.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des explosions.
	int			nbr_vbl_av_exp ; // Nombre de vbl avant que l'explosion n'apparaisse.
	short	  img_angle ;
} explosion ;

typedef struct tir {
	sprite  spr ; // Structure d'un sprite.
	short   pos_vaiss[2] ; // Donne l'indice de progression du vaisseau soit sur la courbe, soit sur la grille.
	short		num_courbe ; // Donne le numro de la courbe utilis par le vaisseau ennemi.
	short   tmp_life_tir ; // temps de vie dfini en nombre de VBLs.
	float   angle_tir ; // Angle du projectile.
	float   agilite ; // Permet de prendre les courbes plus ou moins rapidement.
	short	  img_angle, img_old_angle ;
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des tirs.
	bool		clignote ; // Indique si l'on est en prsence d'un sprite clignotant (tir ennemi) ou non.
} tir ;

typedef struct vaisseau_nmi {
	sprite  spr ; // Structure d'un sprite.
	bool		dead ; // Indique que le vaisseau ennemi est mort (utilis pour le faire disparaitre correctement).
	bool    visible_dead ; // Indique si le sprite est affich ou non  l'cran lorsqu'il est en train de clignoter avant de mourrir.
	short		cmpt_color_dead ; // Indique la couleur d'affichage du vaisseau ennemi .
	bool    affich_white ; // Indique si on doit ou pas afficher le vaisseau ennemi en blanc.
	bool    visible ; // Indique si le sprite est affich ou non  l'cran.
	short   invincible ; // Indique le nombre de VBLs pendant lesquelles, le vaisseau est invincible.
	bool		retournement ; // Vaut 1 si le vaisseau ennemi est dans sa phase de retournement, sinon 0.
	bool		change_dir ; // Vaut 1 si le vaisseau ennemi  chang de direction, sinon 0.
	int     cad_tir ; // Variable utilise pour compter le temps qu'il faut au vaisseau avant de pouvoir tirer  nouveau.
	int     cad_tir_initiale ; // Corespond au temps qu'il faut au vaisseau avant de pouvoir tirer  nouveau.
	short   deplacement ; // 0 indique une courbe, 1 indique une grille, 2 indique un gardien.
	short   pos_vaiss[2] ; // Donne l'indice de progression du vaisseau soit sur la courbe, soit sur la grille.
	short		num_courbe ; // Donne le numro de la courbe utilis par le vaisseau ennemi.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des vaisseaux ennemis.
	int			type ; // Indique le type d'ennemi, 0 = 16x16, 1 = 32x32, 2 = special.
	int			sens_anim ; // 0 Indique un sens croissant, 1 un sens dcroissant.
	float		vitesse_x, vitesse_y ; // Vitesse de dplacement en x et y du vaisseau.
	int			temps_apparition ; // Utilise par les vaisseaux spciaux pour savoir si l'on peux supprimer ou non le sprite.
	float   angle_tir ; // Angle de deplacement du vaisseau pour les SOUKEE par exemple.
	short	  img_angle, img_old_angle ;
	float   agilite ; // Permet de prendre les courbes plus ou moins rapidement.
} vaisseau_nmi ;

typedef struct grid {
	short		nbr_vaisseaux ; // Donne le nombre de vaisseaux de la grille.
	bool		activity ; // Indique si on doit faire la gestion de la grille.
	bool		apparition ; // Indique si la grille est en phase d'appariton ou pas.
	int			sens_dep ; // Indique si la grille se dplace  gauche ou bien  droite.
	short		nom_vaisseau[LARG_GRILLE][HAUT_GRILLE] ; // Numro du vaisseau ennemi dans la grille.
	short		freq_tir[LARG_GRILLE][HAUT_GRILLE] ; // VBLs corespondant au temps qu'il faut au vaisseau avant de pouvoir tirer  nouveau.
	float		coor_x, coor_y ;
	float		vit_dep_x, vit_dep_y ;
} grid ;

typedef struct curve {
	short   nbr_pnt_curve ; // Donne le nombre de points de la courbe.
	short   pos_x, pos_y ; // Donne les coordones du point dpart de la courbe par rapport  l'origine de l'cran en ram.
	char    delta_x[MAX_PNT_OF_CURVE] ; // Donne le dplacement en x du point.
	char    delta_y[MAX_PNT_OF_CURVE] ; // Donne le dplacement en y du point.
	char		angle[MAX_PNT_OF_CURVE] ; // Donne l'angle pour l'affichage du vaisseau.
} curve ;

//structure 'curve_level' : utilisee par la phase "courbe" =====================
//(5 courbes maxium, 16 vaisseaux par courbes maximum)
typedef struct curve_level
{	bool    activity ; 																//1=gestion de la phase "courbe" en cours
	short		num_courbe_act ; 													//numero de la courbe actuellement geree
	short   nbr_vaisseaux_act[MAX_NBR_OF_SCR_CURV] ;	//nombre de vaisseaux (16 maxi) actuellement sur chaque courbes (5 maximum)
	short   nbr_vbl_app_act[MAX_NBR_OF_SCR_CURV] ;		//nombre de boucles comptees entre l'apparition de chaque vaisseau

	short		nbr_tot_courbes ;													//nombre total de courbes
	short		num_courbe[MAX_NBR_OF_SCR_CURV] ;					//tableau des differents numeros de courbes.
	short		nbr_vaisseaux_tot[MAX_NBR_OF_SCR_CURV] ;	//nombre de vaisseaux  sur chaque courbes
	short   nbr_vbl_apparition[MAX_NBR_OF_SCR_CURV] ; //nombre de boucles entre l'apparition de chaque vaisseaux sur chaque courbe
	
	short   num_vaisseau[MAX_NBR_OF_SCR_CURV][NUM_VAI_BY_CURVE] ; //numeros des vaisseaux sur toutes les courbes
	short   freq_tir[MAX_NBR_OF_SCR_CURV][NUM_VAI_BY_CURVE] ; 		//delai entre les tirs des vaisseaux
} curve_level ;

typedef struct vaisseau {
	sprite	spr ; // Structure d'un sprite.
	float		vitesse_x, vitesse_y ; // Vitesse de dplacement en x et y du vaisseau.
	bool    affich_white ; // Indique si on doit ou pas afficher le vaisseau du joueur en blanc.
	bool    visible ; // Indique si le sprite est affich ou non  l'cran.
	short   invincible ; // Indique le nombre de VBLs pendant lesquelles, le vaisseau est invincible.
	short   vbl_invincible ; // Compte le nombre de VBLs pendant lesquelles, le vaisseau est invincible.
	short   nbr_bonus ; // 0  11 indique le niveau de actuel de bonus rammasss par le joueur.
	short   nbr_boules ; // 0  5 indique le nombre de boules qui gravitent autour du vaisseau.
	short   nbr_canons ; // 0  2 indique le nombre de canons qui gravitent autour du vaisseau.
	short 	type_vaisseau ; // 1  1O indique le numro du vaisseau utilis.
	long    score ; // Indique le score du joueur qui est affich sur le panneau de controle corespondant.
	int     cad_tir ; // Corespond au temps qu'il faut au vaisseau avant de pouvoir tirer  nouveau.
	int     tir_spec ; // Corespond au temps qu'il faut au vaisseau avant de pouvoir tirer un tir spcial.
	int     cad_tir_spec ; // Corespond au temps qu'il faut au vaisseau avant de pouvoir tirer un tir spcial.
	long    freeze_tmps ; // Correspond au nombre de VBLs pendant lequel le vaisseau est fig par un tir ennemi figeant.
	short   vit_dep_vaisseau ; // 0 indique que le vaisseau est fig, 1  10 indique la vitesse de dplacement du vaisseau.
	short   power_avant ; // 1  10 indique le numro de l'quipement utilis.
	short   power_arriere ;  // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short   power_droite ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short   power_gauche ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short   power_spec_avant ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short   power_spec_arriere ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short 	power_spec_droite ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	short   power_spec_gauche ; // 0 indique aucun quipement, 1  10 indique le numro de l'quipement utilis.
	// Toutes les variable ci-dessous sont mises  jour par la routine MAJ_Var_Options().
	bool    option_vitesse ; // 0 indique que l'option "vit_dep_vaisseau" n'est pas slectionnable, 1 le contraire.
	bool    option_avant ; // 0 indique que l'option "power_avant" n'est pas slectionnable, 1 le contraire.
	bool    option_arriere ; // 0 indique que l'option "power_arriere" n'est pas slectionnable, 1 le contraire.
	bool    option_droite ; // 0 indique que l'option "power_droite" n'est pas slectionnable, 1 le contraire.
	bool    option_gauche ; // 0 indique que l'option "power_gauche" n'est pas slectionnable, 1 le contraire.
	bool    option_spec_avant ; // 0 indique que l'option "power_spec_avant" n'est pas slectionnable, 1 le contraire.
	bool    option_spec_arriere ; // 0 indique que l'option "power_spec_arriere" n'est pas slectionnable, 1 le contraire.
	bool    option_spec_droite ; // 0 indique que l'option "power_spec_droite" n'est pas slectionnable, 1 le contraire.
	bool    option_spec_gauche ; // 0 indique que l'option "power_spec_gauche" n'est pas slectionnable, 1 le contraire.
	bool    option_type_vaisseau ; // 0 indique que l'option "type_vaisseau" n'est pas slectionnable, 1 le contraire.
	bool		metamorphose ; // Indique si une mtamorphose du vaisseau appartenant au joueur est en train de s'effectuer.
} vaisseau ;

typedef struct fntscroll {
	sprite  spr ; // Structure d'un sprite.
	short   pos_fonte[2] ; // Donne l'indice de progression de la fonte soit sur la courbe, soit sur la grille.
	short		num_courbe ; // Donne le numro de la courbe utilis par la fonte.
	short   num_image ; // Donne le numero de l'image utilisee.
	short   typ_of_scroll ; // Indique le genre de scrolling.
	int			next_object, prev_object ; // Utilis pour le parcour de la liste des tirs.
	bool		clignote ; // Indique si l'on est en prsence d'un sprite clignotant (tir ennemi) ou non.
	bool		dir_x, dir_y ; // Indique si on deplace la lettre dans le sens des x ou des y.
	int			coor_x, coor_y, vitesse ; // Utilis pour le deplacement des fontes qui scrollent.
} fntscroll ;


//inits_game.cpp -----------------------------------------------
int 						inits_game();								//initialisations unique a la creation de notre application
int							etb_read_image(char* _pNomFichier, image* _pImage, unsigned int _iNombreType, unsigned int _iNombreImage) ;
void						etb_affiche_images() ;

void setclav(void) ;
void resetclav(void) ;
void setint21(void) ;
void resetint21(void) ;
void Add_Ve_Special(int val_ve_special) ; // Routine qui ajoute un vaisseau spcial  la liste des vaisseau ennemis.
void Gene_Bonus_Malus(vaisseau_nmi* pve) ; 					//genere un bonus
void Gene_Bonus_Malus_Meteor(vaisseau_nmi* pve) ; 	//genere un bonus ou un malus
float Calc_Angle_Tir(short pxs, short pys, short pxd, short pyd) ; // Calcul un angle en fonction de deux points.
float Calcul_New_Angle( float old_angle, float new_angle, float agilite ) ;
short sign(float); // Retourne -1, 0 ou 1 suivant la valeur passe en argument.
void caraxy(unsigned char caract, short x, short y, unsigned char color, short fond, char *adr, int lar_buf) ;
void textxy(char *chaine, short x, short y, unsigned char color, short fond, char *adr, int lar_buf) ;
unsigned char recherche_couleur (unsigned char  r,unsigned char  g,unsigned char  b) ;
void draw_carre(char *screen, short x, short y, short l, short h, unsigned char coul) ;
int Load_Curve_Level(int) ; // Chargement d'un fichier courbe.
void Find_Tot_Nbr_Vais_Of_Curve(void) ; // Recherche du nombre total de vaisseaux de la courbe.
void Active_Curve_Level(void) ; // Activation d'un fichier courbe.
void read_sprites(char *fichier, int handle, image &rd_img) ; // Lecture du fichier des petits enemis en 16x16.
void Add_Serie_Of_Explosion(int num_nmi) ; // Routine utilise pour ajouter une srie d'explosion  un gros vaisseau.
bool Anim_Player_Level(void) ; // Test si l'affichage du niveau du joueur est dans une phase d'animation.
void Clear_Keyboard(void) ; // Routine utilise afin de mettre  zro toutes les touches du clavier.
void Init_Val_Player_One(void) ; // Routine utilise afin de mettre tous les parametres du joueur  zro.
int Load_Gardien(int) ; // Routine permettant le chargement d'un gardien.
void Apparition_Vaisseau(void) ; // Routine permettant l'apparition  l'can du vaisseau appartenant au joueur.
void Init_Tab_Ve(void) ; // Initialisation du tableau 've'.
void Init_Tab_Tirs(void) ; // Initialisation du tableau 'tirs'.
void Init_Tab_Boules(void) ; // Initialisation du tableau 'bou'.
void Init_Tab_Canons(void) ; // Initialisation du tableau 'can'.
void Aff_Options(int) ; // Routine permettant l'affichage des options.
void Clear_Option(int) ; // Routine permettant l'effacement d'une option.
void Play_Anim_Close_Option(int) ; // Routine qui affiche l'animation de fermeture d'une option du tableau de bord.
void Play_Anim_Open_Option(int) ; // Routine qui affiche l'animation d'ouverture d'une option du tableau de bord.
void Init_Anim_Option(int, bool) ; // Routine utilise pour ouvrir ou fermer une option.
void Aff_Cadre_Selection(int) ; // Affichage du cadre de slection sur l'option slectionne.
void Gere_gardien(int) ; // Gestion des gardiens de fin de niveaux.
bool Gere_Invincibilite_Ve(int) ; // Gestion de l'invincibilit d'un vaisseau ennemi.
void Aff_Ve(int nmi_numero) ; 							//afficher un vaisseau ennemi.
void Aff_Ve2(int nmi_numero) ; 							//affiche le vaisseau du gardien
void Test_Col_Bou_With_Nmi(int) ; // Test les collisions entre les boules du joueur et le vaisseau ennemi.
void Test_Col_Can_With_Nmi(int) ; // Test les collisions entre les canons du joueur et le vaisseau ennemi.
void Test_Col_Player_With_Spec_Nmi(int) ; // Test des collisions entre le joueur et l'ennemi spcial.
void Clignote_Nmi_Avant_Disparition(int) ; // Routine qui indique au vaisseau ennemi de clignoter avant de disparaitre.
//void read_palette(void) ; // Routine permettant de remplir une structure image  partir d'un fichier.
void Fill_Struct_Player_One(void) ; //Routine qui rempli la structure du joueur.

// Routines utilises par les gardiens.
int Meteor_Activity_Less_Guardians() ; // Routine appele pour passer au tableau suivant quand il n'y a pas de gardiens.
void Meteor_Activity_With_Guardian(int) ; // Routine appele pour passer au tableau suivant quand il y a un gardien.
void Fill_Tab_Dep_Gard_Droite(void) ; // Routine qui rempli le tableau des dplacements du gardien de manire  le faire se dplacer vers la droite.
void Fill_Tab_Dep_Gard_Gauche(void) ; // Routine qui rempli le tableau des dplacements du gardien de manire  le faire se dplacer vers la gauche.
void Fill_Tab_Dep_Gard_Haut(void) ; // Routine qui rempli le tableau des dplacements du gardien de manire  le faire se dplacer vers le haut.
void Fill_Tab_Dep_Gard_Bas(void) ; // Routine qui rempli le tableau des dplacements du gardien de manire  le faire se dplacer vers le bas.
void Free_Mem_Gardian(void) ; // Libration de la mmoire utilise par les gardiens.
void Fait_Apparaitre_Gardien_Haut(int) ; // Routine utilise pour faire l'apparition d'un gardien par le haut de l'cran.
void Move_Gardian_Line(int) ; // Routine utilise pour dplacer un gardien en suivant une droite.
void Move_Gardian_Sin(int) ; // Routine utilise pour dplacer un gardien selon un sinus       
int gardien_testFin() ;
void	gardienBarreNRJ() ;
void  _init_gardien12() ; 
void  _init_gardien13() ; 
void  _init_gardien14() ;
void  _execute_gardien12(int) ;
void  _execute_gardien13(int) ;
void  _execute_gardien14(int) ;

// "menu.cpp" ..................................................................
int				Gestion_Menu() ; 					//main menu "menu.cpp"
void			Affich_Menu(int, int ) ; 	//display menu text

// Routines se trouvant  l'origine dans des fichiers include.
//!!!!void Load_Stars(void) ; // Chargement des toiles du starfield.
#ifdef DEVELOPPEMENT
void Grid_Edit(void) ;			//editeur des "grilles"
#endif
int LoadGrid(int num_grid) ; // Routine permettant le chargement d'une grille.
void Active_Grid(void) ; // Activation de la grille charge prcdement.
//!!!!void Load_Enemis(void) ; // Chargement de tous les sprites ennemis utiliss par les courbes et les grilles.
//!!!!void Load_Tirs(void) ; // Chargement de tous les sprites des tirs.
int Load_Meteor(int) ; // Chargement d'un groupe de mtorites bien prcis.
//!!!!! Load_Explos(void) ; // Chargement de toutes les images des explosions.
void Add_Explosion(float, float, float, int, int ) ; // Utiliser pour ajouter une explosion  la liste.
//!!!! Load_Eclats(void) ; // Chargement de toutes les images des clats.
void Add_Eclats(float, float, float, int, int, short ) ; // Utiliser pour ajouter des eclats lors d'une explosion.

//routines utilisees pour la gestion des listes 'tirs'.
int new_element_tir() ;	//ajoute un tir (avec un son)
int New_Element_Tir() ; //ajoute un tir (sans son)
void Del_Element_Tir(int n, int o) ; // Efface le nime lment de la liste 'tirs' et fait les mises  jour ncessaire.


// Routines utilises pour la gestion des listes 've'.
int New_Element_Ve(void) ; // Retourne l'indice dans le tableau 've' d'un nouvel lment de la liste.
void Del_Element_Ve(int n, int o) ; // Efface le nime lment de la liste 've' et fait les mises  jour ncessaire.

// Routines utilises pour la gestion des listes 'xpl'.
int New_Element_Exp(void) ; // Retourne l'indice dans le tableau 'xpl' d'un nouvel lment de la liste.
void Del_Element_Exp(int n, int o) ; // Efface le nime lment de la liste 'xpl' et fait les mises  jour ncessaire.

// Routines utilises pour la gestion des listes 'bou'.
int New_Element_Bou(void) ; // Retourne l'indice dans le tableau 'bou' d'un nouvel lment de la liste.
void Del_Element_Bou(int n, int o) ; // Efface le nime lment de la liste 'bou' et fait les mises  jour ncessaire.

// Routines utilises pour la gestion des listes 'can'.
int New_Element_Can(void) ; // Retourne l'indice dans le tableau 'can' d'un nouvel lment de la liste.
void Del_Element_Can(int n, int o) ; // Efface le nime lment de la liste 'can' et fait les mises  jour ncessaire.

// Routines utilises pour les tirs des vaisseaux normaux du vaisseau 1.
void V1_Tir_Normal_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'avant de puissance 1.
void V1_Tir_Normal_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'avant de puissance 2.
void V1_Tir_Normal_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'avant de puissance 3.
void V1_Tir_Normal_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'avant de puissance 4.
void V1_Tir_Normal_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'avant de puissance 5.
void V1_Tir_Normal_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'arrire de puissance 1.
void V1_Tir_Normal_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'arrire de puissance 2.
void V1_Tir_Normal_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'arrire de puissance 3.
void V1_Tir_Normal_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'arrire de puissance 4.
void V1_Tir_Normal_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  l'arrire de puissance 5.
void V1_Tir_Normal_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  droite de puissance 1.
void V1_Tir_Normal_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  droite de puissance 2.
void V1_Tir_Normal_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  droite de puissance 3.
void V1_Tir_Normal_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  droite de puissance 4.
void V1_Tir_Normal_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  droite de puissance 5.
void V1_Tir_Normal_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  gauche de puissance 1.
void V1_Tir_Normal_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  gauche de puissance 2.
void V1_Tir_Normal_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  gauche de puissance 3.
void V1_Tir_Normal_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  gauche de puissance 4.
void V1_Tir_Normal_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir normal  gauche de puissance 5.

// Routines utilises pour les tirs des vaisseaux spcieaux du vaisseau 1.
void V1_Tir_Special_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'avant de puissance 1.
void V1_Tir_Special_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'avant de puissance 2.
void V1_Tir_Special_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'avant de puissance 3.
void V1_Tir_Special_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'avant de puissance 4.
void V1_Tir_Special_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'avant de puissance 5.
void V1_Tir_Special_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'arrire de puissance 1.
void V1_Tir_Special_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'arrire de puissance 2.
void V1_Tir_Special_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'arrire de puissance 3.
void V1_Tir_Special_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'arrire de puissance 4.
void V1_Tir_Special_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  l'arrire de puissance 5.
void V1_Tir_Special_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  droite de puissance 1.
void V1_Tir_Special_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  droite de puissance 2.
void V1_Tir_Special_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  droite de puissance 3.
void V1_Tir_Special_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  droite de puissance 4.
void V1_Tir_Special_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  droite de puissance 5.
void V1_Tir_Special_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  gauche de puissance 1.
void V1_Tir_Special_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  gauche de puissance 2.
void V1_Tir_Special_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  gauche de puissance 3.
void V1_Tir_Special_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  gauche de puissance 4.
void V1_Tir_Special_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 1 le tir special  gauche de puissance 5.


// Routines utilises pour les tirs des vaisseaux normaux du vaisseau 2.
void V2_Tir_Normal_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'avant de puissance 1.
void V2_Tir_Normal_Avant_P2(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'avant de puissance 2.
void V2_Tir_Normal_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'avant de puissance 3.
void V2_Tir_Normal_Avant_P4(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'avant de puissance 4.
void V2_Tir_Normal_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'avant de puissance 5.
void V2_Tir_Normal_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'arrire de puissance 1.
void V2_Tir_Normal_Arriere_P2(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'arrire de puissance 2.
void V2_Tir_Normal_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'arrire de puissance 3.
void V2_Tir_Normal_Arriere_P4(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'arrire de puissance 4.
void V2_Tir_Normal_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  l'arrire de puissance 5.
void V2_Tir_Normal_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  droite de puissance 1.
void V2_Tir_Normal_Droite_P2(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  droite de puissance 2.
void V2_Tir_Normal_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  droite de puissance 3.
void V2_Tir_Normal_Droite_P4(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  droite de puissance 4.
void V2_Tir_Normal_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  droite de puissance 5.
void V2_Tir_Normal_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  gauche de puissance 1.
void V2_Tir_Normal_Gauche_P2(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  gauche de puissance 2.
void V2_Tir_Normal_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  gauche de puissance 3.
void V2_Tir_Normal_Gauche_P4(int) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  gauche de puissance 4.
void V2_Tir_Normal_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir normal  gauche de puissance 5.

// Routines utilises pour les tirs des vaisseaux spcieaux du vaisseau 2.
void V2_Tir_Special_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'avant de puissance 1.
void V2_Tir_Special_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'avant de puissance 2.
void V2_Tir_Special_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'avant de puissance 3.
void V2_Tir_Special_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'avant de puissance 4.
void V2_Tir_Special_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'avant de puissance 5.
void V2_Tir_Special_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'arrire de puissance 1.
void V2_Tir_Special_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'arrire de puissance 2.
void V2_Tir_Special_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'arrire de puissance 3.
void V2_Tir_Special_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'arrire de puissance 4.
void V2_Tir_Special_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  l'arrire de puissance 5.
void V2_Tir_Special_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  droite de puissance 1.
void V2_Tir_Special_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  droite de puissance 2.
void V2_Tir_Special_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  droite de puissance 3.
void V2_Tir_Special_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  droite de puissance 4.
void V2_Tir_Special_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  droite de puissance 5.
void V2_Tir_Special_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  gauche de puissance 1.
void V2_Tir_Special_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  gauche de puissance 2.
void V2_Tir_Special_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  gauche de puissance 3.
void V2_Tir_Special_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  gauche de puissance 4.
void V2_Tir_Special_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 2 le tir special  gauche de puissance 5.


// Routines utilises pour les tirs des vaisseaux normaux du vaisseau 3.
void V3_Tir_Normal_Avant_P1(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'avant de puissance 1.
void V3_Tir_Normal_Avant_P2(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'avant de puissance 2.
void V3_Tir_Normal_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'avant de puissance 3.
void V3_Tir_Normal_Avant_P4(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'avant de puissance 4.
void V3_Tir_Normal_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'avant de puissance 5.
void V3_Tir_Normal_Arriere_P1(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'arrire de puissance 1.
void V3_Tir_Normal_Arriere_P2(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'arrire de puissance 2.
void V3_Tir_Normal_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'arrire de puissance 3.
void V3_Tir_Normal_Arriere_P4(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'arrire de puissance 4.
void V3_Tir_Normal_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  l'arrire de puissance 5.
void V3_Tir_Normal_Droite_P1(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  droite de puissance 1.
void V3_Tir_Normal_Droite_P2(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  droite de puissance 2.
void V3_Tir_Normal_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  droite de puissance 3.
void V3_Tir_Normal_Droite_P4(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  droite de puissance 4.
void V3_Tir_Normal_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  droite de puissance 5.
void V3_Tir_Normal_Gauche_P1(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  gauche de puissance 1.
void V3_Tir_Normal_Gauche_P2(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  gauche de puissance 2.
void V3_Tir_Normal_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  gauche de puissance 3.
void V3_Tir_Normal_Gauche_P4(int) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  gauche de puissance 4.
void V3_Tir_Normal_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir normal  gauche de puissance 5.

// Routines utilises pour les tirs des vaisseaux spcieaux du vaisseau 3.
void V3_Tir_Special_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'avant de puissance 1.
void V3_Tir_Special_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'avant de puissance 2.
void V3_Tir_Special_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'avant de puissance 3.
void V3_Tir_Special_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'avant de puissance 4.
void V3_Tir_Special_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'avant de puissance 5.
void V3_Tir_Special_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'arrire de puissance 1.
void V3_Tir_Special_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'arrire de puissance 2.
void V3_Tir_Special_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'arrire de puissance 3.
void V3_Tir_Special_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'arrire de puissance 4.
void V3_Tir_Special_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  l'arrire de puissance 5.
void V3_Tir_Special_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  droite de puissance 1.
void V3_Tir_Special_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  droite de puissance 2.
void V3_Tir_Special_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  droite de puissance 3.
void V3_Tir_Special_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  droite de puissance 4.
void V3_Tir_Special_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  droite de puissance 5.
void V3_Tir_Special_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  gauche de puissance 1.
void V3_Tir_Special_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  gauche de puissance 2.
void V3_Tir_Special_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  gauche de puissance 3.
void V3_Tir_Special_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  gauche de puissance 4.
void V3_Tir_Special_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 3 le tir special  gauche de puissance 5.


// Routines utilises pour les tirs des vaisseaux normaux du vaisseau 4.
void V4_Tir_Normal_Avant_P1(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'avant de puissance 1.
void V4_Tir_Normal_Avant_P2(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'avant de puissance 2.
void V4_Tir_Normal_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'avant de puissance 3.
void V4_Tir_Normal_Avant_P4(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'avant de puissance 4.
void V4_Tir_Normal_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'avant de puissance 5.
void V4_Tir_Normal_Arriere_P1(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'arrire de puissance 1.
void V4_Tir_Normal_Arriere_P2(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'arrire de puissance 2.
void V4_Tir_Normal_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'arrire de puissance 3.
void V4_Tir_Normal_Arriere_P4(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'arrire de puissance 4.
void V4_Tir_Normal_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  l'arrire de puissance 5.
void V4_Tir_Normal_Droite_P1(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  droite de puissance 1.
void V4_Tir_Normal_Droite_P2(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  droite de puissance 2.
void V4_Tir_Normal_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  droite de puissance 3.
void V4_Tir_Normal_Droite_P4(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  droite de puissance 4.
void V4_Tir_Normal_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  droite de puissance 5.
void V4_Tir_Normal_Gauche_P1(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  gauche de puissance 1.
void V4_Tir_Normal_Gauche_P2(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  gauche de puissance 2.
void V4_Tir_Normal_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  gauche de puissance 3.
void V4_Tir_Normal_Gauche_P4(int) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  gauche de puissance 4.
void V4_Tir_Normal_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir normal  gauche de puissance 5.

// Routines utilises pour les tirs des vaisseaux spcieaux du vaisseau 4.
void V4_Tir_Special_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'avant de puissance 1.
void V4_Tir_Special_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'avant de puissance 2.
void V4_Tir_Special_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'avant de puissance 3.
void V4_Tir_Special_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'avant de puissance 4.
void V4_Tir_Special_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'avant de puissance 5.
void V4_Tir_Special_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'arrire de puissance 1.
void V4_Tir_Special_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'arrire de puissance 2.
void V4_Tir_Special_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'arrire de puissance 3.
void V4_Tir_Special_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'arrire de puissance 4.
void V4_Tir_Special_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  l'arrire de puissance 5.
void V4_Tir_Special_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  droite de puissance 1.
void V4_Tir_Special_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  droite de puissance 2.
void V4_Tir_Special_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  droite de puissance 3.
void V4_Tir_Special_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  droite de puissance 4.
void V4_Tir_Special_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  droite de puissance 5.
void V4_Tir_Special_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  gauche de puissance 1.
void V4_Tir_Special_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  gauche de puissance 2.
void V4_Tir_Special_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  gauche de puissance 3.
void V4_Tir_Special_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  gauche de puissance 4.
void V4_Tir_Special_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 4 le tir special  gauche de puissance 5.


// Routines utilises pour les tirs des vaisseaux normaux du vaisseau 5.
void V5_Tir_Normal_Avant_P1() ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'avant de puissance 1.
void V5_Tir_Normal_Avant_P2(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'avant de puissance 2.
void V5_Tir_Normal_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'avant de puissance 3.
void V5_Tir_Normal_Avant_P4(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'avant de puissance 4.
void V5_Tir_Normal_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'avant de puissance 5.
void V5_Tir_Normal_Arriere_P1() ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'arrire de puissance 1.
void V5_Tir_Normal_Arriere_P2(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'arrire de puissance 2.
void V5_Tir_Normal_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'arrire de puissance 3.
void V5_Tir_Normal_Arriere_P4(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'arrire de puissance 4.
void V5_Tir_Normal_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  l'arrire de puissance 5.
void V5_Tir_Normal_Droite_P1() ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  droite de puissance 1.
void V5_Tir_Normal_Droite_P2(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  droite de puissance 2.
void V5_Tir_Normal_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  droite de puissance 3.
void V5_Tir_Normal_Droite_P4(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  droite de puissance 4.
void V5_Tir_Normal_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  droite de puissance 5.
void V5_Tir_Normal_Gauche_P1() ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  gauche de puissance 1.
void V5_Tir_Normal_Gauche_P2(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  gauche de puissance 2.
void V5_Tir_Normal_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  gauche de puissance 3.
void V5_Tir_Normal_Gauche_P4(int) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  gauche de puissance 4.
void V5_Tir_Normal_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir normal  gauche de puissance 5.

// Routines utilises pour les tirs des vaisseaux spcieaux du vaisseau 5.
void V5_Tir_Special_Avant_P1(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'avant de puissance 1.
void V5_Tir_Special_Avant_P2(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'avant de puissance 2.
void V5_Tir_Special_Avant_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'avant de puissance 3.
void V5_Tir_Special_Avant_P4(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'avant de puissance 4.
void V5_Tir_Special_Avant_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'avant de puissance 5.
void V5_Tir_Special_Arriere_P1(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'arrire de puissance 1.
void V5_Tir_Special_Arriere_P2(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'arrire de puissance 2.
void V5_Tir_Special_Arriere_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'arrire de puissance 3.
void V5_Tir_Special_Arriere_P4(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'arrire de puissance 4.
void V5_Tir_Special_Arriere_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  l'arrire de puissance 5.
void V5_Tir_Special_Droite_P1(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  droite de puissance 1.
void V5_Tir_Special_Droite_P2(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  droite de puissance 2.
void V5_Tir_Special_Droite_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  droite de puissance 3.
void V5_Tir_Special_Droite_P4(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  droite de puissance 4.
void V5_Tir_Special_Droite_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  droite de puissance 5.
void V5_Tir_Special_Gauche_P1(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  gauche de puissance 1.
void V5_Tir_Special_Gauche_P2(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  gauche de puissance 2.
void V5_Tir_Special_Gauche_P3(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  gauche de puissance 3.
void V5_Tir_Special_Gauche_P4(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  gauche de puissance 4.
void V5_Tir_Special_Gauche_P5(void) ; // Routine utilise pour ajouter au vaisseau 5 le tir special  gauche de puissance 5.

//Routines utilisees pour la gestion des fontes qui scrollent.
int New_Element_FS(void) ; // Retourne l'indice dans le tableau des fontes qui scrollent d'un nouvel lment de la liste.
void Del_Element_FS(int n, int o) ; // Efface le nime lment de la liste et fait les mises  jour ncessaire.
void Gestion_Fontes_Ki_Scrollent(void) ; // Routine utilisee pour la gestion des fontes qui scrollent.
void Init_Scroll_Present(void) ; 												//initialise le texte defilant
void Destruct_Scroll_Font(int d) ; 											//supprime le texte defilant

// "meteors.cpp"
void	meteor_execution() ;
int		meteor_initialise() ;
void	meteor_libere() ;
// "options.cpp"
void	option_execution() ;
void testBoutonOption() ;
// "courbe.cpp"
void	courbe_execution() ;
void	courbe_testFin() ;
#ifdef DEVELOPPEMENT
void	courbe_editeur() ;
#endif

//"grille.cpp" .................................................................
void grille_execution() ;
void grille_testFin() ;

//"bonus.cpp" ..................................................................
void bonus_execution() ;
void ajoute_boule() ;

//"vaisseau.cpp" ...............................................................
void						vaisseau_restaure() ;
void						vaisseau_invincibilite() ;
void						boule_execution() ;
void						canon_execution() ;
// "ennemis_execution.cpp" .....................................................
void						ennemis_execution() ;
inline float		Deplacement_Tir_X( float angle, float vitesse, float x ) ;
inline float		Deplacement_Tir_Y( float angle, float vitesse, float y ) ;

void						finiObjects() ;
void						Keys_Down(unsigned int) ;
void						Keys_Up(unsigned int) ;
void						draw_eclair(char*,Eclair*,int);
unsigned int		doInit() ;
void						finiObjects() ;
void						_initialiseGameOver()	;		//(ETB)
void						tirsJoueur() ;
void						afficheEtoiles() ;
void						eclairExecution() ;
void						explosionExecution() ;
void						tirsExecutions() ;
#ifdef DEVELOPPEMENT
void						touchesTriches() ;
#endif

//seal : synthetic audio library ...............................................
#ifdef UTILISE_SEAL
#include "AUDIO.H"
#if defined(_MSC_VER) || defined(__BORLANDC__) || defined(__WATCOMC__) || defined(__DJGPP__)
#include <conio.h>
#else
#define					kbhit() 0
#endif
int							seal_init() ;
void						seal_exec() ;
int							seal_JoueModule(int) ;
void						seal_kill() ;
void						seal_joue(unsigned int);		
#define 				VCHANGE1				0				//change de vaisseau (progression)
#define 				VCHANGE2				1				//change de vaisseau (regression)
#define 				SELECT					2				//option selectionnee (dans le tableau)
#define 				NOSELECT				3				//option selectionnee (mais il n'ya rien a selectionner)
#define 				BONUS4					4				//bonus violet
#define 				BONUS3					5				//bonus jaune
#define 				BONUS1					6				//bonus vert 	
#define 				BONUS2					7				//bonus rouge
#define 				SPECNMI					8				//ennemi special arrive
#define 				ONDE_CHOC				9				//onde de choc (bonus violet si l'energie du vaisseau est au maximum
#define 				TIR2						10			//tir vaisseau joueur
#define 				TIR1						11			//tir vaisseau joueur
#define					XPLOC1					12			//explosion 64*64
#define 				XPLOC2					13			//explosion 64*64
#define					XPLOC3					14			//explosion 64*64
#define					XPLOC4					15			//explosion 64*64
#define					XPLOB1					16			//explosion 32*32
#define					XPLOB2					17			//explosion 32*32
#define					XPLOB3					18			//explosion 32*32
#define					XPLOB4					19			//explosion 32*32
#define					XPLOA1					20			//explosion 16*16
#define					XPLOA2					21			//explosion 16*16
#define					XPLOA3					22 			//explosion 16*16
#define					XPLOA4					23			//explosion 16*16
#define					TIR1NMI					24			//tir ennemi 1
#define 				TIR2NMI					25			//tir ennemi 2
#define					TIR3NMI					26			//tir ennemi 3 (gardien)
#define					TIR4NMI					27			//tir ennemi 4 (gardien)
#endif

// "gfxbase.cpp"  ...............................................................
void		putsprcolor(unsigned int _iColor, image* _pImage, unsigned int _iX, unsigned int _iY) ;
void 		putsprite3(image* _pImage, unsigned int _iX, unsigned int _iY) ;
void 		putsprite3(fonte* _pFonte, unsigned int _iX, unsigned int _iY) ;
void 		poke(char *adresse, unsigned char valeur) ;
void 		putpixel(char* _pAdresse, int x, int y, int coul) ;
void 		_putRectangleVide(char* adresse, int x, int y, int coul, int large, int haute) ;
void	 	_ASMCOPYFONTE(unsigned char* dst, unsigned char* src) ;
void 		putsprite3_scr(fonte* _pFonte, unsigned int _iX, unsigned int _iY) ;
void 		putsprite3_opt(fonte* _pFonte, unsigned int _iX, unsigned int _iY) ;
void 		putsprite3_scr(image* _pImage, unsigned int _iX, unsigned int _iY) ;
void		copy2X_512x440(char*, char*, unsigned int) ;
void		copy2X(char*, char*, unsigned int _iLarge, unsigned int _iHaut, unsigned int _iOffset, unsigned int _iOffset2) ;

// "powermanga.cpp" .............................................................
int UpdateFrame() ;																				//main loop

// "playanim.cpp"  ..............................................................
int							joueAnimation() ;													//play animation compressed by Etienne Sobole

// "displayFonte.cpp" ............................................................
void						Aff_Score_Player_One() ;									//display player's score
void						Aff_Level_Player_One() ;									//display level number
void						Aff_Game_Pause_Player_One() ; 						//display "PAUSE"
void						initializeFonte() ;												//initialise fontes's structures
void						update_bar_nrj_player() ;

// "onde.cpp" (shock wave) ....................................................... 
void						Draw_Onde_De_Choc() ; 										//display shock wave to the screen
int							New_Element_Onde_Choc() ;
void						Del_Element_Onde_Choc(int n, int o) ;
void						Init_Tab_OndeChoc() ; 										//initialize table "onde_choc"
bool						Tst_Col_Onde_Choc(int) ;
void						polygone(char*,int*,int,unsigned int) ;
//..............................................................................
#include "linux.hpp"
#include "_etb.hpp"
#include "_score.hpp"		
#include "assembler.h"
#include "_etbfonte1.hpp"
#include "_score.hpp"
#include "_etb.hpp"	
#include "xfree.hpp"
#include "firstwindow.hpp"
#endif

