#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifndef	linux
#include <net/if.h>
#ifndef	if_mtu
#include <net/if_var.h>
#endif
#include <netinet/if_ether.h>
#endif
#include <arpa/inet.h>
#include <netdb.h>

#include <config.h>
#include <support.h>

#include "device.h"

#include <option.h>
#include <log.h>

static int
TcpOpen(char **devname, int *status, int argc, char *argv[])
{
    struct sockaddr_in sa;
    struct hostent *hp;
    int sd;
    char *host, *port, *p;

    if ((p = strchr(devname[0], '/')) == NULL) {
	*status = OPEN_FAILED;
	return(-1);
    }
    p ++;
    if (*p == '/') p ++;
    host = Strdup(p);
    if ((port = strchr(host, ':')) == NULL) {
	*status = OPEN_FAILED;
	return(-1);
    }
    *port = '\0'; port ++;
    if ((hp = gethostbyname(host)) == NULL) {
	LogError("TcpOpen gethostbyname");
	free(host);
	*status = OPEN_FAILED;
	return(-1);
    }
    memcpy(&sa.sin_addr, (struct in_addr *)hp->h_addr, sizeof(sa.sin_addr));
    sa.sin_family = AF_INET;
    sa.sin_port = htons(atoi(port));
    free(host);
    if ((sd = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	LogError("TcpOpen socket");
	*status = OPEN_FAILED;
	return(-1);
    }
    if (connect(sd, (struct sockaddr *)&sa, sizeof(sa)) < 0) {
	LogError("TcpOpen connect");
	*status = OPEN_FAILED;
	return(-1);
    }
    return(sd);
}

static void
TcpClose(int sd)
{
    if (sd >= 0) Close(sd);
}

static bool_t
TcpProbe(char *name)
{
    return(strncasecmp(name, "tcp:", 4) ? FALSE: TRUE);
}

void
TcpSetup()
{
    static struct device_s dev={
	NULL, TcpProbe, TcpOpen, AsyncWrite, AsyncRead, TcpClose, NULL
    };
    RegisterDevice(&dev);
}
