#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>

#include <config.h>
#include <support.h>
#include <account.h>

#include "option.h"
#include "frame.h"
#include "auth.h"
#include "console.h"
#include "command.h"
#include "log.h"
#include "env.h"

/*#include <tcio.h>*/

struct pppopt_s pppOpt;

static const char *loadFilePath="conf";

static char loadBuf[BUFSIZ];

const char *
SetLoadFilePath(const char *new)
{
    const char *old;

    old = loadFilePath;
    loadFilePath = new;
    return(old);
}

FILE *
OpenFile(char *name, const char *dir, int *secure)
{
    FILE *fp=NULL;
    struct stat st;
    char tmp[256];

    if (*name == '!') {
	*secure |= EXEC_POPEN;
	name ++;
    } else if (*name == '/') {
	*secure |= EXEC_SECURE;
	name ++;
    }
    if (!(*secure & EXEC_SECURE) && usrPPxP) {
	if (dir) sprintf(tmp, "%s/%s/%s", usrPPxP, dir, name);
	else sprintf(tmp, "%s/%s", usrPPxP, name);
	if (*secure & EXEC_POPEN) {
	    if (!access(tmp, X_OK)) fp = popen(tmp, "r");
	} else fp = fopen(tmp, "r");
	*secure &= ~EXEC_SECURE;
    }
    if (fp == NULL) {
	if (dir) sprintf(tmp, "%s/%s/%s", sysPPxP, dir, name);
	else sprintf(tmp, "%s/%s", sysPPxP, name);
	SuperPrivilege(TRUE);
	if (*secure & EXEC_POPEN) {
	    if (!access(tmp, X_OK)) fp = popen(tmp, "r");
	} else fp = fopen(tmp, "r");
	if (fp != NULL) *secure |= EXEC_SECURE;
	SuperPrivilege(FALSE);
    }
    if (!fp) LogError(tmp);
    else if (ISLOG(LOG_OS))
	Logf(LOG_OS, "%copen(%s) OK\n",
	     (*secure & EXEC_POPEN) ? 'p': 'f', tmp);
    return(fp);
}

int
LoadFile(FILE *fp, int (*proc)(), int secure, void *arg)
{
    char *p, *buf, *endp;
    int retval=0;

    buf = loadBuf;
    endp = loadBuf + sizeof(loadBuf) - 1;
    while (!retval && fgets(buf, endp - buf, fp)) {
	p = buf + strlen(buf) - 1;
	while ((p > buf) && strchr("\r\n \t", *p)) p --;
	if (p <= buf) continue;
	if (*p == '\\') {
	    *p = ' ';
	    buf = p + 1;
	    continue;
	}
	p = loadBuf;
	while (*p && strchr("\t ", *p)) p ++;
	if (p && *p && *p != '#') retval = proc(p, secure, arg);
	buf = loadBuf;
    }
    if (secure & EXEC_POPEN) pclose(fp);
    else fclose(fp);
    return(retval);
}

static int
ConfFileProc(char *line, int secure)
{
    RunCommandLine(line, secure ? EXEC_SECURE: 0);
    return(0);
}

int
LoadScriptFile(char *name)
{
    int secure=0;
    FILE *fp;

    fp = OpenFile(name, loadFilePath, &secure);
    return(fp ? LoadFile(fp, ConfFileProc, secure, NULL): -1);
}

int
LoadOption(int argc, char *argv[])
{
    int a;
    char *ev[]={"set", "NAME", ""};
    bool_t copy=FALSE;

    for (a = 1; a < argc; a ++) {
	if (!pppOpt.name) {
	    ev[2] = argv[a];
	    EnvSet(3, ev);
	    copy = TRUE;
	}
	if (LoadScriptFile(argv[a]) < 0 && copy) {
	    Free(pppOpt.name);
	    pppOpt.name = NULL;
	}
	copy = FALSE;
    }
    if (!pppOpt.a_entry) {
	ev[1] = "AUTH.PASSWD";
	ev[2] = pppOpt.name;
	EnvSet(3, ev);
    }
    return(0);
}

int
SaveOption(int argc, char *argv[])
{
    FILE *fp;

    if (argc < 2) return(-1);
    sprintf(loadBuf, "%s/conf/%s", getuid() ? usrPPxP: sysPPxP, argv[1]);
    if ((fp = fopen(loadBuf, "w")) == NULL) {
	LogError(loadBuf);
	return(-1);
    }
    AllEnvPrint(fp, ENV_RDONLY);
    fclose(fp);
    chown(loadBuf, getuid(), getgid());
    return(0);
}

int
AccountLogWrite(bool_t start)
{
    struct accrec_s acc;
    int fd;
    static u_int32_t accId;

    if (!start && !accId) return(-1);
    memset(&acc, 0, sizeof(acc));
    SuperPrivilege(TRUE);
    fd = open(_PATH_PPXP_ACC, O_APPEND|O_WRONLY|O_CREAT, 0644);
    SuperPrivilege(FALSE);
    if (fd < 0) {
	LogError(_PATH_PPXP_ACC);
	return(-1);
    }
    if (start) {
	struct stat st;

	fstat(fd, &st);
	acc.uid = geteuid();
	acc.pid = getpid();
	accId = (u_int32_t)(st.st_size / sizeof(struct accrec_s)) + 1;
	acc.aid = accId;
    } else {
	acc.aid = accId;
	accId = 0;
    }
    strncpy(acc.name, pppOpt.name ? pppOpt.name: "?", LEN_ACC_NAME);
    time(&(acc.time.sec));
    write(fd, (char *)&acc, sizeof(acc));
    close(fd);
    return(0);
}

int
LastLogWrite(bool_t start)
{
    static char *lastLine;
    int ret;
    char *user, *host;

    user = host = NULL;
    if (start) {
	char *p;

	p = AuthName();
	if (!p) return(0);
	user = Strdup(p);
	if (pppOpt.line) {
	    if ((p = strrchr(*pppOpt.line, '/')) != NULL) p ++;
	    else p = *pppOpt.line;
	} else p = "redirect"; /* ;-< */
	if (lastLine) Free(lastLine);
	lastLine = Strdup(p);
	if (pppOpt.name) host = Strdup(pppOpt.name);
    } else if (!lastLine) return(0);
    SuperPrivilege(TRUE);
    ret = SysWtmp(lastLine, user, host);
    SuperPrivilege(FALSE);
    if (host) Free(host);
    if (user) Free(user);
    if (!start) {
	Free(lastLine);
	lastLine = NULL;
    }
    return(ret);
}
