#/bin/sh -e
#
# $Cambridge: hermes/src/prayer/files/install.sh,v 1.7 2008/09/16 09:59:56 dpc22 Exp $

PATH=/bin:/sbin/:/usr/bin:/usr/sbin

error=0

if [ "x$PREFIX" = "x" ]; then
    echo 'PREFIX not defined'
    error=1
fi

if [ "x$VAR_PREFIX" = "x" ]; then
    echo 'VAR_PREFIX not defined'
    error=1
fi

if [ "x$RO_USER" = "x" ]; then
    echo 'RO_USER not defined'
    error=1
fi

if [ "x$RO_GROUP" = "x" ]; then
    echo 'RO_GROUP not defined'
    error=1
fi

if [ "x$RW_USER" = "x" ]; then
    echo 'RW_USER not defined'
    error=1
fi

if [ "x$RW_GROUP" = "x" ]; then
    echo 'RW_GROUP not defined'
    error=1
fi

if [ "x$PUBLIC_DIR" = "x" ]; then
    echo 'PUBLIC_DIR not defined'
    error=1
fi

if [ "x$PRIVATE_DIR" = "x" ]; then
    echo 'PRIVATE_DIR not defined'
    error=1
fi

if [ "x$BIN_DIR" = "x" ]; then
    echo 'BIN_DIR not defined'
    error=1
fi

if [ $error != 0 ]; then
    exit 1
fi

if [ ! -d ${VAR_PREFIX} -a `whoami` = "root" ]; then
    ${INSTALL} -d -o ${RW_USER} -g ${RW_GROUP} -m ${PRIVATE_DIR} ${VAR_PREFIX}
fi

if [ ! -d ${PREFIX} ]; then
    ${INSTALL} -d -o ${RO_USER} -g ${RO_GROUP} -m ${PUBLIC_DIR} ${PREFIX}
fi

if [ ! -d ${PREFIX}/etc ]; then
    ${INSTALL} -d -o ${RO_USER} -g ${RO_GROUP} -m ${PUBLIC_DIR} ${PREFIX}/etc
fi

if [ ! -d ${PREFIX}/certs ]; then
    ${INSTALL} -d -o ${RO_USER} -g ${RO_GROUP} -m ${PRIVATE_DIR} ${PREFIX}/certs
fi

if [ ! -d ${BIN_DIR} ]; then
    ${INSTALL} -d -o ${RO_USER} -g ${RO_GROUP} -m ${PUBLIC_DIR} ${BIN_DIR}
fi

for i in icons static
do
    if [ -d "${PREFIX}/${i}" ]; then
        echo Removing old ${i}
        rm -rf ${PREFIX}/${i}
    fi
    echo Copying ${i}
    (tar cf - ${i}) | (cd ${PREFIX} ; tar xf -)
    (cd ${PREFIX}; chown -R ${RO_USER}:${RO_GROUP} ${i})
done
