/*****
*
* Copyright (C) 1998 - 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


/*
 * This file is to be included by Detect Plugins.
 */

/*
 * NOTE: On some systems (namely FreeBSD) including this file leads to
 * including <sys/queue.h>. If you include also <libprelude/list.h>
 * in your code that will cause a conflict of LIST_HEAD macro
 * from <libprelude/list.h> and <sys/queue.h>. Therefore you should include
 * this file ALWAYS BEFORE <libprelude/list.h> so the macro defined in
 * <libprelude/list.h> takes precedence. Also see comment in
 * <libprelude/list.h>
 */

#include <stdarg.h>


/*
 * Definition of the packet structure,
 * which is passed to detection plugins.
 */
#include "packet.h"

/*
 * Definition of the common and detect plugin type.
 */
#include <libprelude/prelude-log.h>
#include <libprelude/plugin-common.h>

/*
 * extraction function, handling alignment issue
 */
#include <libprelude/extract.h>

#include "plugin-detect.h"


/*
 * Definition of some operation on packet
 */
#include "packet-decode.h"

/*
 * Definition of the timer API.
 */
#include <libprelude/timer.h>

/*
 * Definition of the host database API,
 * that permit detection plugin to have a persistant state.
 */
#include "hostdb.h"


/*
 * Definition of plugin configuration API.
 */
#include <libprelude/config-engine.h>



/*
 * Id for Prelude NIDS related alert.
 */
#include "nids-alert-id.h"


/*
 * Definition of Prelude NIDS specific alert generation functions.
 */
#include "nids-alert.h"

#include <libprelude/prelude-getopt.h>

#include <libprelude/idmef-message-id.h>

#include <libprelude/sensor.h>
