/*****
*
* Copyright (C) 2001 Jeremie Brebec <flagg@ifrance.com>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Jeremie Brebec <flagg@ifrance.com>
*
*****/


#ifndef RULES_H
#define RULES_H

#include "packet.h"

typedef int (*match_packet_f_t)(packet_container_t *packet, void *set);


/*
 * typed variable
 */
typedef struct {
	int id;
	void *set;
} var_t;




/*
 * tests, set of typed variable
 */
typedef struct _test {
	int inversed; /* test 'not' */
	var_t var;
	struct _test *next;
} test_t;




/*
 * data, abstract
 */ 
typedef struct _data {
	int id;
	void *data;
	struct _data *next;
} data_t;




/*
 * leaf_match, last functions called after the tree matching
 */
typedef int (*leaf_match_f_t)(packet_container_t *packet, void *data);
typedef struct l_leaf_match {
        var_t var;
        int inversed;
        leaf_match_f_t leaf_match;
	struct l_leaf_match *next;
} l_leaf_match_t;



/*
 * function called when the packet match a rule
 */
typedef void (*run_f_t)(packet_container_t *packet, data_t *data);
typedef struct l_run {

        /*
         * Pointer on a function to call (that'll issue an alert).
         */
        run_f_t run;
        data_t *data;
	l_leaf_match_t *leaf_match;

	struct l_run *next;
} l_run_t;




/*
 * rule, tests and set of abstract data (msg, reference, etc..)
 */
typedef struct _rule {
	data_t *data;
	l_leaf_match_t *leaf_match;

	test_t *test;

} rule_t;




/*
 * rules, set of rule
 */
typedef struct _rules {
	rule_t *rule;
	struct _rules *next;
} rules_t;




/*
 * rule node
 */
#define ID_ROOT_NODE     -1
#define ID_LEAF_NODE     -2
#define ID_IGNORE_NODE   -3 

typedef struct _rules_node_t {
        
	int ref; /* refcount */

	struct _rules_node_t *brother;
	struct _rules_node_t *child;

	match_packet_f_t match_packet;
	l_run_t *run;
	var_t var;

} rules_node_t;


/*
 * add rule(s) to the tree
 */
int signature_engine_add_rules(rules_node_t *root, rules_t *rules, run_f_t run);


/*
 * find matching rules
 */
void signature_engine_process_packet(rules_node_t *root, packet_container_t *packet);
				   
#endif
