//
//  PRCScale.m
//  PRICE
//
//  Created by Riccardo Mottola on Wed Jan 19 2005.
//  Copyright (c) 2005 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <math.h>
#import "PRCScale.h"
#import "PRScale.h"
#import "MyDocument.h"


@implementation PRCScale

- (IBAction)changePixelsX:(id)sender
{
    pixelsX = [pixelsXField intValue];
    [percentXField setFloatValue:((float)pixelsX / oldPixelsX *100)];
    if ([uniformToggle intValue])
    {
        pixelsY = (int)rint(pixelsX * ratio);
        [pixelsYField setIntValue:pixelsY];
        [percentYField setFloatValue:[percentXField floatValue]];
    }
}

- (IBAction)changePixelsY:(id)sender
{
    pixelsY = [pixelsYField intValue];
    [percentYField setFloatValue:((float)pixelsY / oldPixelsY *100)];
    if ([uniformToggle intValue])
    {
        pixelsX = (int)rint(pixelsY / ratio);
        [pixelsXField setIntValue:pixelsX];
        [percentXField setFloatValue:[percentYField floatValue]];
    }
}

- (IBAction)changePercentX:(id)sender
{
    float percentX;

    percentX = [percentXField floatValue];
    pixelsX = (int)rint(oldPixelsX * (percentX / 100));
    [pixelsXField setIntValue:pixelsX];
    if ([uniformToggle intValue])
    {
        pixelsY = (int)rint(pixelsX * ratio);
        [pixelsYField setIntValue:pixelsY];
        [percentYField setFloatValue:percentX];
    }
}

- (IBAction)changePercentY:(id)sender
{
    float percentY;

    percentY = [percentYField floatValue];
    pixelsY = (int)rint(oldPixelsY * (percentY / 100));
    [pixelsYField setIntValue:pixelsY];
    if ([uniformToggle intValue])
    {
        pixelsX = (int)rint(pixelsY / ratio);
        [pixelsXField setIntValue:pixelsX];
        [percentXField setFloatValue:percentY];
    }
}

- (IBAction)showScale:(id)sender
{
    if (!scaleWindow)
        [NSBundle loadNibNamed:@"Scale" owner:self];
    [scaleWindow makeKeyAndOrderFront:nil];
    pixelsX = [[[[NSDocumentController sharedDocumentController] currentDocument] activeImage] width];
    pixelsY = [[[[NSDocumentController sharedDocumentController] currentDocument] activeImage] height];
    oldPixelsX = pixelsX;
    oldPixelsY = pixelsY;
    ratio = (float)pixelsY / (float)pixelsX;
    [pixelsXField setIntValue:pixelsX];
    [pixelsYField setIntValue:pixelsY];
    [percentXField setFloatValue:100];
    [percentYField setFloatValue:100];
}

- (IBAction)scaleOK:(id)sender
{
    PRCProgress *filterProgr;
    int         method;

    NSLog(@"tag %d", [[methodSelect selectedItem] tag]);
    switch ([[methodSelect selectedItem] tag])
    {
        case 0:
            method = NEAREST_NEIGHBOUR;
            break;
        case 1:
            method = LINEAR_HV;
            break;
        default:
            method = NEAREST_NEIGHBOUR;
            NSLog(@"Unexpected value for method in scale");
    }
    NSLog(@"method %d", method);
    filterProgr = [[PRCProgress alloc] init];
    [filterProgr showProgress:self];
    [filterProgr setTitle: @"Scale"];

    /* read pixels value again */
    pixelsX = [pixelsXField intValue];
    pixelsY = [pixelsYField intValue];

    [[[NSDocumentController sharedDocumentController] currentDocument] makeScale :pixelsX :pixelsY :method :filterProgr];
    [filterProgr release];
    
    if ([[NSApp delegate] prefClosePanels])
        [scaleWindow performClose:nil];
}

- (IBAction)scaleCancel:(id)sender
{
    [scaleWindow performClose:nil];
}

@end
