/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.io.PrintStream;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.preverification.DoubleType;
import proguard.classfile.attribute.preverification.FloatType;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.IntegerType;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.LongType;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.NullType;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.TopType;
import proguard.classfile.attribute.preverification.UninitializedThisType;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassPrinter
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
ExceptionInfoVisitor,
InnerClassesInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private static final String INDENTATION = "  ";
    private final PrintStream ps;
    private int indentation;

    public ClassPrinter() {
        this(System.out);
    }

    public ClassPrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.println("_____________________________________________________________________");
        this.println(this.visitorInfo(programClass) + " " + "Program class: " + programClass.getName());
        this.indent();
        this.println("Superclass:    " + programClass.getSuperName());
        this.println("Major version: 0x" + Integer.toHexString(ClassUtil.internalMajorClassVersion(programClass.u4version)));
        this.println("Minor version: 0x" + Integer.toHexString(ClassUtil.internalMinorClassVersion(programClass.u4version)));
        this.println("Access flags:  0x" + Integer.toHexString(programClass.u2accessFlags));
        this.println("  = " + ((programClass.u2accessFlags & 0x2000) != 0 ? "@ " : "") + ClassUtil.externalClassAccessFlags(programClass.u2accessFlags) + ((programClass.u2accessFlags & 0x4000) != 0 ? "enum " : ((programClass.u2accessFlags & 0x200) == 0 ? "class " : "")) + ClassUtil.externalClassName(programClass.getName()) + (programClass.u2superClass == 0 ? "" : " extends " + ClassUtil.externalClassName(programClass.getSuperName())));
        this.outdent();
        this.println();
        this.println("Interfaces (count = " + programClass.u2interfacesCount + "):");
        this.indent();
        programClass.interfaceConstantsAccept(this);
        this.outdent();
        this.println();
        this.println("Constant Pool (count = " + programClass.u2constantPoolCount + "):");
        this.indent();
        programClass.constantPoolEntriesAccept(this);
        this.outdent();
        this.println();
        this.println("Fields (count = " + programClass.u2fieldsCount + "):");
        this.indent();
        programClass.fieldsAccept(this);
        this.outdent();
        this.println();
        this.println("Methods (count = " + programClass.u2methodsCount + "):");
        this.indent();
        programClass.methodsAccept(this);
        this.outdent();
        this.println();
        this.println("Class file attributes (count = " + programClass.u2attributesCount + "):");
        this.indent();
        programClass.attributesAccept(this);
        this.outdent();
        this.println();
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.println("_____________________________________________________________________");
        this.println(this.visitorInfo(libraryClass) + " " + "Library class: " + libraryClass.getName());
        this.indent();
        this.println("Superclass:    " + libraryClass.getSuperName());
        this.println("Access flags:  0x" + Integer.toHexString(libraryClass.u2accessFlags));
        this.println("  = " + ((libraryClass.u2accessFlags & 0x2000) != 0 ? "@ " : "") + ClassUtil.externalClassAccessFlags(libraryClass.u2accessFlags) + ((libraryClass.u2accessFlags & 0x4000) != 0 ? "enum " : ((libraryClass.u2accessFlags & 0x200) == 0 ? "class " : "")) + ClassUtil.externalClassName(libraryClass.getName()) + (libraryClass.getSuperName() == null ? "" : " extends " + ClassUtil.externalClassName(libraryClass.getSuperName())));
        this.outdent();
        this.println();
        this.println("Interfaces (count = " + libraryClass.interfaceClasses.length + "):");
        for (int i = 0; i < libraryClass.interfaceClasses.length; ++i) {
            Clazz clazz = libraryClass.interfaceClasses[i];
            if (clazz == null) continue;
            this.println("  + " + clazz.getName());
        }
        this.println("Fields (count = " + libraryClass.fields.length + "):");
        libraryClass.fieldsAccept(this);
        this.println("Methods (count = " + libraryClass.methods.length + "):");
        libraryClass.methodsAccept(this);
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.println(this.visitorInfo(integerConstant) + " Integer [" + integerConstant.getValue() + "]");
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.println(this.visitorInfo(longConstant) + " Long [" + longConstant.getValue() + "]");
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.println(this.visitorInfo(floatConstant) + " Float [" + floatConstant.getValue() + "]");
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.println(this.visitorInfo(doubleConstant) + " Double [" + doubleConstant.getValue() + "]");
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.println(this.visitorInfo(stringConstant) + " String [" + clazz.getString(stringConstant.u2stringIndex) + "]");
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.println(this.visitorInfo(utf8Constant) + " Utf8 [" + utf8Constant.getString() + "]");
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.println(this.visitorInfo(fieldrefConstant) + " Fieldref [" + clazz.getClassName(fieldrefConstant.u2classIndex) + "." + clazz.getName(fieldrefConstant.u2nameAndTypeIndex) + " " + clazz.getType(fieldrefConstant.u2nameAndTypeIndex) + "]");
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        this.println(this.visitorInfo(interfaceMethodrefConstant) + " InterfaceMethodref [" + clazz.getClassName(interfaceMethodrefConstant.u2classIndex) + "." + clazz.getName(interfaceMethodrefConstant.u2nameAndTypeIndex) + " " + clazz.getType(interfaceMethodrefConstant.u2nameAndTypeIndex) + "]");
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.println(this.visitorInfo(methodrefConstant) + " Methodref [" + clazz.getClassName(methodrefConstant.u2classIndex) + "." + clazz.getName(methodrefConstant.u2nameAndTypeIndex) + " " + clazz.getType(methodrefConstant.u2nameAndTypeIndex) + "]");
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.println(this.visitorInfo(classConstant) + " Class [" + clazz.getString(classConstant.u2nameIndex) + "]");
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.println(this.visitorInfo(nameAndTypeConstant) + " NameAndType [" + clazz.getString(nameAndTypeConstant.u2nameIndex) + " " + clazz.getString(nameAndTypeConstant.u2descriptorIndex) + "]");
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.println(this.visitorInfo(programField) + " " + "Field:        " + programField.getName(programClass) + " " + programField.getDescriptor(programClass));
        this.indent();
        this.println("Access flags: 0x" + Integer.toHexString(programField.u2accessFlags));
        this.println("  = " + ClassUtil.externalFullFieldDescription(programField.u2accessFlags, programField.getName(programClass), programField.getDescriptor(programClass)));
        this.visitMember(programClass, programField);
        this.outdent();
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.println(this.visitorInfo(programMethod) + " " + "Method:       " + programMethod.getName(programClass) + programMethod.getDescriptor(programClass));
        this.indent();
        this.println("Access flags: 0x" + Integer.toHexString(programMethod.u2accessFlags));
        this.println("  = " + ClassUtil.externalFullMethodDescription(programClass.getName(), programMethod.u2accessFlags, programMethod.getName(programClass), programMethod.getDescriptor(programClass)));
        this.visitMember(programClass, programMethod);
        this.outdent();
    }

    private void visitMember(ProgramClass programClass, ProgramMember programMember) {
        if (programMember.u2attributesCount > 0) {
            this.println("Class member attributes (count = " + programMember.u2attributesCount + "):");
            programMember.attributesAccept(programClass, this);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.println(this.visitorInfo(libraryField) + " " + "Field:        " + libraryField.getName(libraryClass) + " " + libraryField.getDescriptor(libraryClass));
        this.indent();
        this.println("Access flags: 0x" + Integer.toHexString(libraryField.u2accessFlags));
        this.println("  = " + ClassUtil.externalFullFieldDescription(libraryField.u2accessFlags, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)));
        this.outdent();
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.println(this.visitorInfo(libraryMethod) + " " + "Method:       " + libraryMethod.getName(libraryClass) + " " + libraryMethod.getDescriptor(libraryClass));
        this.indent();
        this.println("Access flags: 0x" + Integer.toHexString(libraryMethod.u2accessFlags));
        this.println("  = " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), libraryMethod.u2accessFlags, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)));
        this.outdent();
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        this.println(this.visitorInfo(unknownAttribute) + " Unknown attribute (" + clazz.getString(unknownAttribute.u2attributeNameIndex) + ")");
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.println(this.visitorInfo(sourceFileAttribute) + " Source file attribute:");
        this.indent();
        clazz.constantPoolEntryAccept(sourceFileAttribute.u2sourceFileIndex, this);
        this.outdent();
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.println(this.visitorInfo(sourceDirAttribute) + " Source dir attribute:");
        this.indent();
        clazz.constantPoolEntryAccept(sourceDirAttribute.u2sourceDirIndex, this);
        this.outdent();
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.println(this.visitorInfo(innerClassesAttribute) + " Inner classes attribute (count = " + innerClassesAttribute.u2classesCount + ")");
        this.indent();
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        this.outdent();
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.println(this.visitorInfo(enclosingMethodAttribute) + " Enclosing method attribute:");
        this.indent();
        clazz.constantPoolEntryAccept(enclosingMethodAttribute.u2classIndex, this);
        if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            clazz.constantPoolEntryAccept(enclosingMethodAttribute.u2nameAndTypeIndex, this);
        }
        this.outdent();
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        this.println(this.visitorInfo(deprecatedAttribute) + " Deprecated attribute");
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        this.println(this.visitorInfo(syntheticAttribute) + " Synthetic attribute");
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.println(this.visitorInfo(signatureAttribute) + " Signature attribute:");
        this.indent();
        clazz.constantPoolEntryAccept(signatureAttribute.u2signatureIndex, this);
        this.outdent();
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.println(this.visitorInfo(constantValueAttribute) + " Constant value attribute:");
        clazz.constantPoolEntryAccept(constantValueAttribute.u2constantValueIndex, this);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.println(this.visitorInfo(exceptionsAttribute) + " Exceptions attribute (count = " + exceptionsAttribute.u2exceptionIndexTableLength + ")");
        this.indent();
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, this);
        this.outdent();
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.println(this.visitorInfo(codeAttribute) + " Code attribute instructions (code length = " + codeAttribute.u4codeLength + ", locals = " + codeAttribute.u2maxLocals + ", stack = " + codeAttribute.u2maxStack + "):");
        this.indent();
        codeAttribute.instructionsAccept(clazz, method, this);
        this.println("Code attribute exceptions (count = " + codeAttribute.u2exceptionTableLength + "):");
        codeAttribute.exceptionsAccept(clazz, method, this);
        this.println("Code attribute attributes (attribute count = " + codeAttribute.u2attributesCount + "):");
        codeAttribute.attributesAccept(clazz, method, this);
        this.outdent();
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.println(this.visitorInfo(codeAttribute) + " Stack map attribute (count = " + stackMapAttribute.u2stackMapFramesCount + "):");
        this.indent();
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
        this.outdent();
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.println(this.visitorInfo(codeAttribute) + " Stack map table attribute (count = " + stackMapTableAttribute.u2stackMapFramesCount + "):");
        this.indent();
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
        this.outdent();
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.println(this.visitorInfo(lineNumberTableAttribute) + " Line number table attribute (count = " + lineNumberTableAttribute.u2lineNumberTableLength + ")");
        this.indent();
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        this.outdent();
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.println(this.visitorInfo(localVariableTableAttribute) + " Local variable table attribute (count = " + localVariableTableAttribute.u2localVariableTableLength + ")");
        this.indent();
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        this.outdent();
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.println(this.visitorInfo(localVariableTypeTableAttribute) + " Local variable type table attribute (count = " + localVariableTypeTableAttribute.u2localVariableTypeTableLength + ")");
        this.indent();
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        this.outdent();
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.println(this.visitorInfo(runtimeVisibleAnnotationsAttribute) + " Runtime visible annotations attribute:");
        this.indent();
        runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, this);
        this.outdent();
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.println(this.visitorInfo(runtimeInvisibleAnnotationsAttribute) + " Runtime invisible annotations attribute:");
        this.indent();
        runtimeInvisibleAnnotationsAttribute.annotationsAccept(clazz, this);
        this.outdent();
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        this.println(this.visitorInfo(runtimeVisibleParameterAnnotationsAttribute) + " Runtime visible parameter annotations attribute (parameter count = " + runtimeVisibleParameterAnnotationsAttribute.u2parametersCount + "):");
        this.indent();
        runtimeVisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
        this.outdent();
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        this.println(this.visitorInfo(runtimeInvisibleParameterAnnotationsAttribute) + " Runtime invisible parameter annotations attribute (parameter count = " + runtimeInvisibleParameterAnnotationsAttribute.u2parametersCount + "):");
        this.indent();
        runtimeInvisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
        this.outdent();
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.println(this.visitorInfo(annotationDefaultAttribute) + " Annotation default attribute:");
        this.indent();
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
        this.outdent();
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        this.println(this.visitorInfo(innerClassesInfo) + " InnerClassesInfo:");
        this.indent();
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
        innerClassesInfo.innerNameConstantAccept(clazz, this);
        this.outdent();
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.println(instruction.toString(n));
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.println(constantInstruction.toString(n));
        this.indent();
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        this.outdent();
    }

    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        int n2;
        this.println(tableSwitchInstruction.toString(n));
        this.indent();
        int[] nArray = tableSwitchInstruction.jumpOffsets;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = nArray[n2];
            this.println(Integer.toString(tableSwitchInstruction.lowCase + n2) + ": offset = " + n3 + ", target = " + (n + n3));
        }
        n2 = tableSwitchInstruction.defaultOffset;
        this.println("default: offset = " + n2 + ", target = " + (n + n2));
        this.outdent();
    }

    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        int n2;
        this.println(lookUpSwitchInstruction.toString(n));
        this.indent();
        int[] nArray = lookUpSwitchInstruction.cases;
        int[] nArray2 = lookUpSwitchInstruction.jumpOffsets;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            int n3 = nArray2[n2];
            this.println(Integer.toString(nArray[n2]) + ": offset = " + n3 + ", target = " + (n + n3));
        }
        n2 = lookUpSwitchInstruction.defaultOffset;
        this.println("default: offset = " + n2 + ", target = " + (n + n2));
        this.outdent();
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.println(this.visitorInfo(exceptionInfo) + " ExceptionInfo (" + exceptionInfo.u2startPC + " -> " + exceptionInfo.u2endPC + ": " + exceptionInfo.u2handlerPC + "):");
        if (exceptionInfo.u2catchType != 0) {
            clazz.constantPoolEntryAccept(exceptionInfo.u2catchType, this);
        }
    }

    public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameZeroFrame sameZeroFrame) {
        this.println(this.visitorInfo(sameZeroFrame) + " [" + n + "]" + " Var: ..., Stack: (empty)");
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.print(this.visitorInfo(sameOneFrame) + " [" + n + "]" + " Var: ..., Stack: ");
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
        this.println();
    }

    public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LessZeroFrame lessZeroFrame) {
        this.println(this.visitorInfo(lessZeroFrame) + " [" + n + "]" + " Var: -" + lessZeroFrame.choppedVariablesCount + ", Stack: (empty)");
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.print(this.visitorInfo(moreZeroFrame) + " [" + n + "]" + " Var: ...");
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
        this.ps.println(", Stack: (empty)");
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.print(this.visitorInfo(fullFrame) + " [" + n + "]" + " Var: ");
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        this.ps.print(", Stack: ");
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
        this.println();
    }

    public void visitIntegerType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, IntegerType integerType) {
        this.ps.print("[i]");
    }

    public void visitFloatType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FloatType floatType) {
        this.ps.print("[f]");
    }

    public void visitLongType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LongType longType) {
        this.ps.print("[l]");
    }

    public void visitDoubleType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, DoubleType doubleType) {
        this.ps.print("[d]");
    }

    public void visitTopType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TopType topType) {
        this.ps.print("[T]");
    }

    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
        this.ps.print("[a:" + clazz.getClassName(objectType.u2classIndex) + "]");
    }

    public void visitNullType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, NullType nullType) {
        this.ps.print("[n]");
    }

    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        this.ps.print("[u:" + uninitializedType.u2newInstructionOffset + "]");
    }

    public void visitUninitializedThisType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedThisType uninitializedThisType) {
        this.ps.print("[u:this]");
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        this.println("[" + lineNumberInfo.u2startPC + "] -> line " + lineNumberInfo.u2lineNumber);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.println("#" + localVariableInfo.u2index + ": " + localVariableInfo.u2startPC + " -> " + (localVariableInfo.u2startPC + localVariableInfo.u2length) + " [" + clazz.getString(localVariableInfo.u2descriptorIndex) + " " + clazz.getString(localVariableInfo.u2nameIndex) + "]");
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.println("#" + localVariableTypeInfo.u2index + ": " + localVariableTypeInfo.u2startPC + " -> " + (localVariableTypeInfo.u2startPC + localVariableTypeInfo.u2length) + " [" + clazz.getString(localVariableTypeInfo.u2signatureIndex) + " " + clazz.getString(localVariableTypeInfo.u2nameIndex) + "]");
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.println(this.visitorInfo(annotation) + " Annotation [" + clazz.getString(annotation.u2typeIndex) + "]:");
        this.indent();
        annotation.elementValuesAccept(clazz, this);
        this.outdent();
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.println(this.visitorInfo(constantElementValue) + " Constant element value [" + (constantElementValue.u2elementNameIndex == 0 ? "(default)" : clazz.getString(constantElementValue.u2elementNameIndex)) + " '" + constantElementValue.u1tag + "']");
        this.indent();
        clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        this.outdent();
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.println(this.visitorInfo(enumConstantElementValue) + " Enum constant element value [" + (enumConstantElementValue.u2elementNameIndex == 0 ? "(default)" : clazz.getString(enumConstantElementValue.u2elementNameIndex)) + ", " + clazz.getString(enumConstantElementValue.u2typeNameIndex) + ", " + clazz.getString(enumConstantElementValue.u2constantNameIndex) + "]");
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.println(this.visitorInfo(classElementValue) + " Class element value [" + (classElementValue.u2elementNameIndex == 0 ? "(default)" : clazz.getString(classElementValue.u2elementNameIndex)) + ", " + clazz.getString(classElementValue.u2classInfoIndex) + "]");
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.println(this.visitorInfo(annotationElementValue) + " Annotation element value [" + (annotationElementValue.u2elementNameIndex == 0 ? "(default)" : clazz.getString(annotationElementValue.u2elementNameIndex)) + "]:");
        this.indent();
        annotationElementValue.annotationAccept(clazz, this);
        this.outdent();
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.println(this.visitorInfo(arrayElementValue) + " Array element value [" + (arrayElementValue.u2elementNameIndex == 0 ? "(default)" : clazz.getString(arrayElementValue.u2elementNameIndex)) + "]:");
        this.indent();
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
        this.outdent();
    }

    private void indent() {
        ++this.indentation;
    }

    private void outdent() {
        --this.indentation;
    }

    private void println(String string) {
        this.print(string);
        this.println();
    }

    private void print(String string) {
        for (int i = 0; i < this.indentation; ++i) {
            this.ps.print(INDENTATION);
        }
        this.ps.print(string);
    }

    private void println() {
        this.ps.println();
    }

    private String visitorInfo(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == null ? "-" : "+";
    }
}

