/*
    EditorLooksPreferences.h

    Interface declaration of the EditorLooksPreferences class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import "../../PreferencesModule.h"

@class NSTextField;

@interface EditorLooksPreferences : NSObject <PreferencesModule>
{
  id backgroundColor;
  id bogusWindow;
  id crosshairsColor;
  id cursorColor;
  id editorFontField;
  id guidelinesColor;
  id guidelinesHighlightColor;
  id highlightColor;
  id pattern;
  id rulerHighlightColor;
  id textColor;
  id view;
}

- (void) changeBackgroundColor: (id)sender;
- (void) changeCrosshairsColor: (id)sender;
- (void) changeCursorColor: sender;
- (void) changeGuidelinesColor: (id)sender;
- (void) changeGuidelinesHighlightColor: (id)sender;
- (void) changeGuidelinesPattern: (id)sender;
- (void) changeHighlightColor: (id)sender;
- (void) changeRulerHighlightColor: (id)sender;
- (void) changeTextColor: (id)sender;

- (void) fontChangedInField: (NSTextField *) aTextField;

@end
