/***************************************************************************
                          job_appendcdromtodatabase.cpp  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_appendcdromtodatabase.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "gui.h"
#include "datadispatcher.h"

#include <qinputdialog.h>

#include <qmessagebox.h>

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_AppendCDROMToDatabase::Job_AppendCDROMToDatabase(LVI_CDDrive *_drive)
: drive(_drive) {}

void Job_AppendCDROMToDatabase::run() {
    int error = 0;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    app->lock()
    ;
    datadispatcher->eventAddEditLock();
    datadispatcher->eventStartedAppendingCDROM(drive);
    app->unlock();

    QList<TRACK> *files = readTags(getFileList(new QDir(drive->getPath()), false));

    for(TRACK *curr = files->first(); curr != 0; curr = files->next())
        curr->path.replace(0, drive->getPath().length(), "");

    // ask for media ID
    bool ok = false, done;
    QString ID = "";
    if(files->count() != 0) {
        QString label = QString( _("Found %1 files on disk in drive %2. Enter CD Name:") ).arg( files->count() ).arg( drive->getName() );
        app->lock()
        ;
        do {
            ID = QInputDialog::getText(_("CD Identification"), label, QLineEdit::Normal, ID, &ok);
            if(ok) {
                done = (!ID.isEmpty() && !gui->getSourcer()->existsLabel(ID));
                if(!done)
                    QMessageBox::information(gui, _("Message"), _("ID is empty / ID already exists!"), QMessageBox::Ok);
            } else {
                int answer = QMessageBox::information(gui, _("Message"), _("Are you sure you want to cancel the job?"), QMessageBox::Yes, QMessageBox::No);
                done = (answer == QMessageBox::Yes);
            }
        } while(!done);
        app->unlock();
    }


    int CdID;

    database->lock()
    ;
    if(ok)
        CdID = database->appendTracks(files, MEDIUM_CDROM, ID, "", drive->getChecksum(), true, 0);
    error = database->getError();
    database->unlock();

    if(ok && !error) {
        database->lock()
        ;
        app->lock()
        ;

        MEDIUM medium;
        medium.id       = CdID;
        medium.type     = MEDIUM_CDROM;
        medium.label    = ID;
        medium.checksum = drive->getChecksum();

        datadispatcher->eventNewLocalAlbumDelta(CdID, database->getLocalAlbumDelta(CdID));
        datadispatcher->eventNewArtistDelta(database->getArtistDelta());
        datadispatcher->eventNewMedium(&medium);
        datadispatcher->eventNewTrackListing(database->getLastQuery());

        error  = database->getError();

        datadispatcher->eventCloseSelectorTree();

        if(!error)
            datadispatcher->eventStoppedAppendingCDROM(drive);
        datadispatcher->eventRemoveEditLock();

        app->unlock();
        database->unlock();
    }

    if(error) {
        app->lock()
        ;
        datadispatcher->eventStoppedAppendingCDROM(drive);
        app->unlock();
        jobman->lock()
        ;
        jobman->addJob(new Job_DisconnectFromDatabase());
        jobman->unlock();
    }

    if (!ok && !error) {
        app->lock()
        ;
        datadispatcher->eventStoppedAppendingCDROM(drive);
        app->unlock();
    }

    for(TRACK *curr = files->first(); curr != 0; curr = files->next())
        delete curr;
    delete files;

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();
    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_AppendCDROMToDatabase::~Job_AppendCDROMToDatabase() {}
