/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2002 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: qsort.c,v 1.1 2002/05/15 21:44:58 type2 Exp $ */

/* Benchmark program to run for testing purposes.
 * Do the quicksort on variable number of slots.
 * Currently always seeds random with 1 for
 * reproduciblity.
 */

#include <stdlib.h>
#include <stdio.h>

char *rcs="$Id: qsort.c,v 1.1 2002/05/15 21:44:58 type2 Exp $";

int my_compare(const void *el1, const void *el2)
{
    return((*(int*)el1 > *(int*)el2) ? 1 : ((*(int*)el1 < *(int*)el2) ? -1 : 0));
}

int main(int argc, char *argv[])
{
    int size, i, *array;

    if (argc > 1)
        size = atoi(argv[1]);
    else
        size = 1000000;

    srandom(1);


    printf("Allocating array - of %d integers.\n", size);
    array = malloc(size*sizeof(int));

    printf("Filling array.\n");
    for (i=0; i<size; i++) {
        array[i] = random();
    }

    printf("Sorting array.\n");
    qsort((void*) array, size, sizeof(int), my_compare);

    if (argc > 2) {
        printf("Array: ");
        for (i=0; i<size; i++)
          printf("%d ", array[i]);
        printf("\n");
    }

}
