////////////////////////////////////////////////////////////////
// 2000 Microsoft Systems Journal. 
// If this program works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// This program compiles with Visual C++ 6.0 on Windows 98
//
// See IdleUI.h
// 

#include<windows.h>
#include<assert.h>

#define DLLEXPORT __declspec(dllexport)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HINSTANCE myInstance;

int WINAPI DllMain(HINSTANCE hinst, unsigned long reason, void*) 
{ 
	myInstance = hinst;
	return 1; 
}

////////////////
// The following global data is SHARED among all instances of the DLL
// (processes); i.e., these are system-wide globals.
// 
#pragma data_seg (".IdleUI")  // you must define as SHARED in .def
HHOOK g_hHookKbd = NULL;      // one instance for all processes
HHOOK g_hHookMouse = NULL;    // one instance for all processes
DWORD g_dwLastInputTick = 0;  // tick time of last input event
#pragma data_seg ()

/////////////////
// Get tick count of last keyboard or mouse event
//
DLLEXPORT DWORD IdleUIGetLastInputTime()
{
	return g_dwLastInputTick;
}

/////////////////
// Keyboard hook: record tick count
//
LRESULT CALLBACK MyKbdHook(int code, WPARAM wParam, LPARAM lParam)
{
	if (code==HC_ACTION) {
		g_dwLastInputTick = GetTickCount();
	}
	return ::CallNextHookEx(g_hHookKbd, code, wParam, lParam);
}

/////////////////
// Mouse hook: record tick count
//
LRESULT CALLBACK MyMouseHook(int code, WPARAM wParam, LPARAM lParam)
{
	if (code==HC_ACTION) {
		g_dwLastInputTick = GetTickCount();
	}
	return ::CallNextHookEx(g_hHookMouse, code, wParam, lParam);
}

//////////////////
// Initialize DLL: install kbd/mouse hooks.
//
DLLEXPORT BOOL IdleUIInit()
{
	if (g_hHookKbd == NULL) {
		HINSTANCE hInst = myInstance;
		g_hHookKbd   = SetWindowsHookEx(WH_KEYBOARD, MyKbdHook,   hInst, 0);
		g_hHookMouse = SetWindowsHookEx(WH_MOUSE,		MyMouseHook, hInst, 0);
		g_dwLastInputTick = GetTickCount(); // init count
	}
	assert(g_hHookKbd);
	assert(g_hHookMouse);
	return TRUE;
}

//////////////////
// Terminate DLL: remove hooks.
//
DLLEXPORT void IdleUITerm()
{
	BOOL bRet1 = UnhookWindowsHookEx(g_hHookKbd);
	BOOL bRet2 = UnhookWindowsHookEx(g_hHookMouse);
	assert(bRet1 && bRet2);
}
