/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qdatetime.h>

void IconsetDetailsDlg::setIconset( const Iconset &is )
{
	setCaption(caption().arg(is.name()));
	
	lb_name->setText(is.name());
	lb_version->setText(is.version());
	
	if ( is.description().isEmpty() ) {
		lb_desc->hide();
		lb_desc2->hide();
	}
	else
		lb_desc->setText(is.description());
	
	if ( !is.homeUrl().isEmpty() ) {
		url_home->setTitle(is.homeUrl());
		url_home->setUrl(is.homeUrl());
	}
	else {
		url_home->hide();
		lb_home->hide();
	}
		
	if ( is.creation().isEmpty() ) {
		lb_date->hide();
		lb_date2->hide();
	}
	else {
		QDate date = QDate::fromString(is.creation(), ISODate);	
		lb_date->setText(date.toString(LocalDate));
	}
	
	if ( is.authors().count() == 0 ) {
		ptv_authors->hide();
		lb_authors->hide();
	}
	else {
		QString authors;
		QStringList::ConstIterator it = is.authors().begin();
		for ( ; it != is.authors().end(); ++it) {
			if ( !authors.isEmpty() )
				authors += "<br><br>";
			authors += *it;
		}
		ptv_authors->setText( "<qt><nobr>" + authors + "</nobr></qt>" );
	}
	
	isd_iconset->setIconset(is);
	
	resize(sizeHint());
}
