#
# @BEGIN LICENSE
#
# Psi4: an open-source quantum chemistry software package
#
# Copyright (c) 2007-2018 The Psi4 Developers.
#
# The copyrights for code used from other parties are included in
# the corresponding files.
#
# This file is part of Psi4.
#
# Psi4 is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, version 3.
#
# Psi4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with Psi4; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# @END LICENSE
#

"""
| Database (Merz) of interaction energies for protein sidechain-sidechain interactions.
| Geometries from Kenneth Merz Group, Univ. of Florida.
| Reference interaction energies from <Reference>.
| Part of the BioFragment Database (BFDb).

- **cp**  ``'off'`` || ``'on'``

- **rlxd** ``'off'``

"""
import re
import qcdb

# <<< SSI Database Module >>>
dbse = 'SSI'

# <<< Database Members >>>
HRXN = ['001ARG-005ASP-1', '001ARG-013ARG-1', '001ARG-015GLU-1', '001ARG-159VAL-1', '001ASN-026VAL-1',
        '001ASN-030MET-1', '001ASN-097GLU-1', '001HIE-099GLN-1', '001LEU-071LYS-1',  # dropped 001ASN-096HIE-1
        '001LEU-154LEU-1', '001LEU-190THR-1', '001LYS-027ASN-2', '001LYS-027THR-1', '001LYS-027THR-2',
        '001MET-005GLU-1', '001MET-027VAL-2', '001MET-031VAL-1', '001MET-047GLU-1', '001PRO-046ASP-1',
        '001SER-030GLU-1', '002ALA-101ILE-1', '002ARG-006GLU-1', '002ARG-020PRO-1', '002ARG-046LEU-1',
        '002ASN-022GLU-1', '002ASN-026ASP-2', '002ASP-145HIE-1', '002LEU-005GLN-1', '002LEU-006GLN-1',
        '002LEU-153PHE-1', '002LEU-163LEU-1', '002LYS-006GLU-2', '002LYS-007ILE-1', '002LYS-035GLU-1',
        '002LYS-075ASN-1', '002LYS-080ARG-1', '002LYS-082TYR-1', '002MET-031TYR-1', '002MET-050ALA-1',
        '002TRP-012VAL-1', '002TRP-138SER-2', '002TRP-139LEU-1', '002VAL-009TRP-1', '002VAL-042PHE-1',
        '002VAL-042PHE-2', '002VAL-043HIE-2', '002VAL-046SER-1', '003ALA-007THR-1', '003GLU-006GLN-2',
        '003ILE-062ILE-1', '003ILE-065SER-1', '003ILE-067TYR-1', '003LEU-033LEU-1', '003LEU-054LEU-1',
        '003LYS-055LEU-1', '003PRO-025ALA-1', '003SER-096ASN-2', '003THR-181VAL-1', '003THR-182GLU-1',
        '003TRP-163PRO-1', '003TRP-167GLN-1', '003TRP-167GLN-2', '003TYR-028VAL-1', '003TYR-028VAL-2',
        '003TYR-030GLN-1', '003TYR-054VAL-1', '003TYR-056ALA-1', '003TYR-073CYS-2', '003TYR-074SER-1',
        '003TYR-096HIE-1', '003VAL-009TYR-1', '003VAL-012GLU-1', '003VAL-036PHE-1', '003VAL-064TYR-1',
        '003VAL-081THR-1', '003VAL-083PRO-1', '003VAL-118ALA-1', '003VAL-121TYR-1', '004ARG-024THR-1',
        '004ARG-057ILE-1', '004ARG-057ILE-2', '004ARG-095TYR-1', '004ARG-095TYR-2', '004ASN-009TRP-1',
        '004ASP-043THR-1', '004ASP-194ARG-1', '004GLN-007ASN-2', '004GLN-056GLU-1', '004GLU-039THR-1',
        '004LEU-010TYR-1', '004LEU-031TYR-1', '004LEU-032HIE-1', '004LEU-040GLU-1', '004LEU-179LEU-1',
        '004LEU-180LEU-1', '004LEU-180LEU-2', '004LEU-183LYS-1', '004LYS-030ASP-1', '004LYS-031ILE-1',
        '004LYS-323PHE-1', '004PHE-116VAL-1', '004PHE-135LEU-2', '004PHE-158LEU-1', '004PHE-160PRO-1',
        '004PRO-007LEU-1', '004PRO-009TYR-1', '004PRO-026TYR-1', '004PRO-029PHE-1', '004PRO-068VAL-1',
        '004PRO-074ALA-1', '004PRO-094LEU-1', '004PRO-096TYR-1', '004SER-027VAL-1', '004SER-030MET-1',
        '004THR-078LEU-1', '004THR-132LYS-1', '004THR-163LEU-1', '004THR-164GLU-1', '004TRP-014ARG-2',
        '004TRP-016LYS-1', '004TYR-075PRO-1', '004TYR-105LEU-1', '004VAL-053LEU-1', '005ALA-019PHE-1',
        '005ARG-012GLU-1', '005ARG-071GLU-1', '005ARG-158LEU-2', '005ASP-103GLN-1', '005ASP-128ARG-1',
        '005ILE-054SER-1', '005ILE-234TYR-1', '005ILE-277LEU-1', '005LEU-010TRP-1', '005LEU-011PHE-1',
        '005LEU-015LYS-1', '005LEU-023GLN-1', '005LEU-025ILE-1', '005LEU-025LEU-1', '005LEU-030ASP-1',
        '005LEU-030LEU-2', '005LEU-032MET-1', '005LEU-037ILE-1', '005LEU-068ILE-1', '005LEU-077LEU-1',
        '005LEU-083HIE-1', '005LEU-106TYR-1', '005LEU-191TYR-1', '005PHE-022VAL-1', '005PHE-031TYR-1',
        '005PHE-037PHE-1', '005PHE-043TYR-1', '005PHE-049LYS-1', '005PHE-050TRP-1', '005PHE-155SER-1',
        '005PHE-162GLN-1', '005PHE-163LEU-1', '005PRO-196ALA-1', '005SER-028VAL-1', '005TYR-166TYR-1',
        '005TYR-168VAL-1', '005VAL-008GLN-1', '005VAL-023LEU-1', '005VAL-035PHE-1', '005VAL-037ILE-1',
        '005VAL-039SER-1', '006ALA-078GLU-1', '006ARG-090TYR-1', '006ASP-010THR-1', '006ASP-116VAL-1',
        '006GLU-010TYR-1', '006LEU-108PHE-1', '006LEU-126VAL-1', '006LEU-319TYR-1', '006LEU-323PHE-1',
        '006PHE-018ARG-1', '006PHE-039THR-2', '006PHE-050VAL-1', '006PHE-053LEU-1', '006PHE-061PHE-1',
        '006PHE-163LEU-1', '006THR-097VAL-1', '006TRP-026TYR-1', '006TRP-038VAL-1', '006TRP-040LYS-1',
        '006VAL-020VAL-1', '006VAL-023MET-1', '006VAL-024ASP-1', '006VAL-026LEU-1', '006VAL-038ILE-1',
        '006VAL-053LEU-1', '006VAL-055GLU-1', '006VAL-175PHE-1', '007ALA-011ILE-1', '007ALA-021PHE-1',
        '007ALA-049VAL-1', '007ARG-011GLU-2', '007ARG-062TYR-1', '007ARG-063PRO-1', '007ASN-109GLU-1',
        '007ASP-011GLN-1', '007ASP-119SER-1', '007ASP-131ARG-1', '007GLU-033LYS-1', '007GLU-033LYS-2',
        '007ILE-015LYS-1', '007ILE-030LEU-1', '007ILE-030LEU-2', '007ILE-038TYR-1', '007ILE-042LYS-1',
        '007ILE-097VAL-1', '007LEU-017ARG-1', '007LEU-026VAL-1', '007LEU-033LEU-1', '007LEU-090TYR-1',
        '007LEU-096TYR-1', '007LEU-168HIE-1', '007LYS-011ASP-1', '007LYS-093SER-1', '007LYS-099THR-1',
        '007PHE-019VAL-1', '007PHE-021PHE-1', '007PHE-021PRO-1', '007PHE-022VAL-1', '007PHE-024VAL-1',
        '007PHE-035PHE-1', '007PHE-084LEU-1', '007PHE-091ILE-1', '007PHE-111PHE-1', '007PHE-157ILE-1',
        '007PHE-160CYS-1', '007SER-010ARG-2', '007SER-100ASN-1', '007THR-031LYS-1', '007TYR-053TYR-1',
        '007VAL-022SER-1', '007VAL-026GLU-1', '007VAL-034ALA-1', '007VAL-038VAL-1', '007VAL-040THR-1',
        '007VAL-154GLN-1', '007VAL-154GLN-2', '007VAL-191TYR-1', '007VAL-248MET-1', '008ALA-034ALA-1',
        '008ALA-035GLU-1', '008ALA-038MET-1', '008ARG-115SER-1', '008ASN-030LYS-1', '008ASP-018ARG-1',
        '008ASP-018ARG-2', '008ASP-058ILE-1', '008ILE-012HIE-1', '008ILE-015TYR-1', '008ILE-032MET-1',
        '008ILE-033PHE-1', '008ILE-034LEU-1', '008ILE-035TRP-1', '008ILE-041TYR-1', '008ILE-058PHE-1',
        '008ILE-062TYR-1', '008LEU-017ALA-1', '008LEU-088TYR-1', '008LYS-043THR-1', '008LYS-065VAL-1',
        '008LYS-068GLU-1', '008LYS-068GLU-2', '008MET-158LEU-1', '008PHE-042LEU-1', '008PHE-044ILE-1',
        '008PHE-097VAL-1', '008PHE-099HIE-1', '008PHE-101HIE-1', '008PRO-183ASP-1', '008SER-032SER-1',
        '008SER-093TYR-1', '008TRP-035PHE-1', '008TRP-250PHE-1', '008TRP-252GLU-1', '008TYR-052TYR-1',
        '008VAL-039TRP-1', '008VAL-041VAL-1', '008VAL-066LEU-1', '008VAL-072SER-1', '008VAL-080PHE-1',
        '009ALA-084LEU-1', '009ALA-091ILE-1', '009ARG-023GLU-1', '009ARG-031TRP-1', '009ARG-092LEU-1',
        '009ARG-103GLN-1', '009ARG-106ASP-1', '009ARG-128ARG-1', '009ARG-128ARG-2', '009ASN-024ARG-1',
        '009ASP-021LYS-1', '009GLN-068ILE-1', '009GLN-072ASN-1', '009ILE-013TYR-1', '009ILE-038LEU-1',
        '009ILE-052PHE-1', '009ILE-092LEU-1', '009ILE-092LEU-2', '009ILE-105LEU-1', '009ILE-108PHE-1',
        '009ILE-155ILE-1', '009LEU-013VAL-1', '009LEU-033LEU-2', '009LEU-039ARG-1', '009LEU-041VAL-1',
        '009LEU-041VAL-2', '009LEU-055SER-2', '009LEU-058ILE-1', '009LYS-137LEU-1', '009LYS-171VAL-1',
        '009PRO-069TYR-1', '009TRP-111ARG-1', '009TYR-016GLU-1', '009TYR-029THR-1', '009TYR-033ASN-1',
        '009TYR-035SER-1', '009TYR-050PRO-1', '009TYR-053TYR-1', '009TYR-111ASP-1', '009TYR-121TYR-1',
        '009TYR-158ALA-1', '009TYR-301MET-1', '009TYR-303TRP-1', '009VAL-021PHE-1', '009VAL-025ILE-1',
        '009VAL-035ARG-1', '009VAL-084ILE-1', '009VAL-086TYR-1', '010ARG-039ASP-1', '010ARG-042ASP-1',
        '010ARG-092LEU-1', '010ASN-014GLN-2', '010ASN-023GLU-1', '010ASN-088TYR-1', '010ASP-090TYR-1',
        '010GLN-022MET-1', '010GLN-102TYR-1', '010GLU-014LYS-1', '010GLU-032SER-1', '010HIE-015TYR-1',
        '010HIE-023ASP-1', '010LEU-091ASN-1', '010LEU-096TRP-1', '010LEU-132ILE-1', '010PHE-028ILE-2',
        '010TRP-022LEU-1', '010TRP-025VAL-1', '010TRP-032ILE-1', '010TRP-032PHE-1', '010TRP-034VAL-1',
        '010TRP-052TYR-1', '010TRP-058PHE-1', '010TRP-081VAL-1', '010TRP-081VAL-2', '010TYR-017GLU-1',
        '010TYR-049PRO-1', '010TYR-052TYR-1', '010TYR-163TYR-1', '010VAL-027ALA-1', '010VAL-028LEU-1',
        '010VAL-034TYR-1', '010VAL-040PHE-1', '010VAL-044ALA-1', '011ALA-016GLU-1', '011ASP-091ASN-1',
        '011CYS-042VAL-1', '011CYS-042VAL-2', '011GLU-062TYR-1', '011GLU-100THR-1', '011HIE-015ASN-1',
        '011HIE-304SER-1', '011HIE-306ASN-1', '011ILE-017LEU-1', '011ILE-018ALA-1', '011ILE-024ILE-1',
        '011ILE-024ILE-2', '011ILE-028LEU-1', '011ILE-037LEU-1', '011ILE-038TYR-1', '011ILE-042LEU-1',
        '011ILE-045VAL-1', '011LEU-062HIE-2', '011LEU-069TYR-1', '011LEU-071GLU-1', '011LEU-102TYR-1',
        '011LEU-102TYR-2', '011PHE-044TYR-1', '011PRO-020ILE-1', '011SER-223GLU-1', '011THR-017ALA-1',
        '011THR-166GLU-1', '011THR-166GLU-2', '011TYR-018ARG-1', '011TYR-023ARG-1', '011TYR-051GLU-1',
        '011TYR-102GLN-1', '011TYR-169ILE-1', '011VAL-144PHE-1', '011VAL-153LYS-1', '011VAL-153LYS-2',
        '011VAL-155ILE-1', '012ALA-055PHE-1', '012ALA-059PHE-1', '012ALA-108PHE-1', '012ALA-139ALA-1',
        '012ASN-048PHE-1', '012ASP-024LYS-2', '012ASP-026TYR-1', '012ASP-069TYR-1', '012GLN-034GLN-1',
        '012GLN-044TRP-1', '012GLN-048TYR-1', '012GLU-017GLU-1', '012GLU-019THR-1', '012GLU-068HIE-1',
        '012GLU-070TYR-1', '012HIE-015ILE-1', '012HIE-033LEU-1', '012ILE-016THR-1', '012ILE-018LEU-1',
        '012ILE-028LEU-1', '012ILE-044ILE-1', '012ILE-046LYS-2', '012ILE-046VAL-1', '012LEU-024VAL-1',
        '012LEU-027PRO-1', '012LEU-033LEU-1', '012LEU-035TRP-1', '012LEU-039ARG-1', '012LEU-047ILE-1',
        '012LEU-057LEU-1', '012LEU-062HIE-1', '012LEU-064LEU-1', '012LEU-065LEU-1', '012LEU-070MET-1',
        '012LEU-074VAL-1', '012LEU-083ASN-1', '012LEU-085ASN-1', '012LEU-088TYR-1', '012PHE-026PHE-1',
        '012PHE-040PHE-1', '012PHE-116PHE-1', '012PHE-163ILE-1', '012PHE-166CYS-1', '012SER-138SER-1',
        '012SER-166PHE-1', '012TYR-087PRO-1', '012VAL-016LEU-1', '012VAL-023LEU-1', '012VAL-088PHE-1',
        '012VAL-114PRO-1', '012VAL-146PHE-1', '013ALA-096TRP-1', '013ASN-149ASN-1', '013ASP-016GLU-1',
        '013ASP-023ARG-1', '013GLU-039ARG-1', '013GLU-052ILE-1', '013GLU-056GLN-1', '013GLU-065LEU-1',
        '013GLU-069ARG-1', '013HIE-032ALA-1', '013HIE-095HIE-1', '013HIE-121TYR-1', '013ILE-017LEU-1',
        '013ILE-105ALA-1', '013LEU-017ASN-1', '013LEU-063ILE-1', '013LEU-065PHE-1', '013LEU-066ALA-1',
        '013LEU-069LEU-1', '013LEU-077LEU-1', '013LEU-082VAL-1', '013LEU-084ALA-1', '013PHE-036VAL-1',
        '013PHE-060TYR-1', '013PHE-062LEU-1', '013PHE-063PRO-1', '013PHE-083ILE-1', '013PHE-085ALA-1',
        '013PRO-032VAL-1', '013PRO-034GLN-1', '013PRO-129THR-1', '013SER-047TYR-1', '013THR-164GLU-1',
        '013TYR-075LEU-1', '013TYR-075LEU-2', '013VAL-016PHE-1', '013VAL-066LEU-1', '013VAL-154ASN-1',
        '013VAL-154ASN-2', '014ALA-055LEU-1', '014ARG-083THR-1', '014ASN-027ARG-1', '014ASN-061LYS-1',
        '014ASN-137TYR-1', '014ASP-017ARG-1', '014GLN-093VAL-1', '014GLU-036LYS-1', '014GLU-069ILE-1',
        '014GLU-164TYR-1', '014HIE-043TYR-1', '014ILE-025TYR-1', '014ILE-027ILE-1', '014ILE-081PHE-1',
        '014ILE-085ASN-1', '014ILE-088MET-1', '014LEU-061GLN-1', '014LEU-070TRP-1', '014LEU-163ILE-1',
        '014LEU-174PRO-1', '014LYS-023GLU-1', '014SER-017GLU-1', '014SER-084GLN-1', '014TYR-019GLU-1',
        '014TYR-021PHE-1', '014TYR-022LYS-1', '014TYR-022LYS-2', '014TYR-082PHE-1', '014VAL-091ALA-1',
        '015ARG-020ASP-1', '015ARG-164ALA-1', '015ASN-019THR-1', '015ASN-048GLN-1', '015ASN-069ARG-1',
        '015ASN-149PHE-1', '015CYS-057LEU-1', '015GLU-019LYS-1', '015ILE-019PRO-1', '015ILE-023LEU-1',
        '015ILE-030LEU-1', '015ILE-034LEU-1', '015ILE-035ARG-1', '015ILE-136HIE-1', '015LEU-035TRP-1',
        '015LEU-038LEU-1', '015LEU-080PHE-1', '015LEU-084TYR-1', '015LEU-102SER-1', '015LYS-047TYR-1',
        '015LYS-047TYR-2', '015LYS-220ASP-1', '015LYS-223GLU-1', '015MET-023LEU-1', '015MET-023LEU-2',
        '015PHE-039ALA-1', '015PHE-044LEU-1', '015SER-018THR-1', '015SER-037LYS-1', '015THR-019ASP-1',
        '015THR-021MET-1', '015THR-060HIE-1', '015THR-061GLN-1', '015TRP-025THR-1', '015TRP-096TYR-1',
        '015TYR-034ILE-1', '015VAL-060TYR-1', '016ARG-047PHE-1', '016GLN-048ILE-1', '016GLN-098LEU-1',
        '016GLN-101GLN-1', '016GLU-035TRP-1', '016ILE-021VAL-1', '016ILE-145LYS-1', '016ILE-219PRO-1',
        '016LEU-036LEU-1', '016LEU-046ILE-1', '016LEU-062LEU-1', '016LEU-065LEU-1', '016LEU-072PRO-1',
        '016LEU-082SER-2', '016LEU-137ILE-1', '016LEU-141MET-1', '016LYS-085GLU-1', '016PHE-034VAL-1',
        '016PHE-036VAL-1', '016PHE-132ILE-1', '016PHE-176PHE-1', '016PHE-192LEU-1', '016SER-031ASN-2',
        '016THR-022MET-1', '016TYR-079ILE-1', '016VAL-033THR-1', '016VAL-055PHE-1', '016VAL-059PHE-1',
        '016VAL-084ILE-1', '017ARG-056HIE-1', '017ASN-021LYS-1', '017ASN-029ASN-2', '017ASP-049ARG-1',
        '017ASP-060HIE-1', '017GLN-024ASN-1', '017GLN-093VAL-1', '017GLN-094ASP-1', '017GLU-036TRP-1',
        '017GLU-072PRO-1', '017HIE-033ASP-1', '017HIE-035TRP-1', '017ILE-021LEU-1', '017ILE-028LEU-1',
        '017ILE-028LEU-2', '017ILE-030PHE-1', '017ILE-055HIE-1', '017ILE-149PHE-1', '017LEU-050ILE-1',
        '017LEU-056PHE-1', '017LEU-066LEU-1', '017LEU-083ILE-1', '017MET-020LYS-1', '017PHE-022SER-2',
        '017PHE-025TYR-1', '017PHE-077ASP-1', '017PHE-081PHE-1', '017PHE-084LEU-1', '017THR-078GLU-1',
        '017THR-307TRP-1', '017VAL-049LEU-1', '018ALA-023VAL-1', '018ALA-026GLU-1', '018ALA-027VAL-1',
        '018ARG-057THR-1', '018ASN-227ALA-1', '018ASP-032THR-1', '018ASP-034ALA-1', '018CYS-132HIE-1',
        '018GLU-074ILE-1', '018ILE-022GLN-1', '018ILE-052VAL-1', '018ILE-055ASN-1', '018ILE-055PHE-1',
        '018LEU-039ILE-1', '018LYS-024TYR-1', '018PRO-060HIE-1', '018PRO-085GLU-1', '018PRO-086VAL-1',
        '018PRO-139LEU-1', '018SER-024LEU-1', '018SER-040GLU-1', '018THR-035ILE-1', '018VAL-034ILE-1',
        '018VAL-164TYR-1', '018VAL-166ILE-1', '019ALA-055HIE-1', '019ALA-058TYR-1', '019ARG-027ARG-1',
        '019ASN-053VAL-1', '019GLN-026GLU-1', '019GLU-022LYS-2', '019GLU-025THR-1', '019ILE-051VAL-1',
        '019LEU-037ILE-1', '019LEU-041VAL-1', '019LEU-061ARG-1', '019LEU-062LEU-1', '019LEU-062LEU-2',
        '019LYS-027VAL-1', '019LYS-031HIE-1', '019LYS-071GLU-1', '019PHE-049LEU-1', '019SER-023ARG-1',
        '019SER-023ARG-2', '019SER-026ARG-1', '019THR-022MET-1', '019THR-035GLU-1', '019THR-035GLU-2',
        '019TYR-050TRP-1', '019VAL-027ILE-1', '019VAL-058VAL-1', '019VAL-075LEU-1', '019VAL-081LEU-1',
        '019VAL-137ILE-1', '019VAL-138VAL-1', '019VAL-138VAL-2', '020ASN-039LYS-2', '020ASN-040LYS-1',
        '020ASP-082LYS-1', '020GLN-036TRP-1', '020GLN-059ARG-1', '020HIE-062ASP-2', '020HIE-068LYS-1',
        '020ILE-023VAL-1', '020ILE-032THR-1', '020ILE-082ILE-1', '020ILE-309ALA-1', '020LEU-024VAL-1',
        '020LEU-038ILE-1', '020LEU-042VAL-1', '020LYS-040GLU-1', '020PHE-135PHE-1', '020PHE-149LEU-1',
        '020PRO-023ARG-2', '020PRO-177PRO-1', '020PRO-178LYS-1', '020PRO-181ILE-1', '020SER-058VAL-1',
        '020SER-091ARG-1', '020VAL-029TYR-1', '021ALA-039TYR-1', '021ALA-057VAL-1', '021ALA-100ASN-1',
        '021ARG-033THR-1', '021ARG-035GLU-1', '021ARG-035GLU-2', '021GLN-024LYS-1', '021GLN-024LYS-2',
        '021GLN-057TYR-1', '021HIE-061PHE-1', '021ILE-031HIE-1', '021ILE-036VAL-1', '021ILE-038VAL-1',
        '021ILE-041PHE-1', '021ILE-077LEU-1', '021ILE-088ILE-1', '021LYS-032TYR-1', '021LYS-039ILE-1',
        '021MET-058TYR-1', '021MET-062GLN-1', '021MET-069ILE-1', '021PHE-025GLN-1', '021PHE-038VAL-1',
        '021PHE-054ILE-1', '021PHE-060PRO-1', '021PHE-072PHE-1', '021PHE-072THR-1', '021PHE-076VAL-1',
        '021PHE-079ILE-1', '021PHE-082PHE-1', '021PHE-097LEU-1', '021PHE-097LEU-2', '021PHE-113ILE-1',
        '021PHE-131VAL-1', '021PHE-251HIE-1', '021PHE-260ILE-1', '021SER-142ASN-1', '021THR-148GLN-1',
        '021THR-150LYS-1', '021TYR-088PHE-1', '022ARG-072GLU-1', '022ARG-073GLU-1', '022GLN-028GLN-1',
        '022GLN-046MET-1', '022GLN-055ASN-1', '022GLN-058GLU-1', '022GLN-147TYR-1', '022ILE-072HIE-1',
        '022ILE-074ILE-1', '022LEU-057THR-1', '022LEU-058PHE-1', '022LEU-062ILE-1', '022LEU-065LEU-1',
        '022LEU-081LYS-2', '022LYS-086ILE-1', '022MET-041VAL-1', '022PHE-027ILE-1', '022PHE-031ILE-1',
        '022PHE-039TRP-1', '022PHE-040ALA-1', '022PHE-041PHE-1', '022PHE-064VAL-1', '022PHE-069VAL-1',
        '022PHE-069VAL-2', '022PHE-099ALA-1', '022PHE-166ILE-1', '022PHE-168TYR-1', '022SER-121LEU-1',
        '022TRP-026THR-1', '022TRP-039TYR-1', '022TRP-040TRP-1', '022TRP-043ILE-1', '022TRP-055LEU-2',
        '022TRP-059VAL-1', '022VAL-067LEU-1', '022VAL-079TYR-1', '022VAL-079TYR-2',  # dropped 023ARG-026GLU-1
        '023ASP-027ARG-1', '023ASP-042ARG-1', '023ASP-057ARG-1', '023GLN-177PRO-1', '023GLN-217THR-1',
        '023GLU-028LEU-1', '023GLU-046LYS-1', '023ILE-060PRO-1', '023LEU-035PHE-1', '023LEU-035PHE-2',
        '023LEU-036ARG-1', '023LEU-055ILE-1', '023LEU-097LEU-1', '023LYS-029GLU-1', '023LYS-029GLU-2',
        '023LYS-064TYR-1', '023LYS-064TYR-2', '023MET-038ILE-1', '023SER-051ASN-1', '023THR-085ALA-1',
        '023TYR-026LEU-1', '023TYR-031TYR-1', '023VAL-041ILE-1', '023VAL-055LEU-1', '024ALA-034ALA-1',
        '024ARG-073ASN-1', '024ARG-076GLU-1', '024ASN-027ARG-1', '024ASN-027LEU-2', '024ASN-029ILE-1',
        '024ASN-034TYR-1', '024ASN-056PHE-1', '024ASN-058TYR-1', '024ASP-065HIE-1', '024CYS-100ASN-1',
        '024GLU-040HIE-1', '024GLU-041LEU-1', '024GLU-050ARG-1', '024GLU-054ARG-1', '024ILE-055TYR-1',
        '024LEU-028GLU-1', '024LEU-028GLU-2', '024LEU-029GLU-1', '024LEU-031LEU-1', '024LEU-032VAL-1',
        '024LEU-054VAL-1', '024LEU-260ILE-1', '024LEU-261ASN-1', '024LYS-057TYR-1', '024LYS-069TYR-1',
        '024LYS-069TYR-2', '024PHE-089LEU-1', '024PHE-089THR-1', '024PHE-099TRP-1', '024PHE-100SER-1',
        '024PHE-130LYS-1', '024SER-038THR-1', '024THR-041GLU-1', '024VAL-032HIE-1', '024VAL-049ILE-1',
        '024VAL-054PHE-1', '024VAL-079PHE-1', '024VAL-142VAL-1', '024VAL-143GLN-1', '025ALA-035TRP-1',
        '025ALA-037ALA-1', '025ASN-181ASN-1', '025ASN-183THR-1', '025GLN-029LYS-1', '025GLN-036THR-1',
        '025GLN-039TYR-1', '025GLN-260ILE-1', '025GLN-274ILE-1', '025ILE-028VAL-1', '025ILE-036VAL-1',
        '025ILE-056LEU-1', '025ILE-059ASP-1', '025ILE-084ILE-1', '025ILE-084ILE-2', '025ILE-090ALA-1',
        '025ILE-091VAL-1', '025LEU-055VAL-1', '025LEU-060PRO-1', '025LEU-075ILE-1', '025LEU-075ILE-2',
        '025SER-035ALA-1', '025SER-075ASP-1', '025SER-100ILE-1', '025THR-045THR-1', '025THR-100TRP-1',
        '025THR-103LYS-1', '025TRP-038MET-1', '025TRP-135ALA-1', '025TRP-144LYS-1', '025TRP-146PHE-1',
        '025TRP-152GLU-1', '025TYR-080ARG-1', '025TYR-081PHE-1', '025TYR-084LEU-1', '025VAL-029TRP-1',
        '025VAL-057VAL-1', '025VAL-069ILE-1', '025VAL-083GLU-2', '025VAL-185ARG-1', '026ASN-054ASN-1',
        '026ASN-055ILE-1', '026ASN-058GLU-1', '026ASP-042PHE-1', '026ASP-077PHE-1', '026GLN-065HIE-1',
        '026GLN-065HIE-2', '026GLU-042HIE-1', '026GLU-057TYR-2', '026GLU-059ARG-1', '026ILE-037TRP-1',
        '026ILE-078ALA-1', '026LEU-037PHE-1', '026LEU-039ILE-1', '026LEU-040GLU-1', '026LEU-041VAL-1',
        '026LEU-135ALA-1', '026MET-029PHE-1', '026MET-099ALA-1', '026MET-103HIE-1', '026MET-168TYR-1',
        '026PHE-030TRP-1', '026PHE-036PHE-1', '026PHE-118ILE-1', '026PHE-217THR-1', '026THR-031LEU-1',
        '026TYR-062ILE-1', '026TYR-069TYR-1', '026VAL-041GLU-1', '026VAL-041GLU-2', '027ALA-074LEU-1',
        '027ALA-102ASN-1', '027ARG-049GLU-1', '027ARG-055THR-1', '027ARG-094ASP-1', '027ILE-039THR-1',
        '027ILE-046PHE-1', '027ILE-075LEU-1', '027LYS-089LEU-1', '027PHE-030ILE-1', '027PHE-057VAL-1',
        '027PHE-069SER-1', '027PHE-071VAL-1', '027PHE-078GLN-1', '027PRO-032MET-1', '027SER-034ILE-1',
        '027THR-036SER-1', '027VAL-070TRP-1', '027VAL-085ALA-1', '027VAL-086TYR-1', '027VAL-088ILE-1',
        '027VAL-090THR-1', '028ALA-038VAL-1', '028ALA-041VAL-1', '028ARG-031GLN-1', '028GLU-072HIE-1',
        '028GLU-097LYS-1', '028ILE-036LEU-1', '028ILE-091VAL-1', '028ILE-106VAL-1', '028ILE-151VAL-1',
        '028LEU-037VAL-1', '028LEU-055LYS-1', '028LEU-058ALA-1', '028LEU-059ARG-2', '028LEU-061GLU-1',
        '028LEU-133PHE-1', '028LYS-067TYR-1', '028LYS-317ASN-1', '028MET-031ASP-1', '028MET-037ARG-2',
        '028MET-040HIE-1', '028PRO-058LEU-1', '028PRO-111LEU-1', '028SER-055THR-1', '028SER-056GLU-1',
        '028VAL-031THR-1', '028VAL-036MET-1', '028VAL-038VAL-1', '028VAL-058PHE-1', '028VAL-085GLU-1',
        '028VAL-086ASN-1', '028VAL-105PHE-1', '028VAL-128PHE-1', '028VAL-170LEU-1', '029ALA-274ILE-1',
        '029ASN-034LYS-2', '029ASN-179SER-1', '029ASP-070ASP-1', '029GLN-033ASP-1', '029GLU-045LEU-1',
        '029GLU-055SER-1', '029LEU-034VAL-1', '029LEU-036PHE-2', '029LEU-040GLU-1', '029LEU-045GLN-1',
        '029LEU-095TYR-1', '029LYS-035GLU-1', '029PHE-094LEU-1', '029PHE-101TRP-1', '029PHE-103HIE-1',
        '029PHE-168TYR-1', '029PHE-177ILE-1', '029PRO-085GLU-1', '029THR-121TYR-1', '029THR-121TYR-2',
        '029TRP-302SER-1', '029TRP-305ILE-1', '029TRP-308ASP-1', '029TRP-315PHE-1', '029TYR-049GLU-1',
        '029VAL-036VAL-1', '029VAL-054LEU-1', '029VAL-087LEU-1', '030ALA-274ILE-1', '030ASP-320ARG-1',
        '030GLN-034TRP-1', '030GLN-034TRP-2', '030GLN-036MET-1', '030GLU-033GLN-1', '030GLU-034ASP-1',
        '030GLU-038PHE-1', '030GLU-042PHE-1', '030GLU-049PHE-1', '030GLU-061LYS-1', '030ILE-034LEU-1',
        '030ILE-055ILE-1', '030ILE-093TYR-1', '030LEU-034LEU-1', '030LYS-078TYR-2', '030LYS-083GLU-1',
        '030LYS-085GLU-1', '030LYS-169THR-1', '030PHE-042LEU-1', '030PHE-044ILE-1', '030PHE-061GLU-2',
        '030PHE-151ILE-1', '030PRO-057MET-1', '030SER-109GLU-1', '030THR-121LYS-1', '030TRP-033THR-1',
        '030TRP-036PHE-1', '030TRP-042GLU-1', '030TRP-046LEU-1', '030TRP-073PHE-1', '030TRP-079LEU-1',
        '030TRP-103PHE-1', '030TRP-171THR-1', '030TRP-176SER-2', '030TRP-212GLU-1', '030TRP-213GLU-1',
        '030TRP-216SER-1', '030TRP-217THR-1', '030VAL-033VAL-1', '030VAL-044LEU-1', '030VAL-050ILE-1',
        '031ALA-088VAL-1', '031ASP-034HIE-1', '031HIE-035LEU-1', '031HIE-037SER-1', '031HIE-109LEU-1',
        '031HIE-125LEU-1', '031HIE-128GLU-1', '031ILE-034ILE-1', '031ILE-097TRP-1', '031ILE-246ALA-1',
        '031LEU-091LEU-1', '031LEU-125LEU-1', '031LEU-168LEU-1', '031LEU-213GLU-1', '031PHE-060THR-1',
        '031PHE-061ILE-1', '031PHE-062HIE-1', '031PHE-076ALA-1', '031PHE-092TRP-2', '031PHE-095TYR-1',
        '031PRO-097VAL-1', '031THR-085GLU-1', '031THR-128PHE-1', '031TRP-060ASP-1', '031TRP-164VAL-1',
        '031TRP-168GLN-1', '031TRP-168GLN-2', '031TRP-171ALA-1', '031TYR-037PHE-2', '031TYR-048HIE-1',
        '031TYR-051GLN-1', '031VAL-056PHE-1', '031VAL-068LEU-1', '031VAL-071VAL-1', '031VAL-073VAL-1',
        '031VAL-077ILE-1', '032ASP-040HIE-1', '032GLN-116ASP-1', '032GLU-035ARG-1', '032GLU-169THR-1',
        '032GLU-169THR-2', '032ILE-036GLU-1', '032ILE-065LEU-1', '032LYS-080GLU-2', '032LYS-083LEU-1',
        '032LYS-091LEU-1', '032LYS-091LEU-2', '032PHE-058ASP-1', '032PHE-081VAL-1', '032PHE-095LEU-1',
        '032SER-057GLU-1', '032THR-093LYS-1', '032THR-094LEU-1', '032THR-128LEU-1', '032TRP-062ALA-1',
        '032TRP-073PHE-1', '032TRP-074VAL-1', '032TRP-083ASN-1', '032VAL-042ILE-1', '032VAL-052VAL-1',
        '032VAL-056HIE-1', '032VAL-068LEU-1', '032VAL-080ARG-1', '032VAL-100VAL-1', '033ARG-189PRO-1',
        '033ARG-191LEU-1', '033ARG-191LEU-2', '033ASP-276SER-1', '033ASP-279LYS-1', '033ASP-279LYS-2',
        '033CYS-047TYR-1', '033GLN-092ASN-2', '033GLU-036ARG-1', '033HIE-060MET-2', '033HIE-062THR-1',
        '033ILE-037ASP-1', '033ILE-061VAL-1', '033LEU-053VAL-1', '033LEU-059ILE-1', '033LEU-061PRO-1',
        '033LEU-089ILE-1', '033PHE-058PHE-1', '033THR-100GLN-1', '033TYR-062HIE-1', '033TYR-091ASN-1',
        '033TYR-094ILE-1', '033TYR-094ILE-2', '033VAL-048ILE-1', '033VAL-055VAL-1', '033VAL-091ASN-1',
        '034ALA-133LYS-1', '034ALA-152GLU-1', '034ARG-060TYR-1', '034ARG-064LEU-1', '034ASN-076SER-1',
        '034ASN-078TYR-1', '034ASP-037PHE-1', '034ASP-061ARG-1', '034HIE-057HIE-1', '034ILE-037TYR-1',
        '034LEU-038TYR-1', '034LEU-044TRP-1', '034LYS-068GLU-1', '034LYS-070TRP-1', '034LYS-070TRP-2',
        '034LYS-086TYR-1', '034LYS-086TYR-2', '034PHE-045TRP-1', '034PHE-058CYS-1', '034PHE-062HIE-1',
        '034PHE-069MET-1', '034PHE-072LEU-1', '034PHE-100VAL-2', '034PRO-065ALA-1', '034PRO-075PRO-1',
        '034SER-105LEU-1', '034TRP-037TRP-1', '034TYR-136ALA-1', '034TYR-143MET-1', '034TYR-148VAL-1',
        '034TYR-277TYR-1', '034VAL-046LEU-1', '034VAL-048PHE-1', '034VAL-072VAL-1', '034VAL-077LEU-1',
        '034VAL-111LEU-1', '035ALA-065LEU-1', '035ALA-067ARG-1', '035ARG-041THR-1', '035ARG-042VAL-1',
        '035ASN-172GLU-1', '035ASN-174TYR-1', '035ASP-046ARG-1', '035CYS-038CYS-1', '035CYS-154THR-1',
        '035GLU-189PRO-1', '035HIE-059ARG-1', '035HIE-059ARG-2', '035HIE-061ARG-1', '035LEU-061PRO-1',
        '035LEU-085LEU-1', '035LYS-083TYR-1', '035LYS-090GLU-1', '035PHE-047TYR-1', '035PHE-062THR-1',
        '035PHE-097LEU-1', '035PHE-111PHE-1', '035PHE-128PHE-1', '035THR-112LYS-1', '035TRP-045HIE-1',
        '035TRP-058PHE-1', '035TRP-064ARG-1', '035TRP-157VAL-1', '035TRP-161LYS-1', '036ARG-042GLU-1',
        '036ARG-162GLN-1', '036CYS-039CYS-1', '036GLN-040HIE-1', '036GLN-105LEU-1', '036GLU-039ARG-1',
        '036GLU-039LYS-1', '036GLU-045LEU-1', '036GLU-053VAL-1', '036GLU-056ARG-1', '036HIE-063LEU-1',
        '036ILE-040THR-1', '036ILE-061ILE-1', '036ILE-063TRP-1', '036LEU-039MET-1', '036LEU-041ILE-1',
        '036LEU-046PHE-1', '036LEU-046PHE-2', '036LEU-047TYR-1', '036LEU-098ILE-1', '036MET-049LEU-1',
        '036MET-054VAL-1', '036PHE-075SER-2', '036PHE-113ASP-1', '036PHE-303TRP-1', '036SER-069THR-1',
        '036THR-090GLU-1', '036THR-104MET-1', '036THR-133PHE-1', '036TRP-047PHE-1', '036TRP-049PRO-1',
        '036VAL-060TYR-1', '036VAL-070TRP-1', '036VAL-086TYR-1', '037ALA-056ILE-1', '037ARG-152GLU-1',
        '037ASN-040THR-1', '037ASN-067GLU-1', '037ASP-040ARG-1', '037ASP-064TYR-1', '037HIE-050GLU-1',
        '037ILE-116PHE-1', '037ILE-125LEU-1', '037ILE-162PRO-1', '037ILE-165VAL-1', '037LYS-162PHE-1',
        '037PHE-048HIE-1', '037SER-043ASP-1', '037THR-053ILE-1', '037THR-085LYS-2', '037TRP-050ALA-1',
        '037TRP-053LEU-1', '037TRP-055LYS-1', '037TRP-055LYS-2', '037TYR-046THR-1', '037TYR-050LYS-1',
        '037TYR-066LEU-1', '037TYR-068VAL-1', '038ASN-199LEU-1', '038ASN-202PHE-1', '038CYS-095PHE-1',
        '038GLN-042ASP-1', '038ILE-085ARG-1', '038ILE-094LYS-1', '038LEU-045PHE-1', '038LEU-047TYR-2',
        '038LEU-054LEU-1', '038LEU-109SER-1', '038LEU-109VAL-1', '038LYS-047PHE-1', '038MET-041LEU-1',
        '038MET-146PHE-1', '038PHE-042PHE-1', '038PHE-042VAL-1', '038PHE-046ARG-1', '038PHE-049PHE-1',
        '038PHE-061VAL-1', '038PHE-061VAL-2', '038PHE-101PRO-1', '038PRO-108ARG-1', '038THR-053PHE-1',
        '038TRP-063TRP-1', '038TRP-065PRO-1', '038TRP-068TYR-1', '038TRP-073ILE-1', '038TRP-078ALA-1',
        '038TRP-081TYR-1', '038TRP-082ILE-1', '038TRP-132ILE-1', '038TYR-060TYR-1', '038VAL-041VAL-1',
        '038VAL-072PHE-1', '038VAL-082PHE-1', '038VAL-083ILE-1', '039ALA-095PHE-1', '039ARG-043ASN-2',
        '039ASN-042ARG-1', '039ASN-081SER-1', '039ASN-083TYR-1', '039ASP-057THR-1', '039GLN-047ARG-1',
        '039HIE-057HIE-1', '039ILE-054LEU-1', '039ILE-055TYR-1', '039ILE-108ILE-1', '039ILE-109CYS-1',
        '039LYS-043HIE-1', '039PRO-165PHE-1', '039PRO-166ILE-1', '039PRO-199LEU-1', '039SER-054GLU-1',
        '039SER-067GLU-1', '039THR-046THR-1', '039THR-077LEU-1', '039THR-079LEU-1', '039THR-083VAL-1',
        '039TRP-052SER-1', '039TRP-064VAL-1', '039TRP-066LEU-1', '039TRP-066LEU-2', '039TYR-043ILE-1',
        '039VAL-083TYR-1', '040ASN-073PHE-1', '040ASN-077TYR-1', '040ASN-090ARG-1', '040ASP-065THR-1',
        '040GLU-045GLN-1', '040HIE-103HIE-1', '040HIE-105LEU-1', '040ILE-054VAL-1', '040ILE-057LYS-1',
        '040LEU-063TYR-1', '040MET-085ARG-1', '040PHE-052TYR-1', '040PHE-116PHE-1', '040PHE-133PHE-1',
        '040THR-044TRP-1', '040THR-048VAL-1', '040THR-162GLN-1', '040THR-186TYR-1', '040THR-270TYR-1',
        '040TRP-052GLN-1', '040TRP-055LEU-1', '040TRP-121ILE-1', '040TRP-121ILE-2', '040TRP-122THR-1',
        '040TYR-045TYR-1', '040TYR-055VAL-1', '040TYR-076VAL-1', '040TYR-079ILE-1', '040TYR-082PHE-1',
        '040VAL-063VAL-1', '041ALA-047TRP-1', '041ALA-081GLU-1', '041ALA-121ALA-1', '041ARG-051PHE-1',
        '041ASP-084ARG-1', '041GLU-045LYS-1', '041ILE-058ARG-1', '041ILE-061PHE-1', '041ILE-107PHE-1',
        '041ILE-107PHE-2', '041LEU-146PHE-1', '041LEU-155PRO-1', '041LEU-162PHE-1', '041LEU-170TRP-1',
        '041LYS-045GLN-1', '041LYS-107PHE-2', '041LYS-110SER-1', '041PHE-047SER-1', '041PHE-054HIE-1',
        '041PHE-073ALA-1', '041PHE-077LEU-1', '041PHE-094LYS-1', '041PHE-094LYS-2', '041PHE-104VAL-2',
        '041VAL-059LEU-1', '041VAL-064LYS-1', '042ALA-082ILE-1', '042ASP-045THR-1', '042GLU-095PHE-1',
        '042GLU-101PRO-1', '042GLU-103PHE-1', '042GLU-121ALA-1', '042ILE-049PHE-1', '042ILE-052PRO-1',
        '042ILE-056PHE-1', '042LEU-047ILE-1', '042LEU-048ILE-1', '042LEU-048VAL-1', '042LEU-103HIE-1',
        '042LEU-105LEU-1', '042LYS-049GLU-1', '042PHE-049PHE-1', '042PHE-054PHE-1', '042PHE-056SER-1',
        '042PHE-061LEU-1', '042PHE-064LYS-1', '042PHE-074LEU-1', '042PHE-077PHE-1', '042PHE-085PHE-1',
        '042PHE-087LEU-1', '042PHE-088ASP-1', '042PHE-089ALA-1', '042PHE-089MET-1', '042PHE-092TYR-1',
        '042PHE-101VAL-1', '042SER-058ILE-1', '042SER-062ASP-1', '042THR-052ASN-1', '042TRP-049ARG-1',
        '043ALA-073PHE-1', '043ALA-077TYR-1', '043ASP-054HIE-1', '043ASP-058ARG-1', '043ASP-062TYR-1',
        '043GLU-104ALA-1', '043ILE-055LEU-1', '043LEU-050PHE-1', '043LEU-055THR-1',  # dropped 043GLU-051PHE-1
        '043LEU-071PHE-1', '043LEU-114SER-1', '043LEU-161TYR-1', '043MET-048ILE-1', '043MET-060VAL-1',
        '043PHE-065PHE-1', '043PHE-068TRP-1', '043PHE-073PHE-1', '043THR-059LEU-1', '043TYR-048GLN-1',
        '043TYR-049THR-1', '043TYR-068LYS-1', '043TYR-185HIE-1', '043TYR-186TYR-1', '043VAL-066LEU-1',
        '043VAL-069VAL-1', '044ALA-052ASP-1', '044ASN-048THR-2', '044ASN-059THR-1', '044GLN-061LYS-2',
        '044GLU-084ARG-1', '044HIE-067HIE-1', '044HIE-073TRP-1', '044HIE-086GLU-1', '044ILE-101HIE-1',
        '044LEU-079VAL-1', '044LEU-101ILE-1', '044LEU-272GLN-1', '044LEU-272GLN-2', '044MET-061VAL-1',
        '044PHE-048LEU-1', '044PHE-130VAL-1', '044PRO-053ASP-1', '044SER-093ARG-1', '044SER-118ARG-2',
        '044THR-118TYR-1', '044TRP-048TYR-1', '044TRP-085PHE-1', '044TRP-147TYR-1', '044TYR-048LYS-2',
        '044TYR-059ILE-1', '044TYR-077LEU-1', '044TYR-109LEU-1', '044VAL-174MET-1', '045ALA-054HIE-1',
        '045ALA-071HIE-1', '045ASP-081GLU-1', '045GLN-062LYS-2', '045HIE-051GLU-1', '045HIE-053ILE-1',
        '045LEU-049GLU-1', '045LEU-049TYR-1', '045LEU-054PHE-1', '045LEU-055ASP-1', '045LEU-070PHE-1',
        '045LEU-097LEU-1', '045LYS-048GLU-1', '045LYS-084GLU-1', '045PHE-057GLU-1', '045PHE-061VAL-1',
        '045PHE-066PHE-1', '045PHE-075LYS-1', '045PRO-080VAL-1', '045PRO-100VAL-1', '045THR-048ALA-2',
        '045THR-066VAL-1', '045THR-097SER-1', '045THR-168LYS-1', '045TRP-048ILE-1', '045TRP-049ILE-1',
        '045TRP-100VAL-1', '045TRP-272GLN-1', '045TYR-053THR-1', '046ARG-050ASP-2', '046ARG-092TYR-1',
        '046ARG-182GLU-1', '046ARG-273GLU-1', '046ASP-083ASP-2', '046ILE-071GLU-1', '046ILE-074LEU-1',
        '046LEU-068ILE-1', '046LEU-103PHE-1', '046PHE-050LYS-1', '046PHE-084LEU-1', '046PHE-088MET-1',
        '046PHE-107PHE-1', '046PHE-119GLN-2', '046PHE-121LEU-1', '046PHE-161TYR-1', '046PRO-140ALA-1',
        '046PRO-141ARG-1', '046SER-054PHE-1', '046SER-088ASP-1', '046THR-069ASN-1', '046VAL-094PHE-1',
        '047ARG-050GLU-1', '047ARG-059MET-1', '047ASN-062LYS-1', '047ASN-276PRO-1', '047ILE-064LEU-1',
        '047LEU-055LEU-1', '047LYS-059ASP-1', '047PRO-164TRP-1', '047SER-065PHE-1', '047TRP-081GLU-1',
        '047TRP-083TYR-1', '047TYR-052PHE-1', '047TYR-053ASP-1', '047TYR-055ASN-1', '047TYR-058TYR-1',
        '047TYR-075ILE-1', '047TYR-077HIE-1', '047TYR-111PHE-1', '047TYR-136TYR-1', '048ARG-060MET-1',
        '048ASN-052ASN-1', '048ASP-081THR-1', '048ASP-131LYS-1', '048GLN-070SER-1', '048HIE-052PHE-1',
        '048HIE-091ARG-1', '048HIE-099HIE-2', '048HIE-174MET-1', '048HIE-178ASP-1', '048ILE-052ILE-1',
        '048ILE-272GLN-1', '048ILE-279ILE-1', '048LEU-070PHE-1', '048LEU-070PHE-2', '048LEU-074TYR-1',
        '048LEU-074TYR-2', '048LEU-077GLN-1', '048LEU-141PHE-1', '048LYS-082ILE-1', '048LYS-098GLU-1',
        '048PHE-058PHE-1', '048PHE-101LEU-1', '048PHE-105TYR-1', '048VAL-093THR-1', '048VAL-095LEU-1',
        '048VAL-099ILE-1', '049ALA-092TYR-1', '049ARG-167GLN-1', '049GLU-080ARG-1', '049ILE-059ASP-1',
        '049ILE-070PHE-1', '049ILE-100VAL-1', '049LEU-054VAL-1', '049LEU-107PHE-1', '049LYS-121LEU-1',
        '049LYS-158ASP-1', '049PHE-056PHE-1', '049PHE-057GLN-2', '049PHE-091ARG-1', '049PHE-093VAL-1',
        '049PRO-052TYR-1', '049THR-053LEU-1', '049TYR-054PHE-1', '049TYR-098GLU-1', '049TYR-102ASN-1',
        '049VAL-053THR-1', '049VAL-124GLN-1', '049VAL-127LEU-1', '049VAL-131VAL-1', '050ALA-081PHE-1',
        '050ARG-054THR-1', '050ASN-083TYR-1', '050ASP-053THR-1', '050ASP-067PHE-1', '050ASP-092TYR-1',
        '050GLN-055TYR-1', '050HIE-065PHE-1', '050HIE-087TYR-1', '050ILE-053ILE-1', '050ILE-071PRO-1',
        '050ILE-079VAL-1', '050LYS-056GLU-1', '050PHE-071PHE-1', '050PRO-053TYR-1', '050PRO-058PHE-1',
        '050PRO-096TYR-1', '050SER-066PHE-1', '050THR-143THR-1', '050TRP-054GLU-1', '050VAL-054THR-1',
        '051CYS-154LYS-1', '051CYS-156THR-1', '051GLN-089GLU-1', '051GLN-089GLU-2', '051GLN-098TYR-1',
        '051GLU-056MET-1', '051GLU-056MET-2', '051HIE-277ASP-1', '051ILE-068LEU-1', '051LEU-055ASP-1',
        '051LEU-080ARG-1', '051LEU-096TYR-1', '051LEU-131LYS-1', '051PHE-058VAL-1', '051PHE-091ARG-1',
        '051PHE-091ARG-2', '051PHE-175PHE-1', '051THR-152PHE-1', '051TRP-093VAL-1', '051TRP-095LEU-1',
        '051TRP-097ARG-1', '051TRP-097ARG-2', '051TRP-107PHE-1', '051VAL-071ALA-1', '051VAL-104ILE-1',
        '052ASN-061ASN-1', '052ASN-143THR-1', '052GLN-069ARG-1', '052GLN-117PHE-1', '052ILE-056GLN-1',
        '052ILE-087VAL-1', '052ILE-100VAL-1', '052LEU-060LEU-1', '052LEU-062PHE-1', '052LEU-062PHE-2',
        '052LEU-070PHE-1', '052LEU-141PHE-1', '052LEU-152PHE-1', '052PHE-056MET-1', '052PHE-061CYS-1',
        '052PHE-071PHE-1', '052PHE-073THR-1', '052PHE-075ILE-1', '052PHE-111PHE-1', '052PHE-141MET-1',
        '052PHE-148ALA-1', '052PHE-157ILE-1', '052PRO-109LEU-1', '052SER-063PHE-1', '052TYR-058PHE-1',
        '052TYR-061ASP-1', '052TYR-116PHE-1', '052VAL-057SER-1', '053ASN-063SER-1', '053ASN-131VAL-1',
        '053ASP-058TYR-1', '053ILE-066LEU-1', '053ILE-069PHE-1', '053ILE-075LEU-1', '053ILE-077LEU-1',
        '053LEU-057PHE-1', '053LEU-091ILE-1', '053MET-140ASP-1', '053SER-089GLU-1', '053TYR-059LEU-1',
        '053TYR-083ASP-1', '053TYR-092TYR-1', '053TYR-094LYS-1', '053TYR-142ALA-1', '053TYR-169MET-1',
        '053VAL-057ARG-1', '053VAL-068PHE-1', '053VAL-074ALA-1', '053VAL-117PHE-1', '054ASN-069PHE-1',
        '054ASN-141ASN-1', '054GLU-057ARG-2', '054GLU-058ARG-1', '054GLU-141GLN-1', '054ILE-074ALA-1',
        '054LEU-061LEU-1', '054LEU-063PHE-1', '054LEU-069VAL-1', '054LEU-091LEU-1', '054LEU-091LEU-2',
        '054PHE-101ILE-1', '054THR-057ASP-2', '054VAL-091ALA-1', '054VAL-097ILE-1', '055ASN-058GLU-1',
        '055ASN-058TYR-1', '055ASP-069ARG-1', '055ASP-104LYS-1', '055ASP-105TYR-1', '055ASP-185ARG-1',
        '055GLN-272GLU-1', '055GLU-121LEU-1', '055ILE-059ILE-1', '055ILE-061CYS-1', '055ILE-151THR-1',
        '055ILE-155ILE-1', '055LEU-060VAL-1', '055PHE-139ALA-1', '055PHE-141GLN-1', '055PHE-141GLN-2',
        '055SER-071PHE-1', '055SER-152PHE-1', '055THR-072THR-1', '055VAL-059ILE-1', '056ALA-061VAL-1',
        '056ALA-175PHE-1', '056ARG-061LEU-1', '056HIE-287LEU-1', '056HIE-287LEU-2', '056ILE-059PHE-1',
        '056ILE-059PHE-2', '056LEU-069LEU-1', '056LYS-160ASP-1', '056MET-059MET-1', '056MET-181ALA-1',
        '056PHE-062PHE-1', '056PHE-129PHE-1', '056PHE-152PHE-1', '056SER-076LEU-1', '056TYR-062TYR-1',
        '056TYR-064VAL-1', '056TYR-084ILE-1', '057ARG-067VAL-1', '057GLU-061ARG-1', '057MET-060MET-1',
        '057PHE-060LEU-1', '057PHE-066ILE-1', '057PHE-098VAL-1', '057PHE-116PHE-1', '057PHE-163ILE-1',
        '057PRO-063TYR-1', '057TYR-091LEU-1', '057VAL-084ASP-1', '057VAL-084ASP-2', '057VAL-181ASN-1',
        '058ARG-062LEU-1', '058ARG-141GLN-1', '058ASP-279LYS-1', '058GLN-067PHE-1', '058GLN-067PHE-2',
        '058HIE-067GLN-1', '058HIE-115GLN-1', '058ILE-097TRP-1', '058LEU-071VAL-1', '058LEU-084LEU-1',
        '058LEU-094GLN-1', '058LYS-122VAL-1', '058PHE-062ILE-1', '058PHE-062TYR-1', '058PHE-070TRP-1',
        '058PHE-081PHE-1', '058PHE-101ILE-1', '058PHE-131VAL-1', '058TRP-084SER-1', '058TRP-180SER-1',
        '058TYR-062GLN-1', '058TYR-062GLN-2', '058TYR-062LYS-1', '058TYR-066VAL-1', '058TYR-068ILE-1',
        '058TYR-077ALA-1', '058VAL-085ILE-1', '059ARG-065MET-1', '059ARG-067GLN-2', '059ASN-062LYS-2',
        '059ILE-068ILE-1', '059ILE-094LEU-1', '059LEU-117VAL-1', '059LEU-117VAL-2', '059LEU-119GLN-1',
        '059LYS-063ASP-2', '059LYS-075TRP-1', '059LYS-135ASP-1', '059PHE-063ASN-1', '059PHE-118THR-1',
        '059PHE-120TRP-1', '059PHE-127ILE-1', '059THR-088TYR-1', '059VAL-084LEU-1', '059VAL-136TRP-1',
        '060ALA-081LEU-1', '060ASP-165ASP-1', '060LEU-068PHE-1', '060LEU-095PHE-1', '060LEU-095PHE-2',
        '060LEU-098VAL-1', '060LEU-120VAL-1', '060LEU-152PHE-1', '060MET-070GLU-1', '060THR-087LYS-1',
        '060THR-176ARG-1', '060TYR-064LEU-1', '060TYR-128PRO-2', '060VAL-063TYR-1', '060VAL-157PRO-1',
        '061ALA-080ALA-1', '061ARG-083GLU-1', '061ARG-083GLU-2', '061ARG-084LEU-1', '061ASN-065ASN-2',
        '061ASP-065LYS-1', '061GLU-080ARG-2', '061GLU-088PHE-1', '061GLU-142MET-1', '061GLU-145LEU-1',
        '061ILE-064PHE-1', '061ILE-086ASP-1', '061ILE-089MET-1', '061ILE-091ILE-1', '061ILE-092TRP-1',
        '061ILE-098LEU-1', '061ILE-155ASP-1', '061LEU-065MET-1', '061LEU-079ALA-1', '061PHE-068VAL-1',
        '061PHE-086VAL-1', '061PHE-086VAL-2', '061PHE-099ALA-1', '061PHE-117VAL-1', '061PRO-088PHE-1',
        '061THR-081THR-1', '061THR-083GLU-1', '061TYR-066LEU-1', '061VAL-064TYR-1', '061VAL-066VAL-1',
        '061VAL-068ILE-1', '062ALA-070MET-1', '062ASP-080ARG-1', '062GLN-110GLN-1', '062GLN-112PHE-1',
        '062GLN-171PRO-1', '062GLN-173TYR-1', '062GLN-173TYR-2', '062HIE-070GLU-1', '062HIE-072LEU-1',
        '062HIE-073TYR-1', '062HIE-076ALA-1', '062ILE-067ILE-1', '062ILE-069TYR-1', '062ILE-105TYR-1',
        '062ILE-107PHE-1', '062LEU-075ILE-1', '062LEU-077ALA-1', '062LEU-079LEU-1', '062LYS-067PHE-2',
        '062LYS-147GLU-1', '062PHE-120TYR-1', '062PHE-128PRO-1', '062THR-099ARG-1', '062THR-102HIE-1',
        '062TRP-073ALA-1', '062TRP-164PHE-1', '062TRP-166PRO-1', '062TYR-077PHE-1', '062TYR-083GLU-1',
        '062TYR-084ILE-1', '062TYR-093ILE-1', '062TYR-095TRP-1', '063ASN-081THR-1', '063GLN-067ASP-1',
        '063GLN-136TRP-1', '063GLN-165ASP-1', '063ILE-077LEU-1', '063LEU-068HIE-1', '063LEU-108LEU-1',
        '063LEU-140LEU-1', '063PRO-090GLN-1', '063PRO-090GLN-2', '063PRO-091ILE-1', '063PRO-094VAL-1',
        '063THR-092TRP-1', '063TRP-081TYR-1', '063TRP-085MET-1', '063TRP-098LEU-1', '063TRP-136PHE-1',
        '063VAL-067LEU-1', '063VAL-154THR-1', '064GLU-111TRP-1', '064ILE-072PRO-1', '064ILE-084TYR-1',
        '064ILE-084TYR-2', '064ILE-090TYR-1', '064PHE-097PRO-1', '064PHE-123THR-1', '064PHE-125TRP-1',
        '064SER-171PRO-1', '064THR-116PHE-1', '064TYR-068LYS-1', '064TYR-078PHE-1', '064TYR-082VAL-1',
        '064TYR-083LEU-1', '064TYR-164PHE-1', '064VAL-073ALA-1', '064VAL-143GLN-2', '065ALA-070PHE-1',
        '065ASN-110GLN-1', '065ASP-110GLN-1', '065GLN-088TYR-1', '065LEU-077VAL-1', '065LEU-080VAL-1',
        '065MET-117PHE-1', '065PHE-095LEU-1', '065PRO-101LEU-1', '065PRO-111TRP-1', '065SER-068TYR-1',
        '065SER-108TYR-1', '065THR-069ILE-1', '065THR-082LEU-1', '065TRP-146THR-1', '065TRP-154THR-1',
        '065TYR-090PRO-1', '066ALA-084ALA-1', '066ALA-136TRP-1', '066ARG-167GLU-1', '066ASP-069ARG-2',
        '066GLN-070ASN-1', '066HIE-069GLU-1', '066ILE-146VAL-1', '066LEU-073PRO-1', '066LEU-138THR-1',
        '066PHE-075LYS-1', '066PHE-109SER-1', '066PRO-095TRP-1', '066TRP-109TYR-1', '066TRP-110PRO-1',
        '066VAL-085ALA-1', '067ARG-077ILE-1', '067ASP-070ALA-1', '067GLN-115GLN-1', '067GLN-117PHE-1',
        '067GLU-139TYR-1', '067HIE-070HIE-1', '067HIE-086GLU-1', '067LEU-078LYS-1', '067LEU-107LEU-1',
        '067LEU-109VAL-1', '067PRO-095TRP-1', '067PRO-101ILE-1', '067SER-073TYR-1', '067THR-080TYR-1',
        '067THR-082VAL-2', '067VAL-085ASN-1', '068ARG-072THR-1', '068HIE-075LYS-1', '068HIE-080GLU-1',
        '068HIE-123ASP-1', '068ILE-072LYS-1', '068ILE-084TYR-1', '068ILE-091LEU-1', '068LEU-081VAL-1',
        '068LEU-146PHE-1', '068MET-131LEU-1', '068PHE-076LEU-1', '068PHE-076LEU-2', '068PHE-077ILE-1',
        '068PHE-077VAL-1', '068PHE-080LEU-1', '068PHE-080VAL-1', '068PHE-083LEU-1', '068PHE-110LEU-1',
        '068TYR-073ILE-1', '068TYR-078ALA-1', '068TYR-082HIE-1', '069ARG-075ILE-1', '069ASN-119VAL-1',
        '069GLU-076ILE-1', '069GLU-076ILE-2', '069GLU-078ARG-1', '069GLU-123ASP-1', '069HIE-075ILE-1',
        '069HIE-078PHE-1', '069ILE-101ILE-1', '069PHE-078GLU-1', '069PHE-080TYR-1', '069PHE-166TYR-1',
        '069THR-080LEU-1', '069VAL-073TRP-1', '069VAL-086GLU-1', '069VAL-086ILE-1', '069VAL-114VAL-1',
        '070ASN-080GLU-1', '070ASP-076THR-1', '070GLU-073LYS-1', '070GLU-073LYS-2', '070MET-075ILE-1',
        '070PHE-120TYR-1', '070SER-082VAL-1', '070THR-120ASN-1', '070THR-124THR-2', '070TRP-084VAL-1',
        '070TRP-138LEU-1', '070TRP-174PRO-1', '071ASP-074LYS-1', '071LYS-195ASP-1', '071PHE-080ILE-1',
        '071PHE-080LYS-1', '071PHE-086ILE-1', '071PHE-108ILE-1', '071PHE-114SER-1', '071SER-082HIE-1',
        '071TRP-076LEU-1', '071TRP-078GLU-1', '071TRP-099TRP-1', '071TRP-100SER-1', '071TRP-125PHE-1',
        '071TRP-165ALA-1', '071TRP-166TYR-1', '071VAL-077ILE-1', '071VAL-083ILE-1', '071VAL-085ALA-1',
        '071VAL-119VAL-1', '072ARG-116ASP-1', '072ARG-118TYR-2', '072ASN-075ARG-1', '072HIE-093TYR-1',
        '072HIE-095PRO-1', '072ILE-077PHE-1', '072ILE-082HIE-1', '072ILE-116PHE-1', '072ILE-116PHE-2',
        '072THR-175GLN-1', '072TYR-076ARG-2', '072TYR-127ASN-1', '072VAL-176PHE-1', '073ARG-076LEU-1',
        '073ARG-119ASP-1', '073ARG-163ASN-1', '073ASP-135ARG-1', '073ASP-193VAL-1', '073GLU-077ASN-2',
        '073GLU-119SER-1', '073ILE-128ALA-1', '073LEU-120TRP-1', '073PHE-077TYR-1', '073PHE-079LEU-1',
        '073SER-090SER-1', '073SER-178SER-1', '073TRP-089TYR-1', '073VAL-111ASP-1', '074ALA-083TYR-1',
        '074ARG-130TYR-2', '074ARG-135SER-1', '074ARG-135SER-2', '074ARG-136GLN-1', '074ARG-147TYR-1',
        '074ARG-147TYR-2', '074GLN-094ASN-1', '074GLU-096ARG-1', '074LEU-079TYR-1', '074LEU-102PRO-1',
        '074LEU-107PHE-1', '074LYS-127ALA-1', '074PHE-080LEU-1', '074PHE-083HIE-1', '074SER-091PRO-1',
        '074SER-111GLU-1', '074VAL-080TRP-1', '074VAL-083ASN-1', '074VAL-190LEU-1', '075GLU-079GLN-1',
        '075GLU-079GLU-2', '075ILE-080ILE-1', '075ILE-112LEU-1', '075LEU-094ILE-1', '075LEU-111LEU-1',
        '075LEU-111LEU-2', '075PHE-093PRO-1', '075PHE-182ASN-1', '075PHE-184PHE-1', '075SER-078TRP-1',
        '075SER-111ASP-1', '075TRP-176ARG-1', '076ARG-079GLU-1', '076ARG-120TRP-1', '076ARG-208TYR-1',
        '076ARG-208TYR-2', '076ASP-084LEU-1', '076ASP-089TYR-1', '076ASP-091PRO-1', '076ASP-188GLN-1',
        '076GLU-170LEU-1', '076ILE-094ASN-1', '076LEU-086MET-1', '076LEU-117ILE-2', '076LEU-123THR-1',
        '076PRO-111TRP-1', '076PRO-112LEU-1', '076SER-082PHE-1', '076THR-090SER-1', '076TYR-125ILE-1',
        '076TYR-125ILE-2', '076TYR-136TYR-1', '076TYR-139ILE-1', '076TYR-143TRP-1', '077ALA-096ARG-1',
        '077ALA-138ARG-1', '077ALA-138ARG-2', '077ASP-080ARG-2', '077HIE-111LEU-1', '077ILE-102PHE-1',
        '077ILE-112ILE-1', '077ILE-125VAL-1', '077ILE-128TYR-1', '077ILE-128TYR-2', '077LEU-093VAL-2',
        '077LYS-178VAL-1', '077LYS-186ASN-2', '077PHE-089PHE-1', '077PHE-093ILE-1', '077PHE-097LEU-1',
        '077PHE-116PHE-1', '077PHE-160VAL-1', '077PHE-162PRO-1', '077PHE-201ARG-1', '077PHE-205GLU-1',
        '078ALA-126VAL-1', '078ASP-157LYS-1', '078GLN-085LYS-1', '078GLN-088GLU-1', '078GLU-099THR-1',
        '078GLU-127GLN-2', '078HIE-081PHE-1', '078LEU-108VAL-1', '078PHE-082VAL-1', '078PHE-096ALA-1',
        '078PHE-104TRP-1', '078PHE-107ALA-2', '078PHE-108LEU-1', '078PHE-179LEU-1', '078PHE-215ILE-1',
        '078PHE-218LEU-1', '078PHE-218LEU-2', '078PRO-115PRO-1', '078PRO-186ASN-1', '078SER-184PHE-1',
        '078TYR-082PHE-1', '079ARG-083ASP-1', '079ARG-182ASP-1', '079ASP-131HIE-1', '079ASP-135ILE-1',
        '079PHE-089PHE-1', '079PHE-100THR-1', '079PHE-104LEU-1', '079SER-088ALA-1', '079SER-208TYR-1',
        '079THR-089LEU-1', '079THR-089LEU-2', '079THR-110THR-1', '079TYR-084PRO-1', '079TYR-109VAL-1',
        '079TYR-112LEU-1', '079TYR-112LEU-2', '079TYR-146PHE-1', '079TYR-153TRP-1', '079TYR-167GLN-1',
        '079VAL-087LYS-1', '079VAL-094ILE-1', '080ARG-088PHE-1', '080ARG-090ASP-1', '080ASP-087LYS-1',
        '080GLU-092ALA-1', '080GLU-155ARG-1', '080ILE-112LEU-1', '080PHE-085LYS-1', '080PHE-098SER-1',
        '080PHE-166PHE-1', '080THR-090ARG-1', '080TRP-088LEU-1', '080TRP-090TYR-1', '080TRP-095ILE-1',
        '080TRP-108LEU-1', '080TRP-136ILE-1', '080TYR-129TRP-1', '080TYR-172GLU-1', '081ALA-088ALA-1',
        '081ASN-084LEU-1', '081ASN-085SER-1', '081ASN-100TRP-1', '081ASP-092SER-1', '081GLN-085ASP-1',
        '081GLU-101ASN-1', '081GLU-103GLN-1', '081GLU-103GLN-2', '081HIE-202PHE-1', '081ILE-085ARG-1',
        '081LYS-105VAL-1', '081MET-106CYS-1', '081MET-134GLU-1', '081MET-134GLU-2', '081MET-138ARG-1',
        '081SER-087PHE-1', '081TYR-085ARG-1', '081TYR-130VAL-1', '081VAL-105TYR-1', '081VAL-149HIE-1',
        '082ARG-088PHE-1', '082ARG-088PHE-2', '082ILE-121LEU-1', '082ILE-135ILE-1', '082ILE-136PHE-1',
        '082ILE-186VAL-1', '082LEU-176PHE-1', '082PHE-091ILE-1', '082PHE-102TYR-1', '082PHE-104VAL-1',
        '082VAL-108LEU-1', '082VAL-126SER-1', '082VAL-127PHE-1', '082VAL-130VAL-1', '083ASP-089HIE-1',
        '083ASP-105TYR-1', '083ASP-136ARG-1', '083GLU-094TYR-1', '083HIE-086GLU-1', '083HIE-089ASP-1',
        '083ILE-155ARG-1', '083ILE-173LEU-1', '083LEU-087LEU-1', '083LEU-088TYR-2', '083LEU-101GLN-1',
        '083LEU-108VAL-1', '083THR-086MET-1', '083THR-087GLN-1', '083TYR-087PHE-1', '083TYR-094TYR-1',
        '083TYR-096ASN-1', '083VAL-087LEU-1', '083VAL-094PHE-1', '083VAL-094PHE-2', '083VAL-103TRP-1',
        '083VAL-140TYR-1', '083VAL-153PHE-1', '084ARG-089ASP-1', '084ASN-099LYS-1', '084ASN-103TRP-1',
        '084ASP-087PHE-1', '084ASP-107ASN-1', '084ASP-126VAL-1', '084CYS-090LYS-1', '084LEU-090LEU-1',
        '084PRO-122PHE-1', '084PRO-135PHE-1', '084THR-107PRO-1', '084THR-108TYR-1', '084TYR-089ASP-1',
        '084TYR-095LEU-1', '085ASN-099TYR-1', '085HIE-094TYR-1', '085HIE-101TYR-1', '085ILE-089ALA-1',
        '085ILE-103LEU-1', '085LEU-094PHE-1', '085LEU-108LEU-1', '085LEU-137ASN-1', '085LEU-138LEU-1',
        '085LYS-088GLU-1', '085LYS-094TYR-1', '085MET-136PHE-1', '085PRO-090LYS-1', '085TRP-089ARG-1',
        '085TRP-135LYS-2', '086ALA-101GLN-1', '086ALA-104TRP-1', '086ALA-136PHE-2', '086ASP-091ILE-1',
        '086ASP-092TRP-1', '086ASP-112TRP-1', '086ASP-115ARG-1', '086HIE-089GLU-2', '086PRO-090ALA-1',
        '086SER-136TRP-1', '086VAL-105LEU-1', '086VAL-116VAL-1', '087ALA-171PRO-1', '087ALA-173TYR-1',
        '087ASN-091LYS-1', '087CYS-119ASP-1', '087CYS-121LEU-1', '087GLN-139ASN-1', '087LEU-095PHE-1',
        '087LEU-095PHE-2', '087LEU-096TRP-1', '087LEU-109VAL-1', '087LEU-153PHE-1', '087PHE-126VAL-1',
        '087PHE-186VAL-1', '087PHE-188VAL-1', '087VAL-102LEU-1', '088ASN-092ASP-1', '088ILE-135LEU-1',
        '088ILE-135PHE-1', '088LEU-108ILE-1', '088PHE-092LEU-1', '089ARG-106ASP-1', '089ARG-108TYR-1',
        '089ARG-131VAL-1', '089ASP-092PHE-1', '089ASP-112ASN-1', '089ASP-131VAL-1', '089CYS-105LEU-1',
        '089GLN-117PHE-1', '089GLN-125TYR-1', '089ILE-112TRP-1', '089LEU-127VAL-1', '089THR-098LEU-1',
        '089THR-098LEU-2', '089TYR-094TYR-1', '089TYR-153VAL-1', '090ALA-121PHE-1', '090ARG-187SER-1',
        '090GLU-119ARG-1', '090ILE-099LEU-1', '090ILE-107SER-1', '090ILE-190VAL-1', '090LYS-122ASP-1',
        '090LYS-122ASP-2', '090PRO-129TRP-1', '090PRO-154VAL-1', '090TYR-095ARG-1', '090TYR-095ILE-1',
        '090TYR-099ILE-1', '090TYR-105LEU-1', '090TYR-112GLU-1', '090TYR-113ALA-1', '091ASN-096TRP-1',
        '091HIE-098SER-1', '091HIE-118THR-1', '091HIE-118THR-2', '091HIE-121LEU-1', '091HIE-122ASP-1',
        '091HIE-125HIE-1', '091HIE-127VAL-1', '091LYS-140SER-1', '091LYS-140SER-2', '091THR-094HIE-2',
        '091VAL-094ASP-1', '092ALA-164GLU-1', '092LEU-095HIE-1', '092PHE-099TRP-1', '092PHE-120VAL-1',
        '092PHE-131VAL-1', '092PRO-102HIE-1', '092PRO-133LYS-1', '092TRP-100GLN-1',  # dropped 092TRP-100GLN-2
        '092VAL-117PHE-1', '093ALA-099THR-1', '093ALA-164ASP-1', '093ASN-096LYS-1', '093ASP-097THR-1',
        '093HIE-118GLN-1', '093HIE-120ALA-1', '093PRO-184PHE-1', '094HIE-099THR-1', '094HIE-104PHE-1',
        '094ILE-114TRP-1', '094LEU-132VAL-1', '094LEU-182MET-1', '094LYS-112ASP-1', '094PHE-098ILE-1',
        '094PHE-141ALA-1', '094PRO-135MET-1', '094TYR-097THR-1', '094TYR-151VAL-1', '094TYR-153VAL-1',
        '094VAL-125TRP-1', '094VAL-152LEU-1', '094VAL-166PHE-1', '095ASN-164ASP-1', '095ASP-102TYR-1',
        '095GLN-098TYR-1', '095GLN-185THR-1', '095GLN-187ASP-1', '095ILE-120TRP-1', '095ILE-120TRP-2',
        '095ILE-144THR-1', '095LEU-103ILE-1', '095LEU-130VAL-1', '095LEU-133LYS-1', '095LYS-107ILE-1',
        '095LYS-109THR-1', '095LYS-127ASP-1', '095PHE-099LYS-2', '095PHE-118ALA-1', '095PHE-154ILE-1',
        '095PHE-160VAL-1', '095PHE-160VAL-2', '095SER-114THR-1', '095THR-182ASN-1', '095TRP-099LEU-2',
        '095TRP-104VAL-1', '095TYR-106TYR-1', '096ASP-100ASN-1', '096ASP-101GLN-1', '096GLU-121LYS-1',
        '096HIE-101GLN-1', '096HIE-103SER-1', '096HIE-126LEU-1', '096HIE-127ASP-1', '096HIE-132VAL-1',
        '096ILE-127VAL-1', '096ILE-127VAL-2', '096TRP-110LEU-1', '096VAL-105LEU-1', '096VAL-108THR-1',
        '097ALA-105LEU-1', '097ALA-117HIE-1', '097ASN-102TYR-1', '097GLU-101ARG-1', '097ILE-105THR-1',
        '097LEU-111PHE-1', '097LEU-113ILE-1', '097LEU-128PHE-1', '097PHE-103ARG-1', '097PHE-181TRP-1',
        '097PHE-183ILE-1', '097PRO-106ILE-1', '097TRP-145LYS-1', '097TRP-173TYR-1', '097TRP-213ILE-1',
        '097TYR-101TRP-1', '097TYR-179LYS-1', '097TYR-179LYS-2', '097VAL-112TRP-1', '098ILE-145ILE-1',
        '098LEU-101VAL-1', '098LEU-115SER-1', '098LEU-117ALA-1', '098LEU-136PHE-1', '098LEU-144VAL-1',
        '098LEU-144VAL-2', '098LEU-146TRP-1', '098PRO-101GLN-1', '098PRO-102ALA-1', '098PRO-114PHE-1',
        '098SER-112PHE-1', '098SER-127VAL-1', '098SER-138TYR-2', '098SER-164ASP-1', '098VAL-101GLN-1',
        '098VAL-105TYR-1', '098VAL-152ALA-1', '098VAL-286TRP-1', '098VAL-287LEU-1', '099ARG-102HIE-1',
        '099ARG-147VAL-1', '099ARG-149ASN-1', '099ARG-177ASP-1', '099ARG-216GLU-1', '099GLN-108GLN-1',
        '099GLN-148HIE-1', '099ILE-103ALA-1', '099LYS-104THR-1', '099MET-107ASN-1', '099MET-126VAL-1',
        '099PRO-104TRP-1', '099PRO-164PHE-1', '099PRO-166GLU-1', '099TRP-118PRO-1', '099TRP-272GLU-1',
        '100ALA-112PHE-1', '100ASN-113LYS-1', '100ILE-103HIE-1', '100ILE-104LYS-1', '100LEU-130VAL-1',
        '100LEU-134ALA-1', '100LEU-142LEU-1', '100SER-119GLU-1', '100SER-131VAL-2', '100SER-148ASN-1',
        '100THR-104LEU-1', '100TRP-103LYS-1', '100TRP-103LYS-2', '100VAL-283ILE-1', '101ALA-104ARG-1',
        '101ALA-128ALA-1', '101ALA-138TYR-1', '101ARG-142LEU-1', '101ASN-125HIE-1', '101ASP-145THR-2',
        '101ILE-110LEU-1', '101ILE-110PHE-1', '101ILE-123ILE-1', '101LEU-111TRP-1', '101LEU-125TYR-1',
        '101LEU-132ILE-1', '101TRP-132VAL-1', '101TRP-135LYS-1', '101TRP-177ILE-1', '101TYR-151VAL-1',
        '101VAL-106LYS-1', '101VAL-132PHE-1', '101VAL-132PHE-2', '102ALA-114PHE-1', '102ASP-106SER-1',
        '102HIE-109TYR-1', '102HIE-127GLU-1', '102HIE-269HIE-1', '102HIE-270TYR-1', '102HIE-272GLN-1',
        '102ILE-110ILE-1', '102ILE-145ILE-1', '102ILE-149TYR-1', '102ILE-149TYR-2', '102ILE-153PHE-1',
        '102SER-165LYS-1', '102SER-169ASP-1', '102VAL-133PHE-1', '103ASP-149TYR-1', '103ASP-269HIE-1',
        '103GLN-108PHE-1', '103GLU-106LYS-1', '103GLU-108TRP-1', '103GLU-177ASP-1', '103HIE-168TYR-1',
        '103ILE-110VAL-1', '103ILE-130VAL-1', '103ILE-132PHE-1', '103PHE-122MET-1', '103PHE-127LEU-1',
        '104ALA-125TYR-1', '104MET-112ASN-1', '104MET-133PHE-1', '104TRP-107ALA-1', '104TRP-129ILE-1',
        '104TRP-147LEU-1', '104TRP-166GLU-1', '104TRP-168LEU-1', '104TRP-169PRO-1', '104TRP-202PHE-1',
        '104TRP-205GLU-1', '104VAL-108ILE-1', '104VAL-112SER-1', '104VAL-126ILE-1', '105ALA-115GLN-1',
        '105ASN-139VAL-1', '105ASN-146GLN-1', '105ASN-154ASN-1', '105ILE-128LEU-1', '105ILE-131ALA-1',
        '105ILE-135LEU-1', '105LEU-114TRP-1', '105LEU-168ILE-1', '105LEU-175PHE-1', '105PHE-127LEU-1',
        '105PHE-130ARG-1', '105PHE-130ARG-2', '105PRO-128ILE-1', '105PRO-181TRP-1', '105TYR-149HIE-1',
        '106ASN-130HIE-1', '106ASP-133GLN-1', '106GLU-129LYS-1', '106ILE-168ILE-1', '106LEU-126LEU-1',
        '106LEU-149PHE-1', '106LEU-149PHE-2', '106PHE-109PHE-1', '106PHE-178LYS-1', '106SER-128PHE-1',
        '106TYR-112SER-1', '106VAL-112LEU-1', '107ASP-125ASN-1', '107ILE-153TRP-1', '107ILE-158MET-1',
        '107THR-125ALA-1', '107THR-129LYS-1', '107VAL-147PHE-1', '107VAL-147PHE-2', '108ILE-122VAL-1',
        '108ILE-146GLN-1', '108LYS-131ALA-1', '108LYS-160LEU-1', '108PHE-125TRP-1', '108PHE-127PHE-1',
        '108PHE-150VAL-1', '108TRP-151ASN-1', '108TRP-155VAL-1', '109ARG-115GLU-1', '109GLN-161GLU-1',
        '109GLN-161GLU-2', '109PHE-113ILE-1', '109PHE-181ILE-1', '109PHE-182VAL-1', '109PHE-185VAL-1',
        '109PHE-228TYR-1', '109SER-137ASN-1', '109THR-131VAL-1', '109THR-158MET-1', '109VAL-164ILE-1',
        '110ALA-161PRO-1', '110ALA-164ILE-1', '110GLU-129LYS-1', '110ILE-116PHE-1', '110ILE-149ARG-1',
        '110ILE-151VAL-1', '110ILE-162VAL-1', '110LEU-125VAL-1', '110LEU-127ILE-1', '110PHE-123ILE-1',
        '110PHE-128PHE-1', '110PHE-222TYR-1', '110PHE-226LEU-1', '110PHE-226LEU-2', '110THR-127GLN-2',
        '110THR-129TRP-1', '111ASP-156SER-2', '111ASP-193HIE-1', '111HIE-218LEU-1', '111LEU-116ASN-1',
        '111LEU-130TYR-1', '111LEU-158LEU-1', '111LEU-169LEU-1', '111TRP-115GLN-1', '111VAL-125ALA-1',
        '112ALA-128PRO-1', '112ALA-131VAL-1', '112ARG-115ALA-1', '112ARG-125PHE-1', '112ARG-127GLN-1',
        '112ASP-183GLU-1', '112ILE-125VAL-1', '112ILE-142ILE-1', '112LEU-142PHE-1', '112LYS-127LEU-1',
        '112PHE-121LEU-1', '112PHE-125HIE-1', '112TRP-119ARG-1', '112TRP-119ARG-2', '112TRP-120VAL-1',
        '112TYR-125GLU-1', '112TYR-128LEU-1', '112TYR-190ARG-1', '113ALA-118ASP-1', '113ALA-120VAL-1',
        '113ALA-122VAL-1', '113ALA-225TRP-1', '113ASP-195GLN-1', '113ILE-131VAL-1', '113ILE-164HIE-1',
        '113ILE-185VAL-1', '113ILE-190ARG-2', '113ILE-232ALA-1', '113LYS-117GLU-2', '113LYS-170VAL-1',
        '113LYS-173GLU-1', '113SER-120ILE-1', '113TRP-119PHE-1', '113TRP-124HIE-1', '113TRP-126ALA-1',
        '113TRP-171ASP-1', '113TRP-178ILE-1', '113TYR-124THR-1', '113VAL-120HIE-2', '113VAL-143PHE-1',
        '114ALA-160ALA-1', '114ASN-122ARG-2', '114ASP-179LEU-1', '114GLU-144ASN-1', '114GLU-146ARG-1',
        '114LEU-118ILE-1', '114LYS-225TRP-1', '114VAL-167GLU-1', '115ASN-124LEU-1', '115ASP-156ASP-1',
        '115GLN-118ARG-1', '115GLU-123PRO-1', '115GLU-123PRO-2', '115GLU-160GLU-1', '115GLU-163TYR-2',
        '115MET-168TYR-1', '115PRO-129TYR-1', '115THR-138VAL-1', '115THR-142GLU-1', '115THR-142GLU-2',
        '115VAL-122MET-1', '115VAL-123PHE-1', '115VAL-130ARG-1', '116ALA-162PHE-1', '116LYS-144SER-1',
        '116PHE-130VAL-1', '116PHE-165VAL-1', '117HIE-123PRO-1', '117ILE-142PHE-1', '117PHE-125TYR-1',
        '117PHE-130HIE-1', '117PRO-126ALA-1', '117PRO-129TYR-1', '117PRO-130LYS-1', '117VAL-166ILE-1',
        '118ALA-160VAL-1', '118ARG-157ASN-1', '118ARG-185ARG-1', '118ASP-136HIE-1', '118GLN-121PHE-1',
        '118GLU-173PHE-1', '118GLU-176THR-1', '118ILE-136VAL-1', '118ILE-165ALA-1', '118ILE-166TYR-1',
        '118ILE-178TYR-1', '118THR-121LEU-1', '118VAL-162PHE-1', '119ALA-160LEU-1', '119CYS-168HIE-1',
        '119LEU-137ALA-1', '119LEU-137ALA-2', '119LYS-186VAL-1', '119MET-144SER-1', '119PHE-124HIE-1',
        '119PHE-176THR-1', '119SER-123ARG-1', '119SER-140TYR-1', '119THR-123THR-1', '119THR-123THR-2',
        '119TYR-174ILE-1', '120HIE-185ARG-1', '120ILE-123TYR-1', '120LEU-123ASN-1', '120LEU-124ASP-1',
        '120LEU-124LEU-1', '120LEU-135ILE-1', '120LEU-171TYR-1', '120LEU-171TYR-2', '120LYS-138VAL-1',
        '120LYS-142ASP-1', '120PRO-126ALA-1', '120SER-136HIE-1', '120THR-143VAL-1', '120THR-147GLU-1',
        '120TYR-141PHE-1', '120VAL-123ILE-1', '120VAL-154ILE-1', '120VAL-275LEU-1', '121ASN-132THR-1',
        '121GLN-144ARG-1', '121LEU-125HIE-1', '121LEU-125HIE-2', '121PHE-126VAL-1', '121PHE-191LEU-1',
        '121PHE-219TRP-1', '121TYR-125LEU-2', '121VAL-157ASP-1', '122ASP-125LYS-1', '122LEU-188VAL-1',
        '122MET-126GLU-1', '122VAL-125ILE-1', '122VAL-143VAL-1', '122VAL-152PHE-1', '123ALA-128VAL-1',
        '123ALA-158ILE-1', '123ARG-127GLN-1', '123MET-140ASN-1', '123SER-182ASN-1', '123THR-136SER-1',
        '123TYR-154VAL-1', '123VAL-134LEU-1', '124ALA-156THR-1', '124ASP-131THR-1', '124ASP-132THR-1',
        '124ASP-134ARG-1', '124GLN-200ALA-1', '124HIE-140GLU-1', '124HIE-143VAL-1', '124LEU-136HIE-2',
        '124LEU-181VAL-1', '125GLU-192PHE-1', '125ILE-136TYR-1', '125LEU-129LEU-1', '125PHE-143VAL-1',
        '125TRP-138SER-1', '125TRP-150VAL-1', '125TRP-152LEU-1', '125TYR-164HIE-1', '126ALA-140GLU-1',
        '126ASN-129ASN-1', '126GLU-130ARG-1', '126ILE-136PRO-1', '126ILE-139PHE-1', '126ILE-139PHE-2',
        '126LEU-130HIE-2', '126LEU-162PHE-1', '126LYS-158ILE-1', '126PHE-132HIE-1', '126PHE-171TYR-1',
        '126PHE-176TYR-1', '126SER-171ILE-1', '126THR-197TYR-1', '127ALA-177ASP-1', '127GLU-146ARG-2',
        '127GLU-269HIE-1', '127GLU-269HIE-2', '127LEU-210VAL-1', '127MET-131LYS-1', '127PHE-132ILE-1',
        '127PHE-133SER-1', '127PHE-138SER-1', '127PHE-140HIE-1', '127PHE-158VAL-1', '127PHE-183TYR-1',
        '127PHE-206ILE-1', '127PHE-237ASN-1', '127PHE-239PHE-1', '128ILE-131LEU-1', '128LYS-183TYR-1',
        '128PHE-235LEU-1', '128PHE-252LEU-1', '128PRO-275LEU-1', '128TYR-158MET-1', '128TYR-160LEU-1',
        '128VAL-160LEU-1', '129ASN-132TYR-1', '129ASP-140HIE-1', '129ASP-148TYR-1', '129LEU-155PHE-1',
        '129LEU-192PHE-1', '129LEU-195PRO-1', '129LEU-277TYR-1', '129LEU-277TYR-2', '129PHE-133VAL-1',
        '129PHE-156ARG-1', '129PHE-166PRO-1', '129TYR-133ARG-1', '129TYR-136TYR-2', '129VAL-159PHE-1',
        '129VAL-184PHE-1', '130ARG-170TYR-2', '130ARG-244ILE-1', '130ARG-248GLU-1', '130GLN-134GLU-1',
        '130GLN-137ARG-1', '130PRO-135ILE-1', '130PRO-139ILE-1', '130PRO-180PRO-1', '130SER-149HIE-1',
        '130SER-153TRP-1', '130VAL-139ILE-1', '130VAL-162VAL-1', '130VAL-185PHE-1', '131ALA-140HIE-1',
        '131ARG-134GLU-2', '131ASP-147PHE-1', '131ASP-182PHE-1', '131LEU-136VAL-1', '131LEU-160MET-1',
        '131PRO-219VAL-1', '131PRO-220GLU-1', '131THR-149LEU-1', '132ARG-136ARG-1', '132ASP-156ARG-1',
        '132HIE-135LYS-1', '132HIE-147ASP-1', '132HIE-149ASN-1', '132ILE-135PHE-1', '132ILE-138TRP-1',
        '132ILE-146TRP-1', '132LEU-198PHE-1', '132PHE-162VAL-1', '132PHE-174SER-1', '132PHE-176VAL-1',
        '132PHE-183GLN-1', '132TYR-136PRO-1', '133LYS-136ASP-1', '133LYS-198PHE-1', '133PRO-151ASP-1',
        '133SER-161GLU-1', '133TRP-143MET-2', '133TRP-148VAL-1', '133TRP-277TYR-1', '133VAL-137ARG-1',
        '133VAL-146TRP-1', '134GLU-138ARG-1', '134ILE-147ASP-1', '134ILE-167LEU-1', '134LEU-205TYR-1',
        '135ARG-193VAL-1', '135ILE-180PRO-1', '135LEU-139LEU-1', '135LEU-163LEU-1', '135LEU-179LEU-1',
        '135LYS-157GLU-1', '135LYS-177ILE-1', '135PHE-147TYR-1', '135PRO-140SER-1', '135PRO-144LEU-1',
        '135PRO-155PHE-1', '135TRP-147GLN-1', '135TRP-208ILE-1', '136ARG-142ALA-1', '136ASP-198PHE-1',
        '136ASP-201VAL-1', '136CYS-143PHE-1', '136PHE-141ALA-1', '136PHE-146TRP-1', '136SER-144ARG-1',
        '136TRP-155CYS-1', '136TRP-165ASP-1', '136TRP-179MET-1', '136VAL-169LEU-1', '137ARG-154TRP-1',
        '137ARG-154TRP-2', '137ARG-157GLU-1', '137GLU-143MET-1', '137SER-156ARG-1', '137TYR-166SER-1',
        '138ARG-142GLU-1', '138ILE-156ARG-1', '138LEU-149PHE-1', '138PHE-153PHE-1', '138SER-169VAL-1',
        '138TRP-146PHE-1', '138TRP-243LEU-1', '138VAL-144ARG-1', '139ASN-154SER-1', '139GLU-144LYS-1',
        '139ILE-143TRP-1', '139LEU-204TYR-1', '139PRO-180PRO-1', '139TYR-148SER-1', '140GLU-143VAL-1',
        '140GLU-155THR-1', '140GLU-156ARG-1', '140LEU-168LEU-1', '141GLN-160PHE-1', '141LYS-144GLU-1',
        '141MET-155ILE-1', '141PHE-152PHE-1', '141SER-144ASP-1', '141SER-154ILE-1', '142GLN-154GLN-1',
        '142ILE-155LEU-1', '142ILE-155LEU-2', '142ILE-185VAL-1', '142PHE-170ARG-1', '142TYR-147LYS-1',
        '142TYR-148TYR-1', '142TYR-150VAL-1', '142TYR-160PHE-1', '142TYR-170ILE-1', '142TYR-199THR-1',
        '142TYR-203VAL-1', '143ARG-187ASP-1', '143ARG-188LYS-1', '143GLN-147GLU-1', '143ILE-146VAL-1',
        '143LEU-160ARG-1', '143TRP-146LYS-1', '143TYR-150ILE-1', '143VAL-147LEU-1', '143VAL-152PHE-1',
        '144ARG-147GLU-2', '144ASP-150SER-1', '144ILE-155THR-1', '144LYS-161GLU-1', '144PHE-153LYS-1',
        '144PHE-155ILE-1', '145GLN-149MET-2', '145LEU-149PHE-1', '145THR-149PHE-1', '146ARG-207GLU-1',
        '146GLU-158SER-1', '146PHE-149PHE-1', '146PHE-150LEU-2', '146PHE-150VAL-1', '146PHE-164TRP-1',
        '146PHE-165PHE-1', '146PHE-199LYS-2', '146VAL-161VAL-1', '146VAL-161VAL-2', '146VAL-165HIE-1',
        '147ASP-171TYR-1', '147ASP-188LYS-1', '147LYS-203VAL-1', '147PHE-159PHE-1', '147PHE-182PHE-1',
        '147VAL-175SER-1', '148ALA-158LEU-1', '148HIE-152GLU-1', '148ILE-202VAL-1', '148ILE-204ARG-1',
        '148PHE-164HIE-1', '148PHE-165TYR-1', '148SER-163ALA-1', '148TYR-170ILE-1', '149ASN-167THR-1',
        '149ASN-171TYR-1', '149ASN-175SER-1', '149ASN-177ASP-1', '149LEU-152GLN-1', '149PHE-159ILE-1',
        '149PHE-164PHE-1', '149PHE-165PHE-1', '149PHE-169VAL-1', '149PRO-152GLN-1', '149PRO-152PHE-1',
        '149THR-157PRO-1', '149TYR-153PHE-1', '150ARG-157ASP-1', '150ARG-208ILE-1', '150LEU-153PHE-1',
        '150LEU-154TYR-1', '150LEU-159PHE-1', '150LEU-167LEU-1', '150LEU-170HIE-1', '150LEU-202LEU-1',
        '150LEU-203GLU-1', '150LYS-158LEU-1', '151ILE-159VAL-1', '151SER-159PHE-1', '151THR-163THR-1',
        '152ASP-156LYS-1', '152ASP-158LEU-1', '152CYS-197VAL-1', '152LYS-156ASP-2', '152LYS-277TYR-1',
        '153ASP-156ARG-1', '153ASP-200ARG-1', '153LYS-203GLU-1', '153PHE-163LEU-1', '153TRP-158MET-1',
        '154ARG-204ARG-1', '154ARG-208TYR-1', '154ILE-159GLN-1', '154ILE-160VAL-1', '154LEU-191TYR-1',
        '154LYS-159ASN-1', '154TYR-203GLU-1', '154TYR-207ASN-1', '155PHE-197TYR-1', '155PHE-277TYR-1',
        '155PHE-284LEU-1', '155PRO-170TRP-1', '156ARG-171ASP-1', '156ARG-172THR-1', '156ARG-197GLU-1',
        '156ARG-200TRP-1', '156ARG-200TRP-2', '156SER-191TYR-2', '157ASP-202VAL-1', '157ASP-204ARG-1',
        '157ILE-160CYS-1', '157MET-181ILE-1', '157MET-192ILE-1', '157PRO-161VAL-1', '157VAL-167PHE-1',
        '158ALA-193HIE-2', '158ALA-284LEU-1', '158ILE-164LYS-2', '158LEU-172THR-1', '158VAL-169VAL-1',
        '158VAL-205TYR-1', '159ALA-197TYR-1', '159GLU-170LYS-1', '159ILE-172TYR-1', '159ILE-199LEU-1',
        '159ILE-200TRP-1', '159ILE-203PRO-1', '159PHE-206ILE-1', '159PRO-164VAL-1', '159PRO-178TYR-1',
        '159PRO-192ILE-1', '159VAL-180LEU-1', '160LEU-164TRP-1', '160MET-169LEU-1', '160PHE-169VAL-1',
        '160PHE-203VAL-1', '161ARG-285ASP-1', '161ARG-288ALA-1', '161ARG-292GLU-1', '161THR-194VAL-2',
        '161TYR-201ALA-1', '161TYR-204ALA-1', '161VAL-170LYS-1', '162ALA-174ILE-1', '162ALA-175TRP-1',
        '162LEU-198PHE-1', '162LEU-201LEU-1', '162LEU-203VAL-1', '162LEU-208ILE-1', '162LEU-284LEU-1',
        '162PHE-168LEU-1', '162PHE-207ASN-1', '162VAL-167CYS-1', '162VAL-167TYR-1', '162VAL-167TYR-2',
        '163ARG-201LEU-1', '163ASN-166ILE-1', '163ASN-196ARG-1', '163ILE-166CYS-1', '163LEU-171ALA-1',
        '163LEU-175LEU-1', '163TYR-174ILE-1', '163TYR-178TYR-1', '163TYR-180LEU-1', '163TYR-180LEU-2',
        '163TYR-183LYS-1', '163TYR-184VAL-1', '163TYR-187GLU-1', '164VAL-171ALA-1', '164VAL-225LEU-1',
        '165ALA-292GLU-1', '165GLN-224MET-2', '165LYS-169ASP-1', '165PHE-169VAL-1', '165TYR-168ASP-1',
        '165TYR-171VAL-1', '165TYR-208ILE-1', '165TYR-208ILE-2', '165VAL-177ILE-1', '166ILE-187ARG-1',
        '166PRO-171VAL-1', '166PRO-172VAL-1', '167GLU-187ARG-1', '167PHE-170TRP-1', '167PRO-170VAL-1',
        '168HIE-180GLU-1', '168ILE-178VAL-1', '168LEU-172ASP-1', '168LEU-211ARG-1', '168TYR-203ILE-1',
        '168TYR-224MET-1', '169ASP-172SER-2', '169LEU-181TRP-1', '169LYS-172ILE-2', '169LYS-291ILE-1',
        '169MET-184VAL-1', '170ALA-175TRP-1', '170HIE-174LEU-1', '170LEU-178LEU-1', '170LEU-186TYR-1',
        '170THR-180GLU-1', '171ASP-176THR-1', '171THR-180SER-1', '171TYR-180PRO-1', '171TYR-231VAL-1',
        '172ASP-204TYR-1', '172ILE-235VAL-1', '172TYR-193VAL-1', '173ARG-234ASP-1', '173ARG-296LYS-1',
        '173CYS-269HIE-1', '173CYS-270TYR-1', '173LEU-190VAL-1', '173PHE-176THR-1', '173TYR-211PRO-1',
        '173TYR-213ILE-1', '173TYR-245ILE-1', '174ASN-178LYS-1', '174MET-177ILE-1', '174THR-205LEU-1',
        '174VAL-203VAL-1', '174VAL-205PHE-1', '174VAL-270TYR-1', '174VAL-273GLU-1', '174VAL-273GLU-2',
        '175LEU-233ALA-1', '175VAL-268LEU-1', '175VAL-274ASP-1', '176ALA-195LEU-1', '176ARG-182GLU-1',
        '176ARG-273GLU-1', '176ILE-198PHE-1', '176ILE-201ALA-1', '176ILE-205LEU-1', '176LEU-204TYR-1',
        '176LEU-208ALA-1', '176LEU-208ALA-2', '176LEU-214PHE-1', '176THR-180LEU-1', '177ASP-216GLU-1',
        '177GLN-190VAL-1', '178SER-239ASP-1', '179ALA-225TRP-1', '179ALA-238MET-1', '179ALA-250ILE-1',
        '179LEU-239PHE-1', '179TYR-216GLU-1', '179TYR-250PHE-1', '179TYR-258TRP-1', '180ASN-219SER-1',
        '180ASN-229TRP-1', '180GLU-187ARG-1', '180GLU-189ARG-2', '180GLU-194ARG-1', '180HIE-184VAL-1',
        '180HIE-209TYR-1', '180HIE-214PHE-1', '180HIE-224ILE-1', '181ILE-228TYR-1', '181THR-195SER-1',
        '181TRP-185GLN-1', '181TRP-189SER-1', '181TRP-258TRP-1', '182ASP-186ASN-1', '182ILE-192ILE-1',
        '182ILE-239PHE-1', '182ILE-242LEU-1', '182PRO-186LEU-1', '182PRO-186LEU-2', '182PRO-189ARG-1',
        '183GLN-190LYS-1', '183GLN-194ILE-1', '183GLN-205LEU-1', '183GLN-209TYR-1', '183TYR-186LYS-1',
        '184ASP-187ARG-1', '184PHE-205THR-1', '184PHE-209LEU-1', '184PHE-225TRP-1', '184PHE-228VAL-1',
        '184PHE-238MET-1', '184PHE-255TRP-1', '184THR-220ALA-1', '184VAL-225GLU-1', '185PHE-190LYS-1',
        '185TYR-220PHE-1', '185VAL-224ILE-1', '185VAL-228TYR-1', '186CYS-192PHE-1', '186GLU-189LYS-1',
        '186LYS-191VAL-1', '186LYS-191VAL-2', '186TYR-273GLU-1', '186VAL-208PRO-1', '186VAL-223LEU-1',
        '187LYS-193THR-1', '187LYS-193THR-2', '188LYS-225GLU-1', '189THR-199LYS-1', '189THR-205PHE-1',
        '189THR-207GLU-1', '189TYR-232ALA-1', '190ARG-235LEU-1', '190LYS-193GLU-1', '190PHE-199LEU-1',
        '191LEU-219TRP-2', '191TRP-229TRP-1', '192GLN-197VAL-1', '192ILE-242LEU-1', '192SER-269ARG-1',
        '193HIE-248MET-1', '193HIE-301MET-1', '194ASP-269ARG-1', '194ILE-205LEU-1', '194PHE-198PHE-1',
        '194PHE-201LYS-1', '194PHE-217PHE-1', '194PHE-233ALA-1', '194PHE-237ILE-1', '194PHE-241TYR-1',
        '195ASP-241TYR-1', '195LEU-205PHE-1', '195LEU-237ILE-1', '195LEU-269ARG-1', '195PRO-198PHE-1',
        '196HIE-218GLU-1', '196HIE-221MET-1', '196HIE-249ILE-1', '196HIE-249ILE-2', '197TYR-201LEU-1',
        '197TYR-252PRO-1', '197TYR-284LEU-1', '198ASN-201LYS-1', '198PHE-205PHE-1', '198PHE-217PHE-1',
        '198PHE-284LEU-1', '198PHE-287LEU-1', '199LYS-207GLU-1', '200TRP-204ASN-1', '201LEU-284LEU-1',
        '201SER-209ASN-1', '202TYR-212ILE-1', '202TYR-241TYR-1', '203VAL-291ILE-1', '205LEU-212ILE-1',
        '205MET-223ASP-2', '205MET-224MET-1', '205THR-209LEU-1', '206ASP-210TYR-1', '206VAL-231TYR-1',
        '207PRO-216VAL-1', '208ALA-214PHE-1', '209TYR-214PHE-1', '210GLU-213LYS-1', '210TYR-216ASP-1',
        '210TYR-286TYR-1', '211ASP-214LYS-1', '211PRO-245ILE-1', '212ALA-221GLU-1', '212ILE-243LYS-1',
        '212PRO-215ILE-1', '214ILE-217PHE-1', '215ALA-282PHE-1', '217PHE-234TYR-1', '217PHE-247ALA-1',
        '217PHE-249TRP-1', '218ALA-249TRP-1', '218ALA-258TRP-1', '219SER-229TRP-1', '219VAL-222TYR-1',
        '219VAL-222TYR-2', '219VAL-272ALA-1', '219VAL-286TYR-1', '219VAL-288LEU-1', '220ALA-256THR-1',
        '220ALA-286TYR-1', '221GLU-226LYS-1', '221GLU-230LYS-1', '221GLU-231TYR-1', '221GLU-262SER-1',
        '221GLU-263SER-1', '221GLU-265GLU-1', '222ALA-249ILE-1', '223ASP-286TYR-1', '223ASP-288LEU-1',
        '223ASP-289SER-1', '223LEU-227ASN-1', '224MET-229PHE-1', '224MET-229PHE-2', '225ASN-228ARG-1',
        '225TRP-228VAL-1', '225TRP-252GLU-1', '226LEU-233LYS-1', '226LEU-247VAL-1', '226LEU-294TYR-1',
        '226LEU-294TYR-2', '226LYS-262SER-1', '227HIE-255SER-1', '227HIE-256LEU-1', '227HIE-289SER-1',
        '228ARG-232GLU-2', '228VAL-254THR-1', '232PRO-290LEU-1', '234ASN-237ASN-1', '234LEU-260LYS-1',
        '234LEU-262VAL-1', '234LEU-286TRP-1', '234LEU-286TRP-2', '235VAL-294ALA-1', '236ILE-258LEU-1',
        '236ILE-260ALA-1', '236PHE-262VAL-1', '236PHE-279ILE-2', '236PHE-282GLU-1', '237ILE-267ILE-1',
        '237ILE-269ARG-1', '237TRP-246PRO-1', '237TRP-249ALA-1', '237TRP-263ASP-1', '238MET-247PRO-1',
        '238MET-255TRP-1', '239ASP-244THR-1', '239ASP-271PRO-1', '240ASP-270SER-1', '240PRO-268LEU-1',
        '241ARG-272GLU-1', '243LEU-269HIE-1', '244SER-294TYR-1', '245ILE-250ILE-1', '245PRO-248GLU-1',
        '248MET-298ARG-1', '249ILE-269MET-1', '249ILE-276ILE-1', '249ILE-297PHE-1', '249ILE-300LEU-1',
        '250ILE-255TRP-1', '250ILE-255TRP-2', '251LEU-269MET-1', '252PRO-258ALA-1', '253ALA-261THR-1',
        '253ALA-302SER-1', '255TRP-261VAL-1', '258LEU-261VAL-1', '261VAL-266VAL-1', '264ILE-271LEU-1',
        '270SER-283LEU-1', '273PRO-283LEU-1', '274ILE-279LYS-1', '275ASN-278LEU-1', ]
HRXN_SSI500 = [
        '001ASN-026VAL-1', '001LEU-154LEU-1', '001LEU-190THR-1', '001MET-005GLU-1', '002ASN-026ASP-2', 
        '002TRP-138SER-2', '003LEU-054LEU-1', '003THR-182GLU-1', '003TRP-163PRO-1', '003TYR-056ALA-1', 
        '003TYR-074SER-1', '003TYR-096HIE-1', '004LEU-031TYR-1', '004PHE-158LEU-1', '004PRO-029PHE-1', 
        '004PRO-074ALA-1', '004PRO-094LEU-1', '004THR-163LEU-1', '005LEU-010TRP-1', '005LEU-015LYS-1', 
        '005LEU-068ILE-1', '005PHE-031TYR-1', '005PHE-162GLN-1', '005PHE-163LEU-1', '005VAL-035PHE-1', 
        '006ALA-078GLU-1', '006GLU-010TYR-1', '006PHE-163LEU-1', '006VAL-023MET-1', '006VAL-024ASP-1', 
        '007PHE-019VAL-1', '007PHE-035PHE-1', '007PHE-160CYS-1', '007THR-031LYS-1', '007VAL-034ALA-1', 
        '008ALA-034ALA-1', '008ALA-035GLU-1', '008ASP-058ILE-1', '009ARG-128ARG-2', '009GLN-068ILE-1', 
        '009ILE-092LEU-1', '009LEU-041VAL-1', '009PRO-069TYR-1', '009TYR-035SER-1', '009TYR-050PRO-1', 
        '009VAL-021PHE-1', '009VAL-025ILE-1', '010TRP-025VAL-1', '010VAL-034TYR-1', '010VAL-040PHE-1', 
        '011ASP-091ASN-1', '011ILE-017LEU-1', '011SER-223GLU-1', '011TYR-018ARG-1', '011TYR-023ARG-1', 
        '011TYR-169ILE-1', '011VAL-153LYS-2', '012HIE-033LEU-1', '012ILE-018LEU-1', '012LEU-033LEU-1', 
        '012LEU-057LEU-1', '012LEU-085ASN-1', '012PHE-040PHE-1', '012SER-138SER-1', '012VAL-016LEU-1', 
        '012VAL-146PHE-1', '013ASP-016GLU-1', '013GLU-065LEU-1', '013HIE-032ALA-1', '013LEU-065PHE-1', 
        '013LEU-066ALA-1', '013PHE-085ALA-1', '013PRO-129THR-1', '013THR-164GLU-1', '013VAL-066LEU-1', 
        '014ALA-055LEU-1', '014ASN-137TYR-1', '014GLU-164TYR-1', '014ILE-027ILE-1', '014ILE-088MET-1', 
        '014TYR-021PHE-1', '015ILE-034LEU-1', '015LEU-035TRP-1', '015LEU-080PHE-1', '015TRP-096TYR-1', 
        '016GLN-101GLN-1', '016LEU-062LEU-1', '016LEU-137ILE-1', '016LYS-085GLU-1', '016VAL-055PHE-1', 
        '016VAL-084ILE-1', '017GLN-024ASN-1', '017GLN-093VAL-1', '017HIE-035TRP-1', '017ILE-028LEU-2', 
        '018ALA-026GLU-1', '018GLU-074ILE-1', '018PRO-085GLU-1', '018SER-040GLU-1', '019LEU-062LEU-1', 
        '019VAL-075LEU-1', '020LEU-024VAL-1', '020LEU-042VAL-1', '020PHE-149LEU-1', '020SER-058VAL-1', 
        '021ARG-035GLU-2', '021GLN-024LYS-1', '021GLN-024LYS-2', '021ILE-036VAL-1', '021PHE-025GLN-1', 
        '021PHE-060PRO-1', '021PHE-260ILE-1', '022GLN-058GLU-1', '022LEU-081LYS-2', '022TRP-026THR-1', 
        '022TRP-055LEU-2', '023ASP-027ARG-1', '023ASP-057ARG-1', '023GLU-028LEU-1', '023LEU-055ILE-1', 
        '023TYR-026LEU-1', '024ARG-073ASN-1', '024CYS-100ASN-1', '024GLU-050ARG-1', '024LEU-260ILE-1', 
        '024LYS-069TYR-2', '025ILE-084ILE-1', '025SER-075ASP-1', '025TYR-081PHE-1', '026GLU-057TYR-2', 
        '026MET-029PHE-1', '026MET-099ALA-1', '026MET-168TYR-1', '026PHE-217THR-1', '026VAL-041GLU-2', 
        '027ARG-049GLU-1', '027ILE-075LEU-1', '027VAL-085ALA-1', '028ALA-041VAL-1', '028MET-031ASP-1', 
        '028MET-037ARG-2', '029PHE-094LEU-1', '029PHE-103HIE-1', '029PHE-168TYR-1', '029PHE-177ILE-1', 
        '029PRO-085GLU-1', '029VAL-036VAL-1', '030ALA-274ILE-1', '030VAL-050ILE-1', '031PHE-095TYR-1', 
        '031TRP-171ALA-1', '031TYR-051GLN-1', '031VAL-056PHE-1', '031VAL-077ILE-1', '032ILE-036GLU-1', 
        '032LYS-083LEU-1', '032THR-093LYS-1', '032TRP-062ALA-1', '032VAL-100VAL-1', '033ARG-189PRO-1', 
        '033ASP-279LYS-2', '033GLN-092ASN-2', '033ILE-061VAL-1', '034ARG-060TYR-1', '034ASP-037PHE-1', 
        '034LEU-044TRP-1', '034LYS-068GLU-1', '034PHE-069MET-1', '034TYR-143MET-1', '034VAL-077LEU-1', 
        '035ALA-065LEU-1', '035LEU-085LEU-1', '036ARG-162GLN-1', '036GLN-040HIE-1', '036ILE-063TRP-1', 
        '036PHE-303TRP-1', '036SER-069THR-1', '037TRP-055LYS-1', '037TYR-068VAL-1', '038LEU-045PHE-1', 
        '038LEU-109SER-1', '038LYS-047PHE-1', '038PHE-046ARG-1', '038PHE-061VAL-1', '038PRO-108ARG-1', 
        '038TRP-132ILE-1', '038VAL-083ILE-1', '039HIE-057HIE-1', '039SER-054GLU-1', '039THR-046THR-1', 
        '039THR-077LEU-1', '041GLU-045LYS-1', '041ILE-107PHE-2', '041PHE-094LYS-2', '042LEU-048ILE-1', 
        '042PHE-064LYS-1', '042PHE-074LEU-1', '042PHE-089MET-1', '042PHE-101VAL-1', '042SER-062ASP-1', 
        '043LEU-055THR-1', '043LEU-114SER-1', '043PHE-073PHE-1', '043TYR-048GLN-1', '044ASN-059THR-1', 
        '044HIE-073TRP-1', '044LEU-079VAL-1', '044LEU-101ILE-1', '044SER-118ARG-2', '045ALA-071HIE-1', 
        '045GLN-062LYS-2', '045HIE-053ILE-1', '045TRP-048ILE-1', '046ARG-050ASP-2', '046ARG-273GLU-1', 
        '046ASP-083ASP-2', '046PHE-084LEU-1', '046SER-054PHE-1', '046VAL-094PHE-1', '047ARG-059MET-1', 
        '047TRP-081GLU-1', '048GLN-070SER-1', '048ILE-052ILE-1', '048ILE-272GLN-1', '048LEU-141PHE-1', 
        '048LYS-082ILE-1', '049ALA-092TYR-1', '049GLU-080ARG-1', '049VAL-127LEU-1', '049VAL-131VAL-1', 
        '050ALA-081PHE-1', '050ASP-067PHE-1', '051GLU-056MET-1', '051LEU-096TYR-1', '051PHE-058VAL-1', 
        '051TRP-097ARG-2', '051VAL-104ILE-1', '052ILE-056GLN-1', '052PHE-148ALA-1', '054GLU-057ARG-2', 
        '054THR-057ASP-2', '054VAL-097ILE-1', '055LEU-060VAL-1', '056LEU-069LEU-1', '056MET-181ALA-1', 
        '056SER-076LEU-1', '056TYR-062TYR-1', '057GLU-061ARG-1', '057PHE-060LEU-1', '057TYR-091LEU-1', 
        '057VAL-084ASP-1', '058HIE-067GLN-1', '058LYS-122VAL-1', '058PHE-062ILE-1', '058TRP-180SER-1', 
        '058TYR-062GLN-2', '058TYR-066VAL-1', '058TYR-077ALA-1', '059ILE-094LEU-1', '059LYS-063ASP-2', 
        '059PHE-118THR-1', '059THR-088TYR-1', '059VAL-136TRP-1', '061LEU-079ALA-1', '061PHE-099ALA-1', 
        '061THR-081THR-1', '062ALA-070MET-1', '062HIE-076ALA-1', '062ILE-105TYR-1', '063GLN-165ASP-1', 
        '063TRP-085MET-1', '063TRP-136PHE-1', '064GLU-111TRP-1', '064TYR-082VAL-1', '065MET-117PHE-1', 
        '065THR-069ILE-1', '065TRP-154THR-1', '066HIE-069GLU-1', '066PRO-095TRP-1', '066TRP-109TYR-1', 
        '067HIE-070HIE-1', '067THR-080TYR-1', '067VAL-085ASN-1', '068ARG-072THR-1', '068HIE-075LYS-1', 
        '068HIE-123ASP-1', '068PHE-076LEU-2', '068PHE-080VAL-1', '068TYR-073ILE-1', '069GLU-076ILE-2', 
        '069GLU-078ARG-1', '069PHE-080TYR-1', '069PHE-166TYR-1', '070MET-075ILE-1', '070THR-120ASN-1', 
        '070THR-124THR-2', '072ASN-075ARG-1', '072HIE-093TYR-1', '073LEU-120TRP-1', '073SER-178SER-1', 
        '073TRP-089TYR-1', '074ARG-136GLN-1', '074ARG-147TYR-1', '075LEU-111LEU-2', '076ARG-208TYR-2', 
        '076ASP-084LEU-1', '076ILE-094ASN-1', '076TYR-125ILE-2', '076TYR-139ILE-1', '076TYR-143TRP-1', 
        '077ALA-096ARG-1', '077HIE-111LEU-1', '077PHE-093ILE-1', '078ASP-157LYS-1', '078PHE-096ALA-1', 
        '079ARG-083ASP-1', '079ARG-182ASP-1', '079ASP-135ILE-1', '079SER-088ALA-1', '079SER-208TYR-1', 
        '080TRP-090TYR-1', '081GLN-085ASP-1', '082ARG-088PHE-1', '082ARG-088PHE-2', '082PHE-091ILE-1', 
        '083HIE-089ASP-1', '083LEU-087LEU-1', '083LEU-088TYR-2', '084ASP-087PHE-1', '084TYR-089ASP-1', 
        '085ILE-089ALA-1', '085LEU-108LEU-1', '085LYS-088GLU-1', '086ASP-092TRP-1', '086ASP-112TRP-1', 
        '086PRO-090ALA-1', '086VAL-116VAL-1', '087LEU-153PHE-1', '089GLN-125TYR-1', '089THR-098LEU-2', 
        '089TYR-094TYR-1', '089TYR-153VAL-1', '090LYS-122ASP-1', '091ASN-096TRP-1', '091HIE-118THR-2', 
        '091HIE-127VAL-1', '091LYS-140SER-2', '092PHE-099TRP-1', '092VAL-117PHE-1', '094HIE-104PHE-1', 
        '094PRO-135MET-1', '095GLN-098TYR-1', '095GLN-187ASP-1', '095ILE-120TRP-2', '095ILE-144THR-1', 
        '095LEU-130VAL-1', '095LYS-109THR-1', '095TYR-106TYR-1', '096HIE-126LEU-1', '097ILE-105THR-1', 
        '097PHE-103ARG-1', '097PRO-106ILE-1', '098LEU-136PHE-1', '098PRO-101GLN-1', '098PRO-102ALA-1', 
        '098SER-138TYR-2', '099ARG-147VAL-1', '099ARG-149ASN-1', '099ILE-103ALA-1', '099TRP-272GLU-1', 
        '100ILE-103HIE-1', '100LEU-142LEU-1', '101LEU-132ILE-1', '102ILE-153PHE-1', '103ILE-110VAL-1', 
        '104MET-133PHE-1', '104TRP-129ILE-1', '104TRP-169PRO-1', '104TRP-202PHE-1', '105PHE-130ARG-2', 
        '107ILE-153TRP-1', '107THR-125ALA-1', '108ILE-122VAL-1', '109PHE-228TYR-1', '110ALA-161PRO-1', 
        '110ILE-149ARG-1', '110LEU-125VAL-1', '111ASP-156SER-2', '111HIE-218LEU-1', '112ALA-131VAL-1', 
        '113ALA-122VAL-1', '113ILE-185VAL-1', '113LYS-117GLU-2', '114ALA-160ALA-1', '114ASN-122ARG-2', 
        '114LYS-225TRP-1', '115ASP-156ASP-1', '115GLU-123PRO-1', '118ARG-157ASN-1', '118VAL-162PHE-1', 
        '119LEU-137ALA-2', '119LYS-186VAL-1', '119SER-140TYR-1', '120LEU-171TYR-1', '123ARG-127GLN-1', 
        '126ALA-140GLU-1', '126LEU-162PHE-1', '126SER-171ILE-1', '127GLU-269HIE-1', '127GLU-269HIE-2', 
        '127PHE-132ILE-1', '128VAL-160LEU-1', '130SER-149HIE-1', '130VAL-185PHE-1', '131ALA-140HIE-1', 
        '131ASP-147PHE-1', '131ASP-182PHE-1', '131PRO-220GLU-1', '131THR-149LEU-1', '132ASP-156ARG-1', 
        '132ILE-146TRP-1', '132PHE-162VAL-1', '133TRP-143MET-2', '134ILE-147ASP-1', '135LEU-163LEU-1', 
        '135LYS-177ILE-1', '136CYS-143PHE-1', '136PHE-141ALA-1', '136SER-144ARG-1', '136TRP-179MET-1', 
        '137ARG-154TRP-2', '138TRP-146PHE-1', '140GLU-156ARG-1', '143ARG-188LYS-1', '143TRP-146LYS-1', 
        '144ARG-147GLU-2', '146GLU-158SER-1', '146PHE-149PHE-1', '147PHE-159PHE-1', '147PHE-182PHE-1', 
        '148ILE-202VAL-1', '148PHE-165TYR-1', '149ASN-175SER-1', '149ASN-177ASP-1', '149LEU-152GLN-1', 
        '149PHE-159ILE-1', '150ARG-157ASP-1', '150LEU-170HIE-1', '150LEU-203GLU-1', '153PHE-163LEU-1', 
        '153TRP-158MET-1', '155PHE-284LEU-1', '157ILE-160CYS-1', '157VAL-167PHE-1', '158LEU-172THR-1', 
        '158VAL-205TYR-1', '161ARG-285ASP-1', '163ILE-166CYS-1', '165TYR-208ILE-1', '166PRO-171VAL-1', 
        '167PHE-170TRP-1', '168TYR-203ILE-1', '169LYS-172ILE-2', '173CYS-269HIE-1', '173CYS-270TYR-1', 
        '175LEU-233ALA-1', '176ILE-205LEU-1', '176LEU-208ALA-2', '179ALA-225TRP-1', '180GLU-187ARG-1', 
        '180HIE-184VAL-1', '182ILE-192ILE-1', '182PRO-186LEU-2', '182PRO-189ARG-1', '184ASP-187ARG-1', 
        '184VAL-225GLU-1', '185PHE-190LYS-1', '187LYS-193THR-2', '189THR-199LYS-1', '191LEU-219TRP-2', 
        '193HIE-248MET-1', '194ASP-269ARG-1', '200TRP-204ASN-1', '206VAL-231TYR-1', '209TYR-214PHE-1', 
        '211PRO-245ILE-1', '215ALA-282PHE-1', '220ALA-286TYR-1', '223ASP-288LEU-1', '225ASN-228ARG-1', 
        '227HIE-255SER-1', '234LEU-262VAL-1', '237TRP-263ASP-1', '239ASP-271PRO-1', '240PRO-268LEU-1', 
        '243LEU-269HIE-1', '245ILE-250ILE-1', '249ILE-269MET-1', '249ILE-297PHE-1', '274ILE-279LYS-1']
HRXN_SSI100 = [
        '001LEU-154LEU-1', '003THR-182GLU-1', '003TRP-163PRO-1', '003TYR-056ALA-1', '004LEU-031TYR-1', 
        '004PRO-074ALA-1', '005LEU-010TRP-1', '005LEU-015LYS-1', '005PHE-163LEU-1', '006GLU-010TYR-1', 
        '007PHE-160CYS-1', '007THR-031LYS-1', '008ALA-035GLU-1', '009ARG-128ARG-2', '009GLN-068ILE-1', 
        '009VAL-025ILE-1', '011SER-223GLU-1', '012HIE-033LEU-1', '013HIE-032ALA-1', '013LEU-065PHE-1', 
        '014ILE-088MET-1', '015ILE-034LEU-1', '016GLN-101GLN-1', '016LEU-062LEU-1', '016LYS-085GLU-1', 
        '017GLN-093VAL-1', '019VAL-075LEU-1', '021PHE-260ILE-1', '022GLN-058GLU-1', '023ASP-057ARG-1', 
        '023GLU-028LEU-1', '024LEU-260ILE-1', '024LYS-069TYR-2', '025SER-075ASP-1', '026PHE-217THR-1', 
        '029PHE-103HIE-1', '029PRO-085GLU-1', '031PHE-095TYR-1', '032LYS-083LEU-1', '033ARG-189PRO-1', 
        '033ASP-279LYS-2', '034ASP-037PHE-1', '034PHE-069MET-1', '034TYR-143MET-1', '035ALA-065LEU-1', 
        '036ARG-162GLN-1', '038PHE-046ARG-1', '039THR-046THR-1', '039THR-077LEU-1', '041ILE-107PHE-2', 
        '041PHE-094LYS-2', '042PHE-064LYS-1', '043LEU-055THR-1', '043TYR-048GLN-1', '044ASN-059THR-1', 
        '044SER-118ARG-2', '048ILE-052ILE-1', '048LYS-082ILE-1', '049GLU-080ARG-1', '051LEU-096TYR-1', 
        '051VAL-104ILE-1', '052ILE-056GLN-1', '057GLU-061ARG-1', '057VAL-084ASP-1', '058TRP-180SER-1', 
        '059PHE-118THR-1', '062ILE-105TYR-1', '065THR-069ILE-1', '065TRP-154THR-1', '066TRP-109TYR-1', 
        '068ARG-072THR-1', '068HIE-075LYS-1', '070MET-075ILE-1', '070THR-120ASN-1', '075LEU-111LEU-2', 
        '079ASP-135ILE-1', '079SER-208TYR-1', '083HIE-089ASP-1', '083LEU-088TYR-2', '084TYR-089ASP-1', 
        '086ASP-092TRP-1', '091LYS-140SER-2', '095ILE-120TRP-2', '095TYR-106TYR-1', '099TRP-272GLU-1', 
        '113ILE-185VAL-1', '115ASP-156ASP-1', '115GLU-123PRO-1', '126LEU-162PHE-1', '130VAL-185PHE-1', 
        '131ASP-182PHE-1', '131THR-149LEU-1', '136SER-144ARG-1', '153PHE-163LEU-1', '158VAL-205TYR-1', 
        '165TYR-208ILE-1', '167PHE-170TRP-1', '175LEU-233ALA-1', '189THR-199LYS-1', '193HIE-248MET-1']

# <<< Chemical Systems Involved >>>
RXNM = {}     # reaction matrix of reagent contributions per reaction
ACTV = {}     # order of active reagents per reaction
ACTV_CP = {}  # order of active reagents per counterpoise-corrected reaction
ACTV_SA = {}  # order of active reagents for non-supermolecular calculations
for rxn in HRXN:

    RXNM[   '%s-%s' % (dbse, rxn)] = {'%s-%s-dimer'      % (dbse, rxn) : +1,
                                      '%s-%s-monoA-CP'   % (dbse, rxn) : -1,
                                      '%s-%s-monoB-CP'   % (dbse, rxn) : -1,
                                      '%s-%s-monoA-unCP' % (dbse, rxn) : -1,
                                      '%s-%s-monoB-unCP' % (dbse, rxn) : -1 }

    ACTV_SA['%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn) ]

    ACTV_CP['%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn),
                                      '%s-%s-monoA-CP'   % (dbse, rxn),
                                      '%s-%s-monoB-CP'   % (dbse, rxn) ]

    ACTV[   '%s-%s' % (dbse, rxn)] = ['%s-%s-dimer'      % (dbse, rxn),
                                      '%s-%s-monoA-unCP' % (dbse, rxn),
                                      '%s-%s-monoB-unCP' % (dbse, rxn) ]

# <<< Reference Values [kcal/mol] >>>
BIND = {}
# Bronze
BIND_BRONZE = {}
BIND_BRONZE['%s-%s' % (dbse, '001ARG-005ASP-1')] =  -61.558  
BIND_BRONZE['%s-%s' % (dbse, '001ARG-013ARG-1')] =   63.477  
BIND_BRONZE['%s-%s' % (dbse, '001ARG-015GLU-1')] =  -80.316  
BIND_BRONZE['%s-%s' % (dbse, '001ARG-159VAL-1')] =   -1.913  
BIND_BRONZE['%s-%s' % (dbse, '001ASN-026VAL-1')] =   -0.688  
BIND_BRONZE['%s-%s' % (dbse, '001ASN-030MET-1')] =    0.998  
BIND_BRONZE['%s-%s' % (dbse, '001ASN-097GLU-1')] =  -16.602  
BIND_BRONZE['%s-%s' % (dbse, '001HIE-099GLN-1')] =   -1.533  
BIND_BRONZE['%s-%s' % (dbse, '001LEU-071LYS-1')] =   -0.729  
BIND_BRONZE['%s-%s' % (dbse, '001LEU-154LEU-1')] =   -0.592  
BIND_BRONZE['%s-%s' % (dbse, '001LEU-190THR-1')] =   -0.525  
BIND_BRONZE['%s-%s' % (dbse, '001LYS-027ASN-2')] =   21.264  
BIND_BRONZE['%s-%s' % (dbse, '001LYS-027THR-1')] =   -0.774  
BIND_BRONZE['%s-%s' % (dbse, '001LYS-027THR-2')] =    1.307  
BIND_BRONZE['%s-%s' % (dbse, '001MET-005GLU-1')] =   -0.315  
BIND_BRONZE['%s-%s' % (dbse, '001MET-027VAL-2')] =    2.844  
BIND_BRONZE['%s-%s' % (dbse, '001MET-031VAL-1')] =    2.367  
BIND_BRONZE['%s-%s' % (dbse, '001MET-047GLU-1')] =   -5.284  
BIND_BRONZE['%s-%s' % (dbse, '001PRO-046ASP-1')] =   -4.028  
BIND_BRONZE['%s-%s' % (dbse, '001SER-030GLU-1')] =   -3.200  
BIND_BRONZE['%s-%s' % (dbse, '002ALA-101ILE-1')] =   -0.788  
BIND_BRONZE['%s-%s' % (dbse, '002ARG-006GLU-1')] =  -90.442  
BIND_BRONZE['%s-%s' % (dbse, '002ARG-020PRO-1')] =   -2.154  
BIND_BRONZE['%s-%s' % (dbse, '002ARG-046LEU-1')] =   -2.180  
BIND_BRONZE['%s-%s' % (dbse, '002ASN-022GLU-1')] =  -21.152  
BIND_BRONZE['%s-%s' % (dbse, '002ASN-026ASP-2')] =   -8.232  
BIND_BRONZE['%s-%s' % (dbse, '002ASP-145HIE-1')] =   -6.758  
BIND_BRONZE['%s-%s' % (dbse, '002LEU-005GLN-1')] =   -1.745  
BIND_BRONZE['%s-%s' % (dbse, '002LEU-006GLN-1')] =   -1.038  
BIND_BRONZE['%s-%s' % (dbse, '002LEU-153PHE-1')] =   -1.667  
BIND_BRONZE['%s-%s' % (dbse, '002LEU-163LEU-1')] =   -0.553  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-006GLU-2')] =   -0.942  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-007ILE-1')] =   -0.762  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-035GLU-1')] = -110.057  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-075ASN-1')] =  -22.510  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-080ARG-1')] =   -0.922  
BIND_BRONZE['%s-%s' % (dbse, '002LYS-082TYR-1')] =   -8.511  
BIND_BRONZE['%s-%s' % (dbse, '002MET-031TYR-1')] =   -0.932  
BIND_BRONZE['%s-%s' % (dbse, '002MET-050ALA-1')] =   -0.973  
BIND_BRONZE['%s-%s' % (dbse, '002TRP-012VAL-1')] =   -0.789  
BIND_BRONZE['%s-%s' % (dbse, '002TRP-138SER-2')] =   -6.078  
BIND_BRONZE['%s-%s' % (dbse, '002TRP-139LEU-1')] =   -1.693  
BIND_BRONZE['%s-%s' % (dbse, '002VAL-009TRP-1')] =   -0.613  
BIND_BRONZE['%s-%s' % (dbse, '002VAL-042PHE-1')] =   -0.956  
BIND_BRONZE['%s-%s' % (dbse, '002VAL-042PHE-2')] =   -0.627  
BIND_BRONZE['%s-%s' % (dbse, '002VAL-043HIE-2')] =   -2.202  
BIND_BRONZE['%s-%s' % (dbse, '002VAL-046SER-1')] =   -0.403  
BIND_BRONZE['%s-%s' % (dbse, '003ALA-007THR-1')] =   -0.981  
BIND_BRONZE['%s-%s' % (dbse, '003GLU-006GLN-2')] =    4.391  
BIND_BRONZE['%s-%s' % (dbse, '003ILE-062ILE-1')] =   -0.206  
BIND_BRONZE['%s-%s' % (dbse, '003ILE-065SER-1')] =    0.217  
BIND_BRONZE['%s-%s' % (dbse, '003ILE-067TYR-1')] =   -1.478  
BIND_BRONZE['%s-%s' % (dbse, '003LEU-033LEU-1')] =   -0.683  
BIND_BRONZE['%s-%s' % (dbse, '003LEU-054LEU-1')] =   -0.660  
BIND_BRONZE['%s-%s' % (dbse, '003LYS-055LEU-1')] =   -0.437  
BIND_BRONZE['%s-%s' % (dbse, '003PRO-025ALA-1')] =   -1.187  
BIND_BRONZE['%s-%s' % (dbse, '003SER-096ASN-2')] =    0.101  
BIND_BRONZE['%s-%s' % (dbse, '003THR-181VAL-1')] =   -1.075  
BIND_BRONZE['%s-%s' % (dbse, '003THR-182GLU-1')] =   -3.479  
BIND_BRONZE['%s-%s' % (dbse, '003TRP-163PRO-1')] =   -4.089  
BIND_BRONZE['%s-%s' % (dbse, '003TRP-167GLN-1')] =   -1.671  
BIND_BRONZE['%s-%s' % (dbse, '003TRP-167GLN-2')] =   -2.459  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-028VAL-1')] =   -1.300  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-028VAL-2')] =   -1.632  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-030GLN-1')] =   -2.526  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-054VAL-1')] =   -1.176  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-056ALA-1')] =   -1.668  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-073CYS-2')] =   -3.006  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-074SER-1')] =   -1.665  
BIND_BRONZE['%s-%s' % (dbse, '003TYR-096HIE-1')] =   -3.917  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-009TYR-1')] =   -1.306  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-012GLU-1')] =   -2.651  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-036PHE-1')] =   -1.301  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-064TYR-1')] =   -1.007  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-081THR-1')] =   -0.479  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-083PRO-1')] =   -0.655  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-118ALA-1')] =   -0.696  
BIND_BRONZE['%s-%s' % (dbse, '003VAL-121TYR-1')] =   -1.096  
BIND_BRONZE['%s-%s' % (dbse, '004ARG-024THR-1')] =  -15.481  
BIND_BRONZE['%s-%s' % (dbse, '004ARG-057ILE-1')] =   -1.032  
BIND_BRONZE['%s-%s' % (dbse, '004ARG-057ILE-2')] =    0.027  
BIND_BRONZE['%s-%s' % (dbse, '004ARG-095TYR-1')] =   -1.514  
BIND_BRONZE['%s-%s' % (dbse, '004ARG-095TYR-2')] =   -5.992  
BIND_BRONZE['%s-%s' % (dbse, '004ASN-009TRP-1')] =   -4.740  
BIND_BRONZE['%s-%s' % (dbse, '004ASP-043THR-1')] =  -16.394  
BIND_BRONZE['%s-%s' % (dbse, '004ASP-194ARG-1')] = -102.479  
BIND_BRONZE['%s-%s' % (dbse, '004GLN-007ASN-2')] =   -3.441  
BIND_BRONZE['%s-%s' % (dbse, '004GLN-056GLU-1')] =   -7.109  
BIND_BRONZE['%s-%s' % (dbse, '004GLU-039THR-1')] =  -16.280  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-010TYR-1')] =   -0.937  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-031TYR-1')] =   -1.238  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-032HIE-1')] =   -1.110  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-040GLU-1')] =   -2.793  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-179LEU-1')] =   -0.725  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-180LEU-1')] =   -0.212  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-180LEU-2')] =   -0.937  
BIND_BRONZE['%s-%s' % (dbse, '004LEU-183LYS-1')] =   -0.528  
BIND_BRONZE['%s-%s' % (dbse, '004LYS-030ASP-1')] =   -4.257  
BIND_BRONZE['%s-%s' % (dbse, '004LYS-031ILE-1')] =   -0.832  
BIND_BRONZE['%s-%s' % (dbse, '004LYS-323PHE-1')] =   -1.313  
BIND_BRONZE['%s-%s' % (dbse, '004PHE-116VAL-1')] =   -1.078  
BIND_BRONZE['%s-%s' % (dbse, '004PHE-135LEU-2')] =   -1.903  
BIND_BRONZE['%s-%s' % (dbse, '004PHE-158LEU-1')] =   -0.785  
BIND_BRONZE['%s-%s' % (dbse, '004PHE-160PRO-1')] =   -1.778  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-007LEU-1')] =   -1.083  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-009TYR-1')] =   -3.379  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-026TYR-1')] =   -2.532  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-029PHE-1')] =   -2.346  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-068VAL-1')] =   -0.656  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-074ALA-1')] =   -1.072  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-094LEU-1')] =   -1.195  
BIND_BRONZE['%s-%s' % (dbse, '004PRO-096TYR-1')] =   -2.516  
BIND_BRONZE['%s-%s' % (dbse, '004SER-027VAL-1')] =   -0.607  
BIND_BRONZE['%s-%s' % (dbse, '004SER-030MET-1')] =   -1.566  
BIND_BRONZE['%s-%s' % (dbse, '004THR-078LEU-1')] =   -0.588  
BIND_BRONZE['%s-%s' % (dbse, '004THR-132LYS-1')] =  -12.920  
BIND_BRONZE['%s-%s' % (dbse, '004THR-163LEU-1')] =   -0.408  
BIND_BRONZE['%s-%s' % (dbse, '004THR-164GLU-1')] =  -15.711  
BIND_BRONZE['%s-%s' % (dbse, '004TRP-014ARG-2')] =   -1.527  
BIND_BRONZE['%s-%s' % (dbse, '004TRP-016LYS-1')] =   -2.495  
BIND_BRONZE['%s-%s' % (dbse, '004TYR-075PRO-1')] =   -1.420  
BIND_BRONZE['%s-%s' % (dbse, '004TYR-105LEU-1')] =   -1.378  
BIND_BRONZE['%s-%s' % (dbse, '004VAL-053LEU-1')] =    0.109  
BIND_BRONZE['%s-%s' % (dbse, '005ALA-019PHE-1')] =   -0.658  
BIND_BRONZE['%s-%s' % (dbse, '005ARG-012GLU-1')] = -106.628  
BIND_BRONZE['%s-%s' % (dbse, '005ARG-071GLU-1')] =  -95.578  
BIND_BRONZE['%s-%s' % (dbse, '005ARG-158LEU-2')] =   -2.089  
BIND_BRONZE['%s-%s' % (dbse, '005ASP-103GLN-1')] =  -12.463  
BIND_BRONZE['%s-%s' % (dbse, '005ASP-128ARG-1')] = -100.487  
BIND_BRONZE['%s-%s' % (dbse, '005ILE-054SER-1')] =   -1.212  
BIND_BRONZE['%s-%s' % (dbse, '005ILE-234TYR-1')] =   -0.969  
BIND_BRONZE['%s-%s' % (dbse, '005ILE-277LEU-1')] =   -0.424  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-010TRP-1')] =   -0.968  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-011PHE-1')] =   -2.330  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-015LYS-1')] =   -1.890  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-023GLN-1')] =   -0.820  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-025ILE-1')] =   -0.480  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-025LEU-1')] =   -0.573  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-030ASP-1')] =   -2.171  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-030LEU-2')] =   -0.893  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-032MET-1')] =   -0.758  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-037ILE-1')] =   -0.648  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-068ILE-1')] =   -0.732  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-077LEU-1')] =   -0.497  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-083HIE-1')] =   -1.193  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-106TYR-1')] =   -1.907  
BIND_BRONZE['%s-%s' % (dbse, '005LEU-191TYR-1')] =   -1.036  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-022VAL-1')] =   -0.716  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-031TYR-1')] =   -1.313  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-037PHE-1')] =   -1.614  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-043TYR-1')] =   -2.280  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-049LYS-1')] =   -1.001  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-050TRP-1')] =   -2.888  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-155SER-1')] =   -0.732  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-162GLN-1')] =   -2.111  
BIND_BRONZE['%s-%s' % (dbse, '005PHE-163LEU-1')] =   -1.482  
BIND_BRONZE['%s-%s' % (dbse, '005PRO-196ALA-1')] =   -1.151  
BIND_BRONZE['%s-%s' % (dbse, '005SER-028VAL-1')] =   -0.610  
BIND_BRONZE['%s-%s' % (dbse, '005TYR-166TYR-1')] =   -3.163  
BIND_BRONZE['%s-%s' % (dbse, '005TYR-168VAL-1')] =   -0.711  
BIND_BRONZE['%s-%s' % (dbse, '005VAL-008GLN-1')] =   -0.432  
BIND_BRONZE['%s-%s' % (dbse, '005VAL-023LEU-1')] =   -0.451  
BIND_BRONZE['%s-%s' % (dbse, '005VAL-035PHE-1')] =   -0.425  
BIND_BRONZE['%s-%s' % (dbse, '005VAL-037ILE-1')] =   -0.386  
BIND_BRONZE['%s-%s' % (dbse, '005VAL-039SER-1')] =   -0.221  
BIND_BRONZE['%s-%s' % (dbse, '006ALA-078GLU-1')] =   -0.647  
BIND_BRONZE['%s-%s' % (dbse, '006ARG-090TYR-1')] =   -2.801  
BIND_BRONZE['%s-%s' % (dbse, '006ASP-010THR-1')] =    6.320  
BIND_BRONZE['%s-%s' % (dbse, '006ASP-116VAL-1')] =   -1.544  
BIND_BRONZE['%s-%s' % (dbse, '006GLU-010TYR-1')] =   -2.726  
BIND_BRONZE['%s-%s' % (dbse, '006LEU-108PHE-1')] =   -1.826  
BIND_BRONZE['%s-%s' % (dbse, '006LEU-126VAL-1')] =   -0.562  
BIND_BRONZE['%s-%s' % (dbse, '006LEU-319TYR-1')] =   -0.563  
BIND_BRONZE['%s-%s' % (dbse, '006LEU-323PHE-1')] =   -1.054  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-018ARG-1')] =   -6.696  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-039THR-2')] =   -1.692  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-050VAL-1')] =   -0.777  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-053LEU-1')] =   -0.951  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-061PHE-1')] =   -3.198  
BIND_BRONZE['%s-%s' % (dbse, '006PHE-163LEU-1')] =   -0.837  
BIND_BRONZE['%s-%s' % (dbse, '006THR-097VAL-1')] =   -0.600  
BIND_BRONZE['%s-%s' % (dbse, '006TRP-026TYR-1')] =   -1.483  
BIND_BRONZE['%s-%s' % (dbse, '006TRP-038VAL-1')] =   -0.997  
BIND_BRONZE['%s-%s' % (dbse, '006TRP-040LYS-1')] =   -1.025  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-020VAL-1')] =   -0.780  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-023MET-1')] =   -0.633  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-024ASP-1')] =   -1.748  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-026LEU-1')] =   -0.474  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-038ILE-1')] =   -0.277  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-053LEU-1')] =   -0.665  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-055GLU-1')] =   -2.153  
BIND_BRONZE['%s-%s' % (dbse, '006VAL-175PHE-1')] =   -2.831  
BIND_BRONZE['%s-%s' % (dbse, '007ALA-011ILE-1')] =   -0.969  
BIND_BRONZE['%s-%s' % (dbse, '007ALA-021PHE-1')] =   -0.975  
BIND_BRONZE['%s-%s' % (dbse, '007ALA-049VAL-1')] =   -0.327  
BIND_BRONZE['%s-%s' % (dbse, '007ARG-011GLU-2')] = -102.615  
BIND_BRONZE['%s-%s' % (dbse, '007ARG-062TYR-1')] =   -1.012  
BIND_BRONZE['%s-%s' % (dbse, '007ARG-063PRO-1')] =   -2.637  
BIND_BRONZE['%s-%s' % (dbse, '007ASN-109GLU-1')] =  -18.957  
BIND_BRONZE['%s-%s' % (dbse, '007ASP-011GLN-1')] =    7.210  
BIND_BRONZE['%s-%s' % (dbse, '007ASP-119SER-1')] =   -5.671  
BIND_BRONZE['%s-%s' % (dbse, '007ASP-131ARG-1')] = -110.814  
BIND_BRONZE['%s-%s' % (dbse, '007GLU-033LYS-1')] =   -4.608  
BIND_BRONZE['%s-%s' % (dbse, '007GLU-033LYS-2')] =  -99.715  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-015LYS-1')] =   -0.933  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-030LEU-1')] =   -0.405  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-030LEU-2')] =   -0.501  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-038TYR-1')] =   -1.712  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-042LYS-1')] =   -0.123  
BIND_BRONZE['%s-%s' % (dbse, '007ILE-097VAL-1')] =   -0.667  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-017ARG-1')] =   -0.819  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-026VAL-1')] =    0.200  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-033LEU-1')] =   -0.556  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-090TYR-1')] =   -1.299  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-096TYR-1')] =   -1.119  
BIND_BRONZE['%s-%s' % (dbse, '007LEU-168HIE-1')] =   -1.703  
BIND_BRONZE['%s-%s' % (dbse, '007LYS-011ASP-1')] = -112.706  
BIND_BRONZE['%s-%s' % (dbse, '007LYS-093SER-1')] =   -0.810  
BIND_BRONZE['%s-%s' % (dbse, '007LYS-099THR-1')] =   -0.640  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-019VAL-1')] =   -0.757  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-021PHE-1')] =   -2.844  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-021PRO-1')] =   -1.700  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-022VAL-1')] =   -1.359  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-024VAL-1')] =   -0.160  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-035PHE-1')] =   -1.351  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-084LEU-1')] =   -0.784  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-091ILE-1')] =   -1.643  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-111PHE-1')] =   -1.146  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-157ILE-1')] =   -1.814  
BIND_BRONZE['%s-%s' % (dbse, '007PHE-160CYS-1')] =   -0.865  
BIND_BRONZE['%s-%s' % (dbse, '007SER-010ARG-2')] =   -8.415  
BIND_BRONZE['%s-%s' % (dbse, '007SER-100ASN-1')] =   -4.649  
BIND_BRONZE['%s-%s' % (dbse, '007THR-031LYS-1')] =   -0.242  
BIND_BRONZE['%s-%s' % (dbse, '007TYR-053TYR-1')] =   -2.086  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-022SER-1')] =   -1.968  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-026GLU-1')] =   -0.501  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-034ALA-1')] =   -0.577  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-038VAL-1')] =   -0.706  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-040THR-1')] =   -0.454  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-154GLN-1')] =   -0.685  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-154GLN-2')] =   -1.120  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-191TYR-1')] =   -1.159  
BIND_BRONZE['%s-%s' % (dbse, '007VAL-248MET-1')] =   -0.727  
BIND_BRONZE['%s-%s' % (dbse, '008ALA-034ALA-1')] =   -0.350  
BIND_BRONZE['%s-%s' % (dbse, '008ALA-035GLU-1')] =   -3.802  
BIND_BRONZE['%s-%s' % (dbse, '008ALA-038MET-1')] =   -0.634  
BIND_BRONZE['%s-%s' % (dbse, '008ARG-115SER-1')] =  -15.065  
BIND_BRONZE['%s-%s' % (dbse, '008ASN-030LYS-1')] =  -24.901  
BIND_BRONZE['%s-%s' % (dbse, '008ASP-018ARG-1')] =   -4.681  
BIND_BRONZE['%s-%s' % (dbse, '008ASP-018ARG-2')] = -111.060  
BIND_BRONZE['%s-%s' % (dbse, '008ASP-058ILE-1')] =   -1.411  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-012HIE-1')] =   -0.776  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-015TYR-1')] =   -1.148  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-032MET-1')] =   -0.609  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-033PHE-1')] =   -1.169  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-034LEU-1')] =   -0.254  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-035TRP-1')] =   -1.358  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-041TYR-1')] =   -1.054  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-058PHE-1')] =   -2.378  
BIND_BRONZE['%s-%s' % (dbse, '008ILE-062TYR-1')] =   -1.238  
BIND_BRONZE['%s-%s' % (dbse, '008LEU-017ALA-1')] =   -0.594  
BIND_BRONZE['%s-%s' % (dbse, '008LEU-088TYR-1')] =   -1.316  
BIND_BRONZE['%s-%s' % (dbse, '008LYS-043THR-1')] =  -14.347  
BIND_BRONZE['%s-%s' % (dbse, '008LYS-065VAL-1')] =   -0.567  
BIND_BRONZE['%s-%s' % (dbse, '008LYS-068GLU-1')] =   -4.002  
BIND_BRONZE['%s-%s' % (dbse, '008LYS-068GLU-2')] = -105.905  
BIND_BRONZE['%s-%s' % (dbse, '008MET-158LEU-1')] =   -0.302  
BIND_BRONZE['%s-%s' % (dbse, '008PHE-042LEU-1')] =   -0.850  
BIND_BRONZE['%s-%s' % (dbse, '008PHE-044ILE-1')] =   -1.134  
BIND_BRONZE['%s-%s' % (dbse, '008PHE-097VAL-1')] =   -1.827  
BIND_BRONZE['%s-%s' % (dbse, '008PHE-099HIE-1')] =   -2.383  
BIND_BRONZE['%s-%s' % (dbse, '008PHE-101HIE-1')] =   -2.834  
BIND_BRONZE['%s-%s' % (dbse, '008PRO-183ASP-1')] =  -13.052  
BIND_BRONZE['%s-%s' % (dbse, '008SER-032SER-1')] =   -5.605  
BIND_BRONZE['%s-%s' % (dbse, '008SER-093TYR-1')] =   -1.308  
BIND_BRONZE['%s-%s' % (dbse, '008TRP-035PHE-1')] =   -3.435  
BIND_BRONZE['%s-%s' % (dbse, '008TRP-250PHE-1')] =   -3.098  
BIND_BRONZE['%s-%s' % (dbse, '008TRP-252GLU-1')] =  -20.326  
BIND_BRONZE['%s-%s' % (dbse, '008TYR-052TYR-1')] =   -1.835  
BIND_BRONZE['%s-%s' % (dbse, '008VAL-039TRP-1')] =   -0.994  
BIND_BRONZE['%s-%s' % (dbse, '008VAL-041VAL-1')] =   -0.363  
BIND_BRONZE['%s-%s' % (dbse, '008VAL-066LEU-1')] =   -0.193  
BIND_BRONZE['%s-%s' % (dbse, '008VAL-072SER-1')] =   -0.311  
BIND_BRONZE['%s-%s' % (dbse, '008VAL-080PHE-1')] =   -1.290  
BIND_BRONZE['%s-%s' % (dbse, '009ALA-084LEU-1')] =   -0.549  
BIND_BRONZE['%s-%s' % (dbse, '009ALA-091ILE-1')] =   -0.210  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-023GLU-1')] =  -95.738  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-031TRP-1')] =  -11.785  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-092LEU-1')] =   -2.323  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-103GLN-1')] =    5.337  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-106ASP-1')] =  -89.306  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-128ARG-1')] =   -2.436  
BIND_BRONZE['%s-%s' % (dbse, '009ARG-128ARG-2')] =   59.759  
BIND_BRONZE['%s-%s' % (dbse, '009ASN-024ARG-1')] =    9.261  
BIND_BRONZE['%s-%s' % (dbse, '009ASP-021LYS-1')] =   -3.518  
BIND_BRONZE['%s-%s' % (dbse, '009GLN-068ILE-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '009GLN-072ASN-1')] =   -2.369  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-013TYR-1')] =   -1.110  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-038LEU-1')] =   -0.432  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-052PHE-1')] =   -0.736  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-092LEU-1')] =   -0.847  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-092LEU-2')] =   -0.567  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-105LEU-1')] =   -0.736  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-108PHE-1')] =   -0.996  
BIND_BRONZE['%s-%s' % (dbse, '009ILE-155ILE-1')] =   -0.473  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-013VAL-1')] =   -0.694  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-033LEU-2')] =   -0.509  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-039ARG-1')] =   -0.641  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-041VAL-1')] =   -0.703  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-041VAL-2')] =   -0.397  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-055SER-2')] =   -0.768  
BIND_BRONZE['%s-%s' % (dbse, '009LEU-058ILE-1')] =   -0.803  
BIND_BRONZE['%s-%s' % (dbse, '009LYS-137LEU-1')] =   -2.485  
BIND_BRONZE['%s-%s' % (dbse, '009LYS-171VAL-1')] =   -0.848  
BIND_BRONZE['%s-%s' % (dbse, '009PRO-069TYR-1')] =   -1.054  
BIND_BRONZE['%s-%s' % (dbse, '009TRP-111ARG-1')] =  -11.137  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-016GLU-1')] =    4.373  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-029THR-1')] =   -1.099  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-033ASN-1')] =   -4.622  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-035SER-1')] =   -1.348  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-050PRO-1')] =   -3.437  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-053TYR-1')] =   -2.637  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-111ASP-1')] =  -23.148  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-121TYR-1')] =   -3.792  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-158ALA-1')] =    0.146  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-301MET-1')] =   -1.807  
BIND_BRONZE['%s-%s' % (dbse, '009TYR-303TRP-1')] =   -2.600  
BIND_BRONZE['%s-%s' % (dbse, '009VAL-021PHE-1')] =   -1.939  
BIND_BRONZE['%s-%s' % (dbse, '009VAL-025ILE-1')] =   -0.471  
BIND_BRONZE['%s-%s' % (dbse, '009VAL-035ARG-1')] =   -0.635  
BIND_BRONZE['%s-%s' % (dbse, '009VAL-084ILE-1')] =   -0.410  
BIND_BRONZE['%s-%s' % (dbse, '009VAL-086TYR-1')] =   -1.448  
BIND_BRONZE['%s-%s' % (dbse, '010ARG-039ASP-1')] = -100.529  
BIND_BRONZE['%s-%s' % (dbse, '010ARG-042ASP-1')] =  -90.493  
BIND_BRONZE['%s-%s' % (dbse, '010ARG-092LEU-1')] =   -0.989  
BIND_BRONZE['%s-%s' % (dbse, '010ASN-014GLN-2')] =   -5.695  
BIND_BRONZE['%s-%s' % (dbse, '010ASN-023GLU-1')] =  -23.149  
BIND_BRONZE['%s-%s' % (dbse, '010ASN-088TYR-1')] =   -3.696  
BIND_BRONZE['%s-%s' % (dbse, '010ASP-090TYR-1')] =  -25.360  
BIND_BRONZE['%s-%s' % (dbse, '010GLN-022MET-1')] =   -1.945  
BIND_BRONZE['%s-%s' % (dbse, '010GLN-102TYR-1')] =    0.793  
BIND_BRONZE['%s-%s' % (dbse, '010GLU-014LYS-1')] =  -67.929  
BIND_BRONZE['%s-%s' % (dbse, '010GLU-032SER-1')] =   10.435  
BIND_BRONZE['%s-%s' % (dbse, '010HIE-015TYR-1')] =   -2.183  
BIND_BRONZE['%s-%s' % (dbse, '010HIE-023ASP-1')] =   -0.940  
BIND_BRONZE['%s-%s' % (dbse, '010LEU-091ASN-1')] =   -0.952  
BIND_BRONZE['%s-%s' % (dbse, '010LEU-096TRP-1')] =   -0.896  
BIND_BRONZE['%s-%s' % (dbse, '010LEU-132ILE-1')] =   -0.884  
BIND_BRONZE['%s-%s' % (dbse, '010PHE-028ILE-2')] =   -1.609  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-022LEU-1')] =   -2.292  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-025VAL-1')] =   -1.226  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-032ILE-1')] =   -0.503  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-032PHE-1')] =   -2.874  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-034VAL-1')] =   -1.033  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-052TYR-1')] =   -1.359  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-058PHE-1')] =   -1.866  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-081VAL-1')] =   -2.498  
BIND_BRONZE['%s-%s' % (dbse, '010TRP-081VAL-2')] =   -2.543  
BIND_BRONZE['%s-%s' % (dbse, '010TYR-017GLU-1')] =    3.589  
BIND_BRONZE['%s-%s' % (dbse, '010TYR-049PRO-1')] =   -2.415  
BIND_BRONZE['%s-%s' % (dbse, '010TYR-052TYR-1')] =   -3.135  
BIND_BRONZE['%s-%s' % (dbse, '010TYR-163TYR-1')] =   -1.381  
BIND_BRONZE['%s-%s' % (dbse, '010VAL-027ALA-1')] =   -0.644  
BIND_BRONZE['%s-%s' % (dbse, '010VAL-028LEU-1')] =   -0.664  
BIND_BRONZE['%s-%s' % (dbse, '010VAL-034TYR-1')] =   -0.904  
BIND_BRONZE['%s-%s' % (dbse, '010VAL-040PHE-1')] =   -1.824  
BIND_BRONZE['%s-%s' % (dbse, '010VAL-044ALA-1')] =   -0.356  
BIND_BRONZE['%s-%s' % (dbse, '011ALA-016GLU-1')] =   -0.884  
BIND_BRONZE['%s-%s' % (dbse, '011ASP-091ASN-1')] =  -18.025  
BIND_BRONZE['%s-%s' % (dbse, '011CYS-042VAL-1')] =   -0.691  
BIND_BRONZE['%s-%s' % (dbse, '011CYS-042VAL-2')] =   -0.792  
BIND_BRONZE['%s-%s' % (dbse, '011GLU-062TYR-1')] =    3.092  
BIND_BRONZE['%s-%s' % (dbse, '011GLU-100THR-1')] =   -8.755  
BIND_BRONZE['%s-%s' % (dbse, '011HIE-015ASN-1')] =    2.301  
BIND_BRONZE['%s-%s' % (dbse, '011HIE-304SER-1')] =    1.478  
BIND_BRONZE['%s-%s' % (dbse, '011HIE-306ASN-1')] =   -2.891  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-017LEU-1')] =   -0.374  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-018ALA-1')] =   -0.568  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-024ILE-1')] =   -0.628  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-024ILE-2')] =   -0.498  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-028LEU-1')] =   -0.247  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-037LEU-1')] =   -0.106  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-038TYR-1')] =   -1.088  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-042LEU-1')] =   -0.598  
BIND_BRONZE['%s-%s' % (dbse, '011ILE-045VAL-1')] =   -0.525  
BIND_BRONZE['%s-%s' % (dbse, '011LEU-062HIE-2')] =   -0.885  
BIND_BRONZE['%s-%s' % (dbse, '011LEU-069TYR-1')] =   -0.938  
BIND_BRONZE['%s-%s' % (dbse, '011LEU-071GLU-1')] =   -1.128  
BIND_BRONZE['%s-%s' % (dbse, '011LEU-102TYR-1')] =   -1.740  
BIND_BRONZE['%s-%s' % (dbse, '011LEU-102TYR-2')] =   -1.734  
BIND_BRONZE['%s-%s' % (dbse, '011PHE-044TYR-1')] =   -1.131  
BIND_BRONZE['%s-%s' % (dbse, '011PRO-020ILE-1')] =   -0.387  
BIND_BRONZE['%s-%s' % (dbse, '011SER-223GLU-1')] =  -18.614  
BIND_BRONZE['%s-%s' % (dbse, '011THR-017ALA-1')] =   -0.468  
BIND_BRONZE['%s-%s' % (dbse, '011THR-166GLU-1')] =   -3.317  
BIND_BRONZE['%s-%s' % (dbse, '011THR-166GLU-2')] =  -16.601  
BIND_BRONZE['%s-%s' % (dbse, '011TYR-018ARG-1')] =   -7.976  
BIND_BRONZE['%s-%s' % (dbse, '011TYR-023ARG-1')] =   -7.890  
BIND_BRONZE['%s-%s' % (dbse, '011TYR-051GLU-1')] =  -10.497  
BIND_BRONZE['%s-%s' % (dbse, '011TYR-102GLN-1')] =   -3.763  
BIND_BRONZE['%s-%s' % (dbse, '011TYR-169ILE-1')] =   -1.347  
BIND_BRONZE['%s-%s' % (dbse, '011VAL-144PHE-1')] =   -1.147  
BIND_BRONZE['%s-%s' % (dbse, '011VAL-153LYS-1')] =   -0.486  
BIND_BRONZE['%s-%s' % (dbse, '011VAL-153LYS-2')] =   -0.684  
BIND_BRONZE['%s-%s' % (dbse, '011VAL-155ILE-1')] =   -0.193  
BIND_BRONZE['%s-%s' % (dbse, '012ALA-055PHE-1')] =   -0.680  
BIND_BRONZE['%s-%s' % (dbse, '012ALA-059PHE-1')] =   -0.963  
BIND_BRONZE['%s-%s' % (dbse, '012ALA-108PHE-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '012ALA-139ALA-1')] =   -0.599  
BIND_BRONZE['%s-%s' % (dbse, '012ASN-048PHE-1')] =   -1.384  
BIND_BRONZE['%s-%s' % (dbse, '012ASP-024LYS-2')] =  -77.221  
BIND_BRONZE['%s-%s' % (dbse, '012ASP-026TYR-1')] =   -7.432  
BIND_BRONZE['%s-%s' % (dbse, '012ASP-069TYR-1')] =    3.647  
BIND_BRONZE['%s-%s' % (dbse, '012GLN-034GLN-1')] =   -6.844  
BIND_BRONZE['%s-%s' % (dbse, '012GLN-044TRP-1')] =   -1.305  
BIND_BRONZE['%s-%s' % (dbse, '012GLN-048TYR-1')] =   -1.736  
BIND_BRONZE['%s-%s' % (dbse, '012GLU-017GLU-1')] =   -0.964  
BIND_BRONZE['%s-%s' % (dbse, '012GLU-019THR-1')] =  -17.207  
BIND_BRONZE['%s-%s' % (dbse, '012GLU-068HIE-1')] =   12.602  
BIND_BRONZE['%s-%s' % (dbse, '012GLU-070TYR-1')] =   -5.291  
BIND_BRONZE['%s-%s' % (dbse, '012HIE-015ILE-1')] =   -1.384  
BIND_BRONZE['%s-%s' % (dbse, '012HIE-033LEU-1')] =   -0.848  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-016THR-1')] =   -0.718  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-018LEU-1')] =   -0.475  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-028LEU-1')] =   -0.242  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-044ILE-1')] =   -0.952  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-046LYS-2')] =   -0.021  
BIND_BRONZE['%s-%s' % (dbse, '012ILE-046VAL-1')] =   -0.440  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-024VAL-1')] =   -0.551  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-027PRO-1')] =   -1.254  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-033LEU-1')] =   -0.258  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-035TRP-1')] =   -1.317  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-039ARG-1')] =   -0.766  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-047ILE-1')] =   -0.434  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-057LEU-1')] =   -0.479  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-062HIE-1')] =   -1.778  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-064LEU-1')] =   -0.810  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-065LEU-1')] =   -0.730  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-070MET-1')] =   -0.792  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-074VAL-1')] =   -0.162  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-083ASN-1')] =   -1.127  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-085ASN-1')] =   -0.820  
BIND_BRONZE['%s-%s' % (dbse, '012LEU-088TYR-1')] =   -0.648  
BIND_BRONZE['%s-%s' % (dbse, '012PHE-026PHE-1')] =   -2.953  
BIND_BRONZE['%s-%s' % (dbse, '012PHE-040PHE-1')] =   -1.536  
BIND_BRONZE['%s-%s' % (dbse, '012PHE-116PHE-1')] =   -1.447  
BIND_BRONZE['%s-%s' % (dbse, '012PHE-163ILE-1')] =   -1.778  
BIND_BRONZE['%s-%s' % (dbse, '012PHE-166CYS-1')] =   -1.158  
BIND_BRONZE['%s-%s' % (dbse, '012SER-138SER-1')] =   -2.754  
BIND_BRONZE['%s-%s' % (dbse, '012SER-166PHE-1')] =   -1.684  
BIND_BRONZE['%s-%s' % (dbse, '012TYR-087PRO-1')] =   -4.346  
BIND_BRONZE['%s-%s' % (dbse, '012VAL-016LEU-1')] =   -0.373  
BIND_BRONZE['%s-%s' % (dbse, '012VAL-023LEU-1')] =   -0.352  
BIND_BRONZE['%s-%s' % (dbse, '012VAL-088PHE-1')] =   -1.075  
BIND_BRONZE['%s-%s' % (dbse, '012VAL-114PRO-1')] =   -1.051  
BIND_BRONZE['%s-%s' % (dbse, '012VAL-146PHE-1')] =   -0.960  
BIND_BRONZE['%s-%s' % (dbse, '013ALA-096TRP-1')] =   -2.443  
BIND_BRONZE['%s-%s' % (dbse, '013ASN-149ASN-1')] =   -7.441  
BIND_BRONZE['%s-%s' % (dbse, '013ASP-016GLU-1')] =   63.130  
BIND_BRONZE['%s-%s' % (dbse, '013ASP-023ARG-1')] = -117.689  
BIND_BRONZE['%s-%s' % (dbse, '013GLU-039ARG-1')] =  -91.435  
BIND_BRONZE['%s-%s' % (dbse, '013GLU-052ILE-1')] =   -1.694  
BIND_BRONZE['%s-%s' % (dbse, '013GLU-056GLN-1')] =  -22.149  
BIND_BRONZE['%s-%s' % (dbse, '013GLU-065LEU-1')] =   -3.400  
BIND_BRONZE['%s-%s' % (dbse, '013GLU-069ARG-1')] = -115.568  
BIND_BRONZE['%s-%s' % (dbse, '013HIE-032ALA-1')] =   -0.475  
BIND_BRONZE['%s-%s' % (dbse, '013HIE-095HIE-1')] =   -2.603  
BIND_BRONZE['%s-%s' % (dbse, '013HIE-121TYR-1')] =  -11.201  
BIND_BRONZE['%s-%s' % (dbse, '013ILE-017LEU-1')] =   -0.765  
BIND_BRONZE['%s-%s' % (dbse, '013ILE-105ALA-1')] =   -0.469  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-017ASN-1')] =   -0.232  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-063ILE-1')] =   -0.538  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-065PHE-1')] =   -1.961  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-066ALA-1')] =   -0.527  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-069LEU-1')] =   -0.692  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-077LEU-1')] =   -0.277  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-082VAL-1')] =   -0.580  
BIND_BRONZE['%s-%s' % (dbse, '013LEU-084ALA-1')] =   -0.555  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-036VAL-1')] =   -0.816  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-060TYR-1')] =   -2.264  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-062LEU-1')] =   -1.547  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-063PRO-1')] =   -1.712  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-083ILE-1')] =   -1.012  
BIND_BRONZE['%s-%s' % (dbse, '013PHE-085ALA-1')] =   -0.792  
BIND_BRONZE['%s-%s' % (dbse, '013PRO-032VAL-1')] =   -0.125  
BIND_BRONZE['%s-%s' % (dbse, '013PRO-034GLN-1')] =   -1.550  
BIND_BRONZE['%s-%s' % (dbse, '013PRO-129THR-1')] =   -1.023  
BIND_BRONZE['%s-%s' % (dbse, '013SER-047TYR-1')] =   -1.385  
BIND_BRONZE['%s-%s' % (dbse, '013THR-164GLU-1')] =   -2.954  
BIND_BRONZE['%s-%s' % (dbse, '013TYR-075LEU-1')] =   -1.859  
BIND_BRONZE['%s-%s' % (dbse, '013TYR-075LEU-2')] =   -1.525  
BIND_BRONZE['%s-%s' % (dbse, '013VAL-016PHE-1')] =   -0.708  
BIND_BRONZE['%s-%s' % (dbse, '013VAL-066LEU-1')] =   -0.797  
BIND_BRONZE['%s-%s' % (dbse, '013VAL-154ASN-1')] =   -1.214  
BIND_BRONZE['%s-%s' % (dbse, '013VAL-154ASN-2')] =   -1.129  
BIND_BRONZE['%s-%s' % (dbse, '014ALA-055LEU-1')] =   -0.530  
BIND_BRONZE['%s-%s' % (dbse, '014ARG-083THR-1')] =    2.543  
BIND_BRONZE['%s-%s' % (dbse, '014ASN-027ARG-1')] =   -1.104  
BIND_BRONZE['%s-%s' % (dbse, '014ASN-061LYS-1')] =  -24.574  
BIND_BRONZE['%s-%s' % (dbse, '014ASN-137TYR-1')] =   -4.484  
BIND_BRONZE['%s-%s' % (dbse, '014ASP-017ARG-1')] =  -80.797  
BIND_BRONZE['%s-%s' % (dbse, '014GLN-093VAL-1')] =   -0.385  
BIND_BRONZE['%s-%s' % (dbse, '014GLU-036LYS-1')] = -121.178  
BIND_BRONZE['%s-%s' % (dbse, '014GLU-069ILE-1')] =   -2.599  
BIND_BRONZE['%s-%s' % (dbse, '014GLU-164TYR-1')] =  -26.907  
BIND_BRONZE['%s-%s' % (dbse, '014HIE-043TYR-1')] =   -1.506  
BIND_BRONZE['%s-%s' % (dbse, '014ILE-025TYR-1')] =   -0.782  
BIND_BRONZE['%s-%s' % (dbse, '014ILE-027ILE-1')] =   -0.375  
BIND_BRONZE['%s-%s' % (dbse, '014ILE-081PHE-1')] =   -1.211  
BIND_BRONZE['%s-%s' % (dbse, '014ILE-085ASN-1')] =   -1.443  
BIND_BRONZE['%s-%s' % (dbse, '014ILE-088MET-1')] =   -0.945  
BIND_BRONZE['%s-%s' % (dbse, '014LEU-061GLN-1')] =   -0.513  
BIND_BRONZE['%s-%s' % (dbse, '014LEU-070TRP-1')] =   -1.796  
BIND_BRONZE['%s-%s' % (dbse, '014LEU-163ILE-1')] =   -0.641  
BIND_BRONZE['%s-%s' % (dbse, '014LEU-174PRO-1')] =   -0.917  
BIND_BRONZE['%s-%s' % (dbse, '014LYS-023GLU-1')] = -124.544  
BIND_BRONZE['%s-%s' % (dbse, '014SER-017GLU-1')] =  -15.811  
BIND_BRONZE['%s-%s' % (dbse, '014SER-084GLN-1')] =   -4.772  
BIND_BRONZE['%s-%s' % (dbse, '014TYR-019GLU-1')] =   -3.424  
BIND_BRONZE['%s-%s' % (dbse, '014TYR-021PHE-1')] =   -1.677  
BIND_BRONZE['%s-%s' % (dbse, '014TYR-022LYS-1')] =   -1.554  
BIND_BRONZE['%s-%s' % (dbse, '014TYR-022LYS-2')] =   -1.934  
BIND_BRONZE['%s-%s' % (dbse, '014TYR-082PHE-1')] =   -2.868  
BIND_BRONZE['%s-%s' % (dbse, '014VAL-091ALA-1')] =   -0.448  
BIND_BRONZE['%s-%s' % (dbse, '015ARG-020ASP-1')] =  -99.803  
BIND_BRONZE['%s-%s' % (dbse, '015ARG-164ALA-1')] =   -0.612  
BIND_BRONZE['%s-%s' % (dbse, '015ASN-019THR-1')] =   -5.003  
BIND_BRONZE['%s-%s' % (dbse, '015ASN-048GLN-1')] =   -7.040  
BIND_BRONZE['%s-%s' % (dbse, '015ASN-069ARG-1')] =   -2.954  
BIND_BRONZE['%s-%s' % (dbse, '015ASN-149PHE-1')] =   -1.626  
BIND_BRONZE['%s-%s' % (dbse, '015CYS-057LEU-1')] =   -1.143  
BIND_BRONZE['%s-%s' % (dbse, '015GLU-019LYS-1')] = -106.272  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-019PRO-1')] =   -0.461  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-023LEU-1')] =   -0.419  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-030LEU-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-034LEU-1')] =   -0.426  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-035ARG-1')] =   -0.726  
BIND_BRONZE['%s-%s' % (dbse, '015ILE-136HIE-1')] =   -0.689  
BIND_BRONZE['%s-%s' % (dbse, '015LEU-035TRP-1')] =   -0.939  
BIND_BRONZE['%s-%s' % (dbse, '015LEU-038LEU-1')] =   -0.500  
BIND_BRONZE['%s-%s' % (dbse, '015LEU-080PHE-1')] =   -1.694  
BIND_BRONZE['%s-%s' % (dbse, '015LEU-084TYR-1')] =   -1.291  
BIND_BRONZE['%s-%s' % (dbse, '015LEU-102SER-1')] =    0.398  
BIND_BRONZE['%s-%s' % (dbse, '015LYS-047TYR-1')] =   -0.679  
BIND_BRONZE['%s-%s' % (dbse, '015LYS-047TYR-2')] =  -13.351  
BIND_BRONZE['%s-%s' % (dbse, '015LYS-220ASP-1')] = -107.377  
BIND_BRONZE['%s-%s' % (dbse, '015LYS-223GLU-1')] =   -4.434  
BIND_BRONZE['%s-%s' % (dbse, '015MET-023LEU-1')] =   -0.921  
BIND_BRONZE['%s-%s' % (dbse, '015MET-023LEU-2')] =   -0.916  
BIND_BRONZE['%s-%s' % (dbse, '015PHE-039ALA-1')] =   -0.881  
BIND_BRONZE['%s-%s' % (dbse, '015PHE-044LEU-1')] =   -1.510  
BIND_BRONZE['%s-%s' % (dbse, '015SER-018THR-1')] =   -0.050  
BIND_BRONZE['%s-%s' % (dbse, '015SER-037LYS-1')] =   -0.572  
BIND_BRONZE['%s-%s' % (dbse, '015THR-019ASP-1')] =   -0.683  
BIND_BRONZE['%s-%s' % (dbse, '015THR-021MET-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '015THR-060HIE-1')] =   -8.974  
BIND_BRONZE['%s-%s' % (dbse, '015THR-061GLN-1')] =   -5.503  
BIND_BRONZE['%s-%s' % (dbse, '015TRP-025THR-1')] =   -1.166  
BIND_BRONZE['%s-%s' % (dbse, '015TRP-096TYR-1')] =   -3.897  
BIND_BRONZE['%s-%s' % (dbse, '015TYR-034ILE-1')] =   -1.953  
BIND_BRONZE['%s-%s' % (dbse, '015VAL-060TYR-1')] =   -1.032  
BIND_BRONZE['%s-%s' % (dbse, '016ARG-047PHE-1')] =   -2.296  
BIND_BRONZE['%s-%s' % (dbse, '016GLN-048ILE-1')] =   -0.682  
BIND_BRONZE['%s-%s' % (dbse, '016GLN-098LEU-1')] =   -0.412  
BIND_BRONZE['%s-%s' % (dbse, '016GLN-101GLN-1')] =   -2.214  
BIND_BRONZE['%s-%s' % (dbse, '016GLU-035TRP-1')] =   -2.676  
BIND_BRONZE['%s-%s' % (dbse, '016ILE-021VAL-1')] =   -1.209  
BIND_BRONZE['%s-%s' % (dbse, '016ILE-145LYS-1')] =   -0.470  
BIND_BRONZE['%s-%s' % (dbse, '016ILE-219PRO-1')] =   -0.822  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-036LEU-1')] =   -0.253  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-046ILE-1')] =   -0.308  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-062LEU-1')] =   -0.204  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-065LEU-1')] =   -0.618  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-072PRO-1')] =   -0.515  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-082SER-2')] =    0.458  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-137ILE-1')] =   -0.669  
BIND_BRONZE['%s-%s' % (dbse, '016LEU-141MET-1')] =   -0.811  
BIND_BRONZE['%s-%s' % (dbse, '016LYS-085GLU-1')] = -105.772  
BIND_BRONZE['%s-%s' % (dbse, '016PHE-034VAL-1')] =   -1.842  
BIND_BRONZE['%s-%s' % (dbse, '016PHE-036VAL-1')] =   -1.751  
BIND_BRONZE['%s-%s' % (dbse, '016PHE-132ILE-1')] =   -0.908  
BIND_BRONZE['%s-%s' % (dbse, '016PHE-176PHE-1')] =   -2.825  
BIND_BRONZE['%s-%s' % (dbse, '016PHE-192LEU-1')] =   -2.195  
BIND_BRONZE['%s-%s' % (dbse, '016SER-031ASN-2')] =   -5.403  
BIND_BRONZE['%s-%s' % (dbse, '016THR-022MET-1')] =   -1.192  
BIND_BRONZE['%s-%s' % (dbse, '016TYR-079ILE-1')] =   -1.630  
BIND_BRONZE['%s-%s' % (dbse, '016VAL-033THR-1')] =   -0.326  
BIND_BRONZE['%s-%s' % (dbse, '016VAL-055PHE-1')] =   -0.820  
BIND_BRONZE['%s-%s' % (dbse, '016VAL-059PHE-1')] =   -1.433  
BIND_BRONZE['%s-%s' % (dbse, '016VAL-084ILE-1')] =   -0.426  
BIND_BRONZE['%s-%s' % (dbse, '017ARG-056HIE-1')] =   -8.658  
BIND_BRONZE['%s-%s' % (dbse, '017ASN-021LYS-1')] =  -19.311  
BIND_BRONZE['%s-%s' % (dbse, '017ASN-029ASN-2')] =   -6.663  
BIND_BRONZE['%s-%s' % (dbse, '017ASP-049ARG-1')] =  -76.868  
BIND_BRONZE['%s-%s' % (dbse, '017ASP-060HIE-1')] =   -7.870  
BIND_BRONZE['%s-%s' % (dbse, '017GLN-024ASN-1')] =   -8.000  
BIND_BRONZE['%s-%s' % (dbse, '017GLN-093VAL-1')] =    0.342  
BIND_BRONZE['%s-%s' % (dbse, '017GLN-094ASP-1')] =  -25.027  
BIND_BRONZE['%s-%s' % (dbse, '017GLU-036TRP-1')] =   -3.379  
BIND_BRONZE['%s-%s' % (dbse, '017GLU-072PRO-1')] =   -4.814  
BIND_BRONZE['%s-%s' % (dbse, '017HIE-033ASP-1')] =  -20.295  
BIND_BRONZE['%s-%s' % (dbse, '017HIE-035TRP-1')] =   -6.033  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-021LEU-1')] =   -1.284  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-028LEU-1')] =   -0.706  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-028LEU-2')] =   -0.352  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-030PHE-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-055HIE-1')] =   -2.987  
BIND_BRONZE['%s-%s' % (dbse, '017ILE-149PHE-1')] =   -2.559  
BIND_BRONZE['%s-%s' % (dbse, '017LEU-050ILE-1')] =   -0.423  
BIND_BRONZE['%s-%s' % (dbse, '017LEU-056PHE-1')] =   -0.640  
BIND_BRONZE['%s-%s' % (dbse, '017LEU-066LEU-1')] =    0.273  
BIND_BRONZE['%s-%s' % (dbse, '017LEU-083ILE-1')] =   -0.701  
BIND_BRONZE['%s-%s' % (dbse, '017MET-020LYS-1')] =   -1.420  
BIND_BRONZE['%s-%s' % (dbse, '017PHE-022SER-2')] =   -3.163  
BIND_BRONZE['%s-%s' % (dbse, '017PHE-025TYR-1')] =   -1.703  
BIND_BRONZE['%s-%s' % (dbse, '017PHE-077ASP-1')] =   -7.555  
BIND_BRONZE['%s-%s' % (dbse, '017PHE-081PHE-1')] =   -2.602  
BIND_BRONZE['%s-%s' % (dbse, '017PHE-084LEU-1')] =   -1.478  
BIND_BRONZE['%s-%s' % (dbse, '017THR-078GLU-1')] =  -14.431  
BIND_BRONZE['%s-%s' % (dbse, '017THR-307TRP-1')] =   -1.804  
BIND_BRONZE['%s-%s' % (dbse, '017VAL-049LEU-1')] =   -0.693  
BIND_BRONZE['%s-%s' % (dbse, '018ALA-023VAL-1')] =   -0.406  
BIND_BRONZE['%s-%s' % (dbse, '018ALA-026GLU-1')] =   -2.866  
BIND_BRONZE['%s-%s' % (dbse, '018ALA-027VAL-1')] =   -0.389  
BIND_BRONZE['%s-%s' % (dbse, '018ARG-057THR-1')] =   -0.548  
BIND_BRONZE['%s-%s' % (dbse, '018ASN-227ALA-1')] =   -1.030  
BIND_BRONZE['%s-%s' % (dbse, '018ASP-032THR-1')] =  -19.790  
BIND_BRONZE['%s-%s' % (dbse, '018ASP-034ALA-1')] =   -4.126  
BIND_BRONZE['%s-%s' % (dbse, '018CYS-132HIE-1')] =   -4.051  
BIND_BRONZE['%s-%s' % (dbse, '018GLU-074ILE-1')] =   -1.891  
BIND_BRONZE['%s-%s' % (dbse, '018ILE-022GLN-1')] =   -1.280  
BIND_BRONZE['%s-%s' % (dbse, '018ILE-052VAL-1')] =   -0.507  
BIND_BRONZE['%s-%s' % (dbse, '018ILE-055ASN-1')] =   -1.371  
BIND_BRONZE['%s-%s' % (dbse, '018ILE-055PHE-1')] =   -1.096  
BIND_BRONZE['%s-%s' % (dbse, '018LEU-039ILE-1')] =    1.618  
BIND_BRONZE['%s-%s' % (dbse, '018LYS-024TYR-1')] =   -2.504  
BIND_BRONZE['%s-%s' % (dbse, '018PRO-060HIE-1')] =   -1.742  
BIND_BRONZE['%s-%s' % (dbse, '018PRO-085GLU-1')] =   -0.539  
BIND_BRONZE['%s-%s' % (dbse, '018PRO-086VAL-1')] =   -1.174  
BIND_BRONZE['%s-%s' % (dbse, '018PRO-139LEU-1')] =   -0.835  
BIND_BRONZE['%s-%s' % (dbse, '018SER-024LEU-1')] =   -0.310  
BIND_BRONZE['%s-%s' % (dbse, '018SER-040GLU-1')] =  -17.857  
BIND_BRONZE['%s-%s' % (dbse, '018THR-035ILE-1')] =   -0.527  
BIND_BRONZE['%s-%s' % (dbse, '018VAL-034ILE-1')] =   -0.696  
BIND_BRONZE['%s-%s' % (dbse, '018VAL-164TYR-1')] =   -1.602  
BIND_BRONZE['%s-%s' % (dbse, '018VAL-166ILE-1')] =   -0.783  
BIND_BRONZE['%s-%s' % (dbse, '019ALA-055HIE-1')] =   -1.513  
BIND_BRONZE['%s-%s' % (dbse, '019ALA-058TYR-1')] =   -1.298  
BIND_BRONZE['%s-%s' % (dbse, '019ARG-027ARG-1')] =   60.006  
BIND_BRONZE['%s-%s' % (dbse, '019ASN-053VAL-1')] =   -1.047  
BIND_BRONZE['%s-%s' % (dbse, '019GLN-026GLU-1')] =   -1.990  
BIND_BRONZE['%s-%s' % (dbse, '019GLU-022LYS-2')] =   -0.998  
BIND_BRONZE['%s-%s' % (dbse, '019GLU-025THR-1')] =  -17.112  
BIND_BRONZE['%s-%s' % (dbse, '019ILE-051VAL-1')] =   -0.674  
BIND_BRONZE['%s-%s' % (dbse, '019LEU-037ILE-1')] =   -0.592  
BIND_BRONZE['%s-%s' % (dbse, '019LEU-041VAL-1')] =   -0.897  
BIND_BRONZE['%s-%s' % (dbse, '019LEU-061ARG-1')] =   -0.631  
BIND_BRONZE['%s-%s' % (dbse, '019LEU-062LEU-1')] =   -0.846  
BIND_BRONZE['%s-%s' % (dbse, '019LEU-062LEU-2')] =   -0.956  
BIND_BRONZE['%s-%s' % (dbse, '019LYS-027VAL-1')] =   -0.618  
BIND_BRONZE['%s-%s' % (dbse, '019LYS-031HIE-1')] =   -0.620  
BIND_BRONZE['%s-%s' % (dbse, '019LYS-071GLU-1')] = -116.619  
BIND_BRONZE['%s-%s' % (dbse, '019PHE-049LEU-1')] =   -0.805  
BIND_BRONZE['%s-%s' % (dbse, '019SER-023ARG-1')] =    0.037  
BIND_BRONZE['%s-%s' % (dbse, '019SER-023ARG-2')] =   -5.981  
BIND_BRONZE['%s-%s' % (dbse, '019SER-026ARG-1')] =  -14.558  
BIND_BRONZE['%s-%s' % (dbse, '019THR-022MET-1')] =   -1.313  
BIND_BRONZE['%s-%s' % (dbse, '019THR-035GLU-1')] =   -0.953  
BIND_BRONZE['%s-%s' % (dbse, '019THR-035GLU-2')] =   -2.761  
BIND_BRONZE['%s-%s' % (dbse, '019TYR-050TRP-1')] =   -3.694  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-027ILE-1')] =   -0.711  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-058VAL-1')] =   -0.136  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-075LEU-1')] =   -0.386  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-081LEU-1')] =   -0.511  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-137ILE-1')] =   -0.348  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-138VAL-1')] =   -0.074  
BIND_BRONZE['%s-%s' % (dbse, '019VAL-138VAL-2')] =   -0.475  
BIND_BRONZE['%s-%s' % (dbse, '020ASN-039LYS-2')] =  -25.169  
BIND_BRONZE['%s-%s' % (dbse, '020ASN-040LYS-1')] =  -23.938  
BIND_BRONZE['%s-%s' % (dbse, '020ASP-082LYS-1')] =  -79.573  
BIND_BRONZE['%s-%s' % (dbse, '020GLN-036TRP-1')] =   -2.841  
BIND_BRONZE['%s-%s' % (dbse, '020GLN-059ARG-1')] =   -2.172  
BIND_BRONZE['%s-%s' % (dbse, '020HIE-062ASP-2')] =   10.546  
BIND_BRONZE['%s-%s' % (dbse, '020HIE-068LYS-1')] =   -2.278  
BIND_BRONZE['%s-%s' % (dbse, '020ILE-023VAL-1')] =   -0.366  
BIND_BRONZE['%s-%s' % (dbse, '020ILE-032THR-1')] =   -0.653  
BIND_BRONZE['%s-%s' % (dbse, '020ILE-082ILE-1')] =   -0.482  
BIND_BRONZE['%s-%s' % (dbse, '020ILE-309ALA-1')] =   -0.363  
BIND_BRONZE['%s-%s' % (dbse, '020LEU-024VAL-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '020LEU-038ILE-1')] =   -0.322  
BIND_BRONZE['%s-%s' % (dbse, '020LEU-042VAL-1')] =    1.044  
BIND_BRONZE['%s-%s' % (dbse, '020LYS-040GLU-1')] = -121.541  
BIND_BRONZE['%s-%s' % (dbse, '020PHE-135PHE-1')] =   -2.379  
BIND_BRONZE['%s-%s' % (dbse, '020PHE-149LEU-1')] =   -1.106  
BIND_BRONZE['%s-%s' % (dbse, '020PRO-023ARG-2')] =    0.946  
BIND_BRONZE['%s-%s' % (dbse, '020PRO-177PRO-1')] =   -1.008  
BIND_BRONZE['%s-%s' % (dbse, '020PRO-178LYS-1')] =   -0.843  
BIND_BRONZE['%s-%s' % (dbse, '020PRO-181ILE-1')] =   -0.233  
BIND_BRONZE['%s-%s' % (dbse, '020SER-058VAL-1')] =   -0.138  
BIND_BRONZE['%s-%s' % (dbse, '020SER-091ARG-1')] =   -0.565  
BIND_BRONZE['%s-%s' % (dbse, '020VAL-029TYR-1')] =   -0.900  
BIND_BRONZE['%s-%s' % (dbse, '021ALA-039TYR-1')] =   -0.760  
BIND_BRONZE['%s-%s' % (dbse, '021ALA-057VAL-1')] =   -1.304  
BIND_BRONZE['%s-%s' % (dbse, '021ALA-100ASN-1')] =   -1.160  
BIND_BRONZE['%s-%s' % (dbse, '021ARG-033THR-1')] =   -1.589  
BIND_BRONZE['%s-%s' % (dbse, '021ARG-035GLU-1')] =   -4.456  
BIND_BRONZE['%s-%s' % (dbse, '021ARG-035GLU-2')] =  -91.610  
BIND_BRONZE['%s-%s' % (dbse, '021GLN-024LYS-1')] =  -22.523  
BIND_BRONZE['%s-%s' % (dbse, '021GLN-024LYS-2')] =   -1.310  
BIND_BRONZE['%s-%s' % (dbse, '021GLN-057TYR-1')] =   -1.932  
BIND_BRONZE['%s-%s' % (dbse, '021HIE-061PHE-1')] =   -2.176  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-031HIE-1')] =   -0.549  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-036VAL-1')] =   -0.605  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-038VAL-1')] =   -1.149  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-041PHE-1')] =   -1.503  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-077LEU-1')] =   -0.081  
BIND_BRONZE['%s-%s' % (dbse, '021ILE-088ILE-1')] =   -0.769  
BIND_BRONZE['%s-%s' % (dbse, '021LYS-032TYR-1')] =  -11.587  
BIND_BRONZE['%s-%s' % (dbse, '021LYS-039ILE-1')] =   -0.768  
BIND_BRONZE['%s-%s' % (dbse, '021MET-058TYR-1')] =   -3.878  
BIND_BRONZE['%s-%s' % (dbse, '021MET-062GLN-1')] =   -0.802  
BIND_BRONZE['%s-%s' % (dbse, '021MET-069ILE-1')] =   -1.228  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-025GLN-1')] =   -2.132  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-038VAL-1')] =   -0.688  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-054ILE-1')] =   -0.869  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-060PRO-1')] =   -1.875  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-072PHE-1')] =   -2.832  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-072THR-1')] =   -1.836  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-076VAL-1')] =   -1.211  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-079ILE-1')] =   -1.133  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-082PHE-1')] =   -2.830  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-097LEU-1')] =   -0.659  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-097LEU-2')] =   -1.758  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-113ILE-1')] =   -0.168  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-131VAL-1')] =   -1.014  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-251HIE-1')] =   -2.137  
BIND_BRONZE['%s-%s' % (dbse, '021PHE-260ILE-1')] =   -1.109  
BIND_BRONZE['%s-%s' % (dbse, '021SER-142ASN-1')] =   -1.815  
BIND_BRONZE['%s-%s' % (dbse, '021THR-148GLN-1')] =   -0.119  
BIND_BRONZE['%s-%s' % (dbse, '021THR-150LYS-1')] =   -0.883  
BIND_BRONZE['%s-%s' % (dbse, '021TYR-088PHE-1')] =   -2.569  
BIND_BRONZE['%s-%s' % (dbse, '022ARG-072GLU-1')] = -105.900  
BIND_BRONZE['%s-%s' % (dbse, '022ARG-073GLU-1')] =  -87.894  
BIND_BRONZE['%s-%s' % (dbse, '022GLN-028GLN-1')] =    2.439  
BIND_BRONZE['%s-%s' % (dbse, '022GLN-046MET-1')] =   -2.886  
BIND_BRONZE['%s-%s' % (dbse, '022GLN-055ASN-1')] =    8.487  
BIND_BRONZE['%s-%s' % (dbse, '022GLN-058GLU-1')] =   -3.797  
BIND_BRONZE['%s-%s' % (dbse, '022GLN-147TYR-1')] =   -5.519  
BIND_BRONZE['%s-%s' % (dbse, '022ILE-072HIE-1')] =   -1.103  
BIND_BRONZE['%s-%s' % (dbse, '022ILE-074ILE-1')] =    1.595  
BIND_BRONZE['%s-%s' % (dbse, '022LEU-057THR-1')] =   -0.841  
BIND_BRONZE['%s-%s' % (dbse, '022LEU-058PHE-1')] =   -1.320  
BIND_BRONZE['%s-%s' % (dbse, '022LEU-062ILE-1')] =   -0.732  
BIND_BRONZE['%s-%s' % (dbse, '022LEU-065LEU-1')] =   -0.622  
BIND_BRONZE['%s-%s' % (dbse, '022LEU-081LYS-2')] =   -0.809  
BIND_BRONZE['%s-%s' % (dbse, '022LYS-086ILE-1')] =   -0.807  
BIND_BRONZE['%s-%s' % (dbse, '022MET-041VAL-1')] =   -0.694  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-027ILE-1')] =   -1.108  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-031ILE-1')] =   -1.506  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-039TRP-1')] =   -1.964  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-040ALA-1')] =   -1.569  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-041PHE-1')] =   -1.800  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-064VAL-1')] =   -1.067  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-069VAL-1')] =   -1.227  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-069VAL-2')] =   -1.594  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-099ALA-1')] =   -0.880  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-166ILE-1')] =   -1.232  
BIND_BRONZE['%s-%s' % (dbse, '022PHE-168TYR-1')] =   -2.797  
BIND_BRONZE['%s-%s' % (dbse, '022SER-121LEU-1')] =   -0.692  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-026THR-1')] =   -1.722  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-039TYR-1')] =   -2.169  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-040TRP-1')] =   -2.425  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-043ILE-1')] =   -0.982  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-055LEU-2')] =   -2.044  
BIND_BRONZE['%s-%s' % (dbse, '022TRP-059VAL-1')] =   -1.327  
BIND_BRONZE['%s-%s' % (dbse, '022VAL-067LEU-1')] =   -0.508  
BIND_BRONZE['%s-%s' % (dbse, '022VAL-079TYR-1')] =   -0.935  
BIND_BRONZE['%s-%s' % (dbse, '022VAL-079TYR-2')] =   -1.190  
BIND_BRONZE['%s-%s' % (dbse, '023ASP-027ARG-1')] = -105.796  
BIND_BRONZE['%s-%s' % (dbse, '023ASP-042ARG-1')] = -120.816  
BIND_BRONZE['%s-%s' % (dbse, '023ASP-057ARG-1')] = -115.252  
BIND_BRONZE['%s-%s' % (dbse, '023GLN-177PRO-1')] =   -1.906  
BIND_BRONZE['%s-%s' % (dbse, '023GLN-217THR-1')] =   -6.272  
BIND_BRONZE['%s-%s' % (dbse, '023GLU-028LEU-1')] =   -2.198  
BIND_BRONZE['%s-%s' % (dbse, '023GLU-046LYS-1')] = -110.092  
BIND_BRONZE['%s-%s' % (dbse, '023ILE-060PRO-1')] =   -0.616  
BIND_BRONZE['%s-%s' % (dbse, '023LEU-035PHE-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '023LEU-035PHE-2')] =   -0.934  
BIND_BRONZE['%s-%s' % (dbse, '023LEU-036ARG-1')] =   -1.019  
BIND_BRONZE['%s-%s' % (dbse, '023LEU-055ILE-1')] =   -0.479  
BIND_BRONZE['%s-%s' % (dbse, '023LEU-097LEU-1')] =   -0.577  
BIND_BRONZE['%s-%s' % (dbse, '023LYS-029GLU-1')] =  -79.994  
BIND_BRONZE['%s-%s' % (dbse, '023LYS-029GLU-2')] =   -4.317  
BIND_BRONZE['%s-%s' % (dbse, '023LYS-064TYR-1')] =   -7.830  
BIND_BRONZE['%s-%s' % (dbse, '023LYS-064TYR-2')] =   -1.469  
BIND_BRONZE['%s-%s' % (dbse, '023MET-038ILE-1')] =   -0.979  
BIND_BRONZE['%s-%s' % (dbse, '023SER-051ASN-1')] =    1.813  
BIND_BRONZE['%s-%s' % (dbse, '023THR-085ALA-1')] =   -0.348  
BIND_BRONZE['%s-%s' % (dbse, '023TYR-026LEU-1')] =   -0.808  
BIND_BRONZE['%s-%s' % (dbse, '023TYR-031TYR-1')] =   -3.496  
BIND_BRONZE['%s-%s' % (dbse, '023VAL-041ILE-1')] =   -0.223  
BIND_BRONZE['%s-%s' % (dbse, '023VAL-055LEU-1')] =   -0.782  
BIND_BRONZE['%s-%s' % (dbse, '024ALA-034ALA-1')] =   -0.352  
BIND_BRONZE['%s-%s' % (dbse, '024ARG-073ASN-1')] =  -16.225  
BIND_BRONZE['%s-%s' % (dbse, '024ARG-076GLU-1')] = -109.142  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-027ARG-1')] =  -24.738  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-027LEU-2')] =   -2.261  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-029ILE-1')] =   -0.766  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-034TYR-1')] =   -4.127  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-056PHE-1')] =   -2.037  
BIND_BRONZE['%s-%s' % (dbse, '024ASN-058TYR-1')] =   -4.666  
BIND_BRONZE['%s-%s' % (dbse, '024ASP-065HIE-1')] =  -26.898  
BIND_BRONZE['%s-%s' % (dbse, '024CYS-100ASN-1')] =   -2.608  
BIND_BRONZE['%s-%s' % (dbse, '024GLU-040HIE-1')] =  -25.468  
BIND_BRONZE['%s-%s' % (dbse, '024GLU-041LEU-1')] =   -1.025  
BIND_BRONZE['%s-%s' % (dbse, '024GLU-050ARG-1')] =   -4.435  
BIND_BRONZE['%s-%s' % (dbse, '024GLU-054ARG-1')] = -105.041  
BIND_BRONZE['%s-%s' % (dbse, '024ILE-055TYR-1')] =   -0.916  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-028GLU-1')] =   -0.649  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-028GLU-2')] =   -2.366  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-029GLU-1')] =   -2.049  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-031LEU-1')] =   -1.099  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-032VAL-1')] =   -0.530  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-054VAL-1')] =   -0.591  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-260ILE-1')] =   -1.228  
BIND_BRONZE['%s-%s' % (dbse, '024LEU-261ASN-1')] =   -1.219  
BIND_BRONZE['%s-%s' % (dbse, '024LYS-057TYR-1')] =   -1.130  
BIND_BRONZE['%s-%s' % (dbse, '024LYS-069TYR-1')] =   -2.200  
BIND_BRONZE['%s-%s' % (dbse, '024LYS-069TYR-2')] =   -9.604  
BIND_BRONZE['%s-%s' % (dbse, '024PHE-089LEU-1')] =   -0.185  
BIND_BRONZE['%s-%s' % (dbse, '024PHE-089THR-1')] =   -0.442  
BIND_BRONZE['%s-%s' % (dbse, '024PHE-099TRP-1')] =   -3.190  
BIND_BRONZE['%s-%s' % (dbse, '024PHE-100SER-1')] =   -0.970  
BIND_BRONZE['%s-%s' % (dbse, '024PHE-130LYS-1')] =   -1.467  
BIND_BRONZE['%s-%s' % (dbse, '024SER-038THR-1')] =    4.153  
BIND_BRONZE['%s-%s' % (dbse, '024THR-041GLU-1')] =   -3.809  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-032HIE-1')] =   -1.231  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-049ILE-1')] =   -0.580  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-054PHE-1')] =   -0.977  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-079PHE-1')] =   -2.190  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-142VAL-1')] =   -0.489  
BIND_BRONZE['%s-%s' % (dbse, '024VAL-143GLN-1')] =   -1.314  
BIND_BRONZE['%s-%s' % (dbse, '025ALA-035TRP-1')] =   -0.873  
BIND_BRONZE['%s-%s' % (dbse, '025ALA-037ALA-1')] =   -0.748  
BIND_BRONZE['%s-%s' % (dbse, '025ASN-181ASN-1')] =   -7.436  
BIND_BRONZE['%s-%s' % (dbse, '025ASN-183THR-1')] =   -5.877  
BIND_BRONZE['%s-%s' % (dbse, '025GLN-029LYS-1')] =   -1.235  
BIND_BRONZE['%s-%s' % (dbse, '025GLN-036THR-1')] =    1.135  
BIND_BRONZE['%s-%s' % (dbse, '025GLN-039TYR-1')] =   -4.215  
BIND_BRONZE['%s-%s' % (dbse, '025GLN-260ILE-1')] =   -0.724  
BIND_BRONZE['%s-%s' % (dbse, '025GLN-274ILE-1')] =   -0.985  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-028VAL-1')] =   -0.575  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-036VAL-1')] =   -0.597  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-056LEU-1')] =   -0.355  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-059ASP-1')] =   -2.021  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-084ILE-1')] =   -0.010  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-084ILE-2')] =   -0.427  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-090ALA-1')] =   -0.547  
BIND_BRONZE['%s-%s' % (dbse, '025ILE-091VAL-1')] =   -0.461  
BIND_BRONZE['%s-%s' % (dbse, '025LEU-055VAL-1')] =   -0.503  
BIND_BRONZE['%s-%s' % (dbse, '025LEU-060PRO-1')] =   -0.845  
BIND_BRONZE['%s-%s' % (dbse, '025LEU-075ILE-1')] =   -0.764  
BIND_BRONZE['%s-%s' % (dbse, '025LEU-075ILE-2')] =   -0.521  
BIND_BRONZE['%s-%s' % (dbse, '025SER-035ALA-1')] =   -0.260  
BIND_BRONZE['%s-%s' % (dbse, '025SER-075ASP-1')] =    4.374  
BIND_BRONZE['%s-%s' % (dbse, '025SER-100ILE-1')] =   -1.317  
BIND_BRONZE['%s-%s' % (dbse, '025THR-045THR-1')] =   -4.712  
BIND_BRONZE['%s-%s' % (dbse, '025THR-100TRP-1')] =   -1.362  
BIND_BRONZE['%s-%s' % (dbse, '025THR-103LYS-1')] =  -17.339  
BIND_BRONZE['%s-%s' % (dbse, '025TRP-038MET-1')] =   -0.753  
BIND_BRONZE['%s-%s' % (dbse, '025TRP-135ALA-1')] =   -1.138  
BIND_BRONZE['%s-%s' % (dbse, '025TRP-144LYS-1')] =   -0.983  
BIND_BRONZE['%s-%s' % (dbse, '025TRP-146PHE-1')] =   -4.588  
BIND_BRONZE['%s-%s' % (dbse, '025TRP-152GLU-1')] =  -22.221  
BIND_BRONZE['%s-%s' % (dbse, '025TYR-080ARG-1')] =   -2.450  
BIND_BRONZE['%s-%s' % (dbse, '025TYR-081PHE-1')] =   -2.110  
BIND_BRONZE['%s-%s' % (dbse, '025TYR-084LEU-1')] =   -1.578  
BIND_BRONZE['%s-%s' % (dbse, '025VAL-029TRP-1')] =   -0.882  
BIND_BRONZE['%s-%s' % (dbse, '025VAL-057VAL-1')] =   -0.642  
BIND_BRONZE['%s-%s' % (dbse, '025VAL-069ILE-1')] =   -0.813  
BIND_BRONZE['%s-%s' % (dbse, '025VAL-083GLU-2')] =   -1.607  
BIND_BRONZE['%s-%s' % (dbse, '025VAL-185ARG-1')] =   -0.751  
BIND_BRONZE['%s-%s' % (dbse, '026ASN-054ASN-1')] =   -7.486  
BIND_BRONZE['%s-%s' % (dbse, '026ASN-055ILE-1')] =   -1.193  
BIND_BRONZE['%s-%s' % (dbse, '026ASN-058GLU-1')] =  -15.533  
BIND_BRONZE['%s-%s' % (dbse, '026ASP-042PHE-1')] =   -1.257  
BIND_BRONZE['%s-%s' % (dbse, '026ASP-077PHE-1')] =   -3.553  
BIND_BRONZE['%s-%s' % (dbse, '026GLN-065HIE-1')] =   -0.881  
BIND_BRONZE['%s-%s' % (dbse, '026GLN-065HIE-2')] =   -0.929  
BIND_BRONZE['%s-%s' % (dbse, '026GLU-042HIE-1')] =   13.638  
BIND_BRONZE['%s-%s' % (dbse, '026GLU-057TYR-2')] =  -25.029  
BIND_BRONZE['%s-%s' % (dbse, '026GLU-059ARG-1')] =  -98.937  
BIND_BRONZE['%s-%s' % (dbse, '026ILE-037TRP-1')] =   -1.132  
BIND_BRONZE['%s-%s' % (dbse, '026ILE-078ALA-1')] =   -0.396  
BIND_BRONZE['%s-%s' % (dbse, '026LEU-037PHE-1')] =   -0.670  
BIND_BRONZE['%s-%s' % (dbse, '026LEU-039ILE-1')] =   -0.861  
BIND_BRONZE['%s-%s' % (dbse, '026LEU-040GLU-1')] =   -1.969  
BIND_BRONZE['%s-%s' % (dbse, '026LEU-041VAL-1')] =   -1.161  
BIND_BRONZE['%s-%s' % (dbse, '026LEU-135ALA-1')] =   -0.838  
BIND_BRONZE['%s-%s' % (dbse, '026MET-029PHE-1')] =   -2.570  
BIND_BRONZE['%s-%s' % (dbse, '026MET-099ALA-1')] =   -0.769  
BIND_BRONZE['%s-%s' % (dbse, '026MET-103HIE-1')] =   -3.069  
BIND_BRONZE['%s-%s' % (dbse, '026MET-168TYR-1')] =   -1.481  
BIND_BRONZE['%s-%s' % (dbse, '026PHE-030TRP-1')] =   -1.998  
BIND_BRONZE['%s-%s' % (dbse, '026PHE-036PHE-1')] =   -1.832  
BIND_BRONZE['%s-%s' % (dbse, '026PHE-118ILE-1')] =   -1.233  
BIND_BRONZE['%s-%s' % (dbse, '026PHE-217THR-1')] =   -3.341  
BIND_BRONZE['%s-%s' % (dbse, '026THR-031LEU-1')] =   -0.448  
BIND_BRONZE['%s-%s' % (dbse, '026TYR-062ILE-1')] =   -1.003  
BIND_BRONZE['%s-%s' % (dbse, '026TYR-069TYR-1')] =   -2.749  
BIND_BRONZE['%s-%s' % (dbse, '026VAL-041GLU-1')] =   -2.353  
BIND_BRONZE['%s-%s' % (dbse, '026VAL-041GLU-2')] =   -2.189  
BIND_BRONZE['%s-%s' % (dbse, '027ALA-074LEU-1')] =   -0.860  
BIND_BRONZE['%s-%s' % (dbse, '027ALA-102ASN-1')] =   -1.297  
BIND_BRONZE['%s-%s' % (dbse, '027ARG-049GLU-1')] =  -96.493  
BIND_BRONZE['%s-%s' % (dbse, '027ARG-055THR-1')] =   -2.236  
BIND_BRONZE['%s-%s' % (dbse, '027ARG-094ASP-1')] =  -97.170  
BIND_BRONZE['%s-%s' % (dbse, '027ILE-039THR-1')] =   -0.662  
BIND_BRONZE['%s-%s' % (dbse, '027ILE-046PHE-1')] =   -0.683  
BIND_BRONZE['%s-%s' % (dbse, '027ILE-075LEU-1')] =   -0.523  
BIND_BRONZE['%s-%s' % (dbse, '027LYS-089LEU-1')] =   -0.780  
BIND_BRONZE['%s-%s' % (dbse, '027PHE-030ILE-1')] =   -1.505  
BIND_BRONZE['%s-%s' % (dbse, '027PHE-057VAL-1')] =   -2.088  
BIND_BRONZE['%s-%s' % (dbse, '027PHE-069SER-1')] =   -2.056  
BIND_BRONZE['%s-%s' % (dbse, '027PHE-071VAL-1')] =   -0.953  
BIND_BRONZE['%s-%s' % (dbse, '027PHE-078GLN-1')] =   -2.529  
BIND_BRONZE['%s-%s' % (dbse, '027PRO-032MET-1')] =   -1.049  
BIND_BRONZE['%s-%s' % (dbse, '027SER-034ILE-1')] =   -0.699  
BIND_BRONZE['%s-%s' % (dbse, '027THR-036SER-1')] =   -5.640  
BIND_BRONZE['%s-%s' % (dbse, '027VAL-070TRP-1')] =   -2.524  
BIND_BRONZE['%s-%s' % (dbse, '027VAL-085ALA-1')] =   -0.535  
BIND_BRONZE['%s-%s' % (dbse, '027VAL-086TYR-1')] =   -1.423  
BIND_BRONZE['%s-%s' % (dbse, '027VAL-088ILE-1')] =   -0.047  
BIND_BRONZE['%s-%s' % (dbse, '027VAL-090THR-1')] =   -0.497  
BIND_BRONZE['%s-%s' % (dbse, '028ALA-038VAL-1')] =   -0.222  
BIND_BRONZE['%s-%s' % (dbse, '028ALA-041VAL-1')] =   -0.312  
BIND_BRONZE['%s-%s' % (dbse, '028ARG-031GLN-1')] =  -17.397  
BIND_BRONZE['%s-%s' % (dbse, '028GLU-072HIE-1')] =  -24.903  
BIND_BRONZE['%s-%s' % (dbse, '028GLU-097LYS-1')] = -113.852  
BIND_BRONZE['%s-%s' % (dbse, '028ILE-036LEU-1')] =   -0.529  
BIND_BRONZE['%s-%s' % (dbse, '028ILE-091VAL-1')] =   -0.565  
BIND_BRONZE['%s-%s' % (dbse, '028ILE-106VAL-1')] =    0.716  
BIND_BRONZE['%s-%s' % (dbse, '028ILE-151VAL-1')] =   -0.906  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-037VAL-1')] =   -0.770  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-055LYS-1')] =   -2.327  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-058ALA-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-059ARG-2')] =   -0.844  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-061GLU-1')] =   -1.096  
BIND_BRONZE['%s-%s' % (dbse, '028LEU-133PHE-1')] =   -0.711  
BIND_BRONZE['%s-%s' % (dbse, '028LYS-067TYR-1')] =   -2.641  
BIND_BRONZE['%s-%s' % (dbse, '028LYS-317ASN-1')] =  -20.953  
BIND_BRONZE['%s-%s' % (dbse, '028MET-031ASP-1')] =   -3.913  
BIND_BRONZE['%s-%s' % (dbse, '028MET-037ARG-2')] =   -0.857  
BIND_BRONZE['%s-%s' % (dbse, '028MET-040HIE-1')] =   -2.592  
BIND_BRONZE['%s-%s' % (dbse, '028PRO-058LEU-1')] =   -0.818  
BIND_BRONZE['%s-%s' % (dbse, '028PRO-111LEU-1')] =   -1.097  
BIND_BRONZE['%s-%s' % (dbse, '028SER-055THR-1')] =   -4.852  
BIND_BRONZE['%s-%s' % (dbse, '028SER-056GLU-1')] =   -2.630  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-031THR-1')] =    2.195  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-036MET-1')] =    1.406  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-038VAL-1')] =   -0.684  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-058PHE-1')] =   -2.421  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-085GLU-1')] =   -0.349  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-086ASN-1')] =   -0.239  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-105PHE-1')] =   -0.783  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-128PHE-1')] =   -0.358  
BIND_BRONZE['%s-%s' % (dbse, '028VAL-170LEU-1')] =    0.005  
BIND_BRONZE['%s-%s' % (dbse, '029ALA-274ILE-1')] =   -0.695  
BIND_BRONZE['%s-%s' % (dbse, '029ASN-034LYS-2')] =  -26.955  
BIND_BRONZE['%s-%s' % (dbse, '029ASN-179SER-1')] =    0.283  
BIND_BRONZE['%s-%s' % (dbse, '029ASP-070ASP-1')] =   82.138  
BIND_BRONZE['%s-%s' % (dbse, '029GLN-033ASP-1')] =    5.185  
BIND_BRONZE['%s-%s' % (dbse, '029GLU-045LEU-1')] =   -2.300  
BIND_BRONZE['%s-%s' % (dbse, '029GLU-055SER-1')] =  -18.765  
BIND_BRONZE['%s-%s' % (dbse, '029LEU-034VAL-1')] =   -0.555  
BIND_BRONZE['%s-%s' % (dbse, '029LEU-036PHE-2')] =   -2.175  
BIND_BRONZE['%s-%s' % (dbse, '029LEU-040GLU-1')] =   -0.757  
BIND_BRONZE['%s-%s' % (dbse, '029LEU-045GLN-1')] =   -1.216  
BIND_BRONZE['%s-%s' % (dbse, '029LEU-095TYR-1')] =   -1.473  
BIND_BRONZE['%s-%s' % (dbse, '029LYS-035GLU-1')] =   -2.680  
BIND_BRONZE['%s-%s' % (dbse, '029PHE-094LEU-1')] =   -1.018  
BIND_BRONZE['%s-%s' % (dbse, '029PHE-101TRP-1')] =   -1.602  
BIND_BRONZE['%s-%s' % (dbse, '029PHE-103HIE-1')] =   -0.415  
BIND_BRONZE['%s-%s' % (dbse, '029PHE-168TYR-1')] =   -2.196  
BIND_BRONZE['%s-%s' % (dbse, '029PHE-177ILE-1')] =   -1.251  
BIND_BRONZE['%s-%s' % (dbse, '029PRO-085GLU-1')] =  -10.372  
BIND_BRONZE['%s-%s' % (dbse, '029THR-121TYR-1')] =   -1.585  
BIND_BRONZE['%s-%s' % (dbse, '029THR-121TYR-2')] =   -4.579  
BIND_BRONZE['%s-%s' % (dbse, '029TRP-302SER-1')] =   -1.026  
BIND_BRONZE['%s-%s' % (dbse, '029TRP-305ILE-1')] =   -2.674  
BIND_BRONZE['%s-%s' % (dbse, '029TRP-308ASP-1')] =   -8.905  
BIND_BRONZE['%s-%s' % (dbse, '029TRP-315PHE-1')] =   -2.065  
BIND_BRONZE['%s-%s' % (dbse, '029TYR-049GLU-1')] =   -2.355  
BIND_BRONZE['%s-%s' % (dbse, '029VAL-036VAL-1')] =   -0.542  
BIND_BRONZE['%s-%s' % (dbse, '029VAL-054LEU-1')] =   -0.320  
BIND_BRONZE['%s-%s' % (dbse, '029VAL-087LEU-1')] =   -0.077  
BIND_BRONZE['%s-%s' % (dbse, '030ALA-274ILE-1')] =   -0.887  
BIND_BRONZE['%s-%s' % (dbse, '030ASP-320ARG-1')] = -101.046  
BIND_BRONZE['%s-%s' % (dbse, '030GLN-034TRP-1')] =   -1.784  
BIND_BRONZE['%s-%s' % (dbse, '030GLN-034TRP-2')] =   -3.355  
BIND_BRONZE['%s-%s' % (dbse, '030GLN-036MET-1')] =   -2.158  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-033GLN-1')] =  -15.856  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-034ASP-1')] =   67.407  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-038PHE-1')] =   -1.237  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-042PHE-1')] =   -0.953  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-049PHE-1')] =   -5.413  
BIND_BRONZE['%s-%s' % (dbse, '030GLU-061LYS-1')] = -114.802  
BIND_BRONZE['%s-%s' % (dbse, '030ILE-034LEU-1')] =   -0.620  
BIND_BRONZE['%s-%s' % (dbse, '030ILE-055ILE-1')] =    1.191  
BIND_BRONZE['%s-%s' % (dbse, '030ILE-093TYR-1')] =   -1.140  
BIND_BRONZE['%s-%s' % (dbse, '030LEU-034LEU-1')] =   -0.633  
BIND_BRONZE['%s-%s' % (dbse, '030LYS-078TYR-2')] =   -7.271  
BIND_BRONZE['%s-%s' % (dbse, '030LYS-083GLU-1')] = -118.688  
BIND_BRONZE['%s-%s' % (dbse, '030LYS-085GLU-1')] =   -4.614  
BIND_BRONZE['%s-%s' % (dbse, '030LYS-169THR-1')] =  -16.367  
BIND_BRONZE['%s-%s' % (dbse, '030PHE-042LEU-1')] =   -0.861  
BIND_BRONZE['%s-%s' % (dbse, '030PHE-044ILE-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '030PHE-061GLU-2')] =   -1.377  
BIND_BRONZE['%s-%s' % (dbse, '030PHE-151ILE-1')] =   -2.689  
BIND_BRONZE['%s-%s' % (dbse, '030PRO-057MET-1')] =   -0.289  
BIND_BRONZE['%s-%s' % (dbse, '030SER-109GLU-1')] =  -17.718  
BIND_BRONZE['%s-%s' % (dbse, '030THR-121LYS-1')] =    0.864  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-033THR-1')] =   -0.586  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-036PHE-1')] =   -3.351  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-042GLU-1')] =  -20.981  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-046LEU-1')] =   -2.943  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-073PHE-1')] =   -1.173  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-079LEU-1')] =   -0.552  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-103PHE-1')] =   -3.615  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-171THR-1')] =   -0.834  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-176SER-2')] =   -6.034  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-212GLU-1')] =  -18.043  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-213GLU-1')] =   -5.009  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-216SER-1')] =   -1.229  
BIND_BRONZE['%s-%s' % (dbse, '030TRP-217THR-1')] =   -1.119  
BIND_BRONZE['%s-%s' % (dbse, '030VAL-033VAL-1')] =   -0.113  
BIND_BRONZE['%s-%s' % (dbse, '030VAL-044LEU-1')] =   -0.586  
BIND_BRONZE['%s-%s' % (dbse, '030VAL-050ILE-1')] =   -0.852  
BIND_BRONZE['%s-%s' % (dbse, '031ALA-088VAL-1')] =   -0.397  
BIND_BRONZE['%s-%s' % (dbse, '031ASP-034HIE-1')] =   20.773  
BIND_BRONZE['%s-%s' % (dbse, '031HIE-035LEU-1')] =   -0.960  
BIND_BRONZE['%s-%s' % (dbse, '031HIE-037SER-1')] =   -6.192  
BIND_BRONZE['%s-%s' % (dbse, '031HIE-109LEU-1')] =   -0.651  
BIND_BRONZE['%s-%s' % (dbse, '031HIE-125LEU-1')] =   -1.003  
BIND_BRONZE['%s-%s' % (dbse, '031HIE-128GLU-1')] =  -14.915  
BIND_BRONZE['%s-%s' % (dbse, '031ILE-034ILE-1')] =   -0.613  
BIND_BRONZE['%s-%s' % (dbse, '031ILE-097TRP-1')] =   -1.199  
BIND_BRONZE['%s-%s' % (dbse, '031ILE-246ALA-1')] =   -0.209  
BIND_BRONZE['%s-%s' % (dbse, '031LEU-091LEU-1')] =   -0.426  
BIND_BRONZE['%s-%s' % (dbse, '031LEU-125LEU-1')] =   -0.628  
BIND_BRONZE['%s-%s' % (dbse, '031LEU-168LEU-1')] =   -0.710  
BIND_BRONZE['%s-%s' % (dbse, '031LEU-213GLU-1')] =   -2.651  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-060THR-1')] =   -0.839  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-061ILE-1')] =   -1.191  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-062HIE-1')] =   -1.379  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-076ALA-1')] =   -0.593  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-092TRP-2')] =   -2.925  
BIND_BRONZE['%s-%s' % (dbse, '031PHE-095TYR-1')] =   -2.508  
BIND_BRONZE['%s-%s' % (dbse, '031PRO-097VAL-1')] =   -0.453  
BIND_BRONZE['%s-%s' % (dbse, '031THR-085GLU-1')] =  -17.088  
BIND_BRONZE['%s-%s' % (dbse, '031THR-128PHE-1')] =   -1.676  
BIND_BRONZE['%s-%s' % (dbse, '031TRP-060ASP-1')] =  -23.633  
BIND_BRONZE['%s-%s' % (dbse, '031TRP-164VAL-1')] =   -1.936  
BIND_BRONZE['%s-%s' % (dbse, '031TRP-168GLN-1')] =   -2.499  
BIND_BRONZE['%s-%s' % (dbse, '031TRP-168GLN-2')] =   -3.304  
BIND_BRONZE['%s-%s' % (dbse, '031TRP-171ALA-1')] =   -1.384  
BIND_BRONZE['%s-%s' % (dbse, '031TYR-037PHE-2')] =   -3.028  
BIND_BRONZE['%s-%s' % (dbse, '031TYR-048HIE-1')] =   -2.349  
BIND_BRONZE['%s-%s' % (dbse, '031TYR-051GLN-1')] =   -2.375  
BIND_BRONZE['%s-%s' % (dbse, '031VAL-056PHE-1')] =   -0.923  
BIND_BRONZE['%s-%s' % (dbse, '031VAL-068LEU-1')] =   -1.018  
BIND_BRONZE['%s-%s' % (dbse, '031VAL-071VAL-1')] =   -0.703  
BIND_BRONZE['%s-%s' % (dbse, '031VAL-073VAL-1')] =   -0.621  
BIND_BRONZE['%s-%s' % (dbse, '031VAL-077ILE-1')] =   -1.169  
BIND_BRONZE['%s-%s' % (dbse, '032ASP-040HIE-1')] =   -3.570  
BIND_BRONZE['%s-%s' % (dbse, '032GLN-116ASP-1')] =  -21.155  
BIND_BRONZE['%s-%s' % (dbse, '032GLU-035ARG-1')] = -114.790  
BIND_BRONZE['%s-%s' % (dbse, '032GLU-169THR-1')] =   -3.345  
BIND_BRONZE['%s-%s' % (dbse, '032GLU-169THR-2')] =  -17.007  
BIND_BRONZE['%s-%s' % (dbse, '032ILE-036GLU-1')] =   -0.844  
BIND_BRONZE['%s-%s' % (dbse, '032ILE-065LEU-1')] =    0.719  
BIND_BRONZE['%s-%s' % (dbse, '032LYS-080GLU-2')] = -107.260  
BIND_BRONZE['%s-%s' % (dbse, '032LYS-083LEU-1')] =   -0.956  
BIND_BRONZE['%s-%s' % (dbse, '032LYS-091LEU-1')] =   -2.656  
BIND_BRONZE['%s-%s' % (dbse, '032LYS-091LEU-2')] =   -0.649  
BIND_BRONZE['%s-%s' % (dbse, '032PHE-058ASP-1')] =   -2.288  
BIND_BRONZE['%s-%s' % (dbse, '032PHE-081VAL-1')] =   -0.912  
BIND_BRONZE['%s-%s' % (dbse, '032PHE-095LEU-1')] =   -2.091  
BIND_BRONZE['%s-%s' % (dbse, '032SER-057GLU-1')] =  -16.065  
BIND_BRONZE['%s-%s' % (dbse, '032THR-093LYS-1')] =   -0.746  
BIND_BRONZE['%s-%s' % (dbse, '032THR-094LEU-1')] =   -0.969  
BIND_BRONZE['%s-%s' % (dbse, '032THR-128LEU-1')] =   -0.411  
BIND_BRONZE['%s-%s' % (dbse, '032TRP-062ALA-1')] =   -1.845  
BIND_BRONZE['%s-%s' % (dbse, '032TRP-073PHE-1')] =   -3.055  
BIND_BRONZE['%s-%s' % (dbse, '032TRP-074VAL-1')] =   -0.959  
BIND_BRONZE['%s-%s' % (dbse, '032TRP-083ASN-1')] =   -7.679  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-042ILE-1')] =    0.371  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-052VAL-1')] =   -1.256  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-056HIE-1')] =   -0.887  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-068LEU-1')] =   -0.521  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-080ARG-1')] =    0.204  
BIND_BRONZE['%s-%s' % (dbse, '032VAL-100VAL-1')] =   -0.329  
BIND_BRONZE['%s-%s' % (dbse, '033ARG-189PRO-1')] =   -2.168  
BIND_BRONZE['%s-%s' % (dbse, '033ARG-191LEU-1')] =   -0.833  
BIND_BRONZE['%s-%s' % (dbse, '033ARG-191LEU-2')] =   -2.302  
BIND_BRONZE['%s-%s' % (dbse, '033ASP-276SER-1')] =  -17.567  
BIND_BRONZE['%s-%s' % (dbse, '033ASP-279LYS-1')] = -121.660  
BIND_BRONZE['%s-%s' % (dbse, '033ASP-279LYS-2')] =   -3.704  
BIND_BRONZE['%s-%s' % (dbse, '033CYS-047TYR-1')] =   -3.439  
BIND_BRONZE['%s-%s' % (dbse, '033GLN-092ASN-2')] =   -7.859  
BIND_BRONZE['%s-%s' % (dbse, '033GLU-036ARG-1')] = -116.640  
BIND_BRONZE['%s-%s' % (dbse, '033HIE-060MET-2')] =   -2.358  
BIND_BRONZE['%s-%s' % (dbse, '033HIE-062THR-1')] =    4.336  
BIND_BRONZE['%s-%s' % (dbse, '033ILE-037ASP-1')] =   -1.955  
BIND_BRONZE['%s-%s' % (dbse, '033ILE-061VAL-1')] =   -0.680  
BIND_BRONZE['%s-%s' % (dbse, '033LEU-053VAL-1')] =   -0.804  
BIND_BRONZE['%s-%s' % (dbse, '033LEU-059ILE-1')] =   -0.890  
BIND_BRONZE['%s-%s' % (dbse, '033LEU-061PRO-1')] =   -1.020  
BIND_BRONZE['%s-%s' % (dbse, '033LEU-089ILE-1')] =   -0.757  
BIND_BRONZE['%s-%s' % (dbse, '033PHE-058PHE-1')] =   -1.121  
BIND_BRONZE['%s-%s' % (dbse, '033THR-100GLN-1')] =    0.037  
BIND_BRONZE['%s-%s' % (dbse, '033TYR-062HIE-1')] =   -2.023  
BIND_BRONZE['%s-%s' % (dbse, '033TYR-091ASN-1')] =   -8.236  
BIND_BRONZE['%s-%s' % (dbse, '033TYR-094ILE-1')] =   -1.786  
BIND_BRONZE['%s-%s' % (dbse, '033TYR-094ILE-2')] =   -1.417  
BIND_BRONZE['%s-%s' % (dbse, '033VAL-048ILE-1')] =   -0.868  
BIND_BRONZE['%s-%s' % (dbse, '033VAL-055VAL-1')] =   -0.366  
BIND_BRONZE['%s-%s' % (dbse, '033VAL-091ASN-1')] =   -0.632  
BIND_BRONZE['%s-%s' % (dbse, '034ALA-133LYS-1')] =   -0.931  
BIND_BRONZE['%s-%s' % (dbse, '034ALA-152GLU-1')] =   -4.051  
BIND_BRONZE['%s-%s' % (dbse, '034ARG-060TYR-1')] =  -15.945  
BIND_BRONZE['%s-%s' % (dbse, '034ARG-064LEU-1')] =   -1.855  
BIND_BRONZE['%s-%s' % (dbse, '034ASN-076SER-1')] =   -1.601  
BIND_BRONZE['%s-%s' % (dbse, '034ASN-078TYR-1')] =   -0.165  
BIND_BRONZE['%s-%s' % (dbse, '034ASP-037PHE-1')] =   -1.945  
BIND_BRONZE['%s-%s' % (dbse, '034ASP-061ARG-1')] =  -81.691  
BIND_BRONZE['%s-%s' % (dbse, '034HIE-057HIE-1')] =   -1.208  
BIND_BRONZE['%s-%s' % (dbse, '034ILE-037TYR-1')] =   -1.453  
BIND_BRONZE['%s-%s' % (dbse, '034LEU-038TYR-1')] =   -1.276  
BIND_BRONZE['%s-%s' % (dbse, '034LEU-044TRP-1')] =   -1.525  
BIND_BRONZE['%s-%s' % (dbse, '034LYS-068GLU-1')] = -108.275  
BIND_BRONZE['%s-%s' % (dbse, '034LYS-070TRP-1')] =   -1.095  
BIND_BRONZE['%s-%s' % (dbse, '034LYS-070TRP-2')] =   -1.079  
BIND_BRONZE['%s-%s' % (dbse, '034LYS-086TYR-1')] =   -1.656  
BIND_BRONZE['%s-%s' % (dbse, '034LYS-086TYR-2')] =   -6.814  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-045TRP-1')] =   -4.860  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-058CYS-1')] =   -2.012  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-062HIE-1')] =   -0.935  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-069MET-1')] =   -2.319  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-072LEU-1')] =   -0.975  
BIND_BRONZE['%s-%s' % (dbse, '034PHE-100VAL-2')] =   -2.473  
BIND_BRONZE['%s-%s' % (dbse, '034PRO-065ALA-1')] =   -0.862  
BIND_BRONZE['%s-%s' % (dbse, '034PRO-075PRO-1')] =   -1.448  
BIND_BRONZE['%s-%s' % (dbse, '034SER-105LEU-1')] =   -1.552  
BIND_BRONZE['%s-%s' % (dbse, '034TRP-037TRP-1')] =   -3.049  
BIND_BRONZE['%s-%s' % (dbse, '034TYR-136ALA-1')] =   -1.233  
BIND_BRONZE['%s-%s' % (dbse, '034TYR-143MET-1')] =   -3.128  
BIND_BRONZE['%s-%s' % (dbse, '034TYR-148VAL-1')] =   -0.664  
BIND_BRONZE['%s-%s' % (dbse, '034TYR-277TYR-1')] =    0.585  
BIND_BRONZE['%s-%s' % (dbse, '034VAL-046LEU-1')] =   -0.486  
BIND_BRONZE['%s-%s' % (dbse, '034VAL-048PHE-1')] =   -0.757  
BIND_BRONZE['%s-%s' % (dbse, '034VAL-072VAL-1')] =   -0.465  
BIND_BRONZE['%s-%s' % (dbse, '034VAL-077LEU-1')] =   -0.346  
BIND_BRONZE['%s-%s' % (dbse, '034VAL-111LEU-1')] =   -0.983  
BIND_BRONZE['%s-%s' % (dbse, '035ALA-065LEU-1')] =   -0.872  
BIND_BRONZE['%s-%s' % (dbse, '035ALA-067ARG-1')] =    0.239  
BIND_BRONZE['%s-%s' % (dbse, '035ARG-041THR-1')] =  -13.394  
BIND_BRONZE['%s-%s' % (dbse, '035ARG-042VAL-1')] =   -0.828  
BIND_BRONZE['%s-%s' % (dbse, '035ASN-172GLU-1')] =  -10.547  
BIND_BRONZE['%s-%s' % (dbse, '035ASN-174TYR-1')] =   -1.208  
BIND_BRONZE['%s-%s' % (dbse, '035ASP-046ARG-1')] =  -98.571  
BIND_BRONZE['%s-%s' % (dbse, '035CYS-038CYS-1')] =    2.061  
BIND_BRONZE['%s-%s' % (dbse, '035CYS-154THR-1')] =   -2.817  
BIND_BRONZE['%s-%s' % (dbse, '035GLU-189PRO-1')] =   -0.486  
BIND_BRONZE['%s-%s' % (dbse, '035HIE-059ARG-1')] =   -1.132  
BIND_BRONZE['%s-%s' % (dbse, '035HIE-059ARG-2')] =   -5.933  
BIND_BRONZE['%s-%s' % (dbse, '035HIE-061ARG-1')] =   -2.347  
BIND_BRONZE['%s-%s' % (dbse, '035LEU-061PRO-1')] =   -0.852  
BIND_BRONZE['%s-%s' % (dbse, '035LEU-085LEU-1')] =   -0.508  
BIND_BRONZE['%s-%s' % (dbse, '035LYS-083TYR-1')] =   -4.345  
BIND_BRONZE['%s-%s' % (dbse, '035LYS-090GLU-1')] =   -5.932  
BIND_BRONZE['%s-%s' % (dbse, '035PHE-047TYR-1')] =   -2.457  
BIND_BRONZE['%s-%s' % (dbse, '035PHE-062THR-1')] =   -2.941  
BIND_BRONZE['%s-%s' % (dbse, '035PHE-097LEU-1')] =   -1.440  
BIND_BRONZE['%s-%s' % (dbse, '035PHE-111PHE-1')] =   -2.268  
BIND_BRONZE['%s-%s' % (dbse, '035PHE-128PHE-1')] =   -2.665  
BIND_BRONZE['%s-%s' % (dbse, '035THR-112LYS-1')] =   -1.776  
BIND_BRONZE['%s-%s' % (dbse, '035TRP-045HIE-1')] =   -0.291  
BIND_BRONZE['%s-%s' % (dbse, '035TRP-058PHE-1')] =   -4.202  
BIND_BRONZE['%s-%s' % (dbse, '035TRP-064ARG-1')] =   -0.914  
BIND_BRONZE['%s-%s' % (dbse, '035TRP-157VAL-1')] =   -0.540  
BIND_BRONZE['%s-%s' % (dbse, '035TRP-161LYS-1')] =  -16.697  
BIND_BRONZE['%s-%s' % (dbse, '036ARG-042GLU-1')] = -109.531  
BIND_BRONZE['%s-%s' % (dbse, '036ARG-162GLN-1')] =  -18.706  
BIND_BRONZE['%s-%s' % (dbse, '036CYS-039CYS-1')] =    0.072  
BIND_BRONZE['%s-%s' % (dbse, '036GLN-040HIE-1')] =   -2.189  
BIND_BRONZE['%s-%s' % (dbse, '036GLN-105LEU-1')] =   -0.585  
BIND_BRONZE['%s-%s' % (dbse, '036GLU-039ARG-1')] = -118.547  
BIND_BRONZE['%s-%s' % (dbse, '036GLU-039LYS-1')] = -113.499  
BIND_BRONZE['%s-%s' % (dbse, '036GLU-045LEU-1')] =   -1.204  
BIND_BRONZE['%s-%s' % (dbse, '036GLU-053VAL-1')] =   -1.642  
BIND_BRONZE['%s-%s' % (dbse, '036GLU-056ARG-1')] =  -81.413  
BIND_BRONZE['%s-%s' % (dbse, '036HIE-063LEU-1')] =   -1.838  
BIND_BRONZE['%s-%s' % (dbse, '036ILE-040THR-1')] =   -1.820  
BIND_BRONZE['%s-%s' % (dbse, '036ILE-061ILE-1')] =   -0.831  
BIND_BRONZE['%s-%s' % (dbse, '036ILE-063TRP-1')] =   -0.795  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-039MET-1')] =   -0.994  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-041ILE-1')] =   -0.451  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-046PHE-1')] =   -0.528  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-046PHE-2')] =   -0.732  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-047TYR-1')] =   -2.051  
BIND_BRONZE['%s-%s' % (dbse, '036LEU-098ILE-1')] =   -0.627  
BIND_BRONZE['%s-%s' % (dbse, '036MET-049LEU-1')] =   -0.150  
BIND_BRONZE['%s-%s' % (dbse, '036MET-054VAL-1')] =    3.046  
BIND_BRONZE['%s-%s' % (dbse, '036PHE-075SER-2')] =   -2.245  
BIND_BRONZE['%s-%s' % (dbse, '036PHE-113ASP-1')] =   -5.181  
BIND_BRONZE['%s-%s' % (dbse, '036PHE-303TRP-1')] =   -1.815  
BIND_BRONZE['%s-%s' % (dbse, '036SER-069THR-1')] =   -0.180  
BIND_BRONZE['%s-%s' % (dbse, '036THR-090GLU-1')] =  -19.293  
BIND_BRONZE['%s-%s' % (dbse, '036THR-104MET-1')] =   -0.977  
BIND_BRONZE['%s-%s' % (dbse, '036THR-133PHE-1')] =   -1.597  
BIND_BRONZE['%s-%s' % (dbse, '036TRP-047PHE-1')] =   -1.164  
BIND_BRONZE['%s-%s' % (dbse, '036TRP-049PRO-1')] =   -2.095  
BIND_BRONZE['%s-%s' % (dbse, '036VAL-060TYR-1')] =   -0.490  
BIND_BRONZE['%s-%s' % (dbse, '036VAL-070TRP-1')] =   -2.319  
BIND_BRONZE['%s-%s' % (dbse, '036VAL-086TYR-1')] =   -0.904  
BIND_BRONZE['%s-%s' % (dbse, '037ALA-056ILE-1')] =   -0.455  
BIND_BRONZE['%s-%s' % (dbse, '037ARG-152GLU-1')] = -118.966  
BIND_BRONZE['%s-%s' % (dbse, '037ASN-040THR-1')] =    3.205  
BIND_BRONZE['%s-%s' % (dbse, '037ASN-067GLU-1')] =   -5.863  
BIND_BRONZE['%s-%s' % (dbse, '037ASP-040ARG-1')] =  -79.389  
BIND_BRONZE['%s-%s' % (dbse, '037ASP-064TYR-1')] =  -18.604  
BIND_BRONZE['%s-%s' % (dbse, '037HIE-050GLU-1')] =  -24.428  
BIND_BRONZE['%s-%s' % (dbse, '037ILE-116PHE-1')] =   -0.830  
BIND_BRONZE['%s-%s' % (dbse, '037ILE-125LEU-1')] =   -0.899  
BIND_BRONZE['%s-%s' % (dbse, '037ILE-162PRO-1')] =   -0.681  
BIND_BRONZE['%s-%s' % (dbse, '037ILE-165VAL-1')] =   -0.424  
BIND_BRONZE['%s-%s' % (dbse, '037LYS-162PHE-1')] =   -1.055  
BIND_BRONZE['%s-%s' % (dbse, '037PHE-048HIE-1')] =   -1.837  
BIND_BRONZE['%s-%s' % (dbse, '037SER-043ASP-1')] =   -6.230  
BIND_BRONZE['%s-%s' % (dbse, '037THR-053ILE-1')] =    0.620  
BIND_BRONZE['%s-%s' % (dbse, '037THR-085LYS-2')] =    0.661  
BIND_BRONZE['%s-%s' % (dbse, '037TRP-050ALA-1')] =   -2.598  
BIND_BRONZE['%s-%s' % (dbse, '037TRP-053LEU-1')] =   -1.322  
BIND_BRONZE['%s-%s' % (dbse, '037TRP-055LYS-1')] =  -15.273  
BIND_BRONZE['%s-%s' % (dbse, '037TRP-055LYS-2')] =   -0.934  
BIND_BRONZE['%s-%s' % (dbse, '037TYR-046THR-1')] =   -1.084  
BIND_BRONZE['%s-%s' % (dbse, '037TYR-050LYS-1')] =   -2.848  
BIND_BRONZE['%s-%s' % (dbse, '037TYR-066LEU-1')] =   -1.121  
BIND_BRONZE['%s-%s' % (dbse, '037TYR-068VAL-1')] =   -1.030  
BIND_BRONZE['%s-%s' % (dbse, '038ASN-199LEU-1')] =   -0.487  
BIND_BRONZE['%s-%s' % (dbse, '038ASN-202PHE-1')] =   -3.134  
BIND_BRONZE['%s-%s' % (dbse, '038CYS-095PHE-1')] =   -1.299  
BIND_BRONZE['%s-%s' % (dbse, '038GLN-042ASP-1')] =  -21.537  
BIND_BRONZE['%s-%s' % (dbse, '038ILE-085ARG-1')] =   -0.634  
BIND_BRONZE['%s-%s' % (dbse, '038ILE-094LYS-1')] =    0.032  
BIND_BRONZE['%s-%s' % (dbse, '038LEU-045PHE-1')] =   -0.854  
BIND_BRONZE['%s-%s' % (dbse, '038LEU-047TYR-2')] =   -1.582  
BIND_BRONZE['%s-%s' % (dbse, '038LEU-054LEU-1')] =   -0.561  
BIND_BRONZE['%s-%s' % (dbse, '038LEU-109SER-1')] =   -0.690  
BIND_BRONZE['%s-%s' % (dbse, '038LEU-109VAL-1')] =   -0.231  
BIND_BRONZE['%s-%s' % (dbse, '038LYS-047PHE-1')] =   -2.326  
BIND_BRONZE['%s-%s' % (dbse, '038MET-041LEU-1')] =   -0.519  
BIND_BRONZE['%s-%s' % (dbse, '038MET-146PHE-1')] =   -2.597  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-042PHE-1')] =   -3.239  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-042VAL-1')] =   -2.079  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-046ARG-1')] =   -2.292  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-049PHE-1')] =   -1.568  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-061VAL-1')] =   -1.793  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-061VAL-2')] =   -1.300  
BIND_BRONZE['%s-%s' % (dbse, '038PHE-101PRO-1')] =   -1.085  
BIND_BRONZE['%s-%s' % (dbse, '038PRO-108ARG-1')] =   -1.889  
BIND_BRONZE['%s-%s' % (dbse, '038THR-053PHE-1')] =   -0.917  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-063TRP-1')] =   -4.744  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-065PRO-1')] =   -2.857  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-068TYR-1')] =   -2.289  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-073ILE-1')] =   -1.592  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-078ALA-1')] =   -0.926  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-081TYR-1')] =   -2.884  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-082ILE-1')] =   -1.411  
BIND_BRONZE['%s-%s' % (dbse, '038TRP-132ILE-1')] =   -1.249  
BIND_BRONZE['%s-%s' % (dbse, '038TYR-060TYR-1')] =   -2.849  
BIND_BRONZE['%s-%s' % (dbse, '038VAL-041VAL-1')] =   -0.258  
BIND_BRONZE['%s-%s' % (dbse, '038VAL-072PHE-1')] =   -1.814  
BIND_BRONZE['%s-%s' % (dbse, '038VAL-082PHE-1')] =   -0.848  
BIND_BRONZE['%s-%s' % (dbse, '038VAL-083ILE-1')] =   -0.241  
BIND_BRONZE['%s-%s' % (dbse, '039ALA-095PHE-1')] =   -2.320  
BIND_BRONZE['%s-%s' % (dbse, '039ARG-043ASN-2')] =    5.130  
BIND_BRONZE['%s-%s' % (dbse, '039ASN-042ARG-1')] =  -21.815  
BIND_BRONZE['%s-%s' % (dbse, '039ASN-081SER-1')] =   -1.688  
BIND_BRONZE['%s-%s' % (dbse, '039ASN-083TYR-1')] =   -0.997  
BIND_BRONZE['%s-%s' % (dbse, '039ASP-057THR-1')] =  -17.167  
BIND_BRONZE['%s-%s' % (dbse, '039GLN-047ARG-1')] =  -16.054  
BIND_BRONZE['%s-%s' % (dbse, '039HIE-057HIE-1')] =    8.890  
BIND_BRONZE['%s-%s' % (dbse, '039ILE-054LEU-1')] =   -1.062  
BIND_BRONZE['%s-%s' % (dbse, '039ILE-055TYR-1')] =   -1.121  
BIND_BRONZE['%s-%s' % (dbse, '039ILE-108ILE-1')] =   -0.882  
BIND_BRONZE['%s-%s' % (dbse, '039ILE-109CYS-1')] =    2.143  
BIND_BRONZE['%s-%s' % (dbse, '039LYS-043HIE-1')] =   -1.088  
BIND_BRONZE['%s-%s' % (dbse, '039PRO-165PHE-1')] =   -2.293  
BIND_BRONZE['%s-%s' % (dbse, '039PRO-166ILE-1')] =   -0.644  
BIND_BRONZE['%s-%s' % (dbse, '039PRO-199LEU-1')] =   -0.324  
BIND_BRONZE['%s-%s' % (dbse, '039SER-054GLU-1')] =  -17.680  
BIND_BRONZE['%s-%s' % (dbse, '039SER-067GLU-1')] =  -18.992  
BIND_BRONZE['%s-%s' % (dbse, '039THR-046THR-1')] =   -5.367  
BIND_BRONZE['%s-%s' % (dbse, '039THR-077LEU-1')] =   -0.339  
BIND_BRONZE['%s-%s' % (dbse, '039THR-079LEU-1')] =   -0.866  
BIND_BRONZE['%s-%s' % (dbse, '039THR-083VAL-1')] =   -0.376  
BIND_BRONZE['%s-%s' % (dbse, '039TRP-052SER-1')] =   -3.965  
BIND_BRONZE['%s-%s' % (dbse, '039TRP-064VAL-1')] =   -1.204  
BIND_BRONZE['%s-%s' % (dbse, '039TRP-066LEU-1')] =   -1.989  
BIND_BRONZE['%s-%s' % (dbse, '039TRP-066LEU-2')] =   -2.265  
BIND_BRONZE['%s-%s' % (dbse, '039TYR-043ILE-1')] =    0.883  
BIND_BRONZE['%s-%s' % (dbse, '039VAL-083TYR-1')] =   -2.059  
BIND_BRONZE['%s-%s' % (dbse, '040ASN-073PHE-1')] =   -1.855  
BIND_BRONZE['%s-%s' % (dbse, '040ASN-077TYR-1')] =   -2.449  
BIND_BRONZE['%s-%s' % (dbse, '040ASN-090ARG-1')] =  -10.337  
BIND_BRONZE['%s-%s' % (dbse, '040ASP-065THR-1')] =    2.220  
BIND_BRONZE['%s-%s' % (dbse, '040GLU-045GLN-1')] =  -18.722  
BIND_BRONZE['%s-%s' % (dbse, '040HIE-103HIE-1')] =  -10.498  
BIND_BRONZE['%s-%s' % (dbse, '040HIE-105LEU-1')] =   -2.007  
BIND_BRONZE['%s-%s' % (dbse, '040ILE-054VAL-1')] =   -0.466  
BIND_BRONZE['%s-%s' % (dbse, '040ILE-057LYS-1')] =   -0.667  
BIND_BRONZE['%s-%s' % (dbse, '040LEU-063TYR-1')] =   -1.079  
BIND_BRONZE['%s-%s' % (dbse, '040MET-085ARG-1')] =    0.660  
BIND_BRONZE['%s-%s' % (dbse, '040PHE-052TYR-1')] =   -2.433  
BIND_BRONZE['%s-%s' % (dbse, '040PHE-116PHE-1')] =   -2.290  
BIND_BRONZE['%s-%s' % (dbse, '040PHE-133PHE-1')] =   -2.859  
BIND_BRONZE['%s-%s' % (dbse, '040THR-044TRP-1')] =   -1.412  
BIND_BRONZE['%s-%s' % (dbse, '040THR-048VAL-1')] =   -0.830  
BIND_BRONZE['%s-%s' % (dbse, '040THR-162GLN-1')] =   -0.701  
BIND_BRONZE['%s-%s' % (dbse, '040THR-186TYR-1')] =   -1.618  
BIND_BRONZE['%s-%s' % (dbse, '040THR-270TYR-1')] =   -0.712  
BIND_BRONZE['%s-%s' % (dbse, '040TRP-052GLN-1')] =   -3.401  
BIND_BRONZE['%s-%s' % (dbse, '040TRP-055LEU-1')] =   -0.721  
BIND_BRONZE['%s-%s' % (dbse, '040TRP-121ILE-1')] =   -2.354  
BIND_BRONZE['%s-%s' % (dbse, '040TRP-121ILE-2')] =   -0.625  
BIND_BRONZE['%s-%s' % (dbse, '040TRP-122THR-1')] =   -3.445  
BIND_BRONZE['%s-%s' % (dbse, '040TYR-045TYR-1')] =   -3.708  
BIND_BRONZE['%s-%s' % (dbse, '040TYR-055VAL-1')] =   -1.051  
BIND_BRONZE['%s-%s' % (dbse, '040TYR-076VAL-1')] =   -1.243  
BIND_BRONZE['%s-%s' % (dbse, '040TYR-079ILE-1')] =   -1.623  
BIND_BRONZE['%s-%s' % (dbse, '040TYR-082PHE-1')] =   -1.199  
BIND_BRONZE['%s-%s' % (dbse, '040VAL-063VAL-1')] =   -0.397  
BIND_BRONZE['%s-%s' % (dbse, '041ALA-047TRP-1')] =   -2.469  
BIND_BRONZE['%s-%s' % (dbse, '041ALA-081GLU-1')] =   -1.015  
BIND_BRONZE['%s-%s' % (dbse, '041ALA-121ALA-1')] =   -0.401  
BIND_BRONZE['%s-%s' % (dbse, '041ARG-051PHE-1')] =   -2.692  
BIND_BRONZE['%s-%s' % (dbse, '041ASP-084ARG-1')] =  -92.584  
BIND_BRONZE['%s-%s' % (dbse, '041GLU-045LYS-1')] = -107.522  
BIND_BRONZE['%s-%s' % (dbse, '041ILE-058ARG-1')] =    0.035  
BIND_BRONZE['%s-%s' % (dbse, '041ILE-061PHE-1')] =   -0.774  
BIND_BRONZE['%s-%s' % (dbse, '041ILE-107PHE-1')] =   -1.524  
BIND_BRONZE['%s-%s' % (dbse, '041ILE-107PHE-2')] =   -1.421  
BIND_BRONZE['%s-%s' % (dbse, '041LEU-146PHE-1')] =   -0.693  
BIND_BRONZE['%s-%s' % (dbse, '041LEU-155PRO-1')] =   -0.912  
BIND_BRONZE['%s-%s' % (dbse, '041LEU-162PHE-1')] =   -2.045  
BIND_BRONZE['%s-%s' % (dbse, '041LEU-170TRP-1')] =   -1.707  
BIND_BRONZE['%s-%s' % (dbse, '041LYS-045GLN-1')] =   -1.462  
BIND_BRONZE['%s-%s' % (dbse, '041LYS-107PHE-2')] =   -2.492  
BIND_BRONZE['%s-%s' % (dbse, '041LYS-110SER-1')] =  -19.310  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-047SER-1')] =   -1.687  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-054HIE-1')] =   -3.617  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-073ALA-1')] =   -0.692  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-077LEU-1')] =   -0.933  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-094LYS-1')] =   -6.745  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-094LYS-2')] =   -2.349  
BIND_BRONZE['%s-%s' % (dbse, '041PHE-104VAL-2')] =   -1.861  
BIND_BRONZE['%s-%s' % (dbse, '041VAL-059LEU-1')] =   -0.785  
BIND_BRONZE['%s-%s' % (dbse, '041VAL-064LYS-1')] =   -0.281  
BIND_BRONZE['%s-%s' % (dbse, '042ALA-082ILE-1')] =   -0.243  
BIND_BRONZE['%s-%s' % (dbse, '042ASP-045THR-1')] =  -19.469  
BIND_BRONZE['%s-%s' % (dbse, '042GLU-095PHE-1')] =   -5.218  
BIND_BRONZE['%s-%s' % (dbse, '042GLU-101PRO-1')] =   -4.274  
BIND_BRONZE['%s-%s' % (dbse, '042GLU-103PHE-1')] =   -6.671  
BIND_BRONZE['%s-%s' % (dbse, '042GLU-121ALA-1')] =   -2.862  
BIND_BRONZE['%s-%s' % (dbse, '042ILE-049PHE-1')] =   -0.948  
BIND_BRONZE['%s-%s' % (dbse, '042ILE-052PRO-1')] =   -0.619  
BIND_BRONZE['%s-%s' % (dbse, '042ILE-056PHE-1')] =   -1.925  
BIND_BRONZE['%s-%s' % (dbse, '042LEU-047ILE-1')] =   -0.503  
BIND_BRONZE['%s-%s' % (dbse, '042LEU-048ILE-1')] =   -1.084  
BIND_BRONZE['%s-%s' % (dbse, '042LEU-048VAL-1')] =   -0.928  
BIND_BRONZE['%s-%s' % (dbse, '042LEU-103HIE-1')] =   -0.800  
BIND_BRONZE['%s-%s' % (dbse, '042LEU-105LEU-1')] =   -0.529  
BIND_BRONZE['%s-%s' % (dbse, '042LYS-049GLU-1')] = -123.080  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-049PHE-1')] =   -1.346  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-054PHE-1')] =   -2.236  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-056SER-1')] =   -1.142  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-061LEU-1')] =   -0.676  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-064LYS-1')] =   -1.283  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-074LEU-1')] =   -2.241  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-077PHE-1')] =   -1.753  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-085PHE-1')] =   -1.730  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-087LEU-1')] =   -1.254  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-088ASP-1')] =   -4.702  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-089ALA-1')] =   -1.242  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-089MET-1')] =   -1.935  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-092TYR-1')] =   -2.801  
BIND_BRONZE['%s-%s' % (dbse, '042PHE-101VAL-1')] =   -1.011  
BIND_BRONZE['%s-%s' % (dbse, '042SER-058ILE-1')] =   -1.247  
BIND_BRONZE['%s-%s' % (dbse, '042SER-062ASP-1')] =    4.060  
BIND_BRONZE['%s-%s' % (dbse, '042THR-052ASN-1')] =   -4.634  
BIND_BRONZE['%s-%s' % (dbse, '042TRP-049ARG-1')] =  -12.522  
BIND_BRONZE['%s-%s' % (dbse, '043ALA-073PHE-1')] =   -0.546  
BIND_BRONZE['%s-%s' % (dbse, '043ALA-077TYR-1')] =   -1.335  
BIND_BRONZE['%s-%s' % (dbse, '043ASP-054HIE-1')] =  -25.571  
BIND_BRONZE['%s-%s' % (dbse, '043ASP-058ARG-1')] = -119.286  
BIND_BRONZE['%s-%s' % (dbse, '043ASP-062TYR-1')] =   -2.107  
BIND_BRONZE['%s-%s' % (dbse, '043GLU-104ALA-1')] =   -2.190  
BIND_BRONZE['%s-%s' % (dbse, '043ILE-055LEU-1')] =   -0.021  
BIND_BRONZE['%s-%s' % (dbse, '043LEU-050PHE-1')] =   -0.848  
BIND_BRONZE['%s-%s' % (dbse, '043LEU-055THR-1')] =   -0.559  
BIND_BRONZE['%s-%s' % (dbse, '043LEU-071PHE-1')] =   -0.859  
BIND_BRONZE['%s-%s' % (dbse, '043LEU-114SER-1')] =   -0.547  
BIND_BRONZE['%s-%s' % (dbse, '043LEU-161TYR-1')] =   -2.145  
BIND_BRONZE['%s-%s' % (dbse, '043MET-048ILE-1')] =   -0.520  
BIND_BRONZE['%s-%s' % (dbse, '043MET-060VAL-1')] =   -0.715  
BIND_BRONZE['%s-%s' % (dbse, '043PHE-065PHE-1')] =   -1.755  
BIND_BRONZE['%s-%s' % (dbse, '043PHE-068TRP-1')] =   -2.099  
BIND_BRONZE['%s-%s' % (dbse, '043PHE-073PHE-1')] =   -1.477  
BIND_BRONZE['%s-%s' % (dbse, '043THR-059LEU-1')] =   -0.508  
BIND_BRONZE['%s-%s' % (dbse, '043TYR-048GLN-1')] =   -2.622  
BIND_BRONZE['%s-%s' % (dbse, '043TYR-049THR-1')] =   -1.228  
BIND_BRONZE['%s-%s' % (dbse, '043TYR-068LYS-1')] =   -2.299  
BIND_BRONZE['%s-%s' % (dbse, '043TYR-185HIE-1')] =   -3.700  
BIND_BRONZE['%s-%s' % (dbse, '043TYR-186TYR-1')] =   -2.525  
BIND_BRONZE['%s-%s' % (dbse, '043VAL-066LEU-1')] =   -0.325  
BIND_BRONZE['%s-%s' % (dbse, '043VAL-069VAL-1')] =   -0.714  
BIND_BRONZE['%s-%s' % (dbse, '044ALA-052ASP-1')] =   -1.094  
BIND_BRONZE['%s-%s' % (dbse, '044ASN-048THR-2')] =   -5.716  
BIND_BRONZE['%s-%s' % (dbse, '044ASN-059THR-1')] =   -4.271  
BIND_BRONZE['%s-%s' % (dbse, '044GLN-061LYS-2')] =  -28.023  
BIND_BRONZE['%s-%s' % (dbse, '044GLU-084ARG-1')] =  -94.889  
BIND_BRONZE['%s-%s' % (dbse, '044HIE-067HIE-1')] =   -2.967  
BIND_BRONZE['%s-%s' % (dbse, '044HIE-073TRP-1')] =   -2.634  
BIND_BRONZE['%s-%s' % (dbse, '044HIE-086GLU-1')] =  -25.814  
BIND_BRONZE['%s-%s' % (dbse, '044ILE-101HIE-1')] =   -0.521  
BIND_BRONZE['%s-%s' % (dbse, '044LEU-079VAL-1')] =   -0.457  
BIND_BRONZE['%s-%s' % (dbse, '044LEU-101ILE-1')] =   -0.547  
BIND_BRONZE['%s-%s' % (dbse, '044LEU-272GLN-1')] =   -2.056  
BIND_BRONZE['%s-%s' % (dbse, '044LEU-272GLN-2')] =   -1.003  
BIND_BRONZE['%s-%s' % (dbse, '044MET-061VAL-1')] =   -0.706  
BIND_BRONZE['%s-%s' % (dbse, '044PHE-048LEU-1')] =   -1.258  
BIND_BRONZE['%s-%s' % (dbse, '044PHE-130VAL-1')] =   -3.152  
BIND_BRONZE['%s-%s' % (dbse, '044PRO-053ASP-1')] =   -3.726  
BIND_BRONZE['%s-%s' % (dbse, '044SER-093ARG-1')] =  -14.426  
BIND_BRONZE['%s-%s' % (dbse, '044SER-118ARG-2')] =  -10.799  
BIND_BRONZE['%s-%s' % (dbse, '044THR-118TYR-1')] =   -1.267  
BIND_BRONZE['%s-%s' % (dbse, '044TRP-048TYR-1')] =   -2.677  
BIND_BRONZE['%s-%s' % (dbse, '044TRP-085PHE-1')] =   -4.091  
BIND_BRONZE['%s-%s' % (dbse, '044TRP-147TYR-1')] =   -1.511  
BIND_BRONZE['%s-%s' % (dbse, '044TYR-048LYS-2')] =  -15.928  
BIND_BRONZE['%s-%s' % (dbse, '044TYR-059ILE-1')] =   -1.242  
BIND_BRONZE['%s-%s' % (dbse, '044TYR-077LEU-1')] =   -1.620  
BIND_BRONZE['%s-%s' % (dbse, '044TYR-109LEU-1')] =   -1.476  
BIND_BRONZE['%s-%s' % (dbse, '044VAL-174MET-1')] =   -1.552  
BIND_BRONZE['%s-%s' % (dbse, '045ALA-054HIE-1')] =   -0.717  
BIND_BRONZE['%s-%s' % (dbse, '045ALA-071HIE-1')] =   -2.296  
BIND_BRONZE['%s-%s' % (dbse, '045ASP-081GLU-1')] =   89.469  
BIND_BRONZE['%s-%s' % (dbse, '045GLN-062LYS-2')] =  -24.192  
BIND_BRONZE['%s-%s' % (dbse, '045HIE-051GLU-1')] =  -23.767  
BIND_BRONZE['%s-%s' % (dbse, '045HIE-053ILE-1')] =   -2.170  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-049GLU-1')] =   -0.172  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-049TYR-1')] =   -0.040  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-054PHE-1')] =   -1.122  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-055ASP-1')] =   -2.808  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-070PHE-1')] =   -1.145  
BIND_BRONZE['%s-%s' % (dbse, '045LEU-097LEU-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '045LYS-048GLU-1')] =   -4.585  
BIND_BRONZE['%s-%s' % (dbse, '045LYS-084GLU-1')] =  -72.232  
BIND_BRONZE['%s-%s' % (dbse, '045PHE-057GLU-1')] =   -7.691  
BIND_BRONZE['%s-%s' % (dbse, '045PHE-061VAL-1')] =   -1.580  
BIND_BRONZE['%s-%s' % (dbse, '045PHE-066PHE-1')] =   -1.978  
BIND_BRONZE['%s-%s' % (dbse, '045PHE-075LYS-1')] =  -10.279  
BIND_BRONZE['%s-%s' % (dbse, '045PRO-080VAL-1')] =   -1.490  
BIND_BRONZE['%s-%s' % (dbse, '045PRO-100VAL-1')] =   -0.662  
BIND_BRONZE['%s-%s' % (dbse, '045THR-048ALA-2')] =   -0.578  
BIND_BRONZE['%s-%s' % (dbse, '045THR-066VAL-1')] =   -0.502  
BIND_BRONZE['%s-%s' % (dbse, '045THR-097SER-1')] =   -0.434  
BIND_BRONZE['%s-%s' % (dbse, '045THR-168LYS-1')] =   -1.177  
BIND_BRONZE['%s-%s' % (dbse, '045TRP-048ILE-1')] =   -0.943  
BIND_BRONZE['%s-%s' % (dbse, '045TRP-049ILE-1')] =   -1.134  
BIND_BRONZE['%s-%s' % (dbse, '045TRP-100VAL-1')] =   -0.988  
BIND_BRONZE['%s-%s' % (dbse, '045TRP-272GLN-1')] =   -4.919  
BIND_BRONZE['%s-%s' % (dbse, '045TYR-053THR-1')] =   -2.106  
BIND_BRONZE['%s-%s' % (dbse, '046ARG-050ASP-2')] =  -95.362  
BIND_BRONZE['%s-%s' % (dbse, '046ARG-092TYR-1')] =    0.899  
BIND_BRONZE['%s-%s' % (dbse, '046ARG-182GLU-1')] =  -76.716  
BIND_BRONZE['%s-%s' % (dbse, '046ARG-273GLU-1')] = -114.182  
BIND_BRONZE['%s-%s' % (dbse, '046ASP-083ASP-2')] =   55.438  
BIND_BRONZE['%s-%s' % (dbse, '046ILE-071GLU-1')] =   -0.732  
BIND_BRONZE['%s-%s' % (dbse, '046ILE-074LEU-1')] =   10.168  
BIND_BRONZE['%s-%s' % (dbse, '046LEU-068ILE-1')] =   -0.481  
BIND_BRONZE['%s-%s' % (dbse, '046LEU-103PHE-1')] =   -1.089  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-050LYS-1')] =   -3.037  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-084LEU-1')] =   -1.928  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-088MET-1')] =   -1.956  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-107PHE-1')] =   -2.887  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-119GLN-2')] =   -1.028  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-121LEU-1')] =   -1.842  
BIND_BRONZE['%s-%s' % (dbse, '046PHE-161TYR-1')] =   -2.351  
BIND_BRONZE['%s-%s' % (dbse, '046PRO-140ALA-1')] =   -0.528  
BIND_BRONZE['%s-%s' % (dbse, '046PRO-141ARG-1')] =   -0.911  
BIND_BRONZE['%s-%s' % (dbse, '046SER-054PHE-1')] =   -2.437  
BIND_BRONZE['%s-%s' % (dbse, '046SER-088ASP-1')] =   -6.004  
BIND_BRONZE['%s-%s' % (dbse, '046THR-069ASN-1')] =   -4.237  
BIND_BRONZE['%s-%s' % (dbse, '046VAL-094PHE-1')] =   -0.937  
BIND_BRONZE['%s-%s' % (dbse, '047ARG-050GLU-1')] =  -81.834  
BIND_BRONZE['%s-%s' % (dbse, '047ARG-059MET-1')] =   -1.317  
BIND_BRONZE['%s-%s' % (dbse, '047ASN-062LYS-1')] =   -0.739  
BIND_BRONZE['%s-%s' % (dbse, '047ASN-276PRO-1')] =   -1.158  
BIND_BRONZE['%s-%s' % (dbse, '047ILE-064LEU-1')] =   -0.446  
BIND_BRONZE['%s-%s' % (dbse, '047LEU-055LEU-1')] =   -0.356  
BIND_BRONZE['%s-%s' % (dbse, '047LYS-059ASP-1')] = -113.947  
BIND_BRONZE['%s-%s' % (dbse, '047PRO-164TRP-1')] =   -1.949  
BIND_BRONZE['%s-%s' % (dbse, '047SER-065PHE-1')] =   -1.094  
BIND_BRONZE['%s-%s' % (dbse, '047TRP-081GLU-1')] =   -9.498  
BIND_BRONZE['%s-%s' % (dbse, '047TRP-083TYR-1')] =   -2.105  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-052PHE-1')] =   -1.208  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-053ASP-1')] =    1.540  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-055ASN-1')] =   -1.104  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-058TYR-1')] =   -3.179  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-075ILE-1')] =   -1.976  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-077HIE-1')] =   -0.866  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-111PHE-1')] =   -1.671  
BIND_BRONZE['%s-%s' % (dbse, '047TYR-136TYR-1')] =    2.889  
BIND_BRONZE['%s-%s' % (dbse, '048ARG-060MET-1')] =   -1.556  
BIND_BRONZE['%s-%s' % (dbse, '048ASN-052ASN-1')] =   -4.592  
BIND_BRONZE['%s-%s' % (dbse, '048ASP-081THR-1')] =  -19.480  
BIND_BRONZE['%s-%s' % (dbse, '048ASP-131LYS-1')] = -115.157  
BIND_BRONZE['%s-%s' % (dbse, '048GLN-070SER-1')] =   -1.007  
BIND_BRONZE['%s-%s' % (dbse, '048HIE-052PHE-1')] =   -0.507  
BIND_BRONZE['%s-%s' % (dbse, '048HIE-091ARG-1')] =   -6.331  
BIND_BRONZE['%s-%s' % (dbse, '048HIE-099HIE-2')] =   -3.165  
BIND_BRONZE['%s-%s' % (dbse, '048HIE-174MET-1')] =   -3.896  
BIND_BRONZE['%s-%s' % (dbse, '048HIE-178ASP-1')] =  -26.524  
BIND_BRONZE['%s-%s' % (dbse, '048ILE-052ILE-1')] =   -1.055  
BIND_BRONZE['%s-%s' % (dbse, '048ILE-272GLN-1')] =   -1.006  
BIND_BRONZE['%s-%s' % (dbse, '048ILE-279ILE-1')] =   -1.029  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-070PHE-1')] =   -1.086  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-070PHE-2')] =   -1.133  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-074TYR-1')] =   -1.860  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-074TYR-2')] =   -1.615  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-077GLN-1')] =   -0.649  
BIND_BRONZE['%s-%s' % (dbse, '048LEU-141PHE-1')] =   -1.373  
BIND_BRONZE['%s-%s' % (dbse, '048LYS-082ILE-1')] =   -0.876  
BIND_BRONZE['%s-%s' % (dbse, '048LYS-098GLU-1')] = -110.100  
BIND_BRONZE['%s-%s' % (dbse, '048PHE-058PHE-1')] =   -1.959  
BIND_BRONZE['%s-%s' % (dbse, '048PHE-101LEU-1')] =   -0.749  
BIND_BRONZE['%s-%s' % (dbse, '048PHE-105TYR-1')] =   -1.838  
BIND_BRONZE['%s-%s' % (dbse, '048VAL-093THR-1')] =   -0.247  
BIND_BRONZE['%s-%s' % (dbse, '048VAL-095LEU-1')] =   -0.635  
BIND_BRONZE['%s-%s' % (dbse, '048VAL-099ILE-1')] =   -0.787  
BIND_BRONZE['%s-%s' % (dbse, '049ALA-092TYR-1')] =   -1.267  
BIND_BRONZE['%s-%s' % (dbse, '049ARG-167GLN-1')] =  -20.811  
BIND_BRONZE['%s-%s' % (dbse, '049GLU-080ARG-1')] =  -92.431  
BIND_BRONZE['%s-%s' % (dbse, '049ILE-059ASP-1')] =   -3.367  
BIND_BRONZE['%s-%s' % (dbse, '049ILE-070PHE-1')] =   -1.041  
BIND_BRONZE['%s-%s' % (dbse, '049ILE-100VAL-1')] =   -0.702  
BIND_BRONZE['%s-%s' % (dbse, '049LEU-054VAL-1')] =   -0.491  
BIND_BRONZE['%s-%s' % (dbse, '049LEU-107PHE-1')] =   -1.740  
BIND_BRONZE['%s-%s' % (dbse, '049LYS-121LEU-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '049LYS-158ASP-1')] =   -6.589  
BIND_BRONZE['%s-%s' % (dbse, '049PHE-056PHE-1')] =   -1.776  
BIND_BRONZE['%s-%s' % (dbse, '049PHE-057GLN-2')] =   -3.262  
BIND_BRONZE['%s-%s' % (dbse, '049PHE-091ARG-1')] =   -1.190  
BIND_BRONZE['%s-%s' % (dbse, '049PHE-093VAL-1')] =   -2.908  
BIND_BRONZE['%s-%s' % (dbse, '049PRO-052TYR-1')] =   -1.047  
BIND_BRONZE['%s-%s' % (dbse, '049THR-053LEU-1')] =   -0.684  
BIND_BRONZE['%s-%s' % (dbse, '049TYR-054PHE-1')] =   -1.446  
BIND_BRONZE['%s-%s' % (dbse, '049TYR-098GLU-1')] =    3.612  
BIND_BRONZE['%s-%s' % (dbse, '049TYR-102ASN-1')] =   -4.438  
BIND_BRONZE['%s-%s' % (dbse, '049VAL-053THR-1')] =   -0.664  
BIND_BRONZE['%s-%s' % (dbse, '049VAL-124GLN-1')] =   -0.734  
BIND_BRONZE['%s-%s' % (dbse, '049VAL-127LEU-1')] =   -1.287  
BIND_BRONZE['%s-%s' % (dbse, '049VAL-131VAL-1')] =   -0.703  
BIND_BRONZE['%s-%s' % (dbse, '050ALA-081PHE-1')] =   -1.084  
BIND_BRONZE['%s-%s' % (dbse, '050ARG-054THR-1')] =  -12.272  
BIND_BRONZE['%s-%s' % (dbse, '050ASN-083TYR-1')] =   -1.254  
BIND_BRONZE['%s-%s' % (dbse, '050ASP-053THR-1')] =  -18.742  
BIND_BRONZE['%s-%s' % (dbse, '050ASP-067PHE-1')] =   -2.479  
BIND_BRONZE['%s-%s' % (dbse, '050ASP-092TYR-1')] =  -24.293  
BIND_BRONZE['%s-%s' % (dbse, '050GLN-055TYR-1')] =   -5.671  
BIND_BRONZE['%s-%s' % (dbse, '050HIE-065PHE-1')] =   -3.398  
BIND_BRONZE['%s-%s' % (dbse, '050HIE-087TYR-1')] =  -11.093  
BIND_BRONZE['%s-%s' % (dbse, '050ILE-053ILE-1')] =   -0.667  
BIND_BRONZE['%s-%s' % (dbse, '050ILE-071PRO-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '050ILE-079VAL-1')] =   -0.157  
BIND_BRONZE['%s-%s' % (dbse, '050LYS-056GLU-1')] = -111.638  
BIND_BRONZE['%s-%s' % (dbse, '050PHE-071PHE-1')] =   -1.636  
BIND_BRONZE['%s-%s' % (dbse, '050PRO-053TYR-1')] =   -1.612  
BIND_BRONZE['%s-%s' % (dbse, '050PRO-058PHE-1')] =   -1.883  
BIND_BRONZE['%s-%s' % (dbse, '050PRO-096TYR-1')] =    0.214  
BIND_BRONZE['%s-%s' % (dbse, '050SER-066PHE-1')] =   -1.184  
BIND_BRONZE['%s-%s' % (dbse, '050THR-143THR-1')] =   -0.292  
BIND_BRONZE['%s-%s' % (dbse, '050TRP-054GLU-1')] =   -6.548  
BIND_BRONZE['%s-%s' % (dbse, '050VAL-054THR-1')] =    1.737  
BIND_BRONZE['%s-%s' % (dbse, '051CYS-154LYS-1')] =   -8.041  
BIND_BRONZE['%s-%s' % (dbse, '051CYS-156THR-1')] =    1.760  
BIND_BRONZE['%s-%s' % (dbse, '051GLN-089GLU-1')] =   -5.395  
BIND_BRONZE['%s-%s' % (dbse, '051GLN-089GLU-2')] =  -24.605  
BIND_BRONZE['%s-%s' % (dbse, '051GLN-098TYR-1')] =   -2.414  
BIND_BRONZE['%s-%s' % (dbse, '051GLU-056MET-1')] =   -0.435  
BIND_BRONZE['%s-%s' % (dbse, '051GLU-056MET-2')] =   -3.184  
BIND_BRONZE['%s-%s' % (dbse, '051HIE-277ASP-1')] =  -24.215  
BIND_BRONZE['%s-%s' % (dbse, '051ILE-068LEU-1')] =   -1.117  
BIND_BRONZE['%s-%s' % (dbse, '051LEU-055ASP-1')] =   -2.956  
BIND_BRONZE['%s-%s' % (dbse, '051LEU-080ARG-1')] =   -1.913  
BIND_BRONZE['%s-%s' % (dbse, '051LEU-096TYR-1')] =   -1.957  
BIND_BRONZE['%s-%s' % (dbse, '051LEU-131LYS-1')] =   -1.043  
BIND_BRONZE['%s-%s' % (dbse, '051PHE-058VAL-1')] =   -0.476  
BIND_BRONZE['%s-%s' % (dbse, '051PHE-091ARG-1')] =   -5.789  
BIND_BRONZE['%s-%s' % (dbse, '051PHE-091ARG-2')] =   -1.963  
BIND_BRONZE['%s-%s' % (dbse, '051PHE-175PHE-1')] =   -1.374  
BIND_BRONZE['%s-%s' % (dbse, '051THR-152PHE-1')] =   -1.303  
BIND_BRONZE['%s-%s' % (dbse, '051TRP-093VAL-1')] =   -1.587  
BIND_BRONZE['%s-%s' % (dbse, '051TRP-095LEU-1')] =   -0.714  
BIND_BRONZE['%s-%s' % (dbse, '051TRP-097ARG-1')] =   -7.264  
BIND_BRONZE['%s-%s' % (dbse, '051TRP-097ARG-2')] =   -2.461  
BIND_BRONZE['%s-%s' % (dbse, '051TRP-107PHE-1')] =   -2.268  
BIND_BRONZE['%s-%s' % (dbse, '051VAL-071ALA-1')] =   -0.733  
BIND_BRONZE['%s-%s' % (dbse, '051VAL-104ILE-1')] =   -0.542  
BIND_BRONZE['%s-%s' % (dbse, '052ASN-061ASN-1')] =   -7.003  
BIND_BRONZE['%s-%s' % (dbse, '052ASN-143THR-1')] =    1.732  
BIND_BRONZE['%s-%s' % (dbse, '052GLN-069ARG-1')] =   -9.845  
BIND_BRONZE['%s-%s' % (dbse, '052GLN-117PHE-1')] =   -1.134  
BIND_BRONZE['%s-%s' % (dbse, '052ILE-056GLN-1')] =   -1.238  
BIND_BRONZE['%s-%s' % (dbse, '052ILE-087VAL-1')] =    0.072  
BIND_BRONZE['%s-%s' % (dbse, '052ILE-100VAL-1')] =   -0.269  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-060LEU-1')] =   -0.534  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-062PHE-1')] =   -1.661  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-062PHE-2')] =   -1.647  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-070PHE-1')] =   -0.923  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-141PHE-1')] =   -1.442  
BIND_BRONZE['%s-%s' % (dbse, '052LEU-152PHE-1')] =   -0.807  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-056MET-1')] =   -3.070  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-061CYS-1')] =   -1.365  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-071PHE-1')] =   -1.380  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-073THR-1')] =   -1.364  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-075ILE-1')] =   -1.426  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-111PHE-1')] =   -1.378  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-141MET-1')] =   -2.532  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-148ALA-1')] =   -1.077  
BIND_BRONZE['%s-%s' % (dbse, '052PHE-157ILE-1')] =   -1.385  
BIND_BRONZE['%s-%s' % (dbse, '052PRO-109LEU-1')] =   -0.710  
BIND_BRONZE['%s-%s' % (dbse, '052SER-063PHE-1')] =   -1.157  
BIND_BRONZE['%s-%s' % (dbse, '052TYR-058PHE-1')] =   -1.792  
BIND_BRONZE['%s-%s' % (dbse, '052TYR-061ASP-1')] =  -24.905  
BIND_BRONZE['%s-%s' % (dbse, '052TYR-116PHE-1')] =   -1.944  
BIND_BRONZE['%s-%s' % (dbse, '052VAL-057SER-1')] =   -0.340  
BIND_BRONZE['%s-%s' % (dbse, '053ASN-063SER-1')] =   -4.411  
BIND_BRONZE['%s-%s' % (dbse, '053ASN-131VAL-1')] =   -1.420  
BIND_BRONZE['%s-%s' % (dbse, '053ASP-058TYR-1')] =   -0.886  
BIND_BRONZE['%s-%s' % (dbse, '053ILE-066LEU-1')] =   -0.170  
BIND_BRONZE['%s-%s' % (dbse, '053ILE-069PHE-1')] =   -1.290  
BIND_BRONZE['%s-%s' % (dbse, '053ILE-075LEU-1')] =   -0.229  
BIND_BRONZE['%s-%s' % (dbse, '053ILE-077LEU-1')] =   -0.770  
BIND_BRONZE['%s-%s' % (dbse, '053LEU-057PHE-1')] =   -1.104  
BIND_BRONZE['%s-%s' % (dbse, '053LEU-091ILE-1')] =   -0.774  
BIND_BRONZE['%s-%s' % (dbse, '053MET-140ASP-1')] =   -6.088  
BIND_BRONZE['%s-%s' % (dbse, '053SER-089GLU-1')] =  -19.540  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-059LEU-1')] =   -1.542  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-083ASP-1')] =  -25.571  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-092TYR-1')] =   -2.597  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-094LYS-1')] =   -2.095  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-142ALA-1')] =   -1.400  
BIND_BRONZE['%s-%s' % (dbse, '053TYR-169MET-1')] =   -3.772  
BIND_BRONZE['%s-%s' % (dbse, '053VAL-057ARG-1')] =   -2.303  
BIND_BRONZE['%s-%s' % (dbse, '053VAL-068PHE-1')] =   -0.572  
BIND_BRONZE['%s-%s' % (dbse, '053VAL-074ALA-1')] =   -0.803  
BIND_BRONZE['%s-%s' % (dbse, '053VAL-117PHE-1')] =   -0.615  
BIND_BRONZE['%s-%s' % (dbse, '054ASN-069PHE-1')] =   -4.694  
BIND_BRONZE['%s-%s' % (dbse, '054ASN-141ASN-1')] =    1.870  
BIND_BRONZE['%s-%s' % (dbse, '054GLU-057ARG-2')] =  -93.939  
BIND_BRONZE['%s-%s' % (dbse, '054GLU-058ARG-1')] = -117.807  
BIND_BRONZE['%s-%s' % (dbse, '054GLU-141GLN-1')] =  -13.317  
BIND_BRONZE['%s-%s' % (dbse, '054ILE-074ALA-1')] =    0.194  
BIND_BRONZE['%s-%s' % (dbse, '054LEU-061LEU-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '054LEU-063PHE-1')] =   -1.556  
BIND_BRONZE['%s-%s' % (dbse, '054LEU-069VAL-1')] =   -0.454  
BIND_BRONZE['%s-%s' % (dbse, '054LEU-091LEU-1')] =   -0.948  
BIND_BRONZE['%s-%s' % (dbse, '054LEU-091LEU-2')] =    0.280  
BIND_BRONZE['%s-%s' % (dbse, '054PHE-101ILE-1')] =   -0.799  
BIND_BRONZE['%s-%s' % (dbse, '054THR-057ASP-2')] =    1.292  
BIND_BRONZE['%s-%s' % (dbse, '054VAL-091ALA-1')] =   -0.256  
BIND_BRONZE['%s-%s' % (dbse, '054VAL-097ILE-1')] =   -0.533  
BIND_BRONZE['%s-%s' % (dbse, '055ASN-058GLU-1')] =   -5.117  
BIND_BRONZE['%s-%s' % (dbse, '055ASN-058TYR-1')] =   -1.828  
BIND_BRONZE['%s-%s' % (dbse, '055ASP-069ARG-1')] = -117.936  
BIND_BRONZE['%s-%s' % (dbse, '055ASP-104LYS-1')] =  -86.292  
BIND_BRONZE['%s-%s' % (dbse, '055ASP-105TYR-1')] =  -10.668  
BIND_BRONZE['%s-%s' % (dbse, '055ASP-185ARG-1')] = -112.055  
BIND_BRONZE['%s-%s' % (dbse, '055GLN-272GLU-1')] =    5.815  
BIND_BRONZE['%s-%s' % (dbse, '055GLU-121LEU-1')] =   -1.141  
BIND_BRONZE['%s-%s' % (dbse, '055ILE-059ILE-1')] =   -0.808  
BIND_BRONZE['%s-%s' % (dbse, '055ILE-061CYS-1')] =   -0.902  
BIND_BRONZE['%s-%s' % (dbse, '055ILE-151THR-1')] =   -1.100  
BIND_BRONZE['%s-%s' % (dbse, '055ILE-155ILE-1')] =    1.049  
BIND_BRONZE['%s-%s' % (dbse, '055LEU-060VAL-1')] =   -0.823  
BIND_BRONZE['%s-%s' % (dbse, '055PHE-139ALA-1')] =   -1.176  
BIND_BRONZE['%s-%s' % (dbse, '055PHE-141GLN-1')] =   -1.758  
BIND_BRONZE['%s-%s' % (dbse, '055PHE-141GLN-2')] =   -1.892  
BIND_BRONZE['%s-%s' % (dbse, '055SER-071PHE-1')] =   -0.642  
BIND_BRONZE['%s-%s' % (dbse, '055SER-152PHE-1')] =   -1.921  
BIND_BRONZE['%s-%s' % (dbse, '055THR-072THR-1')] =    0.272  
BIND_BRONZE['%s-%s' % (dbse, '055VAL-059ILE-1')] =   -0.631  
BIND_BRONZE['%s-%s' % (dbse, '056ALA-061VAL-1')] =   -0.564  
BIND_BRONZE['%s-%s' % (dbse, '056ALA-175PHE-1')] =   -0.887  
BIND_BRONZE['%s-%s' % (dbse, '056ARG-061LEU-1')] =   -0.452  
BIND_BRONZE['%s-%s' % (dbse, '056HIE-287LEU-1')] =   -1.068  
BIND_BRONZE['%s-%s' % (dbse, '056HIE-287LEU-2')] =   -1.412  
BIND_BRONZE['%s-%s' % (dbse, '056ILE-059PHE-1')] =   -1.444  
BIND_BRONZE['%s-%s' % (dbse, '056ILE-059PHE-2')] =   -1.399  
BIND_BRONZE['%s-%s' % (dbse, '056LEU-069LEU-1')] =   -0.519  
BIND_BRONZE['%s-%s' % (dbse, '056LYS-160ASP-1')] = -109.440  
BIND_BRONZE['%s-%s' % (dbse, '056MET-059MET-1')] =   -1.580  
BIND_BRONZE['%s-%s' % (dbse, '056MET-181ALA-1')] =   -1.002  
BIND_BRONZE['%s-%s' % (dbse, '056PHE-062PHE-1')] =   -1.564  
BIND_BRONZE['%s-%s' % (dbse, '056PHE-129PHE-1')] =   -2.097  
BIND_BRONZE['%s-%s' % (dbse, '056PHE-152PHE-1')] =   -1.367  
BIND_BRONZE['%s-%s' % (dbse, '056SER-076LEU-1')] =   -0.530  
BIND_BRONZE['%s-%s' % (dbse, '056TYR-062TYR-1')] =   -3.848  
BIND_BRONZE['%s-%s' % (dbse, '056TYR-064VAL-1')] =   -0.192  
BIND_BRONZE['%s-%s' % (dbse, '056TYR-084ILE-1')] =   -2.060  
BIND_BRONZE['%s-%s' % (dbse, '057ARG-067VAL-1')] =   -1.547  
BIND_BRONZE['%s-%s' % (dbse, '057GLU-061ARG-1')] =  -88.613  
BIND_BRONZE['%s-%s' % (dbse, '057MET-060MET-1')] =   -1.265  
BIND_BRONZE['%s-%s' % (dbse, '057PHE-060LEU-1')] =   -1.349  
BIND_BRONZE['%s-%s' % (dbse, '057PHE-066ILE-1')] =   -1.363  
BIND_BRONZE['%s-%s' % (dbse, '057PHE-098VAL-1')] =   -1.807  
BIND_BRONZE['%s-%s' % (dbse, '057PHE-116PHE-1')] =   -1.280  
BIND_BRONZE['%s-%s' % (dbse, '057PHE-163ILE-1')] =   -1.361  
BIND_BRONZE['%s-%s' % (dbse, '057PRO-063TYR-1')] =   -1.690  
BIND_BRONZE['%s-%s' % (dbse, '057TYR-091LEU-1')] =   -2.842  
BIND_BRONZE['%s-%s' % (dbse, '057VAL-084ASP-1')] =   -3.558  
BIND_BRONZE['%s-%s' % (dbse, '057VAL-084ASP-2')] =   -2.341  
BIND_BRONZE['%s-%s' % (dbse, '057VAL-181ASN-1')] =   -1.238  
BIND_BRONZE['%s-%s' % (dbse, '058ARG-062LEU-1')] =   -0.986  
BIND_BRONZE['%s-%s' % (dbse, '058ARG-141GLN-1')] =  -10.012  
BIND_BRONZE['%s-%s' % (dbse, '058ASP-279LYS-1')] = -108.512  
BIND_BRONZE['%s-%s' % (dbse, '058GLN-067PHE-1')] =   -1.754  
BIND_BRONZE['%s-%s' % (dbse, '058GLN-067PHE-2')] =   -1.156  
BIND_BRONZE['%s-%s' % (dbse, '058HIE-067GLN-1')] =   -1.787  
BIND_BRONZE['%s-%s' % (dbse, '058HIE-115GLN-1')] =   -4.165  
BIND_BRONZE['%s-%s' % (dbse, '058ILE-097TRP-1')] =   -1.944  
BIND_BRONZE['%s-%s' % (dbse, '058LEU-071VAL-1')] =   -0.940  
BIND_BRONZE['%s-%s' % (dbse, '058LEU-084LEU-1')] =   -0.213  
BIND_BRONZE['%s-%s' % (dbse, '058LEU-094GLN-1')] =   -0.798  
BIND_BRONZE['%s-%s' % (dbse, '058LYS-122VAL-1')] =   -2.422  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-062ILE-1')] =   -1.044  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-062TYR-1')] =   -3.841  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-070TRP-1')] =   -4.258  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-081PHE-1')] =   -2.496  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-101ILE-1')] =    0.360  
BIND_BRONZE['%s-%s' % (dbse, '058PHE-131VAL-1')] =   -0.646  
BIND_BRONZE['%s-%s' % (dbse, '058TRP-084SER-1')] =   -3.639  
BIND_BRONZE['%s-%s' % (dbse, '058TRP-180SER-1')] =   -1.220  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-062GLN-1')] =   -1.145  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-062GLN-2')] =   -2.545  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-062LYS-1')] =   -8.652  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-066VAL-1')] =   -0.816  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-068ILE-1')] =   -0.791  
BIND_BRONZE['%s-%s' % (dbse, '058TYR-077ALA-1')] =   -1.221  
BIND_BRONZE['%s-%s' % (dbse, '058VAL-085ILE-1')] =   -0.344  
BIND_BRONZE['%s-%s' % (dbse, '059ARG-065MET-1')] =   -0.546  
BIND_BRONZE['%s-%s' % (dbse, '059ARG-067GLN-2')] =  -23.218  
BIND_BRONZE['%s-%s' % (dbse, '059ASN-062LYS-2')] =  -27.320  
BIND_BRONZE['%s-%s' % (dbse, '059ILE-068ILE-1')] =   -0.807  
BIND_BRONZE['%s-%s' % (dbse, '059ILE-094LEU-1')] =   -0.674  
BIND_BRONZE['%s-%s' % (dbse, '059LEU-117VAL-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '059LEU-117VAL-2')] =   -0.369  
BIND_BRONZE['%s-%s' % (dbse, '059LEU-119GLN-1')] =   -1.715  
BIND_BRONZE['%s-%s' % (dbse, '059LYS-063ASP-2')] = -115.767  
BIND_BRONZE['%s-%s' % (dbse, '059LYS-075TRP-1')] =   -7.632  
BIND_BRONZE['%s-%s' % (dbse, '059LYS-135ASP-1')] =   -3.427  
BIND_BRONZE['%s-%s' % (dbse, '059PHE-063ASN-1')] =   -4.034  
BIND_BRONZE['%s-%s' % (dbse, '059PHE-118THR-1')] =   -0.528  
BIND_BRONZE['%s-%s' % (dbse, '059PHE-120TRP-1')] =   -2.017  
BIND_BRONZE['%s-%s' % (dbse, '059PHE-127ILE-1')] =   -1.034  
BIND_BRONZE['%s-%s' % (dbse, '059THR-088TYR-1')] =   -1.145  
BIND_BRONZE['%s-%s' % (dbse, '059VAL-084LEU-1')] =   -1.054  
BIND_BRONZE['%s-%s' % (dbse, '059VAL-136TRP-1')] =   -1.599  
BIND_BRONZE['%s-%s' % (dbse, '060ALA-081LEU-1')] =   -0.759  
BIND_BRONZE['%s-%s' % (dbse, '060ASP-165ASP-1')] =   77.739  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-068PHE-1')] =   -0.766  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-095PHE-1')] =   -1.046  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-095PHE-2')] =   -1.061  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-098VAL-1')] =   -0.564  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-120VAL-1')] =   -1.220  
BIND_BRONZE['%s-%s' % (dbse, '060LEU-152PHE-1')] =   -1.187  
BIND_BRONZE['%s-%s' % (dbse, '060MET-070GLU-1')] =    0.709  # altered
BIND_BRONZE['%s-%s' % (dbse, '060THR-087LYS-1')] =  -18.158  
BIND_BRONZE['%s-%s' % (dbse, '060THR-176ARG-1')] =  -13.011  
BIND_BRONZE['%s-%s' % (dbse, '060TYR-064LEU-1')] =   -1.274  
BIND_BRONZE['%s-%s' % (dbse, '060TYR-128PRO-2')] =   -1.766  
BIND_BRONZE['%s-%s' % (dbse, '060VAL-063TYR-1')] =   -1.267  
BIND_BRONZE['%s-%s' % (dbse, '060VAL-157PRO-1')] =   -0.938  
BIND_BRONZE['%s-%s' % (dbse, '061ALA-080ALA-1')] =   -0.266  
BIND_BRONZE['%s-%s' % (dbse, '061ARG-083GLU-1')] =   -2.688  
BIND_BRONZE['%s-%s' % (dbse, '061ARG-083GLU-2')] =  -91.598  
BIND_BRONZE['%s-%s' % (dbse, '061ARG-084LEU-1')] =   -0.572  
BIND_BRONZE['%s-%s' % (dbse, '061ASN-065ASN-2')] =   -4.870  
BIND_BRONZE['%s-%s' % (dbse, '061ASP-065LYS-1')] =   -6.586  
BIND_BRONZE['%s-%s' % (dbse, '061GLU-080ARG-2')] =  -78.024  
BIND_BRONZE['%s-%s' % (dbse, '061GLU-088PHE-1')] =   -5.119  
BIND_BRONZE['%s-%s' % (dbse, '061GLU-142MET-1')] =   -8.147  
BIND_BRONZE['%s-%s' % (dbse, '061GLU-145LEU-1')] =   -1.822  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-064PHE-1')] =   -0.995  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-086ASP-1')] =   -1.201  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-089MET-1')] =   -0.482  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-091ILE-1')] =   -0.157  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-092TRP-1')] =   -0.420  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-098LEU-1')] =   -0.868  
BIND_BRONZE['%s-%s' % (dbse, '061ILE-155ASP-1')] =   -2.687  
BIND_BRONZE['%s-%s' % (dbse, '061LEU-065MET-1')] =   -0.665  
BIND_BRONZE['%s-%s' % (dbse, '061LEU-079ALA-1')] =   -0.475  
BIND_BRONZE['%s-%s' % (dbse, '061PHE-068VAL-1')] =   -0.724  
BIND_BRONZE['%s-%s' % (dbse, '061PHE-086VAL-1')] =   -1.289  
BIND_BRONZE['%s-%s' % (dbse, '061PHE-086VAL-2')] =   -0.856  
BIND_BRONZE['%s-%s' % (dbse, '061PHE-099ALA-1')] =   -2.575  
BIND_BRONZE['%s-%s' % (dbse, '061PHE-117VAL-1')] =   -0.851  
BIND_BRONZE['%s-%s' % (dbse, '061PRO-088PHE-1')] =   -1.542  
BIND_BRONZE['%s-%s' % (dbse, '061THR-081THR-1')] =   -0.431  
BIND_BRONZE['%s-%s' % (dbse, '061THR-083GLU-1')] =  -15.758  
BIND_BRONZE['%s-%s' % (dbse, '061TYR-066LEU-1')] =   -2.361  
BIND_BRONZE['%s-%s' % (dbse, '061VAL-064TYR-1')] =   -1.473  
BIND_BRONZE['%s-%s' % (dbse, '061VAL-066VAL-1')] =    0.175  
BIND_BRONZE['%s-%s' % (dbse, '061VAL-068ILE-1')] =   -1.021  
BIND_BRONZE['%s-%s' % (dbse, '062ALA-070MET-1')] =   -1.434  
BIND_BRONZE['%s-%s' % (dbse, '062ASP-080ARG-1')] =  -86.628  
BIND_BRONZE['%s-%s' % (dbse, '062GLN-110GLN-1')] =   -6.703  
BIND_BRONZE['%s-%s' % (dbse, '062GLN-112PHE-1')] =   -1.519  
BIND_BRONZE['%s-%s' % (dbse, '062GLN-171PRO-1')] =    1.700  
BIND_BRONZE['%s-%s' % (dbse, '062GLN-173TYR-1')] =   -2.773  
BIND_BRONZE['%s-%s' % (dbse, '062GLN-173TYR-2')] =   -1.797  
BIND_BRONZE['%s-%s' % (dbse, '062HIE-070GLU-1')] =   -7.759  
BIND_BRONZE['%s-%s' % (dbse, '062HIE-072LEU-1')] =   -1.009  
BIND_BRONZE['%s-%s' % (dbse, '062HIE-073TYR-1')] =    3.911  
BIND_BRONZE['%s-%s' % (dbse, '062HIE-076ALA-1')] =   -0.857  
BIND_BRONZE['%s-%s' % (dbse, '062ILE-067ILE-1')] =   -0.398  
BIND_BRONZE['%s-%s' % (dbse, '062ILE-069TYR-1')] =   -2.320  
BIND_BRONZE['%s-%s' % (dbse, '062ILE-105TYR-1')] =   -0.612  
BIND_BRONZE['%s-%s' % (dbse, '062ILE-107PHE-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '062LEU-075ILE-1')] =   -0.419  
BIND_BRONZE['%s-%s' % (dbse, '062LEU-077ALA-1')] =   -0.801  
BIND_BRONZE['%s-%s' % (dbse, '062LEU-079LEU-1')] =   -0.621  
BIND_BRONZE['%s-%s' % (dbse, '062LYS-067PHE-2')] =   -2.033  
BIND_BRONZE['%s-%s' % (dbse, '062LYS-147GLU-1')] =   -3.540  
BIND_BRONZE['%s-%s' % (dbse, '062PHE-120TYR-1')] =   -1.966  
BIND_BRONZE['%s-%s' % (dbse, '062PHE-128PRO-1')] =   -0.184  
BIND_BRONZE['%s-%s' % (dbse, '062THR-099ARG-1')] =  -10.026  
BIND_BRONZE['%s-%s' % (dbse, '062THR-102HIE-1')] =   -1.404  
BIND_BRONZE['%s-%s' % (dbse, '062TRP-073ALA-1')] =   -1.953  
BIND_BRONZE['%s-%s' % (dbse, '062TRP-164PHE-1')] =   -4.556  
BIND_BRONZE['%s-%s' % (dbse, '062TRP-166PRO-1')] =   -1.366  
BIND_BRONZE['%s-%s' % (dbse, '062TYR-077PHE-1')] =   -2.502  
BIND_BRONZE['%s-%s' % (dbse, '062TYR-083GLU-1')] =  -22.567  
BIND_BRONZE['%s-%s' % (dbse, '062TYR-084ILE-1')] =   -1.221  
BIND_BRONZE['%s-%s' % (dbse, '062TYR-093ILE-1')] =   -0.605  
BIND_BRONZE['%s-%s' % (dbse, '062TYR-095TRP-1')] =   -2.548  
BIND_BRONZE['%s-%s' % (dbse, '063ASN-081THR-1')] =   -3.331  
BIND_BRONZE['%s-%s' % (dbse, '063GLN-067ASP-1')] =   12.245  
BIND_BRONZE['%s-%s' % (dbse, '063GLN-136TRP-1')] =   -3.668  
BIND_BRONZE['%s-%s' % (dbse, '063GLN-165ASP-1')] =   -9.729  
BIND_BRONZE['%s-%s' % (dbse, '063ILE-077LEU-1')] =   -0.414  
BIND_BRONZE['%s-%s' % (dbse, '063LEU-068HIE-1')] =   -1.556  
BIND_BRONZE['%s-%s' % (dbse, '063LEU-108LEU-1')] =   -0.671  
BIND_BRONZE['%s-%s' % (dbse, '063LEU-140LEU-1')] =   -0.317  
BIND_BRONZE['%s-%s' % (dbse, '063PRO-090GLN-1')] =   -0.876  
BIND_BRONZE['%s-%s' % (dbse, '063PRO-090GLN-2')] =   -1.036  
BIND_BRONZE['%s-%s' % (dbse, '063PRO-091ILE-1')] =   -1.027  
BIND_BRONZE['%s-%s' % (dbse, '063PRO-094VAL-1')] =   -1.075  
BIND_BRONZE['%s-%s' % (dbse, '063THR-092TRP-1')] =   -1.593  
BIND_BRONZE['%s-%s' % (dbse, '063TRP-081TYR-1')] =    0.985  
BIND_BRONZE['%s-%s' % (dbse, '063TRP-085MET-1')] =   -2.611  
BIND_BRONZE['%s-%s' % (dbse, '063TRP-098LEU-1')] =   -1.508  
BIND_BRONZE['%s-%s' % (dbse, '063TRP-136PHE-1')] =   -1.692  
BIND_BRONZE['%s-%s' % (dbse, '063VAL-067LEU-1')] =   -0.594  
BIND_BRONZE['%s-%s' % (dbse, '063VAL-154THR-1')] =   -0.653  
BIND_BRONZE['%s-%s' % (dbse, '064GLU-111TRP-1')] =   -1.669  
BIND_BRONZE['%s-%s' % (dbse, '064ILE-072PRO-1')] =   -1.486  
BIND_BRONZE['%s-%s' % (dbse, '064ILE-084TYR-1')] =   -2.167  
BIND_BRONZE['%s-%s' % (dbse, '064ILE-084TYR-2')] =   -3.351  
BIND_BRONZE['%s-%s' % (dbse, '064ILE-090TYR-1')] =   -1.257  
BIND_BRONZE['%s-%s' % (dbse, '064PHE-097PRO-1')] =   -1.420  
BIND_BRONZE['%s-%s' % (dbse, '064PHE-123THR-1')] =   -1.136  
BIND_BRONZE['%s-%s' % (dbse, '064PHE-125TRP-1')] =   -3.349  
BIND_BRONZE['%s-%s' % (dbse, '064SER-171PRO-1')] =    1.438  
BIND_BRONZE['%s-%s' % (dbse, '064THR-116PHE-1')] =   -0.917  
BIND_BRONZE['%s-%s' % (dbse, '064TYR-068LYS-1')] =   -5.321  
BIND_BRONZE['%s-%s' % (dbse, '064TYR-078PHE-1')] =   -2.721  
BIND_BRONZE['%s-%s' % (dbse, '064TYR-082VAL-1')] =   -1.278  
BIND_BRONZE['%s-%s' % (dbse, '064TYR-083LEU-1')] =   -1.138  
BIND_BRONZE['%s-%s' % (dbse, '064TYR-164PHE-1')] =   -2.993  
BIND_BRONZE['%s-%s' % (dbse, '064VAL-073ALA-1')] =   -0.250  
BIND_BRONZE['%s-%s' % (dbse, '064VAL-143GLN-2')] =   -1.931  
BIND_BRONZE['%s-%s' % (dbse, '065ALA-070PHE-1')] =   -0.851  
BIND_BRONZE['%s-%s' % (dbse, '065ASN-110GLN-1')] =   -2.259  
BIND_BRONZE['%s-%s' % (dbse, '065ASP-110GLN-1')] =   -5.283  
BIND_BRONZE['%s-%s' % (dbse, '065GLN-088TYR-1')] =   -1.310  
BIND_BRONZE['%s-%s' % (dbse, '065LEU-077VAL-1')] =   -0.690  
BIND_BRONZE['%s-%s' % (dbse, '065LEU-080VAL-1')] =   -1.142  
BIND_BRONZE['%s-%s' % (dbse, '065MET-117PHE-1')] =   -2.499  
BIND_BRONZE['%s-%s' % (dbse, '065PHE-095LEU-1')] =   -0.789  
BIND_BRONZE['%s-%s' % (dbse, '065PRO-101LEU-1')] =   -0.661  
BIND_BRONZE['%s-%s' % (dbse, '065PRO-111TRP-1')] =   -3.124  
BIND_BRONZE['%s-%s' % (dbse, '065SER-068TYR-1')] =    0.517  
BIND_BRONZE['%s-%s' % (dbse, '065SER-108TYR-1')] =   -2.046  
BIND_BRONZE['%s-%s' % (dbse, '065THR-069ILE-1')] =   -0.654  
BIND_BRONZE['%s-%s' % (dbse, '065THR-082LEU-1')] =   -1.300  
BIND_BRONZE['%s-%s' % (dbse, '065TRP-146THR-1')] =   -1.170  
BIND_BRONZE['%s-%s' % (dbse, '065TRP-154THR-1')] =   -0.696  
BIND_BRONZE['%s-%s' % (dbse, '065TYR-090PRO-1')] =   -2.056  
BIND_BRONZE['%s-%s' % (dbse, '066ALA-084ALA-1')] =   -0.431  
BIND_BRONZE['%s-%s' % (dbse, '066ALA-136TRP-1')] =   -1.385  
BIND_BRONZE['%s-%s' % (dbse, '066ARG-167GLU-1')] = -118.126  
BIND_BRONZE['%s-%s' % (dbse, '066ASP-069ARG-2')] =  -93.199  
BIND_BRONZE['%s-%s' % (dbse, '066GLN-070ASN-1')] =   -4.822  
BIND_BRONZE['%s-%s' % (dbse, '066HIE-069GLU-1')] =   -2.816  
BIND_BRONZE['%s-%s' % (dbse, '066ILE-146VAL-1')] =   -0.738  
BIND_BRONZE['%s-%s' % (dbse, '066LEU-073PRO-1')] =   -1.141  
BIND_BRONZE['%s-%s' % (dbse, '066LEU-138THR-1')] =   -0.577  
BIND_BRONZE['%s-%s' % (dbse, '066PHE-075LYS-1')] =   -0.901  
BIND_BRONZE['%s-%s' % (dbse, '066PHE-109SER-1')] =   -0.276  
BIND_BRONZE['%s-%s' % (dbse, '066PRO-095TRP-1')] =   -3.555  
BIND_BRONZE['%s-%s' % (dbse, '066TRP-109TYR-1')] =   -1.854  
BIND_BRONZE['%s-%s' % (dbse, '066TRP-110PRO-1')] =   -2.027  
BIND_BRONZE['%s-%s' % (dbse, '066VAL-085ALA-1')] =    0.063  
BIND_BRONZE['%s-%s' % (dbse, '067ARG-077ILE-1')] =    0.069  
BIND_BRONZE['%s-%s' % (dbse, '067ASP-070ALA-1')] =   -2.484  
BIND_BRONZE['%s-%s' % (dbse, '067GLN-115GLN-1')] =   -5.925  
BIND_BRONZE['%s-%s' % (dbse, '067GLN-117PHE-1')] =   -2.634  
BIND_BRONZE['%s-%s' % (dbse, '067GLU-139TYR-1')] =   -3.065  
BIND_BRONZE['%s-%s' % (dbse, '067HIE-070HIE-1')] =   -4.955  
BIND_BRONZE['%s-%s' % (dbse, '067HIE-086GLU-1')] =   -4.452  
BIND_BRONZE['%s-%s' % (dbse, '067LEU-078LYS-1')] =   -0.823  
BIND_BRONZE['%s-%s' % (dbse, '067LEU-107LEU-1')] =   -0.771  
BIND_BRONZE['%s-%s' % (dbse, '067LEU-109VAL-1')] =   -0.588  
BIND_BRONZE['%s-%s' % (dbse, '067PRO-095TRP-1')] =   -4.810  
BIND_BRONZE['%s-%s' % (dbse, '067PRO-101ILE-1')] =   -0.704  
BIND_BRONZE['%s-%s' % (dbse, '067SER-073TYR-1')] =   -1.602  
BIND_BRONZE['%s-%s' % (dbse, '067THR-080TYR-1')] =   -1.128  
BIND_BRONZE['%s-%s' % (dbse, '067THR-082VAL-2')] =   -0.951  
BIND_BRONZE['%s-%s' % (dbse, '067VAL-085ASN-1')] =    1.683  
BIND_BRONZE['%s-%s' % (dbse, '068ARG-072THR-1')] =  -12.583  
BIND_BRONZE['%s-%s' % (dbse, '068HIE-075LYS-1')] =  -10.721  
BIND_BRONZE['%s-%s' % (dbse, '068HIE-080GLU-1')] =    1.778  
BIND_BRONZE['%s-%s' % (dbse, '068HIE-123ASP-1')] =  -26.159  
BIND_BRONZE['%s-%s' % (dbse, '068ILE-072LYS-1')] =   -2.315  
BIND_BRONZE['%s-%s' % (dbse, '068ILE-084TYR-1')] =   -1.953  
BIND_BRONZE['%s-%s' % (dbse, '068ILE-091LEU-1')] =   -0.160  
BIND_BRONZE['%s-%s' % (dbse, '068LEU-081VAL-1')] =   -0.577  
BIND_BRONZE['%s-%s' % (dbse, '068LEU-146PHE-1')] =   -1.229  
BIND_BRONZE['%s-%s' % (dbse, '068MET-131LEU-1')] =    0.127  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-076LEU-1')] =   -2.128  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-076LEU-2')] =   -1.329  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-077ILE-1')] =   -1.655  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-077VAL-1')] =   -0.901  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-080LEU-1')] =   -0.992  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-080VAL-1')] =   -1.084  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-083LEU-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '068PHE-110LEU-1')] =   -0.867  
BIND_BRONZE['%s-%s' % (dbse, '068TYR-073ILE-1')] =   -1.027  
BIND_BRONZE['%s-%s' % (dbse, '068TYR-078ALA-1')] =   -2.424  
BIND_BRONZE['%s-%s' % (dbse, '068TYR-082HIE-1')] =   -1.848  
BIND_BRONZE['%s-%s' % (dbse, '069ARG-075ILE-1')] =   -2.027  
BIND_BRONZE['%s-%s' % (dbse, '069ASN-119VAL-1')] =   -0.757  
BIND_BRONZE['%s-%s' % (dbse, '069GLU-076ILE-1')] =   -1.060  
BIND_BRONZE['%s-%s' % (dbse, '069GLU-076ILE-2')] =   -6.580  
BIND_BRONZE['%s-%s' % (dbse, '069GLU-078ARG-1')] = -117.093  
BIND_BRONZE['%s-%s' % (dbse, '069GLU-123ASP-1')] =   61.726  
BIND_BRONZE['%s-%s' % (dbse, '069HIE-075ILE-1')] =   -0.799  
BIND_BRONZE['%s-%s' % (dbse, '069HIE-078PHE-1')] =   -3.161  
BIND_BRONZE['%s-%s' % (dbse, '069ILE-101ILE-1')] =    0.331  
BIND_BRONZE['%s-%s' % (dbse, '069PHE-078GLU-1')] =   -5.898  
BIND_BRONZE['%s-%s' % (dbse, '069PHE-080TYR-1')] =   -2.431  
BIND_BRONZE['%s-%s' % (dbse, '069PHE-166TYR-1')] =    1.481  
BIND_BRONZE['%s-%s' % (dbse, '069THR-080LEU-1')] =   -0.591  
BIND_BRONZE['%s-%s' % (dbse, '069VAL-073TRP-1')] =   -2.823  
BIND_BRONZE['%s-%s' % (dbse, '069VAL-086GLU-1')] =   -1.184  
BIND_BRONZE['%s-%s' % (dbse, '069VAL-086ILE-1')] =   -0.675  
BIND_BRONZE['%s-%s' % (dbse, '069VAL-114VAL-1')] =   -0.537  
BIND_BRONZE['%s-%s' % (dbse, '070ASN-080GLU-1')] =    7.381  
BIND_BRONZE['%s-%s' % (dbse, '070ASP-076THR-1')] =  -15.020  
BIND_BRONZE['%s-%s' % (dbse, '070GLU-073LYS-1')] =   -2.008  
BIND_BRONZE['%s-%s' % (dbse, '070GLU-073LYS-2')] =  -92.126  
BIND_BRONZE['%s-%s' % (dbse, '070MET-075ILE-1')] =   -1.147  
BIND_BRONZE['%s-%s' % (dbse, '070PHE-120TYR-1')] =   -2.730  
BIND_BRONZE['%s-%s' % (dbse, '070SER-082VAL-1')] =   -0.889  
BIND_BRONZE['%s-%s' % (dbse, '070THR-120ASN-1')] =    5.568  
BIND_BRONZE['%s-%s' % (dbse, '070THR-124THR-2')] =   -4.766  
BIND_BRONZE['%s-%s' % (dbse, '070TRP-084VAL-1')] =   -1.086  
BIND_BRONZE['%s-%s' % (dbse, '070TRP-138LEU-1')] =   -2.534  
BIND_BRONZE['%s-%s' % (dbse, '070TRP-174PRO-1')] =   -2.416  
BIND_BRONZE['%s-%s' % (dbse, '071ASP-074LYS-1')] =   -4.025  
BIND_BRONZE['%s-%s' % (dbse, '071LYS-195ASP-1')] =   -4.320  
BIND_BRONZE['%s-%s' % (dbse, '071PHE-080ILE-1')] =   -1.059  
BIND_BRONZE['%s-%s' % (dbse, '071PHE-080LYS-1')] =   -1.048  
BIND_BRONZE['%s-%s' % (dbse, '071PHE-086ILE-1')] =   -1.636  
BIND_BRONZE['%s-%s' % (dbse, '071PHE-108ILE-1')] =   -1.122  
BIND_BRONZE['%s-%s' % (dbse, '071PHE-114SER-1')] =   -0.330  
BIND_BRONZE['%s-%s' % (dbse, '071SER-082HIE-1')] =   -5.814  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-076LEU-1')] =   -1.305  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-078GLU-1')] =   -4.791  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-099TRP-1')] =   -6.695  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-100SER-1')] =   -1.899  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-125PHE-1')] =   -2.301  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-165ALA-1')] =   -0.346  
BIND_BRONZE['%s-%s' % (dbse, '071TRP-166TYR-1')] =   -2.294  
BIND_BRONZE['%s-%s' % (dbse, '071VAL-077ILE-1')] =   -0.444  
BIND_BRONZE['%s-%s' % (dbse, '071VAL-083ILE-1')] =   -0.538  
BIND_BRONZE['%s-%s' % (dbse, '071VAL-085ALA-1')] =   -0.427  
BIND_BRONZE['%s-%s' % (dbse, '071VAL-119VAL-1')] =   -0.016  
BIND_BRONZE['%s-%s' % (dbse, '072ARG-116ASP-1')] =  -93.613  
BIND_BRONZE['%s-%s' % (dbse, '072ARG-118TYR-2')] =   -6.100  
BIND_BRONZE['%s-%s' % (dbse, '072ASN-075ARG-1')] =  -18.397  
BIND_BRONZE['%s-%s' % (dbse, '072HIE-093TYR-1')] =   -2.107  
BIND_BRONZE['%s-%s' % (dbse, '072HIE-095PRO-1')] =   -2.155  
BIND_BRONZE['%s-%s' % (dbse, '072ILE-077PHE-1')] =   -1.475  
BIND_BRONZE['%s-%s' % (dbse, '072ILE-082HIE-1')] =   -1.831  
BIND_BRONZE['%s-%s' % (dbse, '072ILE-116PHE-1')] =   -1.006  
BIND_BRONZE['%s-%s' % (dbse, '072ILE-116PHE-2')] =   -1.618  
BIND_BRONZE['%s-%s' % (dbse, '072THR-175GLN-1')] =   -0.905  
BIND_BRONZE['%s-%s' % (dbse, '072TYR-076ARG-2')] =   -1.460  
BIND_BRONZE['%s-%s' % (dbse, '072TYR-127ASN-1')] =   -0.520  
BIND_BRONZE['%s-%s' % (dbse, '072VAL-176PHE-1')] =   -0.768  
BIND_BRONZE['%s-%s' % (dbse, '073ARG-076LEU-1')] =   -2.279  
BIND_BRONZE['%s-%s' % (dbse, '073ARG-119ASP-1')] = -102.509  
BIND_BRONZE['%s-%s' % (dbse, '073ARG-163ASN-1')] =   -0.548  
BIND_BRONZE['%s-%s' % (dbse, '073ASP-135ARG-1')] = -110.725  
BIND_BRONZE['%s-%s' % (dbse, '073ASP-193VAL-1')] =   -2.404  
BIND_BRONZE['%s-%s' % (dbse, '073GLU-077ASN-2')] =    0.264  
BIND_BRONZE['%s-%s' % (dbse, '073GLU-119SER-1')] =  -19.021  
BIND_BRONZE['%s-%s' % (dbse, '073ILE-128ALA-1')] =   -1.079  
BIND_BRONZE['%s-%s' % (dbse, '073LEU-120TRP-1')] =   -1.027  
BIND_BRONZE['%s-%s' % (dbse, '073PHE-077TYR-1')] =   -2.728  
BIND_BRONZE['%s-%s' % (dbse, '073PHE-079LEU-1')] =   -0.807  
BIND_BRONZE['%s-%s' % (dbse, '073SER-090SER-1')] =   -1.544  
BIND_BRONZE['%s-%s' % (dbse, '073SER-178SER-1')] =   -0.321  
BIND_BRONZE['%s-%s' % (dbse, '073TRP-089TYR-1')] =   -3.492  
BIND_BRONZE['%s-%s' % (dbse, '073VAL-111ASP-1')] =   -1.119  
BIND_BRONZE['%s-%s' % (dbse, '074ALA-083TYR-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-130TYR-2')] =   -1.381  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-135SER-1')] =   -1.319  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-135SER-2')] =  -12.549  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-136GLN-1')] =   -2.590  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-147TYR-1')] =   -1.799  
BIND_BRONZE['%s-%s' % (dbse, '074ARG-147TYR-2')] =   -5.903  
BIND_BRONZE['%s-%s' % (dbse, '074GLN-094ASN-1')] =   -5.788  
BIND_BRONZE['%s-%s' % (dbse, '074GLU-096ARG-1')] =  -61.367  
BIND_BRONZE['%s-%s' % (dbse, '074LEU-079TYR-1')] =   -1.222  
BIND_BRONZE['%s-%s' % (dbse, '074LEU-102PRO-1')] =   -1.382  
BIND_BRONZE['%s-%s' % (dbse, '074LEU-107PHE-1')] =   -2.481  
BIND_BRONZE['%s-%s' % (dbse, '074LYS-127ALA-1')] =   -0.683  
BIND_BRONZE['%s-%s' % (dbse, '074PHE-080LEU-1')] =   -2.385  
BIND_BRONZE['%s-%s' % (dbse, '074PHE-083HIE-1')] =   -1.943  
BIND_BRONZE['%s-%s' % (dbse, '074SER-091PRO-1')] =   -0.712  
BIND_BRONZE['%s-%s' % (dbse, '074SER-111GLU-1')] =  -20.564  
BIND_BRONZE['%s-%s' % (dbse, '074VAL-080TRP-1')] =   -2.467  
BIND_BRONZE['%s-%s' % (dbse, '074VAL-083ASN-1')] =   -0.836  
BIND_BRONZE['%s-%s' % (dbse, '074VAL-190LEU-1')] =   -0.468  
BIND_BRONZE['%s-%s' % (dbse, '075GLU-079GLN-1')] =  -12.597  
BIND_BRONZE['%s-%s' % (dbse, '075GLU-079GLU-2')] =   76.014  
BIND_BRONZE['%s-%s' % (dbse, '075ILE-080ILE-1')] =   -0.781  
BIND_BRONZE['%s-%s' % (dbse, '075ILE-112LEU-1')] =   -0.510  
BIND_BRONZE['%s-%s' % (dbse, '075LEU-094ILE-1')] =   -0.597  
BIND_BRONZE['%s-%s' % (dbse, '075LEU-111LEU-1')] =   -0.381  
BIND_BRONZE['%s-%s' % (dbse, '075LEU-111LEU-2')] =   -0.398  
BIND_BRONZE['%s-%s' % (dbse, '075PHE-093PRO-1')] =   -1.763  
BIND_BRONZE['%s-%s' % (dbse, '075PHE-182ASN-1')] =   -2.221  
BIND_BRONZE['%s-%s' % (dbse, '075PHE-184PHE-1')] =   -1.328  
BIND_BRONZE['%s-%s' % (dbse, '075SER-078TRP-1')] =   -1.499  
BIND_BRONZE['%s-%s' % (dbse, '075SER-111ASP-1')] =  -16.989  
BIND_BRONZE['%s-%s' % (dbse, '075TRP-176ARG-1')] =   -3.670  
BIND_BRONZE['%s-%s' % (dbse, '076ARG-079GLU-1')] =  -96.438  
BIND_BRONZE['%s-%s' % (dbse, '076ARG-120TRP-1')] =   -2.754  
BIND_BRONZE['%s-%s' % (dbse, '076ARG-208TYR-1')] =   -1.767  
BIND_BRONZE['%s-%s' % (dbse, '076ARG-208TYR-2')] =   -5.977  
BIND_BRONZE['%s-%s' % (dbse, '076ASP-084LEU-1')] =   -0.993  
BIND_BRONZE['%s-%s' % (dbse, '076ASP-089TYR-1')] =  -25.960  
BIND_BRONZE['%s-%s' % (dbse, '076ASP-091PRO-1')] =   -1.425  
BIND_BRONZE['%s-%s' % (dbse, '076ASP-188GLN-1')] =  -20.340  
BIND_BRONZE['%s-%s' % (dbse, '076GLU-170LEU-1')] =   -2.803  
BIND_BRONZE['%s-%s' % (dbse, '076ILE-094ASN-1')] =   -1.407  
BIND_BRONZE['%s-%s' % (dbse, '076LEU-086MET-1')] =   -0.228  
BIND_BRONZE['%s-%s' % (dbse, '076LEU-117ILE-2')] =   -0.088  
BIND_BRONZE['%s-%s' % (dbse, '076LEU-123THR-1')] =   -0.534  
BIND_BRONZE['%s-%s' % (dbse, '076PRO-111TRP-1')] =   -0.992  
BIND_BRONZE['%s-%s' % (dbse, '076PRO-112LEU-1')] =   -0.090  
BIND_BRONZE['%s-%s' % (dbse, '076SER-082PHE-1')] =   -1.519  
BIND_BRONZE['%s-%s' % (dbse, '076THR-090SER-1')] =   -5.492  
BIND_BRONZE['%s-%s' % (dbse, '076TYR-125ILE-1')] =   -2.428  
BIND_BRONZE['%s-%s' % (dbse, '076TYR-125ILE-2')] =   -1.345  
BIND_BRONZE['%s-%s' % (dbse, '076TYR-136TYR-1')] =   -1.878  
BIND_BRONZE['%s-%s' % (dbse, '076TYR-139ILE-1')] =   -2.201  
BIND_BRONZE['%s-%s' % (dbse, '076TYR-143TRP-1')] =   -5.318  
BIND_BRONZE['%s-%s' % (dbse, '077ALA-096ARG-1')] =   -1.198  
BIND_BRONZE['%s-%s' % (dbse, '077ALA-138ARG-1')] =   -1.457  
BIND_BRONZE['%s-%s' % (dbse, '077ALA-138ARG-2')] =   -0.203  
BIND_BRONZE['%s-%s' % (dbse, '077ASP-080ARG-2')] =  -85.066  
BIND_BRONZE['%s-%s' % (dbse, '077HIE-111LEU-1')] =   -1.022  
BIND_BRONZE['%s-%s' % (dbse, '077ILE-102PHE-1')] =   -0.973  
BIND_BRONZE['%s-%s' % (dbse, '077ILE-112ILE-1')] =   -0.860  
BIND_BRONZE['%s-%s' % (dbse, '077ILE-125VAL-1')] =   -1.154  
BIND_BRONZE['%s-%s' % (dbse, '077ILE-128TYR-1')] =   -1.091  
BIND_BRONZE['%s-%s' % (dbse, '077ILE-128TYR-2')] =   -1.553  
BIND_BRONZE['%s-%s' % (dbse, '077LEU-093VAL-2')] =   -0.179  
BIND_BRONZE['%s-%s' % (dbse, '077LYS-178VAL-1')] =   -3.574  
BIND_BRONZE['%s-%s' % (dbse, '077LYS-186ASN-2')] =  -19.176  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-089PHE-1')] =   -2.621  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-093ILE-1')] =    0.020  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-097LEU-1')] =   -1.578  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-116PHE-1')] =   -1.768  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-160VAL-1')] =   -0.787  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-162PRO-1')] =   -1.323  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-201ARG-1')] =   -6.445  
BIND_BRONZE['%s-%s' % (dbse, '077PHE-205GLU-1')] =   -8.791  
BIND_BRONZE['%s-%s' % (dbse, '078ALA-126VAL-1')] =   -0.566  
BIND_BRONZE['%s-%s' % (dbse, '078ASP-157LYS-1')] = -103.957  
BIND_BRONZE['%s-%s' % (dbse, '078GLN-085LYS-1')] =   -1.410  
BIND_BRONZE['%s-%s' % (dbse, '078GLN-088GLU-1')] =  -20.630  
BIND_BRONZE['%s-%s' % (dbse, '078GLU-099THR-1')] =   -3.156  
BIND_BRONZE['%s-%s' % (dbse, '078GLU-127GLN-2')] =  -23.365  
BIND_BRONZE['%s-%s' % (dbse, '078HIE-081PHE-1')] =   -1.703  
BIND_BRONZE['%s-%s' % (dbse, '078LEU-108VAL-1')] =    0.170  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-082VAL-1')] =   -1.197  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-096ALA-1')] =   -1.065  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-104TRP-1')] =   -2.563  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-107ALA-2')] =   -0.971  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-108LEU-1')] =   -1.164  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-179LEU-1')] =   -2.119  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-215ILE-1')] =   -1.067  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-218LEU-1')] =   -0.847  
BIND_BRONZE['%s-%s' % (dbse, '078PHE-218LEU-2')] =    0.132  
BIND_BRONZE['%s-%s' % (dbse, '078PRO-115PRO-1')] =   -1.541  
BIND_BRONZE['%s-%s' % (dbse, '078PRO-186ASN-1')] =   -3.515  
BIND_BRONZE['%s-%s' % (dbse, '078SER-184PHE-1')] =   -2.789  
BIND_BRONZE['%s-%s' % (dbse, '078TYR-082PHE-1')] =   -3.006  
BIND_BRONZE['%s-%s' % (dbse, '079ARG-083ASP-1')] =  -97.784  
BIND_BRONZE['%s-%s' % (dbse, '079ARG-182ASP-1')] = -110.389  
BIND_BRONZE['%s-%s' % (dbse, '079ASP-131HIE-1')] =  -27.888  
BIND_BRONZE['%s-%s' % (dbse, '079ASP-135ILE-1')] =   -2.864  
BIND_BRONZE['%s-%s' % (dbse, '079PHE-089PHE-1')] =   -1.446  
BIND_BRONZE['%s-%s' % (dbse, '079PHE-100THR-1')] =   -1.880  
BIND_BRONZE['%s-%s' % (dbse, '079PHE-104LEU-1')] =   -1.429  
BIND_BRONZE['%s-%s' % (dbse, '079SER-088ALA-1')] =   -0.780  
BIND_BRONZE['%s-%s' % (dbse, '079SER-208TYR-1')] =   -0.400  
BIND_BRONZE['%s-%s' % (dbse, '079THR-089LEU-1')] =   -1.032  
BIND_BRONZE['%s-%s' % (dbse, '079THR-089LEU-2')] =   -0.392  
BIND_BRONZE['%s-%s' % (dbse, '079THR-110THR-1')] =   -5.403  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-084PRO-1')] =   -2.449  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-109VAL-1')] =   -0.858  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-112LEU-1')] =   -0.737  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-112LEU-2')] =   -1.096  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-146PHE-1')] =   -2.520  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-153TRP-1')] =   -1.847  
BIND_BRONZE['%s-%s' % (dbse, '079TYR-167GLN-1')] =    1.586  
BIND_BRONZE['%s-%s' % (dbse, '079VAL-087LYS-1')] =   -0.371  
BIND_BRONZE['%s-%s' % (dbse, '079VAL-094ILE-1')] =   -0.390  
BIND_BRONZE['%s-%s' % (dbse, '080ARG-088PHE-1')] =   -4.801  
BIND_BRONZE['%s-%s' % (dbse, '080ARG-090ASP-1')] =   -3.301  
BIND_BRONZE['%s-%s' % (dbse, '080ASP-087LYS-1')] = -111.888  
BIND_BRONZE['%s-%s' % (dbse, '080GLU-092ALA-1')] =   -3.153  
BIND_BRONZE['%s-%s' % (dbse, '080GLU-155ARG-1')] = -119.074  
BIND_BRONZE['%s-%s' % (dbse, '080ILE-112LEU-1')] =   -0.557  
BIND_BRONZE['%s-%s' % (dbse, '080PHE-085LYS-1')] =   -2.113  
BIND_BRONZE['%s-%s' % (dbse, '080PHE-098SER-1')] =   -1.593  
BIND_BRONZE['%s-%s' % (dbse, '080PHE-166PHE-1')] =   -0.979  
BIND_BRONZE['%s-%s' % (dbse, '080THR-090ARG-1')] =   -2.050  
BIND_BRONZE['%s-%s' % (dbse, '080TRP-088LEU-1')] =   -1.339  
BIND_BRONZE['%s-%s' % (dbse, '080TRP-090TYR-1')] =   -3.209  
BIND_BRONZE['%s-%s' % (dbse, '080TRP-095ILE-1')] =   -2.094  
BIND_BRONZE['%s-%s' % (dbse, '080TRP-108LEU-1')] =   -2.533  
BIND_BRONZE['%s-%s' % (dbse, '080TRP-136ILE-1')] =   -1.510  
BIND_BRONZE['%s-%s' % (dbse, '080TYR-129TRP-1')] =   -4.092  
BIND_BRONZE['%s-%s' % (dbse, '080TYR-172GLU-1')] =    1.337  
BIND_BRONZE['%s-%s' % (dbse, '081ALA-088ALA-1')] =   -0.840  
BIND_BRONZE['%s-%s' % (dbse, '081ASN-084LEU-1')] =   -1.793  
BIND_BRONZE['%s-%s' % (dbse, '081ASN-085SER-1')] =   -0.268  
BIND_BRONZE['%s-%s' % (dbse, '081ASN-100TRP-1')] =   -5.935  
BIND_BRONZE['%s-%s' % (dbse, '081ASP-092SER-1')] =  -18.641  
BIND_BRONZE['%s-%s' % (dbse, '081GLN-085ASP-1')] =  -22.278  
BIND_BRONZE['%s-%s' % (dbse, '081GLU-101ASN-1')] =    5.673  
BIND_BRONZE['%s-%s' % (dbse, '081GLU-103GLN-1')] =   -1.563  
BIND_BRONZE['%s-%s' % (dbse, '081GLU-103GLN-2')] =  -13.747  
BIND_BRONZE['%s-%s' % (dbse, '081HIE-202PHE-1')] =   -3.032  
BIND_BRONZE['%s-%s' % (dbse, '081ILE-085ARG-1')] =   -2.660  
BIND_BRONZE['%s-%s' % (dbse, '081LYS-105VAL-1')] =   -4.148  
BIND_BRONZE['%s-%s' % (dbse, '081MET-106CYS-1')] =   13.197  
BIND_BRONZE['%s-%s' % (dbse, '081MET-134GLU-1')] =   -1.573  
BIND_BRONZE['%s-%s' % (dbse, '081MET-134GLU-2')] =   -8.805  
BIND_BRONZE['%s-%s' % (dbse, '081MET-138ARG-1')] =   -4.984  
BIND_BRONZE['%s-%s' % (dbse, '081SER-087PHE-1')] =   -1.452  
BIND_BRONZE['%s-%s' % (dbse, '081TYR-085ARG-1')] =   -2.061  
BIND_BRONZE['%s-%s' % (dbse, '081TYR-130VAL-1')] =   -0.707  
BIND_BRONZE['%s-%s' % (dbse, '081VAL-105TYR-1')] =   -0.836  
BIND_BRONZE['%s-%s' % (dbse, '081VAL-149HIE-1')] =   -1.370  
BIND_BRONZE['%s-%s' % (dbse, '082ARG-088PHE-1')] =   -2.023  
BIND_BRONZE['%s-%s' % (dbse, '082ARG-088PHE-2')] =   -4.456  
BIND_BRONZE['%s-%s' % (dbse, '082ILE-121LEU-1')] =   -0.570  
BIND_BRONZE['%s-%s' % (dbse, '082ILE-135ILE-1')] =   -0.923  
BIND_BRONZE['%s-%s' % (dbse, '082ILE-136PHE-1')] =   -0.579  
BIND_BRONZE['%s-%s' % (dbse, '082ILE-186VAL-1')] =   -0.957  
BIND_BRONZE['%s-%s' % (dbse, '082LEU-176PHE-1')] =   -0.847  
BIND_BRONZE['%s-%s' % (dbse, '082PHE-091ILE-1')] =    0.858  
BIND_BRONZE['%s-%s' % (dbse, '082PHE-102TYR-1')] =   -2.930  
BIND_BRONZE['%s-%s' % (dbse, '082PHE-104VAL-1')] =   -0.987  
BIND_BRONZE['%s-%s' % (dbse, '082VAL-108LEU-1')] =   -0.457  
BIND_BRONZE['%s-%s' % (dbse, '082VAL-126SER-1')] =   -0.568  
BIND_BRONZE['%s-%s' % (dbse, '082VAL-127PHE-1')] =   -1.899  
BIND_BRONZE['%s-%s' % (dbse, '082VAL-130VAL-1')] =   -0.683  
BIND_BRONZE['%s-%s' % (dbse, '083ASP-089HIE-1')] =  -23.670  
BIND_BRONZE['%s-%s' % (dbse, '083ASP-105TYR-1')] =    3.850  
BIND_BRONZE['%s-%s' % (dbse, '083ASP-136ARG-1')] =  -93.783  
BIND_BRONZE['%s-%s' % (dbse, '083GLU-094TYR-1')] =   -7.329  
BIND_BRONZE['%s-%s' % (dbse, '083HIE-086GLU-1')] =  -25.769  
BIND_BRONZE['%s-%s' % (dbse, '083HIE-089ASP-1')] =  -25.545  
BIND_BRONZE['%s-%s' % (dbse, '083ILE-155ARG-1')] =   -0.744  
BIND_BRONZE['%s-%s' % (dbse, '083ILE-173LEU-1')] =   -0.519  
BIND_BRONZE['%s-%s' % (dbse, '083LEU-087LEU-1')] =   -1.272  
BIND_BRONZE['%s-%s' % (dbse, '083LEU-088TYR-2')] =   -1.641  
BIND_BRONZE['%s-%s' % (dbse, '083LEU-101GLN-1')] =   -0.982  
BIND_BRONZE['%s-%s' % (dbse, '083LEU-108VAL-1')] =   -0.536  
BIND_BRONZE['%s-%s' % (dbse, '083THR-086MET-1')] =    0.772  
BIND_BRONZE['%s-%s' % (dbse, '083THR-087GLN-1')] =   -1.276  
BIND_BRONZE['%s-%s' % (dbse, '083TYR-087PHE-1')] =   -3.114  
BIND_BRONZE['%s-%s' % (dbse, '083TYR-094TYR-1')] =   -1.378  
BIND_BRONZE['%s-%s' % (dbse, '083TYR-096ASN-1')] =   -1.833  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-087LEU-1')] =   -0.821  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-094PHE-1')] =   -0.907  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-094PHE-2')] =   -0.789  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-103TRP-1')] =   -1.598  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-140TYR-1')] =   -1.041  
BIND_BRONZE['%s-%s' % (dbse, '083VAL-153PHE-1')] =   -0.261  
BIND_BRONZE['%s-%s' % (dbse, '084ARG-089ASP-1')] =  -87.437  
BIND_BRONZE['%s-%s' % (dbse, '084ASN-099LYS-1')] =   -1.404  
BIND_BRONZE['%s-%s' % (dbse, '084ASN-103TRP-1')] =   -8.442  
BIND_BRONZE['%s-%s' % (dbse, '084ASP-087PHE-1')] =   -4.565  
BIND_BRONZE['%s-%s' % (dbse, '084ASP-107ASN-1')] =  -13.942  
BIND_BRONZE['%s-%s' % (dbse, '084ASP-126VAL-1')] =   -2.439  
BIND_BRONZE['%s-%s' % (dbse, '084CYS-090LYS-1')] =  -11.137  
BIND_BRONZE['%s-%s' % (dbse, '084LEU-090LEU-1')] =   -0.660  
BIND_BRONZE['%s-%s' % (dbse, '084PRO-122PHE-1')] =   -1.310  
BIND_BRONZE['%s-%s' % (dbse, '084PRO-135PHE-1')] =   -1.520  
BIND_BRONZE['%s-%s' % (dbse, '084THR-107PRO-1')] =   -1.903  
BIND_BRONZE['%s-%s' % (dbse, '084THR-108TYR-1')] =   -0.836  
BIND_BRONZE['%s-%s' % (dbse, '084TYR-089ASP-1')] =    0.686  
BIND_BRONZE['%s-%s' % (dbse, '084TYR-095LEU-1')] =   -1.356  
BIND_BRONZE['%s-%s' % (dbse, '085ASN-099TYR-1')] =   -1.492  
BIND_BRONZE['%s-%s' % (dbse, '085HIE-094TYR-1')] =   -2.715  
BIND_BRONZE['%s-%s' % (dbse, '085HIE-101TYR-1')] =   -3.024  
BIND_BRONZE['%s-%s' % (dbse, '085ILE-089ALA-1')] =   -0.503  
BIND_BRONZE['%s-%s' % (dbse, '085ILE-103LEU-1')] =   -1.357  
BIND_BRONZE['%s-%s' % (dbse, '085LEU-094PHE-1')] =   -1.053  
BIND_BRONZE['%s-%s' % (dbse, '085LEU-108LEU-1')] =   -0.506  
BIND_BRONZE['%s-%s' % (dbse, '085LEU-137ASN-1')] =   -1.151  
BIND_BRONZE['%s-%s' % (dbse, '085LEU-138LEU-1')] =   -0.799  
BIND_BRONZE['%s-%s' % (dbse, '085LYS-088GLU-1')] = -111.166  
BIND_BRONZE['%s-%s' % (dbse, '085LYS-094TYR-1')] =   -2.255  
BIND_BRONZE['%s-%s' % (dbse, '085MET-136PHE-1')] =   -1.120  
BIND_BRONZE['%s-%s' % (dbse, '085PRO-090LYS-1')] =   -0.938  
BIND_BRONZE['%s-%s' % (dbse, '085TRP-089ARG-1')] =   -3.050  
BIND_BRONZE['%s-%s' % (dbse, '085TRP-135LYS-2')] =   -7.362  
BIND_BRONZE['%s-%s' % (dbse, '086ALA-101GLN-1')] =   -0.776  
BIND_BRONZE['%s-%s' % (dbse, '086ALA-104TRP-1')] =   -0.968  
BIND_BRONZE['%s-%s' % (dbse, '086ALA-136PHE-2')] =   -2.206  
BIND_BRONZE['%s-%s' % (dbse, '086ASP-091ILE-1')] =   -6.137  
BIND_BRONZE['%s-%s' % (dbse, '086ASP-092TRP-1')] =   -6.687  
BIND_BRONZE['%s-%s' % (dbse, '086ASP-112TRP-1')] =  -11.004  
BIND_BRONZE['%s-%s' % (dbse, '086ASP-115ARG-1')] = -111.718  
BIND_BRONZE['%s-%s' % (dbse, '086HIE-089GLU-2')] =   14.933  
BIND_BRONZE['%s-%s' % (dbse, '086PRO-090ALA-1')] =   -1.541  
BIND_BRONZE['%s-%s' % (dbse, '086SER-136TRP-1')] =   -3.381  
BIND_BRONZE['%s-%s' % (dbse, '086VAL-105LEU-1')] =   -0.703  
BIND_BRONZE['%s-%s' % (dbse, '086VAL-116VAL-1')] =   -0.672  
BIND_BRONZE['%s-%s' % (dbse, '087ALA-171PRO-1')] =   -0.100  
BIND_BRONZE['%s-%s' % (dbse, '087ALA-173TYR-1')] =   -1.409  
BIND_BRONZE['%s-%s' % (dbse, '087ASN-091LYS-1')] =    3.630  
BIND_BRONZE['%s-%s' % (dbse, '087CYS-119ASP-1')] =    6.493  
BIND_BRONZE['%s-%s' % (dbse, '087CYS-121LEU-1')] =   -0.294  
BIND_BRONZE['%s-%s' % (dbse, '087GLN-139ASN-1')] =   -6.399  
BIND_BRONZE['%s-%s' % (dbse, '087LEU-095PHE-1')] =   -1.466  
BIND_BRONZE['%s-%s' % (dbse, '087LEU-095PHE-2')] =   -1.205  
BIND_BRONZE['%s-%s' % (dbse, '087LEU-096TRP-1')] =   -1.110  
BIND_BRONZE['%s-%s' % (dbse, '087LEU-109VAL-1')] =   -0.501  
BIND_BRONZE['%s-%s' % (dbse, '087LEU-153PHE-1')] =   -0.262  
BIND_BRONZE['%s-%s' % (dbse, '087PHE-126VAL-1')] =   -0.765  
BIND_BRONZE['%s-%s' % (dbse, '087PHE-186VAL-1')] =   -1.527  
BIND_BRONZE['%s-%s' % (dbse, '087PHE-188VAL-1')] =   -1.055  
BIND_BRONZE['%s-%s' % (dbse, '087VAL-102LEU-1')] =   -0.071  
BIND_BRONZE['%s-%s' % (dbse, '088ASN-092ASP-1')] =   -1.320  
BIND_BRONZE['%s-%s' % (dbse, '088ILE-135LEU-1')] =   -0.279  
BIND_BRONZE['%s-%s' % (dbse, '088ILE-135PHE-1')] =   -1.458  
BIND_BRONZE['%s-%s' % (dbse, '088LEU-108ILE-1')] =   -0.619  
BIND_BRONZE['%s-%s' % (dbse, '088PHE-092LEU-1')] =   -0.990  
BIND_BRONZE['%s-%s' % (dbse, '089ARG-106ASP-1')] =  -92.243  
BIND_BRONZE['%s-%s' % (dbse, '089ARG-108TYR-1')] =  -12.333  
BIND_BRONZE['%s-%s' % (dbse, '089ARG-131VAL-1')] =   -2.264  
BIND_BRONZE['%s-%s' % (dbse, '089ASP-092PHE-1')] =   -5.246  
BIND_BRONZE['%s-%s' % (dbse, '089ASP-112ASN-1')] =  -13.851  
BIND_BRONZE['%s-%s' % (dbse, '089ASP-131VAL-1')] =   -2.519  
BIND_BRONZE['%s-%s' % (dbse, '089CYS-105LEU-1')] =   -1.503  
BIND_BRONZE['%s-%s' % (dbse, '089GLN-117PHE-1')] =   -2.986  
BIND_BRONZE['%s-%s' % (dbse, '089GLN-125TYR-1')] =   -1.543  
BIND_BRONZE['%s-%s' % (dbse, '089ILE-112TRP-1')] =   -1.730  
BIND_BRONZE['%s-%s' % (dbse, '089LEU-127VAL-1')] =   -1.078  
BIND_BRONZE['%s-%s' % (dbse, '089THR-098LEU-1')] =   -0.603  
BIND_BRONZE['%s-%s' % (dbse, '089THR-098LEU-2')] =   -0.643  
BIND_BRONZE['%s-%s' % (dbse, '089TYR-094TYR-1')] =   -1.628  
BIND_BRONZE['%s-%s' % (dbse, '089TYR-153VAL-1')] =   -0.640  
BIND_BRONZE['%s-%s' % (dbse, '090ALA-121PHE-1')] =   -1.753  
BIND_BRONZE['%s-%s' % (dbse, '090ARG-187SER-1')] =   -7.948  
BIND_BRONZE['%s-%s' % (dbse, '090GLU-119ARG-1')] = -101.351  
BIND_BRONZE['%s-%s' % (dbse, '090ILE-099LEU-1')] =   -0.723  
BIND_BRONZE['%s-%s' % (dbse, '090ILE-107SER-1')] =   -1.100  
BIND_BRONZE['%s-%s' % (dbse, '090ILE-190VAL-1')] =   -0.398  
BIND_BRONZE['%s-%s' % (dbse, '090LYS-122ASP-1')] =   -5.656  
BIND_BRONZE['%s-%s' % (dbse, '090LYS-122ASP-2')] =   -3.685  
BIND_BRONZE['%s-%s' % (dbse, '090PRO-129TRP-1')] =   -1.651  
BIND_BRONZE['%s-%s' % (dbse, '090PRO-154VAL-1')] =   -0.594  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-095ARG-1')] =   -8.439  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-095ILE-1')] =   -1.330  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-099ILE-1')] =   -0.917  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-105LEU-1')] =   -0.766  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-112GLU-1')] =    6.193  
BIND_BRONZE['%s-%s' % (dbse, '090TYR-113ALA-1')] =   -2.354  
BIND_BRONZE['%s-%s' % (dbse, '091ASN-096TRP-1')] =   -7.210  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-098SER-1')] =   -4.668  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-118THR-1')] =   -0.585  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-118THR-2')] =   -2.657  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-121LEU-1')] =   -2.047  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-122ASP-1')] =   11.668  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-125HIE-1')] =   -1.097  
BIND_BRONZE['%s-%s' % (dbse, '091HIE-127VAL-1')] =   -0.906  
BIND_BRONZE['%s-%s' % (dbse, '091LYS-140SER-1')] =   -0.918  
BIND_BRONZE['%s-%s' % (dbse, '091LYS-140SER-2')] =  -17.073  
BIND_BRONZE['%s-%s' % (dbse, '091THR-094HIE-2')] =   -6.722  
BIND_BRONZE['%s-%s' % (dbse, '091VAL-094ASP-1')] =   -0.225  
BIND_BRONZE['%s-%s' % (dbse, '092ALA-164GLU-1')] =   -0.729  
BIND_BRONZE['%s-%s' % (dbse, '092LEU-095HIE-1')] =   -1.587  
BIND_BRONZE['%s-%s' % (dbse, '092PHE-099TRP-1')] =   -3.508  
BIND_BRONZE['%s-%s' % (dbse, '092PHE-120VAL-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '092PHE-131VAL-1')] =   -0.980  
BIND_BRONZE['%s-%s' % (dbse, '092PRO-102HIE-1')] =   -1.529  
BIND_BRONZE['%s-%s' % (dbse, '092PRO-133LYS-1')] =   -1.043  
BIND_BRONZE['%s-%s' % (dbse, '092TRP-100GLN-1')] =   22.772  
BIND_BRONZE['%s-%s' % (dbse, '092VAL-117PHE-1')] =   -1.116  
BIND_BRONZE['%s-%s' % (dbse, '093ALA-099THR-1')] =   -0.770  
BIND_BRONZE['%s-%s' % (dbse, '093ALA-164ASP-1')] =   -4.402  
BIND_BRONZE['%s-%s' % (dbse, '093ASN-096LYS-1')] =   -1.610  
BIND_BRONZE['%s-%s' % (dbse, '093ASP-097THR-1')] =  -21.768  
BIND_BRONZE['%s-%s' % (dbse, '093HIE-118GLN-1')] =   -3.930  
BIND_BRONZE['%s-%s' % (dbse, '093HIE-120ALA-1')] =   -0.619  
BIND_BRONZE['%s-%s' % (dbse, '093PRO-184PHE-1')] =   -1.581  
BIND_BRONZE['%s-%s' % (dbse, '094HIE-099THR-1')] =   -1.451  
BIND_BRONZE['%s-%s' % (dbse, '094HIE-104PHE-1')] =   -2.894  
BIND_BRONZE['%s-%s' % (dbse, '094ILE-114TRP-1')] =   -1.004  
BIND_BRONZE['%s-%s' % (dbse, '094LEU-132VAL-1')] =   -0.872  
BIND_BRONZE['%s-%s' % (dbse, '094LEU-182MET-1')] =   -0.859  
BIND_BRONZE['%s-%s' % (dbse, '094LYS-112ASP-1')] = -121.686  
BIND_BRONZE['%s-%s' % (dbse, '094PHE-098ILE-1')] =    0.083  
BIND_BRONZE['%s-%s' % (dbse, '094PHE-141ALA-1')] =   -0.740  
BIND_BRONZE['%s-%s' % (dbse, '094PRO-135MET-1')] =   -0.861  
BIND_BRONZE['%s-%s' % (dbse, '094TYR-097THR-1')] =   -0.469  
BIND_BRONZE['%s-%s' % (dbse, '094TYR-151VAL-1')] =   -0.883  
BIND_BRONZE['%s-%s' % (dbse, '094TYR-153VAL-1')] =   -1.762  
BIND_BRONZE['%s-%s' % (dbse, '094VAL-125TRP-1')] =   -0.927  
BIND_BRONZE['%s-%s' % (dbse, '094VAL-152LEU-1')] =   -0.166  
BIND_BRONZE['%s-%s' % (dbse, '094VAL-166PHE-1')] =   -1.490  
BIND_BRONZE['%s-%s' % (dbse, '095ASN-164ASP-1')] =  -22.970  
BIND_BRONZE['%s-%s' % (dbse, '095ASP-102TYR-1')] =    4.943  
BIND_BRONZE['%s-%s' % (dbse, '095GLN-098TYR-1')] =   -1.930  
BIND_BRONZE['%s-%s' % (dbse, '095GLN-185THR-1')] =   -0.957  
BIND_BRONZE['%s-%s' % (dbse, '095GLN-187ASP-1')] =   -6.094  
BIND_BRONZE['%s-%s' % (dbse, '095ILE-120TRP-1')] =   -1.682  
BIND_BRONZE['%s-%s' % (dbse, '095ILE-120TRP-2')] =   -0.952  
BIND_BRONZE['%s-%s' % (dbse, '095ILE-144THR-1')] =   -0.583  
BIND_BRONZE['%s-%s' % (dbse, '095LEU-103ILE-1')] =   -0.480  
BIND_BRONZE['%s-%s' % (dbse, '095LEU-130VAL-1')] =   -0.680  
BIND_BRONZE['%s-%s' % (dbse, '095LEU-133LYS-1')] =   -0.740  
BIND_BRONZE['%s-%s' % (dbse, '095LYS-107ILE-1')] =   -0.932  
BIND_BRONZE['%s-%s' % (dbse, '095LYS-109THR-1')] =  -14.941  
BIND_BRONZE['%s-%s' % (dbse, '095LYS-127ASP-1')] =   -6.147  
BIND_BRONZE['%s-%s' % (dbse, '095PHE-099LYS-2')] =   -2.628  
BIND_BRONZE['%s-%s' % (dbse, '095PHE-118ALA-1')] =   -0.810  
BIND_BRONZE['%s-%s' % (dbse, '095PHE-154ILE-1')] =   -1.286  
BIND_BRONZE['%s-%s' % (dbse, '095PHE-160VAL-1')] =   -0.945  
BIND_BRONZE['%s-%s' % (dbse, '095PHE-160VAL-2')] =   -0.487  
BIND_BRONZE['%s-%s' % (dbse, '095SER-114THR-1')] =   -1.153  
BIND_BRONZE['%s-%s' % (dbse, '095THR-182ASN-1')] =    1.761  
BIND_BRONZE['%s-%s' % (dbse, '095TRP-099LEU-2')] =   -1.499  
BIND_BRONZE['%s-%s' % (dbse, '095TRP-104VAL-1')] =   -0.846  
BIND_BRONZE['%s-%s' % (dbse, '095TYR-106TYR-1')] =   -4.495  
BIND_BRONZE['%s-%s' % (dbse, '096ASP-100ASN-1')] =  -21.385  
BIND_BRONZE['%s-%s' % (dbse, '096ASP-101GLN-1')] =  -22.427  
BIND_BRONZE['%s-%s' % (dbse, '096GLU-121LYS-1')] =   -4.079  
BIND_BRONZE['%s-%s' % (dbse, '096HIE-101GLN-1')] =   -4.349  
BIND_BRONZE['%s-%s' % (dbse, '096HIE-103SER-1')] =   -5.895  
BIND_BRONZE['%s-%s' % (dbse, '096HIE-126LEU-1')] =   -1.763  
BIND_BRONZE['%s-%s' % (dbse, '096HIE-127ASP-1')] =   12.423  
BIND_BRONZE['%s-%s' % (dbse, '096HIE-132VAL-1')] =   -1.383  
BIND_BRONZE['%s-%s' % (dbse, '096ILE-127VAL-1')] =   -0.364  
BIND_BRONZE['%s-%s' % (dbse, '096ILE-127VAL-2')] =   -0.145  
BIND_BRONZE['%s-%s' % (dbse, '096TRP-110LEU-1')] =   -1.056  
BIND_BRONZE['%s-%s' % (dbse, '096VAL-105LEU-1')] =    0.091  
BIND_BRONZE['%s-%s' % (dbse, '096VAL-108THR-1')] =   -0.797  
BIND_BRONZE['%s-%s' % (dbse, '097ALA-105LEU-1')] =   -0.598  
BIND_BRONZE['%s-%s' % (dbse, '097ALA-117HIE-1')] =   -0.962  
BIND_BRONZE['%s-%s' % (dbse, '097ASN-102TYR-1')] =   -3.906  
BIND_BRONZE['%s-%s' % (dbse, '097GLU-101ARG-1')] = -103.109  
BIND_BRONZE['%s-%s' % (dbse, '097ILE-105THR-1')] =   -0.964  
BIND_BRONZE['%s-%s' % (dbse, '097LEU-111PHE-1')] =   -1.171  
BIND_BRONZE['%s-%s' % (dbse, '097LEU-113ILE-1')] =    1.367  
BIND_BRONZE['%s-%s' % (dbse, '097LEU-128PHE-1')] =   -1.274  
BIND_BRONZE['%s-%s' % (dbse, '097PHE-103ARG-1')] =   -2.272  
BIND_BRONZE['%s-%s' % (dbse, '097PHE-181TRP-1')] =   -2.765  
BIND_BRONZE['%s-%s' % (dbse, '097PHE-183ILE-1')] =   -1.003  
BIND_BRONZE['%s-%s' % (dbse, '097PRO-106ILE-1')] =   -0.609  
BIND_BRONZE['%s-%s' % (dbse, '097TRP-145LYS-1')] =   -1.519  
BIND_BRONZE['%s-%s' % (dbse, '097TRP-173TYR-1')] =   -2.983  
BIND_BRONZE['%s-%s' % (dbse, '097TRP-213ILE-1')] =   -1.078  
BIND_BRONZE['%s-%s' % (dbse, '097TYR-101TRP-1')] =   -3.799  
BIND_BRONZE['%s-%s' % (dbse, '097TYR-179LYS-1')] =   -2.619  
BIND_BRONZE['%s-%s' % (dbse, '097TYR-179LYS-2')] =   -4.680  
BIND_BRONZE['%s-%s' % (dbse, '097VAL-112TRP-1')] =   -0.799  
BIND_BRONZE['%s-%s' % (dbse, '098ILE-145ILE-1')] =   -0.608  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-101VAL-1')] =   -0.967  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-115SER-1')] =   -1.017  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-117ALA-1')] =   -0.543  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-136PHE-1')] =   -0.922  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-144VAL-1')] =   -0.509  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-144VAL-2')] =   -0.590  
BIND_BRONZE['%s-%s' % (dbse, '098LEU-146TRP-1')] =   -1.110  
BIND_BRONZE['%s-%s' % (dbse, '098PRO-101GLN-1')] =   -1.448  
BIND_BRONZE['%s-%s' % (dbse, '098PRO-102ALA-1')] =   -0.066  
BIND_BRONZE['%s-%s' % (dbse, '098PRO-114PHE-1')] =   -0.847  
BIND_BRONZE['%s-%s' % (dbse, '098SER-112PHE-1')] =   -2.191  
BIND_BRONZE['%s-%s' % (dbse, '098SER-127VAL-1')] =    0.075  
BIND_BRONZE['%s-%s' % (dbse, '098SER-138TYR-2')] =    2.743  
BIND_BRONZE['%s-%s' % (dbse, '098SER-164ASP-1')] =  -17.467  
BIND_BRONZE['%s-%s' % (dbse, '098VAL-101GLN-1')] =   -1.150  
BIND_BRONZE['%s-%s' % (dbse, '098VAL-105TYR-1')] =   -0.737  
BIND_BRONZE['%s-%s' % (dbse, '098VAL-152ALA-1')] =   -0.768  
BIND_BRONZE['%s-%s' % (dbse, '098VAL-286TRP-1')] =   -0.834  
BIND_BRONZE['%s-%s' % (dbse, '098VAL-287LEU-1')] =   -0.380  
BIND_BRONZE['%s-%s' % (dbse, '099ARG-102HIE-1')] =   -2.163  
BIND_BRONZE['%s-%s' % (dbse, '099ARG-147VAL-1')] =   -1.784  
BIND_BRONZE['%s-%s' % (dbse, '099ARG-149ASN-1')] =   -1.485  
BIND_BRONZE['%s-%s' % (dbse, '099ARG-177ASP-1')] = -103.913  
BIND_BRONZE['%s-%s' % (dbse, '099ARG-216GLU-1')] =  -87.419  
BIND_BRONZE['%s-%s' % (dbse, '099GLN-108GLN-1')] =   -4.824  
BIND_BRONZE['%s-%s' % (dbse, '099GLN-148HIE-1')] =   -3.148  
BIND_BRONZE['%s-%s' % (dbse, '099ILE-103ALA-1')] =   -0.419  
BIND_BRONZE['%s-%s' % (dbse, '099LYS-104THR-1')] =   -0.855  
BIND_BRONZE['%s-%s' % (dbse, '099MET-107ASN-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '099MET-126VAL-1')] =    0.134  
BIND_BRONZE['%s-%s' % (dbse, '099PRO-104TRP-1')] =   -1.848  
BIND_BRONZE['%s-%s' % (dbse, '099PRO-164PHE-1')] =   -1.109  
BIND_BRONZE['%s-%s' % (dbse, '099PRO-166GLU-1')] =   -2.916  
BIND_BRONZE['%s-%s' % (dbse, '099TRP-118PRO-1')] =   -1.256  
BIND_BRONZE['%s-%s' % (dbse, '099TRP-272GLU-1')] =  -24.632  
BIND_BRONZE['%s-%s' % (dbse, '100ALA-112PHE-1')] =   -1.627  
BIND_BRONZE['%s-%s' % (dbse, '100ASN-113LYS-1')] =   -0.896  
BIND_BRONZE['%s-%s' % (dbse, '100ILE-103HIE-1')] =   -0.829  
BIND_BRONZE['%s-%s' % (dbse, '100ILE-104LYS-1')] =   -1.908  
BIND_BRONZE['%s-%s' % (dbse, '100LEU-130VAL-1')] =   -0.685  
BIND_BRONZE['%s-%s' % (dbse, '100LEU-134ALA-1')] =   -0.375  
BIND_BRONZE['%s-%s' % (dbse, '100LEU-142LEU-1')] =   -0.462  
BIND_BRONZE['%s-%s' % (dbse, '100SER-119GLU-1')] =  -20.456  
BIND_BRONZE['%s-%s' % (dbse, '100SER-131VAL-2')] =   -1.067  
BIND_BRONZE['%s-%s' % (dbse, '100SER-148ASN-1')] =    2.272  
BIND_BRONZE['%s-%s' % (dbse, '100THR-104LEU-1')] =   -0.602  
BIND_BRONZE['%s-%s' % (dbse, '100TRP-103LYS-1')] =  -11.665  
BIND_BRONZE['%s-%s' % (dbse, '100TRP-103LYS-2')] =   -1.347  
BIND_BRONZE['%s-%s' % (dbse, '100VAL-283ILE-1')] =   -0.619  
BIND_BRONZE['%s-%s' % (dbse, '101ALA-104ARG-1')] =   -0.183  
BIND_BRONZE['%s-%s' % (dbse, '101ALA-128ALA-1')] =   -0.691  
BIND_BRONZE['%s-%s' % (dbse, '101ALA-138TYR-1')] =   -1.506  
BIND_BRONZE['%s-%s' % (dbse, '101ARG-142LEU-1')] =   -2.015  
BIND_BRONZE['%s-%s' % (dbse, '101ASN-125HIE-1')] =   -3.094  
BIND_BRONZE['%s-%s' % (dbse, '101ASP-145THR-2')] =  -18.735  
BIND_BRONZE['%s-%s' % (dbse, '101ILE-110LEU-1')] =   -0.974  
BIND_BRONZE['%s-%s' % (dbse, '101ILE-110PHE-1')] =   -1.609  
BIND_BRONZE['%s-%s' % (dbse, '101ILE-123ILE-1')] =   -0.716  
BIND_BRONZE['%s-%s' % (dbse, '101LEU-111TRP-1')] =   -1.365  
BIND_BRONZE['%s-%s' % (dbse, '101LEU-125TYR-1')] =   -0.787  
BIND_BRONZE['%s-%s' % (dbse, '101LEU-132ILE-1')] =   -0.560  
BIND_BRONZE['%s-%s' % (dbse, '101TRP-132VAL-1')] =   -0.979  
BIND_BRONZE['%s-%s' % (dbse, '101TRP-135LYS-1')] =   -2.732  
BIND_BRONZE['%s-%s' % (dbse, '101TRP-177ILE-1')] =   -0.931  
BIND_BRONZE['%s-%s' % (dbse, '101TYR-151VAL-1')] =   -1.463  
BIND_BRONZE['%s-%s' % (dbse, '101VAL-106LYS-1')] =   -0.930  
BIND_BRONZE['%s-%s' % (dbse, '101VAL-132PHE-1')] =   -1.421  
BIND_BRONZE['%s-%s' % (dbse, '101VAL-132PHE-2')] =   -1.353  
BIND_BRONZE['%s-%s' % (dbse, '102ALA-114PHE-1')] =   -0.218  
BIND_BRONZE['%s-%s' % (dbse, '102ASP-106SER-1')] =   -2.469  
BIND_BRONZE['%s-%s' % (dbse, '102HIE-109TYR-1')] =   -3.706  
BIND_BRONZE['%s-%s' % (dbse, '102HIE-127GLU-1')] =   -0.812  
BIND_BRONZE['%s-%s' % (dbse, '102HIE-269HIE-1')] =   -4.934  
BIND_BRONZE['%s-%s' % (dbse, '102HIE-270TYR-1')] =   -2.050  
BIND_BRONZE['%s-%s' % (dbse, '102HIE-272GLN-1')] =   -5.442  
BIND_BRONZE['%s-%s' % (dbse, '102ILE-110ILE-1')] =   -0.544  
BIND_BRONZE['%s-%s' % (dbse, '102ILE-145ILE-1')] =   -0.559  
BIND_BRONZE['%s-%s' % (dbse, '102ILE-149TYR-1')] =   -1.212  
BIND_BRONZE['%s-%s' % (dbse, '102ILE-149TYR-2')] =   -2.178  
BIND_BRONZE['%s-%s' % (dbse, '102ILE-153PHE-1')] =   -0.785  
BIND_BRONZE['%s-%s' % (dbse, '102SER-165LYS-1')] =   -8.182  
BIND_BRONZE['%s-%s' % (dbse, '102SER-169ASP-1')] =  -17.948  
BIND_BRONZE['%s-%s' % (dbse, '102VAL-133PHE-1')] =   -0.950  
BIND_BRONZE['%s-%s' % (dbse, '103ASP-149TYR-1')] =  -22.315  
BIND_BRONZE['%s-%s' % (dbse, '103ASP-269HIE-1')] =  -11.093  
BIND_BRONZE['%s-%s' % (dbse, '103GLN-108PHE-1')] =   -3.664  
BIND_BRONZE['%s-%s' % (dbse, '103GLU-106LYS-1')] = -112.523  
BIND_BRONZE['%s-%s' % (dbse, '103GLU-108TRP-1')] =  -20.827  
BIND_BRONZE['%s-%s' % (dbse, '103GLU-177ASP-1')] =   81.930  
BIND_BRONZE['%s-%s' % (dbse, '103HIE-168TYR-1')] =  -11.536  
BIND_BRONZE['%s-%s' % (dbse, '103ILE-110VAL-1')] =   -0.571  
BIND_BRONZE['%s-%s' % (dbse, '103ILE-130VAL-1')] =   -0.626  
BIND_BRONZE['%s-%s' % (dbse, '103ILE-132PHE-1')] =   -0.789  
BIND_BRONZE['%s-%s' % (dbse, '103PHE-122MET-1')] =   -1.513  
BIND_BRONZE['%s-%s' % (dbse, '103PHE-127LEU-1')] =   -0.887  
BIND_BRONZE['%s-%s' % (dbse, '104ALA-125TYR-1')] =   -0.379  
BIND_BRONZE['%s-%s' % (dbse, '104MET-112ASN-1')] =   -0.968  
BIND_BRONZE['%s-%s' % (dbse, '104MET-133PHE-1')] =   -1.504  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-107ALA-1')] =   -0.713  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-129ILE-1')] =   -2.349  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-147LEU-1')] =   -0.485  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-166GLU-1')] =  -22.289  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-168LEU-1')] =   -1.649  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-169PRO-1')] =   -1.259  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-202PHE-1')] =   -4.064  
BIND_BRONZE['%s-%s' % (dbse, '104TRP-205GLU-1')] =   -1.129  
BIND_BRONZE['%s-%s' % (dbse, '104VAL-108ILE-1')] =   -0.656  
BIND_BRONZE['%s-%s' % (dbse, '104VAL-112SER-1')] =   -0.556  
BIND_BRONZE['%s-%s' % (dbse, '104VAL-126ILE-1')] =   -0.743  
BIND_BRONZE['%s-%s' % (dbse, '105ALA-115GLN-1')] =   -0.549  
BIND_BRONZE['%s-%s' % (dbse, '105ASN-139VAL-1')] =   -1.143  
BIND_BRONZE['%s-%s' % (dbse, '105ASN-146GLN-1')] =    0.945  
BIND_BRONZE['%s-%s' % (dbse, '105ASN-154ASN-1')] =    4.866  
BIND_BRONZE['%s-%s' % (dbse, '105ILE-128LEU-1')] =   -0.255  
BIND_BRONZE['%s-%s' % (dbse, '105ILE-131ALA-1')] =   -0.545  
BIND_BRONZE['%s-%s' % (dbse, '105ILE-135LEU-1')] =   -0.650  
BIND_BRONZE['%s-%s' % (dbse, '105LEU-114TRP-1')] =   -2.024  
BIND_BRONZE['%s-%s' % (dbse, '105LEU-168ILE-1')] =   -1.037  
BIND_BRONZE['%s-%s' % (dbse, '105LEU-175PHE-1')] =   -0.640  
BIND_BRONZE['%s-%s' % (dbse, '105PHE-127LEU-1')] =   -0.987  
BIND_BRONZE['%s-%s' % (dbse, '105PHE-130ARG-1')] =   -4.984  
BIND_BRONZE['%s-%s' % (dbse, '105PHE-130ARG-2')] =   -1.699  
BIND_BRONZE['%s-%s' % (dbse, '105PRO-128ILE-1')] =    0.165  
BIND_BRONZE['%s-%s' % (dbse, '105PRO-181TRP-1')] =   -8.326  
BIND_BRONZE['%s-%s' % (dbse, '105TYR-149HIE-1')] =   -3.496  
BIND_BRONZE['%s-%s' % (dbse, '106ASN-130HIE-1')] =    1.530  
BIND_BRONZE['%s-%s' % (dbse, '106ASP-133GLN-1')] =    5.004  
BIND_BRONZE['%s-%s' % (dbse, '106GLU-129LYS-1')] = -112.903  
BIND_BRONZE['%s-%s' % (dbse, '106ILE-168ILE-1')] =   -0.393  
BIND_BRONZE['%s-%s' % (dbse, '106LEU-126LEU-1')] =   -0.344  
BIND_BRONZE['%s-%s' % (dbse, '106LEU-149PHE-1')] =   -1.619  
BIND_BRONZE['%s-%s' % (dbse, '106LEU-149PHE-2')] =   -2.085  
BIND_BRONZE['%s-%s' % (dbse, '106PHE-109PHE-1')] =   -2.274  
BIND_BRONZE['%s-%s' % (dbse, '106PHE-178LYS-1')] =   -2.533  
BIND_BRONZE['%s-%s' % (dbse, '106SER-128PHE-1')] =    0.376  
BIND_BRONZE['%s-%s' % (dbse, '106TYR-112SER-1')] =   -1.062  
BIND_BRONZE['%s-%s' % (dbse, '106VAL-112LEU-1')] =   -0.662  
BIND_BRONZE['%s-%s' % (dbse, '107ASP-125ASN-1')] =  -23.988  
BIND_BRONZE['%s-%s' % (dbse, '107ILE-153TRP-1')] =   -0.918  
BIND_BRONZE['%s-%s' % (dbse, '107ILE-158MET-1')] =   -1.122  
BIND_BRONZE['%s-%s' % (dbse, '107THR-125ALA-1')] =   -0.652  
BIND_BRONZE['%s-%s' % (dbse, '107THR-129LYS-1')] =  -18.359  
BIND_BRONZE['%s-%s' % (dbse, '107VAL-147PHE-1')] =   -0.985  
BIND_BRONZE['%s-%s' % (dbse, '107VAL-147PHE-2')] =   -0.912  
BIND_BRONZE['%s-%s' % (dbse, '108ILE-122VAL-1')] =   -0.645  
BIND_BRONZE['%s-%s' % (dbse, '108ILE-146GLN-1')] =   -0.498  
BIND_BRONZE['%s-%s' % (dbse, '108LYS-131ALA-1')] =   -0.420  
BIND_BRONZE['%s-%s' % (dbse, '108LYS-160LEU-1')] =   -0.267  
BIND_BRONZE['%s-%s' % (dbse, '108PHE-125TRP-1')] =   -1.859  
BIND_BRONZE['%s-%s' % (dbse, '108PHE-127PHE-1')] =   -1.714  
BIND_BRONZE['%s-%s' % (dbse, '108PHE-150VAL-1')] =   -0.998  
BIND_BRONZE['%s-%s' % (dbse, '108TRP-151ASN-1')] =   -1.821  
BIND_BRONZE['%s-%s' % (dbse, '108TRP-155VAL-1')] =   -1.754  
BIND_BRONZE['%s-%s' % (dbse, '109ARG-115GLU-1')] = -112.937  
BIND_BRONZE['%s-%s' % (dbse, '109GLN-161GLU-1')] =   -1.475  
BIND_BRONZE['%s-%s' % (dbse, '109GLN-161GLU-2')] =  -13.009  
BIND_BRONZE['%s-%s' % (dbse, '109PHE-113ILE-1')] =   -2.137  
BIND_BRONZE['%s-%s' % (dbse, '109PHE-181ILE-1')] =   -0.954  
BIND_BRONZE['%s-%s' % (dbse, '109PHE-182VAL-1')] =   -1.338  
BIND_BRONZE['%s-%s' % (dbse, '109PHE-185VAL-1')] =   -1.246  
BIND_BRONZE['%s-%s' % (dbse, '109PHE-228TYR-1')] =   -2.724  
BIND_BRONZE['%s-%s' % (dbse, '109SER-137ASN-1')] =    1.747  
BIND_BRONZE['%s-%s' % (dbse, '109THR-131VAL-1')] =   -1.159  
BIND_BRONZE['%s-%s' % (dbse, '109THR-158MET-1')] =   -0.833  
BIND_BRONZE['%s-%s' % (dbse, '109VAL-164ILE-1')] =   -0.418  
BIND_BRONZE['%s-%s' % (dbse, '110ALA-161PRO-1')] =   -1.799  
BIND_BRONZE['%s-%s' % (dbse, '110ALA-164ILE-1')] =   -0.569  
BIND_BRONZE['%s-%s' % (dbse, '110GLU-129LYS-1')] = -114.176  
BIND_BRONZE['%s-%s' % (dbse, '110ILE-116PHE-1')] =   -1.120  
BIND_BRONZE['%s-%s' % (dbse, '110ILE-149ARG-1')] =   -1.167  
BIND_BRONZE['%s-%s' % (dbse, '110ILE-151VAL-1')] =   -1.048  
BIND_BRONZE['%s-%s' % (dbse, '110ILE-162VAL-1')] =   -0.919  
BIND_BRONZE['%s-%s' % (dbse, '110LEU-125VAL-1')] =   -0.406  
BIND_BRONZE['%s-%s' % (dbse, '110LEU-127ILE-1')] =   -0.387  
BIND_BRONZE['%s-%s' % (dbse, '110PHE-123ILE-1')] =   -0.299  
BIND_BRONZE['%s-%s' % (dbse, '110PHE-128PHE-1')] =   -1.698  
BIND_BRONZE['%s-%s' % (dbse, '110PHE-222TYR-1')] =   -3.442  
BIND_BRONZE['%s-%s' % (dbse, '110PHE-226LEU-1')] =   -1.146  
BIND_BRONZE['%s-%s' % (dbse, '110PHE-226LEU-2')] =   -1.255  
BIND_BRONZE['%s-%s' % (dbse, '110THR-127GLN-2')] =   -5.854  
BIND_BRONZE['%s-%s' % (dbse, '110THR-129TRP-1')] =   -5.791  
BIND_BRONZE['%s-%s' % (dbse, '111ASP-156SER-2')] =    8.696  
BIND_BRONZE['%s-%s' % (dbse, '111ASP-193HIE-1')] =   -9.934  
BIND_BRONZE['%s-%s' % (dbse, '111HIE-218LEU-1')] =   -2.462  
BIND_BRONZE['%s-%s' % (dbse, '111LEU-116ASN-1')] =   -0.897  
BIND_BRONZE['%s-%s' % (dbse, '111LEU-130TYR-1')] =   -1.319  
BIND_BRONZE['%s-%s' % (dbse, '111LEU-158LEU-1')] =   -0.479  
BIND_BRONZE['%s-%s' % (dbse, '111LEU-169LEU-1')] =   -0.484  
BIND_BRONZE['%s-%s' % (dbse, '111TRP-115GLN-1')] =   -4.343  
BIND_BRONZE['%s-%s' % (dbse, '111VAL-125ALA-1')] =   -0.517  
BIND_BRONZE['%s-%s' % (dbse, '112ALA-128PRO-1')] =   -0.876  
BIND_BRONZE['%s-%s' % (dbse, '112ALA-131VAL-1')] =   -0.892  
BIND_BRONZE['%s-%s' % (dbse, '112ARG-115ALA-1')] =   -1.827  
BIND_BRONZE['%s-%s' % (dbse, '112ARG-125PHE-1')] =   -2.123  
BIND_BRONZE['%s-%s' % (dbse, '112ARG-127GLN-1')] =   -1.611  
BIND_BRONZE['%s-%s' % (dbse, '112ASP-183GLU-1')] =   84.512  
BIND_BRONZE['%s-%s' % (dbse, '112ILE-125VAL-1')] =   -0.219  
BIND_BRONZE['%s-%s' % (dbse, '112ILE-142ILE-1')] =   -1.013  
BIND_BRONZE['%s-%s' % (dbse, '112LEU-142PHE-1')] =   -1.245  
BIND_BRONZE['%s-%s' % (dbse, '112LYS-127LEU-1')] =   -0.967  
BIND_BRONZE['%s-%s' % (dbse, '112PHE-121LEU-1')] =   -0.530  
BIND_BRONZE['%s-%s' % (dbse, '112PHE-125HIE-1')] =   -1.380  
BIND_BRONZE['%s-%s' % (dbse, '112TRP-119ARG-1')] =   -1.004  
BIND_BRONZE['%s-%s' % (dbse, '112TRP-119ARG-2')] =   -3.022  
BIND_BRONZE['%s-%s' % (dbse, '112TRP-120VAL-1')] =   -0.620  
BIND_BRONZE['%s-%s' % (dbse, '112TYR-125GLU-1')] =   -2.245  
BIND_BRONZE['%s-%s' % (dbse, '112TYR-128LEU-1')] =   -0.932  
BIND_BRONZE['%s-%s' % (dbse, '112TYR-190ARG-1')] =   -8.433  
BIND_BRONZE['%s-%s' % (dbse, '113ALA-118ASP-1')] =   -3.043  
BIND_BRONZE['%s-%s' % (dbse, '113ALA-120VAL-1')] =   -0.665  
BIND_BRONZE['%s-%s' % (dbse, '113ALA-122VAL-1')] =   -0.383  
BIND_BRONZE['%s-%s' % (dbse, '113ALA-225TRP-1')] =   -1.051  
BIND_BRONZE['%s-%s' % (dbse, '113ASP-195GLN-1')] =  -14.472  
BIND_BRONZE['%s-%s' % (dbse, '113ILE-131VAL-1')] =   -0.517  
BIND_BRONZE['%s-%s' % (dbse, '113ILE-164HIE-1')] =   -1.276  
BIND_BRONZE['%s-%s' % (dbse, '113ILE-185VAL-1')] =   -0.141  
BIND_BRONZE['%s-%s' % (dbse, '113ILE-190ARG-2')] =   -1.951  
BIND_BRONZE['%s-%s' % (dbse, '113ILE-232ALA-1')] =   -1.037  
BIND_BRONZE['%s-%s' % (dbse, '113LYS-117GLU-2')] =   -3.651  
BIND_BRONZE['%s-%s' % (dbse, '113LYS-170VAL-1')] =   -0.795  
BIND_BRONZE['%s-%s' % (dbse, '113LYS-173GLU-1')] = -123.389  
BIND_BRONZE['%s-%s' % (dbse, '113SER-120ILE-1')] =   -0.471  
BIND_BRONZE['%s-%s' % (dbse, '113TRP-119PHE-1')] =   -1.979  
BIND_BRONZE['%s-%s' % (dbse, '113TRP-124HIE-1')] =   -4.091  
BIND_BRONZE['%s-%s' % (dbse, '113TRP-126ALA-1')] =   -0.954  
BIND_BRONZE['%s-%s' % (dbse, '113TRP-171ASP-1')] =  -22.622  
BIND_BRONZE['%s-%s' % (dbse, '113TRP-178ILE-1')] =   -2.250  
BIND_BRONZE['%s-%s' % (dbse, '113TYR-124THR-1')] =   -1.132  
BIND_BRONZE['%s-%s' % (dbse, '113VAL-120HIE-2')] =   -2.014  
BIND_BRONZE['%s-%s' % (dbse, '113VAL-143PHE-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '114ALA-160ALA-1')] =   -0.534  
BIND_BRONZE['%s-%s' % (dbse, '114ASN-122ARG-2')] =   -0.766  
BIND_BRONZE['%s-%s' % (dbse, '114ASP-179LEU-1')] =   -4.673  
BIND_BRONZE['%s-%s' % (dbse, '114GLU-144ASN-1')] =   -7.883  
BIND_BRONZE['%s-%s' % (dbse, '114GLU-146ARG-1')] = -120.123  
BIND_BRONZE['%s-%s' % (dbse, '114LEU-118ILE-1')] =   -0.519  
BIND_BRONZE['%s-%s' % (dbse, '114LYS-225TRP-1')] =   -2.065  
BIND_BRONZE['%s-%s' % (dbse, '114VAL-167GLU-1')] =   -2.993  
BIND_BRONZE['%s-%s' % (dbse, '115ASN-124LEU-1')] =   -1.108  
BIND_BRONZE['%s-%s' % (dbse, '115ASP-156ASP-1')] =   83.904  
BIND_BRONZE['%s-%s' % (dbse, '115GLN-118ARG-1')] =   -2.644  
BIND_BRONZE['%s-%s' % (dbse, '115GLU-123PRO-1')] =   -1.102  
BIND_BRONZE['%s-%s' % (dbse, '115GLU-123PRO-2')] =   -4.011  
BIND_BRONZE['%s-%s' % (dbse, '115GLU-160GLU-1')] =   62.765  
BIND_BRONZE['%s-%s' % (dbse, '115GLU-163TYR-2')] =   -4.189  
BIND_BRONZE['%s-%s' % (dbse, '115MET-168TYR-1')] =   -0.779  
BIND_BRONZE['%s-%s' % (dbse, '115PRO-129TYR-1')] =   -2.587  
BIND_BRONZE['%s-%s' % (dbse, '115THR-138VAL-1')] =   -0.465  
BIND_BRONZE['%s-%s' % (dbse, '115THR-142GLU-1')] =  -19.674  
BIND_BRONZE['%s-%s' % (dbse, '115THR-142GLU-2')] =  -17.721  
BIND_BRONZE['%s-%s' % (dbse, '115VAL-122MET-1')] =   -0.699  
BIND_BRONZE['%s-%s' % (dbse, '115VAL-123PHE-1')] =   -0.815  
BIND_BRONZE['%s-%s' % (dbse, '115VAL-130ARG-1')] =   -2.481  
BIND_BRONZE['%s-%s' % (dbse, '116ALA-162PHE-1')] =   -1.258  
BIND_BRONZE['%s-%s' % (dbse, '116LYS-144SER-1')] =   -8.939  
BIND_BRONZE['%s-%s' % (dbse, '116PHE-130VAL-1')] =   -0.457  
BIND_BRONZE['%s-%s' % (dbse, '116PHE-165VAL-1')] =   -0.978  
BIND_BRONZE['%s-%s' % (dbse, '117HIE-123PRO-1')] =   -1.418  
BIND_BRONZE['%s-%s' % (dbse, '117ILE-142PHE-1')] =   -1.155  
BIND_BRONZE['%s-%s' % (dbse, '117PHE-125TYR-1')] =   -2.116  
BIND_BRONZE['%s-%s' % (dbse, '117PHE-130HIE-1')] =   -1.460  
BIND_BRONZE['%s-%s' % (dbse, '117PRO-126ALA-1')] =   -0.860  
BIND_BRONZE['%s-%s' % (dbse, '117PRO-129TYR-1')] =    0.942  
BIND_BRONZE['%s-%s' % (dbse, '117PRO-130LYS-1')] =   -0.541  
BIND_BRONZE['%s-%s' % (dbse, '117VAL-166ILE-1')] =   -0.681  
BIND_BRONZE['%s-%s' % (dbse, '118ALA-160VAL-1')] =   -0.264  
BIND_BRONZE['%s-%s' % (dbse, '118ARG-157ASN-1')] =    9.176  
BIND_BRONZE['%s-%s' % (dbse, '118ARG-185ARG-1')] =   62.481  
BIND_BRONZE['%s-%s' % (dbse, '118ASP-136HIE-1')] =  -26.433  
BIND_BRONZE['%s-%s' % (dbse, '118GLN-121PHE-1')] =   -1.360  
BIND_BRONZE['%s-%s' % (dbse, '118GLU-173PHE-1')] =   -4.478  
BIND_BRONZE['%s-%s' % (dbse, '118GLU-176THR-1')] =   -0.738  
BIND_BRONZE['%s-%s' % (dbse, '118ILE-136VAL-1')] =   -0.499  
BIND_BRONZE['%s-%s' % (dbse, '118ILE-165ALA-1')] =   -0.402  
BIND_BRONZE['%s-%s' % (dbse, '118ILE-166TYR-1')] =   -1.190  
BIND_BRONZE['%s-%s' % (dbse, '118ILE-178TYR-1')] =   -1.092  
BIND_BRONZE['%s-%s' % (dbse, '118THR-121LEU-1')] =   -1.030  
BIND_BRONZE['%s-%s' % (dbse, '118VAL-162PHE-1')] =   -0.561  
BIND_BRONZE['%s-%s' % (dbse, '119ALA-160LEU-1')] =   -0.563  
BIND_BRONZE['%s-%s' % (dbse, '119CYS-168HIE-1')] =   -3.632  
BIND_BRONZE['%s-%s' % (dbse, '119LEU-137ALA-1')] =   -0.023  
BIND_BRONZE['%s-%s' % (dbse, '119LEU-137ALA-2')] =   -0.410  
BIND_BRONZE['%s-%s' % (dbse, '119LYS-186VAL-1')] =   -0.687  
BIND_BRONZE['%s-%s' % (dbse, '119MET-144SER-1')] =   -1.036  
BIND_BRONZE['%s-%s' % (dbse, '119PHE-124HIE-1')] =   -2.762  
BIND_BRONZE['%s-%s' % (dbse, '119PHE-176THR-1')] =   -1.064  
BIND_BRONZE['%s-%s' % (dbse, '119SER-123ARG-1')] =   -2.749  
BIND_BRONZE['%s-%s' % (dbse, '119SER-140TYR-1')] =   -0.598  
BIND_BRONZE['%s-%s' % (dbse, '119THR-123THR-1')] =   -0.945  
BIND_BRONZE['%s-%s' % (dbse, '119THR-123THR-2')] =   -0.392  
BIND_BRONZE['%s-%s' % (dbse, '119TYR-174ILE-1')] =   -1.028  
BIND_BRONZE['%s-%s' % (dbse, '120HIE-185ARG-1')] =   -0.886  
BIND_BRONZE['%s-%s' % (dbse, '120ILE-123TYR-1')] =   -1.526  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-123ASN-1')] =   -0.522  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-124ASP-1')] =   -2.838  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-124LEU-1')] =   -1.253  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-135ILE-1')] =   -0.745  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-171TYR-1')] =   -1.407  
BIND_BRONZE['%s-%s' % (dbse, '120LEU-171TYR-2')] =   -1.756  
BIND_BRONZE['%s-%s' % (dbse, '120LYS-138VAL-1')] =   -0.843  
BIND_BRONZE['%s-%s' % (dbse, '120LYS-142ASP-1')] =  -98.714  
BIND_BRONZE['%s-%s' % (dbse, '120PRO-126ALA-1')] =   -0.544  
BIND_BRONZE['%s-%s' % (dbse, '120SER-136HIE-1')] =   -1.357  
BIND_BRONZE['%s-%s' % (dbse, '120THR-143VAL-1')] =   -0.333  
BIND_BRONZE['%s-%s' % (dbse, '120THR-147GLU-1')] =  -19.814  
BIND_BRONZE['%s-%s' % (dbse, '120TYR-141PHE-1')] =   -1.338  
BIND_BRONZE['%s-%s' % (dbse, '120VAL-123ILE-1')] =   -0.819  
BIND_BRONZE['%s-%s' % (dbse, '120VAL-154ILE-1')] =   -0.822  
BIND_BRONZE['%s-%s' % (dbse, '120VAL-275LEU-1')] =   -0.475  
BIND_BRONZE['%s-%s' % (dbse, '121ASN-132THR-1')] =   -1.112  
BIND_BRONZE['%s-%s' % (dbse, '121GLN-144ARG-1')] =  -22.151  
BIND_BRONZE['%s-%s' % (dbse, '121LEU-125HIE-1')] =   -0.761  
BIND_BRONZE['%s-%s' % (dbse, '121LEU-125HIE-2')] =   -0.764  
BIND_BRONZE['%s-%s' % (dbse, '121PHE-126VAL-1')] =   -1.247  
BIND_BRONZE['%s-%s' % (dbse, '121PHE-191LEU-1')] =   -0.777  
BIND_BRONZE['%s-%s' % (dbse, '121PHE-219TRP-1')] =   -1.718  
BIND_BRONZE['%s-%s' % (dbse, '121TYR-125LEU-2')] =   -2.069  
BIND_BRONZE['%s-%s' % (dbse, '121VAL-157ASP-1')] =   -0.929  
BIND_BRONZE['%s-%s' % (dbse, '122ASP-125LYS-1')] =   -3.863  
BIND_BRONZE['%s-%s' % (dbse, '122LEU-188VAL-1')] =   -0.516  
BIND_BRONZE['%s-%s' % (dbse, '122MET-126GLU-1')] =   -7.993  
BIND_BRONZE['%s-%s' % (dbse, '122VAL-125ILE-1')] =   -1.432  
BIND_BRONZE['%s-%s' % (dbse, '122VAL-143VAL-1')] =   -0.673  
BIND_BRONZE['%s-%s' % (dbse, '122VAL-152PHE-1')] =   -1.688  
BIND_BRONZE['%s-%s' % (dbse, '123ALA-128VAL-1')] =   -0.500  
BIND_BRONZE['%s-%s' % (dbse, '123ALA-158ILE-1')] =    1.683  
BIND_BRONZE['%s-%s' % (dbse, '123ARG-127GLN-1')] =   -2.840  
BIND_BRONZE['%s-%s' % (dbse, '123MET-140ASN-1')] =   -0.838  # altered
BIND_BRONZE['%s-%s' % (dbse, '123SER-182ASN-1')] =   -0.739  
BIND_BRONZE['%s-%s' % (dbse, '123THR-136SER-1')] =   -4.322  
BIND_BRONZE['%s-%s' % (dbse, '123TYR-154VAL-1')] =   -0.981  
BIND_BRONZE['%s-%s' % (dbse, '123VAL-134LEU-1')] =   -0.399  
BIND_BRONZE['%s-%s' % (dbse, '124ALA-156THR-1')] =   -0.459  
BIND_BRONZE['%s-%s' % (dbse, '124ASP-131THR-1')] =    4.382  
BIND_BRONZE['%s-%s' % (dbse, '124ASP-132THR-1')] =  -20.062  
BIND_BRONZE['%s-%s' % (dbse, '124ASP-134ARG-1')] = -112.213  
BIND_BRONZE['%s-%s' % (dbse, '124GLN-200ALA-1')] =   -0.865  
BIND_BRONZE['%s-%s' % (dbse, '124HIE-140GLU-1')] =  -25.251  
BIND_BRONZE['%s-%s' % (dbse, '124HIE-143VAL-1')] =   -0.516  
BIND_BRONZE['%s-%s' % (dbse, '124LEU-136HIE-2')] =   -1.478  
BIND_BRONZE['%s-%s' % (dbse, '124LEU-181VAL-1')] =   -0.402  
BIND_BRONZE['%s-%s' % (dbse, '125GLU-192PHE-1')] =   -5.300  
BIND_BRONZE['%s-%s' % (dbse, '125ILE-136TYR-1')] =   -0.798  
BIND_BRONZE['%s-%s' % (dbse, '125LEU-129LEU-1')] =   -1.269  
BIND_BRONZE['%s-%s' % (dbse, '125PHE-143VAL-1')] =   -1.270  
BIND_BRONZE['%s-%s' % (dbse, '125TRP-138SER-1')] =   -4.298  
BIND_BRONZE['%s-%s' % (dbse, '125TRP-150VAL-1')] =   -1.181  
BIND_BRONZE['%s-%s' % (dbse, '125TRP-152LEU-1')] =   -1.984  
BIND_BRONZE['%s-%s' % (dbse, '125TYR-164HIE-1')] =   -3.128  
BIND_BRONZE['%s-%s' % (dbse, '126ALA-140GLU-1')] =   -0.877  
BIND_BRONZE['%s-%s' % (dbse, '126ASN-129ASN-1')] =   -1.951  
BIND_BRONZE['%s-%s' % (dbse, '126GLU-130ARG-1')] = -104.489  
BIND_BRONZE['%s-%s' % (dbse, '126ILE-136PRO-1')] =   -0.791  
BIND_BRONZE['%s-%s' % (dbse, '126ILE-139PHE-1')] =   -1.268  
BIND_BRONZE['%s-%s' % (dbse, '126ILE-139PHE-2')] =   -2.679  
BIND_BRONZE['%s-%s' % (dbse, '126LEU-130HIE-2')] =   -1.111  
BIND_BRONZE['%s-%s' % (dbse, '126LEU-162PHE-1')] =   -0.926  
BIND_BRONZE['%s-%s' % (dbse, '126LYS-158ILE-1')] =   -0.662  
BIND_BRONZE['%s-%s' % (dbse, '126PHE-132HIE-1')] =   -1.560  
BIND_BRONZE['%s-%s' % (dbse, '126PHE-171TYR-1')] =   -2.608  
BIND_BRONZE['%s-%s' % (dbse, '126PHE-176TYR-1')] =   -2.864  
BIND_BRONZE['%s-%s' % (dbse, '126SER-171ILE-1')] =   -0.653  
BIND_BRONZE['%s-%s' % (dbse, '126THR-197TYR-1')] =   -1.295  
BIND_BRONZE['%s-%s' % (dbse, '127ALA-177ASP-1')] =   -2.375  
BIND_BRONZE['%s-%s' % (dbse, '127GLU-146ARG-2')] =  -97.074  
BIND_BRONZE['%s-%s' % (dbse, '127GLU-269HIE-1')] =   -1.184  
BIND_BRONZE['%s-%s' % (dbse, '127GLU-269HIE-2')] =   13.301  
BIND_BRONZE['%s-%s' % (dbse, '127LEU-210VAL-1')] =   -0.439  
BIND_BRONZE['%s-%s' % (dbse, '127MET-131LYS-1')] =   -0.418  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-132ILE-1')] =   -1.354  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-133SER-1')] =   -0.953  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-138SER-1')] =   -1.630  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-140HIE-1')] =   -3.670  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-158VAL-1')] =   -0.929  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-183TYR-1')] =   -2.351  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-206ILE-1')] =   -1.111  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-237ASN-1')] =   -0.910  
BIND_BRONZE['%s-%s' % (dbse, '127PHE-239PHE-1')] =   -3.119  
BIND_BRONZE['%s-%s' % (dbse, '128ILE-131LEU-1')] =   -0.576  
BIND_BRONZE['%s-%s' % (dbse, '128LYS-183TYR-1')] =   -2.515  
BIND_BRONZE['%s-%s' % (dbse, '128PHE-235LEU-1')] =   -0.707  
BIND_BRONZE['%s-%s' % (dbse, '128PHE-252LEU-1')] =   -0.612  
BIND_BRONZE['%s-%s' % (dbse, '128PRO-275LEU-1')] =   -1.049  
BIND_BRONZE['%s-%s' % (dbse, '128TYR-158MET-1')] =   -3.039  
BIND_BRONZE['%s-%s' % (dbse, '128TYR-160LEU-1')] =   -1.193  
BIND_BRONZE['%s-%s' % (dbse, '128VAL-160LEU-1')] =   -0.827  
BIND_BRONZE['%s-%s' % (dbse, '129ASN-132TYR-1')] =   -3.662  
BIND_BRONZE['%s-%s' % (dbse, '129ASP-140HIE-1')] =  -25.298  
BIND_BRONZE['%s-%s' % (dbse, '129ASP-148TYR-1')] =   -2.010  
BIND_BRONZE['%s-%s' % (dbse, '129LEU-155PHE-1')] =   -0.932  
BIND_BRONZE['%s-%s' % (dbse, '129LEU-192PHE-1')] =   -1.478  
BIND_BRONZE['%s-%s' % (dbse, '129LEU-195PRO-1')] =   -0.241  
BIND_BRONZE['%s-%s' % (dbse, '129LEU-277TYR-1')] =   -1.887  
BIND_BRONZE['%s-%s' % (dbse, '129LEU-277TYR-2')] =   -1.148  
BIND_BRONZE['%s-%s' % (dbse, '129PHE-133VAL-1')] =   -0.915  
BIND_BRONZE['%s-%s' % (dbse, '129PHE-156ARG-1')] =   -7.237  
BIND_BRONZE['%s-%s' % (dbse, '129PHE-166PRO-1')] =   -2.078  
BIND_BRONZE['%s-%s' % (dbse, '129TYR-133ARG-1')] =   -8.366  
BIND_BRONZE['%s-%s' % (dbse, '129TYR-136TYR-2')] =   -3.449  
BIND_BRONZE['%s-%s' % (dbse, '129VAL-159PHE-1')] =   -1.191  
BIND_BRONZE['%s-%s' % (dbse, '129VAL-184PHE-1')] =   -1.782  
BIND_BRONZE['%s-%s' % (dbse, '130ARG-170TYR-2')] =   -3.240  
BIND_BRONZE['%s-%s' % (dbse, '130ARG-244ILE-1')] =   -1.994  
BIND_BRONZE['%s-%s' % (dbse, '130ARG-248GLU-1')] =  -76.254  # altered
BIND_BRONZE['%s-%s' % (dbse, '130GLN-134GLU-1')] =  -16.911  
BIND_BRONZE['%s-%s' % (dbse, '130GLN-137ARG-1')] =    0.296  
BIND_BRONZE['%s-%s' % (dbse, '130PRO-135ILE-1')] =   -1.008  
BIND_BRONZE['%s-%s' % (dbse, '130PRO-139ILE-1')] =   -0.600  
BIND_BRONZE['%s-%s' % (dbse, '130PRO-180PRO-1')] =   -1.026  
BIND_BRONZE['%s-%s' % (dbse, '130SER-149HIE-1')] =   -8.715  
BIND_BRONZE['%s-%s' % (dbse, '130SER-153TRP-1')] =   -5.778  
BIND_BRONZE['%s-%s' % (dbse, '130VAL-139ILE-1')] =    0.192  
BIND_BRONZE['%s-%s' % (dbse, '130VAL-162VAL-1')] =   -0.569  
BIND_BRONZE['%s-%s' % (dbse, '130VAL-185PHE-1')] =   -1.007  
BIND_BRONZE['%s-%s' % (dbse, '131ALA-140HIE-1')] =   -0.768  
BIND_BRONZE['%s-%s' % (dbse, '131ARG-134GLU-2')] =  -79.461  
BIND_BRONZE['%s-%s' % (dbse, '131ASP-147PHE-1')] =   -1.492  
BIND_BRONZE['%s-%s' % (dbse, '131ASP-182PHE-1')] =   -3.467  
BIND_BRONZE['%s-%s' % (dbse, '131LEU-136VAL-1')] =   -0.045  
BIND_BRONZE['%s-%s' % (dbse, '131LEU-160MET-1')] =   -0.754  
BIND_BRONZE['%s-%s' % (dbse, '131PRO-219VAL-1')] =   -0.655  
BIND_BRONZE['%s-%s' % (dbse, '131PRO-220GLU-1')] =   -4.104  
BIND_BRONZE['%s-%s' % (dbse, '131THR-149LEU-1')] =   -0.551  
BIND_BRONZE['%s-%s' % (dbse, '132ARG-136ARG-1')] =   -2.623  
BIND_BRONZE['%s-%s' % (dbse, '132ASP-156ARG-1')] = -102.493  
BIND_BRONZE['%s-%s' % (dbse, '132HIE-135LYS-1')] =   -1.072  
BIND_BRONZE['%s-%s' % (dbse, '132HIE-147ASP-1')] =  -26.174  
BIND_BRONZE['%s-%s' % (dbse, '132HIE-149ASN-1')] =   -1.503  
BIND_BRONZE['%s-%s' % (dbse, '132ILE-135PHE-1')] =   -0.891  
BIND_BRONZE['%s-%s' % (dbse, '132ILE-138TRP-1')] =   -0.032  
BIND_BRONZE['%s-%s' % (dbse, '132ILE-146TRP-1')] =   -0.937  
BIND_BRONZE['%s-%s' % (dbse, '132LEU-198PHE-1')] =   -0.953  
BIND_BRONZE['%s-%s' % (dbse, '132PHE-162VAL-1')] =   -1.506  
BIND_BRONZE['%s-%s' % (dbse, '132PHE-174SER-1')] =   -1.844  
BIND_BRONZE['%s-%s' % (dbse, '132PHE-176VAL-1')] =   -1.316  
BIND_BRONZE['%s-%s' % (dbse, '132PHE-183GLN-1')] =   -1.907  
BIND_BRONZE['%s-%s' % (dbse, '132TYR-136PRO-1')] =   -1.859  
BIND_BRONZE['%s-%s' % (dbse, '133LYS-136ASP-1')] = -102.652  
BIND_BRONZE['%s-%s' % (dbse, '133LYS-198PHE-1')] =   -1.428  
BIND_BRONZE['%s-%s' % (dbse, '133PRO-151ASP-1')] =   -5.059  
BIND_BRONZE['%s-%s' % (dbse, '133SER-161GLU-1')] =  -17.873  
BIND_BRONZE['%s-%s' % (dbse, '133TRP-143MET-2')] =   -2.535  
BIND_BRONZE['%s-%s' % (dbse, '133TRP-148VAL-1')] =    0.616  
BIND_BRONZE['%s-%s' % (dbse, '133TRP-277TYR-1')] =    1.109  
BIND_BRONZE['%s-%s' % (dbse, '133VAL-137ARG-1')] =   -2.749  
BIND_BRONZE['%s-%s' % (dbse, '133VAL-146TRP-1')] =   -2.047  
BIND_BRONZE['%s-%s' % (dbse, '134GLU-138ARG-1')] = -104.202  
BIND_BRONZE['%s-%s' % (dbse, '134ILE-147ASP-1')] =   -2.932  
BIND_BRONZE['%s-%s' % (dbse, '134ILE-167LEU-1')] =   -0.400  
BIND_BRONZE['%s-%s' % (dbse, '134LEU-205TYR-1')] =   -1.592  
BIND_BRONZE['%s-%s' % (dbse, '135ARG-193VAL-1')] =   -2.011  
BIND_BRONZE['%s-%s' % (dbse, '135ILE-180PRO-1')] =   -0.842  
BIND_BRONZE['%s-%s' % (dbse, '135LEU-139LEU-1')] =   -1.134  
BIND_BRONZE['%s-%s' % (dbse, '135LEU-163LEU-1')] =   -0.246  
BIND_BRONZE['%s-%s' % (dbse, '135LEU-179LEU-1')] =   -0.327  
BIND_BRONZE['%s-%s' % (dbse, '135LYS-157GLU-1')] = -104.992  
BIND_BRONZE['%s-%s' % (dbse, '135LYS-177ILE-1')] =   -0.916  
BIND_BRONZE['%s-%s' % (dbse, '135PHE-147TYR-1')] =   -3.078  
BIND_BRONZE['%s-%s' % (dbse, '135PRO-140SER-1')] =   -0.812  
BIND_BRONZE['%s-%s' % (dbse, '135PRO-144LEU-1')] =   -0.912  
BIND_BRONZE['%s-%s' % (dbse, '135PRO-155PHE-1')] =   -1.613  
BIND_BRONZE['%s-%s' % (dbse, '135TRP-147GLN-1')] =   -6.277  
BIND_BRONZE['%s-%s' % (dbse, '135TRP-208ILE-1')] =   -1.139  
BIND_BRONZE['%s-%s' % (dbse, '136ARG-142ALA-1')] =   -2.207  
BIND_BRONZE['%s-%s' % (dbse, '136ASP-198PHE-1')] =   -7.051  
BIND_BRONZE['%s-%s' % (dbse, '136ASP-201VAL-1')] =   -3.229  
BIND_BRONZE['%s-%s' % (dbse, '136CYS-143PHE-1')] =   -2.215  
BIND_BRONZE['%s-%s' % (dbse, '136PHE-141ALA-1')] =   -0.792  
BIND_BRONZE['%s-%s' % (dbse, '136PHE-146TRP-1')] =   -2.248  
BIND_BRONZE['%s-%s' % (dbse, '136SER-144ARG-1')] =  -14.594  
BIND_BRONZE['%s-%s' % (dbse, '136TRP-155CYS-1')] =   -1.402  
BIND_BRONZE['%s-%s' % (dbse, '136TRP-165ASP-1')] =  -23.107  
BIND_BRONZE['%s-%s' % (dbse, '136TRP-179MET-1')] =   -1.461  
BIND_BRONZE['%s-%s' % (dbse, '136VAL-169LEU-1')] =   -0.638  
BIND_BRONZE['%s-%s' % (dbse, '137ARG-154TRP-1')] =   -2.695  
BIND_BRONZE['%s-%s' % (dbse, '137ARG-154TRP-2')] =   -6.667  
BIND_BRONZE['%s-%s' % (dbse, '137ARG-157GLU-1')] = -100.865  
BIND_BRONZE['%s-%s' % (dbse, '137GLU-143MET-1')] =   -5.200  
BIND_BRONZE['%s-%s' % (dbse, '137SER-156ARG-1')] =   -0.926  
BIND_BRONZE['%s-%s' % (dbse, '137TYR-166SER-1')] =   -0.210  
BIND_BRONZE['%s-%s' % (dbse, '138ARG-142GLU-1')] =  -92.395  
BIND_BRONZE['%s-%s' % (dbse, '138ILE-156ARG-1')] =   -1.860  
BIND_BRONZE['%s-%s' % (dbse, '138LEU-149PHE-1')] =   -1.200  
BIND_BRONZE['%s-%s' % (dbse, '138PHE-153PHE-1')] =   -2.709  
BIND_BRONZE['%s-%s' % (dbse, '138SER-169VAL-1')] =   -0.817  
BIND_BRONZE['%s-%s' % (dbse, '138TRP-146PHE-1')] =   -4.353  
BIND_BRONZE['%s-%s' % (dbse, '138TRP-243LEU-1')] =   -0.240  
BIND_BRONZE['%s-%s' % (dbse, '138VAL-144ARG-1')] =   -1.640  
BIND_BRONZE['%s-%s' % (dbse, '139ASN-154SER-1')] =   -5.044  
BIND_BRONZE['%s-%s' % (dbse, '139GLU-144LYS-1')] = -115.906  
BIND_BRONZE['%s-%s' % (dbse, '139ILE-143TRP-1')] =   -1.278  
BIND_BRONZE['%s-%s' % (dbse, '139LEU-204TYR-1')] =   -1.343  
BIND_BRONZE['%s-%s' % (dbse, '139PRO-180PRO-1')] =   -1.357  
BIND_BRONZE['%s-%s' % (dbse, '139TYR-148SER-1')] =   -1.537  
BIND_BRONZE['%s-%s' % (dbse, '140GLU-143VAL-1')] =   -3.831  
BIND_BRONZE['%s-%s' % (dbse, '140GLU-155THR-1')] =  -16.822  
BIND_BRONZE['%s-%s' % (dbse, '140GLU-156ARG-1')] = -118.853  
BIND_BRONZE['%s-%s' % (dbse, '140LEU-168LEU-1')] =   -0.157  
BIND_BRONZE['%s-%s' % (dbse, '141GLN-160PHE-1')] =   -0.870  
BIND_BRONZE['%s-%s' % (dbse, '141LYS-144GLU-1')] = -110.749  
BIND_BRONZE['%s-%s' % (dbse, '141MET-155ILE-1')] =   -0.582  
BIND_BRONZE['%s-%s' % (dbse, '141PHE-152PHE-1')] =   -2.277  
BIND_BRONZE['%s-%s' % (dbse, '141SER-144ASP-1')] =  -13.824  
BIND_BRONZE['%s-%s' % (dbse, '141SER-154ILE-1')] =   -0.365  
BIND_BRONZE['%s-%s' % (dbse, '142GLN-154GLN-1')] =   -5.355  
BIND_BRONZE['%s-%s' % (dbse, '142ILE-155LEU-1')] =   -0.460  
BIND_BRONZE['%s-%s' % (dbse, '142ILE-155LEU-2')] =   -0.686  
BIND_BRONZE['%s-%s' % (dbse, '142ILE-185VAL-1')] =   -0.930  
BIND_BRONZE['%s-%s' % (dbse, '142PHE-170ARG-1')] =   -0.877  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-147LYS-1')] =   -9.243  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-148TYR-1')] =   -3.814  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-150VAL-1')] =   -0.131  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-160PHE-1')] =   -4.125  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-170ILE-1')] =   -2.091  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-199THR-1')] =   -1.253  
BIND_BRONZE['%s-%s' % (dbse, '142TYR-203VAL-1')] =   -0.833  
BIND_BRONZE['%s-%s' % (dbse, '143ARG-187ASP-1')] = -115.756  
BIND_BRONZE['%s-%s' % (dbse, '143ARG-188LYS-1')] =   62.433  
BIND_BRONZE['%s-%s' % (dbse, '143GLN-147GLU-1')] =  -23.238  
BIND_BRONZE['%s-%s' % (dbse, '143ILE-146VAL-1')] =   -0.481  
BIND_BRONZE['%s-%s' % (dbse, '143LEU-160ARG-1')] =   -2.599  
BIND_BRONZE['%s-%s' % (dbse, '143TRP-146LYS-1')] =   -4.979  
BIND_BRONZE['%s-%s' % (dbse, '143TYR-150ILE-1')] =   -1.920  
BIND_BRONZE['%s-%s' % (dbse, '143VAL-147LEU-1')] =   -0.639  
BIND_BRONZE['%s-%s' % (dbse, '143VAL-152PHE-1')] =   -1.019  
BIND_BRONZE['%s-%s' % (dbse, '144ARG-147GLU-2')] =  -92.266  
BIND_BRONZE['%s-%s' % (dbse, '144ASP-150SER-1')] =  -15.311  
BIND_BRONZE['%s-%s' % (dbse, '144ILE-155THR-1')] =   -0.893  
BIND_BRONZE['%s-%s' % (dbse, '144LYS-161GLU-1')] = -121.722  
BIND_BRONZE['%s-%s' % (dbse, '144PHE-153LYS-1')] =   -2.125  
BIND_BRONZE['%s-%s' % (dbse, '144PHE-155ILE-1')] =   -0.727  
BIND_BRONZE['%s-%s' % (dbse, '145GLN-149MET-2')] =    3.732  
BIND_BRONZE['%s-%s' % (dbse, '145LEU-149PHE-1')] =   -0.954  
BIND_BRONZE['%s-%s' % (dbse, '145THR-149PHE-1')] =   -0.690  
BIND_BRONZE['%s-%s' % (dbse, '146ARG-207GLU-1')] = -118.447  
BIND_BRONZE['%s-%s' % (dbse, '146GLU-158SER-1')] =    9.556  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-149PHE-1')] =   -2.816  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-150LEU-2')] =   -1.751  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-150VAL-1')] =   -1.516  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-164TRP-1')] =   -1.241  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-165PHE-1')] =   -1.154  
BIND_BRONZE['%s-%s' % (dbse, '146PHE-199LYS-2')] =   -1.891  
BIND_BRONZE['%s-%s' % (dbse, '146VAL-161VAL-1')] =   -0.612  
BIND_BRONZE['%s-%s' % (dbse, '146VAL-161VAL-2')] =   -0.494  
BIND_BRONZE['%s-%s' % (dbse, '146VAL-165HIE-1')] =   -1.486  
BIND_BRONZE['%s-%s' % (dbse, '147ASP-171TYR-1')] =  -25.521  
BIND_BRONZE['%s-%s' % (dbse, '147ASP-188LYS-1')] = -110.705  
BIND_BRONZE['%s-%s' % (dbse, '147LYS-203VAL-1')] =   -0.619  
BIND_BRONZE['%s-%s' % (dbse, '147PHE-159PHE-1')] =   -2.897  
BIND_BRONZE['%s-%s' % (dbse, '147PHE-182PHE-1')] =   -1.968  
BIND_BRONZE['%s-%s' % (dbse, '147VAL-175SER-1')] =   -0.819  
BIND_BRONZE['%s-%s' % (dbse, '148ALA-158LEU-1')] =   -0.579  
BIND_BRONZE['%s-%s' % (dbse, '148HIE-152GLU-1')] =   -3.238  
BIND_BRONZE['%s-%s' % (dbse, '148ILE-202VAL-1')] =   -0.589  
BIND_BRONZE['%s-%s' % (dbse, '148ILE-204ARG-1')] =   -2.349  
BIND_BRONZE['%s-%s' % (dbse, '148PHE-164HIE-1')] =   -2.787  
BIND_BRONZE['%s-%s' % (dbse, '148PHE-165TYR-1')] =   -3.461  
BIND_BRONZE['%s-%s' % (dbse, '148SER-163ALA-1')] =   -0.818  
BIND_BRONZE['%s-%s' % (dbse, '148TYR-170ILE-1')] =   -1.256  
BIND_BRONZE['%s-%s' % (dbse, '149ASN-167THR-1')] =   -1.082  
BIND_BRONZE['%s-%s' % (dbse, '149ASN-171TYR-1')] =   -4.985  
BIND_BRONZE['%s-%s' % (dbse, '149ASN-175SER-1')] =   -2.995  
BIND_BRONZE['%s-%s' % (dbse, '149ASN-177ASP-1')] =   -6.300  
BIND_BRONZE['%s-%s' % (dbse, '149LEU-152GLN-1')] =   -0.493  
BIND_BRONZE['%s-%s' % (dbse, '149PHE-159ILE-1')] =   -1.938  
BIND_BRONZE['%s-%s' % (dbse, '149PHE-164PHE-1')] =   -1.187  
BIND_BRONZE['%s-%s' % (dbse, '149PHE-165PHE-1')] =   -1.747  
BIND_BRONZE['%s-%s' % (dbse, '149PHE-169VAL-1')] =   -0.622  
BIND_BRONZE['%s-%s' % (dbse, '149PRO-152GLN-1')] =   -3.100  
BIND_BRONZE['%s-%s' % (dbse, '149PRO-152PHE-1')] =   -0.918  
BIND_BRONZE['%s-%s' % (dbse, '149THR-157PRO-1')] =   -0.941  
BIND_BRONZE['%s-%s' % (dbse, '149TYR-153PHE-1')] =   -2.767  
BIND_BRONZE['%s-%s' % (dbse, '150ARG-157ASP-1')] = -112.822  
BIND_BRONZE['%s-%s' % (dbse, '150ARG-208ILE-1')] =   -2.185  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-153PHE-1')] =   -0.858  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-154TYR-1')] =   -0.549  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-159PHE-1')] =   -1.202  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-167LEU-1')] =   -0.437  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-170HIE-1')] =   -1.034  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-202LEU-1')] =   -0.869  
BIND_BRONZE['%s-%s' % (dbse, '150LEU-203GLU-1')] =   -2.399  
BIND_BRONZE['%s-%s' % (dbse, '150LYS-158LEU-1')] =   -0.539  
BIND_BRONZE['%s-%s' % (dbse, '151ILE-159VAL-1')] =    0.022  
BIND_BRONZE['%s-%s' % (dbse, '151SER-159PHE-1')] =   -2.209  
BIND_BRONZE['%s-%s' % (dbse, '151THR-163THR-1')] =    5.382  
BIND_BRONZE['%s-%s' % (dbse, '152ASP-156LYS-1')] =   -5.129  
BIND_BRONZE['%s-%s' % (dbse, '152ASP-158LEU-1')] =   -1.264  
BIND_BRONZE['%s-%s' % (dbse, '152CYS-197VAL-1')] =    0.517  
BIND_BRONZE['%s-%s' % (dbse, '152LYS-156ASP-2')] = -114.785  
BIND_BRONZE['%s-%s' % (dbse, '152LYS-277TYR-1')] =   -2.651  
BIND_BRONZE['%s-%s' % (dbse, '153ASP-156ARG-1')] =  -67.178  
BIND_BRONZE['%s-%s' % (dbse, '153ASP-200ARG-1')] = -105.913  
BIND_BRONZE['%s-%s' % (dbse, '153LYS-203GLU-1')] = -115.035  
BIND_BRONZE['%s-%s' % (dbse, '153PHE-163LEU-1')] =   -1.189  
BIND_BRONZE['%s-%s' % (dbse, '153TRP-158MET-1')] =   -2.772  
BIND_BRONZE['%s-%s' % (dbse, '154ARG-204ARG-1')] =   61.774  
BIND_BRONZE['%s-%s' % (dbse, '154ARG-208TYR-1')] =  -10.683  
BIND_BRONZE['%s-%s' % (dbse, '154ILE-159GLN-1')] =   -0.571  
BIND_BRONZE['%s-%s' % (dbse, '154ILE-160VAL-1')] =   -0.548  
BIND_BRONZE['%s-%s' % (dbse, '154LEU-191TYR-1')] =   -1.191  
BIND_BRONZE['%s-%s' % (dbse, '154LYS-159ASN-1')] =   -0.578  
BIND_BRONZE['%s-%s' % (dbse, '154TYR-203GLU-1')] =    4.982  
BIND_BRONZE['%s-%s' % (dbse, '154TYR-207ASN-1')] =    0.572  
BIND_BRONZE['%s-%s' % (dbse, '155PHE-197TYR-1')] =   -1.652  
BIND_BRONZE['%s-%s' % (dbse, '155PHE-277TYR-1')] =   -3.151  
BIND_BRONZE['%s-%s' % (dbse, '155PHE-284LEU-1')] =   -0.899  
BIND_BRONZE['%s-%s' % (dbse, '155PRO-170TRP-1')] =   -1.299  
BIND_BRONZE['%s-%s' % (dbse, '156ARG-171ASP-1')] =  -94.636  
BIND_BRONZE['%s-%s' % (dbse, '156ARG-172THR-1')] =  -14.661  
BIND_BRONZE['%s-%s' % (dbse, '156ARG-197GLU-1')] = -113.854  
BIND_BRONZE['%s-%s' % (dbse, '156ARG-200TRP-1')] =   -2.658  
BIND_BRONZE['%s-%s' % (dbse, '156ARG-200TRP-2')] =  -12.487  
BIND_BRONZE['%s-%s' % (dbse, '156SER-191TYR-2')] =   -1.753  
BIND_BRONZE['%s-%s' % (dbse, '157ASP-202VAL-1')] =   -2.260  
BIND_BRONZE['%s-%s' % (dbse, '157ASP-204ARG-1')] = -118.003  
BIND_BRONZE['%s-%s' % (dbse, '157ILE-160CYS-1')] =   -1.373  
BIND_BRONZE['%s-%s' % (dbse, '157MET-181ILE-1')] =   -0.295  
BIND_BRONZE['%s-%s' % (dbse, '157MET-192ILE-1')] =   -1.036  
BIND_BRONZE['%s-%s' % (dbse, '157PRO-161VAL-1')] =   -0.975  
BIND_BRONZE['%s-%s' % (dbse, '157VAL-167PHE-1')] =   -1.239  
BIND_BRONZE['%s-%s' % (dbse, '158ALA-193HIE-2')] =   -0.907  
BIND_BRONZE['%s-%s' % (dbse, '158ALA-284LEU-1')] =   -0.409  
BIND_BRONZE['%s-%s' % (dbse, '158ILE-164LYS-2')] =   -0.854  
BIND_BRONZE['%s-%s' % (dbse, '158LEU-172THR-1')] =   -0.229  
BIND_BRONZE['%s-%s' % (dbse, '158VAL-169VAL-1')] =    0.066  
BIND_BRONZE['%s-%s' % (dbse, '158VAL-205TYR-1')] =   -1.194  
BIND_BRONZE['%s-%s' % (dbse, '159ALA-197TYR-1')] =   -0.488  
BIND_BRONZE['%s-%s' % (dbse, '159GLU-170LYS-1')] =   -4.371  
BIND_BRONZE['%s-%s' % (dbse, '159ILE-172TYR-1')] =   -1.659  
BIND_BRONZE['%s-%s' % (dbse, '159ILE-199LEU-1')] =   -0.812  
BIND_BRONZE['%s-%s' % (dbse, '159ILE-200TRP-1')] =   -1.530  
BIND_BRONZE['%s-%s' % (dbse, '159ILE-203PRO-1')] =   -0.445  
BIND_BRONZE['%s-%s' % (dbse, '159PHE-206ILE-1')] =   -0.747  
BIND_BRONZE['%s-%s' % (dbse, '159PRO-164VAL-1')] =   -0.562  
BIND_BRONZE['%s-%s' % (dbse, '159PRO-178TYR-1')] =   -2.682  
BIND_BRONZE['%s-%s' % (dbse, '159PRO-192ILE-1')] =   -1.034  
BIND_BRONZE['%s-%s' % (dbse, '159VAL-180LEU-1')] =   -1.077  
BIND_BRONZE['%s-%s' % (dbse, '160LEU-164TRP-1')] =   -0.572  
BIND_BRONZE['%s-%s' % (dbse, '160MET-169LEU-1')] =   -1.117  
BIND_BRONZE['%s-%s' % (dbse, '160PHE-169VAL-1')] =   -1.718  
BIND_BRONZE['%s-%s' % (dbse, '160PHE-203VAL-1')] =   -1.070  
BIND_BRONZE['%s-%s' % (dbse, '161ARG-285ASP-1')] =  -86.285  
BIND_BRONZE['%s-%s' % (dbse, '161ARG-288ALA-1')] =   -2.142  
BIND_BRONZE['%s-%s' % (dbse, '161ARG-292GLU-1')] = -119.368  
BIND_BRONZE['%s-%s' % (dbse, '161THR-194VAL-2')] =   -0.196  
BIND_BRONZE['%s-%s' % (dbse, '161TYR-201ALA-1')] =   -2.297  
BIND_BRONZE['%s-%s' % (dbse, '161TYR-204ALA-1')] =   -1.182  
BIND_BRONZE['%s-%s' % (dbse, '161VAL-170LYS-1')] =   -1.571  
BIND_BRONZE['%s-%s' % (dbse, '162ALA-174ILE-1')] =   -0.685  
BIND_BRONZE['%s-%s' % (dbse, '162ALA-175TRP-1')] =   -2.286  
BIND_BRONZE['%s-%s' % (dbse, '162LEU-198PHE-1')] =   -1.070  
BIND_BRONZE['%s-%s' % (dbse, '162LEU-201LEU-1')] =   -0.398  
BIND_BRONZE['%s-%s' % (dbse, '162LEU-203VAL-1')] =   -0.747  
BIND_BRONZE['%s-%s' % (dbse, '162LEU-208ILE-1')] =    0.082  
BIND_BRONZE['%s-%s' % (dbse, '162LEU-284LEU-1')] =   -0.374  
BIND_BRONZE['%s-%s' % (dbse, '162PHE-168LEU-1')] =   -2.048  
BIND_BRONZE['%s-%s' % (dbse, '162PHE-207ASN-1')] =   -1.282  
BIND_BRONZE['%s-%s' % (dbse, '162VAL-167CYS-1')] =   -0.911  
BIND_BRONZE['%s-%s' % (dbse, '162VAL-167TYR-1')] =   -1.427  
BIND_BRONZE['%s-%s' % (dbse, '162VAL-167TYR-2')] =   -1.087  
BIND_BRONZE['%s-%s' % (dbse, '163ARG-201LEU-1')] =   -2.194  
BIND_BRONZE['%s-%s' % (dbse, '163ASN-166ILE-1')] =   -1.674  
BIND_BRONZE['%s-%s' % (dbse, '163ASN-196ARG-1')] =   -5.667  
BIND_BRONZE['%s-%s' % (dbse, '163ILE-166CYS-1')] =   -0.710  
BIND_BRONZE['%s-%s' % (dbse, '163LEU-171ALA-1')] =   -0.563  
BIND_BRONZE['%s-%s' % (dbse, '163LEU-175LEU-1')] =   -0.154  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-174ILE-1')] =   -2.097  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-178TYR-1')] =   -2.750  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-180LEU-1')] =   -0.966  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-180LEU-2')] =   -1.253  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-183LYS-1')] =   -6.375  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-184VAL-1')] =   -1.156  
BIND_BRONZE['%s-%s' % (dbse, '163TYR-187GLU-1')] =    4.207  
BIND_BRONZE['%s-%s' % (dbse, '164VAL-171ALA-1')] =   -0.887  
BIND_BRONZE['%s-%s' % (dbse, '164VAL-225LEU-1')] =   -0.594  
BIND_BRONZE['%s-%s' % (dbse, '165ALA-292GLU-1')] =   -2.303  
BIND_BRONZE['%s-%s' % (dbse, '165GLN-224MET-2')] =   -1.950  
BIND_BRONZE['%s-%s' % (dbse, '165LYS-169ASP-1')] = -111.897  
BIND_BRONZE['%s-%s' % (dbse, '165PHE-169VAL-1')] =   -1.526  
BIND_BRONZE['%s-%s' % (dbse, '165TYR-168ASP-1')] =    3.332  
BIND_BRONZE['%s-%s' % (dbse, '165TYR-171VAL-1')] =   -1.559  
BIND_BRONZE['%s-%s' % (dbse, '165TYR-208ILE-1')] =   -0.865  
BIND_BRONZE['%s-%s' % (dbse, '165TYR-208ILE-2')] =   -1.561  
BIND_BRONZE['%s-%s' % (dbse, '165VAL-177ILE-1')] =   -0.557  
BIND_BRONZE['%s-%s' % (dbse, '166ILE-187ARG-1')] =   -0.474  
BIND_BRONZE['%s-%s' % (dbse, '166PRO-171VAL-1')] =   -0.599  
BIND_BRONZE['%s-%s' % (dbse, '166PRO-172VAL-1')] =   -0.403  
BIND_BRONZE['%s-%s' % (dbse, '167GLU-187ARG-1')] = -116.696  
BIND_BRONZE['%s-%s' % (dbse, '167PHE-170TRP-1')] =   -2.788  
BIND_BRONZE['%s-%s' % (dbse, '167PRO-170VAL-1')] =   -1.088  
BIND_BRONZE['%s-%s' % (dbse, '168HIE-180GLU-1')] =  -24.811  
BIND_BRONZE['%s-%s' % (dbse, '168ILE-178VAL-1')] =   -0.484  
BIND_BRONZE['%s-%s' % (dbse, '168LEU-172ASP-1')] =   -2.423  
BIND_BRONZE['%s-%s' % (dbse, '168LEU-211ARG-1')] =   -1.895  
BIND_BRONZE['%s-%s' % (dbse, '168TYR-203ILE-1')] =   -1.203  
BIND_BRONZE['%s-%s' % (dbse, '168TYR-224MET-1')] =   -0.494  
BIND_BRONZE['%s-%s' % (dbse, '169ASP-172SER-2')] =  -18.530  
BIND_BRONZE['%s-%s' % (dbse, '169LEU-181TRP-1')] =   -1.383  
BIND_BRONZE['%s-%s' % (dbse, '169LYS-172ILE-2')] =   -2.803  
BIND_BRONZE['%s-%s' % (dbse, '169LYS-291ILE-1')] =   -0.488  
BIND_BRONZE['%s-%s' % (dbse, '169MET-184VAL-1')] =   -0.159  
BIND_BRONZE['%s-%s' % (dbse, '170ALA-175TRP-1')] =   -1.194  
BIND_BRONZE['%s-%s' % (dbse, '170HIE-174LEU-1')] =   -1.222  
BIND_BRONZE['%s-%s' % (dbse, '170LEU-178LEU-1')] =   -0.996  
BIND_BRONZE['%s-%s' % (dbse, '170LEU-186TYR-1')] =   -1.371  
BIND_BRONZE['%s-%s' % (dbse, '170THR-180GLU-1')] =   -0.612  
BIND_BRONZE['%s-%s' % (dbse, '171ASP-176THR-1')] =  -17.321  
BIND_BRONZE['%s-%s' % (dbse, '171THR-180SER-1')] =   -5.206  
BIND_BRONZE['%s-%s' % (dbse, '171TYR-180PRO-1')] =    2.214  
BIND_BRONZE['%s-%s' % (dbse, '171TYR-231VAL-1')] =   -1.183  
BIND_BRONZE['%s-%s' % (dbse, '172ASP-204TYR-1')] =  -25.808  
BIND_BRONZE['%s-%s' % (dbse, '172ILE-235VAL-1')] =   -0.582  
BIND_BRONZE['%s-%s' % (dbse, '172TYR-193VAL-1')] =   -0.882  
BIND_BRONZE['%s-%s' % (dbse, '173ARG-234ASP-1')] = -116.106  
BIND_BRONZE['%s-%s' % (dbse, '173ARG-296LYS-1')] =   58.587  
BIND_BRONZE['%s-%s' % (dbse, '173CYS-269HIE-1')] =   -0.783  
BIND_BRONZE['%s-%s' % (dbse, '173CYS-270TYR-1')] =   -1.102  
BIND_BRONZE['%s-%s' % (dbse, '173LEU-190VAL-1')] =   -0.550  
BIND_BRONZE['%s-%s' % (dbse, '173PHE-176THR-1')] =   -0.948  
BIND_BRONZE['%s-%s' % (dbse, '173TYR-211PRO-1')] =   -1.158  
BIND_BRONZE['%s-%s' % (dbse, '173TYR-213ILE-1')] =   -2.058  
BIND_BRONZE['%s-%s' % (dbse, '173TYR-245ILE-1')] =   -1.272  
BIND_BRONZE['%s-%s' % (dbse, '174ASN-178LYS-1')] =  -24.429  
BIND_BRONZE['%s-%s' % (dbse, '174MET-177ILE-1')] =   -1.189  
BIND_BRONZE['%s-%s' % (dbse, '174THR-205LEU-1')] =   -1.378  
BIND_BRONZE['%s-%s' % (dbse, '174VAL-203VAL-1')] =   -0.824  
BIND_BRONZE['%s-%s' % (dbse, '174VAL-205PHE-1')] =   -1.648  
BIND_BRONZE['%s-%s' % (dbse, '174VAL-270TYR-1')] =   -0.277  
BIND_BRONZE['%s-%s' % (dbse, '174VAL-273GLU-1')] =   -0.719  
BIND_BRONZE['%s-%s' % (dbse, '174VAL-273GLU-2')] =   -0.867  
BIND_BRONZE['%s-%s' % (dbse, '175LEU-233ALA-1')] =   -0.374  
BIND_BRONZE['%s-%s' % (dbse, '175VAL-268LEU-1')] =   -0.964  
BIND_BRONZE['%s-%s' % (dbse, '175VAL-274ASP-1')] =   -6.768  
BIND_BRONZE['%s-%s' % (dbse, '176ALA-195LEU-1')] =   -0.633  
BIND_BRONZE['%s-%s' % (dbse, '176ARG-182GLU-1')] = -114.171  
BIND_BRONZE['%s-%s' % (dbse, '176ARG-273GLU-1')] =  -76.045  
BIND_BRONZE['%s-%s' % (dbse, '176ILE-198PHE-1')] =   -1.301  
BIND_BRONZE['%s-%s' % (dbse, '176ILE-201ALA-1')] =   -0.482  
BIND_BRONZE['%s-%s' % (dbse, '176ILE-205LEU-1')] =   -0.408  
BIND_BRONZE['%s-%s' % (dbse, '176LEU-204TYR-1')] =   -1.738  
BIND_BRONZE['%s-%s' % (dbse, '176LEU-208ALA-1')] =   -0.671  
BIND_BRONZE['%s-%s' % (dbse, '176LEU-208ALA-2')] =   -0.527  
BIND_BRONZE['%s-%s' % (dbse, '176LEU-214PHE-1')] =   -1.570  
BIND_BRONZE['%s-%s' % (dbse, '176THR-180LEU-1')] =   -0.760  
BIND_BRONZE['%s-%s' % (dbse, '177ASP-216GLU-1')] =   70.504  
BIND_BRONZE['%s-%s' % (dbse, '177GLN-190VAL-1')] =   -1.043  
BIND_BRONZE['%s-%s' % (dbse, '178SER-239ASP-1')] =  -18.785  
BIND_BRONZE['%s-%s' % (dbse, '179ALA-225TRP-1')] =   -0.875  
BIND_BRONZE['%s-%s' % (dbse, '179ALA-238MET-1')] =   -0.744  
BIND_BRONZE['%s-%s' % (dbse, '179ALA-250ILE-1')] =   -0.771  
BIND_BRONZE['%s-%s' % (dbse, '179LEU-239PHE-1')] =   -1.737  
BIND_BRONZE['%s-%s' % (dbse, '179TYR-216GLU-1')] =    4.443  
BIND_BRONZE['%s-%s' % (dbse, '179TYR-250PHE-1')] =   -4.042  
BIND_BRONZE['%s-%s' % (dbse, '179TYR-258TRP-1')] =   -4.376  
BIND_BRONZE['%s-%s' % (dbse, '180ASN-219SER-1')] =   -4.853  
BIND_BRONZE['%s-%s' % (dbse, '180ASN-229TRP-1')] =   -3.524  
BIND_BRONZE['%s-%s' % (dbse, '180GLU-187ARG-1')] = -100.874  
BIND_BRONZE['%s-%s' % (dbse, '180GLU-189ARG-2')] = -104.902  
BIND_BRONZE['%s-%s' % (dbse, '180GLU-194ARG-1')] = -114.905  
BIND_BRONZE['%s-%s' % (dbse, '180HIE-184VAL-1')] =   -1.321  
BIND_BRONZE['%s-%s' % (dbse, '180HIE-209TYR-1')] =  -11.564  
BIND_BRONZE['%s-%s' % (dbse, '180HIE-214PHE-1')] =   -1.623  
BIND_BRONZE['%s-%s' % (dbse, '180HIE-224ILE-1')] =   -0.846  
BIND_BRONZE['%s-%s' % (dbse, '181ILE-228TYR-1')] =   -1.164  
BIND_BRONZE['%s-%s' % (dbse, '181THR-195SER-1')] =   -5.198  
BIND_BRONZE['%s-%s' % (dbse, '181TRP-185GLN-1')] =   -2.025  
BIND_BRONZE['%s-%s' % (dbse, '181TRP-189SER-1')] =   -0.880  
BIND_BRONZE['%s-%s' % (dbse, '181TRP-258TRP-1')] =   -2.895  
BIND_BRONZE['%s-%s' % (dbse, '182ASP-186ASN-1')] =  -10.980  
BIND_BRONZE['%s-%s' % (dbse, '182ILE-192ILE-1')] =   -0.776  
BIND_BRONZE['%s-%s' % (dbse, '182ILE-239PHE-1')] =   -1.032  
BIND_BRONZE['%s-%s' % (dbse, '182ILE-242LEU-1')] =   -0.530  
BIND_BRONZE['%s-%s' % (dbse, '182PRO-186LEU-1')] =   -0.420  
BIND_BRONZE['%s-%s' % (dbse, '182PRO-186LEU-2')] =   -1.081  
BIND_BRONZE['%s-%s' % (dbse, '182PRO-189ARG-1')] =   -2.886  
BIND_BRONZE['%s-%s' % (dbse, '183GLN-190LYS-1')] =   -1.363  
BIND_BRONZE['%s-%s' % (dbse, '183GLN-194ILE-1')] =   -0.822  
BIND_BRONZE['%s-%s' % (dbse, '183GLN-205LEU-1')] =    0.181  
BIND_BRONZE['%s-%s' % (dbse, '183GLN-209TYR-1')] =    2.138  
BIND_BRONZE['%s-%s' % (dbse, '183TYR-186LYS-1')] =  -14.988  
BIND_BRONZE['%s-%s' % (dbse, '184ASP-187ARG-1')] =  -87.507  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-205THR-1')] =   -1.845  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-209LEU-1')] =   -1.370  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-225TRP-1')] =   -2.494  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-228VAL-1')] =   -1.300  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-238MET-1')] =   -1.868  
BIND_BRONZE['%s-%s' % (dbse, '184PHE-255TRP-1')] =   -1.672  
BIND_BRONZE['%s-%s' % (dbse, '184THR-220ALA-1')] =   -0.443  
BIND_BRONZE['%s-%s' % (dbse, '184VAL-225GLU-1')] =   -1.538  
BIND_BRONZE['%s-%s' % (dbse, '185PHE-190LYS-1')] =   -2.052  
BIND_BRONZE['%s-%s' % (dbse, '185TYR-220PHE-1')] =   -1.458  
BIND_BRONZE['%s-%s' % (dbse, '185VAL-224ILE-1')] =   -0.145  
BIND_BRONZE['%s-%s' % (dbse, '185VAL-228TYR-1')] =   -1.386  
BIND_BRONZE['%s-%s' % (dbse, '186CYS-192PHE-1')] =   -0.938  
BIND_BRONZE['%s-%s' % (dbse, '186GLU-189LYS-1')] = -108.444  
BIND_BRONZE['%s-%s' % (dbse, '186LYS-191VAL-1')] =   -1.627  
BIND_BRONZE['%s-%s' % (dbse, '186LYS-191VAL-2')] =   -1.431  
BIND_BRONZE['%s-%s' % (dbse, '186TYR-273GLU-1')] =    4.992  
BIND_BRONZE['%s-%s' % (dbse, '186VAL-208PRO-1')] =   -1.160  
BIND_BRONZE['%s-%s' % (dbse, '186VAL-223LEU-1')] =   -0.539  
BIND_BRONZE['%s-%s' % (dbse, '187LYS-193THR-1')] =   -0.540  
BIND_BRONZE['%s-%s' % (dbse, '187LYS-193THR-2')] =   -1.634  
BIND_BRONZE['%s-%s' % (dbse, '188LYS-225GLU-1')] =   -5.179  
BIND_BRONZE['%s-%s' % (dbse, '189THR-199LYS-1')] =    0.307  
BIND_BRONZE['%s-%s' % (dbse, '189THR-205PHE-1')] =   -1.364  
BIND_BRONZE['%s-%s' % (dbse, '189THR-207GLU-1')] =  -16.265  
BIND_BRONZE['%s-%s' % (dbse, '189TYR-232ALA-1')] =   -1.529  
BIND_BRONZE['%s-%s' % (dbse, '190ARG-235LEU-1')] =   -1.991  
BIND_BRONZE['%s-%s' % (dbse, '190LYS-193GLU-1')] = -108.429  
BIND_BRONZE['%s-%s' % (dbse, '190PHE-199LEU-1')] =   -1.348  
BIND_BRONZE['%s-%s' % (dbse, '191LEU-219TRP-2')] =   -2.409  
BIND_BRONZE['%s-%s' % (dbse, '191TRP-229TRP-1')] =   -1.198  
BIND_BRONZE['%s-%s' % (dbse, '192GLN-197VAL-1')] =   -0.617  
BIND_BRONZE['%s-%s' % (dbse, '192ILE-242LEU-1')] =   -0.534  
BIND_BRONZE['%s-%s' % (dbse, '192SER-269ARG-1')] =   -9.728  
BIND_BRONZE['%s-%s' % (dbse, '193HIE-248MET-1')] =   -0.905  
BIND_BRONZE['%s-%s' % (dbse, '193HIE-301MET-1')] =   -1.994  
BIND_BRONZE['%s-%s' % (dbse, '194ASP-269ARG-1')] = -119.114  
BIND_BRONZE['%s-%s' % (dbse, '194ILE-205LEU-1')] =   -0.577  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-198PHE-1')] =   -2.879  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-201LYS-1')] =   -1.889  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-217PHE-1')] =   -1.643  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-233ALA-1')] =   -1.880  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-237ILE-1')] =   -1.568  
BIND_BRONZE['%s-%s' % (dbse, '194PHE-241TYR-1')] =   -2.691  
BIND_BRONZE['%s-%s' % (dbse, '195ASP-241TYR-1')] =    6.174  
BIND_BRONZE['%s-%s' % (dbse, '195LEU-205PHE-1')] =   -0.903  
BIND_BRONZE['%s-%s' % (dbse, '195LEU-237ILE-1')] =   -0.362  
BIND_BRONZE['%s-%s' % (dbse, '195LEU-269ARG-1')] =   -3.401  
BIND_BRONZE['%s-%s' % (dbse, '195PRO-198PHE-1')] =   -2.834  
BIND_BRONZE['%s-%s' % (dbse, '196HIE-218GLU-1')] =   10.822  
BIND_BRONZE['%s-%s' % (dbse, '196HIE-221MET-1')] =   -0.788  
BIND_BRONZE['%s-%s' % (dbse, '196HIE-249ILE-1')] =   -1.648  
BIND_BRONZE['%s-%s' % (dbse, '196HIE-249ILE-2')] =   -1.472  
BIND_BRONZE['%s-%s' % (dbse, '197TYR-201LEU-1')] =   -1.771  
BIND_BRONZE['%s-%s' % (dbse, '197TYR-252PRO-1')] =   -1.978  
BIND_BRONZE['%s-%s' % (dbse, '197TYR-284LEU-1')] =   -0.750  
BIND_BRONZE['%s-%s' % (dbse, '198ASN-201LYS-1')] =   -1.686  
BIND_BRONZE['%s-%s' % (dbse, '198PHE-205PHE-1')] =   -1.498  
BIND_BRONZE['%s-%s' % (dbse, '198PHE-217PHE-1')] =   -1.021  
BIND_BRONZE['%s-%s' % (dbse, '198PHE-284LEU-1')] =   -1.048  
BIND_BRONZE['%s-%s' % (dbse, '198PHE-287LEU-1')] =   -1.587  
BIND_BRONZE['%s-%s' % (dbse, '199LYS-207GLU-1')] = -108.382  
BIND_BRONZE['%s-%s' % (dbse, '200TRP-204ASN-1')] =   -3.089  
BIND_BRONZE['%s-%s' % (dbse, '201LEU-284LEU-1')] =   -0.592  
BIND_BRONZE['%s-%s' % (dbse, '201SER-209ASN-1')] =   -2.263  
BIND_BRONZE['%s-%s' % (dbse, '202TYR-212ILE-1')] =   -0.663  
BIND_BRONZE['%s-%s' % (dbse, '202TYR-241TYR-1')] =   -2.147  
BIND_BRONZE['%s-%s' % (dbse, '203VAL-291ILE-1')] =   -0.674  
BIND_BRONZE['%s-%s' % (dbse, '205LEU-212ILE-1')] =   -0.803  
BIND_BRONZE['%s-%s' % (dbse, '205MET-223ASP-2')] =   -5.620  
BIND_BRONZE['%s-%s' % (dbse, '205MET-224MET-1')] =   -1.707  
BIND_BRONZE['%s-%s' % (dbse, '205THR-209LEU-1')] =   -0.693  
BIND_BRONZE['%s-%s' % (dbse, '206ASP-210TYR-1')] =  -27.781  
BIND_BRONZE['%s-%s' % (dbse, '206VAL-231TYR-1')] =   -1.345  
BIND_BRONZE['%s-%s' % (dbse, '207PRO-216VAL-1')] =   -0.444  
BIND_BRONZE['%s-%s' % (dbse, '208ALA-214PHE-1')] =   -1.193  
BIND_BRONZE['%s-%s' % (dbse, '209TYR-214PHE-1')] =   -1.649  
BIND_BRONZE['%s-%s' % (dbse, '210GLU-213LYS-1')] = -109.266  
BIND_BRONZE['%s-%s' % (dbse, '210TYR-216ASP-1')] =   -1.713  
BIND_BRONZE['%s-%s' % (dbse, '210TYR-286TYR-1')] =   -2.075  
BIND_BRONZE['%s-%s' % (dbse, '211ASP-214LYS-1')] = -114.283  
BIND_BRONZE['%s-%s' % (dbse, '211PRO-245ILE-1')] =   -0.739  
BIND_BRONZE['%s-%s' % (dbse, '212ALA-221GLU-1')] =   -2.366  
BIND_BRONZE['%s-%s' % (dbse, '212ILE-243LYS-1')] =   -1.771  
BIND_BRONZE['%s-%s' % (dbse, '212PRO-215ILE-1')] =   -0.994  
BIND_BRONZE['%s-%s' % (dbse, '214ILE-217PHE-1')] =   -1.609  
BIND_BRONZE['%s-%s' % (dbse, '215ALA-282PHE-1')] =   -0.729  
BIND_BRONZE['%s-%s' % (dbse, '217PHE-234TYR-1')] =   -2.096  
BIND_BRONZE['%s-%s' % (dbse, '217PHE-247ALA-1')] =   -1.009  
BIND_BRONZE['%s-%s' % (dbse, '217PHE-249TRP-1')] =   -2.644  
BIND_BRONZE['%s-%s' % (dbse, '218ALA-249TRP-1')] =   -2.573  
BIND_BRONZE['%s-%s' % (dbse, '218ALA-258TRP-1')] =   -1.575  
BIND_BRONZE['%s-%s' % (dbse, '219SER-229TRP-1')] =   -2.488  
BIND_BRONZE['%s-%s' % (dbse, '219VAL-222TYR-1')] =   -1.453  
BIND_BRONZE['%s-%s' % (dbse, '219VAL-222TYR-2')] =   -1.656  
BIND_BRONZE['%s-%s' % (dbse, '219VAL-272ALA-1')] =   -0.886  # altered
BIND_BRONZE['%s-%s' % (dbse, '219VAL-286TYR-1')] =   -1.179  
BIND_BRONZE['%s-%s' % (dbse, '219VAL-288LEU-1')] =   -0.113  
BIND_BRONZE['%s-%s' % (dbse, '220ALA-256THR-1')] =   -0.697  
BIND_BRONZE['%s-%s' % (dbse, '220ALA-286TYR-1')] =   -2.190  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-226LYS-1')] =   -4.170  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-230LYS-1')] = -111.199  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-231TYR-1')] =    7.471  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-262SER-1')] =  -18.248  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-263SER-1')] =  -18.588  
BIND_BRONZE['%s-%s' % (dbse, '221GLU-265GLU-1')] =   80.973  
BIND_BRONZE['%s-%s' % (dbse, '222ALA-249ILE-1')] =   -0.607  
BIND_BRONZE['%s-%s' % (dbse, '223ASP-286TYR-1')] =    4.851  
BIND_BRONZE['%s-%s' % (dbse, '223ASP-288LEU-1')] =   -3.516  
BIND_BRONZE['%s-%s' % (dbse, '223ASP-289SER-1')] =  -19.716  
BIND_BRONZE['%s-%s' % (dbse, '223LEU-227ASN-1')] =    1.222  
BIND_BRONZE['%s-%s' % (dbse, '224MET-229PHE-1')] =   -2.453  
BIND_BRONZE['%s-%s' % (dbse, '224MET-229PHE-2')] =   -1.420  
BIND_BRONZE['%s-%s' % (dbse, '225ASN-228ARG-1')] =   -1.608  
BIND_BRONZE['%s-%s' % (dbse, '225TRP-228VAL-1')] =   -1.004  
BIND_BRONZE['%s-%s' % (dbse, '225TRP-252GLU-1')] =   -2.365  
BIND_BRONZE['%s-%s' % (dbse, '226LEU-233LYS-1')] =   -2.258  
BIND_BRONZE['%s-%s' % (dbse, '226LEU-247VAL-1')] =   -1.064  
BIND_BRONZE['%s-%s' % (dbse, '226LEU-294TYR-1')] =   -2.379  
BIND_BRONZE['%s-%s' % (dbse, '226LEU-294TYR-2')] =   -1.488  
BIND_BRONZE['%s-%s' % (dbse, '226LYS-262SER-1')] =  -17.889  
BIND_BRONZE['%s-%s' % (dbse, '227HIE-255SER-1')] =    0.452  
BIND_BRONZE['%s-%s' % (dbse, '227HIE-256LEU-1')] =   -1.229  
BIND_BRONZE['%s-%s' % (dbse, '227HIE-289SER-1')] =   -2.055  
BIND_BRONZE['%s-%s' % (dbse, '228ARG-232GLU-2')] =  -91.735  
BIND_BRONZE['%s-%s' % (dbse, '228VAL-254THR-1')] =   -0.316  
BIND_BRONZE['%s-%s' % (dbse, '232PRO-290LEU-1')] =   -0.673  
BIND_BRONZE['%s-%s' % (dbse, '234ASN-237ASN-1')] =   -0.486  
BIND_BRONZE['%s-%s' % (dbse, '234LEU-260LYS-1')] =   -0.854  
BIND_BRONZE['%s-%s' % (dbse, '234LEU-262VAL-1')] =   -0.434  
BIND_BRONZE['%s-%s' % (dbse, '234LEU-286TRP-1')] =   -2.035  
BIND_BRONZE['%s-%s' % (dbse, '234LEU-286TRP-2')] =   -2.391  
BIND_BRONZE['%s-%s' % (dbse, '235VAL-294ALA-1')] =   -0.578  
BIND_BRONZE['%s-%s' % (dbse, '236ILE-258LEU-1')] =   -0.408  
BIND_BRONZE['%s-%s' % (dbse, '236ILE-260ALA-1')] =   -0.898  
BIND_BRONZE['%s-%s' % (dbse, '236PHE-262VAL-1')] =   -1.927  
BIND_BRONZE['%s-%s' % (dbse, '236PHE-279ILE-2')] =   -1.834  
BIND_BRONZE['%s-%s' % (dbse, '236PHE-282GLU-1')] =   -1.073  
BIND_BRONZE['%s-%s' % (dbse, '237ILE-267ILE-1')] =   -0.524  
BIND_BRONZE['%s-%s' % (dbse, '237ILE-269ARG-1')] =   -1.489  
BIND_BRONZE['%s-%s' % (dbse, '237TRP-246PRO-1')] =   -2.057  
BIND_BRONZE['%s-%s' % (dbse, '237TRP-249ALA-1')] =   -1.596  
BIND_BRONZE['%s-%s' % (dbse, '237TRP-263ASP-1')] =   -1.729  
BIND_BRONZE['%s-%s' % (dbse, '238MET-247PRO-1')] =   -1.025  
BIND_BRONZE['%s-%s' % (dbse, '238MET-255TRP-1')] =   -2.234  
BIND_BRONZE['%s-%s' % (dbse, '239ASP-244THR-1')] =   -3.656  
BIND_BRONZE['%s-%s' % (dbse, '239ASP-271PRO-1')] =  -12.197  
BIND_BRONZE['%s-%s' % (dbse, '240ASP-270SER-1')] =  -17.896  
BIND_BRONZE['%s-%s' % (dbse, '240PRO-268LEU-1')] =   -0.706  
BIND_BRONZE['%s-%s' % (dbse, '241ARG-272GLU-1')] =  -92.059  
BIND_BRONZE['%s-%s' % (dbse, '243LEU-269HIE-1')] =   -1.389  
BIND_BRONZE['%s-%s' % (dbse, '244SER-294TYR-1')] =   -0.368  
BIND_BRONZE['%s-%s' % (dbse, '245ILE-250ILE-1')] =   -0.705  
BIND_BRONZE['%s-%s' % (dbse, '245PRO-248GLU-1')] =   -2.245  
BIND_BRONZE['%s-%s' % (dbse, '248MET-298ARG-1')] =   -0.901  
BIND_BRONZE['%s-%s' % (dbse, '249ILE-269MET-1')] =   -0.621  
BIND_BRONZE['%s-%s' % (dbse, '249ILE-276ILE-1')] =   -0.330  
BIND_BRONZE['%s-%s' % (dbse, '249ILE-297PHE-1')] =   -1.534  
BIND_BRONZE['%s-%s' % (dbse, '249ILE-300LEU-1')] =   -0.725  
BIND_BRONZE['%s-%s' % (dbse, '250ILE-255TRP-1')] =   -1.852  
BIND_BRONZE['%s-%s' % (dbse, '250ILE-255TRP-2')] =   -2.214  
BIND_BRONZE['%s-%s' % (dbse, '251LEU-269MET-1')] =   -1.352  
BIND_BRONZE['%s-%s' % (dbse, '252PRO-258ALA-1')] =   -0.525  
BIND_BRONZE['%s-%s' % (dbse, '253ALA-261THR-1')] =    0.874  
BIND_BRONZE['%s-%s' % (dbse, '253ALA-302SER-1')] =   -0.951  
BIND_BRONZE['%s-%s' % (dbse, '255TRP-261VAL-1')] =   -1.798  
BIND_BRONZE['%s-%s' % (dbse, '258LEU-261VAL-1')] =   -0.701  
BIND_BRONZE['%s-%s' % (dbse, '261VAL-266VAL-1')] =   -0.212  
BIND_BRONZE['%s-%s' % (dbse, '264ILE-271LEU-1')] =   -0.671  
BIND_BRONZE['%s-%s' % (dbse, '270SER-283LEU-1')] =   -0.843  
BIND_BRONZE['%s-%s' % (dbse, '273PRO-283LEU-1')] =   -1.050  
BIND_BRONZE['%s-%s' % (dbse, '274ILE-279LYS-1')] =   -0.937  
BIND_BRONZE['%s-%s' % (dbse, '275ASN-278LEU-1')] =   -1.021  
# Silver
BIND_SILVER = {}
BIND_SILVER['%s-%s' % (dbse, '001ARG-005ASP-1')] =  -61.741  
BIND_SILVER['%s-%s' % (dbse, '001ARG-013ARG-1')] =   63.156  
BIND_SILVER['%s-%s' % (dbse, '001ARG-015GLU-1')] =  -80.722  
BIND_SILVER['%s-%s' % (dbse, '001ARG-159VAL-1')] =   -1.897  
BIND_SILVER['%s-%s' % (dbse, '001ASN-026VAL-1')] =   -0.717  
BIND_SILVER['%s-%s' % (dbse, '001ASN-030MET-1')] =    0.924  
BIND_SILVER['%s-%s' % (dbse, '001ASN-097GLU-1')] =  -16.853  
BIND_SILVER['%s-%s' % (dbse, '001HIE-099GLN-1')] =   -1.619  
BIND_SILVER['%s-%s' % (dbse, '001LEU-071LYS-1')] =   -0.702  
BIND_SILVER['%s-%s' % (dbse, '001LEU-154LEU-1')] =   -0.548  
BIND_SILVER['%s-%s' % (dbse, '001LEU-190THR-1')] =   -0.485  
BIND_SILVER['%s-%s' % (dbse, '001LYS-027ASN-2')] =   20.794  
BIND_SILVER['%s-%s' % (dbse, '001LYS-027THR-1')] =   -0.695  
BIND_SILVER['%s-%s' % (dbse, '001LYS-027THR-2')] =    1.387  
BIND_SILVER['%s-%s' % (dbse, '001MET-005GLU-1')] =   -0.231  
BIND_SILVER['%s-%s' % (dbse, '001MET-027VAL-2')] =    2.888  
BIND_SILVER['%s-%s' % (dbse, '001MET-031VAL-1')] =    2.468  
BIND_SILVER['%s-%s' % (dbse, '001MET-047GLU-1')] =   -5.085  
BIND_SILVER['%s-%s' % (dbse, '001PRO-046ASP-1')] =   -4.148  
BIND_SILVER['%s-%s' % (dbse, '001SER-030GLU-1')] =   -3.183  
BIND_SILVER['%s-%s' % (dbse, '002ALA-101ILE-1')] =   -0.767  
BIND_SILVER['%s-%s' % (dbse, '002ARG-006GLU-1')] =  -90.774  
BIND_SILVER['%s-%s' % (dbse, '002ARG-020PRO-1')] =   -2.220  
BIND_SILVER['%s-%s' % (dbse, '002ARG-046LEU-1')] =   -2.258  
BIND_SILVER['%s-%s' % (dbse, '002ASN-022GLU-1')] =  -21.320  
BIND_SILVER['%s-%s' % (dbse, '002ASN-026ASP-2')] =   -8.508  
BIND_SILVER['%s-%s' % (dbse, '002ASP-145HIE-1')] =   -6.734  
BIND_SILVER['%s-%s' % (dbse, '002LEU-005GLN-1')] =   -1.769  
BIND_SILVER['%s-%s' % (dbse, '002LEU-006GLN-1')] =   -1.051  
BIND_SILVER['%s-%s' % (dbse, '002LEU-153PHE-1')] =   -1.629  
BIND_SILVER['%s-%s' % (dbse, '002LEU-163LEU-1')] =   -0.506  
BIND_SILVER['%s-%s' % (dbse, '002LYS-006GLU-2')] =   -0.910  
BIND_SILVER['%s-%s' % (dbse, '002LYS-007ILE-1')] =   -0.739  
BIND_SILVER['%s-%s' % (dbse, '002LYS-035GLU-1')] = -110.490  
BIND_SILVER['%s-%s' % (dbse, '002LYS-075ASN-1')] =  -22.745  
BIND_SILVER['%s-%s' % (dbse, '002LYS-080ARG-1')] =   -0.875  
BIND_SILVER['%s-%s' % (dbse, '002LYS-082TYR-1')] =   -8.517  
BIND_SILVER['%s-%s' % (dbse, '002MET-031TYR-1')] =   -0.883  
BIND_SILVER['%s-%s' % (dbse, '002MET-050ALA-1')] =   -0.941  
BIND_SILVER['%s-%s' % (dbse, '002TRP-012VAL-1')] =   -0.715  
BIND_SILVER['%s-%s' % (dbse, '002TRP-138SER-2')] =   -5.871  
BIND_SILVER['%s-%s' % (dbse, '002TRP-139LEU-1')] =   -1.693  
BIND_SILVER['%s-%s' % (dbse, '002VAL-009TRP-1')] =   -0.568  
BIND_SILVER['%s-%s' % (dbse, '002VAL-042PHE-1')] =   -0.950  
BIND_SILVER['%s-%s' % (dbse, '002VAL-042PHE-2')] =   -0.569  
BIND_SILVER['%s-%s' % (dbse, '002VAL-043HIE-2')] =   -2.181  
BIND_SILVER['%s-%s' % (dbse, '002VAL-046SER-1')] =   -0.337  
BIND_SILVER['%s-%s' % (dbse, '003ALA-007THR-1')] =   -0.921  
BIND_SILVER['%s-%s' % (dbse, '003GLU-006GLN-2')] =    4.293  
BIND_SILVER['%s-%s' % (dbse, '003ILE-062ILE-1')] =   -0.112  
BIND_SILVER['%s-%s' % (dbse, '003ILE-065SER-1')] =    0.249  
BIND_SILVER['%s-%s' % (dbse, '003ILE-067TYR-1')] =   -1.456  
BIND_SILVER['%s-%s' % (dbse, '003LEU-033LEU-1')] =   -0.617  
BIND_SILVER['%s-%s' % (dbse, '003LEU-054LEU-1')] =   -0.620  
BIND_SILVER['%s-%s' % (dbse, '003LYS-055LEU-1')] =   -0.389  
BIND_SILVER['%s-%s' % (dbse, '003PRO-025ALA-1')] =   -1.173  
BIND_SILVER['%s-%s' % (dbse, '003SER-096ASN-2')] =    0.021  
BIND_SILVER['%s-%s' % (dbse, '003THR-181VAL-1')] =   -1.077  
BIND_SILVER['%s-%s' % (dbse, '003THR-182GLU-1')] =   -3.510  
BIND_SILVER['%s-%s' % (dbse, '003TRP-163PRO-1')] =   -4.059  
BIND_SILVER['%s-%s' % (dbse, '003TRP-167GLN-1')] =   -1.593  
BIND_SILVER['%s-%s' % (dbse, '003TRP-167GLN-2')] =   -2.470  
BIND_SILVER['%s-%s' % (dbse, '003TYR-028VAL-1')] =   -1.255  
BIND_SILVER['%s-%s' % (dbse, '003TYR-028VAL-2')] =   -1.606  
BIND_SILVER['%s-%s' % (dbse, '003TYR-030GLN-1')] =   -2.640  
BIND_SILVER['%s-%s' % (dbse, '003TYR-054VAL-1')] =   -1.155  
BIND_SILVER['%s-%s' % (dbse, '003TYR-056ALA-1')] =   -1.640  
BIND_SILVER['%s-%s' % (dbse, '003TYR-073CYS-2')] =   -2.980  
BIND_SILVER['%s-%s' % (dbse, '003TYR-074SER-1')] =   -1.699  
BIND_SILVER['%s-%s' % (dbse, '003TYR-096HIE-1')] =   -4.087  
BIND_SILVER['%s-%s' % (dbse, '003VAL-009TYR-1')] =   -1.311  
BIND_SILVER['%s-%s' % (dbse, '003VAL-012GLU-1')] =   -2.722  
BIND_SILVER['%s-%s' % (dbse, '003VAL-036PHE-1')] =   -1.251  
BIND_SILVER['%s-%s' % (dbse, '003VAL-064TYR-1')] =   -0.977  
BIND_SILVER['%s-%s' % (dbse, '003VAL-081THR-1')] =   -0.453  
BIND_SILVER['%s-%s' % (dbse, '003VAL-083PRO-1')] =   -0.618  
BIND_SILVER['%s-%s' % (dbse, '003VAL-118ALA-1')] =   -0.650  
BIND_SILVER['%s-%s' % (dbse, '003VAL-121TYR-1')] =   -1.098  
BIND_SILVER['%s-%s' % (dbse, '004ARG-024THR-1')] =  -15.407  
BIND_SILVER['%s-%s' % (dbse, '004ARG-057ILE-1')] =   -0.983  
BIND_SILVER['%s-%s' % (dbse, '004ARG-057ILE-2')] =   -0.091  
BIND_SILVER['%s-%s' % (dbse, '004ARG-095TYR-1')] =   -1.541  
BIND_SILVER['%s-%s' % (dbse, '004ARG-095TYR-2')] =   -6.183  
BIND_SILVER['%s-%s' % (dbse, '004ASN-009TRP-1')] =   -4.821  
BIND_SILVER['%s-%s' % (dbse, '004ASP-043THR-1')] =  -16.624  
BIND_SILVER['%s-%s' % (dbse, '004ASP-194ARG-1')] = -102.828  
BIND_SILVER['%s-%s' % (dbse, '004GLN-007ASN-2')] =   -3.575  
BIND_SILVER['%s-%s' % (dbse, '004GLN-056GLU-1')] =   -7.331  
BIND_SILVER['%s-%s' % (dbse, '004GLU-039THR-1')] =  -16.454  
BIND_SILVER['%s-%s' % (dbse, '004LEU-010TYR-1')] =   -0.907  
BIND_SILVER['%s-%s' % (dbse, '004LEU-031TYR-1')] =   -1.242  
BIND_SILVER['%s-%s' % (dbse, '004LEU-032HIE-1')] =   -1.106  
BIND_SILVER['%s-%s' % (dbse, '004LEU-040GLU-1')] =   -2.803  
BIND_SILVER['%s-%s' % (dbse, '004LEU-179LEU-1')] =   -0.665  
BIND_SILVER['%s-%s' % (dbse, '004LEU-180LEU-1')] =   -0.132  
BIND_SILVER['%s-%s' % (dbse, '004LEU-180LEU-2')] =   -0.900  
BIND_SILVER['%s-%s' % (dbse, '004LEU-183LYS-1')] =   -0.494  
BIND_SILVER['%s-%s' % (dbse, '004LYS-030ASP-1')] =   -4.315  
BIND_SILVER['%s-%s' % (dbse, '004LYS-031ILE-1')] =   -0.820  
BIND_SILVER['%s-%s' % (dbse, '004LYS-323PHE-1')] =   -1.287  
BIND_SILVER['%s-%s' % (dbse, '004PHE-116VAL-1')] =   -1.050  
BIND_SILVER['%s-%s' % (dbse, '004PHE-135LEU-2')] =   -1.842  
BIND_SILVER['%s-%s' % (dbse, '004PHE-158LEU-1')] =   -0.746  
BIND_SILVER['%s-%s' % (dbse, '004PHE-160PRO-1')] =   -1.773  
BIND_SILVER['%s-%s' % (dbse, '004PRO-007LEU-1')] =   -1.028  
BIND_SILVER['%s-%s' % (dbse, '004PRO-009TYR-1')] =   -3.525  
BIND_SILVER['%s-%s' % (dbse, '004PRO-026TYR-1')] =   -2.479  
BIND_SILVER['%s-%s' % (dbse, '004PRO-029PHE-1')] =   -2.260  
BIND_SILVER['%s-%s' % (dbse, '004PRO-068VAL-1')] =   -0.572  
BIND_SILVER['%s-%s' % (dbse, '004PRO-074ALA-1')] =   -1.060  
BIND_SILVER['%s-%s' % (dbse, '004PRO-094LEU-1')] =   -1.151  
BIND_SILVER['%s-%s' % (dbse, '004PRO-096TYR-1')] =   -2.472  
BIND_SILVER['%s-%s' % (dbse, '004SER-027VAL-1')] =   -0.592  
BIND_SILVER['%s-%s' % (dbse, '004SER-030MET-1')] =   -1.574  
BIND_SILVER['%s-%s' % (dbse, '004THR-078LEU-1')] =   -0.506  
BIND_SILVER['%s-%s' % (dbse, '004THR-132LYS-1')] =  -12.835  
BIND_SILVER['%s-%s' % (dbse, '004THR-163LEU-1')] =   -0.361  
BIND_SILVER['%s-%s' % (dbse, '004THR-164GLU-1')] =  -15.998  
BIND_SILVER['%s-%s' % (dbse, '004TRP-014ARG-2')] =   -1.537  
BIND_SILVER['%s-%s' % (dbse, '004TRP-016LYS-1')] =   -2.485  
BIND_SILVER['%s-%s' % (dbse, '004TYR-075PRO-1')] =   -1.409  
BIND_SILVER['%s-%s' % (dbse, '004TYR-105LEU-1')] =   -1.349  
BIND_SILVER['%s-%s' % (dbse, '004VAL-053LEU-1')] =    0.148  
BIND_SILVER['%s-%s' % (dbse, '005ALA-019PHE-1')] =   -0.590  
BIND_SILVER['%s-%s' % (dbse, '005ARG-012GLU-1')] = -107.060  
BIND_SILVER['%s-%s' % (dbse, '005ARG-071GLU-1')] =  -95.873  
BIND_SILVER['%s-%s' % (dbse, '005ARG-158LEU-2')] =   -2.148  
BIND_SILVER['%s-%s' % (dbse, '005ASP-103GLN-1')] =  -12.701  
BIND_SILVER['%s-%s' % (dbse, '005ASP-128ARG-1')] = -100.912  
BIND_SILVER['%s-%s' % (dbse, '005ILE-054SER-1')] =   -1.181  
BIND_SILVER['%s-%s' % (dbse, '005ILE-234TYR-1')] =   -0.924  
BIND_SILVER['%s-%s' % (dbse, '005ILE-277LEU-1')] =   -0.311  
BIND_SILVER['%s-%s' % (dbse, '005LEU-010TRP-1')] =   -0.958  
BIND_SILVER['%s-%s' % (dbse, '005LEU-011PHE-1')] =   -2.257  
BIND_SILVER['%s-%s' % (dbse, '005LEU-015LYS-1')] =   -1.903  
BIND_SILVER['%s-%s' % (dbse, '005LEU-023GLN-1')] =   -0.817  
BIND_SILVER['%s-%s' % (dbse, '005LEU-025ILE-1')] =   -0.450  
BIND_SILVER['%s-%s' % (dbse, '005LEU-025LEU-1')] =   -0.551  
BIND_SILVER['%s-%s' % (dbse, '005LEU-030ASP-1')] =   -2.213  
BIND_SILVER['%s-%s' % (dbse, '005LEU-030LEU-2')] =   -0.864  
BIND_SILVER['%s-%s' % (dbse, '005LEU-032MET-1')] =   -0.703  
BIND_SILVER['%s-%s' % (dbse, '005LEU-037ILE-1')] =   -0.600  
BIND_SILVER['%s-%s' % (dbse, '005LEU-068ILE-1')] =   -0.688  
BIND_SILVER['%s-%s' % (dbse, '005LEU-077LEU-1')] =   -0.457  
BIND_SILVER['%s-%s' % (dbse, '005LEU-083HIE-1')] =   -1.188  
BIND_SILVER['%s-%s' % (dbse, '005LEU-106TYR-1')] =   -1.868  
BIND_SILVER['%s-%s' % (dbse, '005LEU-191TYR-1')] =   -1.016  
BIND_SILVER['%s-%s' % (dbse, '005PHE-022VAL-1')] =   -0.656  
BIND_SILVER['%s-%s' % (dbse, '005PHE-031TYR-1')] =   -1.361  
BIND_SILVER['%s-%s' % (dbse, '005PHE-037PHE-1')] =   -1.607  
BIND_SILVER['%s-%s' % (dbse, '005PHE-043TYR-1')] =   -2.257  
BIND_SILVER['%s-%s' % (dbse, '005PHE-049LYS-1')] =   -0.979  
BIND_SILVER['%s-%s' % (dbse, '005PHE-050TRP-1')] =   -2.885  
BIND_SILVER['%s-%s' % (dbse, '005PHE-155SER-1')] =   -0.726  
BIND_SILVER['%s-%s' % (dbse, '005PHE-162GLN-1')] =   -2.100  
BIND_SILVER['%s-%s' % (dbse, '005PHE-163LEU-1')] =   -1.433  
BIND_SILVER['%s-%s' % (dbse, '005PRO-196ALA-1')] =   -1.123  
BIND_SILVER['%s-%s' % (dbse, '005SER-028VAL-1')] =   -0.582  
BIND_SILVER['%s-%s' % (dbse, '005TYR-166TYR-1')] =   -3.260  
BIND_SILVER['%s-%s' % (dbse, '005TYR-168VAL-1')] =   -0.674  
BIND_SILVER['%s-%s' % (dbse, '005VAL-008GLN-1')] =   -0.404  
BIND_SILVER['%s-%s' % (dbse, '005VAL-023LEU-1')] =   -0.404  
BIND_SILVER['%s-%s' % (dbse, '005VAL-035PHE-1')] =   -0.348  
BIND_SILVER['%s-%s' % (dbse, '005VAL-037ILE-1')] =   -0.327  
BIND_SILVER['%s-%s' % (dbse, '005VAL-039SER-1')] =   -0.158  
BIND_SILVER['%s-%s' % (dbse, '006ALA-078GLU-1')] =   -0.619  
BIND_SILVER['%s-%s' % (dbse, '006ARG-090TYR-1')] =   -2.954  
BIND_SILVER['%s-%s' % (dbse, '006ASP-010THR-1')] =    6.035  
BIND_SILVER['%s-%s' % (dbse, '006ASP-116VAL-1')] =   -1.513  
BIND_SILVER['%s-%s' % (dbse, '006GLU-010TYR-1')] =   -2.701  
BIND_SILVER['%s-%s' % (dbse, '006LEU-108PHE-1')] =   -1.776  
BIND_SILVER['%s-%s' % (dbse, '006LEU-126VAL-1')] =   -0.539  
BIND_SILVER['%s-%s' % (dbse, '006LEU-319TYR-1')] =   -0.527  
BIND_SILVER['%s-%s' % (dbse, '006LEU-323PHE-1')] =   -1.005  
BIND_SILVER['%s-%s' % (dbse, '006PHE-018ARG-1')] =   -6.855  
BIND_SILVER['%s-%s' % (dbse, '006PHE-039THR-2')] =   -1.667  
BIND_SILVER['%s-%s' % (dbse, '006PHE-050VAL-1')] =   -0.721  
BIND_SILVER['%s-%s' % (dbse, '006PHE-053LEU-1')] =   -0.919  
BIND_SILVER['%s-%s' % (dbse, '006PHE-061PHE-1')] =   -3.272  
BIND_SILVER['%s-%s' % (dbse, '006PHE-163LEU-1')] =   -0.764  
BIND_SILVER['%s-%s' % (dbse, '006THR-097VAL-1')] =   -0.600  
BIND_SILVER['%s-%s' % (dbse, '006TRP-026TYR-1')] =   -1.447  
BIND_SILVER['%s-%s' % (dbse, '006TRP-038VAL-1')] =   -0.973  
BIND_SILVER['%s-%s' % (dbse, '006TRP-040LYS-1')] =   -0.998  
BIND_SILVER['%s-%s' % (dbse, '006VAL-020VAL-1')] =   -0.748  
BIND_SILVER['%s-%s' % (dbse, '006VAL-023MET-1')] =   -0.573  
BIND_SILVER['%s-%s' % (dbse, '006VAL-024ASP-1')] =   -1.724  
BIND_SILVER['%s-%s' % (dbse, '006VAL-026LEU-1')] =   -0.385  
BIND_SILVER['%s-%s' % (dbse, '006VAL-038ILE-1')] =   -0.213  
BIND_SILVER['%s-%s' % (dbse, '006VAL-053LEU-1')] =   -0.631  
BIND_SILVER['%s-%s' % (dbse, '006VAL-055GLU-1')] =   -2.194  
BIND_SILVER['%s-%s' % (dbse, '006VAL-175PHE-1')] =   -2.786  
BIND_SILVER['%s-%s' % (dbse, '007ALA-011ILE-1')] =   -0.952  
BIND_SILVER['%s-%s' % (dbse, '007ALA-021PHE-1')] =   -0.948  
BIND_SILVER['%s-%s' % (dbse, '007ALA-049VAL-1')] =   -0.274  
BIND_SILVER['%s-%s' % (dbse, '007ARG-011GLU-2')] = -103.012  
BIND_SILVER['%s-%s' % (dbse, '007ARG-062TYR-1')] =   -1.025  
BIND_SILVER['%s-%s' % (dbse, '007ARG-063PRO-1')] =   -2.712  
BIND_SILVER['%s-%s' % (dbse, '007ASN-109GLU-1')] =  -19.180  
BIND_SILVER['%s-%s' % (dbse, '007ASP-011GLN-1')] =    7.115  
BIND_SILVER['%s-%s' % (dbse, '007ASP-119SER-1')] =   -5.744  
BIND_SILVER['%s-%s' % (dbse, '007ASP-131ARG-1')] = -111.268  
BIND_SILVER['%s-%s' % (dbse, '007GLU-033LYS-1')] =   -4.726  
BIND_SILVER['%s-%s' % (dbse, '007GLU-033LYS-2')] = -100.136  
BIND_SILVER['%s-%s' % (dbse, '007ILE-015LYS-1')] =   -0.881  
BIND_SILVER['%s-%s' % (dbse, '007ILE-030LEU-1')] =   -0.347  
BIND_SILVER['%s-%s' % (dbse, '007ILE-030LEU-2')] =   -0.451  
BIND_SILVER['%s-%s' % (dbse, '007ILE-038TYR-1')] =   -1.700  
BIND_SILVER['%s-%s' % (dbse, '007ILE-042LYS-1')] =   -0.122  
BIND_SILVER['%s-%s' % (dbse, '007ILE-097VAL-1')] =   -0.630  
BIND_SILVER['%s-%s' % (dbse, '007LEU-017ARG-1')] =   -0.747  
BIND_SILVER['%s-%s' % (dbse, '007LEU-026VAL-1')] =    0.246  
BIND_SILVER['%s-%s' % (dbse, '007LEU-033LEU-1')] =   -0.519  
BIND_SILVER['%s-%s' % (dbse, '007LEU-090TYR-1')] =   -1.294  
BIND_SILVER['%s-%s' % (dbse, '007LEU-096TYR-1')] =   -1.109  
BIND_SILVER['%s-%s' % (dbse, '007LEU-168HIE-1')] =   -1.657  
BIND_SILVER['%s-%s' % (dbse, '007LYS-011ASP-1')] = -113.126  
BIND_SILVER['%s-%s' % (dbse, '007LYS-093SER-1')] =   -0.845  
BIND_SILVER['%s-%s' % (dbse, '007LYS-099THR-1')] =   -0.672  
BIND_SILVER['%s-%s' % (dbse, '007PHE-019VAL-1')] =   -0.691  
BIND_SILVER['%s-%s' % (dbse, '007PHE-021PHE-1')] =   -2.820  
BIND_SILVER['%s-%s' % (dbse, '007PHE-021PRO-1')] =   -1.606  
BIND_SILVER['%s-%s' % (dbse, '007PHE-022VAL-1')] =   -1.336  
BIND_SILVER['%s-%s' % (dbse, '007PHE-024VAL-1')] =   -0.096  
BIND_SILVER['%s-%s' % (dbse, '007PHE-035PHE-1')] =   -1.305  
BIND_SILVER['%s-%s' % (dbse, '007PHE-084LEU-1')] =   -0.755  
BIND_SILVER['%s-%s' % (dbse, '007PHE-091ILE-1')] =   -1.601  
BIND_SILVER['%s-%s' % (dbse, '007PHE-111PHE-1')] =   -1.110  
BIND_SILVER['%s-%s' % (dbse, '007PHE-157ILE-1')] =   -1.719  
BIND_SILVER['%s-%s' % (dbse, '007PHE-160CYS-1')] =   -0.872  
BIND_SILVER['%s-%s' % (dbse, '007SER-010ARG-2')] =   -8.462  
BIND_SILVER['%s-%s' % (dbse, '007SER-100ASN-1')] =   -4.634  
BIND_SILVER['%s-%s' % (dbse, '007THR-031LYS-1')] =   -0.184  
BIND_SILVER['%s-%s' % (dbse, '007TYR-053TYR-1')] =   -2.105  
BIND_SILVER['%s-%s' % (dbse, '007VAL-022SER-1')] =   -1.950  
BIND_SILVER['%s-%s' % (dbse, '007VAL-026GLU-1')] =   -0.449  
BIND_SILVER['%s-%s' % (dbse, '007VAL-034ALA-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '007VAL-038VAL-1')] =   -0.670  
BIND_SILVER['%s-%s' % (dbse, '007VAL-040THR-1')] =   -0.399  
BIND_SILVER['%s-%s' % (dbse, '007VAL-154GLN-1')] =   -0.622  
BIND_SILVER['%s-%s' % (dbse, '007VAL-154GLN-2')] =   -1.111  
BIND_SILVER['%s-%s' % (dbse, '007VAL-191TYR-1')] =   -1.152  
BIND_SILVER['%s-%s' % (dbse, '007VAL-248MET-1')] =   -0.622  
BIND_SILVER['%s-%s' % (dbse, '008ALA-034ALA-1')] =   -0.285  
BIND_SILVER['%s-%s' % (dbse, '008ALA-035GLU-1')] =   -3.935  
BIND_SILVER['%s-%s' % (dbse, '008ALA-038MET-1')] =   -0.586  
BIND_SILVER['%s-%s' % (dbse, '008ARG-115SER-1')] =  -14.970  
BIND_SILVER['%s-%s' % (dbse, '008ASN-030LYS-1')] =  -25.303  
BIND_SILVER['%s-%s' % (dbse, '008ASP-018ARG-1')] =   -4.849  
BIND_SILVER['%s-%s' % (dbse, '008ASP-018ARG-2')] = -111.451  
BIND_SILVER['%s-%s' % (dbse, '008ASP-058ILE-1')] =   -1.389  
BIND_SILVER['%s-%s' % (dbse, '008ILE-012HIE-1')] =   -0.729  
BIND_SILVER['%s-%s' % (dbse, '008ILE-015TYR-1')] =   -1.111  
BIND_SILVER['%s-%s' % (dbse, '008ILE-032MET-1')] =   -0.573  
BIND_SILVER['%s-%s' % (dbse, '008ILE-033PHE-1')] =   -1.133  
BIND_SILVER['%s-%s' % (dbse, '008ILE-034LEU-1')] =   -0.203  
BIND_SILVER['%s-%s' % (dbse, '008ILE-035TRP-1')] =   -1.279  
BIND_SILVER['%s-%s' % (dbse, '008ILE-041TYR-1')] =   -1.042  
BIND_SILVER['%s-%s' % (dbse, '008ILE-058PHE-1')] =   -2.302  
BIND_SILVER['%s-%s' % (dbse, '008ILE-062TYR-1')] =   -1.255  
BIND_SILVER['%s-%s' % (dbse, '008LEU-017ALA-1')] =   -0.535  
BIND_SILVER['%s-%s' % (dbse, '008LEU-088TYR-1')] =   -1.287  
BIND_SILVER['%s-%s' % (dbse, '008LYS-043THR-1')] =  -14.305  
BIND_SILVER['%s-%s' % (dbse, '008LYS-065VAL-1')] =   -0.534  
BIND_SILVER['%s-%s' % (dbse, '008LYS-068GLU-1')] =   -4.145  
BIND_SILVER['%s-%s' % (dbse, '008LYS-068GLU-2')] = -106.389  
BIND_SILVER['%s-%s' % (dbse, '008MET-158LEU-1')] =   -0.231  
BIND_SILVER['%s-%s' % (dbse, '008PHE-042LEU-1')] =   -0.832  
BIND_SILVER['%s-%s' % (dbse, '008PHE-044ILE-1')] =   -1.071  
BIND_SILVER['%s-%s' % (dbse, '008PHE-097VAL-1')] =   -1.792  
BIND_SILVER['%s-%s' % (dbse, '008PHE-099HIE-1')] =   -2.312  
BIND_SILVER['%s-%s' % (dbse, '008PHE-101HIE-1')] =   -2.776  
BIND_SILVER['%s-%s' % (dbse, '008PRO-183ASP-1')] =  -13.238  
BIND_SILVER['%s-%s' % (dbse, '008SER-032SER-1')] =   -5.485  
BIND_SILVER['%s-%s' % (dbse, '008SER-093TYR-1')] =   -1.229  
BIND_SILVER['%s-%s' % (dbse, '008TRP-035PHE-1')] =   -3.403  
BIND_SILVER['%s-%s' % (dbse, '008TRP-250PHE-1')] =   -3.168  
BIND_SILVER['%s-%s' % (dbse, '008TRP-252GLU-1')] =  -20.276  
BIND_SILVER['%s-%s' % (dbse, '008TYR-052TYR-1')] =   -1.843  
BIND_SILVER['%s-%s' % (dbse, '008VAL-039TRP-1')] =   -0.958  
BIND_SILVER['%s-%s' % (dbse, '008VAL-041VAL-1')] =   -0.333  
BIND_SILVER['%s-%s' % (dbse, '008VAL-066LEU-1')] =   -0.127  
BIND_SILVER['%s-%s' % (dbse, '008VAL-072SER-1')] =   -0.269  
BIND_SILVER['%s-%s' % (dbse, '008VAL-080PHE-1')] =   -1.177  
BIND_SILVER['%s-%s' % (dbse, '009ALA-084LEU-1')] =   -0.487  
BIND_SILVER['%s-%s' % (dbse, '009ALA-091ILE-1')] =   -0.163  
BIND_SILVER['%s-%s' % (dbse, '009ARG-023GLU-1')] =  -96.103  
BIND_SILVER['%s-%s' % (dbse, '009ARG-031TRP-1')] =  -11.969  
BIND_SILVER['%s-%s' % (dbse, '009ARG-092LEU-1')] =   -2.364  
BIND_SILVER['%s-%s' % (dbse, '009ARG-103GLN-1')] =    5.145  
BIND_SILVER['%s-%s' % (dbse, '009ARG-106ASP-1')] =  -89.647  
BIND_SILVER['%s-%s' % (dbse, '009ARG-128ARG-1')] =   -2.523  
BIND_SILVER['%s-%s' % (dbse, '009ARG-128ARG-2')] =   59.656  
BIND_SILVER['%s-%s' % (dbse, '009ASN-024ARG-1')] =    9.135  
BIND_SILVER['%s-%s' % (dbse, '009ASP-021LYS-1')] =   -3.646  
BIND_SILVER['%s-%s' % (dbse, '009GLN-068ILE-1')] =   -0.978  
BIND_SILVER['%s-%s' % (dbse, '009GLN-072ASN-1')] =   -2.530  
BIND_SILVER['%s-%s' % (dbse, '009ILE-013TYR-1')] =   -1.040  
BIND_SILVER['%s-%s' % (dbse, '009ILE-038LEU-1')] =   -0.372  
BIND_SILVER['%s-%s' % (dbse, '009ILE-052PHE-1')] =   -0.701  
BIND_SILVER['%s-%s' % (dbse, '009ILE-092LEU-1')] =   -0.821  
BIND_SILVER['%s-%s' % (dbse, '009ILE-092LEU-2')] =   -0.543  
BIND_SILVER['%s-%s' % (dbse, '009ILE-105LEU-1')] =   -0.675  
BIND_SILVER['%s-%s' % (dbse, '009ILE-108PHE-1')] =   -0.920  
BIND_SILVER['%s-%s' % (dbse, '009ILE-155ILE-1')] =   -0.434  
BIND_SILVER['%s-%s' % (dbse, '009LEU-013VAL-1')] =   -0.661  
BIND_SILVER['%s-%s' % (dbse, '009LEU-033LEU-2')] =   -0.475  
BIND_SILVER['%s-%s' % (dbse, '009LEU-039ARG-1')] =   -0.589  
BIND_SILVER['%s-%s' % (dbse, '009LEU-041VAL-1')] =   -0.672  
BIND_SILVER['%s-%s' % (dbse, '009LEU-041VAL-2')] =   -0.362  
BIND_SILVER['%s-%s' % (dbse, '009LEU-055SER-2')] =   -0.768  
BIND_SILVER['%s-%s' % (dbse, '009LEU-058ILE-1')] =   -0.742  
BIND_SILVER['%s-%s' % (dbse, '009LYS-137LEU-1')] =   -2.463  
BIND_SILVER['%s-%s' % (dbse, '009LYS-171VAL-1')] =   -0.810  
BIND_SILVER['%s-%s' % (dbse, '009PRO-069TYR-1')] =   -1.009  
BIND_SILVER['%s-%s' % (dbse, '009TRP-111ARG-1')] =  -11.373  
BIND_SILVER['%s-%s' % (dbse, '009TYR-016GLU-1')] =    4.014  
BIND_SILVER['%s-%s' % (dbse, '009TYR-029THR-1')] =   -1.063  
BIND_SILVER['%s-%s' % (dbse, '009TYR-033ASN-1')] =   -4.633  
BIND_SILVER['%s-%s' % (dbse, '009TYR-035SER-1')] =   -1.333  
BIND_SILVER['%s-%s' % (dbse, '009TYR-050PRO-1')] =   -3.380  
BIND_SILVER['%s-%s' % (dbse, '009TYR-053TYR-1')] =   -2.689  
BIND_SILVER['%s-%s' % (dbse, '009TYR-111ASP-1')] =  -23.314  
BIND_SILVER['%s-%s' % (dbse, '009TYR-121TYR-1')] =   -3.894  
BIND_SILVER['%s-%s' % (dbse, '009TYR-158ALA-1')] =    0.068  
BIND_SILVER['%s-%s' % (dbse, '009TYR-301MET-1')] =   -1.694  
BIND_SILVER['%s-%s' % (dbse, '009TYR-303TRP-1')] =   -2.602  
BIND_SILVER['%s-%s' % (dbse, '009VAL-021PHE-1')] =   -1.881  
BIND_SILVER['%s-%s' % (dbse, '009VAL-025ILE-1')] =   -0.420  
BIND_SILVER['%s-%s' % (dbse, '009VAL-035ARG-1')] =   -0.597  
BIND_SILVER['%s-%s' % (dbse, '009VAL-084ILE-1')] =   -0.362  
BIND_SILVER['%s-%s' % (dbse, '009VAL-086TYR-1')] =   -1.398  
BIND_SILVER['%s-%s' % (dbse, '010ARG-039ASP-1')] = -100.943  
BIND_SILVER['%s-%s' % (dbse, '010ARG-042ASP-1')] =  -90.821  
BIND_SILVER['%s-%s' % (dbse, '010ARG-092LEU-1')] =   -0.953  
BIND_SILVER['%s-%s' % (dbse, '010ASN-014GLN-2')] =   -5.900  
BIND_SILVER['%s-%s' % (dbse, '010ASN-023GLU-1')] =  -23.431  
BIND_SILVER['%s-%s' % (dbse, '010ASN-088TYR-1')] =   -3.763  
BIND_SILVER['%s-%s' % (dbse, '010ASP-090TYR-1')] =  -25.512  
BIND_SILVER['%s-%s' % (dbse, '010GLN-022MET-1')] =   -2.011  
BIND_SILVER['%s-%s' % (dbse, '010GLN-102TYR-1')] =    0.619  
BIND_SILVER['%s-%s' % (dbse, '010GLU-014LYS-1')] =  -68.151  
BIND_SILVER['%s-%s' % (dbse, '010GLU-032SER-1')] =   10.072  
BIND_SILVER['%s-%s' % (dbse, '010HIE-015TYR-1')] =   -2.082  
BIND_SILVER['%s-%s' % (dbse, '010HIE-023ASP-1')] =   -1.004  
BIND_SILVER['%s-%s' % (dbse, '010LEU-091ASN-1')] =   -0.993  
BIND_SILVER['%s-%s' % (dbse, '010LEU-096TRP-1')] =   -0.871  
BIND_SILVER['%s-%s' % (dbse, '010LEU-132ILE-1')] =   -0.855  
BIND_SILVER['%s-%s' % (dbse, '010PHE-028ILE-2')] =   -1.550  
BIND_SILVER['%s-%s' % (dbse, '010TRP-022LEU-1')] =   -2.283  
BIND_SILVER['%s-%s' % (dbse, '010TRP-025VAL-1')] =   -1.212  
BIND_SILVER['%s-%s' % (dbse, '010TRP-032ILE-1')] =   -0.438  
BIND_SILVER['%s-%s' % (dbse, '010TRP-032PHE-1')] =   -2.857  
BIND_SILVER['%s-%s' % (dbse, '010TRP-034VAL-1')] =   -1.018  
BIND_SILVER['%s-%s' % (dbse, '010TRP-052TYR-1')] =   -1.336  
BIND_SILVER['%s-%s' % (dbse, '010TRP-058PHE-1')] =   -1.837  
BIND_SILVER['%s-%s' % (dbse, '010TRP-081VAL-1')] =   -2.491  
BIND_SILVER['%s-%s' % (dbse, '010TRP-081VAL-2')] =   -2.499  
BIND_SILVER['%s-%s' % (dbse, '010TYR-017GLU-1')] =    3.286  
BIND_SILVER['%s-%s' % (dbse, '010TYR-049PRO-1')] =   -2.361  
BIND_SILVER['%s-%s' % (dbse, '010TYR-052TYR-1')] =   -3.154  
BIND_SILVER['%s-%s' % (dbse, '010TYR-163TYR-1')] =   -1.459  
BIND_SILVER['%s-%s' % (dbse, '010VAL-027ALA-1')] =   -0.606  
BIND_SILVER['%s-%s' % (dbse, '010VAL-028LEU-1')] =   -0.616  
BIND_SILVER['%s-%s' % (dbse, '010VAL-034TYR-1')] =   -0.865  
BIND_SILVER['%s-%s' % (dbse, '010VAL-040PHE-1')] =   -1.778  
BIND_SILVER['%s-%s' % (dbse, '010VAL-044ALA-1')] =   -0.309  
BIND_SILVER['%s-%s' % (dbse, '011ALA-016GLU-1')] =   -0.844  
BIND_SILVER['%s-%s' % (dbse, '011ASP-091ASN-1')] =  -18.283  
BIND_SILVER['%s-%s' % (dbse, '011CYS-042VAL-1')] =   -0.654  
BIND_SILVER['%s-%s' % (dbse, '011CYS-042VAL-2')] =   -0.776  
BIND_SILVER['%s-%s' % (dbse, '011GLU-062TYR-1')] =    2.761  
BIND_SILVER['%s-%s' % (dbse, '011GLU-100THR-1')] =   -8.909  
BIND_SILVER['%s-%s' % (dbse, '011HIE-015ASN-1')] =    2.032  
BIND_SILVER['%s-%s' % (dbse, '011HIE-304SER-1')] =    1.164  
BIND_SILVER['%s-%s' % (dbse, '011HIE-306ASN-1')] =   -2.989  
BIND_SILVER['%s-%s' % (dbse, '011ILE-017LEU-1')] =   -0.321  
BIND_SILVER['%s-%s' % (dbse, '011ILE-018ALA-1')] =   -0.543  
BIND_SILVER['%s-%s' % (dbse, '011ILE-024ILE-1')] =   -0.588  
BIND_SILVER['%s-%s' % (dbse, '011ILE-024ILE-2')] =   -0.431  
BIND_SILVER['%s-%s' % (dbse, '011ILE-028LEU-1')] =   -0.191  
BIND_SILVER['%s-%s' % (dbse, '011ILE-037LEU-1')] =   -0.094  
BIND_SILVER['%s-%s' % (dbse, '011ILE-038TYR-1')] =   -1.030  
BIND_SILVER['%s-%s' % (dbse, '011ILE-042LEU-1')] =   -0.558  
BIND_SILVER['%s-%s' % (dbse, '011ILE-045VAL-1')] =   -0.483  
BIND_SILVER['%s-%s' % (dbse, '011LEU-062HIE-2')] =   -0.877  
BIND_SILVER['%s-%s' % (dbse, '011LEU-069TYR-1')] =   -0.924  
BIND_SILVER['%s-%s' % (dbse, '011LEU-071GLU-1')] =   -1.099  
BIND_SILVER['%s-%s' % (dbse, '011LEU-102TYR-1')] =   -1.755  
BIND_SILVER['%s-%s' % (dbse, '011LEU-102TYR-2')] =   -1.662  
BIND_SILVER['%s-%s' % (dbse, '011PHE-044TYR-1')] =   -1.161  
BIND_SILVER['%s-%s' % (dbse, '011PRO-020ILE-1')] =   -0.303  
BIND_SILVER['%s-%s' % (dbse, '011SER-223GLU-1')] =  -18.765  
BIND_SILVER['%s-%s' % (dbse, '011THR-017ALA-1')] =   -0.413  
BIND_SILVER['%s-%s' % (dbse, '011THR-166GLU-1')] =   -3.422  
BIND_SILVER['%s-%s' % (dbse, '011THR-166GLU-2')] =  -16.772  
BIND_SILVER['%s-%s' % (dbse, '011TYR-018ARG-1')] =   -8.191  
BIND_SILVER['%s-%s' % (dbse, '011TYR-023ARG-1')] =   -8.063  
BIND_SILVER['%s-%s' % (dbse, '011TYR-051GLU-1')] =  -10.573  
BIND_SILVER['%s-%s' % (dbse, '011TYR-102GLN-1')] =   -3.881  
BIND_SILVER['%s-%s' % (dbse, '011TYR-169ILE-1')] =   -1.313  
BIND_SILVER['%s-%s' % (dbse, '011VAL-144PHE-1')] =   -1.104  
BIND_SILVER['%s-%s' % (dbse, '011VAL-153LYS-1')] =   -0.443  
BIND_SILVER['%s-%s' % (dbse, '011VAL-153LYS-2')] =   -0.649  
BIND_SILVER['%s-%s' % (dbse, '011VAL-155ILE-1')] =   -0.128  
BIND_SILVER['%s-%s' % (dbse, '012ALA-055PHE-1')] =   -0.606  
BIND_SILVER['%s-%s' % (dbse, '012ALA-059PHE-1')] =   -0.942  
BIND_SILVER['%s-%s' % (dbse, '012ALA-108PHE-1')] =   -0.927  
BIND_SILVER['%s-%s' % (dbse, '012ALA-139ALA-1')] =   -0.581  
BIND_SILVER['%s-%s' % (dbse, '012ASN-048PHE-1')] =   -1.474  
BIND_SILVER['%s-%s' % (dbse, '012ASP-024LYS-2')] =  -77.476  
BIND_SILVER['%s-%s' % (dbse, '012ASP-026TYR-1')] =   -7.680  
BIND_SILVER['%s-%s' % (dbse, '012ASP-069TYR-1')] =    3.324  
BIND_SILVER['%s-%s' % (dbse, '012GLN-034GLN-1')] =   -7.047  
BIND_SILVER['%s-%s' % (dbse, '012GLN-044TRP-1')] =   -1.371  
BIND_SILVER['%s-%s' % (dbse, '012GLN-048TYR-1')] =   -1.716  
BIND_SILVER['%s-%s' % (dbse, '012GLU-017GLU-1')] =   -0.931  
BIND_SILVER['%s-%s' % (dbse, '012GLU-019THR-1')] =  -17.395  
BIND_SILVER['%s-%s' % (dbse, '012GLU-068HIE-1')] =   11.959  
BIND_SILVER['%s-%s' % (dbse, '012GLU-070TYR-1')] =   -5.386  
BIND_SILVER['%s-%s' % (dbse, '012HIE-015ILE-1')] =   -1.375  
BIND_SILVER['%s-%s' % (dbse, '012HIE-033LEU-1')] =   -0.829  
BIND_SILVER['%s-%s' % (dbse, '012ILE-016THR-1')] =   -0.678  
BIND_SILVER['%s-%s' % (dbse, '012ILE-018LEU-1')] =   -0.430  
BIND_SILVER['%s-%s' % (dbse, '012ILE-028LEU-1')] =   -0.189  
BIND_SILVER['%s-%s' % (dbse, '012ILE-044ILE-1')] =   -0.890  
BIND_SILVER['%s-%s' % (dbse, '012ILE-046LYS-2')] =    0.005  
BIND_SILVER['%s-%s' % (dbse, '012ILE-046VAL-1')] =   -0.398  
BIND_SILVER['%s-%s' % (dbse, '012LEU-024VAL-1')] =   -0.509  
BIND_SILVER['%s-%s' % (dbse, '012LEU-027PRO-1')] =   -1.228  
BIND_SILVER['%s-%s' % (dbse, '012LEU-033LEU-1')] =   -0.176  
BIND_SILVER['%s-%s' % (dbse, '012LEU-035TRP-1')] =   -1.294  
BIND_SILVER['%s-%s' % (dbse, '012LEU-039ARG-1')] =   -0.696  
BIND_SILVER['%s-%s' % (dbse, '012LEU-047ILE-1')] =   -0.395  
BIND_SILVER['%s-%s' % (dbse, '012LEU-057LEU-1')] =   -0.428  
BIND_SILVER['%s-%s' % (dbse, '012LEU-062HIE-1')] =   -1.744  
BIND_SILVER['%s-%s' % (dbse, '012LEU-064LEU-1')] =   -0.762  
BIND_SILVER['%s-%s' % (dbse, '012LEU-065LEU-1')] =   -0.628  
BIND_SILVER['%s-%s' % (dbse, '012LEU-070MET-1')] =   -0.763  
BIND_SILVER['%s-%s' % (dbse, '012LEU-074VAL-1')] =   -0.099  
BIND_SILVER['%s-%s' % (dbse, '012LEU-083ASN-1')] =   -1.120  
BIND_SILVER['%s-%s' % (dbse, '012LEU-085ASN-1')] =   -0.777  
BIND_SILVER['%s-%s' % (dbse, '012LEU-088TYR-1')] =   -0.593  
BIND_SILVER['%s-%s' % (dbse, '012PHE-026PHE-1')] =   -2.913  
BIND_SILVER['%s-%s' % (dbse, '012PHE-040PHE-1')] =   -1.525  
BIND_SILVER['%s-%s' % (dbse, '012PHE-116PHE-1')] =   -1.399  
BIND_SILVER['%s-%s' % (dbse, '012PHE-163ILE-1')] =   -1.746  
BIND_SILVER['%s-%s' % (dbse, '012PHE-166CYS-1')] =   -1.134  
BIND_SILVER['%s-%s' % (dbse, '012SER-138SER-1')] =   -2.796  
BIND_SILVER['%s-%s' % (dbse, '012SER-166PHE-1')] =   -1.658  
BIND_SILVER['%s-%s' % (dbse, '012TYR-087PRO-1')] =   -4.249  
BIND_SILVER['%s-%s' % (dbse, '012VAL-016LEU-1')] =   -0.310  
BIND_SILVER['%s-%s' % (dbse, '012VAL-023LEU-1')] =   -0.319  
BIND_SILVER['%s-%s' % (dbse, '012VAL-088PHE-1')] =   -1.046  
BIND_SILVER['%s-%s' % (dbse, '012VAL-114PRO-1')] =   -1.015  
BIND_SILVER['%s-%s' % (dbse, '012VAL-146PHE-1')] =   -0.935  
BIND_SILVER['%s-%s' % (dbse, '013ALA-096TRP-1')] =   -2.437  
BIND_SILVER['%s-%s' % (dbse, '013ASN-149ASN-1')] =   -7.635  
BIND_SILVER['%s-%s' % (dbse, '013ASP-016GLU-1')] =   62.779  
BIND_SILVER['%s-%s' % (dbse, '013ASP-023ARG-1')] = -118.098  
BIND_SILVER['%s-%s' % (dbse, '013GLU-039ARG-1')] =  -91.802  
BIND_SILVER['%s-%s' % (dbse, '013GLU-052ILE-1')] =   -1.710  
BIND_SILVER['%s-%s' % (dbse, '013GLU-056GLN-1')] =  -22.477  
BIND_SILVER['%s-%s' % (dbse, '013GLU-065LEU-1')] =   -3.478  
BIND_SILVER['%s-%s' % (dbse, '013GLU-069ARG-1')] = -115.981  
BIND_SILVER['%s-%s' % (dbse, '013HIE-032ALA-1')] =   -0.437  
BIND_SILVER['%s-%s' % (dbse, '013HIE-095HIE-1')] =   -2.645  
BIND_SILVER['%s-%s' % (dbse, '013HIE-121TYR-1')] =  -11.010  
BIND_SILVER['%s-%s' % (dbse, '013ILE-017LEU-1')] =   -0.737  
BIND_SILVER['%s-%s' % (dbse, '013ILE-105ALA-1')] =   -0.423  
BIND_SILVER['%s-%s' % (dbse, '013LEU-017ASN-1')] =   -0.272  
BIND_SILVER['%s-%s' % (dbse, '013LEU-063ILE-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '013LEU-065PHE-1')] =   -1.844  
BIND_SILVER['%s-%s' % (dbse, '013LEU-066ALA-1')] =   -0.455  
BIND_SILVER['%s-%s' % (dbse, '013LEU-069LEU-1')] =   -0.671  
BIND_SILVER['%s-%s' % (dbse, '013LEU-077LEU-1')] =   -0.222  
BIND_SILVER['%s-%s' % (dbse, '013LEU-082VAL-1')] =   -0.547  
BIND_SILVER['%s-%s' % (dbse, '013LEU-084ALA-1')] =   -0.509  
BIND_SILVER['%s-%s' % (dbse, '013PHE-036VAL-1')] =   -0.793  
BIND_SILVER['%s-%s' % (dbse, '013PHE-060TYR-1')] =   -2.256  
BIND_SILVER['%s-%s' % (dbse, '013PHE-062LEU-1')] =   -1.523  
BIND_SILVER['%s-%s' % (dbse, '013PHE-063PRO-1')] =   -1.703  
BIND_SILVER['%s-%s' % (dbse, '013PHE-083ILE-1')] =   -0.991  
BIND_SILVER['%s-%s' % (dbse, '013PHE-085ALA-1')] =   -0.760  
BIND_SILVER['%s-%s' % (dbse, '013PRO-032VAL-1')] =   -0.107  
BIND_SILVER['%s-%s' % (dbse, '013PRO-034GLN-1')] =   -1.578  
BIND_SILVER['%s-%s' % (dbse, '013PRO-129THR-1')] =   -0.999  
BIND_SILVER['%s-%s' % (dbse, '013SER-047TYR-1')] =   -1.384  
BIND_SILVER['%s-%s' % (dbse, '013THR-164GLU-1')] =   -3.046  
BIND_SILVER['%s-%s' % (dbse, '013TYR-075LEU-1')] =   -1.867  
BIND_SILVER['%s-%s' % (dbse, '013TYR-075LEU-2')] =   -1.514  
BIND_SILVER['%s-%s' % (dbse, '013VAL-016PHE-1')] =   -0.620  
BIND_SILVER['%s-%s' % (dbse, '013VAL-066LEU-1')] =   -0.763  
BIND_SILVER['%s-%s' % (dbse, '013VAL-154ASN-1')] =   -1.226  
BIND_SILVER['%s-%s' % (dbse, '013VAL-154ASN-2')] =   -1.165  
BIND_SILVER['%s-%s' % (dbse, '014ALA-055LEU-1')] =   -0.500  
BIND_SILVER['%s-%s' % (dbse, '014ARG-083THR-1')] =    2.654  
BIND_SILVER['%s-%s' % (dbse, '014ASN-027ARG-1')] =   -1.144  
BIND_SILVER['%s-%s' % (dbse, '014ASN-061LYS-1')] =  -24.880  
BIND_SILVER['%s-%s' % (dbse, '014ASN-137TYR-1')] =   -4.556  
BIND_SILVER['%s-%s' % (dbse, '014ASP-017ARG-1')] =  -81.144  
BIND_SILVER['%s-%s' % (dbse, '014GLN-093VAL-1')] =   -0.418  
BIND_SILVER['%s-%s' % (dbse, '014GLU-036LYS-1')] = -121.688  
BIND_SILVER['%s-%s' % (dbse, '014GLU-069ILE-1')] =   -2.698  
BIND_SILVER['%s-%s' % (dbse, '014GLU-164TYR-1')] =  -27.010  
BIND_SILVER['%s-%s' % (dbse, '014HIE-043TYR-1')] =   -1.502  
BIND_SILVER['%s-%s' % (dbse, '014ILE-025TYR-1')] =   -0.744  
BIND_SILVER['%s-%s' % (dbse, '014ILE-027ILE-1')] =   -0.325  
BIND_SILVER['%s-%s' % (dbse, '014ILE-081PHE-1')] =   -1.165  
BIND_SILVER['%s-%s' % (dbse, '014ILE-085ASN-1')] =   -1.476  
BIND_SILVER['%s-%s' % (dbse, '014ILE-088MET-1')] =   -0.885  
BIND_SILVER['%s-%s' % (dbse, '014LEU-061GLN-1')] =   -0.442  
BIND_SILVER['%s-%s' % (dbse, '014LEU-070TRP-1')] =   -1.760  
BIND_SILVER['%s-%s' % (dbse, '014LEU-163ILE-1')] =   -0.600  
BIND_SILVER['%s-%s' % (dbse, '014LEU-174PRO-1')] =   -0.892  
BIND_SILVER['%s-%s' % (dbse, '014LYS-023GLU-1')] = -125.220  
BIND_SILVER['%s-%s' % (dbse, '014SER-017GLU-1')] =  -15.970  
BIND_SILVER['%s-%s' % (dbse, '014SER-084GLN-1')] =   -4.685  
BIND_SILVER['%s-%s' % (dbse, '014TYR-019GLU-1')] =   -3.366  
BIND_SILVER['%s-%s' % (dbse, '014TYR-021PHE-1')] =   -1.664  
BIND_SILVER['%s-%s' % (dbse, '014TYR-022LYS-1')] =   -1.528  
BIND_SILVER['%s-%s' % (dbse, '014TYR-022LYS-2')] =   -1.908  
BIND_SILVER['%s-%s' % (dbse, '014TYR-082PHE-1')] =   -2.856  
BIND_SILVER['%s-%s' % (dbse, '014VAL-091ALA-1')] =   -0.419  
BIND_SILVER['%s-%s' % (dbse, '015ARG-020ASP-1')] = -100.161  
BIND_SILVER['%s-%s' % (dbse, '015ARG-164ALA-1')] =   -0.525  
BIND_SILVER['%s-%s' % (dbse, '015ASN-019THR-1')] =   -5.009  
BIND_SILVER['%s-%s' % (dbse, '015ASN-048GLN-1')] =   -7.222  
BIND_SILVER['%s-%s' % (dbse, '015ASN-069ARG-1')] =   -3.154  
BIND_SILVER['%s-%s' % (dbse, '015ASN-149PHE-1')] =   -1.688  
BIND_SILVER['%s-%s' % (dbse, '015CYS-057LEU-1')] =   -1.125  
BIND_SILVER['%s-%s' % (dbse, '015GLU-019LYS-1')] = -106.742  
BIND_SILVER['%s-%s' % (dbse, '015ILE-019PRO-1')] =   -0.432  
BIND_SILVER['%s-%s' % (dbse, '015ILE-023LEU-1')] =   -0.377  
BIND_SILVER['%s-%s' % (dbse, '015ILE-030LEU-1')] =   -0.866  
BIND_SILVER['%s-%s' % (dbse, '015ILE-034LEU-1')] =   -0.401  
BIND_SILVER['%s-%s' % (dbse, '015ILE-035ARG-1')] =   -0.664  
BIND_SILVER['%s-%s' % (dbse, '015ILE-136HIE-1')] =   -0.545  
BIND_SILVER['%s-%s' % (dbse, '015LEU-035TRP-1')] =   -0.905  
BIND_SILVER['%s-%s' % (dbse, '015LEU-038LEU-1')] =   -0.473  
BIND_SILVER['%s-%s' % (dbse, '015LEU-080PHE-1')] =   -1.651  
BIND_SILVER['%s-%s' % (dbse, '015LEU-084TYR-1')] =   -1.293  
BIND_SILVER['%s-%s' % (dbse, '015LEU-102SER-1')] =    0.291  
BIND_SILVER['%s-%s' % (dbse, '015LYS-047TYR-1')] =   -0.617  
BIND_SILVER['%s-%s' % (dbse, '015LYS-047TYR-2')] =  -13.365  
BIND_SILVER['%s-%s' % (dbse, '015LYS-220ASP-1')] = -107.859  
BIND_SILVER['%s-%s' % (dbse, '015LYS-223GLU-1')] =   -4.508  
BIND_SILVER['%s-%s' % (dbse, '015MET-023LEU-1')] =   -0.898  
BIND_SILVER['%s-%s' % (dbse, '015MET-023LEU-2')] =   -0.889  
BIND_SILVER['%s-%s' % (dbse, '015PHE-039ALA-1')] =   -0.848  
BIND_SILVER['%s-%s' % (dbse, '015PHE-044LEU-1')] =   -1.478  
BIND_SILVER['%s-%s' % (dbse, '015SER-018THR-1')] =   -0.151  
BIND_SILVER['%s-%s' % (dbse, '015SER-037LYS-1')] =   -0.574  
BIND_SILVER['%s-%s' % (dbse, '015THR-019ASP-1')] =   -0.616  
BIND_SILVER['%s-%s' % (dbse, '015THR-021MET-1')] =   -0.881  
BIND_SILVER['%s-%s' % (dbse, '015THR-060HIE-1')] =   -8.898  
BIND_SILVER['%s-%s' % (dbse, '015THR-061GLN-1')] =   -5.474  
BIND_SILVER['%s-%s' % (dbse, '015TRP-025THR-1')] =   -1.146  
BIND_SILVER['%s-%s' % (dbse, '015TRP-096TYR-1')] =   -3.953  
BIND_SILVER['%s-%s' % (dbse, '015TYR-034ILE-1')] =   -1.897  
BIND_SILVER['%s-%s' % (dbse, '015VAL-060TYR-1')] =   -0.967  
BIND_SILVER['%s-%s' % (dbse, '016ARG-047PHE-1')] =   -2.343  
BIND_SILVER['%s-%s' % (dbse, '016GLN-048ILE-1')] =   -0.704  
BIND_SILVER['%s-%s' % (dbse, '016GLN-098LEU-1')] =   -0.425  
BIND_SILVER['%s-%s' % (dbse, '016GLN-101GLN-1')] =   -2.302  
BIND_SILVER['%s-%s' % (dbse, '016GLU-035TRP-1')] =   -2.941  
BIND_SILVER['%s-%s' % (dbse, '016ILE-021VAL-1')] =   -1.170  
BIND_SILVER['%s-%s' % (dbse, '016ILE-145LYS-1')] =   -0.427  
BIND_SILVER['%s-%s' % (dbse, '016ILE-219PRO-1')] =   -0.780  
BIND_SILVER['%s-%s' % (dbse, '016LEU-036LEU-1')] =   -0.209  
BIND_SILVER['%s-%s' % (dbse, '016LEU-046ILE-1')] =   -0.255  
BIND_SILVER['%s-%s' % (dbse, '016LEU-062LEU-1')] =   -0.124  
BIND_SILVER['%s-%s' % (dbse, '016LEU-065LEU-1')] =   -0.514  
BIND_SILVER['%s-%s' % (dbse, '016LEU-072PRO-1')] =   -0.337  
BIND_SILVER['%s-%s' % (dbse, '016LEU-082SER-2')] =    0.372  
BIND_SILVER['%s-%s' % (dbse, '016LEU-137ILE-1')] =   -0.627  
BIND_SILVER['%s-%s' % (dbse, '016LEU-141MET-1')] =   -0.788  
BIND_SILVER['%s-%s' % (dbse, '016LYS-085GLU-1')] = -106.230  
BIND_SILVER['%s-%s' % (dbse, '016PHE-034VAL-1')] =   -1.774  
BIND_SILVER['%s-%s' % (dbse, '016PHE-036VAL-1')] =   -1.688  
BIND_SILVER['%s-%s' % (dbse, '016PHE-132ILE-1')] =   -0.875  
BIND_SILVER['%s-%s' % (dbse, '016PHE-176PHE-1')] =   -2.745  
BIND_SILVER['%s-%s' % (dbse, '016PHE-192LEU-1')] =   -2.113  
BIND_SILVER['%s-%s' % (dbse, '016SER-031ASN-2')] =   -5.318  
BIND_SILVER['%s-%s' % (dbse, '016THR-022MET-1')] =   -1.149  
BIND_SILVER['%s-%s' % (dbse, '016TYR-079ILE-1')] =   -1.581  
BIND_SILVER['%s-%s' % (dbse, '016VAL-033THR-1')] =   -0.280  
BIND_SILVER['%s-%s' % (dbse, '016VAL-055PHE-1')] =   -0.811  
BIND_SILVER['%s-%s' % (dbse, '016VAL-059PHE-1')] =   -1.412  
BIND_SILVER['%s-%s' % (dbse, '016VAL-084ILE-1')] =   -0.384  
BIND_SILVER['%s-%s' % (dbse, '017ARG-056HIE-1')] =   -8.830  
BIND_SILVER['%s-%s' % (dbse, '017ASN-021LYS-1')] =  -19.675  
BIND_SILVER['%s-%s' % (dbse, '017ASN-029ASN-2')] =   -6.784  
BIND_SILVER['%s-%s' % (dbse, '017ASP-049ARG-1')] =  -77.120  
BIND_SILVER['%s-%s' % (dbse, '017ASP-060HIE-1')] =   -7.929  
BIND_SILVER['%s-%s' % (dbse, '017GLN-024ASN-1')] =   -8.284  
BIND_SILVER['%s-%s' % (dbse, '017GLN-093VAL-1')] =    0.249  
BIND_SILVER['%s-%s' % (dbse, '017GLN-094ASP-1')] =  -25.247  
BIND_SILVER['%s-%s' % (dbse, '017GLU-036TRP-1')] =   -3.590  
BIND_SILVER['%s-%s' % (dbse, '017GLU-072PRO-1')] =   -4.920  
BIND_SILVER['%s-%s' % (dbse, '017HIE-033ASP-1')] =  -20.246  
BIND_SILVER['%s-%s' % (dbse, '017HIE-035TRP-1')] =   -6.047  
BIND_SILVER['%s-%s' % (dbse, '017ILE-021LEU-1')] =   -1.160  
BIND_SILVER['%s-%s' % (dbse, '017ILE-028LEU-1')] =   -0.676  
BIND_SILVER['%s-%s' % (dbse, '017ILE-028LEU-2')] =   -0.319  
BIND_SILVER['%s-%s' % (dbse, '017ILE-030PHE-1')] =   -0.856  
BIND_SILVER['%s-%s' % (dbse, '017ILE-055HIE-1')] =   -2.886  
BIND_SILVER['%s-%s' % (dbse, '017ILE-149PHE-1')] =   -2.490  
BIND_SILVER['%s-%s' % (dbse, '017LEU-050ILE-1')] =   -0.387  
BIND_SILVER['%s-%s' % (dbse, '017LEU-056PHE-1')] =   -0.589  
BIND_SILVER['%s-%s' % (dbse, '017LEU-066LEU-1')] =    0.302  
BIND_SILVER['%s-%s' % (dbse, '017LEU-083ILE-1')] =   -0.674  
BIND_SILVER['%s-%s' % (dbse, '017MET-020LYS-1')] =   -1.354  
BIND_SILVER['%s-%s' % (dbse, '017PHE-022SER-2')] =   -3.143  
BIND_SILVER['%s-%s' % (dbse, '017PHE-025TYR-1')] =   -1.728  
BIND_SILVER['%s-%s' % (dbse, '017PHE-077ASP-1')] =   -7.682  
BIND_SILVER['%s-%s' % (dbse, '017PHE-081PHE-1')] =   -2.521  
BIND_SILVER['%s-%s' % (dbse, '017PHE-084LEU-1')] =   -1.429  
BIND_SILVER['%s-%s' % (dbse, '017THR-078GLU-1')] =  -14.693  
BIND_SILVER['%s-%s' % (dbse, '017THR-307TRP-1')] =   -1.747  
BIND_SILVER['%s-%s' % (dbse, '017VAL-049LEU-1')] =   -0.654  
BIND_SILVER['%s-%s' % (dbse, '018ALA-023VAL-1')] =   -0.337  
BIND_SILVER['%s-%s' % (dbse, '018ALA-026GLU-1')] =   -2.936  
BIND_SILVER['%s-%s' % (dbse, '018ALA-027VAL-1')] =   -0.341  
BIND_SILVER['%s-%s' % (dbse, '018ARG-057THR-1')] =   -0.458  
BIND_SILVER['%s-%s' % (dbse, '018ASN-227ALA-1')] =   -1.027  
BIND_SILVER['%s-%s' % (dbse, '018ASP-032THR-1')] =  -20.080  
BIND_SILVER['%s-%s' % (dbse, '018ASP-034ALA-1')] =   -4.253  
BIND_SILVER['%s-%s' % (dbse, '018CYS-132HIE-1')] =   -3.923  
BIND_SILVER['%s-%s' % (dbse, '018GLU-074ILE-1')] =   -1.995  
BIND_SILVER['%s-%s' % (dbse, '018ILE-022GLN-1')] =   -1.313  
BIND_SILVER['%s-%s' % (dbse, '018ILE-052VAL-1')] =   -0.470  
BIND_SILVER['%s-%s' % (dbse, '018ILE-055ASN-1')] =   -1.388  
BIND_SILVER['%s-%s' % (dbse, '018ILE-055PHE-1')] =   -1.069  
BIND_SILVER['%s-%s' % (dbse, '018LEU-039ILE-1')] =    1.673  
BIND_SILVER['%s-%s' % (dbse, '018LYS-024TYR-1')] =   -2.486  
BIND_SILVER['%s-%s' % (dbse, '018PRO-060HIE-1')] =   -1.725  
BIND_SILVER['%s-%s' % (dbse, '018PRO-085GLU-1')] =   -0.486  
BIND_SILVER['%s-%s' % (dbse, '018PRO-086VAL-1')] =   -1.136  
BIND_SILVER['%s-%s' % (dbse, '018PRO-139LEU-1')] =   -0.785  
BIND_SILVER['%s-%s' % (dbse, '018SER-024LEU-1')] =   -0.285  
BIND_SILVER['%s-%s' % (dbse, '018SER-040GLU-1')] =  -18.154  
BIND_SILVER['%s-%s' % (dbse, '018THR-035ILE-1')] =   -0.438  
BIND_SILVER['%s-%s' % (dbse, '018VAL-034ILE-1')] =   -0.641  
BIND_SILVER['%s-%s' % (dbse, '018VAL-164TYR-1')] =   -1.553  
BIND_SILVER['%s-%s' % (dbse, '018VAL-166ILE-1')] =   -0.757  
BIND_SILVER['%s-%s' % (dbse, '019ALA-055HIE-1')] =   -1.503  
BIND_SILVER['%s-%s' % (dbse, '019ALA-058TYR-1')] =   -1.301  
BIND_SILVER['%s-%s' % (dbse, '019ARG-027ARG-1')] =   59.793  
BIND_SILVER['%s-%s' % (dbse, '019ASN-053VAL-1')] =   -0.996  
BIND_SILVER['%s-%s' % (dbse, '019GLN-026GLU-1')] =   -2.028  
BIND_SILVER['%s-%s' % (dbse, '019GLU-022LYS-2')] =   -0.958  
BIND_SILVER['%s-%s' % (dbse, '019GLU-025THR-1')] =  -17.326  
BIND_SILVER['%s-%s' % (dbse, '019ILE-051VAL-1')] =   -0.642  
BIND_SILVER['%s-%s' % (dbse, '019LEU-037ILE-1')] =   -0.568  
BIND_SILVER['%s-%s' % (dbse, '019LEU-041VAL-1')] =   -0.831  
BIND_SILVER['%s-%s' % (dbse, '019LEU-061ARG-1')] =   -0.588  
BIND_SILVER['%s-%s' % (dbse, '019LEU-062LEU-1')] =   -0.812  
BIND_SILVER['%s-%s' % (dbse, '019LEU-062LEU-2')] =   -0.935  
BIND_SILVER['%s-%s' % (dbse, '019LYS-027VAL-1')] =   -0.588  
BIND_SILVER['%s-%s' % (dbse, '019LYS-031HIE-1')] =   -0.549  
BIND_SILVER['%s-%s' % (dbse, '019LYS-071GLU-1')] = -117.104  
BIND_SILVER['%s-%s' % (dbse, '019PHE-049LEU-1')] =   -0.785  
BIND_SILVER['%s-%s' % (dbse, '019SER-023ARG-1')] =   -0.053  
BIND_SILVER['%s-%s' % (dbse, '019SER-023ARG-2')] =   -6.050  
BIND_SILVER['%s-%s' % (dbse, '019SER-026ARG-1')] =  -14.431  
BIND_SILVER['%s-%s' % (dbse, '019THR-022MET-1')] =   -1.311  
BIND_SILVER['%s-%s' % (dbse, '019THR-035GLU-1')] =   -0.915  
BIND_SILVER['%s-%s' % (dbse, '019THR-035GLU-2')] =   -2.837  
BIND_SILVER['%s-%s' % (dbse, '019TYR-050TRP-1')] =   -3.810  
BIND_SILVER['%s-%s' % (dbse, '019VAL-027ILE-1')] =   -0.664  
BIND_SILVER['%s-%s' % (dbse, '019VAL-058VAL-1')] =   -0.074  
BIND_SILVER['%s-%s' % (dbse, '019VAL-075LEU-1')] =   -0.354  
BIND_SILVER['%s-%s' % (dbse, '019VAL-081LEU-1')] =   -0.477  
BIND_SILVER['%s-%s' % (dbse, '019VAL-137ILE-1')] =   -0.248  
BIND_SILVER['%s-%s' % (dbse, '019VAL-138VAL-1')] =   -0.046  
BIND_SILVER['%s-%s' % (dbse, '019VAL-138VAL-2')] =   -0.432  
BIND_SILVER['%s-%s' % (dbse, '020ASN-039LYS-2')] =  -25.444  
BIND_SILVER['%s-%s' % (dbse, '020ASN-040LYS-1')] =  -24.260  
BIND_SILVER['%s-%s' % (dbse, '020ASP-082LYS-1')] =  -79.932  
BIND_SILVER['%s-%s' % (dbse, '020GLN-036TRP-1')] =   -2.928  
BIND_SILVER['%s-%s' % (dbse, '020GLN-059ARG-1')] =   -2.245  
BIND_SILVER['%s-%s' % (dbse, '020HIE-062ASP-2')] =    9.992  
BIND_SILVER['%s-%s' % (dbse, '020HIE-068LYS-1')] =   -2.272  
BIND_SILVER['%s-%s' % (dbse, '020ILE-023VAL-1')] =   -0.315  
BIND_SILVER['%s-%s' % (dbse, '020ILE-032THR-1')] =   -0.614  
BIND_SILVER['%s-%s' % (dbse, '020ILE-082ILE-1')] =   -0.431  
BIND_SILVER['%s-%s' % (dbse, '020ILE-309ALA-1')] =   -0.325  
BIND_SILVER['%s-%s' % (dbse, '020LEU-024VAL-1')] =   -0.876  
BIND_SILVER['%s-%s' % (dbse, '020LEU-038ILE-1')] =   -0.274  
BIND_SILVER['%s-%s' % (dbse, '020LEU-042VAL-1')] =    1.095  
BIND_SILVER['%s-%s' % (dbse, '020LYS-040GLU-1')] = -122.006  
BIND_SILVER['%s-%s' % (dbse, '020PHE-135PHE-1')] =   -2.333  
BIND_SILVER['%s-%s' % (dbse, '020PHE-149LEU-1')] =   -1.086  
BIND_SILVER['%s-%s' % (dbse, '020PRO-023ARG-2')] =    0.756  
BIND_SILVER['%s-%s' % (dbse, '020PRO-177PRO-1')] =   -0.983  
BIND_SILVER['%s-%s' % (dbse, '020PRO-178LYS-1')] =   -0.823  
BIND_SILVER['%s-%s' % (dbse, '020PRO-181ILE-1')] =   -0.080  
BIND_SILVER['%s-%s' % (dbse, '020SER-058VAL-1')] =   -0.139  
BIND_SILVER['%s-%s' % (dbse, '020SER-091ARG-1')] =   -0.604  
BIND_SILVER['%s-%s' % (dbse, '020VAL-029TYR-1')] =   -0.869  
BIND_SILVER['%s-%s' % (dbse, '021ALA-039TYR-1')] =   -0.781  
BIND_SILVER['%s-%s' % (dbse, '021ALA-057VAL-1')] =   -1.252  
BIND_SILVER['%s-%s' % (dbse, '021ALA-100ASN-1')] =   -1.153  
BIND_SILVER['%s-%s' % (dbse, '021ARG-033THR-1')] =   -1.614  
BIND_SILVER['%s-%s' % (dbse, '021ARG-035GLU-1')] =   -4.508  
BIND_SILVER['%s-%s' % (dbse, '021ARG-035GLU-2')] =  -91.902  
BIND_SILVER['%s-%s' % (dbse, '021GLN-024LYS-1')] =  -22.824  
BIND_SILVER['%s-%s' % (dbse, '021GLN-024LYS-2')] =   -1.352  
BIND_SILVER['%s-%s' % (dbse, '021GLN-057TYR-1')] =   -1.948  
BIND_SILVER['%s-%s' % (dbse, '021HIE-061PHE-1')] =   -2.235  
BIND_SILVER['%s-%s' % (dbse, '021ILE-031HIE-1')] =   -0.520  
BIND_SILVER['%s-%s' % (dbse, '021ILE-036VAL-1')] =   -0.590  
BIND_SILVER['%s-%s' % (dbse, '021ILE-038VAL-1')] =   -1.127  
BIND_SILVER['%s-%s' % (dbse, '021ILE-041PHE-1')] =   -1.461  
BIND_SILVER['%s-%s' % (dbse, '021ILE-077LEU-1')] =   -0.063  
BIND_SILVER['%s-%s' % (dbse, '021ILE-088ILE-1')] =   -0.737  
BIND_SILVER['%s-%s' % (dbse, '021LYS-032TYR-1')] =  -11.588  
BIND_SILVER['%s-%s' % (dbse, '021LYS-039ILE-1')] =   -0.732  
BIND_SILVER['%s-%s' % (dbse, '021MET-058TYR-1')] =   -3.841  
BIND_SILVER['%s-%s' % (dbse, '021MET-062GLN-1')] =   -0.779  
BIND_SILVER['%s-%s' % (dbse, '021MET-069ILE-1')] =   -1.181  
BIND_SILVER['%s-%s' % (dbse, '021PHE-025GLN-1')] =   -2.202  
BIND_SILVER['%s-%s' % (dbse, '021PHE-038VAL-1')] =   -0.629  
BIND_SILVER['%s-%s' % (dbse, '021PHE-054ILE-1')] =   -0.834  
BIND_SILVER['%s-%s' % (dbse, '021PHE-060PRO-1')] =   -1.881  
BIND_SILVER['%s-%s' % (dbse, '021PHE-072PHE-1')] =   -2.802  
BIND_SILVER['%s-%s' % (dbse, '021PHE-072THR-1')] =   -1.783  
BIND_SILVER['%s-%s' % (dbse, '021PHE-076VAL-1')] =   -1.172  
BIND_SILVER['%s-%s' % (dbse, '021PHE-079ILE-1')] =   -1.063  
BIND_SILVER['%s-%s' % (dbse, '021PHE-082PHE-1')] =   -2.762  
BIND_SILVER['%s-%s' % (dbse, '021PHE-097LEU-1')] =   -0.533  
BIND_SILVER['%s-%s' % (dbse, '021PHE-097LEU-2')] =   -1.707  
BIND_SILVER['%s-%s' % (dbse, '021PHE-113ILE-1')] =   -0.061  
BIND_SILVER['%s-%s' % (dbse, '021PHE-131VAL-1')] =   -0.968  
BIND_SILVER['%s-%s' % (dbse, '021PHE-251HIE-1')] =   -2.118  
BIND_SILVER['%s-%s' % (dbse, '021PHE-260ILE-1')] =   -1.094  
BIND_SILVER['%s-%s' % (dbse, '021SER-142ASN-1')] =   -1.871  
BIND_SILVER['%s-%s' % (dbse, '021THR-148GLN-1')] =   -0.130  
BIND_SILVER['%s-%s' % (dbse, '021THR-150LYS-1')] =   -0.768  
BIND_SILVER['%s-%s' % (dbse, '021TYR-088PHE-1')] =   -2.521  
BIND_SILVER['%s-%s' % (dbse, '022ARG-072GLU-1')] = -106.296  
BIND_SILVER['%s-%s' % (dbse, '022ARG-073GLU-1')] =  -88.210  
BIND_SILVER['%s-%s' % (dbse, '022GLN-028GLN-1')] =    2.447  
BIND_SILVER['%s-%s' % (dbse, '022GLN-046MET-1')] =   -2.924  
BIND_SILVER['%s-%s' % (dbse, '022GLN-055ASN-1')] =    8.533  
BIND_SILVER['%s-%s' % (dbse, '022GLN-058GLU-1')] =   -3.926  
BIND_SILVER['%s-%s' % (dbse, '022GLN-147TYR-1')] =   -5.468  
BIND_SILVER['%s-%s' % (dbse, '022ILE-072HIE-1')] =   -1.089  
BIND_SILVER['%s-%s' % (dbse, '022ILE-074ILE-1')] =    1.649  
BIND_SILVER['%s-%s' % (dbse, '022LEU-057THR-1')] =   -0.807  
BIND_SILVER['%s-%s' % (dbse, '022LEU-058PHE-1')] =   -1.284  
BIND_SILVER['%s-%s' % (dbse, '022LEU-062ILE-1')] =   -0.711  
BIND_SILVER['%s-%s' % (dbse, '022LEU-065LEU-1')] =   -0.578  
BIND_SILVER['%s-%s' % (dbse, '022LEU-081LYS-2')] =   -0.769  
BIND_SILVER['%s-%s' % (dbse, '022LYS-086ILE-1')] =   -0.734  
BIND_SILVER['%s-%s' % (dbse, '022MET-041VAL-1')] =   -0.677  
BIND_SILVER['%s-%s' % (dbse, '022PHE-027ILE-1')] =   -1.072  
BIND_SILVER['%s-%s' % (dbse, '022PHE-031ILE-1')] =   -1.475  
BIND_SILVER['%s-%s' % (dbse, '022PHE-039TRP-1')] =   -1.944  
BIND_SILVER['%s-%s' % (dbse, '022PHE-040ALA-1')] =   -1.510  
BIND_SILVER['%s-%s' % (dbse, '022PHE-041PHE-1')] =   -1.793  
BIND_SILVER['%s-%s' % (dbse, '022PHE-064VAL-1')] =   -1.017  
BIND_SILVER['%s-%s' % (dbse, '022PHE-069VAL-1')] =   -1.201  
BIND_SILVER['%s-%s' % (dbse, '022PHE-069VAL-2')] =   -1.550  
BIND_SILVER['%s-%s' % (dbse, '022PHE-099ALA-1')] =   -0.875  
BIND_SILVER['%s-%s' % (dbse, '022PHE-166ILE-1')] =   -1.198  
BIND_SILVER['%s-%s' % (dbse, '022PHE-168TYR-1')] =   -2.760  
BIND_SILVER['%s-%s' % (dbse, '022SER-121LEU-1')] =   -0.673  
BIND_SILVER['%s-%s' % (dbse, '022TRP-026THR-1')] =   -1.693  
BIND_SILVER['%s-%s' % (dbse, '022TRP-039TYR-1')] =   -2.202  
BIND_SILVER['%s-%s' % (dbse, '022TRP-040TRP-1')] =   -2.467  
BIND_SILVER['%s-%s' % (dbse, '022TRP-043ILE-1')] =   -0.961  
BIND_SILVER['%s-%s' % (dbse, '022TRP-055LEU-2')] =   -2.081  
BIND_SILVER['%s-%s' % (dbse, '022TRP-059VAL-1')] =   -1.250  
BIND_SILVER['%s-%s' % (dbse, '022VAL-067LEU-1')] =   -0.467  
BIND_SILVER['%s-%s' % (dbse, '022VAL-079TYR-1')] =   -0.874  
BIND_SILVER['%s-%s' % (dbse, '022VAL-079TYR-2')] =   -1.140  
BIND_SILVER['%s-%s' % (dbse, '023ASP-027ARG-1')] = -106.226  
BIND_SILVER['%s-%s' % (dbse, '023ASP-042ARG-1')] = -121.157  
BIND_SILVER['%s-%s' % (dbse, '023ASP-057ARG-1')] = -115.697  
BIND_SILVER['%s-%s' % (dbse, '023GLN-177PRO-1')] =   -1.918  
BIND_SILVER['%s-%s' % (dbse, '023GLN-217THR-1')] =   -6.301  
BIND_SILVER['%s-%s' % (dbse, '023GLU-028LEU-1')] =   -2.198  
BIND_SILVER['%s-%s' % (dbse, '023GLU-046LYS-1')] = -110.517  
BIND_SILVER['%s-%s' % (dbse, '023ILE-060PRO-1')] =   -0.558  
BIND_SILVER['%s-%s' % (dbse, '023LEU-035PHE-1')] =   -0.936  
BIND_SILVER['%s-%s' % (dbse, '023LEU-035PHE-2')] =   -0.897  
BIND_SILVER['%s-%s' % (dbse, '023LEU-036ARG-1')] =   -0.979  
BIND_SILVER['%s-%s' % (dbse, '023LEU-055ILE-1')] =   -0.435  
BIND_SILVER['%s-%s' % (dbse, '023LEU-097LEU-1')] =   -0.563  
BIND_SILVER['%s-%s' % (dbse, '023LYS-029GLU-1')] =  -80.337  
BIND_SILVER['%s-%s' % (dbse, '023LYS-029GLU-2')] =   -4.461  
BIND_SILVER['%s-%s' % (dbse, '023LYS-064TYR-1')] =   -7.757  
BIND_SILVER['%s-%s' % (dbse, '023LYS-064TYR-2')] =   -1.445  
BIND_SILVER['%s-%s' % (dbse, '023MET-038ILE-1')] =   -0.924  
BIND_SILVER['%s-%s' % (dbse, '023SER-051ASN-1')] =    1.612  
BIND_SILVER['%s-%s' % (dbse, '023THR-085ALA-1')] =   -0.291  
BIND_SILVER['%s-%s' % (dbse, '023TYR-026LEU-1')] =   -0.729  
BIND_SILVER['%s-%s' % (dbse, '023TYR-031TYR-1')] =   -3.676  
BIND_SILVER['%s-%s' % (dbse, '023VAL-041ILE-1')] =   -0.164  
BIND_SILVER['%s-%s' % (dbse, '023VAL-055LEU-1')] =   -0.728  
BIND_SILVER['%s-%s' % (dbse, '024ALA-034ALA-1')] =   -0.303  
BIND_SILVER['%s-%s' % (dbse, '024ARG-073ASN-1')] =  -16.418  
BIND_SILVER['%s-%s' % (dbse, '024ARG-076GLU-1')] = -109.546  
BIND_SILVER['%s-%s' % (dbse, '024ASN-027ARG-1')] =  -25.040  
BIND_SILVER['%s-%s' % (dbse, '024ASN-027LEU-2')] =   -2.329  
BIND_SILVER['%s-%s' % (dbse, '024ASN-029ILE-1')] =   -0.740  
BIND_SILVER['%s-%s' % (dbse, '024ASN-034TYR-1')] =   -4.245  
BIND_SILVER['%s-%s' % (dbse, '024ASN-056PHE-1')] =   -2.020  
BIND_SILVER['%s-%s' % (dbse, '024ASN-058TYR-1')] =   -4.703  
BIND_SILVER['%s-%s' % (dbse, '024ASP-065HIE-1')] =  -26.726  
BIND_SILVER['%s-%s' % (dbse, '024CYS-100ASN-1')] =   -2.632  
BIND_SILVER['%s-%s' % (dbse, '024GLU-040HIE-1')] =  -25.279  
BIND_SILVER['%s-%s' % (dbse, '024GLU-041LEU-1')] =   -0.964  
BIND_SILVER['%s-%s' % (dbse, '024GLU-050ARG-1')] =   -4.573  
BIND_SILVER['%s-%s' % (dbse, '024GLU-054ARG-1')] = -105.452  
BIND_SILVER['%s-%s' % (dbse, '024ILE-055TYR-1')] =   -0.902  
BIND_SILVER['%s-%s' % (dbse, '024LEU-028GLU-1')] =   -0.600  
BIND_SILVER['%s-%s' % (dbse, '024LEU-028GLU-2')] =   -2.471  
BIND_SILVER['%s-%s' % (dbse, '024LEU-029GLU-1')] =   -2.050  
BIND_SILVER['%s-%s' % (dbse, '024LEU-031LEU-1')] =   -1.060  
BIND_SILVER['%s-%s' % (dbse, '024LEU-032VAL-1')] =   -0.500  
BIND_SILVER['%s-%s' % (dbse, '024LEU-054VAL-1')] =   -0.565  
BIND_SILVER['%s-%s' % (dbse, '024LEU-260ILE-1')] =   -1.186  
BIND_SILVER['%s-%s' % (dbse, '024LEU-261ASN-1')] =   -1.254  
BIND_SILVER['%s-%s' % (dbse, '024LYS-057TYR-1')] =   -1.109  
BIND_SILVER['%s-%s' % (dbse, '024LYS-069TYR-1')] =   -2.137  
BIND_SILVER['%s-%s' % (dbse, '024LYS-069TYR-2')] =   -9.579  
BIND_SILVER['%s-%s' % (dbse, '024PHE-089LEU-1')] =   -0.086  
BIND_SILVER['%s-%s' % (dbse, '024PHE-089THR-1')] =   -0.480  
BIND_SILVER['%s-%s' % (dbse, '024PHE-099TRP-1')] =   -3.193  
BIND_SILVER['%s-%s' % (dbse, '024PHE-100SER-1')] =   -0.956  
BIND_SILVER['%s-%s' % (dbse, '024PHE-130LYS-1')] =   -1.441  
BIND_SILVER['%s-%s' % (dbse, '024SER-038THR-1')] =    3.878  
BIND_SILVER['%s-%s' % (dbse, '024THR-041GLU-1')] =   -3.946  
BIND_SILVER['%s-%s' % (dbse, '024VAL-032HIE-1')] =   -1.196  
BIND_SILVER['%s-%s' % (dbse, '024VAL-049ILE-1')] =   -0.550  
BIND_SILVER['%s-%s' % (dbse, '024VAL-054PHE-1')] =   -0.914  
BIND_SILVER['%s-%s' % (dbse, '024VAL-079PHE-1')] =   -2.160  
BIND_SILVER['%s-%s' % (dbse, '024VAL-142VAL-1')] =   -0.418  
BIND_SILVER['%s-%s' % (dbse, '024VAL-143GLN-1')] =   -1.316  
BIND_SILVER['%s-%s' % (dbse, '025ALA-035TRP-1')] =   -0.869  
BIND_SILVER['%s-%s' % (dbse, '025ALA-037ALA-1')] =   -0.683  
BIND_SILVER['%s-%s' % (dbse, '025ASN-181ASN-1')] =   -7.603  
BIND_SILVER['%s-%s' % (dbse, '025ASN-183THR-1')] =   -5.856  
BIND_SILVER['%s-%s' % (dbse, '025GLN-029LYS-1')] =   -1.277  
BIND_SILVER['%s-%s' % (dbse, '025GLN-036THR-1')] =    1.019  
BIND_SILVER['%s-%s' % (dbse, '025GLN-039TYR-1')] =   -4.303  
BIND_SILVER['%s-%s' % (dbse, '025GLN-260ILE-1')] =   -0.673  
BIND_SILVER['%s-%s' % (dbse, '025GLN-274ILE-1')] =   -1.014  
BIND_SILVER['%s-%s' % (dbse, '025ILE-028VAL-1')] =   -0.515  
BIND_SILVER['%s-%s' % (dbse, '025ILE-036VAL-1')] =   -0.570  
BIND_SILVER['%s-%s' % (dbse, '025ILE-056LEU-1')] =   -0.309  
BIND_SILVER['%s-%s' % (dbse, '025ILE-059ASP-1')] =   -2.025  
BIND_SILVER['%s-%s' % (dbse, '025ILE-084ILE-1')] =    0.042  
BIND_SILVER['%s-%s' % (dbse, '025ILE-084ILE-2')] =   -0.380  
BIND_SILVER['%s-%s' % (dbse, '025ILE-090ALA-1')] =   -0.505  
BIND_SILVER['%s-%s' % (dbse, '025ILE-091VAL-1')] =   -0.424  
BIND_SILVER['%s-%s' % (dbse, '025LEU-055VAL-1')] =   -0.448  
BIND_SILVER['%s-%s' % (dbse, '025LEU-060PRO-1')] =   -0.801  
BIND_SILVER['%s-%s' % (dbse, '025LEU-075ILE-1')] =   -0.737  
BIND_SILVER['%s-%s' % (dbse, '025LEU-075ILE-2')] =   -0.503  
BIND_SILVER['%s-%s' % (dbse, '025SER-035ALA-1')] =   -0.284  
BIND_SILVER['%s-%s' % (dbse, '025SER-075ASP-1')] =    4.103  
BIND_SILVER['%s-%s' % (dbse, '025SER-100ILE-1')] =   -1.283  
BIND_SILVER['%s-%s' % (dbse, '025THR-045THR-1')] =   -4.654  
BIND_SILVER['%s-%s' % (dbse, '025THR-100TRP-1')] =   -1.309  
BIND_SILVER['%s-%s' % (dbse, '025THR-103LYS-1')] =  -17.193  
BIND_SILVER['%s-%s' % (dbse, '025TRP-038MET-1')] =   -0.767  
BIND_SILVER['%s-%s' % (dbse, '025TRP-135ALA-1')] =   -1.138  
BIND_SILVER['%s-%s' % (dbse, '025TRP-144LYS-1')] =   -0.959  
BIND_SILVER['%s-%s' % (dbse, '025TRP-146PHE-1')] =   -4.554  
BIND_SILVER['%s-%s' % (dbse, '025TRP-152GLU-1')] =  -22.177  
BIND_SILVER['%s-%s' % (dbse, '025TYR-080ARG-1')] =   -2.456  
BIND_SILVER['%s-%s' % (dbse, '025TYR-081PHE-1')] =   -2.052  
BIND_SILVER['%s-%s' % (dbse, '025TYR-084LEU-1')] =   -1.535  
BIND_SILVER['%s-%s' % (dbse, '025VAL-029TRP-1')] =   -0.867  
BIND_SILVER['%s-%s' % (dbse, '025VAL-057VAL-1')] =   -0.624  
BIND_SILVER['%s-%s' % (dbse, '025VAL-069ILE-1')] =   -0.748  
BIND_SILVER['%s-%s' % (dbse, '025VAL-083GLU-2')] =   -1.565  
BIND_SILVER['%s-%s' % (dbse, '025VAL-185ARG-1')] =   -0.708  
BIND_SILVER['%s-%s' % (dbse, '026ASN-054ASN-1')] =   -7.685  
BIND_SILVER['%s-%s' % (dbse, '026ASN-055ILE-1')] =   -1.170  
BIND_SILVER['%s-%s' % (dbse, '026ASN-058GLU-1')] =  -15.770  
BIND_SILVER['%s-%s' % (dbse, '026ASP-042PHE-1')] =   -1.382  
BIND_SILVER['%s-%s' % (dbse, '026ASP-077PHE-1')] =   -3.667  
BIND_SILVER['%s-%s' % (dbse, '026GLN-065HIE-1')] =   -0.872  
BIND_SILVER['%s-%s' % (dbse, '026GLN-065HIE-2')] =   -1.095  
BIND_SILVER['%s-%s' % (dbse, '026GLU-042HIE-1')] =   12.899  
BIND_SILVER['%s-%s' % (dbse, '026GLU-057TYR-2')] =  -25.189  
BIND_SILVER['%s-%s' % (dbse, '026GLU-059ARG-1')] =  -99.314  
BIND_SILVER['%s-%s' % (dbse, '026ILE-037TRP-1')] =   -1.137  
BIND_SILVER['%s-%s' % (dbse, '026ILE-078ALA-1')] =   -0.356  
BIND_SILVER['%s-%s' % (dbse, '026LEU-037PHE-1')] =   -0.647  
BIND_SILVER['%s-%s' % (dbse, '026LEU-039ILE-1')] =   -0.782  
BIND_SILVER['%s-%s' % (dbse, '026LEU-040GLU-1')] =   -1.990  
BIND_SILVER['%s-%s' % (dbse, '026LEU-041VAL-1')] =   -1.101  
BIND_SILVER['%s-%s' % (dbse, '026LEU-135ALA-1')] =   -0.759  
BIND_SILVER['%s-%s' % (dbse, '026MET-029PHE-1')] =   -2.543  
BIND_SILVER['%s-%s' % (dbse, '026MET-099ALA-1')] =   -0.721  
BIND_SILVER['%s-%s' % (dbse, '026MET-103HIE-1')] =   -2.993  
BIND_SILVER['%s-%s' % (dbse, '026MET-168TYR-1')] =   -1.460  
BIND_SILVER['%s-%s' % (dbse, '026PHE-030TRP-1')] =   -2.012  
BIND_SILVER['%s-%s' % (dbse, '026PHE-036PHE-1')] =   -1.826  
BIND_SILVER['%s-%s' % (dbse, '026PHE-118ILE-1')] =   -1.161  
BIND_SILVER['%s-%s' % (dbse, '026PHE-217THR-1')] =   -3.225  
BIND_SILVER['%s-%s' % (dbse, '026THR-031LEU-1')] =   -0.412  
BIND_SILVER['%s-%s' % (dbse, '026TYR-062ILE-1')] =   -0.975  
BIND_SILVER['%s-%s' % (dbse, '026TYR-069TYR-1')] =   -2.879  
BIND_SILVER['%s-%s' % (dbse, '026VAL-041GLU-1')] =   -2.375  
BIND_SILVER['%s-%s' % (dbse, '026VAL-041GLU-2')] =   -2.162  
BIND_SILVER['%s-%s' % (dbse, '027ALA-074LEU-1')] =   -0.818  
BIND_SILVER['%s-%s' % (dbse, '027ALA-102ASN-1')] =   -1.332  
BIND_SILVER['%s-%s' % (dbse, '027ARG-049GLU-1')] =  -96.796  
BIND_SILVER['%s-%s' % (dbse, '027ARG-055THR-1')] =   -2.306  
BIND_SILVER['%s-%s' % (dbse, '027ARG-094ASP-1')] =  -97.470  
BIND_SILVER['%s-%s' % (dbse, '027ILE-039THR-1')] =   -0.612  
BIND_SILVER['%s-%s' % (dbse, '027ILE-046PHE-1')] =   -0.657  
BIND_SILVER['%s-%s' % (dbse, '027ILE-075LEU-1')] =   -0.493  
BIND_SILVER['%s-%s' % (dbse, '027LYS-089LEU-1')] =   -0.733  
BIND_SILVER['%s-%s' % (dbse, '027PHE-030ILE-1')] =   -1.488  
BIND_SILVER['%s-%s' % (dbse, '027PHE-057VAL-1')] =   -2.070  
BIND_SILVER['%s-%s' % (dbse, '027PHE-069SER-1')] =   -2.045  
BIND_SILVER['%s-%s' % (dbse, '027PHE-071VAL-1')] =   -0.914  
BIND_SILVER['%s-%s' % (dbse, '027PHE-078GLN-1')] =   -2.608  
BIND_SILVER['%s-%s' % (dbse, '027PRO-032MET-1')] =   -1.014  
BIND_SILVER['%s-%s' % (dbse, '027SER-034ILE-1')] =   -0.665  
BIND_SILVER['%s-%s' % (dbse, '027THR-036SER-1')] =   -5.604  
BIND_SILVER['%s-%s' % (dbse, '027VAL-070TRP-1')] =   -2.488  
BIND_SILVER['%s-%s' % (dbse, '027VAL-085ALA-1')] =   -0.498  
BIND_SILVER['%s-%s' % (dbse, '027VAL-086TYR-1')] =   -1.392  
BIND_SILVER['%s-%s' % (dbse, '027VAL-088ILE-1')] =   -0.015  
BIND_SILVER['%s-%s' % (dbse, '027VAL-090THR-1')] =   -0.455  
BIND_SILVER['%s-%s' % (dbse, '028ALA-038VAL-1')] =   -0.161  
BIND_SILVER['%s-%s' % (dbse, '028ALA-041VAL-1')] =   -0.262  
BIND_SILVER['%s-%s' % (dbse, '028ARG-031GLN-1')] =  -17.639  
BIND_SILVER['%s-%s' % (dbse, '028GLU-072HIE-1')] =  -24.726  
BIND_SILVER['%s-%s' % (dbse, '028GLU-097LYS-1')] = -114.301  
BIND_SILVER['%s-%s' % (dbse, '028ILE-036LEU-1')] =   -0.509  
BIND_SILVER['%s-%s' % (dbse, '028ILE-091VAL-1')] =   -0.467  
BIND_SILVER['%s-%s' % (dbse, '028ILE-106VAL-1')] =    0.749  
BIND_SILVER['%s-%s' % (dbse, '028ILE-151VAL-1')] =   -0.843  
BIND_SILVER['%s-%s' % (dbse, '028LEU-037VAL-1')] =   -0.730  
BIND_SILVER['%s-%s' % (dbse, '028LEU-055LYS-1')] =   -2.258  
BIND_SILVER['%s-%s' % (dbse, '028LEU-058ALA-1')] =   -0.862  
BIND_SILVER['%s-%s' % (dbse, '028LEU-059ARG-2')] =   -0.768  
BIND_SILVER['%s-%s' % (dbse, '028LEU-061GLU-1')] =   -1.051  
BIND_SILVER['%s-%s' % (dbse, '028LEU-133PHE-1')] =   -0.695  
BIND_SILVER['%s-%s' % (dbse, '028LYS-067TYR-1')] =   -2.614  
BIND_SILVER['%s-%s' % (dbse, '028LYS-317ASN-1')] =  -21.217  
BIND_SILVER['%s-%s' % (dbse, '028MET-031ASP-1')] =   -4.051  
BIND_SILVER['%s-%s' % (dbse, '028MET-037ARG-2')] =   -0.789  
BIND_SILVER['%s-%s' % (dbse, '028MET-040HIE-1')] =   -2.478  
BIND_SILVER['%s-%s' % (dbse, '028PRO-058LEU-1')] =   -0.740  
BIND_SILVER['%s-%s' % (dbse, '028PRO-111LEU-1')] =   -1.038  
BIND_SILVER['%s-%s' % (dbse, '028SER-055THR-1')] =   -4.775  
BIND_SILVER['%s-%s' % (dbse, '028SER-056GLU-1')] =   -2.805  
BIND_SILVER['%s-%s' % (dbse, '028VAL-031THR-1')] =    2.253  
BIND_SILVER['%s-%s' % (dbse, '028VAL-036MET-1')] =    1.507  
BIND_SILVER['%s-%s' % (dbse, '028VAL-038VAL-1')] =   -0.616  
BIND_SILVER['%s-%s' % (dbse, '028VAL-058PHE-1')] =   -2.391  
BIND_SILVER['%s-%s' % (dbse, '028VAL-085GLU-1')] =   -0.465  
BIND_SILVER['%s-%s' % (dbse, '028VAL-086ASN-1')] =   -0.241  
BIND_SILVER['%s-%s' % (dbse, '028VAL-105PHE-1')] =   -0.759  
BIND_SILVER['%s-%s' % (dbse, '028VAL-128PHE-1')] =   -0.234  
BIND_SILVER['%s-%s' % (dbse, '028VAL-170LEU-1')] =    0.027  
BIND_SILVER['%s-%s' % (dbse, '029ALA-274ILE-1')] =   -0.664  
BIND_SILVER['%s-%s' % (dbse, '029ASN-034LYS-2')] =  -27.247  
BIND_SILVER['%s-%s' % (dbse, '029ASN-179SER-1')] =    0.146  
BIND_SILVER['%s-%s' % (dbse, '029ASP-070ASP-1')] =   81.626  
BIND_SILVER['%s-%s' % (dbse, '029GLN-033ASP-1')] =    5.028  
BIND_SILVER['%s-%s' % (dbse, '029GLU-045LEU-1')] =   -2.392  
BIND_SILVER['%s-%s' % (dbse, '029GLU-055SER-1')] =  -18.954  
BIND_SILVER['%s-%s' % (dbse, '029LEU-034VAL-1')] =   -0.524  
BIND_SILVER['%s-%s' % (dbse, '029LEU-036PHE-2')] =   -2.096  
BIND_SILVER['%s-%s' % (dbse, '029LEU-040GLU-1')] =   -0.714  
BIND_SILVER['%s-%s' % (dbse, '029LEU-045GLN-1')] =   -1.207  
BIND_SILVER['%s-%s' % (dbse, '029LEU-095TYR-1')] =   -1.455  
BIND_SILVER['%s-%s' % (dbse, '029LYS-035GLU-1')] =   -2.613  
BIND_SILVER['%s-%s' % (dbse, '029PHE-094LEU-1')] =   -0.956  
BIND_SILVER['%s-%s' % (dbse, '029PHE-101TRP-1')] =   -1.580  
BIND_SILVER['%s-%s' % (dbse, '029PHE-103HIE-1')] =   -0.541  
BIND_SILVER['%s-%s' % (dbse, '029PHE-168TYR-1')] =   -2.206  
BIND_SILVER['%s-%s' % (dbse, '029PHE-177ILE-1')] =   -1.183  
BIND_SILVER['%s-%s' % (dbse, '029PRO-085GLU-1')] =  -10.971  
BIND_SILVER['%s-%s' % (dbse, '029THR-121TYR-1')] =   -1.582  
BIND_SILVER['%s-%s' % (dbse, '029THR-121TYR-2')] =   -4.577  
BIND_SILVER['%s-%s' % (dbse, '029TRP-302SER-1')] =   -0.997  
BIND_SILVER['%s-%s' % (dbse, '029TRP-305ILE-1')] =   -2.697  
BIND_SILVER['%s-%s' % (dbse, '029TRP-308ASP-1')] =   -8.944  
BIND_SILVER['%s-%s' % (dbse, '029TRP-315PHE-1')] =   -2.066  
BIND_SILVER['%s-%s' % (dbse, '029TYR-049GLU-1')] =   -2.343  
BIND_SILVER['%s-%s' % (dbse, '029VAL-036VAL-1')] =   -0.511  
BIND_SILVER['%s-%s' % (dbse, '029VAL-054LEU-1')] =   -0.261  
BIND_SILVER['%s-%s' % (dbse, '029VAL-087LEU-1')] =   -0.070  
BIND_SILVER['%s-%s' % (dbse, '030ALA-274ILE-1')] =   -0.831  
BIND_SILVER['%s-%s' % (dbse, '030ASP-320ARG-1')] = -101.399  
BIND_SILVER['%s-%s' % (dbse, '030GLN-034TRP-1')] =   -1.808  
BIND_SILVER['%s-%s' % (dbse, '030GLN-034TRP-2')] =   -3.477  
BIND_SILVER['%s-%s' % (dbse, '030GLN-036MET-1')] =   -2.131  
BIND_SILVER['%s-%s' % (dbse, '030GLU-033GLN-1')] =  -16.157  
BIND_SILVER['%s-%s' % (dbse, '030GLU-034ASP-1')] =   67.257  
BIND_SILVER['%s-%s' % (dbse, '030GLU-038PHE-1')] =   -1.187  
BIND_SILVER['%s-%s' % (dbse, '030GLU-042PHE-1')] =   -0.938  
BIND_SILVER['%s-%s' % (dbse, '030GLU-049PHE-1')] =   -5.528  
BIND_SILVER['%s-%s' % (dbse, '030GLU-061LYS-1')] = -115.293  
BIND_SILVER['%s-%s' % (dbse, '030ILE-034LEU-1')] =   -0.595  
BIND_SILVER['%s-%s' % (dbse, '030ILE-055ILE-1')] =    1.249  
BIND_SILVER['%s-%s' % (dbse, '030ILE-093TYR-1')] =   -1.137  
BIND_SILVER['%s-%s' % (dbse, '030LEU-034LEU-1')] =   -0.583  
BIND_SILVER['%s-%s' % (dbse, '030LYS-078TYR-2')] =   -7.249  
BIND_SILVER['%s-%s' % (dbse, '030LYS-083GLU-1')] = -119.161  
BIND_SILVER['%s-%s' % (dbse, '030LYS-085GLU-1')] =   -4.778  
BIND_SILVER['%s-%s' % (dbse, '030LYS-169THR-1')] =  -16.263  
BIND_SILVER['%s-%s' % (dbse, '030PHE-042LEU-1')] =   -0.827  
BIND_SILVER['%s-%s' % (dbse, '030PHE-044ILE-1')] =   -0.892  
BIND_SILVER['%s-%s' % (dbse, '030PHE-061GLU-2')] =   -1.339  
BIND_SILVER['%s-%s' % (dbse, '030PHE-151ILE-1')] =   -2.625  
BIND_SILVER['%s-%s' % (dbse, '030PRO-057MET-1')] =   -0.242  
BIND_SILVER['%s-%s' % (dbse, '030SER-109GLU-1')] =  -17.919  
BIND_SILVER['%s-%s' % (dbse, '030THR-121LYS-1')] =    0.899  
BIND_SILVER['%s-%s' % (dbse, '030TRP-033THR-1')] =   -0.489  
BIND_SILVER['%s-%s' % (dbse, '030TRP-036PHE-1')] =   -3.358  
BIND_SILVER['%s-%s' % (dbse, '030TRP-042GLU-1')] =  -20.882  
BIND_SILVER['%s-%s' % (dbse, '030TRP-046LEU-1')] =   -2.872  
BIND_SILVER['%s-%s' % (dbse, '030TRP-073PHE-1')] =   -1.184  
BIND_SILVER['%s-%s' % (dbse, '030TRP-079LEU-1')] =   -0.506  
BIND_SILVER['%s-%s' % (dbse, '030TRP-103PHE-1')] =   -3.647  
BIND_SILVER['%s-%s' % (dbse, '030TRP-171THR-1')] =   -0.812  
BIND_SILVER['%s-%s' % (dbse, '030TRP-176SER-2')] =   -5.892  
BIND_SILVER['%s-%s' % (dbse, '030TRP-212GLU-1')] =  -18.115  
BIND_SILVER['%s-%s' % (dbse, '030TRP-213GLU-1')] =   -5.037  
BIND_SILVER['%s-%s' % (dbse, '030TRP-216SER-1')] =   -1.227  
BIND_SILVER['%s-%s' % (dbse, '030TRP-217THR-1')] =   -1.111  
BIND_SILVER['%s-%s' % (dbse, '030VAL-033VAL-1')] =   -0.091  
BIND_SILVER['%s-%s' % (dbse, '030VAL-044LEU-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '030VAL-050ILE-1')] =   -0.826  
BIND_SILVER['%s-%s' % (dbse, '031ALA-088VAL-1')] =   -0.328  
BIND_SILVER['%s-%s' % (dbse, '031ASP-034HIE-1')] =   19.747  
BIND_SILVER['%s-%s' % (dbse, '031HIE-035LEU-1')] =   -0.974  
BIND_SILVER['%s-%s' % (dbse, '031HIE-037SER-1')] =   -5.921  
BIND_SILVER['%s-%s' % (dbse, '031HIE-109LEU-1')] =   -0.632  
BIND_SILVER['%s-%s' % (dbse, '031HIE-125LEU-1')] =   -0.985  
BIND_SILVER['%s-%s' % (dbse, '031HIE-128GLU-1')] =  -15.560  
BIND_SILVER['%s-%s' % (dbse, '031ILE-034ILE-1')] =   -0.564  
BIND_SILVER['%s-%s' % (dbse, '031ILE-097TRP-1')] =   -1.153  
BIND_SILVER['%s-%s' % (dbse, '031ILE-246ALA-1')] =   -0.140  
BIND_SILVER['%s-%s' % (dbse, '031LEU-091LEU-1')] =   -0.369  
BIND_SILVER['%s-%s' % (dbse, '031LEU-125LEU-1')] =   -0.583  
BIND_SILVER['%s-%s' % (dbse, '031LEU-168LEU-1')] =   -0.690  
BIND_SILVER['%s-%s' % (dbse, '031LEU-213GLU-1')] =   -2.607  
BIND_SILVER['%s-%s' % (dbse, '031PHE-060THR-1')] =   -0.858  
BIND_SILVER['%s-%s' % (dbse, '031PHE-061ILE-1')] =   -1.143  
BIND_SILVER['%s-%s' % (dbse, '031PHE-062HIE-1')] =   -1.375  
BIND_SILVER['%s-%s' % (dbse, '031PHE-076ALA-1')] =   -0.572  
BIND_SILVER['%s-%s' % (dbse, '031PHE-092TRP-2')] =   -2.854  
BIND_SILVER['%s-%s' % (dbse, '031PHE-095TYR-1')] =   -2.470  
BIND_SILVER['%s-%s' % (dbse, '031PRO-097VAL-1')] =   -0.405  
BIND_SILVER['%s-%s' % (dbse, '031THR-085GLU-1')] =  -17.264  
BIND_SILVER['%s-%s' % (dbse, '031THR-128PHE-1')] =   -1.640  
BIND_SILVER['%s-%s' % (dbse, '031TRP-060ASP-1')] =  -23.625  
BIND_SILVER['%s-%s' % (dbse, '031TRP-164VAL-1')] =   -1.937  
BIND_SILVER['%s-%s' % (dbse, '031TRP-168GLN-1')] =   -2.474  
BIND_SILVER['%s-%s' % (dbse, '031TRP-168GLN-2')] =   -3.351  
BIND_SILVER['%s-%s' % (dbse, '031TRP-171ALA-1')] =   -1.345  
BIND_SILVER['%s-%s' % (dbse, '031TYR-037PHE-2')] =   -3.013  
BIND_SILVER['%s-%s' % (dbse, '031TYR-048HIE-1')] =   -2.513  
BIND_SILVER['%s-%s' % (dbse, '031TYR-051GLN-1')] =   -2.538  
BIND_SILVER['%s-%s' % (dbse, '031VAL-056PHE-1')] =   -0.895  
BIND_SILVER['%s-%s' % (dbse, '031VAL-068LEU-1')] =   -0.968  
BIND_SILVER['%s-%s' % (dbse, '031VAL-071VAL-1')] =   -0.649  
BIND_SILVER['%s-%s' % (dbse, '031VAL-073VAL-1')] =   -0.597  
BIND_SILVER['%s-%s' % (dbse, '031VAL-077ILE-1')] =   -1.116  
BIND_SILVER['%s-%s' % (dbse, '032ASP-040HIE-1')] =   -3.847  
BIND_SILVER['%s-%s' % (dbse, '032GLN-116ASP-1')] =  -21.335  
BIND_SILVER['%s-%s' % (dbse, '032GLU-035ARG-1')] = -115.217  
BIND_SILVER['%s-%s' % (dbse, '032GLU-169THR-1')] =   -3.422  
BIND_SILVER['%s-%s' % (dbse, '032GLU-169THR-2')] =  -17.168  
BIND_SILVER['%s-%s' % (dbse, '032ILE-036GLU-1')] =   -0.777  
BIND_SILVER['%s-%s' % (dbse, '032ILE-065LEU-1')] =    0.757  
BIND_SILVER['%s-%s' % (dbse, '032LYS-080GLU-2')] = -107.701  
BIND_SILVER['%s-%s' % (dbse, '032LYS-083LEU-1')] =   -0.909  
BIND_SILVER['%s-%s' % (dbse, '032LYS-091LEU-1')] =   -2.679  
BIND_SILVER['%s-%s' % (dbse, '032LYS-091LEU-2')] =   -0.572  
BIND_SILVER['%s-%s' % (dbse, '032PHE-058ASP-1')] =   -2.299  
BIND_SILVER['%s-%s' % (dbse, '032PHE-081VAL-1')] =   -0.886  
BIND_SILVER['%s-%s' % (dbse, '032PHE-095LEU-1')] =   -2.033  
BIND_SILVER['%s-%s' % (dbse, '032SER-057GLU-1')] =  -16.437  
BIND_SILVER['%s-%s' % (dbse, '032THR-093LYS-1')] =   -0.726  
BIND_SILVER['%s-%s' % (dbse, '032THR-094LEU-1')] =   -0.918  
BIND_SILVER['%s-%s' % (dbse, '032THR-128LEU-1')] =   -0.368  
BIND_SILVER['%s-%s' % (dbse, '032TRP-062ALA-1')] =   -1.796  
BIND_SILVER['%s-%s' % (dbse, '032TRP-073PHE-1')] =   -3.204  
BIND_SILVER['%s-%s' % (dbse, '032TRP-074VAL-1')] =   -0.941  
BIND_SILVER['%s-%s' % (dbse, '032TRP-083ASN-1')] =   -7.755  
BIND_SILVER['%s-%s' % (dbse, '032VAL-042ILE-1')] =    0.407  
BIND_SILVER['%s-%s' % (dbse, '032VAL-052VAL-1')] =   -1.221  
BIND_SILVER['%s-%s' % (dbse, '032VAL-056HIE-1')] =   -0.865  
BIND_SILVER['%s-%s' % (dbse, '032VAL-068LEU-1')] =   -0.487  
BIND_SILVER['%s-%s' % (dbse, '032VAL-080ARG-1')] =    0.236  
BIND_SILVER['%s-%s' % (dbse, '032VAL-100VAL-1')] =   -0.268  
BIND_SILVER['%s-%s' % (dbse, '033ARG-189PRO-1')] =   -2.275  
BIND_SILVER['%s-%s' % (dbse, '033ARG-191LEU-1')] =   -0.753  
BIND_SILVER['%s-%s' % (dbse, '033ARG-191LEU-2')] =   -2.235  
BIND_SILVER['%s-%s' % (dbse, '033ASP-276SER-1')] =  -17.696  
BIND_SILVER['%s-%s' % (dbse, '033ASP-279LYS-1')] = -122.143  
BIND_SILVER['%s-%s' % (dbse, '033ASP-279LYS-2')] =   -3.818  
BIND_SILVER['%s-%s' % (dbse, '033CYS-047TYR-1')] =   -3.399  
BIND_SILVER['%s-%s' % (dbse, '033GLN-092ASN-2')] =   -8.041  
BIND_SILVER['%s-%s' % (dbse, '033GLU-036ARG-1')] = -117.081  
BIND_SILVER['%s-%s' % (dbse, '033HIE-060MET-2')] =   -2.366  
BIND_SILVER['%s-%s' % (dbse, '033HIE-062THR-1')] =    4.468  
BIND_SILVER['%s-%s' % (dbse, '033ILE-037ASP-1')] =   -1.977  
BIND_SILVER['%s-%s' % (dbse, '033ILE-061VAL-1')] =   -0.662  
BIND_SILVER['%s-%s' % (dbse, '033LEU-053VAL-1')] =   -0.719  
BIND_SILVER['%s-%s' % (dbse, '033LEU-059ILE-1')] =   -0.867  
BIND_SILVER['%s-%s' % (dbse, '033LEU-061PRO-1')] =   -1.011  
BIND_SILVER['%s-%s' % (dbse, '033LEU-089ILE-1')] =   -0.730  
BIND_SILVER['%s-%s' % (dbse, '033PHE-058PHE-1')] =   -1.126  
BIND_SILVER['%s-%s' % (dbse, '033THR-100GLN-1')] =   -0.081  
BIND_SILVER['%s-%s' % (dbse, '033TYR-062HIE-1')] =   -2.000  
BIND_SILVER['%s-%s' % (dbse, '033TYR-091ASN-1')] =   -8.387  
BIND_SILVER['%s-%s' % (dbse, '033TYR-094ILE-1')] =   -1.702  
BIND_SILVER['%s-%s' % (dbse, '033TYR-094ILE-2')] =   -1.433  
BIND_SILVER['%s-%s' % (dbse, '033VAL-048ILE-1')] =   -0.833  
BIND_SILVER['%s-%s' % (dbse, '033VAL-055VAL-1')] =   -0.310  
BIND_SILVER['%s-%s' % (dbse, '033VAL-091ASN-1')] =   -0.647  
BIND_SILVER['%s-%s' % (dbse, '034ALA-133LYS-1')] =   -0.905  
BIND_SILVER['%s-%s' % (dbse, '034ALA-152GLU-1')] =   -4.160  
BIND_SILVER['%s-%s' % (dbse, '034ARG-060TYR-1')] =  -15.977  
BIND_SILVER['%s-%s' % (dbse, '034ARG-064LEU-1')] =   -1.843  
BIND_SILVER['%s-%s' % (dbse, '034ASN-076SER-1')] =   -1.631  
BIND_SILVER['%s-%s' % (dbse, '034ASN-078TYR-1')] =   -0.223  
BIND_SILVER['%s-%s' % (dbse, '034ASP-037PHE-1')] =   -1.936  
BIND_SILVER['%s-%s' % (dbse, '034ASP-061ARG-1')] =  -82.272  
BIND_SILVER['%s-%s' % (dbse, '034HIE-057HIE-1')] =   -1.353  
BIND_SILVER['%s-%s' % (dbse, '034ILE-037TYR-1')] =   -1.443  
BIND_SILVER['%s-%s' % (dbse, '034LEU-038TYR-1')] =   -1.225  
BIND_SILVER['%s-%s' % (dbse, '034LEU-044TRP-1')] =   -1.505  
BIND_SILVER['%s-%s' % (dbse, '034LYS-068GLU-1')] = -108.829  
BIND_SILVER['%s-%s' % (dbse, '034LYS-070TRP-1')] =   -1.096  
BIND_SILVER['%s-%s' % (dbse, '034LYS-070TRP-2')] =   -1.075  
BIND_SILVER['%s-%s' % (dbse, '034LYS-086TYR-1')] =   -1.628  
BIND_SILVER['%s-%s' % (dbse, '034LYS-086TYR-2')] =   -6.886  
BIND_SILVER['%s-%s' % (dbse, '034PHE-045TRP-1')] =   -4.812  
BIND_SILVER['%s-%s' % (dbse, '034PHE-058CYS-1')] =   -1.938  
BIND_SILVER['%s-%s' % (dbse, '034PHE-062HIE-1')] =   -0.952  
BIND_SILVER['%s-%s' % (dbse, '034PHE-069MET-1')] =   -2.208  
BIND_SILVER['%s-%s' % (dbse, '034PHE-072LEU-1')] =   -0.930  
BIND_SILVER['%s-%s' % (dbse, '034PHE-100VAL-2')] =   -2.430  
BIND_SILVER['%s-%s' % (dbse, '034PRO-065ALA-1')] =   -0.781  
BIND_SILVER['%s-%s' % (dbse, '034PRO-075PRO-1')] =   -1.446  
BIND_SILVER['%s-%s' % (dbse, '034SER-105LEU-1')] =   -1.555  
BIND_SILVER['%s-%s' % (dbse, '034TRP-037TRP-1')] =   -3.146  
BIND_SILVER['%s-%s' % (dbse, '034TYR-136ALA-1')] =   -1.209  
BIND_SILVER['%s-%s' % (dbse, '034TYR-143MET-1')] =   -3.066  
BIND_SILVER['%s-%s' % (dbse, '034TYR-148VAL-1')] =   -0.605  
BIND_SILVER['%s-%s' % (dbse, '034TYR-277TYR-1')] =    0.417  
BIND_SILVER['%s-%s' % (dbse, '034VAL-046LEU-1')] =   -0.453  
BIND_SILVER['%s-%s' % (dbse, '034VAL-048PHE-1')] =   -0.702  
BIND_SILVER['%s-%s' % (dbse, '034VAL-072VAL-1')] =   -0.431  
BIND_SILVER['%s-%s' % (dbse, '034VAL-077LEU-1')] =   -0.302  
BIND_SILVER['%s-%s' % (dbse, '034VAL-111LEU-1')] =   -0.933  
BIND_SILVER['%s-%s' % (dbse, '035ALA-065LEU-1')] =   -0.832  
BIND_SILVER['%s-%s' % (dbse, '035ALA-067ARG-1')] =    0.132  
BIND_SILVER['%s-%s' % (dbse, '035ARG-041THR-1')] =  -13.265  
BIND_SILVER['%s-%s' % (dbse, '035ARG-042VAL-1')] =   -0.796  
BIND_SILVER['%s-%s' % (dbse, '035ASN-172GLU-1')] =  -10.669  
BIND_SILVER['%s-%s' % (dbse, '035ASN-174TYR-1')] =   -1.259  
BIND_SILVER['%s-%s' % (dbse, '035ASP-046ARG-1')] =  -98.960  
BIND_SILVER['%s-%s' % (dbse, '035CYS-038CYS-1')] =    2.390  
BIND_SILVER['%s-%s' % (dbse, '035CYS-154THR-1')] =   -2.507  
BIND_SILVER['%s-%s' % (dbse, '035GLU-189PRO-1')] =   -0.393  
BIND_SILVER['%s-%s' % (dbse, '035HIE-059ARG-1')] =   -1.094  
BIND_SILVER['%s-%s' % (dbse, '035HIE-059ARG-2')] =   -6.147  
BIND_SILVER['%s-%s' % (dbse, '035HIE-061ARG-1')] =   -2.328  
BIND_SILVER['%s-%s' % (dbse, '035LEU-061PRO-1')] =   -0.836  
BIND_SILVER['%s-%s' % (dbse, '035LEU-085LEU-1')] =   -0.479  
BIND_SILVER['%s-%s' % (dbse, '035LYS-083TYR-1')] =   -4.424  
BIND_SILVER['%s-%s' % (dbse, '035LYS-090GLU-1')] =   -6.134  
BIND_SILVER['%s-%s' % (dbse, '035PHE-047TYR-1')] =   -2.477  
BIND_SILVER['%s-%s' % (dbse, '035PHE-062THR-1')] =   -2.895  
BIND_SILVER['%s-%s' % (dbse, '035PHE-097LEU-1')] =   -1.397  
BIND_SILVER['%s-%s' % (dbse, '035PHE-111PHE-1')] =   -2.222  
BIND_SILVER['%s-%s' % (dbse, '035PHE-128PHE-1')] =   -2.599  
BIND_SILVER['%s-%s' % (dbse, '035THR-112LYS-1')] =   -1.781  
BIND_SILVER['%s-%s' % (dbse, '035TRP-045HIE-1')] =   -0.272  
BIND_SILVER['%s-%s' % (dbse, '035TRP-058PHE-1')] =   -4.147  
BIND_SILVER['%s-%s' % (dbse, '035TRP-064ARG-1')] =   -0.883  
BIND_SILVER['%s-%s' % (dbse, '035TRP-157VAL-1')] =   -0.493  
BIND_SILVER['%s-%s' % (dbse, '035TRP-161LYS-1')] =  -16.599  
BIND_SILVER['%s-%s' % (dbse, '036ARG-042GLU-1')] = -109.981  
BIND_SILVER['%s-%s' % (dbse, '036ARG-162GLN-1')] =  -18.930  
BIND_SILVER['%s-%s' % (dbse, '036CYS-039CYS-1')] =    0.225  
BIND_SILVER['%s-%s' % (dbse, '036GLN-040HIE-1')] =   -2.173  
BIND_SILVER['%s-%s' % (dbse, '036GLN-105LEU-1')] =   -0.541  
BIND_SILVER['%s-%s' % (dbse, '036GLU-039ARG-1')] = -118.965  
BIND_SILVER['%s-%s' % (dbse, '036GLU-039LYS-1')] = -113.965  
BIND_SILVER['%s-%s' % (dbse, '036GLU-045LEU-1')] =   -1.169  
BIND_SILVER['%s-%s' % (dbse, '036GLU-053VAL-1')] =   -1.635  
BIND_SILVER['%s-%s' % (dbse, '036GLU-056ARG-1')] =  -81.683  
BIND_SILVER['%s-%s' % (dbse, '036HIE-063LEU-1')] =   -1.861  
BIND_SILVER['%s-%s' % (dbse, '036ILE-040THR-1')] =   -1.802  
BIND_SILVER['%s-%s' % (dbse, '036ILE-061ILE-1')] =   -0.760  
BIND_SILVER['%s-%s' % (dbse, '036ILE-063TRP-1')] =   -0.749  
BIND_SILVER['%s-%s' % (dbse, '036LEU-039MET-1')] =   -0.963  
BIND_SILVER['%s-%s' % (dbse, '036LEU-041ILE-1')] =   -0.407  
BIND_SILVER['%s-%s' % (dbse, '036LEU-046PHE-1')] =   -0.458  
BIND_SILVER['%s-%s' % (dbse, '036LEU-046PHE-2')] =   -0.640  
BIND_SILVER['%s-%s' % (dbse, '036LEU-047TYR-1')] =   -2.045  
BIND_SILVER['%s-%s' % (dbse, '036LEU-098ILE-1')] =   -0.604  
BIND_SILVER['%s-%s' % (dbse, '036MET-049LEU-1')] =   -0.078  
BIND_SILVER['%s-%s' % (dbse, '036MET-054VAL-1')] =    3.114  
BIND_SILVER['%s-%s' % (dbse, '036PHE-075SER-2')] =   -2.251  
BIND_SILVER['%s-%s' % (dbse, '036PHE-113ASP-1')] =   -5.362  
BIND_SILVER['%s-%s' % (dbse, '036PHE-303TRP-1')] =   -1.798  
BIND_SILVER['%s-%s' % (dbse, '036SER-069THR-1')] =   -0.212  
BIND_SILVER['%s-%s' % (dbse, '036THR-090GLU-1')] =  -19.513  
BIND_SILVER['%s-%s' % (dbse, '036THR-104MET-1')] =   -0.955  
BIND_SILVER['%s-%s' % (dbse, '036THR-133PHE-1')] =   -1.552  
BIND_SILVER['%s-%s' % (dbse, '036TRP-047PHE-1')] =   -1.180  
BIND_SILVER['%s-%s' % (dbse, '036TRP-049PRO-1')] =   -2.011  
BIND_SILVER['%s-%s' % (dbse, '036VAL-060TYR-1')] =   -0.420  
BIND_SILVER['%s-%s' % (dbse, '036VAL-070TRP-1')] =   -2.303  
BIND_SILVER['%s-%s' % (dbse, '036VAL-086TYR-1')] =   -0.902  
BIND_SILVER['%s-%s' % (dbse, '037ALA-056ILE-1')] =   -0.414  
BIND_SILVER['%s-%s' % (dbse, '037ARG-152GLU-1')] = -119.367  
BIND_SILVER['%s-%s' % (dbse, '037ASN-040THR-1')] =    3.034  
BIND_SILVER['%s-%s' % (dbse, '037ASN-067GLU-1')] =   -6.225  
BIND_SILVER['%s-%s' % (dbse, '037ASP-040ARG-1')] =  -79.742  
BIND_SILVER['%s-%s' % (dbse, '037ASP-064TYR-1')] =  -18.742  
BIND_SILVER['%s-%s' % (dbse, '037HIE-050GLU-1')] =  -24.317  
BIND_SILVER['%s-%s' % (dbse, '037ILE-116PHE-1')] =   -0.780  
BIND_SILVER['%s-%s' % (dbse, '037ILE-125LEU-1')] =   -0.851  
BIND_SILVER['%s-%s' % (dbse, '037ILE-162PRO-1')] =   -0.658  
BIND_SILVER['%s-%s' % (dbse, '037ILE-165VAL-1')] =   -0.361  
BIND_SILVER['%s-%s' % (dbse, '037LYS-162PHE-1')] =   -1.034  
BIND_SILVER['%s-%s' % (dbse, '037PHE-048HIE-1')] =   -1.815  
BIND_SILVER['%s-%s' % (dbse, '037SER-043ASP-1')] =   -6.323  
BIND_SILVER['%s-%s' % (dbse, '037THR-053ILE-1')] =    0.562  
BIND_SILVER['%s-%s' % (dbse, '037THR-085LYS-2')] =    0.733  
BIND_SILVER['%s-%s' % (dbse, '037TRP-050ALA-1')] =   -2.566  
BIND_SILVER['%s-%s' % (dbse, '037TRP-053LEU-1')] =   -1.274  
BIND_SILVER['%s-%s' % (dbse, '037TRP-055LYS-1')] =  -15.064  
BIND_SILVER['%s-%s' % (dbse, '037TRP-055LYS-2')] =   -0.926  
BIND_SILVER['%s-%s' % (dbse, '037TYR-046THR-1')] =   -1.050  
BIND_SILVER['%s-%s' % (dbse, '037TYR-050LYS-1')] =   -2.778  
BIND_SILVER['%s-%s' % (dbse, '037TYR-066LEU-1')] =   -1.074  
BIND_SILVER['%s-%s' % (dbse, '037TYR-068VAL-1')] =   -1.021  
BIND_SILVER['%s-%s' % (dbse, '038ASN-199LEU-1')] =   -0.517  
BIND_SILVER['%s-%s' % (dbse, '038ASN-202PHE-1')] =   -3.152  
BIND_SILVER['%s-%s' % (dbse, '038CYS-095PHE-1')] =   -1.282  
BIND_SILVER['%s-%s' % (dbse, '038GLN-042ASP-1')] =  -21.755  
BIND_SILVER['%s-%s' % (dbse, '038ILE-085ARG-1')] =   -0.607  
BIND_SILVER['%s-%s' % (dbse, '038ILE-094LYS-1')] =    0.054  
BIND_SILVER['%s-%s' % (dbse, '038LEU-045PHE-1')] =   -0.833  
BIND_SILVER['%s-%s' % (dbse, '038LEU-047TYR-2')] =   -1.584  
BIND_SILVER['%s-%s' % (dbse, '038LEU-054LEU-1')] =   -0.539  
BIND_SILVER['%s-%s' % (dbse, '038LEU-109SER-1')] =   -0.661  
BIND_SILVER['%s-%s' % (dbse, '038LEU-109VAL-1')] =   -0.175  
BIND_SILVER['%s-%s' % (dbse, '038LYS-047PHE-1')] =   -2.257  
BIND_SILVER['%s-%s' % (dbse, '038MET-041LEU-1')] =   -0.480  
BIND_SILVER['%s-%s' % (dbse, '038MET-146PHE-1')] =   -2.503  
BIND_SILVER['%s-%s' % (dbse, '038PHE-042PHE-1')] =   -3.218  
BIND_SILVER['%s-%s' % (dbse, '038PHE-042VAL-1')] =   -2.045  
BIND_SILVER['%s-%s' % (dbse, '038PHE-046ARG-1')] =   -2.236  
BIND_SILVER['%s-%s' % (dbse, '038PHE-049PHE-1')] =   -1.536  
BIND_SILVER['%s-%s' % (dbse, '038PHE-061VAL-1')] =   -1.720  
BIND_SILVER['%s-%s' % (dbse, '038PHE-061VAL-2')] =   -1.277  
BIND_SILVER['%s-%s' % (dbse, '038PHE-101PRO-1')] =   -1.079  
BIND_SILVER['%s-%s' % (dbse, '038PRO-108ARG-1')] =   -1.892  
BIND_SILVER['%s-%s' % (dbse, '038THR-053PHE-1')] =   -0.863  
BIND_SILVER['%s-%s' % (dbse, '038TRP-063TRP-1')] =   -4.942  
BIND_SILVER['%s-%s' % (dbse, '038TRP-065PRO-1')] =   -2.783  
BIND_SILVER['%s-%s' % (dbse, '038TRP-068TYR-1')] =   -2.286  
BIND_SILVER['%s-%s' % (dbse, '038TRP-073ILE-1')] =   -1.568  
BIND_SILVER['%s-%s' % (dbse, '038TRP-078ALA-1')] =   -0.894  
BIND_SILVER['%s-%s' % (dbse, '038TRP-081TYR-1')] =   -2.895  
BIND_SILVER['%s-%s' % (dbse, '038TRP-082ILE-1')] =   -1.363  
BIND_SILVER['%s-%s' % (dbse, '038TRP-132ILE-1')] =   -1.184  
BIND_SILVER['%s-%s' % (dbse, '038TYR-060TYR-1')] =   -2.862  
BIND_SILVER['%s-%s' % (dbse, '038VAL-041VAL-1')] =   -0.216  
BIND_SILVER['%s-%s' % (dbse, '038VAL-072PHE-1')] =   -1.733  
BIND_SILVER['%s-%s' % (dbse, '038VAL-082PHE-1')] =   -0.823  
BIND_SILVER['%s-%s' % (dbse, '038VAL-083ILE-1')] =   -0.174  
BIND_SILVER['%s-%s' % (dbse, '039ALA-095PHE-1')] =   -2.239  
BIND_SILVER['%s-%s' % (dbse, '039ARG-043ASN-2')] =    4.952  
BIND_SILVER['%s-%s' % (dbse, '039ASN-042ARG-1')] =  -22.074  
BIND_SILVER['%s-%s' % (dbse, '039ASN-081SER-1')] =   -1.723  
BIND_SILVER['%s-%s' % (dbse, '039ASN-083TYR-1')] =   -1.039  
BIND_SILVER['%s-%s' % (dbse, '039ASP-057THR-1')] =  -17.369  
BIND_SILVER['%s-%s' % (dbse, '039GLN-047ARG-1')] =  -16.304  
BIND_SILVER['%s-%s' % (dbse, '039HIE-057HIE-1')] =    8.515  
BIND_SILVER['%s-%s' % (dbse, '039ILE-054LEU-1')] =   -1.025  
BIND_SILVER['%s-%s' % (dbse, '039ILE-055TYR-1')] =   -1.090  
BIND_SILVER['%s-%s' % (dbse, '039ILE-108ILE-1')] =   -0.831  
BIND_SILVER['%s-%s' % (dbse, '039ILE-109CYS-1')] =    2.170  
BIND_SILVER['%s-%s' % (dbse, '039LYS-043HIE-1')] =   -1.096  
BIND_SILVER['%s-%s' % (dbse, '039PRO-165PHE-1')] =   -2.357  
BIND_SILVER['%s-%s' % (dbse, '039PRO-166ILE-1')] =   -0.557  
BIND_SILVER['%s-%s' % (dbse, '039PRO-199LEU-1')] =   -0.253  
BIND_SILVER['%s-%s' % (dbse, '039SER-054GLU-1')] =  -17.886  
BIND_SILVER['%s-%s' % (dbse, '039SER-067GLU-1')] =  -19.229  
BIND_SILVER['%s-%s' % (dbse, '039THR-046THR-1')] =   -5.273  
BIND_SILVER['%s-%s' % (dbse, '039THR-077LEU-1')] =   -0.301  
BIND_SILVER['%s-%s' % (dbse, '039THR-079LEU-1')] =   -0.824  
BIND_SILVER['%s-%s' % (dbse, '039THR-083VAL-1')] =   -0.345  
BIND_SILVER['%s-%s' % (dbse, '039TRP-052SER-1')] =   -4.020  
BIND_SILVER['%s-%s' % (dbse, '039TRP-064VAL-1')] =   -1.183  
BIND_SILVER['%s-%s' % (dbse, '039TRP-066LEU-1')] =   -1.971  
BIND_SILVER['%s-%s' % (dbse, '039TRP-066LEU-2')] =   -2.232  
BIND_SILVER['%s-%s' % (dbse, '039TYR-043ILE-1')] =    0.834  
BIND_SILVER['%s-%s' % (dbse, '039VAL-083TYR-1')] =   -2.023  
BIND_SILVER['%s-%s' % (dbse, '040ASN-073PHE-1')] =   -1.934  
BIND_SILVER['%s-%s' % (dbse, '040ASN-077TYR-1')] =   -2.333  
BIND_SILVER['%s-%s' % (dbse, '040ASN-090ARG-1')] =  -10.580  
BIND_SILVER['%s-%s' % (dbse, '040ASP-065THR-1')] =    2.091  
BIND_SILVER['%s-%s' % (dbse, '040GLU-045GLN-1')] =  -18.953  
BIND_SILVER['%s-%s' % (dbse, '040HIE-103HIE-1')] =  -10.145  
BIND_SILVER['%s-%s' % (dbse, '040HIE-105LEU-1')] =   -1.969  
BIND_SILVER['%s-%s' % (dbse, '040ILE-054VAL-1')] =   -0.430  
BIND_SILVER['%s-%s' % (dbse, '040ILE-057LYS-1')] =   -0.617  
BIND_SILVER['%s-%s' % (dbse, '040LEU-063TYR-1')] =   -1.070  
BIND_SILVER['%s-%s' % (dbse, '040MET-085ARG-1')] =    0.489  
BIND_SILVER['%s-%s' % (dbse, '040PHE-052TYR-1')] =   -2.418  
BIND_SILVER['%s-%s' % (dbse, '040PHE-116PHE-1')] =   -2.283  
BIND_SILVER['%s-%s' % (dbse, '040PHE-133PHE-1')] =   -2.804  
BIND_SILVER['%s-%s' % (dbse, '040THR-044TRP-1')] =   -1.379  
BIND_SILVER['%s-%s' % (dbse, '040THR-048VAL-1')] =   -0.792  
BIND_SILVER['%s-%s' % (dbse, '040THR-162GLN-1')] =   -0.675  
BIND_SILVER['%s-%s' % (dbse, '040THR-186TYR-1')] =   -1.631  
BIND_SILVER['%s-%s' % (dbse, '040THR-270TYR-1')] =   -0.702  
BIND_SILVER['%s-%s' % (dbse, '040TRP-052GLN-1')] =   -3.401  
BIND_SILVER['%s-%s' % (dbse, '040TRP-055LEU-1')] =   -0.704  
BIND_SILVER['%s-%s' % (dbse, '040TRP-121ILE-1')] =   -2.349  
BIND_SILVER['%s-%s' % (dbse, '040TRP-121ILE-2')] =   -0.562  
BIND_SILVER['%s-%s' % (dbse, '040TRP-122THR-1')] =   -3.460  
BIND_SILVER['%s-%s' % (dbse, '040TYR-045TYR-1')] =   -3.705  
BIND_SILVER['%s-%s' % (dbse, '040TYR-055VAL-1')] =   -1.047  
BIND_SILVER['%s-%s' % (dbse, '040TYR-076VAL-1')] =   -1.250  
BIND_SILVER['%s-%s' % (dbse, '040TYR-079ILE-1')] =   -1.593  
BIND_SILVER['%s-%s' % (dbse, '040TYR-082PHE-1')] =   -1.132  
BIND_SILVER['%s-%s' % (dbse, '040VAL-063VAL-1')] =   -0.360  
BIND_SILVER['%s-%s' % (dbse, '041ALA-047TRP-1')] =   -2.447  
BIND_SILVER['%s-%s' % (dbse, '041ALA-081GLU-1')] =   -1.026  
BIND_SILVER['%s-%s' % (dbse, '041ALA-121ALA-1')] =   -0.367  
BIND_SILVER['%s-%s' % (dbse, '041ARG-051PHE-1')] =   -2.628  
BIND_SILVER['%s-%s' % (dbse, '041ASP-084ARG-1')] =  -92.904  
BIND_SILVER['%s-%s' % (dbse, '041GLU-045LYS-1')] = -107.969  
BIND_SILVER['%s-%s' % (dbse, '041ILE-058ARG-1')] =    0.092  
BIND_SILVER['%s-%s' % (dbse, '041ILE-061PHE-1')] =   -0.707  
BIND_SILVER['%s-%s' % (dbse, '041ILE-107PHE-1')] =   -1.453  
BIND_SILVER['%s-%s' % (dbse, '041ILE-107PHE-2')] =   -1.383  
BIND_SILVER['%s-%s' % (dbse, '041LEU-146PHE-1')] =   -0.654  
BIND_SILVER['%s-%s' % (dbse, '041LEU-155PRO-1')] =   -0.844  
BIND_SILVER['%s-%s' % (dbse, '041LEU-162PHE-1')] =   -2.008  
BIND_SILVER['%s-%s' % (dbse, '041LEU-170TRP-1')] =   -1.656  
BIND_SILVER['%s-%s' % (dbse, '041LYS-045GLN-1')] =   -1.511  
BIND_SILVER['%s-%s' % (dbse, '041LYS-107PHE-2')] =   -2.398  
BIND_SILVER['%s-%s' % (dbse, '041LYS-110SER-1')] =  -19.112  
BIND_SILVER['%s-%s' % (dbse, '041PHE-047SER-1')] =   -1.643  
BIND_SILVER['%s-%s' % (dbse, '041PHE-054HIE-1')] =   -3.600  
BIND_SILVER['%s-%s' % (dbse, '041PHE-073ALA-1')] =   -0.663  
BIND_SILVER['%s-%s' % (dbse, '041PHE-077LEU-1')] =   -0.905  
BIND_SILVER['%s-%s' % (dbse, '041PHE-094LYS-1')] =   -6.698  
BIND_SILVER['%s-%s' % (dbse, '041PHE-094LYS-2')] =   -2.262  
BIND_SILVER['%s-%s' % (dbse, '041PHE-104VAL-2')] =   -1.777  
BIND_SILVER['%s-%s' % (dbse, '041VAL-059LEU-1')] =   -0.742  
BIND_SILVER['%s-%s' % (dbse, '041VAL-064LYS-1')] =   -0.209  
BIND_SILVER['%s-%s' % (dbse, '042ALA-082ILE-1')] =   -0.188  
BIND_SILVER['%s-%s' % (dbse, '042ASP-045THR-1')] =  -19.653  
BIND_SILVER['%s-%s' % (dbse, '042GLU-095PHE-1')] =   -5.297  
BIND_SILVER['%s-%s' % (dbse, '042GLU-101PRO-1')] =   -4.444  
BIND_SILVER['%s-%s' % (dbse, '042GLU-103PHE-1')] =   -6.859  
BIND_SILVER['%s-%s' % (dbse, '042GLU-121ALA-1')] =   -2.850  
BIND_SILVER['%s-%s' % (dbse, '042ILE-049PHE-1')] =   -0.888  
BIND_SILVER['%s-%s' % (dbse, '042ILE-052PRO-1')] =   -0.584  
BIND_SILVER['%s-%s' % (dbse, '042ILE-056PHE-1')] =   -1.903  
BIND_SILVER['%s-%s' % (dbse, '042LEU-047ILE-1')] =   -0.481  
BIND_SILVER['%s-%s' % (dbse, '042LEU-048ILE-1')] =   -1.027  
BIND_SILVER['%s-%s' % (dbse, '042LEU-048VAL-1')] =   -0.883  
BIND_SILVER['%s-%s' % (dbse, '042LEU-103HIE-1')] =   -0.770  
BIND_SILVER['%s-%s' % (dbse, '042LEU-105LEU-1')] =   -0.493  
BIND_SILVER['%s-%s' % (dbse, '042LYS-049GLU-1')] = -123.547  
BIND_SILVER['%s-%s' % (dbse, '042PHE-049PHE-1')] =   -1.458  
BIND_SILVER['%s-%s' % (dbse, '042PHE-054PHE-1')] =   -2.122  
BIND_SILVER['%s-%s' % (dbse, '042PHE-056SER-1')] =   -1.133  
BIND_SILVER['%s-%s' % (dbse, '042PHE-061LEU-1')] =   -0.666  
BIND_SILVER['%s-%s' % (dbse, '042PHE-064LYS-1')] =   -1.284  
BIND_SILVER['%s-%s' % (dbse, '042PHE-074LEU-1')] =   -2.171  
BIND_SILVER['%s-%s' % (dbse, '042PHE-077PHE-1')] =   -1.751  
BIND_SILVER['%s-%s' % (dbse, '042PHE-085PHE-1')] =   -1.718  
BIND_SILVER['%s-%s' % (dbse, '042PHE-087LEU-1')] =   -1.240  
BIND_SILVER['%s-%s' % (dbse, '042PHE-088ASP-1')] =   -4.718  
BIND_SILVER['%s-%s' % (dbse, '042PHE-089ALA-1')] =   -1.179  
BIND_SILVER['%s-%s' % (dbse, '042PHE-089MET-1')] =   -1.927  
BIND_SILVER['%s-%s' % (dbse, '042PHE-092TYR-1')] =   -2.772  
BIND_SILVER['%s-%s' % (dbse, '042PHE-101VAL-1')] =   -0.984  
BIND_SILVER['%s-%s' % (dbse, '042SER-058ILE-1')] =   -1.251  
BIND_SILVER['%s-%s' % (dbse, '042SER-062ASP-1')] =    3.665  
BIND_SILVER['%s-%s' % (dbse, '042THR-052ASN-1')] =   -4.598  
BIND_SILVER['%s-%s' % (dbse, '042TRP-049ARG-1')] =  -12.696  
BIND_SILVER['%s-%s' % (dbse, '043ALA-073PHE-1')] =   -0.525  
BIND_SILVER['%s-%s' % (dbse, '043ALA-077TYR-1')] =   -1.273  
BIND_SILVER['%s-%s' % (dbse, '043ASP-054HIE-1')] =  -25.403  
BIND_SILVER['%s-%s' % (dbse, '043ASP-058ARG-1')] = -119.662  
BIND_SILVER['%s-%s' % (dbse, '043ASP-062TYR-1')] =   -2.141  
BIND_SILVER['%s-%s' % (dbse, '043GLU-104ALA-1')] =   -2.276  
BIND_SILVER['%s-%s' % (dbse, '043ILE-055LEU-1')] =    0.008  
BIND_SILVER['%s-%s' % (dbse, '043LEU-050PHE-1')] =   -0.825  
BIND_SILVER['%s-%s' % (dbse, '043LEU-055THR-1')] =   -0.529  
BIND_SILVER['%s-%s' % (dbse, '043LEU-071PHE-1')] =   -0.833  
BIND_SILVER['%s-%s' % (dbse, '043LEU-114SER-1')] =   -0.504  
BIND_SILVER['%s-%s' % (dbse, '043LEU-161TYR-1')] =   -2.141  
BIND_SILVER['%s-%s' % (dbse, '043MET-048ILE-1')] =   -0.462  
BIND_SILVER['%s-%s' % (dbse, '043MET-060VAL-1')] =   -0.693  
BIND_SILVER['%s-%s' % (dbse, '043PHE-065PHE-1')] =   -1.745  
BIND_SILVER['%s-%s' % (dbse, '043PHE-068TRP-1')] =   -2.083  
BIND_SILVER['%s-%s' % (dbse, '043PHE-073PHE-1')] =   -1.430  
BIND_SILVER['%s-%s' % (dbse, '043THR-059LEU-1')] =   -0.454  
BIND_SILVER['%s-%s' % (dbse, '043TYR-048GLN-1')] =   -2.735  
BIND_SILVER['%s-%s' % (dbse, '043TYR-049THR-1')] =   -1.207  
BIND_SILVER['%s-%s' % (dbse, '043TYR-068LYS-1')] =   -2.299  
BIND_SILVER['%s-%s' % (dbse, '043TYR-185HIE-1')] =   -3.835  
BIND_SILVER['%s-%s' % (dbse, '043TYR-186TYR-1')] =   -2.561  
BIND_SILVER['%s-%s' % (dbse, '043VAL-066LEU-1')] =   -0.287  
BIND_SILVER['%s-%s' % (dbse, '043VAL-069VAL-1')] =   -0.665  
BIND_SILVER['%s-%s' % (dbse, '044ALA-052ASP-1')] =   -1.046  
BIND_SILVER['%s-%s' % (dbse, '044ASN-048THR-2')] =   -5.653  
BIND_SILVER['%s-%s' % (dbse, '044ASN-059THR-1')] =   -4.239  
BIND_SILVER['%s-%s' % (dbse, '044GLN-061LYS-2')] =  -28.330  
BIND_SILVER['%s-%s' % (dbse, '044GLU-084ARG-1')] =  -95.217  
BIND_SILVER['%s-%s' % (dbse, '044HIE-067HIE-1')] =   -2.875  
BIND_SILVER['%s-%s' % (dbse, '044HIE-073TRP-1')] =   -2.707  
BIND_SILVER['%s-%s' % (dbse, '044HIE-086GLU-1')] =  -25.558  
BIND_SILVER['%s-%s' % (dbse, '044ILE-101HIE-1')] =   -0.446  
BIND_SILVER['%s-%s' % (dbse, '044LEU-079VAL-1')] =   -0.405  
BIND_SILVER['%s-%s' % (dbse, '044LEU-101ILE-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '044LEU-272GLN-1')] =   -2.078  
BIND_SILVER['%s-%s' % (dbse, '044LEU-272GLN-2')] =   -0.947  
BIND_SILVER['%s-%s' % (dbse, '044MET-061VAL-1')] =   -0.686  
BIND_SILVER['%s-%s' % (dbse, '044PHE-048LEU-1')] =   -1.223  
BIND_SILVER['%s-%s' % (dbse, '044PHE-130VAL-1')] =   -3.084  
BIND_SILVER['%s-%s' % (dbse, '044PRO-053ASP-1')] =   -3.835  
BIND_SILVER['%s-%s' % (dbse, '044SER-093ARG-1')] =  -14.344  
BIND_SILVER['%s-%s' % (dbse, '044SER-118ARG-2')] =  -10.784  
BIND_SILVER['%s-%s' % (dbse, '044THR-118TYR-1')] =   -1.262  
BIND_SILVER['%s-%s' % (dbse, '044TRP-048TYR-1')] =   -2.705  
BIND_SILVER['%s-%s' % (dbse, '044TRP-085PHE-1')] =   -4.261  
BIND_SILVER['%s-%s' % (dbse, '044TRP-147TYR-1')] =   -1.547  
BIND_SILVER['%s-%s' % (dbse, '044TYR-048LYS-2')] =  -15.948  
BIND_SILVER['%s-%s' % (dbse, '044TYR-059ILE-1')] =   -1.218  
BIND_SILVER['%s-%s' % (dbse, '044TYR-077LEU-1')] =   -1.579  
BIND_SILVER['%s-%s' % (dbse, '044TYR-109LEU-1')] =   -1.451  
BIND_SILVER['%s-%s' % (dbse, '044VAL-174MET-1')] =   -1.482  
BIND_SILVER['%s-%s' % (dbse, '045ALA-054HIE-1')] =   -0.710  
BIND_SILVER['%s-%s' % (dbse, '045ALA-071HIE-1')] =   -2.243  
BIND_SILVER['%s-%s' % (dbse, '045ASP-081GLU-1')] =   88.942  
BIND_SILVER['%s-%s' % (dbse, '045GLN-062LYS-2')] =  -24.503  
BIND_SILVER['%s-%s' % (dbse, '045HIE-051GLU-1')] =  -23.689  
BIND_SILVER['%s-%s' % (dbse, '045HIE-053ILE-1')] =   -2.150  
BIND_SILVER['%s-%s' % (dbse, '045LEU-049GLU-1')] =   -0.103  
BIND_SILVER['%s-%s' % (dbse, '045LEU-049TYR-1')] =    0.060  
BIND_SILVER['%s-%s' % (dbse, '045LEU-054PHE-1')] =   -1.107  
BIND_SILVER['%s-%s' % (dbse, '045LEU-055ASP-1')] =   -2.883  
BIND_SILVER['%s-%s' % (dbse, '045LEU-070PHE-1')] =   -1.111  
BIND_SILVER['%s-%s' % (dbse, '045LEU-097LEU-1')] =   -0.866  
BIND_SILVER['%s-%s' % (dbse, '045LYS-048GLU-1')] =   -4.739  
BIND_SILVER['%s-%s' % (dbse, '045LYS-084GLU-1')] =  -72.386  
BIND_SILVER['%s-%s' % (dbse, '045PHE-057GLU-1')] =   -7.819  
BIND_SILVER['%s-%s' % (dbse, '045PHE-061VAL-1')] =   -1.515  
BIND_SILVER['%s-%s' % (dbse, '045PHE-066PHE-1')] =   -1.938  
BIND_SILVER['%s-%s' % (dbse, '045PHE-075LYS-1')] =  -10.186  
BIND_SILVER['%s-%s' % (dbse, '045PRO-080VAL-1')] =   -1.459  
BIND_SILVER['%s-%s' % (dbse, '045PRO-100VAL-1')] =   -0.592  
BIND_SILVER['%s-%s' % (dbse, '045THR-048ALA-2')] =   -0.613  
BIND_SILVER['%s-%s' % (dbse, '045THR-066VAL-1')] =   -0.473  
BIND_SILVER['%s-%s' % (dbse, '045THR-097SER-1')] =   -0.423  
BIND_SILVER['%s-%s' % (dbse, '045THR-168LYS-1')] =   -1.127  
BIND_SILVER['%s-%s' % (dbse, '045TRP-048ILE-1')] =   -0.935  
BIND_SILVER['%s-%s' % (dbse, '045TRP-049ILE-1')] =   -1.111  
BIND_SILVER['%s-%s' % (dbse, '045TRP-100VAL-1')] =   -0.938  
BIND_SILVER['%s-%s' % (dbse, '045TRP-272GLN-1')] =   -4.851  
BIND_SILVER['%s-%s' % (dbse, '045TYR-053THR-1')] =   -2.046  
BIND_SILVER['%s-%s' % (dbse, '046ARG-050ASP-2')] =  -95.821  
BIND_SILVER['%s-%s' % (dbse, '046ARG-092TYR-1')] =    0.680  
BIND_SILVER['%s-%s' % (dbse, '046ARG-182GLU-1')] =  -77.082  
BIND_SILVER['%s-%s' % (dbse, '046ARG-273GLU-1')] = -114.658  
BIND_SILVER['%s-%s' % (dbse, '046ASP-083ASP-2')] =   55.241  
BIND_SILVER['%s-%s' % (dbse, '046ILE-071GLU-1')] =   -0.653  
BIND_SILVER['%s-%s' % (dbse, '046ILE-074LEU-1')] =   10.302  
BIND_SILVER['%s-%s' % (dbse, '046LEU-068ILE-1')] =   -0.447  
BIND_SILVER['%s-%s' % (dbse, '046LEU-103PHE-1')] =   -1.050  
BIND_SILVER['%s-%s' % (dbse, '046PHE-050LYS-1')] =   -3.007  
BIND_SILVER['%s-%s' % (dbse, '046PHE-084LEU-1')] =   -1.873  
BIND_SILVER['%s-%s' % (dbse, '046PHE-088MET-1')] =   -1.865  
BIND_SILVER['%s-%s' % (dbse, '046PHE-107PHE-1')] =   -2.839  
BIND_SILVER['%s-%s' % (dbse, '046PHE-119GLN-2')] =   -0.996  
BIND_SILVER['%s-%s' % (dbse, '046PHE-121LEU-1')] =   -1.755  
BIND_SILVER['%s-%s' % (dbse, '046PHE-161TYR-1')] =   -2.336  
BIND_SILVER['%s-%s' % (dbse, '046PRO-140ALA-1')] =   -0.451  
BIND_SILVER['%s-%s' % (dbse, '046PRO-141ARG-1')] =   -0.848  
BIND_SILVER['%s-%s' % (dbse, '046SER-054PHE-1')] =   -2.325  
BIND_SILVER['%s-%s' % (dbse, '046SER-088ASP-1')] =   -6.085  
BIND_SILVER['%s-%s' % (dbse, '046THR-069ASN-1')] =   -4.189  
BIND_SILVER['%s-%s' % (dbse, '046VAL-094PHE-1')] =   -0.908  
BIND_SILVER['%s-%s' % (dbse, '047ARG-050GLU-1')] =  -82.158  
BIND_SILVER['%s-%s' % (dbse, '047ARG-059MET-1')] =   -1.431  
BIND_SILVER['%s-%s' % (dbse, '047ASN-062LYS-1')] =   -0.688  
BIND_SILVER['%s-%s' % (dbse, '047ASN-276PRO-1')] =   -1.147  
BIND_SILVER['%s-%s' % (dbse, '047ILE-064LEU-1')] =   -0.396  
BIND_SILVER['%s-%s' % (dbse, '047LEU-055LEU-1')] =   -0.292  
BIND_SILVER['%s-%s' % (dbse, '047LYS-059ASP-1')] = -114.369  
BIND_SILVER['%s-%s' % (dbse, '047PRO-164TRP-1')] =   -1.964  
BIND_SILVER['%s-%s' % (dbse, '047SER-065PHE-1')] =   -1.089  
BIND_SILVER['%s-%s' % (dbse, '047TRP-081GLU-1')] =   -9.539  
BIND_SILVER['%s-%s' % (dbse, '047TRP-083TYR-1')] =   -2.090  
BIND_SILVER['%s-%s' % (dbse, '047TYR-052PHE-1')] =   -1.226  
BIND_SILVER['%s-%s' % (dbse, '047TYR-053ASP-1')] =    1.238  
BIND_SILVER['%s-%s' % (dbse, '047TYR-055ASN-1')] =   -1.148  
BIND_SILVER['%s-%s' % (dbse, '047TYR-058TYR-1')] =   -3.260  
BIND_SILVER['%s-%s' % (dbse, '047TYR-075ILE-1')] =   -1.942  
BIND_SILVER['%s-%s' % (dbse, '047TYR-077HIE-1')] =   -0.933  
BIND_SILVER['%s-%s' % (dbse, '047TYR-111PHE-1')] =   -1.740  
BIND_SILVER['%s-%s' % (dbse, '047TYR-136TYR-1')] =    2.608  
BIND_SILVER['%s-%s' % (dbse, '048ARG-060MET-1')] =   -1.666  
BIND_SILVER['%s-%s' % (dbse, '048ASN-052ASN-1')] =   -4.840  
BIND_SILVER['%s-%s' % (dbse, '048ASP-081THR-1')] =  -19.769  
BIND_SILVER['%s-%s' % (dbse, '048ASP-131LYS-1')] = -115.604  
BIND_SILVER['%s-%s' % (dbse, '048GLN-070SER-1')] =   -0.877  
BIND_SILVER['%s-%s' % (dbse, '048HIE-052PHE-1')] =   -0.514  
BIND_SILVER['%s-%s' % (dbse, '048HIE-091ARG-1')] =   -6.372  
BIND_SILVER['%s-%s' % (dbse, '048HIE-099HIE-2')] =   -3.011  
BIND_SILVER['%s-%s' % (dbse, '048HIE-174MET-1')] =   -3.763  
BIND_SILVER['%s-%s' % (dbse, '048HIE-178ASP-1')] =  -26.607  
BIND_SILVER['%s-%s' % (dbse, '048ILE-052ILE-1')] =   -0.976  
BIND_SILVER['%s-%s' % (dbse, '048ILE-272GLN-1')] =   -0.947  
BIND_SILVER['%s-%s' % (dbse, '048ILE-279ILE-1')] =   -0.994  
BIND_SILVER['%s-%s' % (dbse, '048LEU-070PHE-1')] =   -1.087  
BIND_SILVER['%s-%s' % (dbse, '048LEU-070PHE-2')] =   -1.120  
BIND_SILVER['%s-%s' % (dbse, '048LEU-074TYR-1')] =   -1.828  
BIND_SILVER['%s-%s' % (dbse, '048LEU-074TYR-2')] =   -1.597  
BIND_SILVER['%s-%s' % (dbse, '048LEU-077GLN-1')] =   -0.696  
BIND_SILVER['%s-%s' % (dbse, '048LEU-141PHE-1')] =   -1.312  
BIND_SILVER['%s-%s' % (dbse, '048LYS-082ILE-1')] =   -0.833  
BIND_SILVER['%s-%s' % (dbse, '048LYS-098GLU-1')] = -110.536  
BIND_SILVER['%s-%s' % (dbse, '048PHE-058PHE-1')] =   -1.935  
BIND_SILVER['%s-%s' % (dbse, '048PHE-101LEU-1')] =   -0.705  
BIND_SILVER['%s-%s' % (dbse, '048PHE-105TYR-1')] =   -1.858  
BIND_SILVER['%s-%s' % (dbse, '048VAL-093THR-1')] =   -0.185  
BIND_SILVER['%s-%s' % (dbse, '048VAL-095LEU-1')] =   -0.603  
BIND_SILVER['%s-%s' % (dbse, '048VAL-099ILE-1')] =   -0.733  
BIND_SILVER['%s-%s' % (dbse, '049ALA-092TYR-1')] =   -1.278  
BIND_SILVER['%s-%s' % (dbse, '049ARG-167GLN-1')] =  -21.041  
BIND_SILVER['%s-%s' % (dbse, '049GLU-080ARG-1')] =  -92.816  
BIND_SILVER['%s-%s' % (dbse, '049ILE-059ASP-1')] =   -3.460  
BIND_SILVER['%s-%s' % (dbse, '049ILE-070PHE-1')] =   -1.030  
BIND_SILVER['%s-%s' % (dbse, '049ILE-100VAL-1')] =   -0.663  
BIND_SILVER['%s-%s' % (dbse, '049LEU-054VAL-1')] =   -0.449  
BIND_SILVER['%s-%s' % (dbse, '049LEU-107PHE-1')] =   -1.693  
BIND_SILVER['%s-%s' % (dbse, '049LYS-121LEU-1')] =   -0.872  
BIND_SILVER['%s-%s' % (dbse, '049LYS-158ASP-1')] =   -6.751  
BIND_SILVER['%s-%s' % (dbse, '049PHE-056PHE-1')] =   -1.738  
BIND_SILVER['%s-%s' % (dbse, '049PHE-057GLN-2')] =   -3.312  
BIND_SILVER['%s-%s' % (dbse, '049PHE-091ARG-1')] =   -1.182  
BIND_SILVER['%s-%s' % (dbse, '049PHE-093VAL-1')] =   -2.839  
BIND_SILVER['%s-%s' % (dbse, '049PRO-052TYR-1')] =   -1.037  
BIND_SILVER['%s-%s' % (dbse, '049THR-053LEU-1')] =   -0.661  
BIND_SILVER['%s-%s' % (dbse, '049TYR-054PHE-1')] =   -1.413  
BIND_SILVER['%s-%s' % (dbse, '049TYR-098GLU-1')] =    3.334  
BIND_SILVER['%s-%s' % (dbse, '049TYR-102ASN-1')] =   -4.577  
BIND_SILVER['%s-%s' % (dbse, '049VAL-053THR-1')] =   -0.602  
BIND_SILVER['%s-%s' % (dbse, '049VAL-124GLN-1')] =   -0.726  
BIND_SILVER['%s-%s' % (dbse, '049VAL-127LEU-1')] =   -1.232  
BIND_SILVER['%s-%s' % (dbse, '049VAL-131VAL-1')] =   -0.664  
BIND_SILVER['%s-%s' % (dbse, '050ALA-081PHE-1')] =   -1.058  
BIND_SILVER['%s-%s' % (dbse, '050ARG-054THR-1')] =  -12.201  
BIND_SILVER['%s-%s' % (dbse, '050ASN-083TYR-1')] =   -1.392  
BIND_SILVER['%s-%s' % (dbse, '050ASP-053THR-1')] =  -19.054  
BIND_SILVER['%s-%s' % (dbse, '050ASP-067PHE-1')] =   -2.812  
BIND_SILVER['%s-%s' % (dbse, '050ASP-092TYR-1')] =  -24.353  
BIND_SILVER['%s-%s' % (dbse, '050GLN-055TYR-1')] =   -5.887  
BIND_SILVER['%s-%s' % (dbse, '050HIE-065PHE-1')] =   -3.340  
BIND_SILVER['%s-%s' % (dbse, '050HIE-087TYR-1')] =  -10.881  
BIND_SILVER['%s-%s' % (dbse, '050ILE-053ILE-1')] =   -0.610  
BIND_SILVER['%s-%s' % (dbse, '050ILE-071PRO-1')] =   -0.823  
BIND_SILVER['%s-%s' % (dbse, '050ILE-079VAL-1')] =   -0.091  
BIND_SILVER['%s-%s' % (dbse, '050LYS-056GLU-1')] = -112.142  
BIND_SILVER['%s-%s' % (dbse, '050PHE-071PHE-1')] =   -1.560  
BIND_SILVER['%s-%s' % (dbse, '050PRO-053TYR-1')] =   -1.601  
BIND_SILVER['%s-%s' % (dbse, '050PRO-058PHE-1')] =   -1.798  
BIND_SILVER['%s-%s' % (dbse, '050PRO-096TYR-1')] =    0.243  
BIND_SILVER['%s-%s' % (dbse, '050SER-066PHE-1')] =   -1.163  
BIND_SILVER['%s-%s' % (dbse, '050THR-143THR-1')] =   -0.229  
BIND_SILVER['%s-%s' % (dbse, '050TRP-054GLU-1')] =   -6.822  
BIND_SILVER['%s-%s' % (dbse, '050VAL-054THR-1')] =    1.615  
BIND_SILVER['%s-%s' % (dbse, '051CYS-154LYS-1')] =   -7.995  
BIND_SILVER['%s-%s' % (dbse, '051CYS-156THR-1')] =    1.829  
BIND_SILVER['%s-%s' % (dbse, '051GLN-089GLU-1')] =   -5.548  
BIND_SILVER['%s-%s' % (dbse, '051GLN-089GLU-2')] =  -24.845  
BIND_SILVER['%s-%s' % (dbse, '051GLN-098TYR-1')] =   -2.515  
BIND_SILVER['%s-%s' % (dbse, '051GLU-056MET-1')] =   -0.406  
BIND_SILVER['%s-%s' % (dbse, '051GLU-056MET-2')] =   -3.366  
BIND_SILVER['%s-%s' % (dbse, '051HIE-277ASP-1')] =  -24.075  
BIND_SILVER['%s-%s' % (dbse, '051ILE-068LEU-1')] =   -1.083  
BIND_SILVER['%s-%s' % (dbse, '051LEU-055ASP-1')] =   -2.986  
BIND_SILVER['%s-%s' % (dbse, '051LEU-080ARG-1')] =   -1.978  
BIND_SILVER['%s-%s' % (dbse, '051LEU-096TYR-1')] =   -1.912  
BIND_SILVER['%s-%s' % (dbse, '051LEU-131LYS-1')] =   -1.004  
BIND_SILVER['%s-%s' % (dbse, '051PHE-058VAL-1')] =   -0.429  
BIND_SILVER['%s-%s' % (dbse, '051PHE-091ARG-1')] =   -5.759  
BIND_SILVER['%s-%s' % (dbse, '051PHE-091ARG-2')] =   -1.898  
BIND_SILVER['%s-%s' % (dbse, '051PHE-175PHE-1')] =   -1.343  
BIND_SILVER['%s-%s' % (dbse, '051THR-152PHE-1')] =   -1.241  
BIND_SILVER['%s-%s' % (dbse, '051TRP-093VAL-1')] =   -1.571  
BIND_SILVER['%s-%s' % (dbse, '051TRP-095LEU-1')] =   -0.723  
BIND_SILVER['%s-%s' % (dbse, '051TRP-097ARG-1')] =   -7.419  
BIND_SILVER['%s-%s' % (dbse, '051TRP-097ARG-2')] =   -2.436  
BIND_SILVER['%s-%s' % (dbse, '051TRP-107PHE-1')] =   -2.339  
BIND_SILVER['%s-%s' % (dbse, '051VAL-071ALA-1')] =   -0.694  
BIND_SILVER['%s-%s' % (dbse, '051VAL-104ILE-1')] =   -0.502  
BIND_SILVER['%s-%s' % (dbse, '052ASN-061ASN-1')] =   -7.124  
BIND_SILVER['%s-%s' % (dbse, '052ASN-143THR-1')] =    1.625  
BIND_SILVER['%s-%s' % (dbse, '052GLN-069ARG-1')] =  -10.112  
BIND_SILVER['%s-%s' % (dbse, '052GLN-117PHE-1')] =   -1.133  
BIND_SILVER['%s-%s' % (dbse, '052ILE-056GLN-1')] =   -1.262  
BIND_SILVER['%s-%s' % (dbse, '052ILE-087VAL-1')] =    0.108  
BIND_SILVER['%s-%s' % (dbse, '052ILE-100VAL-1')] =   -0.201  
BIND_SILVER['%s-%s' % (dbse, '052LEU-060LEU-1')] =   -0.506  
BIND_SILVER['%s-%s' % (dbse, '052LEU-062PHE-1')] =   -1.622  
BIND_SILVER['%s-%s' % (dbse, '052LEU-062PHE-2')] =   -1.596  
BIND_SILVER['%s-%s' % (dbse, '052LEU-070PHE-1')] =   -0.897  
BIND_SILVER['%s-%s' % (dbse, '052LEU-141PHE-1')] =   -1.422  
BIND_SILVER['%s-%s' % (dbse, '052LEU-152PHE-1')] =   -0.750  
BIND_SILVER['%s-%s' % (dbse, '052PHE-056MET-1')] =   -3.029  
BIND_SILVER['%s-%s' % (dbse, '052PHE-061CYS-1')] =   -1.353  
BIND_SILVER['%s-%s' % (dbse, '052PHE-071PHE-1')] =   -1.367  
BIND_SILVER['%s-%s' % (dbse, '052PHE-073THR-1')] =   -1.345  
BIND_SILVER['%s-%s' % (dbse, '052PHE-075ILE-1')] =   -1.384  
BIND_SILVER['%s-%s' % (dbse, '052PHE-111PHE-1')] =   -1.386  
BIND_SILVER['%s-%s' % (dbse, '052PHE-141MET-1')] =   -2.449  
BIND_SILVER['%s-%s' % (dbse, '052PHE-148ALA-1')] =   -1.033  
BIND_SILVER['%s-%s' % (dbse, '052PHE-157ILE-1')] =   -1.352  
BIND_SILVER['%s-%s' % (dbse, '052PRO-109LEU-1')] =   -0.659  
BIND_SILVER['%s-%s' % (dbse, '052SER-063PHE-1')] =   -1.152  
BIND_SILVER['%s-%s' % (dbse, '052TYR-058PHE-1')] =   -1.836  
BIND_SILVER['%s-%s' % (dbse, '052TYR-061ASP-1')] =  -24.995  
BIND_SILVER['%s-%s' % (dbse, '052TYR-116PHE-1')] =   -1.996  
BIND_SILVER['%s-%s' % (dbse, '052VAL-057SER-1')] =   -0.295  
BIND_SILVER['%s-%s' % (dbse, '053ASN-063SER-1')] =   -4.441  
BIND_SILVER['%s-%s' % (dbse, '053ASN-131VAL-1')] =   -1.440  
BIND_SILVER['%s-%s' % (dbse, '053ASP-058TYR-1')] =   -0.968  
BIND_SILVER['%s-%s' % (dbse, '053ILE-066LEU-1')] =   -0.141  
BIND_SILVER['%s-%s' % (dbse, '053ILE-069PHE-1')] =   -1.247  
BIND_SILVER['%s-%s' % (dbse, '053ILE-075LEU-1')] =   -0.174  
BIND_SILVER['%s-%s' % (dbse, '053ILE-077LEU-1')] =   -0.732  
BIND_SILVER['%s-%s' % (dbse, '053LEU-057PHE-1')] =   -1.058  
BIND_SILVER['%s-%s' % (dbse, '053LEU-091ILE-1')] =   -0.690  
BIND_SILVER['%s-%s' % (dbse, '053MET-140ASP-1')] =   -6.145  
BIND_SILVER['%s-%s' % (dbse, '053SER-089GLU-1')] =  -19.844  
BIND_SILVER['%s-%s' % (dbse, '053TYR-059LEU-1')] =   -1.536  
BIND_SILVER['%s-%s' % (dbse, '053TYR-083ASP-1')] =  -25.626  
BIND_SILVER['%s-%s' % (dbse, '053TYR-092TYR-1')] =   -2.614  
BIND_SILVER['%s-%s' % (dbse, '053TYR-094LYS-1')] =   -2.076  
BIND_SILVER['%s-%s' % (dbse, '053TYR-142ALA-1')] =   -1.376  
BIND_SILVER['%s-%s' % (dbse, '053TYR-169MET-1')] =   -3.752  
BIND_SILVER['%s-%s' % (dbse, '053VAL-057ARG-1')] =   -2.322  
BIND_SILVER['%s-%s' % (dbse, '053VAL-068PHE-1')] =   -0.545  
BIND_SILVER['%s-%s' % (dbse, '053VAL-074ALA-1')] =   -0.775  
BIND_SILVER['%s-%s' % (dbse, '053VAL-117PHE-1')] =   -0.605  
BIND_SILVER['%s-%s' % (dbse, '054ASN-069PHE-1')] =   -4.683  
BIND_SILVER['%s-%s' % (dbse, '054ASN-141ASN-1')] =    1.835  
BIND_SILVER['%s-%s' % (dbse, '054GLU-057ARG-2')] =  -94.239  
BIND_SILVER['%s-%s' % (dbse, '054GLU-058ARG-1')] = -118.218  
BIND_SILVER['%s-%s' % (dbse, '054GLU-141GLN-1')] =  -13.457  
BIND_SILVER['%s-%s' % (dbse, '054ILE-074ALA-1')] =    0.243  
BIND_SILVER['%s-%s' % (dbse, '054LEU-061LEU-1')] =   -0.898  
BIND_SILVER['%s-%s' % (dbse, '054LEU-063PHE-1')] =   -1.485  
BIND_SILVER['%s-%s' % (dbse, '054LEU-069VAL-1')] =   -0.428  
BIND_SILVER['%s-%s' % (dbse, '054LEU-091LEU-1')] =   -0.907  
BIND_SILVER['%s-%s' % (dbse, '054LEU-091LEU-2')] =    0.311  
BIND_SILVER['%s-%s' % (dbse, '054PHE-101ILE-1')] =   -0.776  
BIND_SILVER['%s-%s' % (dbse, '054THR-057ASP-2')] =    0.997  
BIND_SILVER['%s-%s' % (dbse, '054VAL-091ALA-1')] =   -0.195  
BIND_SILVER['%s-%s' % (dbse, '054VAL-097ILE-1')] =   -0.502  
BIND_SILVER['%s-%s' % (dbse, '055ASN-058GLU-1')] =   -5.455  
BIND_SILVER['%s-%s' % (dbse, '055ASN-058TYR-1')] =   -1.840  
BIND_SILVER['%s-%s' % (dbse, '055ASP-069ARG-1')] = -118.294  
BIND_SILVER['%s-%s' % (dbse, '055ASP-104LYS-1')] =  -86.772  
BIND_SILVER['%s-%s' % (dbse, '055ASP-105TYR-1')] =  -10.791  
BIND_SILVER['%s-%s' % (dbse, '055ASP-185ARG-1')] = -112.490  
BIND_SILVER['%s-%s' % (dbse, '055GLN-272GLU-1')] =    5.717  
BIND_SILVER['%s-%s' % (dbse, '055GLU-121LEU-1')] =   -1.100  
BIND_SILVER['%s-%s' % (dbse, '055ILE-059ILE-1')] =   -0.773  
BIND_SILVER['%s-%s' % (dbse, '055ILE-061CYS-1')] =   -0.836  
BIND_SILVER['%s-%s' % (dbse, '055ILE-151THR-1')] =   -1.058  
BIND_SILVER['%s-%s' % (dbse, '055ILE-155ILE-1')] =    1.098  
BIND_SILVER['%s-%s' % (dbse, '055LEU-060VAL-1')] =   -0.790  
BIND_SILVER['%s-%s' % (dbse, '055PHE-139ALA-1')] =   -1.146  
BIND_SILVER['%s-%s' % (dbse, '055PHE-141GLN-1')] =   -1.686  
BIND_SILVER['%s-%s' % (dbse, '055PHE-141GLN-2')] =   -1.886  
BIND_SILVER['%s-%s' % (dbse, '055SER-071PHE-1')] =   -0.614  
BIND_SILVER['%s-%s' % (dbse, '055SER-152PHE-1')] =   -1.946  
BIND_SILVER['%s-%s' % (dbse, '055THR-072THR-1')] =    0.305  
BIND_SILVER['%s-%s' % (dbse, '055VAL-059ILE-1')] =   -0.593  
BIND_SILVER['%s-%s' % (dbse, '056ALA-061VAL-1')] =   -0.544  
BIND_SILVER['%s-%s' % (dbse, '056ALA-175PHE-1')] =   -0.834  
BIND_SILVER['%s-%s' % (dbse, '056ARG-061LEU-1')] =   -0.420  
BIND_SILVER['%s-%s' % (dbse, '056HIE-287LEU-1')] =   -1.095  
BIND_SILVER['%s-%s' % (dbse, '056HIE-287LEU-2')] =   -1.386  
BIND_SILVER['%s-%s' % (dbse, '056ILE-059PHE-1')] =   -1.376  
BIND_SILVER['%s-%s' % (dbse, '056ILE-059PHE-2')] =   -1.338  
BIND_SILVER['%s-%s' % (dbse, '056LEU-069LEU-1')] =   -0.480  
BIND_SILVER['%s-%s' % (dbse, '056LYS-160ASP-1')] = -109.917  
BIND_SILVER['%s-%s' % (dbse, '056MET-059MET-1')] =   -1.518  
BIND_SILVER['%s-%s' % (dbse, '056MET-181ALA-1')] =   -0.951  
BIND_SILVER['%s-%s' % (dbse, '056PHE-062PHE-1')] =   -1.525  
BIND_SILVER['%s-%s' % (dbse, '056PHE-129PHE-1')] =   -2.054  
BIND_SILVER['%s-%s' % (dbse, '056PHE-152PHE-1')] =   -1.364  
BIND_SILVER['%s-%s' % (dbse, '056SER-076LEU-1')] =   -0.547  
BIND_SILVER['%s-%s' % (dbse, '056TYR-062TYR-1')] =   -4.015  
BIND_SILVER['%s-%s' % (dbse, '056TYR-064VAL-1')] =   -0.231  
BIND_SILVER['%s-%s' % (dbse, '056TYR-084ILE-1')] =   -2.040  
BIND_SILVER['%s-%s' % (dbse, '057ARG-067VAL-1')] =   -1.497  
BIND_SILVER['%s-%s' % (dbse, '057GLU-061ARG-1')] =  -88.938  
BIND_SILVER['%s-%s' % (dbse, '057MET-060MET-1')] =   -1.223  
BIND_SILVER['%s-%s' % (dbse, '057PHE-060LEU-1')] =   -1.298  
BIND_SILVER['%s-%s' % (dbse, '057PHE-066ILE-1')] =   -1.339  
BIND_SILVER['%s-%s' % (dbse, '057PHE-098VAL-1')] =   -1.726  
BIND_SILVER['%s-%s' % (dbse, '057PHE-116PHE-1')] =   -1.300  
BIND_SILVER['%s-%s' % (dbse, '057PHE-163ILE-1')] =   -1.325  
BIND_SILVER['%s-%s' % (dbse, '057PRO-063TYR-1')] =   -1.688  
BIND_SILVER['%s-%s' % (dbse, '057TYR-091LEU-1')] =   -2.809  
BIND_SILVER['%s-%s' % (dbse, '057VAL-084ASP-1')] =   -3.649  
BIND_SILVER['%s-%s' % (dbse, '057VAL-084ASP-2')] =   -2.344  
BIND_SILVER['%s-%s' % (dbse, '057VAL-181ASN-1')] =   -1.215  
BIND_SILVER['%s-%s' % (dbse, '058ARG-062LEU-1')] =   -0.962  
BIND_SILVER['%s-%s' % (dbse, '058ARG-141GLN-1')] =  -10.308  
BIND_SILVER['%s-%s' % (dbse, '058ASP-279LYS-1')] = -108.989  
BIND_SILVER['%s-%s' % (dbse, '058GLN-067PHE-1')] =   -1.718  
BIND_SILVER['%s-%s' % (dbse, '058GLN-067PHE-2')] =   -1.178  
BIND_SILVER['%s-%s' % (dbse, '058HIE-067GLN-1')] =   -1.778  
BIND_SILVER['%s-%s' % (dbse, '058HIE-115GLN-1')] =   -4.423  
BIND_SILVER['%s-%s' % (dbse, '058ILE-097TRP-1')] =   -1.940  
BIND_SILVER['%s-%s' % (dbse, '058LEU-071VAL-1')] =   -0.907  
BIND_SILVER['%s-%s' % (dbse, '058LEU-084LEU-1')] =   -0.145  
BIND_SILVER['%s-%s' % (dbse, '058LEU-094GLN-1')] =   -0.816  
BIND_SILVER['%s-%s' % (dbse, '058LYS-122VAL-1')] =   -2.395  
BIND_SILVER['%s-%s' % (dbse, '058PHE-062ILE-1')] =   -1.008  
BIND_SILVER['%s-%s' % (dbse, '058PHE-062TYR-1')] =   -3.781  
BIND_SILVER['%s-%s' % (dbse, '058PHE-070TRP-1')] =   -4.232  
BIND_SILVER['%s-%s' % (dbse, '058PHE-081PHE-1')] =   -2.484  
BIND_SILVER['%s-%s' % (dbse, '058PHE-101ILE-1')] =    0.409  
BIND_SILVER['%s-%s' % (dbse, '058PHE-131VAL-1')] =   -0.631  
BIND_SILVER['%s-%s' % (dbse, '058TRP-084SER-1')] =   -3.663  
BIND_SILVER['%s-%s' % (dbse, '058TRP-180SER-1')] =   -1.222  
BIND_SILVER['%s-%s' % (dbse, '058TYR-062GLN-1')] =   -1.092  
BIND_SILVER['%s-%s' % (dbse, '058TYR-062GLN-2')] =   -2.645  
BIND_SILVER['%s-%s' % (dbse, '058TYR-062LYS-1')] =   -8.699  
BIND_SILVER['%s-%s' % (dbse, '058TYR-066VAL-1')] =   -0.799  
BIND_SILVER['%s-%s' % (dbse, '058TYR-068ILE-1')] =   -0.777  
BIND_SILVER['%s-%s' % (dbse, '058TYR-077ALA-1')] =   -1.194  
BIND_SILVER['%s-%s' % (dbse, '058VAL-085ILE-1')] =   -0.290  
BIND_SILVER['%s-%s' % (dbse, '059ARG-065MET-1')] =   -0.615  
BIND_SILVER['%s-%s' % (dbse, '059ARG-067GLN-2')] =  -23.540  
BIND_SILVER['%s-%s' % (dbse, '059ASN-062LYS-2')] =  -27.600  
BIND_SILVER['%s-%s' % (dbse, '059ILE-068ILE-1')] =   -0.760  
BIND_SILVER['%s-%s' % (dbse, '059ILE-094LEU-1')] =   -0.656  
BIND_SILVER['%s-%s' % (dbse, '059LEU-117VAL-1')] =   -0.874  
BIND_SILVER['%s-%s' % (dbse, '059LEU-117VAL-2')] =   -0.317  
BIND_SILVER['%s-%s' % (dbse, '059LEU-119GLN-1')] =   -1.727  
BIND_SILVER['%s-%s' % (dbse, '059LYS-063ASP-2')] = -116.333  
BIND_SILVER['%s-%s' % (dbse, '059LYS-075TRP-1')] =   -7.619  
BIND_SILVER['%s-%s' % (dbse, '059LYS-135ASP-1')] =   -3.557  
BIND_SILVER['%s-%s' % (dbse, '059PHE-063ASN-1')] =   -3.970  
BIND_SILVER['%s-%s' % (dbse, '059PHE-118THR-1')] =   -0.387  
BIND_SILVER['%s-%s' % (dbse, '059PHE-120TRP-1')] =   -1.998  
BIND_SILVER['%s-%s' % (dbse, '059PHE-127ILE-1')] =   -0.957  
BIND_SILVER['%s-%s' % (dbse, '059THR-088TYR-1')] =   -1.083  
BIND_SILVER['%s-%s' % (dbse, '059VAL-084LEU-1')] =   -1.016  
BIND_SILVER['%s-%s' % (dbse, '059VAL-136TRP-1')] =   -1.583  
BIND_SILVER['%s-%s' % (dbse, '060ALA-081LEU-1')] =   -0.721  
BIND_SILVER['%s-%s' % (dbse, '060ASP-165ASP-1')] =   77.260  
BIND_SILVER['%s-%s' % (dbse, '060LEU-068PHE-1')] =   -0.725  
BIND_SILVER['%s-%s' % (dbse, '060LEU-095PHE-1')] =   -1.031  
BIND_SILVER['%s-%s' % (dbse, '060LEU-095PHE-2')] =   -1.009  
BIND_SILVER['%s-%s' % (dbse, '060LEU-098VAL-1')] =   -0.525  
BIND_SILVER['%s-%s' % (dbse, '060LEU-120VAL-1')] =   -1.168  
BIND_SILVER['%s-%s' % (dbse, '060LEU-152PHE-1')] =   -1.155  
BIND_SILVER['%s-%s' % (dbse, '060MET-070GLU-1')] =    0.426  # altered
BIND_SILVER['%s-%s' % (dbse, '060THR-087LYS-1')] =  -18.010  
BIND_SILVER['%s-%s' % (dbse, '060THR-176ARG-1')] =  -12.928  
BIND_SILVER['%s-%s' % (dbse, '060TYR-064LEU-1')] =   -1.250  
BIND_SILVER['%s-%s' % (dbse, '060TYR-128PRO-2')] =   -1.771  
BIND_SILVER['%s-%s' % (dbse, '060VAL-063TYR-1')] =   -1.198  
BIND_SILVER['%s-%s' % (dbse, '060VAL-157PRO-1')] =   -0.913  
BIND_SILVER['%s-%s' % (dbse, '061ALA-080ALA-1')] =   -0.190  
BIND_SILVER['%s-%s' % (dbse, '061ARG-083GLU-1')] =   -2.679  
BIND_SILVER['%s-%s' % (dbse, '061ARG-083GLU-2')] =  -91.995  
BIND_SILVER['%s-%s' % (dbse, '061ARG-084LEU-1')] =   -0.512  
BIND_SILVER['%s-%s' % (dbse, '061ASN-065ASN-2')] =   -5.029  
BIND_SILVER['%s-%s' % (dbse, '061ASP-065LYS-1')] =   -6.775  
BIND_SILVER['%s-%s' % (dbse, '061GLU-080ARG-2')] =  -78.315  
BIND_SILVER['%s-%s' % (dbse, '061GLU-088PHE-1')] =   -5.236  
BIND_SILVER['%s-%s' % (dbse, '061GLU-142MET-1')] =   -8.303  
BIND_SILVER['%s-%s' % (dbse, '061GLU-145LEU-1')] =   -1.882  
BIND_SILVER['%s-%s' % (dbse, '061ILE-064PHE-1')] =   -0.846  
BIND_SILVER['%s-%s' % (dbse, '061ILE-086ASP-1')] =   -1.210  
BIND_SILVER['%s-%s' % (dbse, '061ILE-089MET-1')] =   -0.443  
BIND_SILVER['%s-%s' % (dbse, '061ILE-091ILE-1')] =   -0.107  
BIND_SILVER['%s-%s' % (dbse, '061ILE-092TRP-1')] =   -0.425  
BIND_SILVER['%s-%s' % (dbse, '061ILE-098LEU-1')] =   -0.825  
BIND_SILVER['%s-%s' % (dbse, '061ILE-155ASP-1')] =   -2.731  
BIND_SILVER['%s-%s' % (dbse, '061LEU-065MET-1')] =   -0.624  
BIND_SILVER['%s-%s' % (dbse, '061LEU-079ALA-1')] =   -0.426  
BIND_SILVER['%s-%s' % (dbse, '061PHE-068VAL-1')] =   -0.698  
BIND_SILVER['%s-%s' % (dbse, '061PHE-086VAL-1')] =   -1.244  
BIND_SILVER['%s-%s' % (dbse, '061PHE-086VAL-2')] =   -0.807  
BIND_SILVER['%s-%s' % (dbse, '061PHE-099ALA-1')] =   -2.464  
BIND_SILVER['%s-%s' % (dbse, '061PHE-117VAL-1')] =   -0.825  
BIND_SILVER['%s-%s' % (dbse, '061PRO-088PHE-1')] =   -1.479  
BIND_SILVER['%s-%s' % (dbse, '061THR-081THR-1')] =   -0.379  
BIND_SILVER['%s-%s' % (dbse, '061THR-083GLU-1')] =  -16.102  
BIND_SILVER['%s-%s' % (dbse, '061TYR-066LEU-1')] =   -2.376  
BIND_SILVER['%s-%s' % (dbse, '061VAL-064TYR-1')] =   -1.436  
BIND_SILVER['%s-%s' % (dbse, '061VAL-066VAL-1')] =    0.207  
BIND_SILVER['%s-%s' % (dbse, '061VAL-068ILE-1')] =   -0.985  
BIND_SILVER['%s-%s' % (dbse, '062ALA-070MET-1')] =   -1.324  
BIND_SILVER['%s-%s' % (dbse, '062ASP-080ARG-1')] =  -86.981  
BIND_SILVER['%s-%s' % (dbse, '062GLN-110GLN-1')] =   -6.848  
BIND_SILVER['%s-%s' % (dbse, '062GLN-112PHE-1')] =   -1.542  
BIND_SILVER['%s-%s' % (dbse, '062GLN-171PRO-1')] =    1.617  
BIND_SILVER['%s-%s' % (dbse, '062GLN-173TYR-1')] =   -2.744  
BIND_SILVER['%s-%s' % (dbse, '062GLN-173TYR-2')] =   -1.927  
BIND_SILVER['%s-%s' % (dbse, '062HIE-070GLU-1')] =   -8.104  
BIND_SILVER['%s-%s' % (dbse, '062HIE-072LEU-1')] =   -1.030  
BIND_SILVER['%s-%s' % (dbse, '062HIE-073TYR-1')] =    3.640  
BIND_SILVER['%s-%s' % (dbse, '062HIE-076ALA-1')] =   -0.817  
BIND_SILVER['%s-%s' % (dbse, '062ILE-067ILE-1')] =   -0.352  
BIND_SILVER['%s-%s' % (dbse, '062ILE-069TYR-1')] =   -2.283  
BIND_SILVER['%s-%s' % (dbse, '062ILE-105TYR-1')] =   -0.570  
BIND_SILVER['%s-%s' % (dbse, '062ILE-107PHE-1')] =   -0.928  
BIND_SILVER['%s-%s' % (dbse, '062LEU-075ILE-1')] =   -0.370  
BIND_SILVER['%s-%s' % (dbse, '062LEU-077ALA-1')] =   -0.739  
BIND_SILVER['%s-%s' % (dbse, '062LEU-079LEU-1')] =   -0.577  
BIND_SILVER['%s-%s' % (dbse, '062LYS-067PHE-2')] =   -1.966  
BIND_SILVER['%s-%s' % (dbse, '062LYS-147GLU-1')] =   -3.577  
BIND_SILVER['%s-%s' % (dbse, '062PHE-120TYR-1')] =   -2.033  
BIND_SILVER['%s-%s' % (dbse, '062PHE-128PRO-1')] =   -0.149  
BIND_SILVER['%s-%s' % (dbse, '062THR-099ARG-1')] =   -9.967  
BIND_SILVER['%s-%s' % (dbse, '062THR-102HIE-1')] =   -1.393  
BIND_SILVER['%s-%s' % (dbse, '062TRP-073ALA-1')] =   -1.884  
BIND_SILVER['%s-%s' % (dbse, '062TRP-164PHE-1')] =   -4.561  
BIND_SILVER['%s-%s' % (dbse, '062TRP-166PRO-1')] =   -1.310  
BIND_SILVER['%s-%s' % (dbse, '062TYR-077PHE-1')] =   -2.549  
BIND_SILVER['%s-%s' % (dbse, '062TYR-083GLU-1')] =  -22.726  
BIND_SILVER['%s-%s' % (dbse, '062TYR-084ILE-1')] =   -1.214  
BIND_SILVER['%s-%s' % (dbse, '062TYR-093ILE-1')] =   -0.572  
BIND_SILVER['%s-%s' % (dbse, '062TYR-095TRP-1')] =   -2.511  
BIND_SILVER['%s-%s' % (dbse, '063ASN-081THR-1')] =   -3.388  
BIND_SILVER['%s-%s' % (dbse, '063GLN-067ASP-1')] =   12.247  
BIND_SILVER['%s-%s' % (dbse, '063GLN-136TRP-1')] =   -3.681  
BIND_SILVER['%s-%s' % (dbse, '063GLN-165ASP-1')] =  -10.122  
BIND_SILVER['%s-%s' % (dbse, '063ILE-077LEU-1')] =   -0.382  
BIND_SILVER['%s-%s' % (dbse, '063LEU-068HIE-1')] =   -1.549  
BIND_SILVER['%s-%s' % (dbse, '063LEU-108LEU-1')] =   -0.641  
BIND_SILVER['%s-%s' % (dbse, '063LEU-140LEU-1')] =   -0.269  
BIND_SILVER['%s-%s' % (dbse, '063PRO-090GLN-1')] =   -0.786  
BIND_SILVER['%s-%s' % (dbse, '063PRO-090GLN-2')] =   -1.076  
BIND_SILVER['%s-%s' % (dbse, '063PRO-091ILE-1')] =   -0.973  
BIND_SILVER['%s-%s' % (dbse, '063PRO-094VAL-1')] =   -1.056  
BIND_SILVER['%s-%s' % (dbse, '063THR-092TRP-1')] =   -1.570  
BIND_SILVER['%s-%s' % (dbse, '063TRP-081TYR-1')] =    0.827  
BIND_SILVER['%s-%s' % (dbse, '063TRP-085MET-1')] =   -2.640  
BIND_SILVER['%s-%s' % (dbse, '063TRP-098LEU-1')] =   -1.479  
BIND_SILVER['%s-%s' % (dbse, '063TRP-136PHE-1')] =   -1.684  
BIND_SILVER['%s-%s' % (dbse, '063VAL-067LEU-1')] =   -0.565  
BIND_SILVER['%s-%s' % (dbse, '063VAL-154THR-1')] =   -0.614  
BIND_SILVER['%s-%s' % (dbse, '064GLU-111TRP-1')] =   -1.649  
BIND_SILVER['%s-%s' % (dbse, '064ILE-072PRO-1')] =   -1.469  
BIND_SILVER['%s-%s' % (dbse, '064ILE-084TYR-1')] =   -2.133  
BIND_SILVER['%s-%s' % (dbse, '064ILE-084TYR-2')] =   -3.316  
BIND_SILVER['%s-%s' % (dbse, '064ILE-090TYR-1')] =   -1.235  
BIND_SILVER['%s-%s' % (dbse, '064PHE-097PRO-1')] =   -1.410  
BIND_SILVER['%s-%s' % (dbse, '064PHE-123THR-1')] =   -1.101  
BIND_SILVER['%s-%s' % (dbse, '064PHE-125TRP-1')] =   -3.283  
BIND_SILVER['%s-%s' % (dbse, '064SER-171PRO-1')] =    1.376  
BIND_SILVER['%s-%s' % (dbse, '064THR-116PHE-1')] =   -0.869  
BIND_SILVER['%s-%s' % (dbse, '064TYR-068LYS-1')] =   -5.352  
BIND_SILVER['%s-%s' % (dbse, '064TYR-078PHE-1')] =   -2.690  
BIND_SILVER['%s-%s' % (dbse, '064TYR-082VAL-1')] =   -1.290  
BIND_SILVER['%s-%s' % (dbse, '064TYR-083LEU-1')] =   -1.053  
BIND_SILVER['%s-%s' % (dbse, '064TYR-164PHE-1')] =   -2.919  
BIND_SILVER['%s-%s' % (dbse, '064VAL-073ALA-1')] =   -0.208  
BIND_SILVER['%s-%s' % (dbse, '064VAL-143GLN-2')] =   -1.900  
BIND_SILVER['%s-%s' % (dbse, '065ALA-070PHE-1')] =   -0.815  
BIND_SILVER['%s-%s' % (dbse, '065ASN-110GLN-1')] =   -2.561  
BIND_SILVER['%s-%s' % (dbse, '065ASP-110GLN-1')] =   -5.452  
BIND_SILVER['%s-%s' % (dbse, '065GLN-088TYR-1')] =   -1.416  
BIND_SILVER['%s-%s' % (dbse, '065LEU-077VAL-1')] =   -0.643  
BIND_SILVER['%s-%s' % (dbse, '065LEU-080VAL-1')] =   -1.103  
BIND_SILVER['%s-%s' % (dbse, '065MET-117PHE-1')] =   -2.353  
BIND_SILVER['%s-%s' % (dbse, '065PHE-095LEU-1')] =   -0.771  
BIND_SILVER['%s-%s' % (dbse, '065PRO-101LEU-1')] =   -0.611  
BIND_SILVER['%s-%s' % (dbse, '065PRO-111TRP-1')] =   -3.070  
BIND_SILVER['%s-%s' % (dbse, '065SER-068TYR-1')] =    0.277  
BIND_SILVER['%s-%s' % (dbse, '065SER-108TYR-1')] =   -2.041  
BIND_SILVER['%s-%s' % (dbse, '065THR-069ILE-1')] =   -0.613  
BIND_SILVER['%s-%s' % (dbse, '065THR-082LEU-1')] =   -1.276  
BIND_SILVER['%s-%s' % (dbse, '065TRP-146THR-1')] =   -1.144  
BIND_SILVER['%s-%s' % (dbse, '065TRP-154THR-1')] =   -0.687  
BIND_SILVER['%s-%s' % (dbse, '065TYR-090PRO-1')] =   -2.058  
BIND_SILVER['%s-%s' % (dbse, '066ALA-084ALA-1')] =   -0.389  
BIND_SILVER['%s-%s' % (dbse, '066ALA-136TRP-1')] =   -1.356  
BIND_SILVER['%s-%s' % (dbse, '066ARG-167GLU-1')] = -118.516  
BIND_SILVER['%s-%s' % (dbse, '066ASP-069ARG-2')] =  -93.522  
BIND_SILVER['%s-%s' % (dbse, '066GLN-070ASN-1')] =   -4.968  
BIND_SILVER['%s-%s' % (dbse, '066HIE-069GLU-1')] =   -2.745  
BIND_SILVER['%s-%s' % (dbse, '066ILE-146VAL-1')] =   -0.706  
BIND_SILVER['%s-%s' % (dbse, '066LEU-073PRO-1')] =   -1.095  
BIND_SILVER['%s-%s' % (dbse, '066LEU-138THR-1')] =   -0.559  
BIND_SILVER['%s-%s' % (dbse, '066PHE-075LYS-1')] =   -0.869  
BIND_SILVER['%s-%s' % (dbse, '066PHE-109SER-1')] =   -0.316  
BIND_SILVER['%s-%s' % (dbse, '066PRO-095TRP-1')] =   -3.486  
BIND_SILVER['%s-%s' % (dbse, '066TRP-109TYR-1')] =   -1.888  
BIND_SILVER['%s-%s' % (dbse, '066TRP-110PRO-1')] =   -2.000  
BIND_SILVER['%s-%s' % (dbse, '066VAL-085ALA-1')] =    0.081  
BIND_SILVER['%s-%s' % (dbse, '067ARG-077ILE-1')] =    0.077  
BIND_SILVER['%s-%s' % (dbse, '067ASP-070ALA-1')] =   -2.468  
BIND_SILVER['%s-%s' % (dbse, '067GLN-115GLN-1')] =   -6.062  
BIND_SILVER['%s-%s' % (dbse, '067GLN-117PHE-1')] =   -2.737  
BIND_SILVER['%s-%s' % (dbse, '067GLU-139TYR-1')] =   -3.106  
BIND_SILVER['%s-%s' % (dbse, '067HIE-070HIE-1')] =   -4.921  
BIND_SILVER['%s-%s' % (dbse, '067HIE-086GLU-1')] =   -4.638  
BIND_SILVER['%s-%s' % (dbse, '067LEU-078LYS-1')] =   -0.752  
BIND_SILVER['%s-%s' % (dbse, '067LEU-107LEU-1')] =   -0.690  
BIND_SILVER['%s-%s' % (dbse, '067LEU-109VAL-1')] =   -0.569  
BIND_SILVER['%s-%s' % (dbse, '067PRO-095TRP-1')] =   -4.732  
BIND_SILVER['%s-%s' % (dbse, '067PRO-101ILE-1')] =   -0.667  
BIND_SILVER['%s-%s' % (dbse, '067SER-073TYR-1')] =   -1.589  
BIND_SILVER['%s-%s' % (dbse, '067THR-080TYR-1')] =   -1.121  
BIND_SILVER['%s-%s' % (dbse, '067THR-082VAL-2')] =   -0.950  
BIND_SILVER['%s-%s' % (dbse, '067VAL-085ASN-1')] =    1.575  
BIND_SILVER['%s-%s' % (dbse, '068ARG-072THR-1')] =  -12.515  
BIND_SILVER['%s-%s' % (dbse, '068HIE-075LYS-1')] =  -10.736  
BIND_SILVER['%s-%s' % (dbse, '068HIE-080GLU-1')] =    1.253  
BIND_SILVER['%s-%s' % (dbse, '068HIE-123ASP-1')] =  -25.897  
BIND_SILVER['%s-%s' % (dbse, '068ILE-072LYS-1')] =   -2.305  
BIND_SILVER['%s-%s' % (dbse, '068ILE-084TYR-1')] =   -1.943  
BIND_SILVER['%s-%s' % (dbse, '068ILE-091LEU-1')] =   -0.104  
BIND_SILVER['%s-%s' % (dbse, '068LEU-081VAL-1')] =   -0.514  
BIND_SILVER['%s-%s' % (dbse, '068LEU-146PHE-1')] =   -1.194  
BIND_SILVER['%s-%s' % (dbse, '068MET-131LEU-1')] =    0.153  
BIND_SILVER['%s-%s' % (dbse, '068PHE-076LEU-1')] =   -2.078  
BIND_SILVER['%s-%s' % (dbse, '068PHE-076LEU-2')] =   -1.279  
BIND_SILVER['%s-%s' % (dbse, '068PHE-077ILE-1')] =   -1.618  
BIND_SILVER['%s-%s' % (dbse, '068PHE-077VAL-1')] =   -0.872  
BIND_SILVER['%s-%s' % (dbse, '068PHE-080LEU-1')] =   -0.930  
BIND_SILVER['%s-%s' % (dbse, '068PHE-080VAL-1')] =   -1.040  
BIND_SILVER['%s-%s' % (dbse, '068PHE-083LEU-1')] =   -0.881  
BIND_SILVER['%s-%s' % (dbse, '068PHE-110LEU-1')] =   -0.861  
BIND_SILVER['%s-%s' % (dbse, '068TYR-073ILE-1')] =   -1.008  
BIND_SILVER['%s-%s' % (dbse, '068TYR-078ALA-1')] =   -2.371  
BIND_SILVER['%s-%s' % (dbse, '068TYR-082HIE-1')] =   -1.794  
BIND_SILVER['%s-%s' % (dbse, '069ARG-075ILE-1')] =   -2.062  
BIND_SILVER['%s-%s' % (dbse, '069ASN-119VAL-1')] =   -0.774  
BIND_SILVER['%s-%s' % (dbse, '069GLU-076ILE-1')] =   -1.017  
BIND_SILVER['%s-%s' % (dbse, '069GLU-076ILE-2')] =   -6.766  
BIND_SILVER['%s-%s' % (dbse, '069GLU-078ARG-1')] = -117.482  
BIND_SILVER['%s-%s' % (dbse, '069GLU-123ASP-1')] =   61.342  
BIND_SILVER['%s-%s' % (dbse, '069HIE-075ILE-1')] =   -0.778  
BIND_SILVER['%s-%s' % (dbse, '069HIE-078PHE-1')] =   -3.287  
BIND_SILVER['%s-%s' % (dbse, '069ILE-101ILE-1')] =    0.363  
BIND_SILVER['%s-%s' % (dbse, '069PHE-078GLU-1')] =   -6.108  
BIND_SILVER['%s-%s' % (dbse, '069PHE-080TYR-1')] =   -2.417  
BIND_SILVER['%s-%s' % (dbse, '069PHE-166TYR-1')] =    1.330  
BIND_SILVER['%s-%s' % (dbse, '069THR-080LEU-1')] =   -0.561  
BIND_SILVER['%s-%s' % (dbse, '069VAL-073TRP-1')] =   -2.767  
BIND_SILVER['%s-%s' % (dbse, '069VAL-086GLU-1')] =   -1.157  
BIND_SILVER['%s-%s' % (dbse, '069VAL-086ILE-1')] =   -0.641  
BIND_SILVER['%s-%s' % (dbse, '069VAL-114VAL-1')] =   -0.500  
BIND_SILVER['%s-%s' % (dbse, '070ASN-080GLU-1')] =    7.265  
BIND_SILVER['%s-%s' % (dbse, '070ASP-076THR-1')] =  -15.281  
BIND_SILVER['%s-%s' % (dbse, '070GLU-073LYS-1')] =   -2.033  
BIND_SILVER['%s-%s' % (dbse, '070GLU-073LYS-2')] =  -92.652  
BIND_SILVER['%s-%s' % (dbse, '070MET-075ILE-1')] =   -1.045  
BIND_SILVER['%s-%s' % (dbse, '070PHE-120TYR-1')] =   -2.737  
BIND_SILVER['%s-%s' % (dbse, '070SER-082VAL-1')] =   -0.879  
BIND_SILVER['%s-%s' % (dbse, '070THR-120ASN-1')] =    5.329  
BIND_SILVER['%s-%s' % (dbse, '070THR-124THR-2')] =   -4.710  
BIND_SILVER['%s-%s' % (dbse, '070TRP-084VAL-1')] =   -1.068  
BIND_SILVER['%s-%s' % (dbse, '070TRP-138LEU-1')] =   -2.544  
BIND_SILVER['%s-%s' % (dbse, '070TRP-174PRO-1')] =   -2.427  
BIND_SILVER['%s-%s' % (dbse, '071ASP-074LYS-1')] =   -4.105  
BIND_SILVER['%s-%s' % (dbse, '071LYS-195ASP-1')] =   -4.448  
BIND_SILVER['%s-%s' % (dbse, '071PHE-080ILE-1')] =   -1.021  
BIND_SILVER['%s-%s' % (dbse, '071PHE-080LYS-1')] =   -1.009  
BIND_SILVER['%s-%s' % (dbse, '071PHE-086ILE-1')] =   -1.551  
BIND_SILVER['%s-%s' % (dbse, '071PHE-108ILE-1')] =   -1.086  
BIND_SILVER['%s-%s' % (dbse, '071PHE-114SER-1')] =   -0.369  
BIND_SILVER['%s-%s' % (dbse, '071SER-082HIE-1')] =   -5.678  
BIND_SILVER['%s-%s' % (dbse, '071TRP-076LEU-1')] =   -1.303  
BIND_SILVER['%s-%s' % (dbse, '071TRP-078GLU-1')] =   -5.047  
BIND_SILVER['%s-%s' % (dbse, '071TRP-099TRP-1')] =   -6.641  
BIND_SILVER['%s-%s' % (dbse, '071TRP-100SER-1')] =   -1.960  
BIND_SILVER['%s-%s' % (dbse, '071TRP-125PHE-1')] =   -2.290  
BIND_SILVER['%s-%s' % (dbse, '071TRP-165ALA-1')] =   -0.299  
BIND_SILVER['%s-%s' % (dbse, '071TRP-166TYR-1')] =   -2.343  
BIND_SILVER['%s-%s' % (dbse, '071VAL-077ILE-1')] =   -0.407  
BIND_SILVER['%s-%s' % (dbse, '071VAL-083ILE-1')] =   -0.500  
BIND_SILVER['%s-%s' % (dbse, '071VAL-085ALA-1')] =   -0.377  
BIND_SILVER['%s-%s' % (dbse, '071VAL-119VAL-1')] =    0.005  
BIND_SILVER['%s-%s' % (dbse, '072ARG-116ASP-1')] =  -94.036  
BIND_SILVER['%s-%s' % (dbse, '072ARG-118TYR-2')] =   -6.143  
BIND_SILVER['%s-%s' % (dbse, '072ASN-075ARG-1')] =  -18.653  
BIND_SILVER['%s-%s' % (dbse, '072HIE-093TYR-1')] =   -2.084  
BIND_SILVER['%s-%s' % (dbse, '072HIE-095PRO-1')] =   -2.181  
BIND_SILVER['%s-%s' % (dbse, '072ILE-077PHE-1')] =   -1.405  
BIND_SILVER['%s-%s' % (dbse, '072ILE-082HIE-1')] =   -1.841  
BIND_SILVER['%s-%s' % (dbse, '072ILE-116PHE-1')] =   -1.000  
BIND_SILVER['%s-%s' % (dbse, '072ILE-116PHE-2')] =   -1.578  
BIND_SILVER['%s-%s' % (dbse, '072THR-175GLN-1')] =   -0.945  
BIND_SILVER['%s-%s' % (dbse, '072TYR-076ARG-2')] =   -1.472  
BIND_SILVER['%s-%s' % (dbse, '072TYR-127ASN-1')] =   -0.594  
BIND_SILVER['%s-%s' % (dbse, '072VAL-176PHE-1')] =   -0.723  
BIND_SILVER['%s-%s' % (dbse, '073ARG-076LEU-1')] =   -2.347  
BIND_SILVER['%s-%s' % (dbse, '073ARG-119ASP-1')] = -102.947  
BIND_SILVER['%s-%s' % (dbse, '073ARG-163ASN-1')] =   -0.503  
BIND_SILVER['%s-%s' % (dbse, '073ASP-135ARG-1')] = -111.188  
BIND_SILVER['%s-%s' % (dbse, '073ASP-193VAL-1')] =   -2.491  
BIND_SILVER['%s-%s' % (dbse, '073GLU-077ASN-2')] =    0.108  
BIND_SILVER['%s-%s' % (dbse, '073GLU-119SER-1')] =  -19.194  
BIND_SILVER['%s-%s' % (dbse, '073ILE-128ALA-1')] =   -1.031  
BIND_SILVER['%s-%s' % (dbse, '073LEU-120TRP-1')] =   -0.969  
BIND_SILVER['%s-%s' % (dbse, '073PHE-077TYR-1')] =   -2.729  
BIND_SILVER['%s-%s' % (dbse, '073PHE-079LEU-1')] =   -0.766  
BIND_SILVER['%s-%s' % (dbse, '073SER-090SER-1')] =   -1.573  
BIND_SILVER['%s-%s' % (dbse, '073SER-178SER-1')] =   -0.284  
BIND_SILVER['%s-%s' % (dbse, '073TRP-089TYR-1')] =   -3.401  
BIND_SILVER['%s-%s' % (dbse, '073VAL-111ASP-1')] =   -1.087  
BIND_SILVER['%s-%s' % (dbse, '074ALA-083TYR-1')] =   -0.921  
BIND_SILVER['%s-%s' % (dbse, '074ARG-130TYR-2')] =   -1.350  
BIND_SILVER['%s-%s' % (dbse, '074ARG-135SER-1')] =   -1.319  
BIND_SILVER['%s-%s' % (dbse, '074ARG-135SER-2')] =  -12.500  
BIND_SILVER['%s-%s' % (dbse, '074ARG-136GLN-1')] =   -2.679  
BIND_SILVER['%s-%s' % (dbse, '074ARG-147TYR-1')] =   -1.794  
BIND_SILVER['%s-%s' % (dbse, '074ARG-147TYR-2')] =   -6.072  
BIND_SILVER['%s-%s' % (dbse, '074GLN-094ASN-1')] =   -5.895  
BIND_SILVER['%s-%s' % (dbse, '074GLU-096ARG-1')] =  -61.678  
BIND_SILVER['%s-%s' % (dbse, '074LEU-079TYR-1')] =   -1.162  
BIND_SILVER['%s-%s' % (dbse, '074LEU-102PRO-1')] =   -1.351  
BIND_SILVER['%s-%s' % (dbse, '074LEU-107PHE-1')] =   -2.437  
BIND_SILVER['%s-%s' % (dbse, '074LYS-127ALA-1')] =   -0.655  
BIND_SILVER['%s-%s' % (dbse, '074PHE-080LEU-1')] =   -2.348  
BIND_SILVER['%s-%s' % (dbse, '074PHE-083HIE-1')] =   -1.860  
BIND_SILVER['%s-%s' % (dbse, '074SER-091PRO-1')] =   -0.697  
BIND_SILVER['%s-%s' % (dbse, '074SER-111GLU-1')] =  -20.780  
BIND_SILVER['%s-%s' % (dbse, '074VAL-080TRP-1')] =   -2.461  
BIND_SILVER['%s-%s' % (dbse, '074VAL-083ASN-1')] =   -0.875  
BIND_SILVER['%s-%s' % (dbse, '074VAL-190LEU-1')] =   -0.419  
BIND_SILVER['%s-%s' % (dbse, '075GLU-079GLN-1')] =  -12.784  
BIND_SILVER['%s-%s' % (dbse, '075GLU-079GLU-2')] =   75.555  
BIND_SILVER['%s-%s' % (dbse, '075ILE-080ILE-1')] =   -0.732  
BIND_SILVER['%s-%s' % (dbse, '075ILE-112LEU-1')] =   -0.482  
BIND_SILVER['%s-%s' % (dbse, '075LEU-094ILE-1')] =   -0.577  
BIND_SILVER['%s-%s' % (dbse, '075LEU-111LEU-1')] =   -0.321  
BIND_SILVER['%s-%s' % (dbse, '075LEU-111LEU-2')] =   -0.343  
BIND_SILVER['%s-%s' % (dbse, '075PHE-093PRO-1')] =   -1.702  
BIND_SILVER['%s-%s' % (dbse, '075PHE-182ASN-1')] =   -2.265  
BIND_SILVER['%s-%s' % (dbse, '075PHE-184PHE-1')] =   -1.346  
BIND_SILVER['%s-%s' % (dbse, '075SER-078TRP-1')] =   -1.505  
BIND_SILVER['%s-%s' % (dbse, '075SER-111ASP-1')] =  -17.129  
BIND_SILVER['%s-%s' % (dbse, '075TRP-176ARG-1')] =   -3.569  
BIND_SILVER['%s-%s' % (dbse, '076ARG-079GLU-1')] =  -96.820  
BIND_SILVER['%s-%s' % (dbse, '076ARG-120TRP-1')] =   -2.738  
BIND_SILVER['%s-%s' % (dbse, '076ARG-208TYR-1')] =   -1.739  
BIND_SILVER['%s-%s' % (dbse, '076ARG-208TYR-2')] =   -6.129  
BIND_SILVER['%s-%s' % (dbse, '076ASP-084LEU-1')] =   -0.951  
BIND_SILVER['%s-%s' % (dbse, '076ASP-089TYR-1')] =  -26.050  
BIND_SILVER['%s-%s' % (dbse, '076ASP-091PRO-1')] =   -1.398  
BIND_SILVER['%s-%s' % (dbse, '076ASP-188GLN-1')] =  -20.543  
BIND_SILVER['%s-%s' % (dbse, '076GLU-170LEU-1')] =   -2.864  
BIND_SILVER['%s-%s' % (dbse, '076ILE-094ASN-1')] =   -1.382  
BIND_SILVER['%s-%s' % (dbse, '076LEU-086MET-1')] =   -0.164  
BIND_SILVER['%s-%s' % (dbse, '076LEU-117ILE-2')] =   -0.076  
BIND_SILVER['%s-%s' % (dbse, '076LEU-123THR-1')] =   -0.501  
BIND_SILVER['%s-%s' % (dbse, '076PRO-111TRP-1')] =   -0.977  
BIND_SILVER['%s-%s' % (dbse, '076PRO-112LEU-1')] =   -0.071  
BIND_SILVER['%s-%s' % (dbse, '076SER-082PHE-1')] =   -1.486  
BIND_SILVER['%s-%s' % (dbse, '076THR-090SER-1')] =   -5.444  
BIND_SILVER['%s-%s' % (dbse, '076TYR-125ILE-1')] =   -2.394  
BIND_SILVER['%s-%s' % (dbse, '076TYR-125ILE-2')] =   -1.328  
BIND_SILVER['%s-%s' % (dbse, '076TYR-136TYR-1')] =   -1.913  
BIND_SILVER['%s-%s' % (dbse, '076TYR-139ILE-1')] =   -2.144  
BIND_SILVER['%s-%s' % (dbse, '076TYR-143TRP-1')] =   -5.322  
BIND_SILVER['%s-%s' % (dbse, '077ALA-096ARG-1')] =   -1.090  
BIND_SILVER['%s-%s' % (dbse, '077ALA-138ARG-1')] =   -1.454  
BIND_SILVER['%s-%s' % (dbse, '077ALA-138ARG-2')] =   -0.135  
BIND_SILVER['%s-%s' % (dbse, '077ASP-080ARG-2')] =  -85.478  
BIND_SILVER['%s-%s' % (dbse, '077HIE-111LEU-1')] =   -1.045  
BIND_SILVER['%s-%s' % (dbse, '077ILE-102PHE-1')] =   -0.944  
BIND_SILVER['%s-%s' % (dbse, '077ILE-112ILE-1')] =   -0.774  
BIND_SILVER['%s-%s' % (dbse, '077ILE-125VAL-1')] =   -1.108  
BIND_SILVER['%s-%s' % (dbse, '077ILE-128TYR-1')] =   -1.098  
BIND_SILVER['%s-%s' % (dbse, '077ILE-128TYR-2')] =   -1.521  
BIND_SILVER['%s-%s' % (dbse, '077LEU-093VAL-2')] =   -0.097  
BIND_SILVER['%s-%s' % (dbse, '077LYS-178VAL-1')] =   -3.576  
BIND_SILVER['%s-%s' % (dbse, '077LYS-186ASN-2')] =  -19.450  
BIND_SILVER['%s-%s' % (dbse, '077PHE-089PHE-1')] =   -2.581  
BIND_SILVER['%s-%s' % (dbse, '077PHE-093ILE-1')] =    0.048  
BIND_SILVER['%s-%s' % (dbse, '077PHE-097LEU-1')] =   -1.546  
BIND_SILVER['%s-%s' % (dbse, '077PHE-116PHE-1')] =   -1.794  
BIND_SILVER['%s-%s' % (dbse, '077PHE-160VAL-1')] =   -0.736  
BIND_SILVER['%s-%s' % (dbse, '077PHE-162PRO-1')] =   -1.306  
BIND_SILVER['%s-%s' % (dbse, '077PHE-201ARG-1')] =   -6.586  
BIND_SILVER['%s-%s' % (dbse, '077PHE-205GLU-1')] =   -8.878  
BIND_SILVER['%s-%s' % (dbse, '078ALA-126VAL-1')] =   -0.530  
BIND_SILVER['%s-%s' % (dbse, '078ASP-157LYS-1')] = -104.399  
BIND_SILVER['%s-%s' % (dbse, '078GLN-085LYS-1')] =   -1.452  
BIND_SILVER['%s-%s' % (dbse, '078GLN-088GLU-1')] =  -20.923  
BIND_SILVER['%s-%s' % (dbse, '078GLU-099THR-1')] =   -3.255  
BIND_SILVER['%s-%s' % (dbse, '078GLU-127GLN-2')] =  -23.568  
BIND_SILVER['%s-%s' % (dbse, '078HIE-081PHE-1')] =   -1.666  
BIND_SILVER['%s-%s' % (dbse, '078LEU-108VAL-1')] =    0.207  
BIND_SILVER['%s-%s' % (dbse, '078PHE-082VAL-1')] =   -1.143  
BIND_SILVER['%s-%s' % (dbse, '078PHE-096ALA-1')] =   -0.990  
BIND_SILVER['%s-%s' % (dbse, '078PHE-104TRP-1')] =   -2.534  
BIND_SILVER['%s-%s' % (dbse, '078PHE-107ALA-2')] =   -0.959  
BIND_SILVER['%s-%s' % (dbse, '078PHE-108LEU-1')] =   -1.124  
BIND_SILVER['%s-%s' % (dbse, '078PHE-179LEU-1')] =   -2.075  
BIND_SILVER['%s-%s' % (dbse, '078PHE-215ILE-1')] =   -1.004  
BIND_SILVER['%s-%s' % (dbse, '078PHE-218LEU-1')] =   -0.829  
BIND_SILVER['%s-%s' % (dbse, '078PHE-218LEU-2')] =    0.143  
BIND_SILVER['%s-%s' % (dbse, '078PRO-115PRO-1')] =   -1.478  
BIND_SILVER['%s-%s' % (dbse, '078PRO-186ASN-1')] =   -3.650  
BIND_SILVER['%s-%s' % (dbse, '078SER-184PHE-1')] =   -2.740  
BIND_SILVER['%s-%s' % (dbse, '078TYR-082PHE-1')] =   -2.997  
BIND_SILVER['%s-%s' % (dbse, '079ARG-083ASP-1')] =  -98.150  
BIND_SILVER['%s-%s' % (dbse, '079ARG-182ASP-1')] = -110.832  
BIND_SILVER['%s-%s' % (dbse, '079ASP-131HIE-1')] =  -27.682  
BIND_SILVER['%s-%s' % (dbse, '079ASP-135ILE-1')] =   -2.958  
BIND_SILVER['%s-%s' % (dbse, '079PHE-089PHE-1')] =   -1.438  
BIND_SILVER['%s-%s' % (dbse, '079PHE-100THR-1')] =   -1.782  
BIND_SILVER['%s-%s' % (dbse, '079PHE-104LEU-1')] =   -1.382  
BIND_SILVER['%s-%s' % (dbse, '079SER-088ALA-1')] =   -0.767  
BIND_SILVER['%s-%s' % (dbse, '079SER-208TYR-1')] =   -0.485  
BIND_SILVER['%s-%s' % (dbse, '079THR-089LEU-1')] =   -1.001  
BIND_SILVER['%s-%s' % (dbse, '079THR-089LEU-2')] =   -0.399  
BIND_SILVER['%s-%s' % (dbse, '079THR-110THR-1')] =   -5.310  
BIND_SILVER['%s-%s' % (dbse, '079TYR-084PRO-1')] =   -2.408  
BIND_SILVER['%s-%s' % (dbse, '079TYR-109VAL-1')] =   -0.829  
BIND_SILVER['%s-%s' % (dbse, '079TYR-112LEU-1')] =   -0.739  
BIND_SILVER['%s-%s' % (dbse, '079TYR-112LEU-2')] =   -1.092  
BIND_SILVER['%s-%s' % (dbse, '079TYR-146PHE-1')] =   -2.538  
BIND_SILVER['%s-%s' % (dbse, '079TYR-153TRP-1')] =   -1.806  
BIND_SILVER['%s-%s' % (dbse, '079TYR-167GLN-1')] =    1.334  
BIND_SILVER['%s-%s' % (dbse, '079VAL-087LYS-1')] =   -0.312  
BIND_SILVER['%s-%s' % (dbse, '079VAL-094ILE-1')] =   -0.338  
BIND_SILVER['%s-%s' % (dbse, '080ARG-088PHE-1')] =   -4.898  
BIND_SILVER['%s-%s' % (dbse, '080ARG-090ASP-1')] =   -3.422  
BIND_SILVER['%s-%s' % (dbse, '080ASP-087LYS-1')] = -112.373  
BIND_SILVER['%s-%s' % (dbse, '080GLU-092ALA-1')] =   -3.297  
BIND_SILVER['%s-%s' % (dbse, '080GLU-155ARG-1')] = -119.462  
BIND_SILVER['%s-%s' % (dbse, '080ILE-112LEU-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '080PHE-085LYS-1')] =   -2.072  
BIND_SILVER['%s-%s' % (dbse, '080PHE-098SER-1')] =   -1.550  
BIND_SILVER['%s-%s' % (dbse, '080PHE-166PHE-1')] =   -1.014  
BIND_SILVER['%s-%s' % (dbse, '080THR-090ARG-1')] =   -2.125  
BIND_SILVER['%s-%s' % (dbse, '080TRP-088LEU-1')] =   -1.338  
BIND_SILVER['%s-%s' % (dbse, '080TRP-090TYR-1')] =   -3.216  
BIND_SILVER['%s-%s' % (dbse, '080TRP-095ILE-1')] =   -2.058  
BIND_SILVER['%s-%s' % (dbse, '080TRP-108LEU-1')] =   -2.520  
BIND_SILVER['%s-%s' % (dbse, '080TRP-136ILE-1')] =   -1.499  
BIND_SILVER['%s-%s' % (dbse, '080TYR-129TRP-1')] =   -4.310  
BIND_SILVER['%s-%s' % (dbse, '080TYR-172GLU-1')] =    1.079  
BIND_SILVER['%s-%s' % (dbse, '081ALA-088ALA-1')] =   -0.806  
BIND_SILVER['%s-%s' % (dbse, '081ASN-084LEU-1')] =   -1.846  
BIND_SILVER['%s-%s' % (dbse, '081ASN-085SER-1')] =   -0.337  
BIND_SILVER['%s-%s' % (dbse, '081ASN-100TRP-1')] =   -6.023  
BIND_SILVER['%s-%s' % (dbse, '081ASP-092SER-1')] =  -18.909  
BIND_SILVER['%s-%s' % (dbse, '081GLN-085ASP-1')] =  -22.487  
BIND_SILVER['%s-%s' % (dbse, '081GLU-101ASN-1')] =    5.505  
BIND_SILVER['%s-%s' % (dbse, '081GLU-103GLN-1')] =   -1.589  
BIND_SILVER['%s-%s' % (dbse, '081GLU-103GLN-2')] =  -14.004  
BIND_SILVER['%s-%s' % (dbse, '081HIE-202PHE-1')] =   -3.023  
BIND_SILVER['%s-%s' % (dbse, '081ILE-085ARG-1')] =   -2.695  
BIND_SILVER['%s-%s' % (dbse, '081LYS-105VAL-1')] =   -3.965  
BIND_SILVER['%s-%s' % (dbse, '081MET-106CYS-1')] =   12.863  
BIND_SILVER['%s-%s' % (dbse, '081MET-134GLU-1')] =   -1.498  
BIND_SILVER['%s-%s' % (dbse, '081MET-134GLU-2')] =   -8.937  
BIND_SILVER['%s-%s' % (dbse, '081MET-138ARG-1')] =   -4.952  
BIND_SILVER['%s-%s' % (dbse, '081SER-087PHE-1')] =   -1.435  
BIND_SILVER['%s-%s' % (dbse, '081TYR-085ARG-1')] =   -2.008  
BIND_SILVER['%s-%s' % (dbse, '081TYR-130VAL-1')] =   -0.642  
BIND_SILVER['%s-%s' % (dbse, '081VAL-105TYR-1')] =   -0.833  
BIND_SILVER['%s-%s' % (dbse, '081VAL-149HIE-1')] =   -1.375  
BIND_SILVER['%s-%s' % (dbse, '082ARG-088PHE-1')] =   -1.996  
BIND_SILVER['%s-%s' % (dbse, '082ARG-088PHE-2')] =   -4.615  
BIND_SILVER['%s-%s' % (dbse, '082ILE-121LEU-1')] =   -0.534  
BIND_SILVER['%s-%s' % (dbse, '082ILE-135ILE-1')] =   -0.867  
BIND_SILVER['%s-%s' % (dbse, '082ILE-136PHE-1')] =   -0.550  
BIND_SILVER['%s-%s' % (dbse, '082ILE-186VAL-1')] =   -0.913  
BIND_SILVER['%s-%s' % (dbse, '082LEU-176PHE-1')] =   -0.790  
BIND_SILVER['%s-%s' % (dbse, '082PHE-091ILE-1')] =    0.879  
BIND_SILVER['%s-%s' % (dbse, '082PHE-102TYR-1')] =   -2.905  
BIND_SILVER['%s-%s' % (dbse, '082PHE-104VAL-1')] =   -0.970  
BIND_SILVER['%s-%s' % (dbse, '082VAL-108LEU-1')] =   -0.423  
BIND_SILVER['%s-%s' % (dbse, '082VAL-126SER-1')] =   -0.546  
BIND_SILVER['%s-%s' % (dbse, '082VAL-127PHE-1')] =   -1.819  
BIND_SILVER['%s-%s' % (dbse, '082VAL-130VAL-1')] =   -0.653  
BIND_SILVER['%s-%s' % (dbse, '083ASP-089HIE-1')] =  -23.521  
BIND_SILVER['%s-%s' % (dbse, '083ASP-105TYR-1')] =    3.567  
BIND_SILVER['%s-%s' % (dbse, '083ASP-136ARG-1')] =  -94.166  
BIND_SILVER['%s-%s' % (dbse, '083GLU-094TYR-1')] =   -7.468  
BIND_SILVER['%s-%s' % (dbse, '083HIE-086GLU-1')] =  -25.557  
BIND_SILVER['%s-%s' % (dbse, '083HIE-089ASP-1')] =  -25.324  
BIND_SILVER['%s-%s' % (dbse, '083ILE-155ARG-1')] =   -0.707  
BIND_SILVER['%s-%s' % (dbse, '083ILE-173LEU-1')] =   -0.481  
BIND_SILVER['%s-%s' % (dbse, '083LEU-087LEU-1')] =   -1.218  
BIND_SILVER['%s-%s' % (dbse, '083LEU-088TYR-2')] =   -1.631  
BIND_SILVER['%s-%s' % (dbse, '083LEU-101GLN-1')] =   -0.953  
BIND_SILVER['%s-%s' % (dbse, '083LEU-108VAL-1')] =   -0.512  
BIND_SILVER['%s-%s' % (dbse, '083THR-086MET-1')] =    0.699  
BIND_SILVER['%s-%s' % (dbse, '083THR-087GLN-1')] =   -1.302  
BIND_SILVER['%s-%s' % (dbse, '083TYR-087PHE-1')] =   -3.085  
BIND_SILVER['%s-%s' % (dbse, '083TYR-094TYR-1')] =   -1.423  
BIND_SILVER['%s-%s' % (dbse, '083TYR-096ASN-1')] =   -1.767  
BIND_SILVER['%s-%s' % (dbse, '083VAL-087LEU-1')] =   -0.799  
BIND_SILVER['%s-%s' % (dbse, '083VAL-094PHE-1')] =   -0.853  
BIND_SILVER['%s-%s' % (dbse, '083VAL-094PHE-2')] =   -0.758  
BIND_SILVER['%s-%s' % (dbse, '083VAL-103TRP-1')] =   -1.575  
BIND_SILVER['%s-%s' % (dbse, '083VAL-140TYR-1')] =   -1.018  
BIND_SILVER['%s-%s' % (dbse, '083VAL-153PHE-1')] =   -0.234  
BIND_SILVER['%s-%s' % (dbse, '084ARG-089ASP-1')] =  -87.733  
BIND_SILVER['%s-%s' % (dbse, '084ASN-099LYS-1')] =   -1.432  
BIND_SILVER['%s-%s' % (dbse, '084ASN-103TRP-1')] =   -8.418  
BIND_SILVER['%s-%s' % (dbse, '084ASP-087PHE-1')] =   -4.626  
BIND_SILVER['%s-%s' % (dbse, '084ASP-107ASN-1')] =  -14.111  
BIND_SILVER['%s-%s' % (dbse, '084ASP-126VAL-1')] =   -2.446  
BIND_SILVER['%s-%s' % (dbse, '084CYS-090LYS-1')] =  -11.019  
BIND_SILVER['%s-%s' % (dbse, '084LEU-090LEU-1')] =   -0.621  
BIND_SILVER['%s-%s' % (dbse, '084PRO-122PHE-1')] =   -1.276  
BIND_SILVER['%s-%s' % (dbse, '084PRO-135PHE-1')] =   -1.475  
BIND_SILVER['%s-%s' % (dbse, '084THR-107PRO-1')] =   -1.870  
BIND_SILVER['%s-%s' % (dbse, '084THR-108TYR-1')] =   -0.854  
BIND_SILVER['%s-%s' % (dbse, '084TYR-089ASP-1')] =    0.573  
BIND_SILVER['%s-%s' % (dbse, '084TYR-095LEU-1')] =   -1.312  
BIND_SILVER['%s-%s' % (dbse, '085ASN-099TYR-1')] =   -1.506  
BIND_SILVER['%s-%s' % (dbse, '085HIE-094TYR-1')] =   -2.859  
BIND_SILVER['%s-%s' % (dbse, '085HIE-101TYR-1')] =   -2.706  
BIND_SILVER['%s-%s' % (dbse, '085ILE-089ALA-1')] =   -0.462  
BIND_SILVER['%s-%s' % (dbse, '085ILE-103LEU-1')] =   -1.299  
BIND_SILVER['%s-%s' % (dbse, '085LEU-094PHE-1')] =   -0.985  
BIND_SILVER['%s-%s' % (dbse, '085LEU-108LEU-1')] =   -0.464  
BIND_SILVER['%s-%s' % (dbse, '085LEU-137ASN-1')] =   -1.162  
BIND_SILVER['%s-%s' % (dbse, '085LEU-138LEU-1')] =   -0.754  
BIND_SILVER['%s-%s' % (dbse, '085LYS-088GLU-1')] = -111.602  
BIND_SILVER['%s-%s' % (dbse, '085LYS-094TYR-1')] =   -2.278  
BIND_SILVER['%s-%s' % (dbse, '085MET-136PHE-1')] =   -1.109  
BIND_SILVER['%s-%s' % (dbse, '085PRO-090LYS-1')] =   -0.883  
BIND_SILVER['%s-%s' % (dbse, '085TRP-089ARG-1')] =   -3.017  
BIND_SILVER['%s-%s' % (dbse, '085TRP-135LYS-2')] =   -7.418  
BIND_SILVER['%s-%s' % (dbse, '086ALA-101GLN-1')] =   -0.786  
BIND_SILVER['%s-%s' % (dbse, '086ALA-104TRP-1')] =   -0.941  
BIND_SILVER['%s-%s' % (dbse, '086ALA-136PHE-2')] =   -2.089  
BIND_SILVER['%s-%s' % (dbse, '086ASP-091ILE-1')] =   -6.341  
BIND_SILVER['%s-%s' % (dbse, '086ASP-092TRP-1')] =   -6.747  
BIND_SILVER['%s-%s' % (dbse, '086ASP-112TRP-1')] =  -11.095  
BIND_SILVER['%s-%s' % (dbse, '086ASP-115ARG-1')] = -112.147  
BIND_SILVER['%s-%s' % (dbse, '086HIE-089GLU-2')] =   14.332  
BIND_SILVER['%s-%s' % (dbse, '086PRO-090ALA-1')] =   -1.471  
BIND_SILVER['%s-%s' % (dbse, '086SER-136TRP-1')] =   -3.395  
BIND_SILVER['%s-%s' % (dbse, '086VAL-105LEU-1')] =   -0.686  
BIND_SILVER['%s-%s' % (dbse, '086VAL-116VAL-1')] =   -0.648  
BIND_SILVER['%s-%s' % (dbse, '087ALA-171PRO-1')] =   -0.068  
BIND_SILVER['%s-%s' % (dbse, '087ALA-173TYR-1')] =   -1.393  
BIND_SILVER['%s-%s' % (dbse, '087ASN-091LYS-1')] =    3.418  
BIND_SILVER['%s-%s' % (dbse, '087CYS-119ASP-1')] =    6.331  
BIND_SILVER['%s-%s' % (dbse, '087CYS-121LEU-1')] =   -0.215  
BIND_SILVER['%s-%s' % (dbse, '087GLN-139ASN-1')] =   -6.621  
BIND_SILVER['%s-%s' % (dbse, '087LEU-095PHE-1')] =   -1.417  
BIND_SILVER['%s-%s' % (dbse, '087LEU-095PHE-2')] =   -1.194  
BIND_SILVER['%s-%s' % (dbse, '087LEU-096TRP-1')] =   -1.076  
BIND_SILVER['%s-%s' % (dbse, '087LEU-109VAL-1')] =   -0.464  
BIND_SILVER['%s-%s' % (dbse, '087LEU-153PHE-1')] =   -0.196  
BIND_SILVER['%s-%s' % (dbse, '087PHE-126VAL-1')] =   -0.720  
BIND_SILVER['%s-%s' % (dbse, '087PHE-186VAL-1')] =   -1.483  
BIND_SILVER['%s-%s' % (dbse, '087PHE-188VAL-1')] =   -1.032  
BIND_SILVER['%s-%s' % (dbse, '087VAL-102LEU-1')] =   -0.044  
BIND_SILVER['%s-%s' % (dbse, '088ASN-092ASP-1')] =   -1.382  
BIND_SILVER['%s-%s' % (dbse, '088ILE-135LEU-1')] =   -0.233  
BIND_SILVER['%s-%s' % (dbse, '088ILE-135PHE-1')] =   -1.428  
BIND_SILVER['%s-%s' % (dbse, '088LEU-108ILE-1')] =   -0.593  
BIND_SILVER['%s-%s' % (dbse, '088PHE-092LEU-1')] =   -0.940  
BIND_SILVER['%s-%s' % (dbse, '089ARG-106ASP-1')] =  -92.607  
BIND_SILVER['%s-%s' % (dbse, '089ARG-108TYR-1')] =  -12.371  
BIND_SILVER['%s-%s' % (dbse, '089ARG-131VAL-1')] =   -2.331  
BIND_SILVER['%s-%s' % (dbse, '089ASP-092PHE-1')] =   -5.338  
BIND_SILVER['%s-%s' % (dbse, '089ASP-112ASN-1')] =  -14.022  
BIND_SILVER['%s-%s' % (dbse, '089ASP-131VAL-1')] =   -2.528  
BIND_SILVER['%s-%s' % (dbse, '089CYS-105LEU-1')] =   -1.360  
BIND_SILVER['%s-%s' % (dbse, '089GLN-117PHE-1')] =   -2.995  
BIND_SILVER['%s-%s' % (dbse, '089GLN-125TYR-1')] =   -1.628  
BIND_SILVER['%s-%s' % (dbse, '089ILE-112TRP-1')] =   -1.730  
BIND_SILVER['%s-%s' % (dbse, '089LEU-127VAL-1')] =   -1.016  
BIND_SILVER['%s-%s' % (dbse, '089THR-098LEU-1')] =   -0.567  
BIND_SILVER['%s-%s' % (dbse, '089THR-098LEU-2')] =   -0.574  
BIND_SILVER['%s-%s' % (dbse, '089TYR-094TYR-1')] =   -1.625  
BIND_SILVER['%s-%s' % (dbse, '089TYR-153VAL-1')] =   -0.596  
BIND_SILVER['%s-%s' % (dbse, '090ALA-121PHE-1')] =   -1.638  
BIND_SILVER['%s-%s' % (dbse, '090ARG-187SER-1')] =   -8.015  
BIND_SILVER['%s-%s' % (dbse, '090GLU-119ARG-1')] = -101.781  
BIND_SILVER['%s-%s' % (dbse, '090ILE-099LEU-1')] =   -0.650  
BIND_SILVER['%s-%s' % (dbse, '090ILE-107SER-1')] =   -1.109  
BIND_SILVER['%s-%s' % (dbse, '090ILE-190VAL-1')] =   -0.352  
BIND_SILVER['%s-%s' % (dbse, '090LYS-122ASP-1')] =   -5.808  
BIND_SILVER['%s-%s' % (dbse, '090LYS-122ASP-2')] =   -3.802  
BIND_SILVER['%s-%s' % (dbse, '090PRO-129TRP-1')] =   -1.639  
BIND_SILVER['%s-%s' % (dbse, '090PRO-154VAL-1')] =   -0.510  
BIND_SILVER['%s-%s' % (dbse, '090TYR-095ARG-1')] =   -8.490  
BIND_SILVER['%s-%s' % (dbse, '090TYR-095ILE-1')] =   -1.285  
BIND_SILVER['%s-%s' % (dbse, '090TYR-099ILE-1')] =   -0.885  
BIND_SILVER['%s-%s' % (dbse, '090TYR-105LEU-1')] =   -0.739  
BIND_SILVER['%s-%s' % (dbse, '090TYR-112GLU-1')] =    5.782  
BIND_SILVER['%s-%s' % (dbse, '090TYR-113ALA-1')] =   -2.335  
BIND_SILVER['%s-%s' % (dbse, '091ASN-096TRP-1')] =   -7.215  
BIND_SILVER['%s-%s' % (dbse, '091HIE-098SER-1')] =   -4.603  
BIND_SILVER['%s-%s' % (dbse, '091HIE-118THR-1')] =   -0.609  
BIND_SILVER['%s-%s' % (dbse, '091HIE-118THR-2')] =   -2.569  
BIND_SILVER['%s-%s' % (dbse, '091HIE-121LEU-1')] =   -2.055  
BIND_SILVER['%s-%s' % (dbse, '091HIE-122ASP-1')] =   11.177  
BIND_SILVER['%s-%s' % (dbse, '091HIE-125HIE-1')] =   -1.124  
BIND_SILVER['%s-%s' % (dbse, '091HIE-127VAL-1')] =   -0.878  
BIND_SILVER['%s-%s' % (dbse, '091LYS-140SER-1')] =   -0.897  
BIND_SILVER['%s-%s' % (dbse, '091LYS-140SER-2')] =  -16.957  
BIND_SILVER['%s-%s' % (dbse, '091THR-094HIE-2')] =   -6.615  
BIND_SILVER['%s-%s' % (dbse, '091VAL-094ASP-1')] =   -0.140  
BIND_SILVER['%s-%s' % (dbse, '092ALA-164GLU-1')] =   -0.702  
BIND_SILVER['%s-%s' % (dbse, '092LEU-095HIE-1')] =   -1.546  
BIND_SILVER['%s-%s' % (dbse, '092PHE-099TRP-1')] =   -3.633  
BIND_SILVER['%s-%s' % (dbse, '092PHE-120VAL-1')] =   -0.797  
BIND_SILVER['%s-%s' % (dbse, '092PHE-131VAL-1')] =   -0.965  
BIND_SILVER['%s-%s' % (dbse, '092PRO-102HIE-1')] =   -1.513  
BIND_SILVER['%s-%s' % (dbse, '092PRO-133LYS-1')] =   -1.018  
BIND_SILVER['%s-%s' % (dbse, '092TRP-100GLN-1')] =   22.586  
BIND_SILVER['%s-%s' % (dbse, '092VAL-117PHE-1')] =   -1.102  
BIND_SILVER['%s-%s' % (dbse, '093ALA-099THR-1')] =   -0.735  
BIND_SILVER['%s-%s' % (dbse, '093ALA-164ASP-1')] =   -4.523  
BIND_SILVER['%s-%s' % (dbse, '093ASN-096LYS-1')] =   -1.650  
BIND_SILVER['%s-%s' % (dbse, '093ASP-097THR-1')] =  -22.003  
BIND_SILVER['%s-%s' % (dbse, '093HIE-118GLN-1')] =   -3.989  
BIND_SILVER['%s-%s' % (dbse, '093HIE-120ALA-1')] =   -0.585  
BIND_SILVER['%s-%s' % (dbse, '093PRO-184PHE-1')] =   -1.529  
BIND_SILVER['%s-%s' % (dbse, '094HIE-099THR-1')] =   -1.436  
BIND_SILVER['%s-%s' % (dbse, '094HIE-104PHE-1')] =   -2.770  
BIND_SILVER['%s-%s' % (dbse, '094ILE-114TRP-1')] =   -0.975  
BIND_SILVER['%s-%s' % (dbse, '094LEU-132VAL-1')] =   -0.824  
BIND_SILVER['%s-%s' % (dbse, '094LEU-182MET-1')] =   -0.825  
BIND_SILVER['%s-%s' % (dbse, '094LYS-112ASP-1')] = -122.181  
BIND_SILVER['%s-%s' % (dbse, '094PHE-098ILE-1')] =    0.187  
BIND_SILVER['%s-%s' % (dbse, '094PHE-141ALA-1')] =   -0.669  
BIND_SILVER['%s-%s' % (dbse, '094PRO-135MET-1')] =   -0.831  
BIND_SILVER['%s-%s' % (dbse, '094TYR-097THR-1')] =   -0.361  
BIND_SILVER['%s-%s' % (dbse, '094TYR-151VAL-1')] =   -0.869  
BIND_SILVER['%s-%s' % (dbse, '094TYR-153VAL-1')] =   -1.721  
BIND_SILVER['%s-%s' % (dbse, '094VAL-125TRP-1')] =   -0.899  
BIND_SILVER['%s-%s' % (dbse, '094VAL-152LEU-1')] =   -0.096  
BIND_SILVER['%s-%s' % (dbse, '094VAL-166PHE-1')] =   -1.402  
BIND_SILVER['%s-%s' % (dbse, '095ASN-164ASP-1')] =  -23.285  
BIND_SILVER['%s-%s' % (dbse, '095ASP-102TYR-1')] =    4.553  
BIND_SILVER['%s-%s' % (dbse, '095GLN-098TYR-1')] =   -2.042  
BIND_SILVER['%s-%s' % (dbse, '095GLN-185THR-1')] =   -0.931  
BIND_SILVER['%s-%s' % (dbse, '095GLN-187ASP-1')] =   -6.221  
BIND_SILVER['%s-%s' % (dbse, '095ILE-120TRP-1')] =   -1.650  
BIND_SILVER['%s-%s' % (dbse, '095ILE-120TRP-2')] =   -0.952  
BIND_SILVER['%s-%s' % (dbse, '095ILE-144THR-1')] =   -0.553  
BIND_SILVER['%s-%s' % (dbse, '095LEU-103ILE-1')] =   -0.454  
BIND_SILVER['%s-%s' % (dbse, '095LEU-130VAL-1')] =   -0.648  
BIND_SILVER['%s-%s' % (dbse, '095LEU-133LYS-1')] =   -0.673  
BIND_SILVER['%s-%s' % (dbse, '095LYS-107ILE-1')] =   -0.895  
BIND_SILVER['%s-%s' % (dbse, '095LYS-109THR-1')] =  -14.871  
BIND_SILVER['%s-%s' % (dbse, '095LYS-127ASP-1')] =   -6.315  
BIND_SILVER['%s-%s' % (dbse, '095PHE-099LYS-2')] =   -2.566  
BIND_SILVER['%s-%s' % (dbse, '095PHE-118ALA-1')] =   -0.799  
BIND_SILVER['%s-%s' % (dbse, '095PHE-154ILE-1')] =   -1.266  
BIND_SILVER['%s-%s' % (dbse, '095PHE-160VAL-1')] =   -0.938  
BIND_SILVER['%s-%s' % (dbse, '095PHE-160VAL-2')] =   -0.461  
BIND_SILVER['%s-%s' % (dbse, '095SER-114THR-1')] =   -1.124  
BIND_SILVER['%s-%s' % (dbse, '095THR-182ASN-1')] =    1.632  
BIND_SILVER['%s-%s' % (dbse, '095TRP-099LEU-2')] =   -1.489  
BIND_SILVER['%s-%s' % (dbse, '095TRP-104VAL-1')] =   -0.803  
BIND_SILVER['%s-%s' % (dbse, '095TYR-106TYR-1')] =   -4.444  
BIND_SILVER['%s-%s' % (dbse, '096ASP-100ASN-1')] =  -21.737  
BIND_SILVER['%s-%s' % (dbse, '096ASP-101GLN-1')] =  -22.632  
BIND_SILVER['%s-%s' % (dbse, '096GLU-121LYS-1')] =   -4.251  
BIND_SILVER['%s-%s' % (dbse, '096HIE-101GLN-1')] =   -4.344  
BIND_SILVER['%s-%s' % (dbse, '096HIE-103SER-1')] =   -5.557  
BIND_SILVER['%s-%s' % (dbse, '096HIE-126LEU-1')] =   -1.779  
BIND_SILVER['%s-%s' % (dbse, '096HIE-127ASP-1')] =   11.914  
BIND_SILVER['%s-%s' % (dbse, '096HIE-132VAL-1')] =   -1.366  
BIND_SILVER['%s-%s' % (dbse, '096ILE-127VAL-1')] =   -0.329  
BIND_SILVER['%s-%s' % (dbse, '096ILE-127VAL-2')] =   -0.091  
BIND_SILVER['%s-%s' % (dbse, '096TRP-110LEU-1')] =   -1.054  
BIND_SILVER['%s-%s' % (dbse, '096VAL-105LEU-1')] =    0.122  
BIND_SILVER['%s-%s' % (dbse, '096VAL-108THR-1')] =   -0.759  
BIND_SILVER['%s-%s' % (dbse, '097ALA-105LEU-1')] =   -0.568  
BIND_SILVER['%s-%s' % (dbse, '097ALA-117HIE-1')] =   -0.936  
BIND_SILVER['%s-%s' % (dbse, '097ASN-102TYR-1')] =   -4.001  
BIND_SILVER['%s-%s' % (dbse, '097GLU-101ARG-1')] = -103.582  
BIND_SILVER['%s-%s' % (dbse, '097ILE-105THR-1')] =   -0.937  
BIND_SILVER['%s-%s' % (dbse, '097LEU-111PHE-1')] =   -1.130  
BIND_SILVER['%s-%s' % (dbse, '097LEU-113ILE-1')] =    1.413  
BIND_SILVER['%s-%s' % (dbse, '097LEU-128PHE-1')] =   -1.179  
BIND_SILVER['%s-%s' % (dbse, '097PHE-103ARG-1')] =   -2.176  
BIND_SILVER['%s-%s' % (dbse, '097PHE-181TRP-1')] =   -2.777  
BIND_SILVER['%s-%s' % (dbse, '097PHE-183ILE-1')] =   -0.991  
BIND_SILVER['%s-%s' % (dbse, '097PRO-106ILE-1')] =   -0.531  
BIND_SILVER['%s-%s' % (dbse, '097TRP-145LYS-1')] =   -1.506  
BIND_SILVER['%s-%s' % (dbse, '097TRP-173TYR-1')] =   -3.119  
BIND_SILVER['%s-%s' % (dbse, '097TRP-213ILE-1')] =   -1.068  
BIND_SILVER['%s-%s' % (dbse, '097TYR-101TRP-1')] =   -3.806  
BIND_SILVER['%s-%s' % (dbse, '097TYR-179LYS-1')] =   -2.549  
BIND_SILVER['%s-%s' % (dbse, '097TYR-179LYS-2')] =   -4.666  
BIND_SILVER['%s-%s' % (dbse, '097VAL-112TRP-1')] =   -0.783  
BIND_SILVER['%s-%s' % (dbse, '098ILE-145ILE-1')] =   -0.584  
BIND_SILVER['%s-%s' % (dbse, '098LEU-101VAL-1')] =   -0.940  
BIND_SILVER['%s-%s' % (dbse, '098LEU-115SER-1')] =   -1.010  
BIND_SILVER['%s-%s' % (dbse, '098LEU-117ALA-1')] =   -0.500  
BIND_SILVER['%s-%s' % (dbse, '098LEU-136PHE-1')] =   -0.911  
BIND_SILVER['%s-%s' % (dbse, '098LEU-144VAL-1')] =   -0.464  
BIND_SILVER['%s-%s' % (dbse, '098LEU-144VAL-2')] =   -0.555  
BIND_SILVER['%s-%s' % (dbse, '098LEU-146TRP-1')] =   -1.055  
BIND_SILVER['%s-%s' % (dbse, '098PRO-101GLN-1')] =   -1.459  
BIND_SILVER['%s-%s' % (dbse, '098PRO-102ALA-1')] =   -0.033  
BIND_SILVER['%s-%s' % (dbse, '098PRO-114PHE-1')] =   -0.782  
BIND_SILVER['%s-%s' % (dbse, '098SER-112PHE-1')] =   -2.124  
BIND_SILVER['%s-%s' % (dbse, '098SER-127VAL-1')] =    0.073  
BIND_SILVER['%s-%s' % (dbse, '098SER-138TYR-2')] =    2.522  
BIND_SILVER['%s-%s' % (dbse, '098SER-164ASP-1')] =  -17.628  
BIND_SILVER['%s-%s' % (dbse, '098VAL-101GLN-1')] =   -1.140  
BIND_SILVER['%s-%s' % (dbse, '098VAL-105TYR-1')] =   -0.686  
BIND_SILVER['%s-%s' % (dbse, '098VAL-152ALA-1')] =   -0.698  
BIND_SILVER['%s-%s' % (dbse, '098VAL-286TRP-1')] =   -0.812  
BIND_SILVER['%s-%s' % (dbse, '098VAL-287LEU-1')] =   -0.339  
BIND_SILVER['%s-%s' % (dbse, '099ARG-102HIE-1')] =   -2.484  
BIND_SILVER['%s-%s' % (dbse, '099ARG-147VAL-1')] =   -1.776  
BIND_SILVER['%s-%s' % (dbse, '099ARG-149ASN-1')] =   -1.574  
BIND_SILVER['%s-%s' % (dbse, '099ARG-177ASP-1')] = -104.316  
BIND_SILVER['%s-%s' % (dbse, '099ARG-216GLU-1')] =  -87.749  
BIND_SILVER['%s-%s' % (dbse, '099GLN-108GLN-1')] =   -4.986  
BIND_SILVER['%s-%s' % (dbse, '099GLN-148HIE-1')] =   -3.419  
BIND_SILVER['%s-%s' % (dbse, '099ILE-103ALA-1')] =   -0.373  
BIND_SILVER['%s-%s' % (dbse, '099LYS-104THR-1')] =   -0.802  
BIND_SILVER['%s-%s' % (dbse, '099MET-107ASN-1')] =   -0.937  
BIND_SILVER['%s-%s' % (dbse, '099MET-126VAL-1')] =    0.182  
BIND_SILVER['%s-%s' % (dbse, '099PRO-104TRP-1')] =   -1.847  
BIND_SILVER['%s-%s' % (dbse, '099PRO-164PHE-1')] =   -1.099  
BIND_SILVER['%s-%s' % (dbse, '099PRO-166GLU-1')] =   -3.039  
BIND_SILVER['%s-%s' % (dbse, '099TRP-118PRO-1')] =   -1.272  
BIND_SILVER['%s-%s' % (dbse, '099TRP-272GLU-1')] =  -24.561  
BIND_SILVER['%s-%s' % (dbse, '100ALA-112PHE-1')] =   -1.582  
BIND_SILVER['%s-%s' % (dbse, '100ASN-113LYS-1')] =   -0.952  
BIND_SILVER['%s-%s' % (dbse, '100ILE-103HIE-1')] =   -0.799  
BIND_SILVER['%s-%s' % (dbse, '100ILE-104LYS-1')] =   -1.894  
BIND_SILVER['%s-%s' % (dbse, '100LEU-130VAL-1')] =   -0.647  
BIND_SILVER['%s-%s' % (dbse, '100LEU-134ALA-1')] =   -0.325  
BIND_SILVER['%s-%s' % (dbse, '100LEU-142LEU-1')] =   -0.375  
BIND_SILVER['%s-%s' % (dbse, '100SER-119GLU-1')] =  -20.697  
BIND_SILVER['%s-%s' % (dbse, '100SER-131VAL-2')] =   -1.050  
BIND_SILVER['%s-%s' % (dbse, '100SER-148ASN-1')] =    2.093  
BIND_SILVER['%s-%s' % (dbse, '100THR-104LEU-1')] =   -0.566  
BIND_SILVER['%s-%s' % (dbse, '100TRP-103LYS-1')] =  -11.552  
BIND_SILVER['%s-%s' % (dbse, '100TRP-103LYS-2')] =   -1.330  
BIND_SILVER['%s-%s' % (dbse, '100VAL-283ILE-1')] =   -0.588  
BIND_SILVER['%s-%s' % (dbse, '101ALA-104ARG-1')] =   -0.125  
BIND_SILVER['%s-%s' % (dbse, '101ALA-128ALA-1')] =   -0.660  
BIND_SILVER['%s-%s' % (dbse, '101ALA-138TYR-1')] =   -1.474  
BIND_SILVER['%s-%s' % (dbse, '101ARG-142LEU-1')] =   -2.039  
BIND_SILVER['%s-%s' % (dbse, '101ASN-125HIE-1')] =   -3.342  
BIND_SILVER['%s-%s' % (dbse, '101ASP-145THR-2')] =  -18.890  
BIND_SILVER['%s-%s' % (dbse, '101ILE-110LEU-1')] =   -0.880  
BIND_SILVER['%s-%s' % (dbse, '101ILE-110PHE-1')] =   -1.536  
BIND_SILVER['%s-%s' % (dbse, '101ILE-123ILE-1')] =   -0.688  
BIND_SILVER['%s-%s' % (dbse, '101LEU-111TRP-1')] =   -1.266  
BIND_SILVER['%s-%s' % (dbse, '101LEU-125TYR-1')] =   -0.742  
BIND_SILVER['%s-%s' % (dbse, '101LEU-132ILE-1')] =   -0.540  
BIND_SILVER['%s-%s' % (dbse, '101TRP-132VAL-1')] =   -0.933  
BIND_SILVER['%s-%s' % (dbse, '101TRP-135LYS-1')] =   -2.701  
BIND_SILVER['%s-%s' % (dbse, '101TRP-177ILE-1')] =   -0.911  
BIND_SILVER['%s-%s' % (dbse, '101TYR-151VAL-1')] =   -1.436  
BIND_SILVER['%s-%s' % (dbse, '101VAL-106LYS-1')] =   -0.886  
BIND_SILVER['%s-%s' % (dbse, '101VAL-132PHE-1')] =   -1.378  
BIND_SILVER['%s-%s' % (dbse, '101VAL-132PHE-2')] =   -1.300  
BIND_SILVER['%s-%s' % (dbse, '102ALA-114PHE-1')] =   -0.126  
BIND_SILVER['%s-%s' % (dbse, '102ASP-106SER-1')] =   -2.630  
BIND_SILVER['%s-%s' % (dbse, '102HIE-109TYR-1')] =   -3.840  
BIND_SILVER['%s-%s' % (dbse, '102HIE-127GLU-1')] =   -0.754  
BIND_SILVER['%s-%s' % (dbse, '102HIE-269HIE-1')] =   -4.987  
BIND_SILVER['%s-%s' % (dbse, '102HIE-270TYR-1')] =   -2.036  
BIND_SILVER['%s-%s' % (dbse, '102HIE-272GLN-1')] =   -5.600  
BIND_SILVER['%s-%s' % (dbse, '102ILE-110ILE-1')] =   -0.507  
BIND_SILVER['%s-%s' % (dbse, '102ILE-145ILE-1')] =   -0.545  
BIND_SILVER['%s-%s' % (dbse, '102ILE-149TYR-1')] =   -1.200  
BIND_SILVER['%s-%s' % (dbse, '102ILE-149TYR-2')] =   -2.151  
BIND_SILVER['%s-%s' % (dbse, '102ILE-153PHE-1')] =   -0.752  
BIND_SILVER['%s-%s' % (dbse, '102SER-165LYS-1')] =   -8.233  
BIND_SILVER['%s-%s' % (dbse, '102SER-169ASP-1')] =  -18.176  
BIND_SILVER['%s-%s' % (dbse, '102VAL-133PHE-1')] =   -0.890  
BIND_SILVER['%s-%s' % (dbse, '103ASP-149TYR-1')] =  -22.415  
BIND_SILVER['%s-%s' % (dbse, '103ASP-269HIE-1')] =  -11.250  
BIND_SILVER['%s-%s' % (dbse, '103GLN-108PHE-1')] =   -3.783  
BIND_SILVER['%s-%s' % (dbse, '103GLU-106LYS-1')] = -113.110  
BIND_SILVER['%s-%s' % (dbse, '103GLU-108TRP-1')] =  -20.778  
BIND_SILVER['%s-%s' % (dbse, '103GLU-177ASP-1')] =   81.284  
BIND_SILVER['%s-%s' % (dbse, '103HIE-168TYR-1')] =  -11.390  
BIND_SILVER['%s-%s' % (dbse, '103ILE-110VAL-1')] =   -0.546  
BIND_SILVER['%s-%s' % (dbse, '103ILE-130VAL-1')] =   -0.598  
BIND_SILVER['%s-%s' % (dbse, '103ILE-132PHE-1')] =   -0.761  
BIND_SILVER['%s-%s' % (dbse, '103PHE-122MET-1')] =   -1.510  
BIND_SILVER['%s-%s' % (dbse, '103PHE-127LEU-1')] =   -0.863  
BIND_SILVER['%s-%s' % (dbse, '104ALA-125TYR-1')] =   -0.333  
BIND_SILVER['%s-%s' % (dbse, '104MET-112ASN-1')] =   -1.005  
BIND_SILVER['%s-%s' % (dbse, '104MET-133PHE-1')] =   -1.494  
BIND_SILVER['%s-%s' % (dbse, '104TRP-107ALA-1')] =   -0.716  
BIND_SILVER['%s-%s' % (dbse, '104TRP-129ILE-1')] =   -2.306  
BIND_SILVER['%s-%s' % (dbse, '104TRP-147LEU-1')] =   -0.435  
BIND_SILVER['%s-%s' % (dbse, '104TRP-166GLU-1')] =  -22.177  
BIND_SILVER['%s-%s' % (dbse, '104TRP-168LEU-1')] =   -1.653  
BIND_SILVER['%s-%s' % (dbse, '104TRP-169PRO-1')] =   -1.181  
BIND_SILVER['%s-%s' % (dbse, '104TRP-202PHE-1')] =   -4.219  
BIND_SILVER['%s-%s' % (dbse, '104TRP-205GLU-1')] =   -1.135  
BIND_SILVER['%s-%s' % (dbse, '104VAL-108ILE-1')] =   -0.626  
BIND_SILVER['%s-%s' % (dbse, '104VAL-112SER-1')] =   -0.547  
BIND_SILVER['%s-%s' % (dbse, '104VAL-126ILE-1')] =   -0.715  
BIND_SILVER['%s-%s' % (dbse, '105ALA-115GLN-1')] =   -0.505  
BIND_SILVER['%s-%s' % (dbse, '105ASN-139VAL-1')] =   -1.104  
BIND_SILVER['%s-%s' % (dbse, '105ASN-146GLN-1')] =    0.880  
BIND_SILVER['%s-%s' % (dbse, '105ASN-154ASN-1')] =    4.832  
BIND_SILVER['%s-%s' % (dbse, '105ILE-128LEU-1')] =   -0.205  
BIND_SILVER['%s-%s' % (dbse, '105ILE-131ALA-1')] =   -0.495  
BIND_SILVER['%s-%s' % (dbse, '105ILE-135LEU-1')] =   -0.622  
BIND_SILVER['%s-%s' % (dbse, '105LEU-114TRP-1')] =   -1.999  
BIND_SILVER['%s-%s' % (dbse, '105LEU-168ILE-1')] =   -1.001  
BIND_SILVER['%s-%s' % (dbse, '105LEU-175PHE-1')] =   -0.556  
BIND_SILVER['%s-%s' % (dbse, '105PHE-127LEU-1')] =   -0.942  
BIND_SILVER['%s-%s' % (dbse, '105PHE-130ARG-1')] =   -4.943  
BIND_SILVER['%s-%s' % (dbse, '105PHE-130ARG-2')] =   -1.676  
BIND_SILVER['%s-%s' % (dbse, '105PRO-128ILE-1')] =    0.192  
BIND_SILVER['%s-%s' % (dbse, '105PRO-181TRP-1')] =   -8.401  
BIND_SILVER['%s-%s' % (dbse, '105TYR-149HIE-1')] =   -3.547  
BIND_SILVER['%s-%s' % (dbse, '106ASN-130HIE-1')] =    1.378  
BIND_SILVER['%s-%s' % (dbse, '106ASP-133GLN-1')] =    4.847  
BIND_SILVER['%s-%s' % (dbse, '106GLU-129LYS-1')] = -113.380  
BIND_SILVER['%s-%s' % (dbse, '106ILE-168ILE-1')] =   -0.335  
BIND_SILVER['%s-%s' % (dbse, '106LEU-126LEU-1')] =   -0.289  
BIND_SILVER['%s-%s' % (dbse, '106LEU-149PHE-1')] =   -1.560  
BIND_SILVER['%s-%s' % (dbse, '106LEU-149PHE-2')] =   -2.015  
BIND_SILVER['%s-%s' % (dbse, '106PHE-109PHE-1')] =   -2.271  
BIND_SILVER['%s-%s' % (dbse, '106PHE-178LYS-1')] =   -2.479  
BIND_SILVER['%s-%s' % (dbse, '106SER-128PHE-1')] =    0.384  
BIND_SILVER['%s-%s' % (dbse, '106TYR-112SER-1')] =   -1.060  
BIND_SILVER['%s-%s' % (dbse, '106VAL-112LEU-1')] =   -0.617  
BIND_SILVER['%s-%s' % (dbse, '107ASP-125ASN-1')] =  -24.238  
BIND_SILVER['%s-%s' % (dbse, '107ILE-153TRP-1')] =   -0.927  
BIND_SILVER['%s-%s' % (dbse, '107ILE-158MET-1')] =   -1.025  
BIND_SILVER['%s-%s' % (dbse, '107THR-125ALA-1')] =   -0.614  
BIND_SILVER['%s-%s' % (dbse, '107THR-129LYS-1')] =  -18.209  
BIND_SILVER['%s-%s' % (dbse, '107VAL-147PHE-1')] =   -0.964  
BIND_SILVER['%s-%s' % (dbse, '107VAL-147PHE-2')] =   -0.905  
BIND_SILVER['%s-%s' % (dbse, '108ILE-122VAL-1')] =   -0.616  
BIND_SILVER['%s-%s' % (dbse, '108ILE-146GLN-1')] =   -0.383  
BIND_SILVER['%s-%s' % (dbse, '108LYS-131ALA-1')] =   -0.383  
BIND_SILVER['%s-%s' % (dbse, '108LYS-160LEU-1')] =   -0.205  
BIND_SILVER['%s-%s' % (dbse, '108PHE-125TRP-1')] =   -1.847  
BIND_SILVER['%s-%s' % (dbse, '108PHE-127PHE-1')] =   -1.718  
BIND_SILVER['%s-%s' % (dbse, '108PHE-150VAL-1')] =   -0.933  
BIND_SILVER['%s-%s' % (dbse, '108TRP-151ASN-1')] =   -1.945  
BIND_SILVER['%s-%s' % (dbse, '108TRP-155VAL-1')] =   -1.717  
BIND_SILVER['%s-%s' % (dbse, '109ARG-115GLU-1')] = -113.445  
BIND_SILVER['%s-%s' % (dbse, '109GLN-161GLU-1')] =   -1.493  
BIND_SILVER['%s-%s' % (dbse, '109GLN-161GLU-2')] =  -13.349  
BIND_SILVER['%s-%s' % (dbse, '109PHE-113ILE-1')] =   -2.084  
BIND_SILVER['%s-%s' % (dbse, '109PHE-181ILE-1')] =   -0.926  
BIND_SILVER['%s-%s' % (dbse, '109PHE-182VAL-1')] =   -1.284  
BIND_SILVER['%s-%s' % (dbse, '109PHE-185VAL-1')] =   -1.155  
BIND_SILVER['%s-%s' % (dbse, '109PHE-228TYR-1')] =   -2.724  
BIND_SILVER['%s-%s' % (dbse, '109SER-137ASN-1')] =    1.505  
BIND_SILVER['%s-%s' % (dbse, '109THR-131VAL-1')] =   -1.132  
BIND_SILVER['%s-%s' % (dbse, '109THR-158MET-1')] =   -0.745  
BIND_SILVER['%s-%s' % (dbse, '109VAL-164ILE-1')] =   -0.360  
BIND_SILVER['%s-%s' % (dbse, '110ALA-161PRO-1')] =   -1.749  
BIND_SILVER['%s-%s' % (dbse, '110ALA-164ILE-1')] =   -0.498  
BIND_SILVER['%s-%s' % (dbse, '110GLU-129LYS-1')] = -114.616  
BIND_SILVER['%s-%s' % (dbse, '110ILE-116PHE-1')] =   -1.067  
BIND_SILVER['%s-%s' % (dbse, '110ILE-149ARG-1')] =   -1.108  
BIND_SILVER['%s-%s' % (dbse, '110ILE-151VAL-1')] =   -1.008  
BIND_SILVER['%s-%s' % (dbse, '110ILE-162VAL-1')] =   -0.870  
BIND_SILVER['%s-%s' % (dbse, '110LEU-125VAL-1')] =   -0.378  
BIND_SILVER['%s-%s' % (dbse, '110LEU-127ILE-1')] =   -0.349  
BIND_SILVER['%s-%s' % (dbse, '110PHE-123ILE-1')] =   -0.266  
BIND_SILVER['%s-%s' % (dbse, '110PHE-128PHE-1')] =   -1.669  
BIND_SILVER['%s-%s' % (dbse, '110PHE-222TYR-1')] =   -3.398  
BIND_SILVER['%s-%s' % (dbse, '110PHE-226LEU-1')] =   -1.122  
BIND_SILVER['%s-%s' % (dbse, '110PHE-226LEU-2')] =   -1.218  
BIND_SILVER['%s-%s' % (dbse, '110THR-127GLN-2')] =   -6.014  
BIND_SILVER['%s-%s' % (dbse, '110THR-129TRP-1')] =   -5.588  
BIND_SILVER['%s-%s' % (dbse, '111ASP-156SER-2')] =    8.266  
BIND_SILVER['%s-%s' % (dbse, '111ASP-193HIE-1')] =  -10.384  
BIND_SILVER['%s-%s' % (dbse, '111HIE-218LEU-1')] =   -2.430  
BIND_SILVER['%s-%s' % (dbse, '111LEU-116ASN-1')] =   -0.866  
BIND_SILVER['%s-%s' % (dbse, '111LEU-130TYR-1')] =   -1.290  
BIND_SILVER['%s-%s' % (dbse, '111LEU-158LEU-1')] =   -0.451  
BIND_SILVER['%s-%s' % (dbse, '111LEU-169LEU-1')] =   -0.446  
BIND_SILVER['%s-%s' % (dbse, '111TRP-115GLN-1')] =   -4.366  
BIND_SILVER['%s-%s' % (dbse, '111VAL-125ALA-1')] =   -0.493  
BIND_SILVER['%s-%s' % (dbse, '112ALA-128PRO-1')] =   -0.822  
BIND_SILVER['%s-%s' % (dbse, '112ALA-131VAL-1')] =   -0.829  
BIND_SILVER['%s-%s' % (dbse, '112ARG-115ALA-1')] =   -1.840  
BIND_SILVER['%s-%s' % (dbse, '112ARG-125PHE-1')] =   -2.067  
BIND_SILVER['%s-%s' % (dbse, '112ARG-127GLN-1')] =   -1.636  
BIND_SILVER['%s-%s' % (dbse, '112ASP-183GLU-1')] =   83.891  
BIND_SILVER['%s-%s' % (dbse, '112ILE-125VAL-1')] =   -0.142  
BIND_SILVER['%s-%s' % (dbse, '112ILE-142ILE-1')] =   -0.961  
BIND_SILVER['%s-%s' % (dbse, '112LEU-142PHE-1')] =   -1.209  
BIND_SILVER['%s-%s' % (dbse, '112LYS-127LEU-1')] =   -0.930  
BIND_SILVER['%s-%s' % (dbse, '112PHE-121LEU-1')] =   -0.483  
BIND_SILVER['%s-%s' % (dbse, '112PHE-125HIE-1')] =   -1.432  
BIND_SILVER['%s-%s' % (dbse, '112TRP-119ARG-1')] =   -0.995  
BIND_SILVER['%s-%s' % (dbse, '112TRP-119ARG-2')] =   -3.138  
BIND_SILVER['%s-%s' % (dbse, '112TRP-120VAL-1')] =   -0.571  
BIND_SILVER['%s-%s' % (dbse, '112TYR-125GLU-1')] =   -2.231  
BIND_SILVER['%s-%s' % (dbse, '112TYR-128LEU-1')] =   -0.938  
BIND_SILVER['%s-%s' % (dbse, '112TYR-190ARG-1')] =   -8.431  
BIND_SILVER['%s-%s' % (dbse, '113ALA-118ASP-1')] =   -3.051  
BIND_SILVER['%s-%s' % (dbse, '113ALA-120VAL-1')] =   -0.598  
BIND_SILVER['%s-%s' % (dbse, '113ALA-122VAL-1')] =   -0.309  
BIND_SILVER['%s-%s' % (dbse, '113ALA-225TRP-1')] =   -1.014  
BIND_SILVER['%s-%s' % (dbse, '113ASP-195GLN-1')] =  -14.682  
BIND_SILVER['%s-%s' % (dbse, '113ILE-131VAL-1')] =   -0.497  
BIND_SILVER['%s-%s' % (dbse, '113ILE-164HIE-1')] =   -1.228  
BIND_SILVER['%s-%s' % (dbse, '113ILE-185VAL-1')] =   -0.098  
BIND_SILVER['%s-%s' % (dbse, '113ILE-190ARG-2')] =   -1.990  
BIND_SILVER['%s-%s' % (dbse, '113ILE-232ALA-1')] =   -0.960  
BIND_SILVER['%s-%s' % (dbse, '113LYS-117GLU-2')] =   -3.809  
BIND_SILVER['%s-%s' % (dbse, '113LYS-170VAL-1')] =   -0.696  
BIND_SILVER['%s-%s' % (dbse, '113LYS-173GLU-1')] = -123.921  
BIND_SILVER['%s-%s' % (dbse, '113SER-120ILE-1')] =   -0.409  
BIND_SILVER['%s-%s' % (dbse, '113TRP-119PHE-1')] =   -2.081  
BIND_SILVER['%s-%s' % (dbse, '113TRP-124HIE-1')] =   -3.927  
BIND_SILVER['%s-%s' % (dbse, '113TRP-126ALA-1')] =   -0.934  
BIND_SILVER['%s-%s' % (dbse, '113TRP-171ASP-1')] =  -22.571  
BIND_SILVER['%s-%s' % (dbse, '113TRP-178ILE-1')] =   -2.273  
BIND_SILVER['%s-%s' % (dbse, '113TYR-124THR-1')] =   -1.138  
BIND_SILVER['%s-%s' % (dbse, '113VAL-120HIE-2')] =   -1.993  
BIND_SILVER['%s-%s' % (dbse, '113VAL-143PHE-1')] =   -0.855  
BIND_SILVER['%s-%s' % (dbse, '114ALA-160ALA-1')] =   -0.487  
BIND_SILVER['%s-%s' % (dbse, '114ASN-122ARG-2')] =   -0.804  
BIND_SILVER['%s-%s' % (dbse, '114ASP-179LEU-1')] =   -4.630  
BIND_SILVER['%s-%s' % (dbse, '114GLU-144ASN-1')] =   -8.064  
BIND_SILVER['%s-%s' % (dbse, '114GLU-146ARG-1')] = -120.540  
BIND_SILVER['%s-%s' % (dbse, '114LEU-118ILE-1')] =   -0.477  
BIND_SILVER['%s-%s' % (dbse, '114LYS-225TRP-1')] =   -2.035  
BIND_SILVER['%s-%s' % (dbse, '114VAL-167GLU-1')] =   -3.089  
BIND_SILVER['%s-%s' % (dbse, '115ASN-124LEU-1')] =   -1.084  
BIND_SILVER['%s-%s' % (dbse, '115ASP-156ASP-1')] =   83.331  
BIND_SILVER['%s-%s' % (dbse, '115GLN-118ARG-1')] =   -2.660  
BIND_SILVER['%s-%s' % (dbse, '115GLU-123PRO-1')] =   -1.075  
BIND_SILVER['%s-%s' % (dbse, '115GLU-123PRO-2')] =   -4.111  
BIND_SILVER['%s-%s' % (dbse, '115GLU-160GLU-1')] =   62.241  
BIND_SILVER['%s-%s' % (dbse, '115GLU-163TYR-2')] =   -4.306  
BIND_SILVER['%s-%s' % (dbse, '115MET-168TYR-1')] =   -0.770  
BIND_SILVER['%s-%s' % (dbse, '115PRO-129TYR-1')] =   -2.606  
BIND_SILVER['%s-%s' % (dbse, '115THR-138VAL-1')] =   -0.436  
BIND_SILVER['%s-%s' % (dbse, '115THR-142GLU-1')] =  -19.975  
BIND_SILVER['%s-%s' % (dbse, '115THR-142GLU-2')] =  -17.939  
BIND_SILVER['%s-%s' % (dbse, '115VAL-122MET-1')] =   -0.642  
BIND_SILVER['%s-%s' % (dbse, '115VAL-123PHE-1')] =   -0.762  
BIND_SILVER['%s-%s' % (dbse, '115VAL-130ARG-1')] =   -2.529  
BIND_SILVER['%s-%s' % (dbse, '116ALA-162PHE-1')] =   -1.148  
BIND_SILVER['%s-%s' % (dbse, '116LYS-144SER-1')] =   -8.866  
BIND_SILVER['%s-%s' % (dbse, '116PHE-130VAL-1')] =   -0.402  
BIND_SILVER['%s-%s' % (dbse, '116PHE-165VAL-1')] =   -0.921  
BIND_SILVER['%s-%s' % (dbse, '117HIE-123PRO-1')] =   -1.424  
BIND_SILVER['%s-%s' % (dbse, '117ILE-142PHE-1')] =   -1.133  
BIND_SILVER['%s-%s' % (dbse, '117PHE-125TYR-1')] =   -2.113  
BIND_SILVER['%s-%s' % (dbse, '117PHE-130HIE-1')] =   -1.456  
BIND_SILVER['%s-%s' % (dbse, '117PRO-126ALA-1')] =   -0.819  
BIND_SILVER['%s-%s' % (dbse, '117PRO-129TYR-1')] =    0.851  
BIND_SILVER['%s-%s' % (dbse, '117PRO-130LYS-1')] =   -0.476  
BIND_SILVER['%s-%s' % (dbse, '117VAL-166ILE-1')] =   -0.643  
BIND_SILVER['%s-%s' % (dbse, '118ALA-160VAL-1')] =   -0.222  
BIND_SILVER['%s-%s' % (dbse, '118ARG-157ASN-1')] =    8.896  
BIND_SILVER['%s-%s' % (dbse, '118ARG-185ARG-1')] =   62.302  
BIND_SILVER['%s-%s' % (dbse, '118ASP-136HIE-1')] =  -26.173  
BIND_SILVER['%s-%s' % (dbse, '118GLN-121PHE-1')] =   -1.281  
BIND_SILVER['%s-%s' % (dbse, '118GLU-173PHE-1')] =   -4.642  
BIND_SILVER['%s-%s' % (dbse, '118GLU-176THR-1')] =   -0.700  
BIND_SILVER['%s-%s' % (dbse, '118ILE-136VAL-1')] =   -0.465  
BIND_SILVER['%s-%s' % (dbse, '118ILE-165ALA-1')] =   -0.349  
BIND_SILVER['%s-%s' % (dbse, '118ILE-166TYR-1')] =   -1.189  
BIND_SILVER['%s-%s' % (dbse, '118ILE-178TYR-1')] =   -1.089  
BIND_SILVER['%s-%s' % (dbse, '118THR-121LEU-1')] =   -1.037  
BIND_SILVER['%s-%s' % (dbse, '118VAL-162PHE-1')] =   -0.548  
BIND_SILVER['%s-%s' % (dbse, '119ALA-160LEU-1')] =   -0.532  
BIND_SILVER['%s-%s' % (dbse, '119CYS-168HIE-1')] =   -3.510  
BIND_SILVER['%s-%s' % (dbse, '119LEU-137ALA-1')] =    0.008  
BIND_SILVER['%s-%s' % (dbse, '119LEU-137ALA-2')] =   -0.340  
BIND_SILVER['%s-%s' % (dbse, '119LYS-186VAL-1')] =   -0.667  
BIND_SILVER['%s-%s' % (dbse, '119MET-144SER-1')] =   -1.004  
BIND_SILVER['%s-%s' % (dbse, '119PHE-124HIE-1')] =   -2.717  
BIND_SILVER['%s-%s' % (dbse, '119PHE-176THR-1')] =   -1.049  
BIND_SILVER['%s-%s' % (dbse, '119SER-123ARG-1')] =   -2.890  
BIND_SILVER['%s-%s' % (dbse, '119SER-140TYR-1')] =   -0.619  
BIND_SILVER['%s-%s' % (dbse, '119THR-123THR-1')] =   -0.898  
BIND_SILVER['%s-%s' % (dbse, '119THR-123THR-2')] =   -0.397  
BIND_SILVER['%s-%s' % (dbse, '119TYR-174ILE-1')] =   -1.010  
BIND_SILVER['%s-%s' % (dbse, '120HIE-185ARG-1')] =   -0.891  
BIND_SILVER['%s-%s' % (dbse, '120ILE-123TYR-1')] =   -1.522  
BIND_SILVER['%s-%s' % (dbse, '120LEU-123ASN-1')] =   -0.505  
BIND_SILVER['%s-%s' % (dbse, '120LEU-124ASP-1')] =   -2.928  
BIND_SILVER['%s-%s' % (dbse, '120LEU-124LEU-1')] =   -1.199  
BIND_SILVER['%s-%s' % (dbse, '120LEU-135ILE-1')] =   -0.708  
BIND_SILVER['%s-%s' % (dbse, '120LEU-171TYR-1')] =   -1.419  
BIND_SILVER['%s-%s' % (dbse, '120LEU-171TYR-2')] =   -1.706  
BIND_SILVER['%s-%s' % (dbse, '120LYS-138VAL-1')] =   -0.730  
BIND_SILVER['%s-%s' % (dbse, '120LYS-142ASP-1')] =  -99.092  
BIND_SILVER['%s-%s' % (dbse, '120PRO-126ALA-1')] =   -0.481  
BIND_SILVER['%s-%s' % (dbse, '120SER-136HIE-1')] =   -1.245  
BIND_SILVER['%s-%s' % (dbse, '120THR-143VAL-1')] =   -0.293  
BIND_SILVER['%s-%s' % (dbse, '120THR-147GLU-1')] =  -20.153  
BIND_SILVER['%s-%s' % (dbse, '120TYR-141PHE-1')] =   -1.295  
BIND_SILVER['%s-%s' % (dbse, '120VAL-123ILE-1')] =   -0.788  
BIND_SILVER['%s-%s' % (dbse, '120VAL-154ILE-1')] =   -0.749  
BIND_SILVER['%s-%s' % (dbse, '120VAL-275LEU-1')] =   -0.427  
BIND_SILVER['%s-%s' % (dbse, '121ASN-132THR-1')] =   -1.144  
BIND_SILVER['%s-%s' % (dbse, '121GLN-144ARG-1')] =  -22.412  
BIND_SILVER['%s-%s' % (dbse, '121LEU-125HIE-1')] =   -0.725  
BIND_SILVER['%s-%s' % (dbse, '121LEU-125HIE-2')] =   -0.735  
BIND_SILVER['%s-%s' % (dbse, '121PHE-126VAL-1')] =   -1.203  
BIND_SILVER['%s-%s' % (dbse, '121PHE-191LEU-1')] =   -0.747  
BIND_SILVER['%s-%s' % (dbse, '121PHE-219TRP-1')] =   -1.693  
BIND_SILVER['%s-%s' % (dbse, '121TYR-125LEU-2')] =   -2.063  
BIND_SILVER['%s-%s' % (dbse, '121VAL-157ASP-1')] =   -0.888  
BIND_SILVER['%s-%s' % (dbse, '122ASP-125LYS-1')] =   -3.949  
BIND_SILVER['%s-%s' % (dbse, '122LEU-188VAL-1')] =   -0.478  
BIND_SILVER['%s-%s' % (dbse, '122MET-126GLU-1')] =   -8.137  
BIND_SILVER['%s-%s' % (dbse, '122VAL-125ILE-1')] =   -1.344  
BIND_SILVER['%s-%s' % (dbse, '122VAL-143VAL-1')] =   -0.625  
BIND_SILVER['%s-%s' % (dbse, '122VAL-152PHE-1')] =   -1.644  
BIND_SILVER['%s-%s' % (dbse, '123ALA-128VAL-1')] =   -0.445  
BIND_SILVER['%s-%s' % (dbse, '123ALA-158ILE-1')] =    1.800  
BIND_SILVER['%s-%s' % (dbse, '123ARG-127GLN-1')] =   -2.904  
BIND_SILVER['%s-%s' % (dbse, '123MET-140ASN-1')] =   -0.879  # altered
BIND_SILVER['%s-%s' % (dbse, '123SER-182ASN-1')] =   -0.636  
BIND_SILVER['%s-%s' % (dbse, '123THR-136SER-1')] =   -4.149  
BIND_SILVER['%s-%s' % (dbse, '123TYR-154VAL-1')] =   -0.972  
BIND_SILVER['%s-%s' % (dbse, '123VAL-134LEU-1')] =   -0.362  
BIND_SILVER['%s-%s' % (dbse, '124ALA-156THR-1')] =   -0.418  
BIND_SILVER['%s-%s' % (dbse, '124ASP-131THR-1')] =    3.992  
BIND_SILVER['%s-%s' % (dbse, '124ASP-132THR-1')] =  -20.298  
BIND_SILVER['%s-%s' % (dbse, '124ASP-134ARG-1')] = -112.654  
BIND_SILVER['%s-%s' % (dbse, '124GLN-200ALA-1')] =   -0.893  
BIND_SILVER['%s-%s' % (dbse, '124HIE-140GLU-1')] =  -24.984  
BIND_SILVER['%s-%s' % (dbse, '124HIE-143VAL-1')] =   -0.530  
BIND_SILVER['%s-%s' % (dbse, '124LEU-136HIE-2')] =   -1.426  
BIND_SILVER['%s-%s' % (dbse, '124LEU-181VAL-1')] =   -0.357  
BIND_SILVER['%s-%s' % (dbse, '125GLU-192PHE-1')] =   -5.385  
BIND_SILVER['%s-%s' % (dbse, '125ILE-136TYR-1')] =   -0.746  
BIND_SILVER['%s-%s' % (dbse, '125LEU-129LEU-1')] =   -1.235  
BIND_SILVER['%s-%s' % (dbse, '125PHE-143VAL-1')] =   -1.209  
BIND_SILVER['%s-%s' % (dbse, '125TRP-138SER-1')] =   -4.326  
BIND_SILVER['%s-%s' % (dbse, '125TRP-150VAL-1')] =   -1.163  
BIND_SILVER['%s-%s' % (dbse, '125TRP-152LEU-1')] =   -1.966  
BIND_SILVER['%s-%s' % (dbse, '125TYR-164HIE-1')] =   -3.005  
BIND_SILVER['%s-%s' % (dbse, '126ALA-140GLU-1')] =   -0.830  
BIND_SILVER['%s-%s' % (dbse, '126ASN-129ASN-1')] =   -1.980  
BIND_SILVER['%s-%s' % (dbse, '126GLU-130ARG-1')] = -104.939  
BIND_SILVER['%s-%s' % (dbse, '126ILE-136PRO-1')] =   -0.754  
BIND_SILVER['%s-%s' % (dbse, '126ILE-139PHE-1')] =   -1.228  
BIND_SILVER['%s-%s' % (dbse, '126ILE-139PHE-2')] =   -2.631  
BIND_SILVER['%s-%s' % (dbse, '126LEU-130HIE-2')] =   -1.095  
BIND_SILVER['%s-%s' % (dbse, '126LEU-162PHE-1')] =   -0.885  
BIND_SILVER['%s-%s' % (dbse, '126LYS-158ILE-1')] =   -0.608  
BIND_SILVER['%s-%s' % (dbse, '126PHE-132HIE-1')] =   -1.551  
BIND_SILVER['%s-%s' % (dbse, '126PHE-171TYR-1')] =   -2.616  
BIND_SILVER['%s-%s' % (dbse, '126PHE-176TYR-1')] =   -2.818  
BIND_SILVER['%s-%s' % (dbse, '126SER-171ILE-1')] =   -0.661  
BIND_SILVER['%s-%s' % (dbse, '126THR-197TYR-1')] =   -1.278  
BIND_SILVER['%s-%s' % (dbse, '127ALA-177ASP-1')] =   -2.341  
BIND_SILVER['%s-%s' % (dbse, '127GLU-146ARG-2')] =  -97.482  
BIND_SILVER['%s-%s' % (dbse, '127GLU-269HIE-1')] =   -1.175  
BIND_SILVER['%s-%s' % (dbse, '127GLU-269HIE-2')] =   12.739  
BIND_SILVER['%s-%s' % (dbse, '127LEU-210VAL-1')] =   -0.396  
BIND_SILVER['%s-%s' % (dbse, '127MET-131LYS-1')] =   -0.379  
BIND_SILVER['%s-%s' % (dbse, '127PHE-132ILE-1')] =   -1.270  
BIND_SILVER['%s-%s' % (dbse, '127PHE-133SER-1')] =   -0.964  
BIND_SILVER['%s-%s' % (dbse, '127PHE-138SER-1')] =   -1.642  
BIND_SILVER['%s-%s' % (dbse, '127PHE-140HIE-1')] =   -3.649  
BIND_SILVER['%s-%s' % (dbse, '127PHE-158VAL-1')] =   -0.884  
BIND_SILVER['%s-%s' % (dbse, '127PHE-183TYR-1')] =   -2.339  
BIND_SILVER['%s-%s' % (dbse, '127PHE-206ILE-1')] =   -1.104  
BIND_SILVER['%s-%s' % (dbse, '127PHE-237ASN-1')] =   -1.018  
BIND_SILVER['%s-%s' % (dbse, '127PHE-239PHE-1')] =   -3.083  
BIND_SILVER['%s-%s' % (dbse, '128ILE-131LEU-1')] =   -0.550  
BIND_SILVER['%s-%s' % (dbse, '128LYS-183TYR-1')] =   -2.469  
BIND_SILVER['%s-%s' % (dbse, '128PHE-235LEU-1')] =   -0.676  
BIND_SILVER['%s-%s' % (dbse, '128PHE-252LEU-1')] =   -0.584  
BIND_SILVER['%s-%s' % (dbse, '128PRO-275LEU-1')] =   -1.020  
BIND_SILVER['%s-%s' % (dbse, '128TYR-158MET-1')] =   -3.004  
BIND_SILVER['%s-%s' % (dbse, '128TYR-160LEU-1')] =   -1.180  
BIND_SILVER['%s-%s' % (dbse, '128VAL-160LEU-1')] =   -0.787  
BIND_SILVER['%s-%s' % (dbse, '129ASN-132TYR-1')] =   -3.682  
BIND_SILVER['%s-%s' % (dbse, '129ASP-140HIE-1')] =  -25.161  
BIND_SILVER['%s-%s' % (dbse, '129ASP-148TYR-1')] =   -2.046  
BIND_SILVER['%s-%s' % (dbse, '129LEU-155PHE-1')] =   -0.892  
BIND_SILVER['%s-%s' % (dbse, '129LEU-192PHE-1')] =   -1.425  
BIND_SILVER['%s-%s' % (dbse, '129LEU-195PRO-1')] =   -0.112  
BIND_SILVER['%s-%s' % (dbse, '129LEU-277TYR-1')] =   -1.879  
BIND_SILVER['%s-%s' % (dbse, '129LEU-277TYR-2')] =   -1.121  
BIND_SILVER['%s-%s' % (dbse, '129PHE-133VAL-1')] =   -0.898  
BIND_SILVER['%s-%s' % (dbse, '129PHE-156ARG-1')] =   -7.382  
BIND_SILVER['%s-%s' % (dbse, '129PHE-166PRO-1')] =   -2.017  
BIND_SILVER['%s-%s' % (dbse, '129TYR-133ARG-1')] =   -8.578  
BIND_SILVER['%s-%s' % (dbse, '129TYR-136TYR-2')] =   -3.435  
BIND_SILVER['%s-%s' % (dbse, '129VAL-159PHE-1')] =   -1.139  
BIND_SILVER['%s-%s' % (dbse, '129VAL-184PHE-1')] =   -1.727  
BIND_SILVER['%s-%s' % (dbse, '130ARG-170TYR-2')] =   -3.165  
BIND_SILVER['%s-%s' % (dbse, '130ARG-244ILE-1')] =   -2.024  
BIND_SILVER['%s-%s' % (dbse, '130ARG-248GLU-1')] =  -76.927  # altered
BIND_SILVER['%s-%s' % (dbse, '130GLN-134GLU-1')] =  -17.068  
BIND_SILVER['%s-%s' % (dbse, '130GLN-137ARG-1')] =    0.143  
BIND_SILVER['%s-%s' % (dbse, '130PRO-135ILE-1')] =   -0.982  
BIND_SILVER['%s-%s' % (dbse, '130PRO-139ILE-1')] =   -0.563  
BIND_SILVER['%s-%s' % (dbse, '130PRO-180PRO-1')] =   -0.987  
BIND_SILVER['%s-%s' % (dbse, '130SER-149HIE-1')] =   -8.682  
BIND_SILVER['%s-%s' % (dbse, '130SER-153TRP-1')] =   -5.708  
BIND_SILVER['%s-%s' % (dbse, '130VAL-139ILE-1')] =    0.236  
BIND_SILVER['%s-%s' % (dbse, '130VAL-162VAL-1')] =   -0.540  
BIND_SILVER['%s-%s' % (dbse, '130VAL-185PHE-1')] =   -0.985  
BIND_SILVER['%s-%s' % (dbse, '131ALA-140HIE-1')] =   -0.765  
BIND_SILVER['%s-%s' % (dbse, '131ARG-134GLU-2')] =  -79.683  
BIND_SILVER['%s-%s' % (dbse, '131ASP-147PHE-1')] =   -1.600  
BIND_SILVER['%s-%s' % (dbse, '131ASP-182PHE-1')] =   -3.570  
BIND_SILVER['%s-%s' % (dbse, '131LEU-136VAL-1')] =   -0.039  
BIND_SILVER['%s-%s' % (dbse, '131LEU-160MET-1')] =   -0.713  
BIND_SILVER['%s-%s' % (dbse, '131PRO-219VAL-1')] =   -0.570  
BIND_SILVER['%s-%s' % (dbse, '131PRO-220GLU-1')] =   -4.252  
BIND_SILVER['%s-%s' % (dbse, '131THR-149LEU-1')] =   -0.516  
BIND_SILVER['%s-%s' % (dbse, '132ARG-136ARG-1')] =   -2.643  
BIND_SILVER['%s-%s' % (dbse, '132ASP-156ARG-1')] = -102.813  
BIND_SILVER['%s-%s' % (dbse, '132HIE-135LYS-1')] =   -1.020  
BIND_SILVER['%s-%s' % (dbse, '132HIE-147ASP-1')] =  -25.984  
BIND_SILVER['%s-%s' % (dbse, '132HIE-149ASN-1')] =   -1.740  
BIND_SILVER['%s-%s' % (dbse, '132ILE-135PHE-1')] =   -0.858  
BIND_SILVER['%s-%s' % (dbse, '132ILE-138TRP-1')] =    0.004  
BIND_SILVER['%s-%s' % (dbse, '132ILE-146TRP-1')] =   -0.896  
BIND_SILVER['%s-%s' % (dbse, '132LEU-198PHE-1')] =   -0.927  
BIND_SILVER['%s-%s' % (dbse, '132PHE-162VAL-1')] =   -1.478  
BIND_SILVER['%s-%s' % (dbse, '132PHE-174SER-1')] =   -1.831  
BIND_SILVER['%s-%s' % (dbse, '132PHE-176VAL-1')] =   -1.283  
BIND_SILVER['%s-%s' % (dbse, '132PHE-183GLN-1')] =   -1.983  
BIND_SILVER['%s-%s' % (dbse, '132TYR-136PRO-1')] =   -1.860  
BIND_SILVER['%s-%s' % (dbse, '133LYS-136ASP-1')] = -103.095  
BIND_SILVER['%s-%s' % (dbse, '133LYS-198PHE-1')] =   -1.381  
BIND_SILVER['%s-%s' % (dbse, '133PRO-151ASP-1')] =   -5.200  
BIND_SILVER['%s-%s' % (dbse, '133SER-161GLU-1')] =  -18.068  
BIND_SILVER['%s-%s' % (dbse, '133TRP-143MET-2')] =   -2.519  
BIND_SILVER['%s-%s' % (dbse, '133TRP-148VAL-1')] =    0.566  
BIND_SILVER['%s-%s' % (dbse, '133TRP-277TYR-1')] =    0.983  
BIND_SILVER['%s-%s' % (dbse, '133VAL-137ARG-1')] =   -2.779  
BIND_SILVER['%s-%s' % (dbse, '133VAL-146TRP-1')] =   -2.037  
BIND_SILVER['%s-%s' % (dbse, '134GLU-138ARG-1')] = -104.648  
BIND_SILVER['%s-%s' % (dbse, '134ILE-147ASP-1')] =   -2.945  
BIND_SILVER['%s-%s' % (dbse, '134ILE-167LEU-1')] =   -0.352  
BIND_SILVER['%s-%s' % (dbse, '134LEU-205TYR-1')] =   -1.558  
BIND_SILVER['%s-%s' % (dbse, '135ARG-193VAL-1')] =   -2.056  
BIND_SILVER['%s-%s' % (dbse, '135ILE-180PRO-1')] =   -0.783  
BIND_SILVER['%s-%s' % (dbse, '135LEU-139LEU-1')] =   -1.104  
BIND_SILVER['%s-%s' % (dbse, '135LEU-163LEU-1')] =   -0.208  
BIND_SILVER['%s-%s' % (dbse, '135LEU-179LEU-1')] =   -0.285  
BIND_SILVER['%s-%s' % (dbse, '135LYS-157GLU-1')] = -105.455  
BIND_SILVER['%s-%s' % (dbse, '135LYS-177ILE-1')] =   -0.884  
BIND_SILVER['%s-%s' % (dbse, '135PHE-147TYR-1')] =   -3.158  
BIND_SILVER['%s-%s' % (dbse, '135PRO-140SER-1')] =   -0.787  
BIND_SILVER['%s-%s' % (dbse, '135PRO-144LEU-1')] =   -0.871  
BIND_SILVER['%s-%s' % (dbse, '135PRO-155PHE-1')] =   -1.549  
BIND_SILVER['%s-%s' % (dbse, '135TRP-147GLN-1')] =   -6.213  
BIND_SILVER['%s-%s' % (dbse, '135TRP-208ILE-1')] =   -1.106  
BIND_SILVER['%s-%s' % (dbse, '136ARG-142ALA-1')] =   -2.269  
BIND_SILVER['%s-%s' % (dbse, '136ASP-198PHE-1')] =   -7.217  
BIND_SILVER['%s-%s' % (dbse, '136ASP-201VAL-1')] =   -3.240  
BIND_SILVER['%s-%s' % (dbse, '136CYS-143PHE-1')] =   -2.133  
BIND_SILVER['%s-%s' % (dbse, '136PHE-141ALA-1')] =   -0.763  
BIND_SILVER['%s-%s' % (dbse, '136PHE-146TRP-1')] =   -2.176  
BIND_SILVER['%s-%s' % (dbse, '136SER-144ARG-1')] =  -14.505  
BIND_SILVER['%s-%s' % (dbse, '136TRP-155CYS-1')] =   -1.388  
BIND_SILVER['%s-%s' % (dbse, '136TRP-165ASP-1')] =  -23.009  
BIND_SILVER['%s-%s' % (dbse, '136TRP-179MET-1')] =   -1.442  
BIND_SILVER['%s-%s' % (dbse, '136VAL-169LEU-1')] =   -0.615  
BIND_SILVER['%s-%s' % (dbse, '137ARG-154TRP-1')] =   -2.633  
BIND_SILVER['%s-%s' % (dbse, '137ARG-154TRP-2')] =   -6.916  
BIND_SILVER['%s-%s' % (dbse, '137ARG-157GLU-1')] = -101.313  
BIND_SILVER['%s-%s' % (dbse, '137GLU-143MET-1')] =   -5.063  
BIND_SILVER['%s-%s' % (dbse, '137SER-156ARG-1')] =   -0.883  
BIND_SILVER['%s-%s' % (dbse, '137TYR-166SER-1')] =   -0.265  
BIND_SILVER['%s-%s' % (dbse, '138ARG-142GLU-1')] =  -92.723  
BIND_SILVER['%s-%s' % (dbse, '138ILE-156ARG-1')] =   -1.895  
BIND_SILVER['%s-%s' % (dbse, '138LEU-149PHE-1')] =   -1.151  
BIND_SILVER['%s-%s' % (dbse, '138PHE-153PHE-1')] =   -2.667  
BIND_SILVER['%s-%s' % (dbse, '138SER-169VAL-1')] =   -0.795  
BIND_SILVER['%s-%s' % (dbse, '138TRP-146PHE-1')] =   -4.359  
BIND_SILVER['%s-%s' % (dbse, '138TRP-243LEU-1')] =   -0.176  
BIND_SILVER['%s-%s' % (dbse, '138VAL-144ARG-1')] =   -1.647  
BIND_SILVER['%s-%s' % (dbse, '139ASN-154SER-1')] =   -5.229  
BIND_SILVER['%s-%s' % (dbse, '139GLU-144LYS-1')] = -116.396  
BIND_SILVER['%s-%s' % (dbse, '139ILE-143TRP-1')] =   -1.291  
BIND_SILVER['%s-%s' % (dbse, '139LEU-204TYR-1')] =   -1.301  
BIND_SILVER['%s-%s' % (dbse, '139PRO-180PRO-1')] =   -1.361  
BIND_SILVER['%s-%s' % (dbse, '139TYR-148SER-1')] =   -1.483  
BIND_SILVER['%s-%s' % (dbse, '140GLU-143VAL-1')] =   -3.897  
BIND_SILVER['%s-%s' % (dbse, '140GLU-155THR-1')] =  -17.019  
BIND_SILVER['%s-%s' % (dbse, '140GLU-156ARG-1')] = -119.251  
BIND_SILVER['%s-%s' % (dbse, '140LEU-168LEU-1')] =   -0.137  
BIND_SILVER['%s-%s' % (dbse, '141GLN-160PHE-1')] =   -0.852  
BIND_SILVER['%s-%s' % (dbse, '141LYS-144GLU-1')] = -111.208  
BIND_SILVER['%s-%s' % (dbse, '141MET-155ILE-1')] =   -0.511  
BIND_SILVER['%s-%s' % (dbse, '141PHE-152PHE-1')] =   -2.294  
BIND_SILVER['%s-%s' % (dbse, '141SER-144ASP-1')] =  -14.020  
BIND_SILVER['%s-%s' % (dbse, '141SER-154ILE-1')] =   -0.337  
BIND_SILVER['%s-%s' % (dbse, '142GLN-154GLN-1')] =   -5.600  
BIND_SILVER['%s-%s' % (dbse, '142ILE-155LEU-1')] =   -0.398  
BIND_SILVER['%s-%s' % (dbse, '142ILE-155LEU-2')] =   -0.657  
BIND_SILVER['%s-%s' % (dbse, '142ILE-185VAL-1')] =   -0.875  
BIND_SILVER['%s-%s' % (dbse, '142PHE-170ARG-1')] =   -0.851  
BIND_SILVER['%s-%s' % (dbse, '142TYR-147LYS-1')] =   -9.182  
BIND_SILVER['%s-%s' % (dbse, '142TYR-148TYR-1')] =   -3.979  
BIND_SILVER['%s-%s' % (dbse, '142TYR-150VAL-1')] =   -0.171  
BIND_SILVER['%s-%s' % (dbse, '142TYR-160PHE-1')] =   -4.037  
BIND_SILVER['%s-%s' % (dbse, '142TYR-170ILE-1')] =   -2.082  
BIND_SILVER['%s-%s' % (dbse, '142TYR-199THR-1')] =   -1.329  
BIND_SILVER['%s-%s' % (dbse, '142TYR-203VAL-1')] =   -0.842  
BIND_SILVER['%s-%s' % (dbse, '143ARG-187ASP-1')] = -116.177  
BIND_SILVER['%s-%s' % (dbse, '143ARG-188LYS-1')] =   62.414  
BIND_SILVER['%s-%s' % (dbse, '143GLN-147GLU-1')] =  -23.530  
BIND_SILVER['%s-%s' % (dbse, '143ILE-146VAL-1')] =   -0.426  
BIND_SILVER['%s-%s' % (dbse, '143LEU-160ARG-1')] =   -2.644  
BIND_SILVER['%s-%s' % (dbse, '143TRP-146LYS-1')] =   -5.173  
BIND_SILVER['%s-%s' % (dbse, '143TYR-150ILE-1')] =   -1.906  
BIND_SILVER['%s-%s' % (dbse, '143VAL-147LEU-1')] =   -0.618  
BIND_SILVER['%s-%s' % (dbse, '143VAL-152PHE-1')] =   -0.972  
BIND_SILVER['%s-%s' % (dbse, '144ARG-147GLU-2')] =  -92.535  
BIND_SILVER['%s-%s' % (dbse, '144ASP-150SER-1')] =  -15.457  
BIND_SILVER['%s-%s' % (dbse, '144ILE-155THR-1')] =   -0.850  
BIND_SILVER['%s-%s' % (dbse, '144LYS-161GLU-1')] = -122.221  
BIND_SILVER['%s-%s' % (dbse, '144PHE-153LYS-1')] =   -2.095  
BIND_SILVER['%s-%s' % (dbse, '144PHE-155ILE-1')] =   -0.673  
BIND_SILVER['%s-%s' % (dbse, '145GLN-149MET-2')] =    3.546  
BIND_SILVER['%s-%s' % (dbse, '145LEU-149PHE-1')] =   -0.919  
BIND_SILVER['%s-%s' % (dbse, '145THR-149PHE-1')] =   -0.612  
BIND_SILVER['%s-%s' % (dbse, '146ARG-207GLU-1')] = -118.843  
BIND_SILVER['%s-%s' % (dbse, '146GLU-158SER-1')] =    9.115  
BIND_SILVER['%s-%s' % (dbse, '146PHE-149PHE-1')] =   -2.783  
BIND_SILVER['%s-%s' % (dbse, '146PHE-150LEU-2')] =   -1.702  
BIND_SILVER['%s-%s' % (dbse, '146PHE-150VAL-1')] =   -1.451  
BIND_SILVER['%s-%s' % (dbse, '146PHE-164TRP-1')] =   -1.225  
BIND_SILVER['%s-%s' % (dbse, '146PHE-165PHE-1')] =   -1.167  
BIND_SILVER['%s-%s' % (dbse, '146PHE-199LYS-2')] =   -1.784  
BIND_SILVER['%s-%s' % (dbse, '146VAL-161VAL-1')] =   -0.582  
BIND_SILVER['%s-%s' % (dbse, '146VAL-161VAL-2')] =   -0.441  
BIND_SILVER['%s-%s' % (dbse, '146VAL-165HIE-1')] =   -1.488  
BIND_SILVER['%s-%s' % (dbse, '147ASP-171TYR-1')] =  -25.608  
BIND_SILVER['%s-%s' % (dbse, '147ASP-188LYS-1')] = -111.154  
BIND_SILVER['%s-%s' % (dbse, '147LYS-203VAL-1')] =   -0.573  
BIND_SILVER['%s-%s' % (dbse, '147PHE-159PHE-1')] =   -2.789  
BIND_SILVER['%s-%s' % (dbse, '147PHE-182PHE-1')] =   -1.956  
BIND_SILVER['%s-%s' % (dbse, '147VAL-175SER-1')] =   -0.794  
BIND_SILVER['%s-%s' % (dbse, '148ALA-158LEU-1')] =   -0.555  
BIND_SILVER['%s-%s' % (dbse, '148HIE-152GLU-1')] =   -3.856  
BIND_SILVER['%s-%s' % (dbse, '148ILE-202VAL-1')] =   -0.539  
BIND_SILVER['%s-%s' % (dbse, '148ILE-204ARG-1')] =   -2.426  
BIND_SILVER['%s-%s' % (dbse, '148PHE-164HIE-1')] =   -2.766  
BIND_SILVER['%s-%s' % (dbse, '148PHE-165TYR-1')] =   -3.439  
BIND_SILVER['%s-%s' % (dbse, '148SER-163ALA-1')] =   -0.777  
BIND_SILVER['%s-%s' % (dbse, '148TYR-170ILE-1')] =   -1.244  
BIND_SILVER['%s-%s' % (dbse, '149ASN-167THR-1')] =   -1.157  
BIND_SILVER['%s-%s' % (dbse, '149ASN-171TYR-1')] =   -5.027  
BIND_SILVER['%s-%s' % (dbse, '149ASN-175SER-1')] =   -2.825  
BIND_SILVER['%s-%s' % (dbse, '149ASN-177ASP-1')] =   -6.506  
BIND_SILVER['%s-%s' % (dbse, '149LEU-152GLN-1')] =   -0.442  
BIND_SILVER['%s-%s' % (dbse, '149PHE-159ILE-1')] =   -1.849  
BIND_SILVER['%s-%s' % (dbse, '149PHE-164PHE-1')] =   -1.178  
BIND_SILVER['%s-%s' % (dbse, '149PHE-165PHE-1')] =   -1.784  
BIND_SILVER['%s-%s' % (dbse, '149PHE-169VAL-1')] =   -0.552  
BIND_SILVER['%s-%s' % (dbse, '149PRO-152GLN-1')] =   -3.151  
BIND_SILVER['%s-%s' % (dbse, '149PRO-152PHE-1')] =   -0.876  
BIND_SILVER['%s-%s' % (dbse, '149THR-157PRO-1')] =   -0.880  
BIND_SILVER['%s-%s' % (dbse, '149TYR-153PHE-1')] =   -2.777  
BIND_SILVER['%s-%s' % (dbse, '150ARG-157ASP-1')] = -113.264  
BIND_SILVER['%s-%s' % (dbse, '150ARG-208ILE-1')] =   -2.246  
BIND_SILVER['%s-%s' % (dbse, '150LEU-153PHE-1')] =   -0.825  
BIND_SILVER['%s-%s' % (dbse, '150LEU-154TYR-1')] =   -0.501  
BIND_SILVER['%s-%s' % (dbse, '150LEU-159PHE-1')] =   -1.198  
BIND_SILVER['%s-%s' % (dbse, '150LEU-167LEU-1')] =   -0.400  
BIND_SILVER['%s-%s' % (dbse, '150LEU-170HIE-1')] =   -1.029  
BIND_SILVER['%s-%s' % (dbse, '150LEU-202LEU-1')] =   -0.784  
BIND_SILVER['%s-%s' % (dbse, '150LEU-203GLU-1')] =   -2.485  
BIND_SILVER['%s-%s' % (dbse, '150LYS-158LEU-1')] =   -0.492  
BIND_SILVER['%s-%s' % (dbse, '151ILE-159VAL-1')] =    0.051  
BIND_SILVER['%s-%s' % (dbse, '151SER-159PHE-1')] =   -2.097  
BIND_SILVER['%s-%s' % (dbse, '151THR-163THR-1')] =    5.467  
BIND_SILVER['%s-%s' % (dbse, '152ASP-156LYS-1')] =   -5.280  
BIND_SILVER['%s-%s' % (dbse, '152ASP-158LEU-1')] =   -1.226  
BIND_SILVER['%s-%s' % (dbse, '152CYS-197VAL-1')] =    0.588  
BIND_SILVER['%s-%s' % (dbse, '152LYS-156ASP-2')] = -115.305  
BIND_SILVER['%s-%s' % (dbse, '152LYS-277TYR-1')] =   -2.615  
BIND_SILVER['%s-%s' % (dbse, '153ASP-156ARG-1')] =  -67.350  
BIND_SILVER['%s-%s' % (dbse, '153ASP-200ARG-1')] = -106.304  
BIND_SILVER['%s-%s' % (dbse, '153LYS-203GLU-1')] = -115.460  
BIND_SILVER['%s-%s' % (dbse, '153PHE-163LEU-1')] =   -1.158  
BIND_SILVER['%s-%s' % (dbse, '153TRP-158MET-1')] =   -2.756  
BIND_SILVER['%s-%s' % (dbse, '154ARG-204ARG-1')] =   61.621  
BIND_SILVER['%s-%s' % (dbse, '154ARG-208TYR-1')] =  -10.964  
BIND_SILVER['%s-%s' % (dbse, '154ILE-159GLN-1')] =   -0.538  
BIND_SILVER['%s-%s' % (dbse, '154ILE-160VAL-1')] =   -0.510  
BIND_SILVER['%s-%s' % (dbse, '154LEU-191TYR-1')] =   -1.190  
BIND_SILVER['%s-%s' % (dbse, '154LYS-159ASN-1')] =   -0.595  
BIND_SILVER['%s-%s' % (dbse, '154TYR-203GLU-1')] =    4.617  
BIND_SILVER['%s-%s' % (dbse, '154TYR-207ASN-1')] =    0.261  
BIND_SILVER['%s-%s' % (dbse, '155PHE-197TYR-1')] =   -1.675  
BIND_SILVER['%s-%s' % (dbse, '155PHE-277TYR-1')] =   -3.116  
BIND_SILVER['%s-%s' % (dbse, '155PHE-284LEU-1')] =   -0.850  
BIND_SILVER['%s-%s' % (dbse, '155PRO-170TRP-1')] =   -1.268  
BIND_SILVER['%s-%s' % (dbse, '156ARG-171ASP-1')] =  -94.941  
BIND_SILVER['%s-%s' % (dbse, '156ARG-172THR-1')] =  -14.505  
BIND_SILVER['%s-%s' % (dbse, '156ARG-197GLU-1')] = -114.308  
BIND_SILVER['%s-%s' % (dbse, '156ARG-200TRP-1')] =   -2.651  
BIND_SILVER['%s-%s' % (dbse, '156ARG-200TRP-2')] =  -12.481  
BIND_SILVER['%s-%s' % (dbse, '156SER-191TYR-2')] =   -1.704  
BIND_SILVER['%s-%s' % (dbse, '157ASP-202VAL-1')] =   -2.295  
BIND_SILVER['%s-%s' % (dbse, '157ASP-204ARG-1')] = -118.382  
BIND_SILVER['%s-%s' % (dbse, '157ILE-160CYS-1')] =   -1.301  
BIND_SILVER['%s-%s' % (dbse, '157MET-181ILE-1')] =   -0.244  
BIND_SILVER['%s-%s' % (dbse, '157MET-192ILE-1')] =   -0.990  
BIND_SILVER['%s-%s' % (dbse, '157PRO-161VAL-1')] =   -0.927  
BIND_SILVER['%s-%s' % (dbse, '157VAL-167PHE-1')] =   -1.198  
BIND_SILVER['%s-%s' % (dbse, '158ALA-193HIE-2')] =   -0.904  
BIND_SILVER['%s-%s' % (dbse, '158ALA-284LEU-1')] =   -0.353  
BIND_SILVER['%s-%s' % (dbse, '158ILE-164LYS-2')] =   -0.786  
BIND_SILVER['%s-%s' % (dbse, '158LEU-172THR-1')] =   -0.169  
BIND_SILVER['%s-%s' % (dbse, '158VAL-169VAL-1')] =    0.094  
BIND_SILVER['%s-%s' % (dbse, '158VAL-205TYR-1')] =   -1.162  
BIND_SILVER['%s-%s' % (dbse, '159ALA-197TYR-1')] =   -0.523  
BIND_SILVER['%s-%s' % (dbse, '159GLU-170LYS-1')] =   -4.527  
BIND_SILVER['%s-%s' % (dbse, '159ILE-172TYR-1')] =   -1.582  
BIND_SILVER['%s-%s' % (dbse, '159ILE-199LEU-1')] =   -0.787  
BIND_SILVER['%s-%s' % (dbse, '159ILE-200TRP-1')] =   -1.471  
BIND_SILVER['%s-%s' % (dbse, '159ILE-203PRO-1')] =   -0.408  
BIND_SILVER['%s-%s' % (dbse, '159PHE-206ILE-1')] =   -0.729  
BIND_SILVER['%s-%s' % (dbse, '159PRO-164VAL-1')] =   -0.496  
BIND_SILVER['%s-%s' % (dbse, '159PRO-178TYR-1')] =   -2.639  
BIND_SILVER['%s-%s' % (dbse, '159PRO-192ILE-1')] =   -0.978  
BIND_SILVER['%s-%s' % (dbse, '159VAL-180LEU-1')] =   -1.047  
BIND_SILVER['%s-%s' % (dbse, '160LEU-164TRP-1')] =   -0.529  
BIND_SILVER['%s-%s' % (dbse, '160MET-169LEU-1')] =   -1.058  
BIND_SILVER['%s-%s' % (dbse, '160PHE-169VAL-1')] =   -1.645  
BIND_SILVER['%s-%s' % (dbse, '160PHE-203VAL-1')] =   -1.024  
BIND_SILVER['%s-%s' % (dbse, '161ARG-285ASP-1')] =  -86.634  
BIND_SILVER['%s-%s' % (dbse, '161ARG-288ALA-1')] =   -2.125  
BIND_SILVER['%s-%s' % (dbse, '161ARG-292GLU-1')] = -119.799  
BIND_SILVER['%s-%s' % (dbse, '161THR-194VAL-2')] =   -0.132  
BIND_SILVER['%s-%s' % (dbse, '161TYR-201ALA-1')] =   -2.252  
BIND_SILVER['%s-%s' % (dbse, '161TYR-204ALA-1')] =   -1.151  
BIND_SILVER['%s-%s' % (dbse, '161VAL-170LYS-1')] =   -1.438  
BIND_SILVER['%s-%s' % (dbse, '162ALA-174ILE-1')] =   -0.664  
BIND_SILVER['%s-%s' % (dbse, '162ALA-175TRP-1')] =   -2.236  
BIND_SILVER['%s-%s' % (dbse, '162LEU-198PHE-1')] =   -1.055  
BIND_SILVER['%s-%s' % (dbse, '162LEU-201LEU-1')] =   -0.346  
BIND_SILVER['%s-%s' % (dbse, '162LEU-203VAL-1')] =   -0.703  
BIND_SILVER['%s-%s' % (dbse, '162LEU-208ILE-1')] =    0.095  
BIND_SILVER['%s-%s' % (dbse, '162LEU-284LEU-1')] =   -0.328  
BIND_SILVER['%s-%s' % (dbse, '162PHE-168LEU-1')] =   -1.954  
BIND_SILVER['%s-%s' % (dbse, '162PHE-207ASN-1')] =   -1.299  
BIND_SILVER['%s-%s' % (dbse, '162VAL-167CYS-1')] =   -0.859  
BIND_SILVER['%s-%s' % (dbse, '162VAL-167TYR-1')] =   -1.422  
BIND_SILVER['%s-%s' % (dbse, '162VAL-167TYR-2')] =   -1.084  
BIND_SILVER['%s-%s' % (dbse, '163ARG-201LEU-1')] =   -2.239  
BIND_SILVER['%s-%s' % (dbse, '163ASN-166ILE-1')] =   -1.751  
BIND_SILVER['%s-%s' % (dbse, '163ASN-196ARG-1')] =   -5.767  
BIND_SILVER['%s-%s' % (dbse, '163ILE-166CYS-1')] =   -0.610  
BIND_SILVER['%s-%s' % (dbse, '163LEU-171ALA-1')] =   -0.532  
BIND_SILVER['%s-%s' % (dbse, '163LEU-175LEU-1')] =   -0.079  
BIND_SILVER['%s-%s' % (dbse, '163TYR-174ILE-1')] =   -2.101  
BIND_SILVER['%s-%s' % (dbse, '163TYR-178TYR-1')] =   -2.705  
BIND_SILVER['%s-%s' % (dbse, '163TYR-180LEU-1')] =   -0.945  
BIND_SILVER['%s-%s' % (dbse, '163TYR-180LEU-2')] =   -1.217  
BIND_SILVER['%s-%s' % (dbse, '163TYR-183LYS-1')] =   -6.398  
BIND_SILVER['%s-%s' % (dbse, '163TYR-184VAL-1')] =   -1.100  
BIND_SILVER['%s-%s' % (dbse, '163TYR-187GLU-1')] =    3.810  
BIND_SILVER['%s-%s' % (dbse, '164VAL-171ALA-1')] =   -0.851  
BIND_SILVER['%s-%s' % (dbse, '164VAL-225LEU-1')] =   -0.551  
BIND_SILVER['%s-%s' % (dbse, '165ALA-292GLU-1')] =   -2.291  
BIND_SILVER['%s-%s' % (dbse, '165GLN-224MET-2')] =   -1.864  
BIND_SILVER['%s-%s' % (dbse, '165LYS-169ASP-1')] = -112.327  
BIND_SILVER['%s-%s' % (dbse, '165PHE-169VAL-1')] =   -1.460  
BIND_SILVER['%s-%s' % (dbse, '165TYR-168ASP-1')] =    3.051  
BIND_SILVER['%s-%s' % (dbse, '165TYR-171VAL-1')] =   -1.542  
BIND_SILVER['%s-%s' % (dbse, '165TYR-208ILE-1')] =   -0.894  
BIND_SILVER['%s-%s' % (dbse, '165TYR-208ILE-2')] =   -1.503  
BIND_SILVER['%s-%s' % (dbse, '165VAL-177ILE-1')] =   -0.528  
BIND_SILVER['%s-%s' % (dbse, '166ILE-187ARG-1')] =   -0.449  
BIND_SILVER['%s-%s' % (dbse, '166PRO-171VAL-1')] =   -0.549  
BIND_SILVER['%s-%s' % (dbse, '166PRO-172VAL-1')] =   -0.336  
BIND_SILVER['%s-%s' % (dbse, '167GLU-187ARG-1')] = -117.120  
BIND_SILVER['%s-%s' % (dbse, '167PHE-170TRP-1')] =   -2.777  
BIND_SILVER['%s-%s' % (dbse, '167PRO-170VAL-1')] =   -1.042  
BIND_SILVER['%s-%s' % (dbse, '168HIE-180GLU-1')] =  -24.591  
BIND_SILVER['%s-%s' % (dbse, '168ILE-178VAL-1')] =   -0.424  
BIND_SILVER['%s-%s' % (dbse, '168LEU-172ASP-1')] =   -2.469  
BIND_SILVER['%s-%s' % (dbse, '168LEU-211ARG-1')] =   -1.938  
BIND_SILVER['%s-%s' % (dbse, '168TYR-203ILE-1')] =   -1.187  
BIND_SILVER['%s-%s' % (dbse, '168TYR-224MET-1')] =   -0.469  
BIND_SILVER['%s-%s' % (dbse, '169ASP-172SER-2')] =  -18.790  
BIND_SILVER['%s-%s' % (dbse, '169LEU-181TRP-1')] =   -1.378  
BIND_SILVER['%s-%s' % (dbse, '169LYS-172ILE-2')] =   -2.811  
BIND_SILVER['%s-%s' % (dbse, '169LYS-291ILE-1')] =   -0.420  
BIND_SILVER['%s-%s' % (dbse, '169MET-184VAL-1')] =   -0.079  
BIND_SILVER['%s-%s' % (dbse, '170ALA-175TRP-1')] =   -1.173  
BIND_SILVER['%s-%s' % (dbse, '170HIE-174LEU-1')] =   -1.213  
BIND_SILVER['%s-%s' % (dbse, '170LEU-178LEU-1')] =   -0.969  
BIND_SILVER['%s-%s' % (dbse, '170LEU-186TYR-1')] =   -1.321  
BIND_SILVER['%s-%s' % (dbse, '170THR-180GLU-1')] =   -0.552  
BIND_SILVER['%s-%s' % (dbse, '171ASP-176THR-1')] =  -17.536  
BIND_SILVER['%s-%s' % (dbse, '171THR-180SER-1')] =   -5.192  
BIND_SILVER['%s-%s' % (dbse, '171TYR-180PRO-1')] =    2.055  
BIND_SILVER['%s-%s' % (dbse, '171TYR-231VAL-1')] =   -1.120  
BIND_SILVER['%s-%s' % (dbse, '172ASP-204TYR-1')] =  -25.902  
BIND_SILVER['%s-%s' % (dbse, '172ILE-235VAL-1')] =   -0.553  
BIND_SILVER['%s-%s' % (dbse, '172TYR-193VAL-1')] =   -0.838  
BIND_SILVER['%s-%s' % (dbse, '173ARG-234ASP-1')] = -116.550  
BIND_SILVER['%s-%s' % (dbse, '173ARG-296LYS-1')] =   58.589  
BIND_SILVER['%s-%s' % (dbse, '173CYS-269HIE-1')] =   -0.754  
BIND_SILVER['%s-%s' % (dbse, '173CYS-270TYR-1')] =   -1.086  
BIND_SILVER['%s-%s' % (dbse, '173LEU-190VAL-1')] =   -0.531  
BIND_SILVER['%s-%s' % (dbse, '173PHE-176THR-1')] =   -0.915  
BIND_SILVER['%s-%s' % (dbse, '173TYR-211PRO-1')] =   -1.150  
BIND_SILVER['%s-%s' % (dbse, '173TYR-213ILE-1')] =   -2.018  
BIND_SILVER['%s-%s' % (dbse, '173TYR-245ILE-1')] =   -1.261  
BIND_SILVER['%s-%s' % (dbse, '174ASN-178LYS-1')] =  -24.717  
BIND_SILVER['%s-%s' % (dbse, '174MET-177ILE-1')] =   -1.135  
BIND_SILVER['%s-%s' % (dbse, '174THR-205LEU-1')] =   -1.355  
BIND_SILVER['%s-%s' % (dbse, '174VAL-203VAL-1')] =   -0.791  
BIND_SILVER['%s-%s' % (dbse, '174VAL-205PHE-1')] =   -1.609  
BIND_SILVER['%s-%s' % (dbse, '174VAL-270TYR-1')] =   -0.209  
BIND_SILVER['%s-%s' % (dbse, '174VAL-273GLU-1')] =   -0.690  
BIND_SILVER['%s-%s' % (dbse, '174VAL-273GLU-2')] =   -0.841  
BIND_SILVER['%s-%s' % (dbse, '175LEU-233ALA-1')] =   -0.327  
BIND_SILVER['%s-%s' % (dbse, '175VAL-268LEU-1')] =   -0.927  
BIND_SILVER['%s-%s' % (dbse, '175VAL-274ASP-1')] =   -6.954  
BIND_SILVER['%s-%s' % (dbse, '176ALA-195LEU-1')] =   -0.615  
BIND_SILVER['%s-%s' % (dbse, '176ARG-182GLU-1')] = -114.656  
BIND_SILVER['%s-%s' % (dbse, '176ARG-273GLU-1')] =  -76.407  
BIND_SILVER['%s-%s' % (dbse, '176ILE-198PHE-1')] =   -1.240  
BIND_SILVER['%s-%s' % (dbse, '176ILE-201ALA-1')] =   -0.457  
BIND_SILVER['%s-%s' % (dbse, '176ILE-205LEU-1')] =   -0.342  
BIND_SILVER['%s-%s' % (dbse, '176LEU-204TYR-1')] =   -1.712  
BIND_SILVER['%s-%s' % (dbse, '176LEU-208ALA-1')] =   -0.632  
BIND_SILVER['%s-%s' % (dbse, '176LEU-208ALA-2')] =   -0.496  
BIND_SILVER['%s-%s' % (dbse, '176LEU-214PHE-1')] =   -1.525  
BIND_SILVER['%s-%s' % (dbse, '176THR-180LEU-1')] =   -0.722  
BIND_SILVER['%s-%s' % (dbse, '177ASP-216GLU-1')] =   70.128  
BIND_SILVER['%s-%s' % (dbse, '177GLN-190VAL-1')] =   -1.071  
BIND_SILVER['%s-%s' % (dbse, '178SER-239ASP-1')] =  -18.922  
BIND_SILVER['%s-%s' % (dbse, '179ALA-225TRP-1')] =   -0.805  
BIND_SILVER['%s-%s' % (dbse, '179ALA-238MET-1')] =   -0.719  
BIND_SILVER['%s-%s' % (dbse, '179ALA-250ILE-1')] =   -0.747  
BIND_SILVER['%s-%s' % (dbse, '179LEU-239PHE-1')] =   -1.720  
BIND_SILVER['%s-%s' % (dbse, '179TYR-216GLU-1')] =    4.148  
BIND_SILVER['%s-%s' % (dbse, '179TYR-250PHE-1')] =   -3.936  
BIND_SILVER['%s-%s' % (dbse, '179TYR-258TRP-1')] =   -4.378  
BIND_SILVER['%s-%s' % (dbse, '180ASN-219SER-1')] =   -4.822  
BIND_SILVER['%s-%s' % (dbse, '180ASN-229TRP-1')] =   -3.628  
BIND_SILVER['%s-%s' % (dbse, '180GLU-187ARG-1')] = -101.333  
BIND_SILVER['%s-%s' % (dbse, '180GLU-189ARG-2')] = -105.373  
BIND_SILVER['%s-%s' % (dbse, '180GLU-194ARG-1')] = -115.347  
BIND_SILVER['%s-%s' % (dbse, '180HIE-184VAL-1')] =   -1.326  
BIND_SILVER['%s-%s' % (dbse, '180HIE-209TYR-1')] =  -11.397  
BIND_SILVER['%s-%s' % (dbse, '180HIE-214PHE-1')] =   -1.595  
BIND_SILVER['%s-%s' % (dbse, '180HIE-224ILE-1')] =   -0.795  
BIND_SILVER['%s-%s' % (dbse, '181ILE-228TYR-1')] =   -1.143  
BIND_SILVER['%s-%s' % (dbse, '181THR-195SER-1')] =   -5.126  
BIND_SILVER['%s-%s' % (dbse, '181TRP-185GLN-1')] =   -2.113  
BIND_SILVER['%s-%s' % (dbse, '181TRP-189SER-1')] =   -0.882  
BIND_SILVER['%s-%s' % (dbse, '181TRP-258TRP-1')] =   -2.876  
BIND_SILVER['%s-%s' % (dbse, '182ASP-186ASN-1')] =  -11.283  
BIND_SILVER['%s-%s' % (dbse, '182ILE-192ILE-1')] =   -0.702  
BIND_SILVER['%s-%s' % (dbse, '182ILE-239PHE-1')] =   -1.003  
BIND_SILVER['%s-%s' % (dbse, '182ILE-242LEU-1')] =   -0.488  
BIND_SILVER['%s-%s' % (dbse, '182PRO-186LEU-1')] =   -0.363  
BIND_SILVER['%s-%s' % (dbse, '182PRO-186LEU-2')] =   -1.033  
BIND_SILVER['%s-%s' % (dbse, '182PRO-189ARG-1')] =   -2.963  
BIND_SILVER['%s-%s' % (dbse, '183GLN-190LYS-1')] =   -1.397  
BIND_SILVER['%s-%s' % (dbse, '183GLN-194ILE-1')] =   -0.841  
BIND_SILVER['%s-%s' % (dbse, '183GLN-205LEU-1')] =    0.073  
BIND_SILVER['%s-%s' % (dbse, '183GLN-209TYR-1')] =    1.996  
BIND_SILVER['%s-%s' % (dbse, '183TYR-186LYS-1')] =  -14.933  
BIND_SILVER['%s-%s' % (dbse, '184ASP-187ARG-1')] =  -87.829  
BIND_SILVER['%s-%s' % (dbse, '184PHE-205THR-1')] =   -1.746  
BIND_SILVER['%s-%s' % (dbse, '184PHE-209LEU-1')] =   -1.340  
BIND_SILVER['%s-%s' % (dbse, '184PHE-225TRP-1')] =   -2.393  
BIND_SILVER['%s-%s' % (dbse, '184PHE-228VAL-1')] =   -1.216  
BIND_SILVER['%s-%s' % (dbse, '184PHE-238MET-1')] =   -1.779  
BIND_SILVER['%s-%s' % (dbse, '184PHE-255TRP-1')] =   -1.679  
BIND_SILVER['%s-%s' % (dbse, '184THR-220ALA-1')] =   -0.411  
BIND_SILVER['%s-%s' % (dbse, '184VAL-225GLU-1')] =   -1.549  
BIND_SILVER['%s-%s' % (dbse, '185PHE-190LYS-1')] =   -2.020  
BIND_SILVER['%s-%s' % (dbse, '185TYR-220PHE-1')] =   -1.540  
BIND_SILVER['%s-%s' % (dbse, '185VAL-224ILE-1')] =   -0.085  
BIND_SILVER['%s-%s' % (dbse, '185VAL-228TYR-1')] =   -1.344  
BIND_SILVER['%s-%s' % (dbse, '186CYS-192PHE-1')] =   -0.852  
BIND_SILVER['%s-%s' % (dbse, '186GLU-189LYS-1')] = -108.890  
BIND_SILVER['%s-%s' % (dbse, '186LYS-191VAL-1')] =   -1.624  
BIND_SILVER['%s-%s' % (dbse, '186LYS-191VAL-2')] =   -1.395  
BIND_SILVER['%s-%s' % (dbse, '186TYR-273GLU-1')] =    4.703  
BIND_SILVER['%s-%s' % (dbse, '186VAL-208PRO-1')] =   -1.119  
BIND_SILVER['%s-%s' % (dbse, '186VAL-223LEU-1')] =   -0.499  
BIND_SILVER['%s-%s' % (dbse, '187LYS-193THR-1')] =   -0.497  
BIND_SILVER['%s-%s' % (dbse, '187LYS-193THR-2')] =   -1.645  
BIND_SILVER['%s-%s' % (dbse, '188LYS-225GLU-1')] =   -5.277  
BIND_SILVER['%s-%s' % (dbse, '189THR-199LYS-1')] =    0.216  
BIND_SILVER['%s-%s' % (dbse, '189THR-205PHE-1')] =   -1.285  
BIND_SILVER['%s-%s' % (dbse, '189THR-207GLU-1')] =  -16.616  
BIND_SILVER['%s-%s' % (dbse, '189TYR-232ALA-1')] =   -1.493  
BIND_SILVER['%s-%s' % (dbse, '190ARG-235LEU-1')] =   -2.072  
BIND_SILVER['%s-%s' % (dbse, '190LYS-193GLU-1')] = -108.863  
BIND_SILVER['%s-%s' % (dbse, '190PHE-199LEU-1')] =   -1.262  
BIND_SILVER['%s-%s' % (dbse, '191LEU-219TRP-2')] =   -2.358  
BIND_SILVER['%s-%s' % (dbse, '191TRP-229TRP-1')] =   -1.295  
BIND_SILVER['%s-%s' % (dbse, '192GLN-197VAL-1')] =   -0.589  
BIND_SILVER['%s-%s' % (dbse, '192ILE-242LEU-1')] =   -0.493  
BIND_SILVER['%s-%s' % (dbse, '192SER-269ARG-1')] =   -9.722  
BIND_SILVER['%s-%s' % (dbse, '193HIE-248MET-1')] =   -0.852  
BIND_SILVER['%s-%s' % (dbse, '193HIE-301MET-1')] =   -1.862  
BIND_SILVER['%s-%s' % (dbse, '194ASP-269ARG-1')] = -119.485  
BIND_SILVER['%s-%s' % (dbse, '194ILE-205LEU-1')] =   -0.554  
BIND_SILVER['%s-%s' % (dbse, '194PHE-198PHE-1')] =   -2.942  
BIND_SILVER['%s-%s' % (dbse, '194PHE-201LYS-1')] =   -1.795  
BIND_SILVER['%s-%s' % (dbse, '194PHE-217PHE-1')] =   -1.671  
BIND_SILVER['%s-%s' % (dbse, '194PHE-233ALA-1')] =   -1.778  
BIND_SILVER['%s-%s' % (dbse, '194PHE-237ILE-1')] =   -1.507  
BIND_SILVER['%s-%s' % (dbse, '194PHE-241TYR-1')] =   -2.703  
BIND_SILVER['%s-%s' % (dbse, '195ASP-241TYR-1')] =    5.813  
BIND_SILVER['%s-%s' % (dbse, '195LEU-205PHE-1')] =   -0.859  
BIND_SILVER['%s-%s' % (dbse, '195LEU-237ILE-1')] =   -0.323  
BIND_SILVER['%s-%s' % (dbse, '195LEU-269ARG-1')] =   -3.496  
BIND_SILVER['%s-%s' % (dbse, '195PRO-198PHE-1')] =   -2.704  
BIND_SILVER['%s-%s' % (dbse, '196HIE-218GLU-1')] =   10.369  
BIND_SILVER['%s-%s' % (dbse, '196HIE-221MET-1')] =   -0.795  
BIND_SILVER['%s-%s' % (dbse, '196HIE-249ILE-1')] =   -1.665  
BIND_SILVER['%s-%s' % (dbse, '196HIE-249ILE-2')] =   -1.434  
BIND_SILVER['%s-%s' % (dbse, '197TYR-201LEU-1')] =   -1.737  
BIND_SILVER['%s-%s' % (dbse, '197TYR-252PRO-1')] =   -1.892  
BIND_SILVER['%s-%s' % (dbse, '197TYR-284LEU-1')] =   -0.743  
BIND_SILVER['%s-%s' % (dbse, '198ASN-201LYS-1')] =   -1.716  
BIND_SILVER['%s-%s' % (dbse, '198PHE-205PHE-1')] =   -1.442  
BIND_SILVER['%s-%s' % (dbse, '198PHE-217PHE-1')] =   -1.002  
BIND_SILVER['%s-%s' % (dbse, '198PHE-284LEU-1')] =   -1.002  
BIND_SILVER['%s-%s' % (dbse, '198PHE-287LEU-1')] =   -1.532  
BIND_SILVER['%s-%s' % (dbse, '199LYS-207GLU-1')] = -108.844  
BIND_SILVER['%s-%s' % (dbse, '200TRP-204ASN-1')] =   -3.288  
BIND_SILVER['%s-%s' % (dbse, '201LEU-284LEU-1')] =   -0.574  
BIND_SILVER['%s-%s' % (dbse, '201SER-209ASN-1')] =   -2.257  
BIND_SILVER['%s-%s' % (dbse, '202TYR-212ILE-1')] =   -0.663  
BIND_SILVER['%s-%s' % (dbse, '202TYR-241TYR-1')] =   -2.244  
BIND_SILVER['%s-%s' % (dbse, '203VAL-291ILE-1')] =   -0.650  
BIND_SILVER['%s-%s' % (dbse, '205LEU-212ILE-1')] =   -0.787  
BIND_SILVER['%s-%s' % (dbse, '205MET-223ASP-2')] =   -5.679  
BIND_SILVER['%s-%s' % (dbse, '205MET-224MET-1')] =   -1.634  
BIND_SILVER['%s-%s' % (dbse, '205THR-209LEU-1')] =   -0.667  
BIND_SILVER['%s-%s' % (dbse, '206ASP-210TYR-1')] =  -27.791  
BIND_SILVER['%s-%s' % (dbse, '206VAL-231TYR-1')] =   -1.313  
BIND_SILVER['%s-%s' % (dbse, '207PRO-216VAL-1')] =   -0.387  
BIND_SILVER['%s-%s' % (dbse, '208ALA-214PHE-1')] =   -1.166  
BIND_SILVER['%s-%s' % (dbse, '209TYR-214PHE-1')] =   -1.736  
BIND_SILVER['%s-%s' % (dbse, '210GLU-213LYS-1')] = -109.771  
BIND_SILVER['%s-%s' % (dbse, '210TYR-216ASP-1')] =   -1.726  
BIND_SILVER['%s-%s' % (dbse, '210TYR-286TYR-1')] =   -2.157  
BIND_SILVER['%s-%s' % (dbse, '211ASP-214LYS-1')] = -114.742  
BIND_SILVER['%s-%s' % (dbse, '211PRO-245ILE-1')] =   -0.715  
BIND_SILVER['%s-%s' % (dbse, '212ALA-221GLU-1')] =   -2.427  
BIND_SILVER['%s-%s' % (dbse, '212ILE-243LYS-1')] =   -1.770  
BIND_SILVER['%s-%s' % (dbse, '212PRO-215ILE-1')] =   -0.947  
BIND_SILVER['%s-%s' % (dbse, '214ILE-217PHE-1')] =   -1.542  
BIND_SILVER['%s-%s' % (dbse, '215ALA-282PHE-1')] =   -0.687  
BIND_SILVER['%s-%s' % (dbse, '217PHE-234TYR-1')] =   -2.109  
BIND_SILVER['%s-%s' % (dbse, '217PHE-247ALA-1')] =   -0.980  
BIND_SILVER['%s-%s' % (dbse, '217PHE-249TRP-1')] =   -2.650  
BIND_SILVER['%s-%s' % (dbse, '218ALA-249TRP-1')] =   -2.521  
BIND_SILVER['%s-%s' % (dbse, '218ALA-258TRP-1')] =   -1.514  
BIND_SILVER['%s-%s' % (dbse, '219SER-229TRP-1')] =   -2.488  
BIND_SILVER['%s-%s' % (dbse, '219VAL-222TYR-1')] =   -1.450  
BIND_SILVER['%s-%s' % (dbse, '219VAL-222TYR-2')] =   -1.646  
BIND_SILVER['%s-%s' % (dbse, '219VAL-272ALA-1')] =   -0.824  # altered
BIND_SILVER['%s-%s' % (dbse, '219VAL-286TYR-1')] =   -1.156  
BIND_SILVER['%s-%s' % (dbse, '219VAL-288LEU-1')] =   -0.092  
BIND_SILVER['%s-%s' % (dbse, '220ALA-256THR-1')] =   -0.680  
BIND_SILVER['%s-%s' % (dbse, '220ALA-286TYR-1')] =   -2.133  
BIND_SILVER['%s-%s' % (dbse, '221GLU-226LYS-1')] =   -4.275  
BIND_SILVER['%s-%s' % (dbse, '221GLU-230LYS-1')] = -111.591  
BIND_SILVER['%s-%s' % (dbse, '221GLU-231TYR-1')] =    7.034  
BIND_SILVER['%s-%s' % (dbse, '221GLU-262SER-1')] =  -18.411  
BIND_SILVER['%s-%s' % (dbse, '221GLU-263SER-1')] =  -18.836  
BIND_SILVER['%s-%s' % (dbse, '221GLU-265GLU-1')] =   80.740  
BIND_SILVER['%s-%s' % (dbse, '222ALA-249ILE-1')] =   -0.557  
BIND_SILVER['%s-%s' % (dbse, '223ASP-286TYR-1')] =    4.496  
BIND_SILVER['%s-%s' % (dbse, '223ASP-288LEU-1')] =   -3.613  
BIND_SILVER['%s-%s' % (dbse, '223ASP-289SER-1')] =  -19.940  
BIND_SILVER['%s-%s' % (dbse, '223LEU-227ASN-1')] =    1.142  
BIND_SILVER['%s-%s' % (dbse, '224MET-229PHE-1')] =   -2.407  
BIND_SILVER['%s-%s' % (dbse, '224MET-229PHE-2')] =   -1.391  
BIND_SILVER['%s-%s' % (dbse, '225ASN-228ARG-1')] =   -1.656  
BIND_SILVER['%s-%s' % (dbse, '225TRP-228VAL-1')] =   -0.999  
BIND_SILVER['%s-%s' % (dbse, '225TRP-252GLU-1')] =   -2.418  
BIND_SILVER['%s-%s' % (dbse, '226LEU-233LYS-1')] =   -2.245  
BIND_SILVER['%s-%s' % (dbse, '226LEU-247VAL-1')] =   -1.024  
BIND_SILVER['%s-%s' % (dbse, '226LEU-294TYR-1')] =   -2.363  
BIND_SILVER['%s-%s' % (dbse, '226LEU-294TYR-2')] =   -1.472  
BIND_SILVER['%s-%s' % (dbse, '226LYS-262SER-1')] =  -17.757  
BIND_SILVER['%s-%s' % (dbse, '227HIE-255SER-1')] =    0.327  
BIND_SILVER['%s-%s' % (dbse, '227HIE-256LEU-1')] =   -1.186  
BIND_SILVER['%s-%s' % (dbse, '227HIE-289SER-1')] =   -1.963  
BIND_SILVER['%s-%s' % (dbse, '228ARG-232GLU-2')] =  -92.102  
BIND_SILVER['%s-%s' % (dbse, '228VAL-254THR-1')] =   -0.236  
BIND_SILVER['%s-%s' % (dbse, '232PRO-290LEU-1')] =   -0.585  
BIND_SILVER['%s-%s' % (dbse, '234ASN-237ASN-1')] =   -0.507  
BIND_SILVER['%s-%s' % (dbse, '234LEU-260LYS-1')] =   -0.814  
BIND_SILVER['%s-%s' % (dbse, '234LEU-262VAL-1')] =   -0.395  
BIND_SILVER['%s-%s' % (dbse, '234LEU-286TRP-1')] =   -1.999  
BIND_SILVER['%s-%s' % (dbse, '234LEU-286TRP-2')] =   -2.414  
BIND_SILVER['%s-%s' % (dbse, '235VAL-294ALA-1')] =   -0.546  
BIND_SILVER['%s-%s' % (dbse, '236ILE-258LEU-1')] =   -0.370  
BIND_SILVER['%s-%s' % (dbse, '236ILE-260ALA-1')] =   -0.834  
BIND_SILVER['%s-%s' % (dbse, '236PHE-262VAL-1')] =   -1.889  
BIND_SILVER['%s-%s' % (dbse, '236PHE-279ILE-2')] =   -1.796  
BIND_SILVER['%s-%s' % (dbse, '236PHE-282GLU-1')] =   -1.041  
BIND_SILVER['%s-%s' % (dbse, '237ILE-267ILE-1')] =   -0.443  
BIND_SILVER['%s-%s' % (dbse, '237ILE-269ARG-1')] =   -1.430  
BIND_SILVER['%s-%s' % (dbse, '237TRP-246PRO-1')] =   -1.982  
BIND_SILVER['%s-%s' % (dbse, '237TRP-249ALA-1')] =   -1.543  
BIND_SILVER['%s-%s' % (dbse, '237TRP-263ASP-1')] =   -2.034  
BIND_SILVER['%s-%s' % (dbse, '238MET-247PRO-1')] =   -0.948  
BIND_SILVER['%s-%s' % (dbse, '238MET-255TRP-1')] =   -2.182  
BIND_SILVER['%s-%s' % (dbse, '239ASP-244THR-1')] =   -3.746  
BIND_SILVER['%s-%s' % (dbse, '239ASP-271PRO-1')] =  -12.417  
BIND_SILVER['%s-%s' % (dbse, '240ASP-270SER-1')] =  -18.106  
BIND_SILVER['%s-%s' % (dbse, '240PRO-268LEU-1')] =   -0.653  
BIND_SILVER['%s-%s' % (dbse, '241ARG-272GLU-1')] =  -92.405  
BIND_SILVER['%s-%s' % (dbse, '243LEU-269HIE-1')] =   -1.381  
BIND_SILVER['%s-%s' % (dbse, '244SER-294TYR-1')] =   -0.451  
BIND_SILVER['%s-%s' % (dbse, '245ILE-250ILE-1')] =   -0.679  
BIND_SILVER['%s-%s' % (dbse, '245PRO-248GLU-1')] =   -2.219  
BIND_SILVER['%s-%s' % (dbse, '248MET-298ARG-1')] =   -0.855  
BIND_SILVER['%s-%s' % (dbse, '249ILE-269MET-1')] =   -0.594  
BIND_SILVER['%s-%s' % (dbse, '249ILE-276ILE-1')] =   -0.299  
BIND_SILVER['%s-%s' % (dbse, '249ILE-297PHE-1')] =   -1.504  
BIND_SILVER['%s-%s' % (dbse, '249ILE-300LEU-1')] =   -0.685  
BIND_SILVER['%s-%s' % (dbse, '250ILE-255TRP-1')] =   -1.846  
BIND_SILVER['%s-%s' % (dbse, '250ILE-255TRP-2')] =   -2.168  
BIND_SILVER['%s-%s' % (dbse, '251LEU-269MET-1')] =   -1.266  
BIND_SILVER['%s-%s' % (dbse, '252PRO-258ALA-1')] =   -0.437  
BIND_SILVER['%s-%s' % (dbse, '253ALA-261THR-1')] =    0.920  
BIND_SILVER['%s-%s' % (dbse, '253ALA-302SER-1')] =   -0.946  
BIND_SILVER['%s-%s' % (dbse, '255TRP-261VAL-1')] =   -1.769  
BIND_SILVER['%s-%s' % (dbse, '258LEU-261VAL-1')] =   -0.624  
BIND_SILVER['%s-%s' % (dbse, '261VAL-266VAL-1')] =   -0.176  
BIND_SILVER['%s-%s' % (dbse, '264ILE-271LEU-1')] =   -0.640  
BIND_SILVER['%s-%s' % (dbse, '270SER-283LEU-1')] =   -0.835  
BIND_SILVER['%s-%s' % (dbse, '273PRO-283LEU-1')] =   -1.017  
BIND_SILVER['%s-%s' % (dbse, '274ILE-279LYS-1')] =   -0.834  
BIND_SILVER['%s-%s' % (dbse, '275ASN-278LEU-1')] =   -1.076  
# Set default
BIND = BIND_SILVER
# Reference information
BINDINFO_BRONZE = {}
BINDINFO_SILVER = {}
for rxn in HRXN:
    BINDINFO_BRONZE['%s-%s' % (dbse, rxn)] = {'citation': 'merz3', 'method': 'MP2CF12', 'mode': 'SA', 'basis': 'adz'}
    BINDINFO_SILVER['%s-%s' % (dbse, rxn)] = {'citation': 'merz3', 'method': 'DWCCSDTF12', 'mode': 'CP', 'basis': 'adz'}  # addz?

# <<< Comment Lines >>>
TAGL = {}
rxnpattern = re.compile(r'^(.+)-(.+)-(.+)$')
for rxn in HRXN:
    molname = rxnpattern.match(rxn)
    TAGL['%s-%s'            % (dbse, rxn)] = """Residue %s and %s interaction No. %s""" % (molname.group(1), molname.group(2), molname.group(3))
    TAGL['%s-%s-dimer'      % (dbse, rxn)] = """Dimer from %s""" % (rxn)
    TAGL['%s-%s-monoA-CP'   % (dbse, rxn)] = """Monomer A from %s""" % (rxn)
    TAGL['%s-%s-monoB-CP'   % (dbse, rxn)] = """Monomer B from %s""" % (rxn)
    TAGL['%s-%s-monoA-unCP' % (dbse, rxn)] = """Monomer A from %s""" % (rxn)
    TAGL['%s-%s-monoB-unCP' % (dbse, rxn)] = """Monomer B from %s""" % (rxn)

TAGL['dbse'] = 'interaction energies for peptide sidechain-sidechain complexes'
TAGL['default'] = 'entire database'
TAGL['NeutralOverall'] = 'neutral charge on complex'
TAGL['CationOverall'] = 'positive charge on complex'
TAGL['AnionOverall'] = 'negative charge on complex'
TAGL['NeutralMonomer'] = 'neutral charge on both monomers'
TAGL['CationMonomer'] = 'positive charge on either monomer'
TAGL['AnionMonomer'] = 'negative charge on either monomer'
TAGL['HB'] = 'hydrogen-bonded systems (derived from SAPT0/jun-cc-pVDZ)'
TAGL['MX'] = 'mixed-influence system s(derived from SAPT0/jun-cc-pVDZ)'
TAGL['DD'] = 'dispersion-dominated systems (derived from SAPT0/jun-cc-pVDZ)'
TAGL['PosPos'] = 'both aa positively charged'
TAGL['PosNeg'] = 'one aa positively charged, one negatively'
TAGL['PosPolar'] = 'one aa positively charged, one polar'
TAGL['PosAliph'] = 'one aa positively charged, one nonpolar aliphatic'
TAGL['PosAryl'] = 'one aa positively charged, one nonpolar aromatic'
TAGL['NegNeg'] = 'both aa negatively charged'
TAGL['NegPolar'] = 'one aa negatively charged, one polar'
TAGL['NegAliph'] = 'one aa negatively charged, one nonpolar aliphatic'
TAGL['NegAryl'] = 'one aa negatively charged, one nonpolar aromatic'
TAGL['PolarPolar'] = 'both aa polar'
TAGL['PolarAliph'] = 'one aa polar, one nonpolar aliphatic'
TAGL['PolarAryl'] = 'one aa polar, one nonpolar aromatic'
TAGL['AliphAliph'] = 'both aa nonpolar aliphatic'
TAGL['AliphAryl'] = 'one aa nonpolar aliphatic, one nonpolar aromatic'
TAGL['ArylAryl'] = 'both aa nonpolar aromatic'
TAGL['ssi500'] = 'representative sample of 500'
TAGL['ssi100'] = 'representative sample of 100'

# <<< Geometry Specification Strings >>>
GEOS = {}

GEOS['%s-%s-dimer' % (dbse, '001ARG-005ASP-1')] = qcdb.Molecule("""
1 1
C      -23.00700000   -14.39400000   -25.47600000
C      -23.86700000   -15.59000000   -25.01000000
C      -22.00600000   -15.99600000   -27.05600000
N      -22.00900000   -14.81000000   -26.46800000
N      -22.97400000   -16.87300000   -26.85700000
N      -21.03500000   -16.32600000   -27.87900000
H      -23.65000000   -13.61700000   -25.89000000
H      -22.47300000   -13.98600000   -24.61600000
H      -23.24100000   -16.45200000   -24.76000000
H      -24.75600000   -15.73900000   -25.63000000
H      -21.30800000   -14.13600000   -26.74300000
H      -23.91000000   -16.51500000   -26.79400000
H      -22.88300000   -17.78900000   -27.27300000
H      -20.27200000   -15.69400000   -28.06100000
H      -20.98400000   -17.25100000   -28.27500000
H      -24.16288000   -15.59000000   -23.95054000
--
-1 1
C      -22.55600000   -10.26400000   -22.28900000
C      -23.78900000   -10.92000000   -22.80600000
O      -23.62800000   -11.92000000   -23.54700000
O      -24.89300000   -10.40500000   -22.49800000
H      -22.80800000    -9.57700000   -21.47600000
H      -22.15700000    -9.68100000   -23.12100000
H      -21.82283000   -10.99789000   -21.92314000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ARG-013ARG-1')] = qcdb.Molecule("""
1 1
C      -23.00700000   -14.39400000   -25.47600000
C      -23.86700000   -15.59000000   -25.01000000
C      -22.00600000   -15.99600000   -27.05600000
N      -22.00900000   -14.81000000   -26.46800000
N      -22.97400000   -16.87300000   -26.85700000
N      -21.03500000   -16.32600000   -27.87900000
H      -23.65000000   -13.61700000   -25.89000000
H      -22.47300000   -13.98600000   -24.61600000
H      -23.24100000   -16.45200000   -24.76000000
H      -24.75600000   -15.73900000   -25.63000000
H      -21.30800000   -14.13600000   -26.74300000
H      -23.91000000   -16.51500000   -26.79400000
H      -22.88300000   -17.78900000   -27.27300000
H      -20.27200000   -15.69400000   -28.06100000
H      -20.98400000   -17.25100000   -28.27500000
H      -24.16288000   -15.59000000   -23.95054000
--
1 1
C      -20.43100000   -18.76900000   -24.46000000
C      -20.00400000   -16.38700000   -24.07600000
N      -19.89600000   -17.47900000   -24.83400000
N      -20.69200000   -16.41500000   -22.93200000
N      -19.46500000   -15.23000000   -24.46300000
H      -19.39300000   -17.42400000   -25.72300000
H      -21.07700000   -17.29100000   -22.58900000
H      -20.84800000   -15.55800000   -22.40300000
H      -18.90500000   -15.21400000   -25.30500000
H      -19.60900000   -14.38900000   -23.92100000
H      -20.58900000   -19.35100000   -25.37000000
H      -21.40400000   -18.68100000   -23.97800000
H      -19.72785000   -19.32174000   -23.81964000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ARG-015GLU-1')] = qcdb.Molecule("""
1 1
C      -23.00700000   -14.39400000   -25.47600000
C      -22.00600000   -15.99600000   -27.05600000
N      -21.03500000   -16.32600000   -27.87900000
N      -22.00900000   -14.81000000   -26.46800000
N      -22.97400000   -16.87300000   -26.85700000
H      -20.27200000   -15.69400000   -28.06100000
H      -20.98400000   -17.25100000   -28.27500000
H      -21.30800000   -14.13600000   -26.74300000
H      -23.91000000   -16.51500000   -26.79400000
H      -22.88300000   -17.78900000   -27.27300000
H      -23.65000000   -13.61700000   -25.89000000
H      -22.47300000   -13.98600000   -24.61600000
H      -23.61928000   -15.24549000   -25.14423000
--
-1 1
C      -16.24500000   -18.38300000   -27.39100000
C      -17.33100000   -17.37300000   -27.32100000
O      -18.51900000   -17.73600000   -27.31600000
O      -17.01700000   -16.18400000   -27.23000000
H      -16.30900000   -18.92500000   -28.33800000
H      -16.39900000   -19.10100000   -26.58400000
H      -15.24154000   -17.94036000   -27.30648000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ARG-159VAL-1')] = qcdb.Molecule("""
1 1
C        2.30100000    11.51200000     7.38900000
C        1.68200000    10.56100000     6.38100000
C        3.50900000    13.66600000     7.36400000
N        2.87900000    12.68900000     6.72900000
N        3.65600000    13.62400000     8.67300000
N        4.00000000    14.68500000     6.68800000
H        1.51700000    11.84200000     8.07400000
H        3.05900000    10.98900000     7.97400000
H        2.42500000    10.31800000     5.61700000
H        0.84400000    11.07600000     5.90900000
H        2.75100000    12.79000000     5.73100000
H        3.26900000    12.86300000     9.20200000
H        4.19100000    14.34700000     9.13300000
H        3.88700000    14.74500000     5.69000000
H        4.52900000    15.39100000     7.18000000
H        1.35184800     9.63267200     6.87008800
--
0 1
C        5.70100000    10.90800000     6.94500000
C        6.59000000    10.71100000     5.72300000
H        5.93200000    10.16000000     7.70400000
H        5.86300000    11.89700000     7.37600000
H        4.67500000    10.79100000     6.62500000
H        7.61300000    10.63400000     6.05000000
H        6.28790800     9.80472300     5.17765500
H        6.52932000    11.58653000     5.05985100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ASN-026VAL-1')] = qcdb.Molecule("""
0 1
C       13.49800000    -3.02600000    29.06400000
C       13.42800000    -1.56400000    28.66200000
O       14.37900000    -0.78800000    28.83700000
N       12.31100000    -1.18300000    28.13300000
H       13.39400000    -3.01700000    30.15200000
H       14.50500000    -3.40100000    28.86200000
H       12.30400000    -0.23100000    27.78500000
H       11.43700000    -1.61800000    28.37400000
H       12.71870000    -3.68779000    28.65813000
--
0 1
C       16.70800000    -2.09400000    26.73800000
C       17.28900000    -2.11700000    25.32500000
H       17.16400000    -1.30800000    27.33900000
H       16.90700000    -3.04900000    27.22700000
H       15.63000000    -1.94200000    26.68900000
H       18.37400000    -2.19500000    25.40700000
H       17.03413000    -1.18007500    24.80808000
H       16.93050000    -2.99093300    24.76133000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ASN-030MET-1')] = qcdb.Molecule("""
0 1
C       13.49800000    -3.02600000    29.06400000
C       13.42800000    -1.56400000    28.66200000
O       14.37900000    -0.78800000    28.83700000
N       12.31100000    -1.18300000    28.13300000
H       12.30400000    -0.23100000    27.78500000
H       11.43700000    -1.61800000    28.37400000
H       13.39400000    -3.01700000    30.15200000
H       14.50500000    -3.40100000    28.86200000
H       12.71870000    -3.68779000    28.65813000
--
0 1
C        9.83500000    -0.50600000    26.62800000
C        8.87500000     1.85700000    25.65700000
S       10.13100000     0.61700000    25.29700000
H       10.42800000    -1.40000000    26.45600000
H        8.78100000    -0.79300000    26.62700000
H       10.06800000    -0.03700000    27.58300000
H        7.94600000     1.35500000    25.93100000
H        8.68400000     2.45900000    24.78000000
H        9.20333600     2.49486900    26.49086000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001ASN-097GLU-1')] = qcdb.Molecule("""
0 1
C       37.76800000    38.93400000     0.68800000
C       37.55100000    37.49300000     0.33100000
O       38.51900000    36.79600000     0.45100000
N       36.32700000    37.17600000    -0.06100000
H       36.12500000    36.30600000    -0.49600000
H       35.56700000    37.83500000    -0.02800000
H       37.09100000    39.19100000     1.50600000
H       37.51200000    39.55200000    -0.17500000
H       38.80789000    39.11768000     0.99603680
--
-1 1
C       32.78300000    36.52700000     1.91700000
C       32.74000000    36.26300000     0.39900000
O       33.56900000    36.86000000    -0.32700000
O       31.88400000    35.48100000    -0.08600000
H       32.06500000    37.31700000     2.15200000
H       33.77200000    36.88400000     2.21300000
H       32.53118000    35.64563000     2.52508900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001HIE-099GLN-1')] = qcdb.Molecule("""
0 1
C      -14.05200000    29.34200000     1.43300000
C      -11.02400000    27.58700000     0.45400000
C      -12.66200000    28.78000000     1.30700000
C      -11.56800000    28.94500000     2.09800000
N      -12.29600000    27.93000000     0.28400000
N      -10.56100000    28.17800000     1.55200000
H      -10.46500000    26.95300000    -0.21500000
H       -9.62200000    28.05400000     1.93400000
H      -11.49700000    29.56700000     2.98300000
H      -14.37700000    29.65300000     0.43800000
H      -14.01800000    30.24300000     2.04900000
H      -14.78070000    28.62044000     1.83092900
--
0 1
C      -12.47000000    24.20200000     1.23300000
C      -12.41300000    22.87300000     1.96900000
C      -13.76900000    24.33100000     0.47400000
O      -14.84000000    24.33100000     1.06800000
N      -13.69400000    24.31400000    -0.84800000
H      -12.39800000    25.02200000     1.94800000
H      -11.63100000    24.28100000     0.54100000
H      -12.53000000    22.06300000     1.24700000
H      -13.25500000    22.82900000     2.66300000
H      -14.54500000    24.19600000    -1.38700000
H      -12.79800000    24.31500000    -1.30700000
H      -11.48080000    22.72088000     2.53279100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LEU-071LYS-1')] = qcdb.Molecule("""
0 1
C       -4.72900000     5.73500000   -24.43200000
C       -5.85200000     4.79100000   -24.84800000
H       -3.89000000     5.69800000   -25.13000000
H       -5.10100000     6.76200000   -24.42400000
H       -4.38500000     5.50500000   -23.42100000
H       -6.05800000     4.93700000   -25.90500000
H       -5.56272100     3.74398400   -24.67458000
H       -6.76604500     5.01716300   -24.27934000
--
0 1
C       -5.11700000     8.61300000   -26.85400000
C       -5.35800000    10.11100000   -26.70100000
C       -5.32900000     8.15900000   -28.29300000
H       -4.10400000     8.36400000   -26.53400000
H       -5.81700000     8.08300000   -26.21100000
H       -5.15400000    10.37900000   -25.66900000
H       -6.41100000    10.32100000   -26.89500000
H       -6.34500000     8.41500000   -28.59800000
H       -4.62600000     8.65400000   -28.95900000
H       -4.74111900    10.74082000   -27.35886000
H       -5.18602600     7.07225500   -28.38543000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LEU-154LEU-1')] = qcdb.Molecule("""
0 1
C       -7.11700000     5.10400000   -24.06100000
C       -5.85200000     4.79100000   -24.84800000
H       -6.93400000     5.01000000   -22.98800000
H       -7.43800000     6.12000000   -24.27500000
H       -7.91800000     4.42200000   -24.35600000
H       -6.05800000     4.93700000   -25.90500000
H       -5.56272100     3.74398400   -24.67458000
H       -5.04191400     5.47196300   -24.54791000
--
0 1
C       -8.11600000     8.81900000   -24.21100000
C       -9.60700000     8.60100000   -23.97000000
H       -7.92000000     9.87000000   -24.42400000
H       -7.55400000     8.52100000   -23.32500000
H       -7.78500000     8.22000000   -25.05800000
H       -9.74500000     7.55700000   -23.70200000
H      -10.16854000     8.80011700   -24.89468000
H       -9.95320500     9.22561100   -23.13334000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LEU-190THR-1')] = qcdb.Molecule("""
0 1
C       -7.11700000     5.10400000   -24.06100000
C       -5.85200000     4.79100000   -24.84800000
H       -6.93400000     5.01000000   -22.98800000
H       -7.43800000     6.12000000   -24.27500000
H       -7.91800000     4.42200000   -24.35600000
H       -6.05800000     4.93700000   -25.90500000
H       -5.56272100     3.74398400   -24.67458000
H       -5.04191400     5.47196300   -24.54791000
--
0 1
C      -10.22900000     4.84000000   -22.08400000
C      -11.50600000     5.58900000   -21.72700000
H      -10.46700000     3.92200000   -22.62400000
H       -9.61100000     5.47300000   -22.71800000
H       -9.66200000     4.58600000   -21.19100000
H      -11.24900000     6.54800000   -21.27900000
H      -12.10976000     4.99599200   -21.02428000
H      -12.08121000     5.77970800   -22.64502000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LYS-027ASN-2')] = qcdb.Molecule("""
1 1
C        3.33900000    13.12400000    14.62700000
N        3.43800000    11.83600000    14.06400000
H        3.76200000    11.20700000    14.80300000
H        4.15200000    11.62800000    13.37500000
H        2.53400000    11.37800000    13.91000000
H        3.46400000    12.68300000    15.63100000
H        4.23600000    13.55800000    15.06500000
H        2.37968800    13.52575000    14.98521000
--
0 1
C        4.21900000    13.06400000    12.09800000
C        2.95100000    12.28000000    11.76800000
O        2.03700000    11.96400000    12.52400000
N        2.78600000    11.97100000    10.54200000
H        4.59600000    13.44700000    11.14500000
H        5.06900000    12.43600000    12.39000000
H        1.94000000    11.47200000    10.29800000
H        3.48300000    12.17200000     9.83800000
H        4.05027600    13.96338000    12.70845000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LYS-027THR-1')] = qcdb.Molecule("""
0 1
C       -0.67000000   -12.11100000    19.55400000
C        0.60300000   -11.51100000    18.95900000
C       -1.00300000   -11.46700000    20.89500000
H       -1.51700000   -11.97800000    18.87800000
H       -0.53200000   -13.18200000    19.71600000
H        1.45800000   -11.74200000    19.59500000
H        0.51900000   -10.42600000    18.91200000
H       -1.90400000   -11.94500000    21.29500000
H       -0.18600000   -11.66700000    21.59700000
H        0.76863970   -11.85812000    17.92843000
H       -1.16391200   -10.38269000    20.80347000
--
0 1
C       -1.80200000   -10.31800000    16.49200000
C       -1.45000000    -9.18600000    15.53600000
H       -1.67100000   -11.28500000    16.01100000
H       -1.24900000   -10.18800000    17.41600000
H       -2.85800000   -10.23400000    16.75700000
H       -1.98600000    -8.28800000    15.84300000
H       -1.73452100    -9.44758700    14.50614000
H       -0.37036460    -8.97980400    15.57925000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001LYS-027THR-2')] = qcdb.Molecule("""
0 1
C        0.83300000   -11.99300000    17.52800000
C        1.25300000   -13.45200000    17.40600000
C        0.60300000   -11.51100000    18.95900000
H        1.57500000   -11.34800000    17.04900000
H       -0.07000000   -11.93600000    16.97100000
H        0.51900000   -14.08500000    17.91600000
H        1.45800000   -11.74200000    19.59500000
H        0.51900000   -10.42600000    18.91200000
H        2.23945400   -13.60232000    17.86894000
H        1.26526300   -13.75208000    16.34779000
H       -0.31347180   -11.94296000    19.38736000
--
0 1
C       -1.80200000   -10.31800000    16.49200000
C       -1.45000000    -9.18600000    15.53600000
H       -1.67100000   -11.28500000    16.01100000
H       -1.24900000   -10.18800000    17.41600000
H       -2.85800000   -10.23400000    16.75700000
H       -1.98600000    -8.28800000    15.84300000
H       -1.73452100    -9.44758700    14.50614000
H       -0.37036460    -8.97980400    15.57925000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001MET-005GLU-1')] = qcdb.Molecule("""
0 1
C       13.26300000    11.60500000     0.31300000
C       13.67500000    10.55100000    -0.70300000
C       11.56800000    10.06100000     1.81800000
S       11.51500000    11.47300000     0.76700000
H       13.88700000    11.53400000     1.20400000
H       13.40200000    12.58200000    -0.14900000
H       12.87700000    10.49300000    -1.44600000
H       13.73300000     9.58100000    -0.20500000
H       12.54700000     9.97700000     2.28600000
H       10.81200000    10.14600000     2.59400000
H       11.38400000     9.16100000     1.23000000
H       14.61536000    10.76172000    -1.23338800
--
0 1
C       14.39300000    14.51200000     1.53100000
C       14.39700000    14.73400000     3.04500000
C       15.07700000    15.62100000     0.74100000
H       14.90100000    13.57300000     1.32300000
H       13.35900000    14.44200000     1.19100000
H       13.99900000    15.72700000     3.25800000
H       14.50400000    16.53500000     0.91800000
H       16.07200000    15.83500000     1.11400000
H       15.41327000    14.63102000     3.45316100
H       13.74728000    13.99115000     3.53084500
H       15.09138000    15.41387000    -0.33922740
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001MET-027VAL-2')] = qcdb.Molecule("""
0 1
C       18.28800000    21.56000000    30.71700000
C       19.91700000    20.25200000    28.65600000
S       18.46200000    21.25200000    28.95400000
H       19.26300000    21.82000000    31.13200000
H       17.95500000    20.63600000    31.19200000
H       19.75400000    19.26300000    29.08400000
H       20.05900000    20.19300000    27.57900000
H       20.78800000    20.71900000    29.11700000
H       17.56954000    22.35893000    30.95265000
--
0 1
C       16.06400000    21.90300000    27.03700000
C       15.47300000    21.89300000    25.64000000
H       17.13800000    21.99900000    26.91500000
H       15.67800000    22.76200000    27.58400000
H       15.81100000    20.99900000    27.59100000
H       14.38700000    21.95200000    25.71100000
H       15.76457000    20.98008000    25.10003000
H       15.85428000    22.78815000    25.12685000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001MET-031VAL-1')] = qcdb.Molecule("""
0 1
C       19.91700000    20.25200000    28.65600000
C       18.28800000    21.56000000    30.71700000
S       18.46200000    21.25200000    28.95400000
H       19.75400000    19.26300000    29.08400000
H       20.05900000    20.19300000    27.57900000
H       20.78800000    20.71900000    29.11700000
H       19.26300000    21.82000000    31.13200000
H       17.95500000    20.63600000    31.19200000
H       17.56954000    22.35893000    30.95265000
--
0 1
C       21.82600000    18.23400000    27.79200000
C       22.67600000    17.37200000    26.90400000
H       21.73500000    17.81400000    28.79500000
H       22.26600000    19.23000000    27.84800000
H       20.84300000    18.27300000    27.32600000
H       22.86200000    17.89500000    25.96600000
H       22.15336000    16.42715000    26.69396000
H       23.62684000    17.21733000    27.43502000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001MET-047GLU-1')] = qcdb.Molecule("""
0 1
C       -5.97900000    -7.59100000    -1.68800000
C       -3.94300000    -7.74800000     0.20500000
S       -4.26400000    -7.81900000    -1.57300000
H       -6.19500000    -6.56800000    -1.99300000
H       -6.37100000    -8.25600000    -2.45800000
H       -6.46400000    -7.83600000    -0.74200000
H       -4.05300000    -8.76100000     0.59500000
H       -4.71100000    -7.18700000     0.70900000
H       -2.94679700    -7.37941200     0.49087310
--
-1 1
C       -6.24300000    -5.12000000     0.61900000
C       -6.30700000    -3.64300000     0.22600000
C       -6.99700000    -5.43000000     1.90300000
O       -7.67600000    -4.52400000     2.44600000
O       -6.90800000    -6.58600000     2.38000000
H       -6.67000000    -5.69600000    -0.18800000
H       -5.18700000    -5.32000000     0.76500000
H       -6.12400000    -3.01300000     1.09800000
H       -7.31700000    -3.43900000    -0.13300000
H       -5.58303800    -3.36710200    -0.55487070
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001PRO-046ASP-1')] = qcdb.Molecule("""
0 1
C        6.11800000    -5.05600000     2.77700000
C        6.16200000    -4.64300000     1.33200000
C        7.55700000    -5.38500000     3.14300000
H        5.48800000    -5.94300000     2.85800000
H        5.72100000    -4.26200000     3.40500000
H        5.22800000    -4.88300000     0.81800000
H        6.33600000    -3.56700000     1.26200000
H        8.04600000    -4.52800000     3.60800000
H        7.01239100    -5.17642000     0.88222460
H        8.02724500    -5.63289300     2.17997400
H        7.56281200    -6.25752200     3.81283000
--
-1 1
C        3.99500000    -3.01100000     5.72500000
C        3.82800000    -2.61000000     4.26300000
O        4.52700000    -1.67800000     3.80000000
O        2.97800000    -3.22300000     3.57800000
H        4.24200000    -4.07100000     5.79300000
H        3.04100000    -2.86500000     6.23600000
H        4.75579900    -2.40840200     6.24274600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '001SER-030GLU-1')] = qcdb.Molecule("""
0 1
C      -23.60600000    11.65500000   -15.36300000
C      -23.95900000    13.09200000   -14.96000000
O      -22.32600000    11.62000000   -15.95100000
H      -23.61900000    11.00400000   -14.48900000
H      -24.34100000    11.28700000   -16.08000000
H      -25.00000000    13.09800000   -14.62700000
H      -22.13600000    10.72400000   -16.25200000
H      -23.87211000    13.78418000   -15.81049000
H      -23.34193000    13.40667000   -14.10548000
--
-1 1
C      -24.96100000     9.19500000   -12.73600000
C      -23.61000000     8.68700000   -12.24500000
C      -26.12800000     8.36600000   -12.27000000
O      -26.01600000     7.69700000   -11.22100000
O      -27.18200000     8.44100000   -12.94000000
H      -25.08900000    10.21100000   -12.35800000
H      -24.95700000     9.26200000   -13.82500000
H      -23.60000000     8.63900000   -11.15600000
H      -22.86300000     9.42200000   -12.54500000
H      -23.31533000     7.71170800   -12.65970000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ALA-101ILE-1')] = qcdb.Molecule("""
0 1
C       23.10500000    -7.41600000    -6.52600000
C       24.39800000    -7.31900000    -5.72200000
H       23.05100000    -8.37400000    -7.04600000
H       22.25000000    -7.32400000    -5.85500000
H       23.06400000    -6.60700000    -7.25700000
H       24.41500000    -6.34700000    -5.22500000
H       25.27519000    -7.39799200    -6.38101800
H       24.41392000    -8.09092700    -4.93849800
--
0 1
C       20.14300000    -9.80400000    -5.84600000
C       20.60100000   -10.87000000    -6.85100000
H       19.20800000   -10.10400000    -5.37200000
H       20.90000000    -9.64400000    -5.07800000
H       20.00200000    -8.84000000    -6.33600000
H       21.53800000   -10.52600000    -7.29400000
H       19.85587000   -10.99562000    -7.65037500
H       20.79730000   -11.83432000    -6.35952500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ARG-006GLU-1')] = qcdb.Molecule("""
1 1
C       12.78700000    35.93500000     8.14300000
C       12.50200000    35.31700000     5.75900000
N       13.33700000    34.30300000     5.87400000
N       12.22000000    36.09300000     6.79800000
N       11.93800000    35.55500000     4.59100000
H       13.73100000    34.01500000     6.77000000
H       13.57300000    33.74600000     5.07200000
H       11.60800000    36.88200000     6.64200000
H       11.31200000    36.33700000     4.47600000
H       12.19300000    35.00900000     3.78400000
H       12.75000000    36.88800000     8.67500000
H       13.83900000    35.65300000     8.06400000
H       12.25752000    35.16852000     8.72794600
--
-1 1
C       13.53600000    30.79600000     8.82500000
C       14.44700000    32.01800000     8.73700000
O       14.55000000    32.59000000     7.62800000
O       15.04100000    32.42200000     9.76000000
H       13.74200000    30.13300000     7.98100000
H       12.50000000    31.12500000     8.73000000
H       13.65603000    30.21526000     9.75146000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ARG-020PRO-1')] = qcdb.Molecule("""
1 1
C       26.21800000    -6.75200000    -1.34900000
C       26.72900000    -8.67100000    -2.85800000
N       26.68000000    -8.11300000    -1.65100000
N       26.32700000    -8.02300000    -3.94000000
N       27.18100000    -9.90400000    -2.97700000
H       27.03100000    -8.66000000    -0.87800000
H       26.00900000    -7.07300000    -3.85900000
H       26.37400000    -8.46000000    -4.84600000
H       27.54900000   -10.40300000    -2.18300000
H       27.23200000   -10.33500000    -3.88700000
H       25.53300000    -6.38500000    -2.11500000
H       27.09100000    -6.09700000    -1.31800000
H       25.69543000    -6.72252900    -0.38149960
--
0 1
C       24.70500000   -11.04100000    -1.03900000
C       24.12600000   -11.75800000     0.16300000
C       24.00400000   -11.75700000    -2.21200000
H       25.78500000   -11.16700000    -1.07300000
H       24.42900000    -9.98600000    -1.02100000
H       24.66200000   -12.69100000     0.34600000
H       24.17400000   -11.10100000     1.03300000
H       24.50700000   -12.70800000    -2.40300000
H       24.00400000   -11.14300000    -3.11400000
H       23.09299000   -11.97402000    -0.14720200
H       22.98262000   -11.93213000    -1.84306900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ARG-046LEU-1')] = qcdb.Molecule("""
1 1
C       12.78700000    35.93500000     8.14300000
C       12.50200000    35.31700000     5.75900000
N       12.22000000    36.09300000     6.79800000
N       11.93800000    35.55500000     4.59100000
N       13.33700000    34.30300000     5.87400000
H       11.60800000    36.88200000     6.64200000
H       11.31200000    36.33700000     4.47600000
H       12.19300000    35.00900000     3.78400000
H       13.73100000    34.01500000     6.77000000
H       13.57300000    33.74600000     5.07200000
H       12.75000000    36.88800000     8.67500000
H       13.83900000    35.65300000     8.06400000
H       12.25752000    35.16852000     8.72794600
--
0 1
C        9.45500000    33.07000000     6.37300000
C        9.90700000    32.25100000     5.16900000
H        8.98300000    32.42100000     7.11100000
H       10.31600000    33.55700000     6.81900000
H        8.75300000    33.84200000     6.06100000
H       10.41000000    32.92000000     4.47300000
H        9.06295300    31.76234000     4.66027900
H       10.64400000    31.49088000     5.46741200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ASN-022GLU-1')] = qcdb.Molecule("""
0 1
C       16.23900000    -0.43400000    15.85100000
C       16.79700000    -0.32200000    14.44100000
O       17.80400000     0.33900000    14.17600000
N       16.13000000    -0.98200000    13.51400000
H       16.46500000    -0.90800000    12.56000000
H       15.31000000    -1.53100000    13.76000000
H       15.93100000    -1.46600000    16.02900000
H       15.33100000     0.15900000    15.90800000
H       16.94653000    -0.12778770    16.63562000
--
-1 1
C       12.22300000    -1.08900000    15.37300000
C       12.46200000    -2.45300000    14.74400000
O       13.60500000    -2.66200000    14.27700000
O       11.54900000    -3.30900000    14.72000000
H       12.50400000    -0.33100000    14.64000000
H       12.87300000    -0.97400000    16.24400000
H       11.18183000    -0.92854030    15.68956000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ASN-026ASP-2')] = qcdb.Molecule("""
0 1
C       16.23900000    -0.43400000    15.85100000
C       16.79700000    -0.32200000    14.44100000
O       17.80400000     0.33900000    14.17600000
N       16.13000000    -0.98200000    13.51400000
H       16.46500000    -0.90800000    12.56000000
H       15.31000000    -1.53100000    13.76000000
H       15.93100000    -1.46600000    16.02900000
H       15.33100000     0.15900000    15.90800000
H       16.94653000    -0.12778770    16.63562000
--
-1 1
C       19.91000000    -0.15800000    11.13500000
C       18.56500000    -0.72300000    10.65200000
O       17.50600000    -0.07100000    10.80000000
O       18.56900000    -1.86300000    10.14200000
H       20.72200000    -0.61400000    10.56500000
H       20.04900000    -0.43100000    12.18200000
H       19.99575000     0.93464930    11.04139000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002ASP-145HIE-1')] = qcdb.Molecule("""
-1 1
C       33.26400000    26.56300000     7.35500000
C       31.73400000    26.42300000     7.36500000
O       31.17500000    25.51700000     8.04700000
O       31.09400000    27.23700000     6.65700000
H       33.54500000    27.61100000     7.47300000
H       33.62400000    26.22300000     6.38200000
H       33.75126000    25.96578000     8.13979500
--
0 1
C       31.75800000    23.69900000     5.00100000
C       31.64000000    22.33700000     5.71000000
C       30.91000000    23.83900000     3.76000000
C       29.77600000    24.56400000     3.54000000
C       30.28800000    23.52800000     1.67000000
N       31.20700000    23.19200000     2.57300000
N       29.40700000    24.35100000     2.22400000
H       31.46200000    24.48100000     5.68800000
H       32.79600000    23.87500000     4.71900000
H       31.95900000    21.58100000     5.00000000
H       29.27200000    25.19200000     4.26300000
H       30.22800000    23.18800000     0.66400000
H       28.61300000    24.76800000     1.74800000
H       30.59303000    22.17390000     6.00537700
H       32.31167000    22.31799000     6.58091800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LEU-005GLN-1')] = qcdb.Molecule("""
0 1
C       43.37900000    37.00500000     0.00300000
C       42.05200000    37.35000000    -0.67800000
C       44.11200000    38.16400000     0.68100000
H       43.17900000    36.23700000     0.75300000
H       44.04200000    36.57200000    -0.74200000
H       42.24300000    38.10400000    -1.44300000
H       43.41300000    38.72800000     1.29800000
H       41.33514000    37.73212000     0.06368265
H       41.65713000    36.44857000    -1.16942700
H       44.89359000    37.76960000     1.34700900
H       44.54177000    38.84297000    -0.07019828
--
0 1
C       44.61500000    33.52500000    -0.49600000
C       45.02200000    32.05300000    -0.35700000
C       45.77400000    34.41000000    -0.94700000
O       45.74600000    35.06400000    -1.99500000
N       46.82700000    34.41900000    -0.15800000
H       43.78000000    33.63100000    -1.18800000
H       44.27500000    33.87700000     0.47800000
H       44.16400000    31.49300000     0.01600000
H       45.81400000    31.97000000     0.38700000
H       47.62000000    34.98700000    -0.42100000
H       46.82400000    33.91800000     0.71900000
H       45.34932000    31.61849000    -1.31306600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LEU-006GLN-1')] = qcdb.Molecule("""
0 1
C       19.92200000    73.71400000     8.26500000
C       18.86600000    74.81800000     8.37200000
H       20.80900000    74.10400000     7.76500000
H       20.20800000    73.37700000     9.25800000
H       19.54000000    72.86200000     7.70600000
H       17.96600000    74.36700000     8.78000000
H       18.63845000    75.28511000     7.40244800
H       19.13534000    75.55165000     9.14608800
--
0 1
C       18.24500000    70.49700000     9.77600000
C       18.13300000    71.58100000    10.79900000
O       17.02500000    72.02000000    11.12100000
N       19.26000000    72.02100000    11.33400000
H       19.07300000    69.83000000    10.02100000
H       18.41400000    70.94000000     8.79500000
H       19.21100000    72.74100000    12.04100000
H       20.14700000    71.62400000    11.06000000
H       17.29604000    69.94146000     9.80500400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LEU-153PHE-1')] = qcdb.Molecule("""
0 1
C       29.29000000    33.27600000    56.95100000
C       29.40200000    32.34800000    58.16900000
C       29.56200000    34.72000000    57.36200000
C       30.28900000    32.83800000    55.88500000
H       28.29300000    33.19700000    56.53200000
H       30.43100000    32.38900000    58.53200000
H       29.22000000    31.32400000    57.83200000
H       30.51800000    34.80200000    57.87800000
H       29.58200000    35.35100000    56.47300000
H       28.76100000    35.08500000    58.00400000
H       30.08700000    31.81000000    55.58300000
H       30.19700000    33.48400000    55.01200000
H       31.30300000    32.90800000    56.27500000
H       28.73509000    32.55932000    59.01786000
--
0 1
C       25.89500000    38.47800000    56.15400000
C       26.51700000    34.84700000    55.23800000
C       27.01300000    34.96300000    53.93800000
C       26.17200000    35.99100000    55.95800000
C       26.31000000    37.25500000    55.38800000
C       27.15800000    36.22700000    53.36100000
C       26.80700000    37.36800000    54.08700000
H       26.38000000    33.87100000    55.68100000
H       27.28200000    34.07400000    53.38900000
H       25.79900000    35.88700000    56.96500000
H       27.53500000    36.33300000    52.35500000
H       26.62500000    39.26700000    55.96100000
H       25.92200000    38.25800000    57.22100000
H       26.91900000    38.34100000    53.63100000
H       24.89232000    38.84843000    55.89434000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LEU-163LEU-1')] = qcdb.Molecule("""
0 1
C       29.56200000    34.72000000    57.36200000
C       29.29000000    33.27600000    56.95100000
H       30.51800000    34.80200000    57.87800000
H       29.58200000    35.35100000    56.47300000
H       28.76100000    35.08500000    58.00400000
H       28.29300000    33.19700000    56.53200000
H       29.37024000    32.61113000    57.82364000
H       30.01050000    32.96010000    56.18218000
--
0 1
C       28.83000000    38.01300000    58.52900000
C       29.07400000    39.38700000    59.14000000
H       28.24800000    37.39500000    59.20800000
H       28.28900000    38.12300000    57.59100000
H       29.75500000    37.50900000    58.28100000
H       29.87600000    39.87600000    58.58700000
H       29.35675000    39.30826000    60.20012000
H       28.16947000    40.00828000    59.06360000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-006GLU-2')] = qcdb.Molecule("""
0 1
C       38.25800000    14.04500000    -6.93600000
C       38.02300000    12.77800000    -7.76000000
C       39.58200000    14.09700000    -6.18600000
H       38.19600000    14.90800000    -7.60300000
H       37.45600000    14.15100000    -6.20800000
H       38.22400000    11.91700000    -7.13000000
H       39.61800000    13.25800000    -5.49000000
H       40.40800000    14.01100000    -6.89300000
H       38.69955000    12.74568000    -8.62673700
H       36.96844000    12.75201000    -8.07182000
H       39.66614000    15.04914000    -5.64161400
--
0 1
C       36.32600000    12.67100000    -3.89700000
C       35.39400000    13.56400000    -3.07700000
C       36.03400000    11.18900000    -3.71500000
H       36.20500000    12.91900000    -4.94400000
H       37.35900000    12.86700000    -3.60800000
H       35.48400000    13.29000000    -2.02400000
H       36.22300000    11.02000000    -2.65100000
H       35.00700000    10.88800000    -3.77600000
H       34.35307000    13.44096000    -3.41064200
H       35.69280000    14.61774000    -3.17876500
H       36.74146000    10.54453000    -4.25736500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-007ILE-1')] = qcdb.Molecule("""
0 1
C       38.25800000    14.04500000    -6.93600000
C       38.02300000    12.77800000    -7.76000000
C       39.58200000    14.09700000    -6.18600000
H       38.19600000    14.90800000    -7.60300000
H       37.45600000    14.15100000    -6.20800000
H       38.22400000    11.91700000    -7.13000000
H       39.61800000    13.25800000    -5.49000000
H       40.40800000    14.01100000    -6.89300000
H       38.69955000    12.74568000    -8.62673700
H       36.96844000    12.75201000    -8.07182000
H       39.66614000    15.04914000    -5.64161400
--
0 1
C       35.82600000    16.98200000    -6.95700000
C       35.04900000    17.61700000    -5.79700000
C       35.23500000    17.26900000    -8.32800000
H       36.85100000    17.35700000    -6.94100000
H       35.88500000    15.90800000    -6.83600000
H       34.00100000    17.33700000    -5.88300000
H       35.20800000    18.33200000    -8.55200000
H       35.84000000    16.77200000    -9.08700000
H       34.22100000    16.87200000    -8.37800000
H       35.45189000    17.25190000    -4.84076400
H       35.11367000    18.71425000    -5.84011400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-035GLU-1')] = qcdb.Molecule("""
1 1
C        9.12400000    -6.69000000    22.74000000
N        7.96000000    -6.55600000    21.83900000
H        8.24600000    -6.67200000    20.86300000
H        7.55700000    -5.63000000    21.88900000
H        7.23800000    -7.23200000    22.05200000
H        9.98100000    -6.18400000    22.28300000
H        9.39500000    -7.74000000    22.88700000
H        8.91513100    -6.21360700    23.70924000
--
-1 1
C        7.94600000    -5.10700000    17.09700000
C        8.50600000    -4.90000000    18.49100000
O        8.70700000    -5.93000000    19.18500000
O        8.79900000    -3.80300000    18.99700000
H        7.01700000    -5.67000000    17.22000000
H        8.63000000    -5.78900000    16.58600000
H        7.71577100    -4.32219300    16.36142000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-075ASN-1')] = qcdb.Molecule("""
1 1
C       14.83300000     3.79800000     9.75100000
N       13.43900000     3.33900000     9.45800000
H       12.92200000     3.15800000    10.31300000
H       12.93700000     4.03000000     8.90900000
H       13.44800000     2.47700000     8.92300000
H       14.79000000     4.78100000    10.23100000
H       15.39100000     3.91100000     8.81500000
H       15.38525000     3.11239400    10.41052000
--
0 1
C        9.92500000     2.36100000    12.12200000
C       11.05200000     1.41000000    12.34100000
O       11.99500000     1.57800000    11.58200000
N       11.02400000     0.50400000    13.33600000
H        9.17400000     2.18700000    12.89600000
H        9.46500000     2.13600000    11.15900000
H       11.79600000    -0.14200000    13.42300000
H       10.20600000     0.41800000    13.91900000
H       10.22777000     3.41790600    12.15774000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-080ARG-1')] = qcdb.Molecule("""
0 1
C      -31.36600000     2.81400000     0.65000000
C      -32.88000000     2.90800000     0.83000000
C      -30.58500000     2.97400000     1.95500000
H      -31.13700000     1.84400000     0.20300000
H      -31.03800000     3.59300000    -0.03800000
H      -33.09900000     3.87700000     1.28900000
H      -30.52300000     4.03400000     2.20600000
H      -31.08600000     2.45500000     2.77100000
H      -33.23019000     2.09616400     1.48443900
H      -33.39110000     2.88414400    -0.14376070
H      -29.57575000     2.54897500     1.85126500
--
0 1
C      -29.00800000     3.20300000    -2.08400000
C      -28.11900000     4.08700000    -2.95100000
C      -28.78400000     1.73900000    -2.36900000
H      -28.82200000     3.43100000    -1.04100000
H      -30.05500000     3.41400000    -2.30600000
H      -28.01900000     3.63500000    -3.93300000
H      -27.12900000     4.16600000    -2.50700000
H      -29.50500000     1.15500000    -1.79100000
H      -28.97100000     1.56800000    -3.43100000
H      -28.56727000     5.08098400    -3.09609100
H      -27.76497000     1.43720500    -2.08526800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002LYS-082TYR-1')] = qcdb.Molecule("""
1 1
C      -28.33700000     2.62900000     3.05400000
C      -29.18400000     2.38400000     1.81100000
N      -27.04700000     1.89200000     2.98100000
H      -28.16000000     3.70500000     3.16200000
H      -28.90100000     2.29500000     3.93200000
H      -29.27000000     1.30900000     1.63400000
H      -28.67400000     2.84400000     0.96900000
H      -26.48100000     2.19800000     2.19800000
H      -26.50100000     2.04000000     3.82300000
H      -27.19400000     0.89300000     2.89700000
H      -30.19325000     2.80902500     1.91473500
--
0 1
C      -32.24100000     7.09500000     4.17800000
C      -30.51500000     3.55800000     5.89500000
C      -31.87300000     3.59500000     5.60600000
C      -29.71100000     4.66300000     5.62800000
C      -32.42300000     4.74500000     5.05000000
C      -30.26900000     5.80900000     5.07100000
C      -31.62900000     5.85800000     4.77500000
O      -29.96700000     2.43700000     6.43900000
H      -32.49900000     2.74000000     5.81800000
H      -30.62900000     1.75300000     6.59900000
H      -28.65600000     4.62600000     5.86400000
H      -33.48400000     4.77500000     4.83000000
H      -29.64000000     6.66800000     4.87000000
H      -31.58100000     7.95200000     4.32300000
H      -33.15500000     7.29900000     4.73800000
H      -32.49716000     6.99470100     3.11295400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002MET-031TYR-1')] = qcdb.Molecule("""
0 1
C        9.63600000    13.40900000    22.43500000
C        7.46100000    14.39900000    23.84900000
S        8.59900000    13.00100000    23.84100000
H       10.36800000    14.15600000    22.73300000
H       10.16900000    12.51600000    22.11000000
H        9.03100000    13.78400000    21.61100000
H        6.76500000    14.28600000    24.67900000
H        6.88500000    14.37500000    22.92400000
H        7.96469800    15.37464000    23.91539000
--
0 1
C       10.84000000    16.17500000    20.65000000
C       12.28700000    16.62700000    20.42800000
C        9.77700000    17.11200000    20.12900000
C        9.28200000    18.13100000    20.93500000
C        9.24700000    16.94900000    18.85000000
C        8.30100000    18.99400000    20.46600000
C        8.26100000    17.80800000    18.37300000
C        7.78800000    18.82900000    19.18500000
O        6.82400000    19.67900000    18.74400000
H       10.69800000    15.19000000    20.19900000
H       10.68800000    16.07300000    21.72300000
H       12.41600000    17.61900000    20.85100000
H        9.66300000    18.25800000    21.93800000
H        9.61300000    16.15200000    18.21500000
H        7.93400000    19.78700000    21.10200000
H        7.84900000    17.68400000    17.38300000
H        6.62700000    20.36900000    19.38200000
H       12.53267000    16.64503000    19.35594000
H       12.93573000    15.92088000    20.96703000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002MET-050ALA-1')] = qcdb.Molecule("""
0 1
C        7.46100000    14.39900000    23.84900000
C        8.15900000    15.75100000    23.94100000
C        9.63600000    13.40900000    22.43500000
S        8.59900000    13.00100000    23.84100000
H        6.76500000    14.28600000    24.67900000
H        6.88500000    14.37500000    22.92400000
H        7.37300000    16.49600000    23.89800000
H        8.79800000    15.90400000    23.07400000
H       10.36800000    14.15600000    22.73300000
H       10.16900000    12.51600000    22.11000000
H        9.03100000    13.78400000    21.61100000
H        8.73769400    15.90212000    24.86419000
--
0 1
C        4.26800000    12.80900000    24.93700000
C        3.21900000    13.15400000    23.87800000
H        5.12100000    12.30600000    24.47700000
H        4.60600000    13.72300000    25.42800000
H        3.83000000    12.15100000    25.69100000
H        2.40500000    13.68900000    24.37200000
H        2.81026100    12.24376000    23.41496000
H        3.64274400    13.82235000    23.11397000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002TRP-012VAL-1')] = qcdb.Molecule("""
0 1
C       -2.86700000    22.24300000    31.54500000
C       -0.26000000    22.64100000    31.08800000
C       -1.63200000    22.47900000    30.65600000
C        0.51900000    22.81900000    29.92200000
C       -1.59300000    22.57300000    29.28100000
C        1.81300000    22.90500000    32.37400000
C        2.52100000    23.05300000    31.19900000
C        0.40500000    22.64700000    32.33500000
C        1.88000000    23.03500000    29.97100000
N       -0.32200000    22.80700000    28.85100000
H        2.32200000    22.98700000    33.32000000
H        3.58700000    23.22100000    31.23900000
H       -0.16100000    22.49600000    33.23900000
H        2.43800000    23.17900000    29.05700000
H       -3.67900000    22.87400000    31.19300000
H       -2.62600000    22.53900000    32.56700000
H       -2.46200000    22.48300000    28.63900000
H       -0.04000000    22.85100000    27.87400000
H       -3.22889800    21.20432000    31.53146000
--
0 1
C        3.60100000    21.35200000    35.00300000
C        4.33400000    20.26900000    34.17100000
H        3.77400000    21.18300000    36.06700000
H        3.99200000    22.33600000    34.73800000
H        2.53000000    21.33100000    34.80700000
H        4.09000000    20.43900000    33.12200000
H        3.98926900    19.26466000    34.45816000
H        5.42792700    20.33037000    34.26876000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002TRP-138SER-2')] = qcdb.Molecule("""
0 1
C       -2.86700000    22.24300000    31.54500000
C       -1.59300000    22.57300000    29.28100000
C        0.51900000    22.81900000    29.92200000
C       -1.63200000    22.47900000    30.65600000
C       -0.26000000    22.64100000    31.08800000
C        1.88000000    23.03500000    29.97100000
C        2.52100000    23.05300000    31.19900000
C        0.40500000    22.64700000    32.33500000
C        1.81300000    22.90500000    32.37400000
N       -0.32200000    22.80700000    28.85100000
H       -0.04000000    22.85100000    27.87400000
H       -2.46200000    22.48300000    28.63900000
H        2.43800000    23.17900000    29.05700000
H       -3.67900000    22.87400000    31.19300000
H       -2.62600000    22.53900000    32.56700000
H        3.58700000    23.22100000    31.23900000
H       -0.16100000    22.49600000    33.23900000
H        2.32200000    22.98700000    33.32000000
H       -3.22889800    21.20432000    31.53146000
--
0 1
C       -0.55900000    21.70600000    25.55300000
O        0.46100000    22.51300000    26.13500000
H        0.87200000    23.05500000    25.43100000
H       -1.03200000    21.14500000    26.36100000
H       -0.10600000    20.98100000    24.87500000
H       -1.34638200    22.26201000    25.02302000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002TRP-139LEU-1')] = qcdb.Molecule("""
0 1
C       -2.86700000    22.24300000    31.54500000
C        0.51900000    22.81900000    29.92200000
C       -0.26000000    22.64100000    31.08800000
C       -1.63200000    22.47900000    30.65600000
C       -1.59300000    22.57300000    29.28100000
C        1.88000000    23.03500000    29.97100000
C        2.52100000    23.05300000    31.19900000
C        0.40500000    22.64700000    32.33500000
C        1.81300000    22.90500000    32.37400000
N       -0.32200000    22.80700000    28.85100000
H       -0.04000000    22.85100000    27.87400000
H        2.43800000    23.17900000    29.05700000
H       -2.46200000    22.48300000    28.63900000
H        3.58700000    23.22100000    31.23900000
H       -0.16100000    22.49600000    33.23900000
H       -3.67900000    22.87400000    31.19300000
H       -2.62600000    22.53900000    32.56700000
H        2.32200000    22.98700000    33.32000000
H       -3.22889800    21.20432000    31.53146000
--
0 1
C        0.51200000    26.21700000    28.40000000
C        0.85800000    26.18900000    26.93100000
H       -0.35900000    25.59700000    28.59900000
H        1.34500000    25.81600000    28.97700000
H        0.31400000    27.23900000    28.72700000
H        0.99700000    25.16000000    26.61300000
H        0.06404668    26.69162000    26.35915000
H        1.79437900    26.74258000    26.76746000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002VAL-009TRP-1')] = qcdb.Molecule("""
0 1
C        7.72200000    -8.33900000     8.55900000
C        7.94600000    -7.19400000     7.57600000
H        7.92400000    -9.30300000     8.09200000
H        8.36700000    -8.18700000     9.42100000
H        6.70200000    -8.30200000     8.91600000
H        7.63400000    -6.26400000     8.05000000
H        7.36210700    -7.36000200     6.65866000
H        9.01192700    -7.10203500     7.32038000
--
0 1
C        5.97300000   -11.79500000    10.86800000
C        4.33900000    -9.83300000    11.39500000
C        5.01000000   -11.05800000    11.72600000
C        3.49700000    -9.50400000    12.48900000
C        4.55400000   -11.42600000    12.95100000
C        4.37000000    -8.97800000    10.28700000
C        3.58000000    -7.83300000    10.29700000
C        2.75700000    -7.53300000    11.39500000
C        2.70900000    -8.36200000    12.50400000
N        3.65000000   -10.49800000    13.41700000
H        4.94700000    -9.25000000     9.42000000
H        3.58600000    -7.16800000     9.44200000
H        2.14900000    -6.63700000    11.37300000
H        6.60100000   -12.43900000    11.48700000
H        6.61800000   -11.06900000    10.37200000
H        4.86000000   -12.32200000    13.48400000
H        3.18600000   -10.55700000    14.31800000
H        2.07500000    -8.13300000    13.35000000
H        5.45357200   -12.39667000    10.10761000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002VAL-042PHE-1')] = qcdb.Molecule("""
0 1
C        1.16300000    -5.37100000     2.47100000
C        1.87900000    -6.69000000     2.25400000
H        0.08800000    -5.52500000     2.43500000
H        1.40200000    -4.98200000     3.46000000
H        1.48100000    -4.64400000     1.72600000
H        1.48000000    -7.40500000     2.97400000
H        1.71041300    -7.07308700     1.23673800
H        2.95287100    -6.56019100     2.45387600
--
0 1
C        2.22100000    -0.94100000     5.47700000
C        3.38800000    -2.70200000     4.08100000
C        3.09400000    -1.35600000     4.31900000
C        4.23900000    -3.06300000     3.04300000
C        3.67200000    -0.38700000     3.49300000
C        4.79700000    -2.09700000     2.23000000
C        4.52900000    -0.76100000     2.45200000
H        2.97100000    -3.46700000     4.72100000
H        4.50100000    -4.09500000     2.88900000
H        2.72200000    -0.13000000     6.00600000
H        2.12500000    -1.77400000     6.17300000
H        3.47400000     0.65800000     3.66900000
H        5.46000000    -2.38000000     1.42500000
H        4.97500000    -0.00400000     1.82300000
H        1.21942100    -0.59997610     5.17609700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002VAL-042PHE-2')] = qcdb.Molecule("""
0 1
C        3.33500000    -6.51400000     2.52500000
C        1.87900000    -6.69000000     2.25400000
H        3.78700000    -5.87900000     1.76200000
H        3.47300000    -6.06500000     3.50900000
H        3.84600000    -7.47700000     2.53900000
H        1.48000000    -7.40500000     2.97400000
H        1.71041300    -7.07308700     1.23673800
H        1.35961600    -5.73320200     2.41141100
--
0 1
C        2.22100000    -0.94100000     5.47700000
C        4.23900000    -3.06300000     3.04300000
C        4.79700000    -2.09700000     2.23000000
C        3.38800000    -2.70200000     4.08100000
C        3.09400000    -1.35600000     4.31900000
C        4.52900000    -0.76100000     2.45200000
C        3.67200000    -0.38700000     3.49300000
H        4.50100000    -4.09500000     2.88900000
H        5.46000000    -2.38000000     1.42500000
H        2.97100000    -3.46700000     4.72100000
H        4.97500000    -0.00400000     1.82300000
H        2.72200000    -0.13000000     6.00600000
H        2.12500000    -1.77400000     6.17300000
H        3.47400000     0.65800000     3.66900000
H        1.21942100    -0.59997610     5.17609700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002VAL-043HIE-2')] = qcdb.Molecule("""
0 1
C        1.16300000    -5.37100000     2.47100000
C        1.87900000    -6.69000000     2.25400000
H        0.08800000    -5.52500000     2.43500000
H        1.40200000    -4.98200000     3.46000000
H        1.48100000    -4.64400000     1.72600000
H        1.48000000    -7.40500000     2.97400000
H        1.71041300    -7.07308700     1.23673800
H        2.95287100    -6.56019100     2.45387600
--
0 1
C       -1.63900000    -4.55600000     5.76900000
C       -0.47900000    -5.50900000     5.92900000
C       -0.40700000    -6.84500000     5.68300000
C        1.57000000    -6.18400000     6.39400000
N        0.77400000    -5.11900000     6.37200000
N        0.87900000    -7.24200000     5.98600000
H       -1.84100000    -4.05300000     6.71600000
H       -2.51900000    -5.14700000     5.50800000
H       -1.21400000    -7.47200000     5.32300000
H        2.61200000    -6.18900000     6.69600000
H        1.24700000    -8.18500000     5.91700000
H       -1.45947900    -3.82061400     4.97089000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '002VAL-046SER-1')] = qcdb.Molecule("""
0 1
C        1.16300000    -5.37100000     2.47100000
C        1.87900000    -6.69000000     2.25400000
H        0.08800000    -5.52500000     2.43500000
H        1.40200000    -4.98200000     3.46000000
H        1.48100000    -4.64400000     1.72600000
H        1.48000000    -7.40500000     2.97400000
H        1.71041300    -7.07308700     1.23673800
H        2.95287100    -6.56019100     2.45387600
--
0 1
C       -0.93000000    -3.60500000     0.35200000
C       -1.62000000    -2.49700000    -0.34800000
O       -1.78400000    -4.32700000     1.18300000
H       -0.96900000    -3.92700000    -0.66900000
H        0.03400000    -3.30800000     0.76500000
H       -0.97900000    -2.11000000    -1.13900000
H       -2.21100000    -3.79000000     1.88700000
H       -1.77867100    -1.68076000     0.37212200
H       -2.54746800    -2.84533500    -0.82598090
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003ALA-007THR-1')] = qcdb.Molecule("""
0 1
C       37.32000000    22.75400000     7.19300000
C       37.11100000    24.24600000     7.04200000
H       36.71800000    22.21400000     6.46100000
H       38.36900000    22.51100000     7.06000000
H       37.02500000    22.43900000     8.19600000
H       37.78800000    24.74800000     7.73300000
H       36.07128000    24.47621000     7.31764400
H       37.34721000    24.56312000     6.01552900
--
0 1
C       38.95700000    20.40300000     5.10000000
C       39.18900000    19.42000000     3.94500000
C       39.26900000    19.75700000     6.46000000
O       39.79900000    21.54200000     4.90900000
H       37.91700000    20.73400000     5.09800000
H       40.24100000    19.12700000     3.93500000
H       40.20700000    19.20200000     6.41000000
H       39.36900000    20.52300000     7.22700000
H       38.46100000    19.09100000     6.75500000
H       39.37000000    22.11000000     4.24100000
H       38.91352000    19.88015000     2.98459600
H       38.55489000    18.53953000     4.12575900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003GLU-006GLN-2')] = qcdb.Molecule("""
-1 1
C       33.57700000    10.20600000    28.09000000
C       32.57000000    11.12900000    27.41000000
C       34.99200000    10.73800000    28.09500000
O       35.18200000    11.93900000    27.79800000
O       35.91200000     9.94300000    28.39600000
H       33.24300000     9.93800000    29.09600000
H       33.67600000     9.33800000    27.49000000
H       33.06500000    11.66400000    26.59800000
H       32.16900000    11.85400000    28.11900000
H       31.76327000    10.53735000    26.95269000
--
0 1
C       32.36100000     6.94700000    27.19700000
C       32.19400000     5.95600000    28.34300000
C       33.69400000     6.74400000    26.55100000
O       34.24100000     7.68900000    26.00000000
N       34.16500000     5.50700000    26.64300000
H       31.60100000     6.87700000    26.42000000
H       32.40000000     7.90000000    27.63100000
H       32.14400000     6.60300000    29.22100000
H       33.00600000     5.28100000    28.60400000
H       35.07000000     5.31300000    26.23500000
H       33.64400000     4.77100000    27.08700000
H       31.24674000     5.39823300    28.30311000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003ILE-062ILE-1')] = qcdb.Molecule("""
0 1
C        5.87800000   -18.21400000     3.77200000
C        6.15500000   -16.74500000     3.47900000
H        5.45700000   -18.68300000     2.88700000
H        6.81900000   -18.71100000     4.00700000
H        5.21600000   -18.31200000     4.63300000
H        6.60700000   -16.64100000     2.49100000
H        6.86000000   -16.38500000     4.22900000
H        5.21716200   -16.17295000     3.53577300
--
0 1
C        7.66400000   -19.75600000     1.35300000
C        6.99100000   -20.41400000     0.14700000
H        8.74800000   -19.77200000     1.23500000
H        7.34000000   -18.72700000     1.47300000
H        7.40200000   -20.27600000     2.27400000
H        5.91000000   -20.35700000     0.27300000
H        7.29119400   -21.46971000     0.07374686
H        7.26745100   -19.87905000    -0.77354510
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003ILE-065SER-1')] = qcdb.Molecule("""
0 1
C        5.87800000   -18.21400000     3.77200000
C        6.15500000   -16.74500000     3.47900000
H        5.45700000   -18.68300000     2.88700000
H        6.81900000   -18.71100000     4.00700000
H        5.21600000   -18.31200000     4.63300000
H        6.60700000   -16.64100000     2.49100000
H        6.86000000   -16.38500000     4.22900000
H        5.21716200   -16.17295000     3.53577300
--
0 1
C        3.52300000   -20.49500000     3.32400000
C        2.89800000   -21.74300000     3.93700000
O        3.94400000   -20.74300000     1.99300000
H        2.79100000   -19.68700000     3.32300000
H        4.36700000   -20.21400000     3.94300000
H        2.24700000   -21.44900000     4.76200000
H        4.63900000   -21.42800000     2.01000000
H        3.68305000   -22.42489000     4.29577200
H        2.28776500   -22.24762000     3.17347300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003ILE-067TYR-1')] = qcdb.Molecule("""
0 1
C        3.83800000   -16.56000000     2.58000000
C        4.85000000   -15.94900000     3.55800000
H        4.27200000   -16.63600000     1.58200000
H        3.51400000   -17.54400000     2.91200000
H        2.93800000   -15.96100000     2.51500000
H        4.44700000   -16.04300000     4.56900000
H        5.01695200   -14.88137000     3.35235600
H        5.78783800   -16.52105000     3.50122700
--
0 1
C        2.67500000   -18.64400000    -0.54700000
C        0.88500000   -17.88100000     1.05300000
C        1.55600000   -17.71300000    -0.15300000
C       -0.14800000   -17.02600000     1.41000000
C       -0.53500000   -16.00200000     0.54500000
C        1.16100000   -16.68800000    -1.01400000
C        0.11500000   -15.82800000    -0.67800000
O       -1.54600000   -15.18200000     0.92900000
H        1.18800000   -18.66500000     1.73200000
H       -0.64400000   -17.15100000     2.36200000
H        3.33800000   -18.79600000     0.30400000
H        3.26500000   -18.15000000    -1.32000000
H        1.67200000   -16.55400000    -1.95600000
H       -1.82500000   -15.38200000     1.82600000
H       -0.17800000   -15.03200000    -1.34300000
H        2.31743100   -19.61383000    -0.92327500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003LEU-033LEU-1')] = qcdb.Molecule("""
0 1
C       20.98100000    10.21000000     7.11300000
C       19.57800000    10.57800000     6.64900000
H       21.66100000    11.02900000     6.88300000
H       20.98300000    10.04400000     8.18700000
H       21.32200000     9.30500000     6.60900000
H       19.28100000    11.50100000     7.14400000
H       19.60592000    10.73552000     5.56069500
H       18.86669000     9.78469300     6.92230600
--
0 1
C       21.05400000    13.00600000     9.28200000
C       22.29300000    13.50200000    10.01500000
H       21.16000000    13.16700000     8.20800000
H       20.91600000    11.94600000     9.48800000
H       20.17600000    13.54300000     9.64200000
H       22.17000000    13.28900000    11.07500000
H       22.40749000    14.58605000     9.86759800
H       23.18815000    12.97295000     9.65608000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003LEU-054LEU-1')] = qcdb.Molecule("""
0 1
C       20.98100000    10.21000000     7.11300000
C       19.57800000    10.57800000     6.64900000
H       21.66100000    11.02900000     6.88300000
H       20.98300000    10.04400000     8.18700000
H       21.32200000     9.30500000     6.60900000
H       19.28100000    11.50100000     7.14400000
H       19.60592000    10.73552000     5.56069500
H       18.86669000     9.78469300     6.92230600
--
0 1
C       21.81800000     7.12100000     9.27600000
C       22.37800000     8.01000000    10.38100000
H       21.19400000     6.33500000     9.70300000
H       21.21100000     7.71200000     8.59400000
H       22.63600000     6.67200000     8.71200000
H       22.99100000     8.78600000     9.93100000
H       22.98360000     7.39076200    11.05908000
H       21.55284000     8.48894200    10.92847000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003LYS-055LEU-1')] = qcdb.Molecule("""
0 1
C        4.58000000   -10.01600000    -1.64400000
C        4.18800000    -9.82700000    -0.18200000
C        5.38100000   -11.29100000    -1.87200000
H        3.67100000   -10.05800000    -2.24700000
H        5.16600000    -9.16200000    -1.97600000
H        3.59100000   -10.70000000     0.10400000
H        6.29900000   -11.26800000    -1.28500000
H        4.74800000   -12.10700000    -1.52200000
H        3.58720500    -8.91215200    -0.07200589
H        5.07152300    -9.78293200     0.47179270
H        5.65019500   -11.45539000    -2.92580800
--
0 1
C        6.84000000    -7.21200000    -2.96900000
C        7.75100000    -6.02500000    -2.61100000
H        5.82100000    -7.01500000    -2.64900000
H        6.83600000    -7.35900000    -4.05000000
H        7.20900000    -8.11500000    -2.48500000
H        7.28500000    -5.12500000    -3.01200000
H        7.87646300    -5.88089700    -1.52772100
H        8.72418000    -6.12955100    -3.11298600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003PRO-025ALA-1')] = qcdb.Molecule("""
0 1
C      -16.72000000     2.95000000   -17.44300000
C      -16.57500000     4.21000000   -18.23900000
C      -15.52000000     2.42200000   -19.48600000
C      -17.15000000     0.15800000   -16.87800000
C      -16.40400000     0.58000000   -18.13300000
O      -15.97300000    -0.28400000   -18.90400000
N      -16.23500000     1.89400000   -18.33000000
H      -16.10500000     3.00500000   -16.54900000
H      -17.77400000     2.82900000   -17.19100000
H      -16.16600000     5.01000000   -17.62100000
H      -17.56000000     4.51000000   -18.60200000
H      -15.96800000     2.04100000   -20.40600000
H      -17.72100000     0.98100000   -16.45600000
H      -15.92437000     4.00866900   -19.10280000
H      -15.64668000     3.51316300   -19.42842000
H      -14.44877000     2.17512600   -19.44702000
H      -17.86483000    -0.62771220   -17.16378000
H      -16.42659000    -0.19435650   -16.12798000
--
0 1
C      -18.54500000     4.00900000   -14.38500000
C      -18.04000000     3.91200000   -12.95300000
H      -19.46500000     4.59700000   -14.41200000
H      -17.79700000     4.50300000   -15.00800000
H      -18.74900000     3.01300000   -14.78200000
H      -17.84800000     4.91700000   -12.57600000
H      -17.10001000     3.34150800   -12.92202000
H      -18.80669000     3.45141000   -12.31265000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003SER-096ASN-2')] = qcdb.Molecule("""
0 1
C       -8.50800000    27.70000000     6.16500000
C       -9.60300000    26.89600000     5.47000000
O       -7.34400000    26.91700000     6.39600000
H       -8.34700000    28.62800000     5.62900000
H       -8.88900000    27.98800000     7.14600000
H       -9.29000000    26.65100000     4.46000000
H       -6.69500000    27.47000000     6.85700000
H      -10.51062000    27.51613000     5.42936000
H       -9.77318300    25.95571000     6.01487000
--
0 1
C       -5.73400000    28.56000000     4.24700000
C       -5.68100000    27.27200000     3.41300000
C       -5.61700000    29.83400000     3.42600000
O       -5.55000000    29.80700000     2.19800000
N       -5.60000000    30.97600000     4.10400000
H       -6.68400000    28.64100000     4.71200000
H       -4.96600000    28.54200000     5.02100000
H       -5.94800000    26.45600000     4.09000000
H       -5.52900000    31.84000000     3.58800000
H       -5.59600000    30.97800000     5.11400000
H       -4.66495500    27.06126000     3.04797600
H       -6.45989400    27.26766000     2.63627300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003THR-181VAL-1')] = qcdb.Molecule("""
0 1
C       12.26400000    79.14100000    45.39000000
C       11.39400000    80.36000000    45.03600000
C       12.84200000    79.32400000    46.82100000
O       11.48300000    77.93600000    45.33800000
H       13.08300000    79.06500000    44.67200000
H       12.04300000    81.22900000    44.93200000
H       12.03000000    79.40400000    47.54500000
H       13.46600000    78.47000000    47.08200000
H       13.44400000    80.23200000    46.86500000
H       12.04300000    77.17900000    45.55300000
H       10.65198000    80.55943000    45.82317000
H       10.93646000    80.21498000    44.04624000
--
0 1
C       15.06000000    76.60500000    44.62800000
C       15.57000000    75.84100000    43.44600000
H       14.87600000    77.63500000    44.33700000
H       14.13600000    76.15100000    44.98000000
H       15.80600000    76.57300000    45.42100000
H       15.75400000    74.81400000    43.75900000
H       16.50047000    76.29102000    43.06957000
H       14.84541000    75.72204000    42.62696000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003THR-182GLU-1')] = qcdb.Molecule("""
0 1
C       12.84200000    79.32400000    46.82100000
C       12.26400000    79.14100000    45.39000000
H       12.03000000    79.40400000    47.54500000
H       13.46600000    78.47000000    47.08200000
H       13.44400000    80.23200000    46.86500000
H       13.08300000    79.06500000    44.67200000
H       11.64212000    80.01234000    45.13696000
H       11.66612000    78.21853000    45.35019000
--
-1 1
C       15.72400000    81.08300000    45.16000000
C       17.02100000    81.19600000    44.34900000
C       15.84300000    81.73800000    46.54200000
O       16.89400000    81.56100000    47.20200000
O       14.87200000    82.40800000    46.97700000
H       14.94700000    81.58700000    44.58900000
H       15.45400000    80.03300000    45.28300000
H       17.86400000    80.88000000    44.96200000
H       17.16700000    82.23500000    44.04800000
H       16.99518000    80.57053000    43.44450000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TRP-163PRO-1')] = qcdb.Molecule("""
0 1
C       39.23000000    14.12400000    23.09300000
C       40.34000000    13.76300000    20.75300000
C       40.29900000    14.29600000    22.08000000
C       41.56300000    14.18400000    20.16600000
C       41.45500000    14.99900000    22.24900000
C       39.46000000    12.96100000    20.04500000
C       39.81400000    12.60800000    18.75100000
C       41.01300000    13.04100000    18.17900000
C       41.90800000    13.83300000    18.87200000
N       42.21400000    14.93600000    21.10600000
H       38.54200000    12.64900000    20.50000000
H       39.15200000    11.98500000    18.16200000
H       41.24700000    12.74700000    17.16300000
H       39.70200000    14.13900000    24.06900000
H       38.79100000    13.13600000    22.96500000
H       41.74200000    15.51700000    23.15900000
H       43.12700000    15.36500000    21.00100000
H       42.83800000    14.16100000    18.42800000
H       38.42296000    14.87145000    23.09156000
--
0 1
C       38.86700000    15.97200000    17.68700000
C       39.90500000    16.23500000    16.61500000
C       37.91500000    17.41200000    15.96900000
C       36.21700000    15.49200000    18.78500000
C       36.37800000    16.39300000    17.57400000
O       35.41800000    16.90900000    16.99300000
N       37.65200000    16.58600000    17.14700000
H       38.73600000    14.89700000    17.80600000
H       39.14500000    16.40700000    18.63600000
H       39.97300000    15.35300000    15.97500000
H       40.88200000    16.43800000    17.05200000
H       37.57000000    18.43500000    16.13300000
H       36.86300000    15.85000000    19.57900000
H       36.55700000    14.49300000    18.51500000
H       39.54647000    17.08231000    16.01208000
H       39.00725000    17.39816000    15.83939000
H       37.41355000    16.97530000    15.09273000
H       35.18247000    15.44525000    19.15590000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TRP-167GLN-1')] = qcdb.Molecule("""
0 1
C       39.23000000    14.12400000    23.09300000
C       40.34000000    13.76300000    20.75300000
C       40.29900000    14.29600000    22.08000000
C       41.56300000    14.18400000    20.16600000
C       41.45500000    14.99900000    22.24900000
C       39.46000000    12.96100000    20.04500000
C       39.81400000    12.60800000    18.75100000
C       41.01300000    13.04100000    18.17900000
C       41.90800000    13.83300000    18.87200000
N       42.21400000    14.93600000    21.10600000
H       38.54200000    12.64900000    20.50000000
H       39.15200000    11.98500000    18.16200000
H       41.24700000    12.74700000    17.16300000
H       39.70200000    14.13900000    24.06900000
H       38.79100000    13.13600000    22.96500000
H       41.74200000    15.51700000    23.15900000
H       43.12700000    15.36500000    21.00100000
H       42.83800000    14.16100000    18.42800000
H       38.42296000    14.87145000    23.09156000
--
0 1
C       36.22500000    11.57000000    19.18300000
C       35.96500000    10.77000000    17.91300000
C       36.63100000    10.68500000    20.37200000
H       37.00100000    12.30300000    18.98600000
H       35.31500000    12.10900000    19.44300000
H       36.84400000    10.15200000    17.71600000
H       35.94300000     9.85100000    20.49000000
H       37.62200000    10.27200000    20.18100000
H       35.80598000    11.45809000    17.06965000
H       35.11002000    10.10205000    18.09425000
H       36.64047000    11.20758000    21.33990000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TRP-167GLN-2')] = qcdb.Molecule("""
0 1
C       39.23000000    14.12400000    23.09300000
C       40.34000000    13.76300000    20.75300000
C       40.29900000    14.29600000    22.08000000
C       41.56300000    14.18400000    20.16600000
C       41.45500000    14.99900000    22.24900000
C       39.46000000    12.96100000    20.04500000
C       39.81400000    12.60800000    18.75100000
C       41.01300000    13.04100000    18.17900000
C       41.90800000    13.83300000    18.87200000
N       42.21400000    14.93600000    21.10600000
H       38.54200000    12.64900000    20.50000000
H       39.15200000    11.98500000    18.16200000
H       41.24700000    12.74700000    17.16300000
H       39.70200000    14.13900000    24.06900000
H       38.79100000    13.13600000    22.96500000
H       41.74200000    15.51700000    23.15900000
H       43.12700000    15.36500000    21.00100000
H       42.83800000    14.16100000    18.42800000
H       38.42296000    14.87145000    23.09156000
--
0 1
C       36.63100000    10.68500000    20.37200000
C       36.64400000    11.40200000    21.70000000
O       36.10600000    12.50300000    21.83300000
N       37.23100000    10.78600000    22.72300000
H       35.94300000     9.85100000    20.49000000
H       37.62200000    10.27200000    20.18100000
H       37.18500000    11.19200000    23.65400000
H       37.70500000     9.90100000    22.57300000
H       36.34040000    11.31846000    19.52095000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-028VAL-1')] = qcdb.Molecule("""
0 1
C        3.71000000    22.84900000    14.17100000
C        3.98600000    21.09900000    15.99800000
C        4.03700000    22.43700000    15.58600000
C        4.27300000    20.74100000    17.32100000
C        4.40800000    23.40700000    16.52000000
C        4.63500000    21.72400000    18.22600000
C        4.70000000    23.05500000    17.83700000
O        4.92600000    21.38100000    19.51200000
H        3.69600000    20.33100000    15.29400000
H        4.22100000    19.71000000    17.64200000
H        4.08500000    23.86200000    14.04300000
H        4.35700000    22.23200000    13.52500000
H        4.48500000    24.44100000    16.22000000
H        4.99100000    23.81700000    18.54800000
H        5.13400000    22.15200000    20.05300000
H        2.63183300    22.88427000    13.95580000
--
0 1
C        5.53100000    18.69800000    13.84300000
C        5.85000000    18.06400000    15.19100000
H        4.57600000    18.33800000    13.45800000
H        5.46800000    19.78300000    13.94000000
H        6.32600000    18.46900000    13.13300000
H        4.99000000    18.17300000    15.84900000
H        6.08092700    16.99857000    15.04424000
H        6.71126100    18.57686000    15.64399000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-028VAL-2')] = qcdb.Molecule("""
0 1
C        3.71000000    22.84900000    14.17100000
C        3.98600000    21.09900000    15.99800000
C        4.03700000    22.43700000    15.58600000
C        4.27300000    20.74100000    17.32100000
C        4.40800000    23.40700000    16.52000000
C        4.63500000    21.72400000    18.22600000
C        4.70000000    23.05500000    17.83700000
O        4.92600000    21.38100000    19.51200000
H        3.69600000    20.33100000    15.29400000
H        4.22100000    19.71000000    17.64200000
H        4.08500000    23.86200000    14.04300000
H        4.35700000    22.23200000    13.52500000
H        4.48500000    24.44100000    16.22000000
H        4.99100000    23.81700000    18.54800000
H        5.13400000    22.15200000    20.05300000
H        2.63183300    22.88427000    13.95580000
--
0 1
C        7.04400000    18.77500000    15.81900000
C        5.85000000    18.06400000    15.19100000
H        7.90500000    18.58000000    15.18700000
H        6.83300000    19.84300000    15.83000000
H        7.22400000    18.45000000    16.84400000
H        4.99000000    18.17300000    15.84900000
H        6.08092700    16.99857000    15.04424000
H        5.61966400    18.52178000    14.21767000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-030GLN-1')] = qcdb.Molecule("""
0 1
C        3.71000000    22.84900000    14.17100000
C        4.63500000    21.72400000    18.22600000
C        4.70000000    23.05500000    17.83700000
C        4.27300000    20.74100000    17.32100000
C        4.40800000    23.40700000    16.52000000
C        3.98600000    21.09900000    15.99800000
C        4.03700000    22.43700000    15.58600000
O        4.92600000    21.38100000    19.51200000
H        5.13400000    22.15200000    20.05300000
H        4.99100000    23.81700000    18.54800000
H        4.22100000    19.71000000    17.64200000
H        4.48500000    24.44100000    16.22000000
H        3.69600000    20.33100000    15.29400000
H        4.08500000    23.86200000    14.04300000
H        4.35700000    22.23200000    13.52500000
H        2.63183300    22.88427000    13.95580000
--
0 1
C        9.26100000    18.58900000    21.15800000
C        8.96300000    19.77500000    20.25000000
O        9.76100000    20.72700000    20.14200000
N        7.74900000    19.76200000    19.65900000
H        7.50500000    20.54100000    19.06300000
H        7.09000000    19.02000000    19.83900000
H        8.52200000    17.80300000    20.99900000
H        9.13700000    18.92400000    22.18900000
H       10.27301000    18.17141000    21.05100000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-054VAL-1')] = qcdb.Molecule("""
0 1
C        3.71000000    22.84900000    14.17100000
C        4.40800000    23.40700000    16.52000000
C        4.03700000    22.43700000    15.58600000
C        4.70000000    23.05500000    17.83700000
C        4.63500000    21.72400000    18.22600000
C        3.98600000    21.09900000    15.99800000
C        4.27300000    20.74100000    17.32100000
O        4.92600000    21.38100000    19.51200000
H        4.48500000    24.44100000    16.22000000
H        4.99100000    23.81700000    18.54800000
H        4.08500000    23.86200000    14.04300000
H        4.35700000    22.23200000    13.52500000
H        3.69600000    20.33100000    15.29400000
H        5.13400000    22.15200000    20.05300000
H        4.22100000    19.71000000    17.64200000
H        2.63183300    22.88427000    13.95580000
--
0 1
C        7.11800000    25.16600000    14.75100000
C        6.47800000    25.81100000    13.53000000
H        6.67500000    25.47100000    15.69600000
H        6.90500000    24.10900000    14.64200000
H        8.18800000    25.37400000    14.75200000
H        5.46400000    25.43500000    13.42700000
H        6.41861600    26.90183000    13.65867000
H        7.02505600    25.54106000    12.61465000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-056ALA-1')] = qcdb.Molecule("""
0 1
C        3.71000000    22.84900000    14.17100000
C        4.70000000    23.05500000    17.83700000
C        4.40800000    23.40700000    16.52000000
C        4.63500000    21.72400000    18.22600000
C        4.03700000    22.43700000    15.58600000
C        4.27300000    20.74100000    17.32100000
C        3.98600000    21.09900000    15.99800000
O        4.92600000    21.38100000    19.51200000
H        4.99100000    23.81700000    18.54800000
H        4.48500000    24.44100000    16.22000000
H        5.13400000    22.15200000    20.05300000
H        4.22100000    19.71000000    17.64200000
H        4.08500000    23.86200000    14.04300000
H        4.35700000    22.23200000    13.52500000
H        3.69600000    20.33100000    15.29400000
H        2.63183300    22.88427000    13.95580000
--
0 1
C        1.42200000    24.28700000    19.15600000
C        1.41700000    24.77800000    17.69700000
H        1.14700000    25.10200000    19.82800000
H        0.70500000    23.47400000    19.27000000
H        2.41400000    23.92100000    19.42100000
H        1.68400000    23.94500000    17.04300000
H        2.13597900    25.59936000    17.56124000
H        0.41324900    25.14372000    17.43484000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-073CYS-2')] = qcdb.Molecule("""
0 1
C       16.87200000     7.47800000    15.90900000
C       16.76000000     6.41900000    16.97200000
C       16.93300000     6.73400000    18.32300000
C       16.48700000     5.10000000    16.62200000
C       16.85300000     5.74400000    19.30500000
C       16.43300000     4.11300000    17.59300000
C       16.60600000     4.43900000    18.92700000
O       16.54300000     3.46700000    19.86700000
H       16.61700000     8.44500000    16.34500000
H       16.14300000     7.27500000    15.12600000
H       17.12300000     7.75800000    18.61500000
H       16.34000000     4.83200000    15.58400000
H       16.97400000     5.97400000    20.34900000
H       16.26400000     3.08200000    17.32400000
H       16.66800000     3.80600000    20.76000000
H       17.87293000     7.53511400    15.45637000
--
0 1
C       13.35100000     6.67900000    18.26600000
C       12.28100000     6.64300000    17.17700000
S       12.80900000     7.51700000    19.77600000
H       13.65000000     5.65600000    18.51000000
H       14.22900000     7.20500000    17.88400000
H       11.91900000     7.66300000    17.02800000
H       13.82600000     7.12000000    20.55100000
H       11.43283000     6.00216000    17.45972000
H       12.74380000     6.32872600    16.22987000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-074SER-1')] = qcdb.Molecule("""
0 1
C       16.87200000     7.47800000    15.90900000
C       16.43300000     4.11300000    17.59300000
C       16.60600000     4.43900000    18.92700000
C       16.48700000     5.10000000    16.62200000
C       16.76000000     6.41900000    16.97200000
C       16.85300000     5.74400000    19.30500000
C       16.93300000     6.73400000    18.32300000
O       16.54300000     3.46700000    19.86700000
H       16.26400000     3.08200000    17.32400000
H       16.34000000     4.83200000    15.58400000
H       16.97400000     5.97400000    20.34900000
H       16.66800000     3.80600000    20.76000000
H       16.61700000     8.44500000    16.34500000
H       16.14300000     7.27500000    15.12600000
H       17.12300000     7.75800000    18.61500000
H       17.87293000     7.53511400    15.45637000
--
0 1
C       13.57700000     2.72700000    14.60700000
O       14.55300000     2.40900000    15.59500000
H       14.10100000     2.50700000    16.45700000
H       12.61600000     2.30700000    14.90900000
H       13.87700000     2.24700000    13.67400000
H       13.47536000     3.80763800    14.42842000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003TYR-096HIE-1')] = qcdb.Molecule("""
0 1
C       40.38900000    35.23200000    -4.66900000
C       36.17500000    35.75500000    -3.79800000
C       37.10300000    36.70500000    -3.36500000
C       36.61400000    34.63800000    -4.50900000
C       38.46900000    36.53500000    -3.65200000
C       37.97700000    34.47800000    -4.78800000
C       38.91800000    35.42000000    -4.36100000
O       34.84000000    35.90200000    -3.52200000
H       36.77100000    37.57200000    -2.81400000
H       34.66900000    36.66700000    -2.96100000
H       35.89800000    33.90000000    -4.84000000
H       39.17800000    37.27900000    -3.31400000
H       38.30300000    33.60700000    -5.34300000
H       40.78400000    36.13300000    -5.14100000
H       40.46200000    34.42800000    -5.39700000
H       41.00114000    34.96504000    -3.79492100
--
0 1
C       35.00700000    33.29500000    -1.24500000
C       34.56300000    32.20200000    -0.27300000
C       36.41100000    33.72800000    -1.03500000
C       37.57900000    33.14400000    -1.40500000
C       38.03700000    34.83800000    -0.28200000
N       36.73500000    34.80000000    -0.30900000
N       38.59500000    33.93000000    -0.94500000
H       34.92800000    32.91600000    -2.26500000
H       34.34700000    34.15900000    -1.16100000
H       35.25700000    31.36200000    -0.32300000
H       37.67600000    32.22900000    -1.97600000
H       38.47700000    34.79600000     0.71400000
H       39.58500000    33.71700000    -0.89500000
H       33.55915000    31.87723000    -0.58414720
H       34.57167000    32.59991000     0.75247120
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-009TYR-1')] = qcdb.Molecule("""
0 1
C      -16.71600000    13.47800000   -12.04700000
C      -18.19700000    13.83400000   -12.18600000
H      -16.60300000    12.39600000   -12.04500000
H      -16.15800000    13.87500000   -12.89100000
H      -16.28500000    13.87800000   -11.13700000
H      -18.29400000    14.92000000   -12.17700000
H      -18.76264000    13.40010000   -11.34828000
H      -18.60277000    13.47626000   -13.14380000
--
0 1
C      -12.40100000     8.94800000   -12.89200000
C      -15.35000000    10.68300000   -10.33100000
C      -14.08100000    11.23500000   -10.38900000
C      -15.66800000     9.59100000   -11.12400000
C      -13.14100000    10.69100000   -11.24400000
C      -14.70700000     9.02300000   -11.93700000
C      -13.44600000     9.58300000   -12.02600000
O      -16.30500000    11.18000000    -9.50100000
H      -13.82900000    12.08000000    -9.76700000
H      -15.98300000    11.93500000    -8.98300000
H      -16.65600000     9.16500000   -11.06500000
H      -12.15100000    11.12500000   -11.29300000
H      -14.94100000     8.14500000   -12.52200000
H      -11.75400000     9.73200000   -13.27600000
H      -12.89300000     8.47700000   -13.74500000
H      -11.78995000     8.19813800   -12.36824000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-012GLU-1')] = qcdb.Molecule("""
0 1
C        3.49000000    -9.87300000     4.15900000
C        2.90200000    -8.72900000     4.97500000
H        3.32500000   -10.83600000     4.64000000
H        2.99500000    -9.90200000     3.19000000
H        4.55800000    -9.73200000     3.98600000
H        1.83000000    -8.89700000     5.08600000
H        3.36888800    -8.69600900     5.97045300
H        3.03946200    -7.77472600     4.44541000
--
-1 1
C        5.70800000   -11.19700000     1.12200000
C        4.22800000   -11.03400000     0.80600000
O        3.84800000   -10.01400000     0.18900000
O        3.43600000   -11.93000000     1.17400000
H        6.04800000   -12.18100000     0.79100000
H        5.84700000   -11.12800000     2.20400000
H        6.31256600   -10.42663000     0.62097030
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-036PHE-1')] = qcdb.Molecule("""
0 1
C       30.97500000    -5.34200000    12.41700000
C       32.48600000    -5.47900000    12.13900000
H       30.49200000    -6.30700000    12.26700000
H       30.82300000    -5.02800000    13.44900000
H       30.52300000    -4.60000000    11.75900000
H       32.94000000    -4.51500000    12.36100000
H       32.69385000    -5.72090500    11.08625000
H       32.91567000    -6.18969500    12.86031000
--
0 1
C       31.87300000    -1.81800000    12.83500000
C       33.28900000    -1.36200000    12.40300000
C       31.00900000    -0.72500000    13.35500000
C       29.89400000    -0.26400000    12.63700000
C       31.22500000    -0.24100000    14.65700000
C       29.05300000     0.75300000    13.19900000
C       30.43000000     0.75800000    15.19200000
C       29.32600000     1.26000000    14.49200000
H       31.37800000    -2.27500000    11.97700000
H       31.96000000    -2.59100000    13.59900000
H       33.77600000    -2.19600000    11.89600000
H       29.67100000    -0.66100000    11.65600000
H       32.03400000    -0.63700000    15.24500000
H       28.19200000     1.11200000    12.65400000
H       30.64400000     1.12900000    16.18600000
H       28.69500000     2.01700000    14.93600000
H       33.88764000    -1.08033200    13.28180000
H       33.23617000    -0.53270470    11.68225000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-064TYR-1')] = qcdb.Molecule("""
0 1
C       33.09300000    -6.48300000    13.15800000
C       32.48600000    -5.47900000    12.13900000
H       34.17800000    -6.41100000    13.14400000
H       32.75200000    -6.24600000    14.16600000
H       32.79400000    -7.49800000    12.90100000
H       32.94000000    -4.51500000    12.36100000
H       32.69385000    -5.72090500    11.08625000
H       31.40843000    -5.38129900    12.33726000
--
0 1
C       30.58500000   -10.62500000    10.70000000
C       31.57900000    -9.76300000    14.28900000
C       30.96500000    -9.73300000    13.02400000
C       32.47100000   -10.79400000    14.62700000
C       31.25300000   -10.69900000    12.06000000
C       32.75500000   -11.78600000    13.67800000
C       32.14000000   -11.73500000    12.39300000
O       32.98300000   -10.83300000    15.90600000
H       31.33700000    -8.99800000    15.01300000
H       30.27800000    -8.93000000    12.79300000
H       32.68300000   -10.09300000    16.44000000
H       33.42600000   -12.59400000    13.93400000
H       29.75000000    -9.92700000    10.76700000
H       30.15700000   -11.60100000    10.46500000
H       32.35200000   -12.51600000    11.67500000
H       31.24056000   -10.29794000     9.87946900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-081THR-1')] = qcdb.Molecule("""
0 1
C      -34.97000000     6.45400000    -2.12400000
C      -35.32800000     5.05100000    -2.61300000
H      -34.17100000     6.88600000    -2.72600000
H      -35.84500000     7.09700000    -2.21200000
H      -34.67200000     6.43500000    -1.07700000
H      -35.66300000     5.12800000    -3.64800000
H      -34.45256000     4.38620800    -2.57229800
H      -36.15986000     4.63903800    -2.02283400
--
0 1
C      -31.87400000     8.73900000    -1.76000000
C      -30.60800000     8.76300000    -0.89700000
H      -32.75600000     8.53500000    -1.15400000
H      -31.99900000     9.71400000    -2.23000000
H      -31.79200000     7.99500000    -2.55100000
H      -29.77100000     9.05500000    -1.53300000
H      -30.39316000     7.77344700    -0.46731640
H      -30.71321000     9.51568600    -0.10176720
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-083PRO-1')] = qcdb.Molecule("""
0 1
C      -36.48100000     4.48000000    -1.79500000
C      -35.32800000     5.05100000    -2.61300000
H      -36.19200000     4.36200000    -0.75200000
H      -37.34200000     5.14600000    -1.85700000
H      -36.76500000     3.50600000    -2.19500000
H      -35.66300000     5.12800000    -3.64800000
H      -34.45256000     4.38620800    -2.57229800
H      -35.07033000     6.06081600    -2.26104000
--
0 1
C      -36.81400000     6.28000000     1.61100000
C      -35.41500000     6.14900000     2.15400000
C      -37.26100000     7.67800000     1.91100000
H      -37.48500000     5.54000000     2.04900000
H      -36.78600000     6.15900000     0.53000000
H      -35.43900000     5.74900000     3.16900000
H      -34.81800000     5.51600000     1.49600000
H      -37.75900000     7.68300000     2.88300000
H      -37.94400000     8.05100000     1.14600000
H      -35.04341000     7.18420400     2.17051500
H      -36.33854000     8.27590500     1.95066800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-118ALA-1')] = qcdb.Molecule("""
0 1
C      -16.71600000    13.47800000   -12.04700000
C      -18.19700000    13.83400000   -12.18600000
H      -16.60300000    12.39600000   -12.04500000
H      -16.15800000    13.87500000   -12.89100000
H      -16.28500000    13.87800000   -11.13700000
H      -18.29400000    14.92000000   -12.17700000
H      -18.76264000    13.40010000   -11.34828000
H      -18.60277000    13.47626000   -13.14380000
--
0 1
C      -13.78700000    15.21200000   -10.24600000
C      -12.98600000    14.67400000   -11.42200000
H      -13.31700000    16.11700000    -9.85700000
H      -14.79900000    15.45800000   -10.56600000
H      -13.83000000    14.46100000    -9.45700000
H      -13.44200000    13.73300000   -11.73500000
H      -11.95419000    14.46779000   -11.10131000
H      -13.04716000    15.35826000   -12.28110000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '003VAL-121TYR-1')] = qcdb.Molecule("""
0 1
C      -18.76300000    13.33500000   -13.52200000
C      -18.19700000    13.83400000   -12.18600000
H      -19.76100000    13.73200000   -13.68200000
H      -18.13000000    13.67900000   -14.34000000
H      -18.79900000    12.24500000   -13.53300000
H      -18.29400000    14.92000000   -12.17700000
H      -18.76264000    13.40010000   -11.34828000
H      -17.13189000    13.57797000   -12.08603000
--
0 1
C      -13.72300000    11.89100000   -14.87200000
C      -16.05400000    10.93900000   -14.90300000
C      -14.71300000    10.81400000   -15.26600000
C      -17.00200000     9.97800000   -15.30100000
C      -14.33000000     9.75700000   -16.09500000
C      -16.60100000     8.91000000   -16.08600000
C      -15.26900000     8.80100000   -16.50100000
O      -17.54400000     8.00700000   -16.49700000
H      -16.36900000    11.77800000   -14.30400000
H      -18.03500000    10.06800000   -15.00100000
H      -12.82900000    11.41100000   -14.47600000
H      -14.14400000    12.51100000   -14.08000000
H      -13.30200000     9.66600000   -16.41700000
H      -14.96500000     7.98300000   -17.13800000
H      -17.23300000     7.49800000   -17.27500000
H      -13.42985000    12.53034000   -15.71776000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ARG-024THR-1')] = qcdb.Molecule("""
1 1
C       -0.13200000    26.84400000     9.19900000
C       -2.33100000    25.84000000     9.82000000
N       -3.06400000    24.74000000     9.86000000
N       -1.08200000    25.75000000     9.38500000
N       -2.85800000    26.99400000    10.17800000
H       -2.68800000    23.88100000     9.48300000
H       -4.03200000    24.78700000    10.13500000
H       -0.81100000    24.84800000     9.00900000
H       -2.32600000    27.84100000    10.08300000
H       -3.81300000    27.04000000    10.49700000
H       -0.56900000    27.57900000     8.52200000
H        0.76400000    26.45600000     8.73600000
H        0.16646470    27.36912000    10.11833000
--
0 1
C       -0.19200000    21.94700000     8.13200000
O       -1.17600000    22.94800000     7.90400000
H       -1.75700000    22.62100000     7.20100000
H       -0.20600000    21.23900000     7.30500000
H        0.79804990    22.42345000     8.18486000
H       -0.43016220    21.44163000     9.07956600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ARG-057ILE-1')] = qcdb.Molecule("""
0 1
C        0.60700000    26.65500000    11.57000000
C        1.87600000    25.81700000    11.45100000
C        0.26700000    27.54600000    10.42800000
H       -0.23500000    26.00300000    11.78500000
H        0.71800000    27.29400000    12.44900000
H        1.79200000    25.19500000    10.55800000
H       -0.54700000    28.19800000    10.74500000
H        1.10900000    28.19800000    10.20400000
H        1.95076500    25.19471000    12.35498000
H        2.77610300    26.44161000    11.35261000
H       -0.03146468    27.02088000     9.50866900
--
0 1
C       -1.65600000    24.51000000    13.70500000
C       -2.46000000    23.98600000    14.88300000
C       -1.89200000    23.66400000    12.48400000
H       -1.92600000    25.54700000    13.49700000
H       -0.59400000    24.47100000    13.94700000
H       -2.25600000    22.91700000    14.98800000
H       -2.89600000    23.77200000    12.10000000
H       -1.17800000    23.94100000    11.71000000
H       -1.72200000    22.61500000    12.72200000
H       -2.19825400    24.47058000    15.83519000
H       -3.53191700    24.10960000    14.66918000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ARG-057ILE-2')] = qcdb.Molecule("""
1 1
C       -0.13200000    26.84400000     9.19900000
C       -2.33100000    25.84000000     9.82000000
N       -1.08200000    25.75000000     9.38500000
N       -2.85800000    26.99400000    10.17800000
N       -3.06400000    24.74000000     9.86000000
H       -0.81100000    24.84800000     9.00900000
H       -2.32600000    27.84100000    10.08300000
H       -3.81300000    27.04000000    10.49700000
H       -2.68800000    23.88100000     9.48300000
H       -4.03200000    24.78700000    10.13500000
H       -0.56900000    27.57900000     8.52200000
H        0.76400000    26.45600000     8.73600000
H        0.16646470    27.36912000    10.11833000
--
0 1
C       -1.89200000    23.66400000    12.48400000
C       -1.65600000    24.51000000    13.70500000
H       -2.89600000    23.77200000    12.10000000
H       -1.17800000    23.94100000    11.71000000
H       -1.72200000    22.61500000    12.72200000
H       -1.92600000    25.54700000    13.49700000
H       -0.59400000    24.47100000    13.94700000
H       -2.23805900    24.13065000    14.55782000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ARG-095TYR-1')] = qcdb.Molecule("""
0 1
C       27.07300000    10.51400000    29.04600000
C       28.36900000     9.74300000    28.91700000
C       27.24700000    11.89800000    29.63100000
H       26.59700000    10.57800000    28.06900000
H       26.39400000     9.96800000    29.70700000
H       28.84800000     9.72100000    29.90000000
H       27.68300000    11.81000000    30.62700000
H       27.92600000    12.48800000    29.01400000
H       29.03466000    10.23396000    28.19185000
H       28.06709000     8.71955600    28.64976000
H       26.28495000    12.42485000    29.71400000
--
0 1
C       21.23900000    10.22100000    31.98300000
C       23.60400000     8.89900000    28.69000000
C       22.83600000    10.04900000    28.55100000
C       23.62500000     8.14700000    29.87500000
C       22.08100000    10.45600000    29.64200000
C       22.84300000     8.56000000    30.95700000
C       22.06400000     9.70800000    30.82700000
O       24.39900000     8.45600000    27.69300000
H       22.81000000    10.61400000    27.63700000
H       24.86800000     7.66100000    27.96400000
H       24.23400000     7.25700000    29.96400000
H       21.47400000    11.35100000    29.56900000
H       22.84000000     7.99300000    31.87700000
H       20.90300000     9.39500000    32.61200000
H       20.35700000    10.71200000    31.57300000
H       21.88774000    10.90077000    32.55488000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ARG-095TYR-2')] = qcdb.Molecule("""
1 1
C       25.91400000    12.62800000    29.74600000
C       24.07200000    13.29300000    28.17700000
N       25.29100000    12.82900000    28.43200000
N       23.35400000    13.70200000    29.19800000
N       23.56500000    13.40600000    26.95900000
H       25.94800000    13.33200000    27.85300000
H       23.73900000    13.66700000    30.13000000
H       22.44600000    14.12700000    29.06300000
H       23.53800000    14.38000000    26.64200000
H       22.59600000    13.09500000    26.88500000
H       25.25500000    12.03300000    30.38400000
H       26.09000000    13.59200000    30.23300000
H       26.87605000    12.10115000    29.66300000
--
0 1
C       21.23900000    10.22100000    31.98300000
C       22.08100000    10.45600000    29.64200000
C       22.06400000     9.70800000    30.82700000
C       22.83600000    10.04900000    28.55100000
C       23.60400000     8.89900000    28.69000000
C       22.84300000     8.56000000    30.95700000
C       23.62500000     8.14700000    29.87500000
O       24.39900000     8.45600000    27.69300000
H       21.47400000    11.35100000    29.56900000
H       22.81000000    10.61400000    27.63700000
H       20.90300000     9.39500000    32.61200000
H       20.35700000    10.71200000    31.57300000
H       22.84000000     7.99300000    31.87700000
H       24.86800000     7.66100000    27.96400000
H       24.23400000     7.25700000    29.96400000
H       21.88774000    10.90077000    32.55488000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ASN-009TRP-1')] = qcdb.Molecule("""
0 1
C        1.16300000   -10.89400000     9.77800000
C        1.38100000   -11.12700000     8.28300000
C        0.81900000   -12.17500000    10.51400000
O        0.45300000   -13.17600000     9.90200000
N        0.95000000   -12.16300000    11.83000000
H        2.08400000   -10.50800000    10.20100000
H        0.38000000   -10.15600000     9.95300000
H        2.06600000   -11.97200000     8.17800000
H        0.71400000   -12.99700000    12.34700000
H        1.28200000   -11.33400000    12.29900000
H        1.81191600   -10.23039000     7.81352800
H        0.43497850   -11.39151000     7.78794700
--
0 1
C        5.97300000   -11.79500000    10.86800000
C        3.49700000    -9.50400000    12.48900000
C        4.33900000    -9.83300000    11.39500000
C        5.01000000   -11.05800000    11.72600000
C        4.55400000   -11.42600000    12.95100000
C        2.70900000    -8.36200000    12.50400000
C        2.75700000    -7.53300000    11.39500000
C        4.37000000    -8.97800000    10.28700000
C        3.58000000    -7.83300000    10.29700000
N        3.65000000   -10.49800000    13.41700000
H        3.18600000   -10.55700000    14.31800000
H        2.07500000    -8.13300000    13.35000000
H        4.86000000   -12.32200000    13.48400000
H        2.14900000    -6.63700000    11.37300000
H        4.94700000    -9.25000000     9.42000000
H        6.60100000   -12.43900000    11.48700000
H        6.61800000   -11.06900000    10.37200000
H        3.58600000    -7.16800000     9.44200000
H        5.45357200   -12.39667000    10.10761000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ASP-043THR-1')] = qcdb.Molecule("""
-1 1
C       36.20200000    42.07500000    30.50600000
C       34.82700000    41.47200000    30.74800000
O       34.73900000    40.38200000    31.34700000
O       33.82800000    42.09800000    30.33800000
H       36.57400000    42.52100000    31.43100000
H       36.12400000    42.88000000    29.77200000
H       36.91773000    41.33182000    30.12466000
--
0 1
C       33.41200000    39.53600000    34.46500000
O       34.72300000    39.88700000    34.03400000
H       34.70800000    40.02600000    33.06400000
H       32.73900000    40.36700000    34.24900000
H       33.07911000    38.63705000    33.92549000
H       33.42930000    39.35004000    35.54903000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004ASP-194ARG-1')] = qcdb.Molecule("""
-1 1
C       34.44500000    12.62500000    24.95900000
C       33.70500000    11.92700000    26.09800000
O       32.60000000    11.42900000    25.81100000
O       34.21200000    11.87200000    27.24800000
H       33.75000000    13.28700000    24.44000000
H       34.76300000    11.86300000    24.24500000
H       35.32079000    13.21299000    25.27085000
--
1 1
C       30.10300000    11.19000000    28.53000000
C       29.75500000     9.56900000    26.67900000
N       30.37700000    10.59600000    27.21800000
N       28.74500000     8.97600000    27.28900000
N       30.12800000     9.14700000    25.49400000
H       31.17900000    10.96200000    26.70100000
H       31.02700000    11.65000000    28.88700000
H       29.84700000    10.41200000    29.25200000
H       28.42800000     9.31100000    28.18300000
H       28.25500000     8.21600000    26.81600000
H       30.90000000     9.61000000    25.04000000
H       29.57100000     8.43700000    25.01400000
H       29.31831000    11.96085000    28.53729000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004GLN-007ASN-2')] = qcdb.Molecule("""
0 1
C        5.55000000     1.39400000    53.82500000
C        6.78100000     1.42000000    52.94600000
O        7.40500000     0.38700000    52.68600000
N        7.16200000     2.58400000    52.44300000
H        8.00400000     2.59300000    51.88400000
H        6.65600000     3.43200000    52.57900000
H        5.54900000     0.44200000    54.35900000
H        4.65500000     1.40200000    53.20500000
H        5.53418600     2.19405000    54.57976000
--
0 1
C        6.17200000     5.41400000    50.50500000
C        7.13800000     6.06400000    51.46200000
O        7.90200000     5.35500000    52.13100000
N        7.14000000     7.37400000    51.52100000
H        5.80900000     4.49600000    50.95700000
H        6.75700000     5.13100000    49.62700000
H        7.80000000     7.81700000    52.14200000
H        6.52900000     7.93100000    50.95200000
H        5.32654400     6.02881100    50.16264000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004GLN-056GLU-1')] = qcdb.Molecule("""
0 1
C        7.58000000   -11.91800000     4.53500000
C        7.30300000   -10.78700000     5.50600000
O        6.16100000   -10.48400000     5.82400000
N        8.33700000   -10.16300000     6.00200000
H        8.14800000    -9.40800000     6.65700000
H        9.27100000   -10.44600000     5.76600000
H        7.56500000   -12.84600000     5.10700000
H        8.57900000   -11.81800000     4.10900000
H        6.83258400   -11.99418000     3.73152800
--
-1 1
C        7.45600000    -6.45500000     5.73600000
C        6.69100000    -6.99900000     6.91000000
O        7.30600000    -7.73200000     7.74600000
O        5.51500000    -6.60300000     7.00500000
H        8.40500000    -6.97900000     5.77600000
H        7.66000000    -5.39700000     5.91100000
H        6.99610700    -6.55329200     4.74159700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004GLU-039THR-1')] = qcdb.Molecule("""
-1 1
C       31.28000000    -2.76300000     5.69200000
C       32.03100000    -2.80300000     4.40300000
O       31.91300000    -1.81200000     3.64800000
O       32.76800000    -3.79100000     4.16000000
H       30.20500000    -2.71300000     5.50200000
H       31.56400000    -1.86800000     6.24800000
H       31.51099000    -3.65386700     6.29449400
--
0 1
C       29.14300000     0.47900000     3.29000000
O       30.53400000     0.55500000     3.58600000
H       30.91700000    -0.34400000     3.50800000
H       28.77500000    -0.50800000     3.58000000
H       28.61418000     1.25029000     3.86918700
H       29.00726000     0.60336760     2.20551500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-010TYR-1')] = qcdb.Molecule("""
0 1
C       47.51600000    22.19300000    -2.27200000
C       48.25400000    23.38000000    -2.88700000
C       45.99900000    22.34700000    -2.18500000
H       47.74500000    21.29700000    -2.85200000
H       47.88700000    22.03300000    -1.26500000
H       47.98200000    24.28700000    -2.34600000
H       45.60200000    22.52600000    -3.18200000
H       47.98313000    23.47940000    -3.94848400
H       49.34011000    23.23635000    -2.78832900
H       45.54738000    21.41840000    -1.80587400
H       45.71820000    23.19663000    -1.54524600
--
0 1
C       47.42400000    24.18900000     3.29900000
C       49.29300000    21.84600000     0.91800000
C       49.32100000    20.66400000     1.65200000
C       48.68300000    22.99000000     1.44200000
C       48.10900000    22.96700000     2.71700000
C       48.76400000    20.63100000     2.92100000
C       48.14600000    21.77000000     3.44200000
O       49.91400000    19.53900000     1.14700000
H       49.75700000    21.86500000    -0.05500000
H       48.66300000    23.90200000     0.86200000
H       48.78500000    19.71600000     3.49400000
H       49.91100000    18.81300000     1.78000000
H       46.78300000    23.86100000     4.11700000
H       46.76700000    24.62000000     2.54200000
H       47.70000000    21.72800000     4.42700000
H       48.10428000    24.96431000     3.68125400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-031TYR-1')] = qcdb.Molecule("""
0 1
C       10.48000000    21.61800000    18.85800000
C       10.90400000    22.65900000    19.88200000
H        9.43000000    21.35900000    18.99500000
H       10.61400000    22.02300000    17.85500000
H       11.08300000    20.72200000    18.94300000
H       11.95400000    22.90800000    19.73000000
H       10.75412000    22.26171000    20.89674000
H       10.31091000    23.57677000    19.75573000
--
0 1
C       10.84000000    16.17500000    20.65000000
C        8.30100000    18.99400000    20.46600000
C        9.28200000    18.13100000    20.93500000
C        7.78800000    18.82900000    19.18500000
C        9.77700000    17.11200000    20.12900000
C        8.26100000    17.80800000    18.37300000
C        9.24700000    16.94900000    18.85000000
O        6.82400000    19.67900000    18.74400000
H        7.93400000    19.78700000    21.10200000
H        9.66300000    18.25800000    21.93800000
H        6.62700000    20.36900000    19.38200000
H        7.84900000    17.68400000    17.38300000
H       10.69800000    15.19000000    20.19900000
H       10.68800000    16.07300000    21.72300000
H        9.61300000    16.15200000    18.21500000
H       11.87889000    16.49952000    20.49061000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-032HIE-1')] = qcdb.Molecule("""
0 1
C       11.41700000    26.37500000    18.26300000
C       10.64500000    27.69900000    18.34700000
C       12.55600000    26.29700000    17.23400000
H       11.83200000    26.16100000    19.25000000
H       10.70100000    25.58500000    18.04300000
H       10.22900000    27.91300000    17.36100000
H       13.32900000    27.02200000    17.49000000
H       11.31410000    28.52500000    18.62988000
H        9.79731400    27.60833000    19.04213000
H       12.99853000    25.29033000    17.26206000
H       12.18518000    26.51517000    16.22163000
--
0 1
C        8.02500000    21.50800000    19.40600000
C        9.41600000    23.49400000    16.70500000
C        8.64300000    22.01200000    18.13300000
C        9.32600000    21.34500000    17.16600000
N        8.71100000    23.35200000    17.81800000
N        9.80400000    22.29400000    16.28500000
H        9.64200000    24.43600000    16.22000000
H       10.46500000    22.13900000    15.53100000
H        9.52200000    20.28100000    17.14400000
H        7.73300000    20.46600000    19.27500000
H        7.12200000    22.08600000    19.60000000
H        8.70746600    21.59827000    20.26396000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-040GLU-1')] = qcdb.Molecule("""
0 1
C        2.14600000     7.62200000    18.05300000
C        1.68900000     6.50400000    18.99000000
H        3.18500000     7.47000000    17.76200000
H        1.51300000     7.61400000    17.16900000
H        2.04000000     8.59100000    18.53900000
H        0.62000000     6.61900000    19.17000000
H        2.21724200     6.58151400    19.95174000
H        1.86645100     5.52802000    18.51463000
--
-1 1
C        2.40900000     7.50100000    14.27300000
C        3.68800000     6.71700000    13.95700000
C        1.16600000     6.64200000    14.36100000
O        1.24400000     5.41300000    14.11400000
O        0.09700000     7.21900000    14.67900000
H        2.53100000     8.03100000    15.21700000
H        2.26400000     8.24800000    13.48800000
H        3.55200000     6.15100000    13.03500000
H        3.89100000     6.02400000    14.77400000
H        4.54485600     7.39357900    13.82269000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-179LEU-1')] = qcdb.Molecule("""
0 1
C       45.61100000    23.52100000    -1.30100000
C       45.99900000    22.34700000    -2.18500000
H       45.87900000    24.46300000    -1.78000000
H       44.53600000    23.52200000    -1.13400000
H       46.11300000    23.44500000    -0.33500000
H       45.60200000    22.52600000    -3.18200000
H       47.09160000    22.23608000    -2.24766100
H       45.54738000    21.41840000    -1.80587400
--
0 1
C       42.57500000    23.34500000    -3.45200000
C       41.26900000    22.63100000    -3.10400000
C       42.50100000    24.23400000    -4.69500000
H       42.87000000    23.96300000    -2.60400000
H       43.34400000    22.59000000    -3.61400000
H       40.91000000    22.07600000    -3.97100000
H       41.73100000    24.98900000    -4.56500000
H       40.50126000    23.35425000    -2.79177500
H       41.44229000    21.88153000    -2.31770400
H       43.45948000    24.75300000    -4.84318100
H       42.23594000    23.62764000    -5.57367700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-180LEU-1')] = qcdb.Molecule("""
0 1
C       45.37600000    21.06600000    -1.66200000
C       45.99900000    22.34700000    -2.18500000
H       45.87500000    20.77000000    -0.74000000
H       44.30900000    21.20200000    -1.49500000
H       45.51000000    20.27400000    -2.40100000
H       45.60200000    22.52600000    -3.18200000
H       47.09160000    22.23608000    -2.24766100
H       45.71820000    23.19663000    -1.54524600
--
0 1
C       44.47000000    21.68200000     1.79200000
C       43.28800000    22.66400000     1.77600000
H       44.49200000    21.10600000     0.87800000
H       45.40900000    22.22600000     1.88900000
H       44.36500000    20.98400000     2.61900000
H       43.42200000    23.31700000     0.92000000
H       42.31332000    22.16126000     1.69077800
H       43.31951000    23.29214000     2.67846400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-180LEU-2')] = qcdb.Molecule("""
0 1
C       45.61100000    23.52100000    -1.30100000
C       45.99900000    22.34700000    -2.18500000
H       45.87900000    24.46300000    -1.78000000
H       44.53600000    23.52200000    -1.13400000
H       46.11300000    23.44500000    -0.33500000
H       45.60200000    22.52600000    -3.18200000
H       47.09160000    22.23608000    -2.24766100
H       45.54738000    21.41840000    -1.80587400
--
0 1
C       44.47000000    21.68200000     1.79200000
C       43.28800000    22.66400000     1.77600000
H       44.49200000    21.10600000     0.87800000
H       45.40900000    22.22600000     1.88900000
H       44.36500000    20.98400000     2.61900000
H       43.42200000    23.31700000     0.92000000
H       42.31332000    22.16126000     1.69077800
H       43.31951000    23.29214000     2.67846400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LEU-183LYS-1')] = qcdb.Molecule("""
0 1
C       45.37600000    21.06600000    -1.66200000
C       45.99900000    22.34700000    -2.18500000
H       45.87500000    20.77000000    -0.74000000
H       44.30900000    21.20200000    -1.49500000
H       45.51000000    20.27400000    -2.40100000
H       45.60200000    22.52600000    -3.18200000
H       47.09160000    22.23608000    -2.24766100
H       45.71820000    23.19663000    -1.54524600
--
0 1
C       45.51300000    17.64300000     0.04400000
C       44.42200000    16.70000000    -0.44400000
C       46.75700000    16.88900000     0.50000000
H       45.79000000    18.32100000    -0.76500000
H       45.13700000    18.23700000     0.88100000
H       44.14100000    16.03300000     0.37200000
H       44.77300000    16.10600000    -1.28700000
H       47.52800000    17.61600000     0.77400000
H       46.50500000    16.30700000     1.39100000
H       43.53709000    17.26149000    -0.77817010
H       47.12624000    16.21685000    -0.28859400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LYS-030ASP-1')] = qcdb.Molecule("""
0 1
C       28.93600000    37.07300000    19.16700000
C       30.22600000    37.48500000    19.86800000
C       28.17700000    38.21900000    18.50600000
H       29.19400000    36.33300000    18.40900000
H       28.27500000    36.58700000    19.88300000
H       29.99300000    38.26400000    20.59800000
H       27.85700000    38.94200000    19.25700000
H       28.83300000    38.70800000    17.78400000
H       30.96393000    37.86609000    19.14673000
H       30.64572000    36.62176000    20.40527000
H       27.30747000    37.79287000    17.98414000
--
-1 1
C       26.74000000    37.19600000    22.21300000
C       25.75900000    36.64200000    23.24400000
C       27.54100000    38.36200000    22.76400000
O       26.87200000    39.32500000    23.19400000
O       28.79100000    38.29500000    22.81500000
H       27.41700000    36.39600000    21.91400000
H       26.19000000    37.52200000    21.32800000
H       25.03500000    37.42500000    23.48100000
H       26.30319000    36.34764000    24.15351000
H       25.21023000    35.79712000    22.80238000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LYS-031ILE-1')] = qcdb.Molecule("""
0 1
C       28.93600000    37.07300000    19.16700000
C       30.22600000    37.48500000    19.86800000
C       28.17700000    38.21900000    18.50600000
H       29.19400000    36.33300000    18.40900000
H       28.27500000    36.58700000    19.88300000
H       29.99300000    38.26400000    20.59800000
H       27.85700000    38.94200000    19.25700000
H       28.83300000    38.70800000    17.78400000
H       30.96393000    37.86609000    19.14673000
H       30.64572000    36.62176000    20.40527000
H       27.30747000    37.79287000    17.98414000
--
0 1
C       27.22100000    33.60800000    19.00300000
C       25.98900000    33.68400000    19.84400000
H       27.30300000    32.63100000    18.52600000
H       27.17700000    34.37600000    18.23200000
H       28.09900000    33.78200000    19.62700000
H       25.10800000    33.59000000    19.20600000
H       25.97700000    34.68400000    20.27200000
H       25.95741000    32.91227000    20.62722000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004LYS-323PHE-1')] = qcdb.Molecule("""
0 1
C       -0.14700000     1.07600000   -14.53100000
C        0.70800000     0.84000000   -15.77500000
C       -0.44200000    -0.23500000   -13.81200000
H        0.39500000     1.73000000   -13.84900000
H       -1.08800000     1.56400000   -14.78400000
H        0.27100000     0.06900000   -16.40700000
H        1.69100000     0.49000000   -15.45500000
H        0.48900000    -0.80300000   -13.69900000
H       -0.81400000     0.00200000   -12.80800000
H        0.84197070     1.76194900   -16.35986000
H       -1.19931600    -0.82755340   -14.34618000
--
0 1
C        4.06000000     3.89800000   -15.10600000
C        2.35600000     3.56400000   -13.28200000
C        2.97200000     4.41400000   -14.20000000
C        1.35100000     4.03300000   -12.44500000
C        0.94600000     5.35700000   -12.52300000
C        2.55500000     5.73900000   -14.27600000
C        1.54800000     6.21200000   -13.43900000
H        2.64300000     2.52400000   -13.21700000
H        0.88000000     3.36700000   -11.73700000
H        4.50800000     4.72100000   -15.66500000
H        3.59800000     3.22400000   -15.82800000
H        0.16400000     5.69500000   -11.86500000
H        3.01800000     6.40800000   -14.98700000
H        1.23400000     7.24400000   -13.49400000
H        4.85152600     3.34615600   -14.57784000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PHE-116VAL-1')] = qcdb.Molecule("""
0 1
C        3.20300000    19.80600000    28.91300000
C        5.46300000    20.10600000    27.78000000
C        4.08800000    19.82400000    27.68300000
C        6.24400000    20.03900000    26.65400000
C        3.51200000    19.58000000    26.42800000
C        5.68500000    19.86800000    25.40200000
C        4.30400000    19.59800000    25.27500000
H        5.91200000    20.29900000    28.74400000
H        7.30700000    20.22100000    26.73600000
H        2.30900000    20.38800000    28.68700000
H        3.71000000    20.30100000    29.74300000
H        2.45000000    19.38700000    26.34700000
H        6.31200000    19.89200000    24.51900000
H        3.86400000    19.42800000    24.30200000
H        2.90157300    18.79048000    29.20940000
--
0 1
C        7.94200000    22.65200000    28.87700000
C        7.85300000    23.21800000    30.29100000
H        8.11000000    21.58200000    28.89700000
H        7.00100000    22.84100000    28.35600000
H        8.72800000    23.13900000    28.29900000
H        7.77200000    24.30200000    30.21300000
H        8.76701200    22.96591000    30.84870000
H        6.94232800    22.84095000    30.77937000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PHE-135LEU-2')] = qcdb.Molecule("""
0 1
C        3.20300000    19.80600000    28.91300000
C        5.46300000    20.10600000    27.78000000
C        4.08800000    19.82400000    27.68300000
C        6.24400000    20.03900000    26.65400000
C        3.51200000    19.58000000    26.42800000
C        5.68500000    19.86800000    25.40200000
C        4.30400000    19.59800000    25.27500000
H        5.91200000    20.29900000    28.74400000
H        7.30700000    20.22100000    26.73600000
H        2.30900000    20.38800000    28.68700000
H        3.71000000    20.30100000    29.74300000
H        2.45000000    19.38700000    26.34700000
H        6.31200000    19.89200000    24.51900000
H        3.86400000    19.42800000    24.30200000
H        2.90157300    18.79048000    29.20940000
--
0 1
C        4.18400000    23.54700000    26.60400000
C        4.81800000    24.23100000    25.39400000
H        4.66900000    22.58900000    26.78800000
H        4.30000000    24.17700000    27.48600000
H        3.11900000    23.38900000    26.44500000
H        4.27700000    25.15100000    25.17500000
H        4.79378700    23.55588000    24.52588000
H        5.86239900    24.48053000    25.63268000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PHE-158LEU-1')] = qcdb.Molecule("""
0 1
C        2.26000000     4.55700000     3.59700000
C        1.25100000     3.40700000     3.70300000
C        2.10400000     5.39700000     2.36100000
C        2.21100000     6.78800000     2.43400000
C        1.88200000     4.79700000     1.11900000
C        2.09600000     7.57100000     1.28200000
C        1.76500000     5.57400000    -0.03500000
C        1.87200000     6.96300000     0.04600000
H        2.19500000     5.18800000     4.48600000
H        3.26600000     4.13500000     3.55600000
H        1.13700000     2.89000000     2.75200000
H        2.40800000     7.26700000     3.38100000
H        1.83800000     3.72300000     1.01400000
H        2.18600000     8.64800000     1.34500000
H        1.60200000     5.09900000    -0.99400000
H        1.78600000     7.56700000    -0.84800000
H        0.27316100     3.79074700     4.02944900
H        1.62932000     2.66050700     4.41687900
--
0 1
C        5.25400000     4.98000000     6.00000000
C        5.23900000     6.27300000     6.82700000
C        5.66000000     3.70000000     6.73000000
H        4.26000000     4.82900000     5.58200000
H        5.94200000     5.11800000     5.16300000
H        6.18600000     6.38700000     7.35500000
H        4.92300000     3.46800000     7.49600000
H        4.40356400     6.26696800     7.54254900
H        5.14617100     7.13529200     6.15036500
H        5.70113800     2.86713700     6.01261200
H        6.64334300     3.83428900     7.20434400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PHE-160PRO-1')] = qcdb.Molecule("""
0 1
C        2.26000000     4.55700000     3.59700000
C        2.09600000     7.57100000     1.28200000
C        2.21100000     6.78800000     2.43400000
C        1.87200000     6.96300000     0.04600000
C        2.10400000     5.39700000     2.36100000
C        1.76500000     5.57400000    -0.03500000
C        1.88200000     4.79700000     1.11900000
H        2.18600000     8.64800000     1.34500000
H        2.40800000     7.26700000     3.38100000
H        1.78600000     7.56700000    -0.84800000
H        1.60200000     5.09900000    -0.99400000
H        2.19500000     5.18800000     4.48600000
H        3.26600000     4.13500000     3.55600000
H        1.83800000     3.72300000     1.01400000
H        1.53626100     3.73212400     3.67303200
--
0 1
C        5.24400000     9.59000000     2.16500000
C        5.40600000    10.06400000     0.74000000
C        7.46900000     9.08800000     1.38500000
C        6.16900000     9.44800000     4.96300000
C        7.12600000     9.22500000     3.79800000
O        8.31900000     8.99800000     4.00300000
N        6.62400000     9.28900000     2.56100000
H        4.79600000    10.39100000     2.75200000
H        4.63700000     8.68400000     2.20400000
H        5.74600000    11.10000000     0.71900000
H        4.47900000     9.95400000     0.17600000
H        7.92500000     8.09700000     1.41600000
H        5.15900000     9.63000000     4.60700000
H        6.18959900     9.38963900     0.36422200
H        6.75690700     9.12407400     0.54737100
H        8.26790700     9.83796500     1.28855500
H        6.16070600     8.56280500     5.61596300
H        6.47109200    10.35428000     5.50834500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-007LEU-1')] = qcdb.Molecule("""
0 1
C      -18.27000000    12.20200000    -6.42500000
C      -19.42600000    11.44100000    -7.05500000
C      -18.13100000    13.44100000    -7.30800000
H      -17.36800000    11.59700000    -6.49100000
H      -18.47800000    12.46500000    -5.38700000
H      -19.38900000    10.38000000    -6.80800000
H      -20.37100000    11.87500000    -6.72500000
H      -18.81700000    14.21500000    -6.96000000
H      -19.30236000    11.60901000    -8.13504000
H      -18.46404000    13.08987000    -8.29582300
H      -17.09919000    13.82171000    -7.32891000
--
0 1
C      -16.50800000     8.82200000    -6.55100000
C      -15.35600000     9.50900000    -5.84100000
H      -16.21200000     7.82600000    -6.87200000
H      -17.35400000     8.73200000    -5.86900000
H      -16.82100000     9.40100000    -7.41900000
H      -15.71400000    10.45400000    -5.43700000
H      -14.54627000     9.68822100    -6.56364200
H      -15.00136000     8.88162300    -5.00995700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-009TYR-1')] = qcdb.Molecule("""
0 1
C      -19.25600000    11.67200000    -8.54000000
C      -19.42600000    11.44100000    -7.05500000
C      -18.13100000    13.44100000    -7.30800000
C      -18.98700000    13.22800000   -11.01600000
C      -18.45500000    13.76000000    -9.69400000
O      -18.00100000    14.90900000    -9.62100000
N      -18.57300000    12.97500000    -8.61900000
H      -18.64600000    10.88200000    -8.97100000
H      -20.23200000    11.69600000    -9.02200000
H      -19.38900000    10.38000000    -6.80800000
H      -20.37100000    11.87500000    -6.72500000
H      -18.81700000    14.21500000    -6.96000000
H      -18.84700000    12.14700000   -11.04600000
H      -18.58978000    11.99149000    -6.59927200
H      -18.23108000    12.54892000    -6.67224400
H      -17.09919000    13.82171000    -7.32891000
H      -20.05460000    13.48627000   -11.07531000
H      -18.42136000    13.66190000   -11.85372000
--
0 1
C      -12.40100000     8.94800000   -12.89200000
C      -15.35000000    10.68300000   -10.33100000
C      -14.08100000    11.23500000   -10.38900000
C      -15.66800000     9.59100000   -11.12400000
C      -13.14100000    10.69100000   -11.24400000
C      -14.70700000     9.02300000   -11.93700000
C      -13.44600000     9.58300000   -12.02600000
O      -16.30500000    11.18000000    -9.50100000
H      -15.98300000    11.93500000    -8.98300000
H      -13.82900000    12.08000000    -9.76700000
H      -16.65600000     9.16500000   -11.06500000
H      -12.15100000    11.12500000   -11.29300000
H      -14.94100000     8.14500000   -12.52200000
H      -11.75400000     9.73200000   -13.27600000
H      -12.89300000     8.47700000   -13.74500000
H      -11.78995000     8.19813800   -12.36824000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-026TYR-1')] = qcdb.Molecule("""
0 1
C        2.39600000   -12.50500000     0.31100000
C        3.37900000   -13.42800000     1.00200000
C        1.21200000   -12.40900000     1.25200000
H        2.10100000   -12.89300000    -0.66400000
H        2.85000000   -11.51900000     0.20200000
H        3.19700000   -14.46000000     0.70000000
H        4.40000000   -13.12800000     0.77000000
H        0.50600000   -13.20200000     1.00600000
H        0.71900000   -11.44000000     1.16700000
H        3.15664800   -13.30148000     2.07183700
H        1.62232700   -12.56036000     2.26131700
--
0 1
C        3.99900000   -14.06500000    -2.80900000
C        4.25900000   -14.74800000    -4.14500000
C        5.19300000   -13.79200000    -1.92900000
C        5.72900000   -12.50000000    -1.83000000
C        5.74100000   -14.81000000    -1.13800000
C        6.80100000   -12.23200000    -0.96600000
C        6.80700000   -14.54900000    -0.27500000
C        7.33800000   -13.25900000    -0.19300000
O        8.37000000   -12.97200000     0.64700000
H        3.46700000   -13.13000000    -2.98000000
H        3.32200000   -14.69900000    -2.23400000
H        4.82600000   -15.66800000    -3.99700000
H        5.31000000   -11.69700000    -2.42100000
H        5.32700000   -15.80800000    -1.19000000
H        7.20300000   -11.23200000    -0.89800000
H        7.23000000   -15.33500000     0.33000000
H        8.72000000   -12.10200000     0.43800000
H        4.78275400   -14.06024000    -4.82520000
H        3.26892500   -14.96352000    -4.57314000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-029PHE-1')] = qcdb.Molecule("""
0 1
C      -18.47100000    20.50400000    -1.22700000
C      -18.08100000    19.05200000    -1.21000000
C      -19.83600000    20.51200000    -1.91100000
H      -17.73800000    21.11600000    -1.75200000
H      -18.58400000    20.86000000    -0.20300000
H      -17.69800000    18.76800000    -2.19000000
H      -17.33800000    18.83600000    -0.44400000
H      -20.46000000    21.29900000    -1.48500000
H      -19.03000000    18.52753000    -1.02472200
H      -20.24929000    19.52056000    -1.67386700
H      -19.72347000    20.66998000    -2.99376500
--
0 1
C      -14.88200000    22.50700000    -1.81500000
C      -15.48500000    20.63100000    -3.38000000
C      -14.81300000    21.06600000    -2.24000000
C      -15.40900000    19.29800000    -3.78000000
C      -14.65700000    18.39300000    -3.04000000
C      -14.05800000    20.15300000    -1.51000000
C      -13.98100000    18.82000000    -1.90500000
H      -16.07300000    21.32100000    -3.96100000
H      -15.93400000    18.97400000    -4.66600000
H      -14.23600000    22.64500000    -0.94600000
H      -15.90400000    22.73400000    -1.51000000
H      -14.59900000    17.35700000    -3.33900000
H      -13.53600000    20.47200000    -0.62100000
H      -13.39200000    18.11700000    -1.33200000
H      -14.57628000    23.21052000    -2.60340800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-068VAL-1')] = qcdb.Molecule("""
0 1
C        3.99800000   -17.80900000    18.83500000
C        3.42000000   -18.70900000    19.88800000
C        4.81400000   -16.81900000    19.62400000
H        3.19000000   -17.29500000    18.31300000
H        4.61400000   -18.36800000    18.12800000
H        2.49100000   -19.15300000    19.52900000
H        4.13900000   -19.48100000    20.16300000
H        5.00000000   -15.90300000    19.06200000
H        5.76300000   -17.27300000    19.90500000
H        3.26013800   -18.02602000    20.73534000
H        4.20689700   -16.63730000    20.52312000
--
0 1
C        4.59300000   -15.37500000    16.16900000
C        5.59800000   -15.39900000    15.02800000
H        4.55800000   -16.35200000    16.63900000
H        4.90600000   -14.64400000    16.91700000
H        3.59900000   -15.11400000    15.81400000
H        6.54400000   -15.77800000    15.41100000
H        5.26636200   -16.05146000    14.20684000
H        5.76591300   -14.38135000    14.64565000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-074ALA-1')] = qcdb.Molecule("""
0 1
C        3.42000000   -18.70900000    19.88800000
C        3.99800000   -17.80900000    18.83500000
C        3.97200000   -16.56700000    20.87100000
C        1.35200000   -19.04300000    22.04300000
C        2.39300000   -17.91700000    22.06600000
O        2.43800000   -17.11700000    23.00600000
N        3.20700000   -17.79900000    21.01700000
H        2.49100000   -19.15300000    19.52900000
H        4.13900000   -19.48100000    20.16300000
H        3.19000000   -17.29500000    18.31300000
H        4.61400000   -18.36800000    18.12800000
H        4.61900000   -16.38900000    21.73000000
H        1.70100000   -19.85500000    21.40600000
H        4.59395800   -17.08596000    19.41124000
H        4.57910300   -16.74870000    19.97188000
H        3.29504600   -15.71164000    20.72928000
H        1.20279800   -19.44213000    23.05712000
H        0.40411650   -18.67506000    21.62332000
--
0 1
C        3.06600000   -22.49000000    19.91300000
C        3.06700000   -22.89900000    18.45300000
H        3.95000000   -21.89600000    20.13500000
H        2.17700000   -21.89800000    20.13000000
H        3.06200000   -23.37800000    20.54700000
H        2.14500000   -23.44700000    18.24800000
H        3.93295800   -23.53998000    18.23104000
H        3.11041100   -22.00980000    17.80690000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-094LEU-1')] = qcdb.Molecule("""
0 1
C      -18.08100000    19.05200000    -1.21000000
C      -19.38200000    18.33300000    -0.95600000
C      -18.47100000    20.50400000    -1.22700000
H      -17.69800000    18.76800000    -2.19000000
H      -17.33800000    18.83600000    -0.44400000
H      -19.34400000    17.33900000    -1.40100000
H      -19.57600000    18.27200000     0.11600000
H      -17.73800000    21.11600000    -1.75200000
H      -18.58400000    20.86000000    -0.20300000
H      -20.13293000    18.97837000    -1.43516100
H      -19.45442000    20.50976000    -1.71979300
--
0 1
C      -17.47300000    19.24200000     2.51100000
C      -16.14800000    19.90900000     2.87200000
H      -18.04800000    19.00500000     3.40500000
H      -18.07100000    19.92700000     1.91100000
H      -17.29400000    18.33300000     1.93700000
H      -16.35300000    20.79900000     3.45500000
H      -15.51372000    19.24160000     3.47388400
H      -15.60882000    20.20653000     1.96054100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004PRO-096TYR-1')] = qcdb.Molecule("""
0 1
C      -19.42600000    11.44100000    -7.05500000
C      -19.25600000    11.67200000    -8.54000000
C      -18.27000000    12.20200000    -6.42500000
H      -19.38900000    10.38000000    -6.80800000
H      -20.37100000    11.87500000    -6.72500000
H      -18.64600000    10.88200000    -8.97100000
H      -20.23200000    11.69600000    -9.02200000
H      -17.36800000    11.59700000    -6.49100000
H      -18.47800000    12.46500000    -5.38700000
H      -18.74605000    12.64487000    -8.59898400
H      -18.16992000    13.09408000    -7.06075600
--
0 1
C      -20.82400000     7.13800000    -5.74600000
C      -21.59100000     8.50000000    -7.71900000
C      -20.62100000     7.69400000    -7.13400000
C      -21.43200000     8.98300000    -9.01800000
C      -19.47400000     7.39200000    -7.86500000
C      -20.27300000     8.69400000    -9.73200000
C      -19.29100000     7.91000000    -9.14500000
O      -20.06100000     9.15900000   -10.99900000
H      -22.49100000     8.74400000    -7.16900000
H      -22.19000000     9.60200000    -9.47300000
H      -21.72000000     7.57500000    -5.30200000
H      -19.97100000     7.45400000    -5.14400000
H      -18.70200000     6.77900000    -7.42000000
H      -18.37600000     7.69000000    -9.67500000
H      -19.13400000     9.13100000   -11.25100000
H      -20.90422000     6.04138200    -5.71448400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004SER-027VAL-1')] = qcdb.Molecule("""
0 1
C       12.68900000     2.66600000    22.02900000
C       12.63700000     1.50300000    21.02600000
O       12.03800000     2.36700000    23.24200000
H       13.73000000     2.92000000    22.22800000
H       12.20500000     3.54100000    21.59300000
H       11.59600000     1.25900000    20.82000000
H       12.31500000     1.48700000    23.53600000
H       13.16367000     0.63076780    21.44052000
H       13.12059000     1.85917500    20.10443000
--
0 1
C       15.36100000     3.73200000    24.39800000
C       16.64300000     3.73500000    25.23900000
H       14.49200000     3.95300000    25.01800000
H       15.22400000     2.76800000    23.91100000
H       15.43600000     4.47700000    23.61100000
H       16.69200000     4.68700000    25.76800000
H       16.63446000     2.92344600    25.98150000
H       17.52347000     3.69543700    24.58081000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004SER-030MET-1')] = qcdb.Molecule("""
0 1
C       12.68900000     2.66600000    22.02900000
O       12.03800000     2.36700000    23.24200000
H       12.31500000     1.48700000    23.53600000
H       13.73000000     2.92000000    22.22800000
H       12.20500000     3.54100000    21.59300000
H       12.65178000     1.83347300    21.31101000
--
0 1
C        8.87500000     1.85700000    25.65700000
C        9.83500000    -0.50600000    26.62800000
S       10.13100000     0.61700000    25.29700000
H        7.94600000     1.35500000    25.93100000
H        8.68400000     2.45900000    24.78000000
H       10.42800000    -1.40000000    26.45600000
H        8.78100000    -0.79300000    26.62700000
H       10.06800000    -0.03700000    27.58300000
H        9.20333600     2.49486900    26.49086000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004THR-078LEU-1')] = qcdb.Molecule("""
0 1
C      -30.87300000     3.99500000    -7.76000000
C      -31.78600000     3.57100000    -6.61500000
H      -30.05900000     4.61200000    -7.38000000
H      -30.45700000     3.11000000    -8.24300000
H      -31.44300000     4.55000000    -8.50400000
H      -32.65600000     3.06000000    -7.02700000
H      -32.11468000     4.44222700    -6.02939800
H      -31.23905000     2.87901700    -5.95773100
--
0 1
C      -29.55200000     5.57800000   -10.62400000
C      -28.23100000     5.11000000   -10.01700000
H      -29.43400000     5.74100000   -11.69500000
H      -30.32000000     4.82200000   -10.47800000
H      -29.88300000     6.50200000   -10.15800000
H      -28.33100000     5.09900000    -8.93300000
H      -27.40980000     5.78788200   -10.29288000
H      -28.01253000     4.07965000   -10.33425000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004THR-132LYS-1')] = qcdb.Molecule("""
0 1
C       11.52200000     0.47500000    21.59900000
O       12.07500000    -0.72000000    21.05300000
H       13.03700000    -0.62600000    21.07400000
H       11.91100000     0.60300000    22.60900000
H       11.80887000     1.33776700    20.97986000
H       10.42665000     0.38737190    21.64928000
--
1 1
C        9.96100000    -4.32000000    19.84100000
N       11.19500000    -3.79800000    20.49400000
H       11.79500000    -4.56000000    20.79100000
H       11.73500000    -3.21300000    19.86700000
H       10.98100000    -3.24600000    21.31700000
H        9.40600000    -4.95900000    20.53700000
H       10.22400000    -4.92400000    18.96600000
H        9.31129300    -3.49198500    19.52120000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004THR-163LEU-1')] = qcdb.Molecule("""
0 1
C       28.76100000    35.00300000    -2.78600000
C       29.62800000    36.20000000    -2.43000000
H       27.94000000    34.91000000    -2.07600000
H       28.34400000    35.15300000    -3.78300000
H       29.33700000    34.08000000    -2.79600000
H       30.41900000    36.31200000    -3.17300000
H       30.07970000    36.02359000    -1.44265800
H       29.02991000    37.12270000    -2.39978600
--
0 1
C       29.87500000    32.69100000    -5.66500000
C       31.43800000    32.78300000    -5.53500000
H       29.55500000    33.18800000    -6.58200000
H       29.56900000    31.64600000    -5.70300000
H       29.39600000    33.16700000    -4.81500000
H       31.67500000    32.33200000    -4.57800000
H       31.79549000    33.82227000    -5.48907700
H       31.96399000    32.22448000    -6.32328400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004THR-164GLU-1')] = qcdb.Molecule("""
0 1
C      -11.68600000     0.57800000   -21.57200000
C      -12.01300000     1.83600000   -20.77400000
C      -10.18600000     0.46300000   -21.79500000
O      -12.14200000    -0.57100000   -20.86800000
H      -12.16700000     0.62500000   -22.54800000
H      -11.54200000     1.77800000   -19.80600000
H       -9.98000000    -0.45800000   -22.34100000
H       -9.80300000     1.28800000   -22.39500000
H       -9.66000000     0.42300000   -20.84200000
H      -13.08700000    -0.61300000   -21.10500000
H      -13.10049000     1.94391300   -20.64861000
H      -11.64031000     2.70440100   -21.33701000
--
-1 1
C      -14.05800000    -1.11300000   -24.77000000
C      -14.60800000    -1.30200000   -23.36400000
O      -14.48400000    -0.34800000   -22.55300000
O      -15.14700000    -2.40900000   -23.09900000
H      -13.74700000    -2.08100000   -25.17700000
H      -13.15400000    -0.50800000   -24.71100000
H      -14.84811000    -0.70127180   -25.41514000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004TRP-014ARG-2')] = qcdb.Molecule("""
0 1
C       21.31400000     1.74000000     2.00000000
C       19.98500000     0.56300000     3.89800000
C       21.16400000     1.17300000     3.36400000
C       20.28000000     0.15100000     5.22400000
C       22.09800000     1.12700000     4.35100000
C       18.71200000     0.31500000     3.38000000
C       17.77500000    -0.33000000     4.18000000
C       18.09000000    -0.71900000     5.49000000
C       19.34600000    -0.48200000     6.03100000
N       21.57600000     0.51800000     5.46900000
H       18.47400000     0.61900000     2.37200000
H       16.78600000    -0.53800000     3.79300000
H       17.33800000    -1.21000000     6.09400000
H       22.05300000     2.54300000     2.02200000
H       20.35900000     2.18300000     1.71300000
H       23.10900000     1.51700000     4.26700000
H       22.08200000     0.38600000     6.34000000
H       19.59000000    -0.78100000     7.04200000
H       21.60408000     0.99510630     1.24436300
--
0 1
C       16.43100000     2.96300000     2.16900000
C       15.55700000     2.28300000     1.11100000
C       16.40500000     4.49400000     2.13600000
H       16.54000000     2.50600000     3.12000000
H       17.44000000     2.74600000     1.81200000
H       15.93300000     2.55500000     0.12800000
H       16.98900000     4.84100000     1.28200000
H       15.38500000     4.85100000     2.00600000
H       14.50872000     2.60601300     1.19326300
H       15.60270000     1.18832200     1.20893300
H       16.79097000     4.96589300     3.05161300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004TRP-016LYS-1')] = qcdb.Molecule("""
0 1
C       21.31400000     1.74000000     2.00000000
C       19.98500000     0.56300000     3.89800000
C       21.16400000     1.17300000     3.36400000
C       20.28000000     0.15100000     5.22400000
C       22.09800000     1.12700000     4.35100000
C       18.71200000     0.31500000     3.38000000
C       19.34600000    -0.48200000     6.03100000
C       17.77500000    -0.33000000     4.18000000
C       18.09000000    -0.71900000     5.49000000
N       21.57600000     0.51800000     5.46900000
H       18.47400000     0.61900000     2.37200000
H       22.05300000     2.54300000     2.02200000
H       20.35900000     2.18300000     1.71300000
H       23.10900000     1.51700000     4.26700000
H       22.08200000     0.38600000     6.34000000
H       19.59000000    -0.78100000     7.04200000
H       16.78600000    -0.53800000     3.79300000
H       17.33800000    -1.21000000     6.09400000
H       21.60408000     0.99510630     1.24436300
--
0 1
C       20.35900000    -2.93800000     2.90500000
C       19.71800000    -3.30900000     1.54300000
C       21.69800000    -3.60600000     3.28500000
H       20.51700000    -1.86100000     2.91200000
H       19.63300000    -3.16500000     3.68900000
H       20.37200000    -2.92400000     0.75100000
H       21.60900000    -4.68800000     3.20600000
H       22.47800000    -3.26000000     2.60600000
H       18.70974000    -2.87688800     1.46122900
H       19.65870000    -4.40339700     1.44929900
H       21.96304000    -3.36640600     4.32536000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004TYR-075PRO-1')] = qcdb.Molecule("""
0 1
C       -8.49700000    22.08200000     5.84700000
C       -4.25900000    22.49400000     6.55200000
C       -4.84700000    23.09700000     5.44500000
C       -5.03400000    21.74100000     7.43300000
C       -6.20200000    22.92700000     5.20600000
C       -6.39000000    21.54800000     7.16200000
C       -6.99000000    22.14400000     6.04800000
O       -2.94000000    22.70900000     6.82200000
H       -2.51500000    23.20700000     6.12100000
H       -4.25900000    23.70700000     4.77500000
H       -4.57700000    21.30100000     8.30600000
H       -6.64900000    23.42600000     4.35900000
H       -6.98900000    20.95100000     7.82800000
H       -8.84900000    21.13900000     6.26700000
H       -8.72800000    22.06100000     4.78400000
H       -9.04838100    22.89699000     6.33869600
--
0 1
C       -1.52400000    25.53600000     6.70000000
C       -2.65800000    26.45100000     6.26000000
C       -0.35200000    26.49000000     6.94400000
H       -1.28900000    24.78400000     5.94800000
H       -1.79200000    25.05800000     7.64400000
H       -2.54900000    26.70600000     5.20700000
H       -3.63300000    25.99700000     6.43500000
H        0.28500000    26.08200000     7.72700000
H       -2.51275800    27.34932000     6.87800300
H       -0.84791940    27.41552000     7.27184900
H        0.24772080    26.66516000     6.03865200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004TYR-105LEU-1')] = qcdb.Molecule("""
0 1
C       -8.49700000    22.08200000     5.84700000
C       -9.27300000    23.22900000     6.53900000
C       -6.99000000    22.14400000     6.04800000
C       -6.20200000    22.92700000     5.20600000
C       -6.39000000    21.54800000     7.16200000
C       -4.84700000    23.09700000     5.44500000
C       -5.03400000    21.74100000     7.43300000
C       -4.25900000    22.49400000     6.55200000
O       -2.94000000    22.70900000     6.82200000
H       -8.84900000    21.13900000     6.26700000
H       -8.72800000    22.06100000     4.78400000
H      -10.30100000    22.90000000     6.69500000
H       -6.64900000    23.42600000     4.35900000
H       -6.98900000    20.95100000     7.82800000
H       -4.25900000    23.70700000     4.77500000
H       -4.57700000    21.30100000     8.30600000
H       -2.51500000    23.20700000     6.12100000
H       -9.29318100    24.15060000     5.93880000
H       -8.83306700    23.43818000     7.52525600
--
0 1
C       -7.35600000    18.61300000     5.09000000
C       -7.29800000    17.16600000     4.59900000
H       -8.38600000    18.96600000     5.11700000
H       -6.94700000    18.67100000     6.09900000
H       -6.76600000    19.25800000     4.43800000
H       -7.89700000    16.55800000     5.26900000
H       -7.69157400    17.07838000     3.57556400
H       -6.26412700    16.79136000     4.62637800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '004VAL-053LEU-1')] = qcdb.Molecule("""
0 1
C       -4.05200000   -11.72000000     7.60400000
C       -3.17300000   -11.52300000     8.82800000
H       -3.92100000   -12.72700000     7.23000000
H       -5.07700000   -11.66000000     7.96800000
H       -3.88700000   -10.96100000     6.83900000
H       -3.36800000   -12.34200000     9.52000000
H       -2.10807200   -11.54304000     8.55318000
H       -3.43573700   -10.57874000     9.32734600
--
0 1
C       -6.95300000   -10.89100000     5.65100000
C       -6.46200000   -10.83000000     4.20500000
C       -7.59400000    -9.61100000     6.19200000
H       -7.68900000   -11.69500000     5.73100000
H       -6.12200000   -11.15300000     6.27500000
H       -5.63800000   -10.12200000     4.14600000
H       -8.44500000    -9.34300000     5.56700000
H       -7.28306800   -10.50233000     3.55041600
H       -6.07792000   -11.82209000     3.92527400
H       -7.98868100    -9.76728800     7.20679100
H       -6.87924200    -8.77543800     6.16108000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ALA-019PHE-1')] = qcdb.Molecule("""
0 1
C        5.39800000    27.27800000     8.47100000
C        4.79600000    27.58900000     9.84400000
H        4.62400000    27.34900000     7.70800000
H        6.19000000    27.99300000     8.24800000
H        5.80800000    26.26700000     8.46900000
H        5.56300000    27.45700000    10.60500000
H        3.93599200    26.93509000    10.05086000
H        4.44666700    28.63194000     9.85991200
--
0 1
C        8.00500000    24.69300000     5.34800000
C        8.39700000    26.38700000     7.17900000
C        8.68700000    25.15200000     6.59200000
C        9.02200000    26.74300000     8.35900000
C        9.95900000    25.89400000     8.96400000
C        9.61900000    24.30700000     7.19100000
C       10.25000000    24.67200000     8.38300000
H        7.68800000    27.05900000     6.71800000
H        8.79400000    27.69500000     8.81500000
H        6.95200000    24.96800000     5.41200000
H        8.02500000    23.60700000     5.31400000
H       10.45100000    26.19000000     9.88000000
H        9.84600000    23.35400000     6.73600000
H       10.98200000    24.01600000     8.82900000
H        8.43010500    25.08453000     4.41205500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ARG-012GLU-1')] = qcdb.Molecule("""
1 1
C        0.01900000   -12.24500000     2.37200000
C        0.22300000    -9.83900000     1.84900000
N        0.66900000   -11.08600000     1.75700000
N       -0.87800000    -9.57200000     2.52900000
N        0.87600000    -8.85300000     1.26400000
H        1.57500000   -11.24100000     1.31700000
H        0.56800000   -13.14900000     2.09900000
H       -1.00300000   -12.34300000     1.99900000
H       -1.44200000   -10.32000000     2.89200000
H       -1.21900000    -8.62500000     2.58900000
H        1.72400000    -9.06300000     0.75200000
H        0.52800000    -7.90900000     1.29900000
H        0.01611679   -12.14697000     3.46761900
--
-1 1
C        5.70800000   -11.19700000     1.12200000
C        4.22800000   -11.03400000     0.80600000
O        3.43600000   -11.93000000     1.17400000
O        3.84800000   -10.01400000     0.18900000
H        6.04800000   -12.18100000     0.79100000
H        5.84700000   -11.12800000     2.20400000
H        6.31256600   -10.42663000     0.62097030
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ARG-071GLU-1')] = qcdb.Molecule("""
1 1
C        3.69000000     1.17800000     9.65700000
C        5.89300000     2.10500000    10.26700000
N        6.46800000     0.95000000     9.98900000
N        4.58400000     2.24900000    10.11300000
N        6.62900000     3.10900000    10.69900000
H        5.91600000     0.16800000     9.69300000
H        7.49000000     0.89000000     9.89100000
H        4.18700000     3.12900000    10.38500000
H        6.22600000     4.01600000    10.92500000
H        7.61200000     2.96300000    10.84200000
H        3.74200000     0.36200000    10.38300000
H        4.02000000     0.78400000     8.69500000
H        2.63834300     1.49675000     9.60785000
--
-1 1
C       11.24700000    -0.42600000     8.69400000
C       10.21400000    -0.01300000     9.73300000
O        9.20000000     0.61300000     9.35500000
O       10.40400000    -0.31300000    10.93100000
H       11.22600000     0.30100000     7.88000000
H       10.99000000    -1.38100000     8.25200000
H       12.27414000    -0.41084190     9.08738800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ARG-158LEU-2')] = qcdb.Molecule("""
1 1
C        3.69000000     1.17800000     9.65700000
C        5.89300000     2.10500000    10.26700000
N        4.58400000     2.24900000    10.11300000
N        6.46800000     0.95000000     9.98900000
N        6.62900000     3.10900000    10.69900000
H        4.18700000     3.12900000    10.38500000
H        5.91600000     0.16800000     9.69300000
H        7.49000000     0.89000000     9.89100000
H        6.22600000     4.01600000    10.92500000
H        7.61200000     2.96300000    10.84200000
H        3.74200000     0.36200000    10.38300000
H        4.02000000     0.78400000     8.69500000
H        2.63834300     1.49675000     9.60785000
--
0 1
C        7.02200000     3.88600000     7.38700000
C        5.66000000     3.70000000     6.73000000
H        6.97800000     4.60500000     8.18800000
H        7.34400000     2.93900000     7.81600000
H        7.75400000     4.21300000     6.64800000
H        4.92300000     3.46800000     7.49600000
H        5.36780700     4.62119900     6.20462900
H        5.70113800     2.86713700     6.01261200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ASP-103GLN-1')] = qcdb.Molecule("""
-1 1
C       25.65400000    -5.20500000    -2.23100000
C       25.43700000    -3.85300000    -1.56500000
O       24.27400000    -3.40300000    -1.47500000
O       26.43300000    -3.22700000    -1.14000000
H       26.34900000    -5.06000000    -3.05900000
H       24.71500000    -5.57700000    -2.64500000
H       26.07672000    -5.94638300    -1.53698600
--
0 1
C       20.47200000    -3.51400000    -4.98900000
C       21.86200000    -3.47900000    -4.39000000
O       22.77100000    -4.18400000    -4.82900000
N       22.04600000    -2.65000000    -3.38200000
H       22.89500000    -2.79800000    -2.84400000
H       21.24300000    -2.16400000    -2.99300000
H       20.29300000    -2.52200000    -5.40000000
H       19.74800000    -3.70100000    -4.19400000
H       20.36287000    -4.28438200    -5.76656200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ASP-128ARG-1')] = qcdb.Molecule("""
-1 1
C       25.65400000    -5.20500000    -2.23100000
C       25.43700000    -3.85300000    -1.56500000
O       26.43300000    -3.22700000    -1.14000000
O       24.27400000    -3.40300000    -1.47500000
H       26.34900000    -5.06000000    -3.05900000
H       24.71500000    -5.57700000    -2.64500000
H       26.07672000    -5.94638300    -1.53698600
--
1 1
C       24.99900000     1.39700000     1.87000000
C       25.42800000     0.25700000    -0.27700000
N       25.96700000    -0.77600000     0.34700000
N       24.96500000     1.29400000     0.40900000
N       25.34500000     0.24400000    -1.59200000
H       26.12800000    -0.74800000     1.33700000
H       26.23900000    -1.60600000    -0.18800000
H       24.58500000     2.07500000    -0.10800000
H       24.99500000     1.04900000    -2.09100000
H       25.76800000    -0.51400000    -2.10800000
H       24.78900000     2.42800000     2.16300000
H       25.98900000     1.13800000     2.25100000
H       24.23304000     0.74076910     2.30893100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ILE-054SER-1')] = qcdb.Molecule("""
0 1
C        6.62100000    31.81300000     8.89600000
C        7.03300000    30.65300000     9.79400000
H        6.74600000    31.56500000     7.84700000
H        5.58000000    32.05800000     9.08700000
H        7.23100000    32.68700000     9.12400000
H        6.36000000    29.81600000     9.60800000
H        6.87100000    30.96800000    10.82300000
H        8.06991700    30.31285000     9.65579200
--
0 1
C        4.91500000    30.60900000     5.74800000
C        3.73700000    29.64800000     5.83400000
O        6.12600000    29.92800000     5.99600000
H        4.93900000    31.08500000     4.77100000
H        4.79600000    31.38400000     6.50500000
H        3.80600000    28.94100000     5.00900000
H        6.47700000    29.56700000     5.15900000
H        2.79276900    30.20472000     5.74184300
H        3.78600000    29.07585000     6.77221200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ILE-234TYR-1')] = qcdb.Molecule("""
0 1
C       33.81500000    35.84500000    23.03600000
C       32.72500000    36.58800000    23.74700000
H       33.65300000    35.87900000    21.95900000
H       34.77500000    36.29100000    23.27000000
H       33.86200000    34.80700000    23.35300000
H       32.43100000    37.45200000    23.15000000
H       33.12700000    36.97000000    24.68700000
H       31.85112000    35.96246000    23.98158000
--
0 1
C       40.90400000    35.36800000    22.74800000
C       37.17900000    34.54900000    22.64800000
C       37.04900000    33.56100000    23.59700000
C       38.42800000    35.14000000    22.40900000
C       39.57400000    34.73200000    23.07500000
C       38.19900000    33.14500000    24.30400000
C       39.45700000    33.72400000    24.02400000
O       35.78900000    33.06000000    23.80100000
H       36.31100000    34.87200000    22.09300000
H       38.50100000    35.92200000    21.66400000
H       38.12300000    32.37200000    25.05300000
H       35.72200000    32.54500000    24.61200000
H       41.61200000    35.22500000    23.56600000
H       40.74200000    36.44200000    22.63500000
H       40.33500000    33.38300000    24.55700000
H       41.33127000    34.96663000    21.81722000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005ILE-277LEU-1')] = qcdb.Molecule("""
0 1
C       32.72500000    36.58800000    23.74700000
C       31.51800000    35.72400000    24.07100000
C       33.81500000    35.84500000    23.03600000
H       32.43100000    37.45200000    23.15000000
H       33.12700000    36.97000000    24.68700000
H       30.76600000    36.38500000    24.50500000
H       33.65300000    35.87900000    21.95900000
H       34.77500000    36.29100000    23.27000000
H       33.86200000    34.80700000    23.35300000
H       31.10606000    35.29635000    23.14503000
H       31.73367000    34.95488000    24.82727000
--
0 1
C       35.35800000    38.85800000    22.92500000
C       36.22000000    40.10200000    22.99000000
H       34.58700000    38.96500000    22.16000000
H       36.00000000    38.00900000    22.69200000
H       34.88900000    38.68900000    23.89600000
H       36.99400000    39.92400000    23.73500000
H       35.61152000    40.96778000    23.29030000
H       36.70525000    40.27473000    22.01804000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-010TRP-1')] = qcdb.Molecule("""
0 1
C        2.96900000    -2.87500000     7.14900000
C        4.25900000    -3.20500000     7.89100000
H        2.34500000    -2.21500000     7.75100000
H        3.21800000    -2.38000000     6.21100000
H        2.40900000    -3.77000000     6.89200000
H        4.85100000    -3.87700000     7.27100000
H        4.04458200    -3.69694100     8.85121800
H        4.85096800    -2.29217200     8.05323200
--
0 1
C       -1.74800000    -4.46400000     0.95600000
C       -1.99400000    -3.39100000     4.55300000
C       -1.28200000    -3.42700000     3.34300000
C       -2.06900000    -4.16200000     2.40000000
C       -3.17800000    -4.53500000     3.05500000
C       -0.32300000    -2.10000000     5.56200000
C       -1.54000000    -2.72000000     5.66800000
C        0.40700000    -2.11200000     4.37900000
C       -0.07100000    -2.73800000     3.26000000
N       -3.14300000    -4.07800000     4.33700000
H        0.07300000    -1.56500000     6.41500000
H       -2.12900000    -2.63400000     6.56700000
H        1.35600000    -1.59800000     4.33600000
H        0.47900000    -2.71300000     2.33300000
H       -3.91200000    -4.17900000     4.99000000
H       -3.99900000    -5.09500000     2.61500000
H       -1.36800000    -3.55800000     0.48300000
H       -2.67800000    -4.70000000     0.44700000
H       -1.03258800    -5.28859100     0.82096240
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-011PHE-1')] = qcdb.Molecule("""
0 1
C        2.96900000    -2.87500000     7.14900000
C        4.25900000    -3.20500000     7.89100000
H        2.34500000    -2.21500000     7.75100000
H        3.21800000    -2.38000000     6.21100000
H        2.40900000    -3.77000000     6.89200000
H        4.85100000    -3.87700000     7.27100000
H        4.04458200    -3.69694100     8.85121800
H        4.85096800    -2.29217200     8.05323200
--
0 1
C        3.03500000    -4.98400000     3.67700000
C        4.34400000    -4.30300000     3.95100000
C        4.52800000    -2.95800000     3.62300000
C        5.42000000    -5.02300000     4.45900000
C        5.77500000    -2.32800000     3.82400000
C        6.64300000    -4.37900000     4.67200000
C        6.81000000    -3.04300000     4.38700000
H        2.24400000    -4.41900000     4.17100000
H        3.04000000    -5.98900000     4.10100000
H        3.70900000    -2.38700000     3.21400000
H        5.31300000    -6.07400000     4.69300000
H        5.90500000    -1.28400000     3.57400000
H        7.47200000    -4.93900000     5.08300000
H        7.76300000    -2.56700000     4.57200000
H        2.81830300    -5.03925100     2.59997200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-015LYS-1')] = qcdb.Molecule("""
0 1
C       18.03500000     0.29600000    -5.35200000
C       18.77400000     1.33300000    -4.50100000
H       17.27100000    -0.19700000    -4.75100000
H       17.55300000     0.79000000    -6.19700000
H       18.73900000    -0.44800000    -5.72600000
H       18.02200000     2.06500000    -4.21700000
H       19.22884000     0.90029150    -3.59773900
H       19.53819000     1.84922600    -5.10060500
--
1 1
C       18.34600000    -2.99700000    -3.36900000
C       17.73700000    -2.98000000    -1.98700000
N       19.36200000    -4.07500000    -3.49400000
H       17.54800000    -3.14600000    -4.10700000
H       18.80900000    -2.02300000    -3.56800000
H       18.56700000    -2.95500000    -1.31100000
H       17.27000000    -3.95800000    -1.83400000
H       18.97300000    -4.99500000    -3.30300000
H       19.73600000    -4.11000000    -4.43800000
H       20.15500000    -3.93300000    -2.87600000
H       16.93324000    -2.23278600    -1.91184900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-023GLN-1')] = qcdb.Molecule("""
0 1
C       26.47500000     7.46700000    23.20100000
C       26.31600000     7.32700000    24.71000000
H       26.62200000     6.48700000    22.74300000
H       25.57900000     7.92500000    22.77800000
H       27.32800000     8.11000000    22.98000000
H       26.23300000     8.32600000    25.13400000
H       27.19782000     6.81961200    25.12827000
H       25.39917000     6.76516700    24.94189000
--
0 1
C       29.89000000     6.27000000    22.12400000
C       29.99600000     5.90500000    20.64200000
C       31.22000000     6.42700000    22.83400000
O       31.37300000     7.29600000    23.70200000
N       32.19300000     5.58800000    22.48700000
H       29.34400000     7.21000000    22.20900000
H       29.33100000     5.49900000    22.65500000
H       30.57800000     4.99300000    20.50500000
H       30.50400000     6.71800000    20.12000000
H       33.09500000     5.68900000    22.92900000
H       32.03500000     4.87200000    21.79200000
H       29.00219000     5.75718400    20.19425000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-025ILE-1')] = qcdb.Molecule("""
0 1
C        1.01100000    -8.37200000     3.18500000
C        0.05500000    -9.51200000     2.83600000
H        1.92700000    -8.77200000     3.61800000
H        1.26100000    -7.82200000     2.27900000
H        0.54600000    -7.68400000     3.89000000
H       -0.86200000    -9.08500000     2.43300000
H       -0.18018740   -10.12793000     3.71651900
H        0.48956250   -10.15229000     2.05422100
--
0 1
C        2.76900000    -8.38700000     6.56400000
C        3.26600000    -7.21000000     7.39200000
H        1.74500000    -8.22100000     6.23400000
H        3.40000000    -8.48900000     5.68200000
H        2.82600000    -9.31100000     7.13500000
H        3.23400000    -6.30900000     6.77900000
H        4.31500000    -7.38900000     7.63500000
H        2.71765200    -7.04800400     8.33171900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-025LEU-1')] = qcdb.Molecule("""
0 1
C       24.52400000    -3.37800000     9.76900000
C       25.15800000    -1.99500000     9.62200000
H       24.87200000    -3.85300000    10.68800000
H       23.44000000    -3.27100000     9.81000000
H       24.77200000    -4.00900000     8.91700000
H       24.81700000    -1.60400000     8.67500000
H       26.25445000    -2.07311500     9.58081200
H       24.85182000    -1.29841300    10.41637000
--
0 1
C       21.32400000    -4.88400000    11.33600000
C       21.17900000    -4.26000000    12.75500000
H       22.30800000    -5.34200000    11.22900000
H       20.55100000    -5.63700000    11.18100000
H       21.20700000    -4.10100000    10.58700000
H       20.19200000    -3.81500000    12.82000000
H       21.92943000    -3.47112500    12.91164000
H       21.26390000    -5.01398300    13.55143000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-030ASP-1')] = qcdb.Molecule("""
0 1
C       -2.28800000     5.22900000   -21.20400000
C       -3.12600000     5.31000000   -19.93700000
H       -1.27300000     4.90200000   -20.97400000
H       -2.74000000     4.50700000   -21.88100000
H       -2.25800000     6.20200000   -21.69600000
H       -3.10200000     4.34300000   -19.44000000
H       -2.72348900     6.08117900   -19.26375000
H       -4.17567500     5.53189400   -20.17979000
--
-1 1
C       -0.32100000     8.29600000   -22.46800000
C        0.01600000     9.62900000   -23.13700000
C        0.90500000     7.61700000   -21.88800000
O        1.87000000     7.37400000   -22.64400000
O        0.89600000     7.32700000   -20.67200000
H       -1.05000000     8.47100000   -21.67400000
H       -0.77900000     7.63400000   -23.20500000
H        0.67400000     9.42100000   -23.98100000
H        0.51656590    10.29792000   -22.42148000
H       -0.90341790    10.08257000   -23.53568000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-030LEU-2')] = qcdb.Molecule("""
0 1
C       13.81200000    65.73400000     6.39200000
C       14.57700000    64.48300000     6.83800000
H       13.15400000    66.07300000     7.19300000
H       14.51800000    66.53100000     6.15700000
H       13.21300000    65.51800000     5.50900000
H       15.26500000    64.21300000     6.03900000
H       13.86368000    63.65724000     6.97693900
H       15.18385000    64.68073000     7.73389800
--
0 1
C       15.17500000    66.18800000     2.96000000
C       15.06500000    64.85700000     2.22200000
H       15.73700000    66.05700000     3.88400000
H       15.66700000    66.91800000     2.33000000
H       14.17900000    66.56700000     3.19100000
H       14.55300000    65.04100000     1.27800000
H       14.48470000    64.15014000     2.83322400
H       16.06636000    64.45300000     2.01209500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-032MET-1')] = qcdb.Molecule("""
0 1
C       37.40900000    -0.66700000    57.59700000
C       38.60100000    -1.60800000    57.32900000
H       37.46900000    -0.26300000    58.60600000
H       37.43800000     0.15400000    56.88300000
H       36.46900000    -1.20600000    57.47200000
H       38.46200000    -2.09000000    56.36500000
H       38.70387000    -2.38240900    58.10341000
H       39.53907000    -1.03509300    57.28659000
--
0 1
C       34.49100000     1.61200000    57.92600000
C       33.42500000     2.53100000    58.57300000
C       34.91600000     1.98200000    56.51800000
H       35.38700000     1.67800000    58.54500000
H       34.20300000     0.56600000    58.00500000
H       32.55600000     2.60600000    57.92000000
H       35.34800000     2.98300000    56.50500000
H       35.66900000     1.27300000    56.17900000
H       33.84972000     3.53309200    58.73246000
H       33.09255000     2.07477800    59.51711000
H       34.06299000     1.94333800    55.82455000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-037ILE-1')] = qcdb.Molecule("""
0 1
C       16.04300000     9.19000000    21.23400000
C       17.10600000     8.37800000    21.98200000
H       16.41900000     9.55700000    20.27900000
H       15.19600000     8.54200000    21.01800000
H       15.69400000    10.02200000    21.85100000
H       17.58700000     7.69700000    21.29300000
H       17.87360000     9.03001700    22.42433000
H       16.66005000     7.79747200    22.80304000
--
0 1
C       13.30900000    11.37800000    19.98100000
C       13.97100000    11.92400000    18.69400000
C       11.81800000    11.08600000    19.82300000
H       13.81300000    10.46600000    20.29100000
H       13.39000000    12.09700000    20.79500000
H       13.33200000    12.71600000    18.30500000
H       11.65700000    10.27900000    19.11100000
H       11.39300000    10.79300000    20.77700000
H       11.30000000    11.97900000    19.48700000
H       14.96117000    12.35956000    18.89360000
H       14.04329000    11.13390000    17.93209000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-068ILE-1')] = qcdb.Molecule("""
0 1
C       29.82000000    13.31300000    -0.88600000
C       30.80800000    12.24900000    -1.35800000
H       28.93300000    13.31400000    -1.52200000
H       29.51100000    13.09900000     0.13400000
H       30.28600000    14.29700000    -0.90300000
H       31.75000000    12.37700000    -0.82800000
H       30.97118000    12.33632000    -2.44231800
H       30.42134000    11.24557000    -1.12643900
--
0 1
C       30.72500000    15.12000000     2.26400000
C       30.29800000    13.85700000     3.02200000
H       31.33900000    14.87400000     1.39900000
H       29.83600000    15.64100000     1.90900000
H       31.27900000    15.78100000     2.93100000
H       29.84300000    13.15800000     2.32300000
H       29.52000000    14.14500000     3.72200000
H       31.11279000    13.34677000     3.55659200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-077LEU-1')] = qcdb.Molecule("""
0 1
C        2.96900000    -2.87500000     7.14900000
C        4.25900000    -3.20500000     7.89100000
H        2.34500000    -2.21500000     7.75100000
H        3.21800000    -2.38000000     6.21100000
H        2.40900000    -3.77000000     6.89200000
H        4.85100000    -3.87700000     7.27100000
H        4.04458200    -3.69694100     8.85121800
H        4.85096800    -2.29217200     8.05323200
--
0 1
C        3.08400000     0.63500000     5.59600000
C        1.89900000     1.43600000     6.08400000
H        3.38800000    -0.09400000     6.34400000
H        2.82000000     0.10100000     4.68900000
H        3.92300000     1.29400000     5.39200000
H        1.04000000     0.77200000     6.01800000
H        2.04404300     1.71085600     7.13918600
H        1.70050100     2.30523700     5.43977600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-083HIE-1')] = qcdb.Molecule("""
0 1
C       15.42100000    64.75800000     8.08400000
C       14.57700000    64.48300000     6.83800000
H       16.03400000    63.89800000     8.34000000
H       16.08300000    65.59800000     7.88500000
H       14.78300000    65.02000000     8.92200000
H       15.26500000    64.21300000     6.03900000
H       13.86368000    63.65724000     6.97693900
H       14.02797000    65.38083000     6.51790900
--
0 1
C       18.86000000    63.73600000     9.70500000
C       17.99100000    64.18300000    10.84500000
C       17.86000000    65.39300000    11.45300000
C       16.49700000    63.98500000    12.44800000
N       17.12100000    63.32000000    11.47900000
N       16.92400000    65.24200000    12.44700000
H       18.29300000    63.04400000     9.09600000
H       19.71600000    63.19200000    10.10500000
H       18.36900000    66.30400000    11.20400000
H       15.74600000    63.57800000    13.11700000
H       16.58500000    65.98100000    13.06800000
H       19.19619000    64.55393000     9.05080500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-106TYR-1')] = qcdb.Molecule("""
0 1
C       25.03500000     6.54200000    25.03400000
C       26.31600000     7.32700000    24.71000000
H       24.85500000     6.48200000    26.10300000
H       24.17800000     7.02000000    24.55900000
H       25.12200000     5.53200000    24.64200000
H       26.23300000     8.32600000    25.13400000
H       27.19782000     6.81961200    25.12827000
H       26.43078000     7.42806300    23.62068000
--
0 1
C       21.90600000     9.45700000    20.42500000
C       22.54400000     9.14200000    24.16500000
C       23.55700000    10.06200000    24.33600000
C       21.98900000     8.96000000    22.89300000
C       22.47100000     9.66800000    21.80900000
C       24.00700000    10.79000000    23.24300000
C       23.48600000    10.58700000    21.98900000
O       24.08900000    10.24100000    25.57500000
H       22.16600000     8.58100000    25.00400000
H       21.18500000     8.24600000    22.75600000
H       24.49500000    11.71100000    23.34100000
H       23.85900000     9.51000000    26.17600000
H       21.40200000     8.49300000    20.38400000
H       22.77200000     9.37100000    19.76500000
H       23.81500000    11.19900000    21.15500000
H       21.23850000    10.24135000    20.03867000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005LEU-191TYR-1')] = qcdb.Molecule("""
0 1
C       -4.58300000     5.61800000   -20.27400000
C       -3.12600000     5.31000000   -19.93700000
H       -4.65100000     6.57400000   -20.79900000
H       -4.99300000     4.83300000   -20.91000000
H       -5.17800000     5.67800000   -19.36000000
H       -3.10200000     4.34300000   -19.44000000
H       -2.72348900     6.08117900   -19.26375000
H       -2.52003700     5.25142800   -20.85318000
--
0 1
C       -9.77900000     5.95400000   -17.21400000
C       -7.86000000     7.30200000   -20.20900000
C       -7.87400000     8.66800000   -19.95700000
C       -8.47600000     6.42800000   -19.31700000
C       -9.11000000     6.90700000   -18.17400000
C       -8.50000000     9.15800000   -18.82000000
C       -9.11200000     8.28000000   -17.93300000
O       -7.27600000     9.52700000   -20.82600000
H       -7.35900000     6.92800000   -21.09100000
H       -8.43300000     5.36300000   -19.49800000
H       -8.50600000    10.21600000   -18.63100000
H       -7.37700000    10.44500000   -20.56500000
H       -9.46200000     6.19600000   -16.19900000
H       -9.42000000     4.94300000   -17.41300000
H       -9.58100000     8.67400000   -17.04000000
H      -10.87746000     5.96332100   -17.27136000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-022VAL-1')] = qcdb.Molecule("""
0 1
C        9.03000000    82.15700000    38.28800000
C        8.91400000    85.84600000    36.12800000
C        9.33200000    85.82800000    37.46300000
C        8.54500000    84.65700000    35.48700000
C        9.38300000    84.61600000    38.15400000
C        8.59500000    83.44400000    36.18600000
C        9.01300000    83.42900000    37.51900000
H        8.87700000    86.78200000    35.59200000
H        9.61100000    86.75000000    37.95600000
H        8.22100000    84.67500000    34.45500000
H        9.70700000    84.59100000    39.18600000
H        8.30700000    82.52200000    35.69600000
H        9.98900000    82.10800000    38.79600000
H        8.96800000    81.34600000    37.56200000
H        8.23208200    82.08251000    39.04151000
--
0 1
C        6.73600000    88.35600000    34.99000000
C        5.73900000    89.46100000    34.78800000
H        7.59000000    88.51800000    34.33100000
H        7.07300000    88.35500000    36.02600000
H        6.26800000    87.40300000    34.75300000
H        6.26800000    90.38300000    34.98800000
H        5.40620400    89.45888000    33.73955000
H        4.88689900    89.37550000    35.47837000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-031TYR-1')] = qcdb.Molecule("""
0 1
C       38.29500000    24.59800000    -0.77600000
C       36.32000000    23.05500000    -3.65800000
C       36.61900000    23.77100000    -2.49300000
C       37.33000000    22.36700000    -4.34900000
C       37.94100000    23.81300000    -2.01200000
C       38.65100000    22.40100000    -3.86700000
C       38.94300000    23.12600000    -2.69900000
H       35.30700000    23.04400000    -4.03500000
H       35.83800000    24.31000000    -1.97500000
H       37.09200000    21.81600000    -5.24400000
H       39.43700000    21.87600000    -4.39400000
H       37.78100000    25.54200000    -0.79600000
H       39.35400000    24.85400000    -0.83800000
H       39.96200000    23.15500000    -2.33800000
H       38.13564000    24.06249000     0.17154330
--
0 1
C       36.10800000    27.59000000    -8.95200000
C       35.27000000    24.36700000    -7.10400000
C       35.98500000    25.38400000    -7.74700000
C       33.88300000    24.47400000    -6.97300000
C       35.32900000    26.50100000    -8.26000000
C       33.21300000    25.58600000    -7.48400000
C       33.94300000    26.59300000    -8.12500000
O       33.17900000    23.48900000    -6.34200000
H       35.79100000    23.51200000    -6.70700000
H       37.05600000    25.31100000    -7.83500000
H       33.75900000    22.71100000    -6.26600000
H       32.14400000    25.66900000    -7.37700000
H       36.74800000    28.07800000    -8.21500000
H       35.41700000    28.33500000    -9.34500000
H       33.42000000    27.45400000    -8.52000000
H       36.73240000    27.21406000    -9.77589100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-037PHE-1')] = qcdb.Molecule("""
0 1
C       38.29500000    24.59800000    -0.77600000
C       37.33000000    22.36700000    -4.34900000
C       36.32000000    23.05500000    -3.65800000
C       38.65100000    22.40100000    -3.86700000
C       36.61900000    23.77100000    -2.49300000
C       38.94300000    23.12600000    -2.69900000
C       37.94100000    23.81300000    -2.01200000
H       37.09200000    21.81600000    -5.24400000
H       35.30700000    23.04400000    -4.03500000
H       39.43700000    21.87600000    -4.39400000
H       35.83800000    24.31000000    -1.97500000
H       39.96200000    23.15500000    -2.33800000
H       37.78100000    25.54200000    -0.79600000
H       39.35400000    24.85400000    -0.83800000
H       38.13564000    24.06249000     0.17154330
--
0 1
C       37.82800000    21.96500000    -9.80300000
C       38.64300000    23.18000000    -7.74100000
C       38.55900000    23.10000000    -9.14300000
C       39.38000000    24.20100000    -7.13300000
C       39.21100000    24.05300000    -9.92600000
C       40.04200000    25.15700000    -7.92800000
C       39.95100000    25.07800000    -9.33100000
H       38.14900000    22.44000000    -7.13200000
H       39.44600000    24.24900000    -6.05400000
H       37.62000000    22.20500000   -10.84700000
H       36.87200000    21.86900000    -9.29000000
H       39.09400000    24.01000000   -10.99500000
H       40.61400000    25.95000000    -7.46400000
H       40.44000000    25.82000000    -9.94700000
H       38.36309000    21.00588000    -9.74170300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-043TYR-1')] = qcdb.Molecule("""
0 1
C        9.03000000    82.15700000    38.28800000
C        9.38300000    84.61600000    38.15400000
C        9.01300000    83.42900000    37.51900000
C        9.33200000    85.82800000    37.46300000
C        8.91400000    85.84600000    36.12800000
C        8.59500000    83.44400000    36.18600000
C        8.54500000    84.65700000    35.48700000
H        9.70700000    84.59100000    39.18600000
H        9.61100000    86.75000000    37.95600000
H        9.98900000    82.10800000    38.79600000
H        8.96800000    81.34600000    37.56200000
H        8.87700000    86.78200000    35.59200000
H        8.30700000    82.52200000    35.69600000
H        8.22100000    84.67500000    34.45500000
H        8.23208200    82.08251000    39.04151000
--
0 1
C       13.64800000    85.66400000    38.42300000
C       12.67400000    83.53600000    39.42900000
C       13.66500000    84.53300000    39.43700000
C       12.66400000    82.52400000    40.42400000
C       13.67000000    82.51400000    41.41300000
C       14.65600000    84.50100000    40.42100000
C       14.66200000    83.50600000    41.39800000
O       13.73400000    81.56200000    42.40300000
H       11.91600000    83.54800000    38.65500000
H       11.89500000    81.76200000    40.43700000
H       13.41800000    85.25400000    37.44000000
H       14.63400000    86.13100000    38.39200000
H       15.42400000    85.25800000    40.42100000
H       13.02100000    80.90600000    42.35200000
H       15.43700000    83.49600000    42.15200000
H       12.90169000    86.45387000    38.59369000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-049LYS-1')] = qcdb.Molecule("""
0 1
C       38.29500000    24.59800000    -0.77600000
C       37.33000000    22.36700000    -4.34900000
C       36.32000000    23.05500000    -3.65800000
C       38.65100000    22.40100000    -3.86700000
C       36.61900000    23.77100000    -2.49300000
C       38.94300000    23.12600000    -2.69900000
C       37.94100000    23.81300000    -2.01200000
H       37.09200000    21.81600000    -5.24400000
H       35.30700000    23.04400000    -4.03500000
H       39.43700000    21.87600000    -4.39400000
H       35.83800000    24.31000000    -1.97500000
H       39.96200000    23.15500000    -2.33800000
H       37.78100000    25.54200000    -0.79600000
H       39.35400000    24.85400000    -0.83800000
H       38.13564000    24.06249000     0.17154330
--
0 1
C       36.61800000    19.09500000    -6.18400000
C       35.09800000    18.98300000    -6.29000000
C       37.36600000    17.85700000    -6.69700000
H       36.94500000    19.95700000    -6.77000000
H       36.89600000    19.28300000    -5.15400000
H       34.77800000    18.08100000    -5.77400000
H       37.09400000    16.99300000    -6.09300000
H       37.09500000    17.65900000    -7.73300000
H       34.81577000    18.92791000    -7.35175000
H       34.65643000    19.89271000    -5.85704600
H       38.44981000    18.03489000    -6.63603100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-050TRP-1')] = qcdb.Molecule("""
0 1
C       38.29500000    24.59800000    -0.77600000
C       37.33000000    22.36700000    -4.34900000
C       36.32000000    23.05500000    -3.65800000
C       38.65100000    22.40100000    -3.86700000
C       36.61900000    23.77100000    -2.49300000
C       38.94300000    23.12600000    -2.69900000
C       37.94100000    23.81300000    -2.01200000
H       37.09200000    21.81600000    -5.24400000
H       35.30700000    23.04400000    -4.03500000
H       39.43700000    21.87600000    -4.39400000
H       35.83800000    24.31000000    -1.97500000
H       39.96200000    23.15500000    -2.33800000
H       37.78100000    25.54200000    -0.79600000
H       39.35400000    24.85400000    -0.83800000
H       38.13564000    24.06249000     0.17154330
--
0 1
C       34.16500000    18.93700000    -2.42400000
C       36.69100000    19.33700000    -2.49300000
C       35.59900000    18.54000000    -2.66600000
C       37.50100000    17.36300000    -3.20500000
C       36.08300000    17.26400000    -3.13200000
C       38.31200000    16.31600000    -3.62600000
C       35.46800000    16.05700000    -3.50900000
C       37.68500000    15.13900000    -3.99700000
C       36.27600000    15.00500000    -3.95100000
N       37.82900000    18.63300000    -2.80800000
H       36.65900000    20.37100000    -2.16100000
H       38.76500000    19.02000000    -2.76700000
H       34.12900000    19.89000000    -1.89700000
H       33.70000000    18.17800000    -1.79400000
H       39.38800000    16.41800000    -3.65700000
H       34.39700000    15.94900000    -3.45000000
H       38.28300000    14.30000000    -4.32800000
H       35.82500000    14.06700000    -4.24100000
H       33.61521000    19.00815000    -3.37409000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-155SER-1')] = qcdb.Molecule("""
0 1
C       25.62500000    36.81300000    60.01000000
C       25.88500000    37.86300000    62.27800000
C       26.30200000    36.91300000    61.34600000
C       26.50600000    37.95900000    63.52400000
C       27.34800000    36.05400000    61.67200000
C       27.55400000    37.09800000    63.84500000
C       27.97500000    36.14200000    62.91700000
H       25.05600000    38.51300000    62.04900000
H       26.16100000    38.68400000    64.24800000
H       26.26200000    36.26600000    59.31500000
H       25.50700000    37.82400000    59.62100000
H       27.66500000    35.29900000    60.96800000
H       28.01300000    37.16900000    64.81600000
H       28.75200000    35.43700000    63.15700000
H       24.63973000    36.32504000    60.04383000
--
0 1
C       26.00000000    41.40800000    62.38700000
C       24.55500000    41.88700000    62.20400000
O       26.93000000    42.44200000    62.09800000
H       26.14600000    41.07300000    63.41100000
H       26.19000000    40.56500000    61.72300000
H       23.87500000    41.19100000    62.69800000
H       26.93200000    43.09200000    62.82500000
H       24.30545000    41.97397000    61.13622000
H       24.44934000    42.88169000    62.66163000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-162GLN-1')] = qcdb.Molecule("""
0 1
C       25.62500000    36.81300000    60.01000000
C       27.55400000    37.09800000    63.84500000
C       27.97500000    36.14200000    62.91700000
C       26.50600000    37.95900000    63.52400000
C       27.34800000    36.05400000    61.67200000
C       25.88500000    37.86300000    62.27800000
C       26.30200000    36.91300000    61.34600000
H       28.01300000    37.16900000    64.81600000
H       28.75200000    35.43700000    63.15700000
H       26.16100000    38.68400000    64.24800000
H       27.66500000    35.29900000    60.96800000
H       25.05600000    38.51300000    62.04900000
H       26.26200000    36.26600000    59.31500000
H       25.50700000    37.82400000    59.62100000
H       24.63973000    36.32504000    60.04383000
--
0 1
C       30.76700000    36.07100000    65.30400000
C       31.04300000    37.57200000    65.41200000
C       29.66600000    35.64300000    66.25800000
O       29.12000000    36.45900000    66.99700000
N       29.33500000    34.35700000    66.25200000
H       30.47500000    35.78800000    64.30000000
H       31.67500000    35.52200000    65.55800000
H       31.36500000    37.81400000    66.42700000
H       30.13500000    38.12600000    65.18300000
H       28.63000000    34.04800000    66.90800000
H       29.91800000    33.69900000    65.76100000
H       31.84091000    37.85048000    64.70788000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PHE-163LEU-1')] = qcdb.Molecule("""
0 1
C       25.62500000    36.81300000    60.01000000
C       24.25600000    36.13500000    60.05700000
C       26.30200000    36.91300000    61.34600000
C       27.34800000    36.05400000    61.67200000
C       25.88500000    37.86300000    62.27800000
C       27.97500000    36.14200000    62.91700000
C       26.50600000    37.95900000    63.52400000
C       27.55400000    37.09800000    63.84500000
H       26.26200000    36.26600000    59.31500000
H       25.50700000    37.82400000    59.62100000
H       23.63700000    36.69200000    60.76200000
H       27.66500000    35.29900000    60.96800000
H       25.05600000    38.51300000    62.04900000
H       28.75200000    35.43700000    63.15700000
H       26.16100000    38.68400000    64.24800000
H       28.01300000    37.16900000    64.81600000
H       24.35230000    35.08853000    60.38200000
H       23.77677000    36.22608000    59.07108000
--
0 1
C       28.83000000    38.01300000    58.52900000
C       29.07400000    39.38700000    59.14000000
H       28.24800000    37.39500000    59.20800000
H       28.28900000    38.12300000    57.59100000
H       29.75500000    37.50900000    58.28100000
H       29.87600000    39.87600000    58.58700000
H       29.35675000    39.30826000    60.20012000
H       28.16947000    40.00828000    59.06360000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005PRO-196ALA-1')] = qcdb.Molecule("""
0 1
C       36.58100000    13.97300000    28.17900000
C       37.28600000    13.79800000    29.50200000
C       38.14600000    12.12900000    28.01000000
C       35.64700000    13.43200000    25.38700000
C       36.66600000    12.54800000    26.11000000
O       37.12200000    11.54200000    25.55400000
N       37.08100000    12.87300000    27.34800000
H       35.50100000    13.91700000    28.31600000
H       36.86200000    14.93000000    27.74300000
H       36.68500000    13.16300000    30.15600000
H       37.48500000    14.75700000    29.98200000
H       38.98000000    11.95000000    27.33400000
H       35.29400000    14.23000000    26.03800000
H       38.21623000    13.27643000    29.23247000
H       38.44580000    12.81415000    28.81665000
H       37.81963000    11.15788000    28.41051000
H       36.14486000    13.86735000    24.50802000
H       34.77121000    12.84401000    25.07515000
--
0 1
C       33.96100000    16.59000000    27.93700000
C       33.17900000    17.46400000    26.92900000
H       33.64900000    15.54700000    27.85800000
H       35.03100000    16.66300000    27.73600000
H       33.77100000    16.94200000    28.95200000
H       33.50000000    18.50400000    27.02900000
H       32.09662000    17.39209000    27.11142000
H       33.41561000    17.08847000    25.92252000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005SER-028VAL-1')] = qcdb.Molecule("""
0 1
C       20.20000000    17.18800000    22.41000000
C       20.23200000    18.37600000    21.44500000
O       20.97200000    17.43300000    23.57700000
H       19.16800000    16.97400000    22.68700000
H       20.61000000    16.30800000    21.91400000
H       21.27400000    18.60500000    21.23500000
H       20.67100000    18.26500000    23.96900000
H       19.75167000    19.25097000    21.90729000
H       19.75343000    18.07923000    20.50007000
--
0 1
C       17.18800000    15.99900000    24.36100000
C       16.00900000    15.95800000    25.35000000
H       18.13000000    15.82800000    24.88400000
H       17.05300000    15.23300000    23.60300000
H       17.22200000    16.95500000    23.83900000
H       16.01000000    14.99500000    25.86100000
H       16.07033000    16.76872000    26.09093000
H       15.06670000    16.03755000    24.78809000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005TYR-166TYR-1')] = qcdb.Molecule("""
0 1
C       36.29500000    37.03500000    32.00100000
C       36.41500000    34.73000000    33.00600000
C       36.42500000    36.11200000    33.18100000
C       36.57200000    33.87300000    34.09800000
C       36.59200000    36.63000000    34.46900000
C       36.74500000    34.40000000    35.37800000
C       36.75300000    35.78200000    35.56700000
O       36.91700000    33.56600000    36.44300000
H       36.28900000    34.32300000    32.01900000
H       36.53300000    32.80400000    33.97500000
H       35.60600000    37.82700000    32.27700000
H       35.87900000    36.49900000    31.14700000
H       36.60000000    37.70300000    34.61800000
H       36.88600000    36.19600000    36.55600000
H       37.03200000    34.05200000    37.26600000
H       37.25164000    37.50357000    31.72664000
--
0 1
C       32.96000000    33.95200000    34.07400000
C       31.45900000    34.16300000    33.87300000
C       33.34800000    32.56500000    34.52500000
C       33.37600000    31.50500000    33.61600000
C       33.71600000    32.32800000    35.85200000
C       33.76500000    30.23100000    34.02200000
C       34.10900000    31.05300000    36.26800000
C       34.13400000    30.00500000    35.34900000
O       34.52000000    28.75800000    35.74100000
H       33.48000000    34.16900000    33.14100000
H       33.31700000    34.68000000    34.80500000
H       31.32000000    35.19200000    33.55100000
H       33.10500000    31.66600000    32.58300000
H       33.72100000    33.14300000    36.56500000
H       33.77900000    29.43500000    33.30000000
H       34.40700000    30.87600000    37.29100000
H       34.56300000    28.14100000    35.01100000
H       30.90566000    34.02845000    34.81412000
H       31.07422000    33.52674000    33.06237000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005TYR-168VAL-1')] = qcdb.Molecule("""
0 1
C       36.29500000    37.03500000    32.00100000
C       36.41500000    34.73000000    33.00600000
C       36.42500000    36.11200000    33.18100000
C       36.57200000    33.87300000    34.09800000
C       36.59200000    36.63000000    34.46900000
C       36.74500000    34.40000000    35.37800000
C       36.75300000    35.78200000    35.56700000
O       36.91700000    33.56600000    36.44300000
H       36.28900000    34.32300000    32.01900000
H       36.53300000    32.80400000    33.97500000
H       35.60600000    37.82700000    32.27700000
H       35.87900000    36.49900000    31.14700000
H       36.60000000    37.70300000    34.61800000
H       36.88600000    36.19600000    36.55600000
H       37.03200000    34.05200000    37.26600000
H       37.25164000    37.50357000    31.72664000
--
0 1
C       35.09700000    32.84400000    30.10400000
C       35.06600000    31.85300000    28.93600000
H       34.34000000    32.60400000    30.84900000
H       36.07600000    32.75300000    30.57600000
H       34.96800000    33.86900000    29.77300000
H       35.94200000    32.01400000    28.31600000
H       34.15413000    31.97064000    28.33213000
H       35.12276000    30.82912000    29.33406000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005VAL-008GLN-1')] = qcdb.Molecule("""
0 1
C       54.12200000    24.82700000    -1.85800000
C       52.63700000    25.00500000    -2.21700000
H       54.42500000    23.79300000    -2.02700000
H       54.74900000    25.45900000    -2.48400000
H       54.29800000    25.08600000    -0.81300000
H       52.28000000    25.96100000    -1.85700000
H       52.03420000    24.20390000    -1.76436300
H       52.49509000    25.02445000    -3.30763400
--
0 1
C       54.65000000    28.23100000    -0.15100000
C       53.15300000    28.15100000     0.08800000
C       55.04400000    28.18000000    -1.61700000
O       56.22700000    28.30600000    -1.93700000
N       54.08800000    27.97700000    -2.52100000
H       55.02500000    29.16400000     0.27200000
H       55.13700000    27.39800000     0.35600000
H       52.75900000    27.22900000    -0.31400000
H       52.67700000    28.99800000    -0.41100000
H       54.35900000    27.98000000    -3.49400000
H       53.11800000    27.94000000    -2.25900000
H       52.90084000    28.18785000     1.15807300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005VAL-023LEU-1')] = qcdb.Molecule("""
0 1
C       11.10000000     6.42100000    20.55500000
C        9.68800000     5.82100000    20.64400000
H       11.07700000     7.30500000    19.91800000
H       11.44300000     6.71300000    21.54900000
H       11.79200000     5.68900000    20.13700000
H        9.39400000     5.48700000    19.64800000
H        9.66871200     4.95946500    21.32766000
H        8.96585600     6.58850300    20.95935000
--
0 1
C       12.61300000     6.31800000    17.21100000
C       12.02600000     5.08800000    16.50500000
H       11.85400000     6.76200000    17.84700000
H       13.45500000     6.02900000    17.83700000
H       12.93800000     7.05700000    16.47600000
H       11.76000000     4.36400000    17.27400000
H       12.78139000     4.65181100    15.83483000
H       11.11683000     5.34314300    15.94081000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005VAL-035PHE-1')] = qcdb.Molecule("""
0 1
C       -9.41500000     6.09300000   -19.77200000
C       -9.98500000     6.09300000   -21.14200000
H       -9.62800000     7.06600000   -19.33400000
H       -9.86500000     5.32400000   -19.14400000
H       -8.33600000     5.96200000   -19.81200000
H       -9.46400000     6.85200000   -21.72300000
H       -9.84234900     5.11093300   -21.61655000
H      -11.04938000     6.36702800   -21.09729000
--
0 1
C      -10.98200000    10.16300000   -15.38500000
C       -8.24900000     8.19800000   -17.15700000
C       -7.10600000     8.73000000   -16.59900000
C       -9.50700000     8.67600000   -16.77200000
C       -9.62500000     9.69800000   -15.84700000
C       -7.21200000     9.76300000   -15.69200000
C       -8.46500000    10.23900000   -15.30400000
H       -8.14600000     7.38100000   -17.84700000
H       -6.13500000     8.34000000   -16.87100000
H      -10.39400000     8.23300000   -17.19800000
H       -6.31700000    10.18800000   -15.26800000
H      -10.88500000    10.54100000   -14.36500000
H      -11.65800000     9.30700000   -15.34600000
H       -8.52800000    11.03500000   -14.57600000
H      -11.43045000    10.95138000   -16.00737000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005VAL-037ILE-1')] = qcdb.Molecule("""
0 1
C       11.00500000     3.05500000    16.59500000
C       11.98500000     4.14600000    17.03100000
H       10.35300000     2.76800000    17.41200000
H       11.56500000     2.18400000    16.27300000
H       10.37900000     3.41300000    15.78000000
H       11.42400000     4.87100000    17.61800000
H       12.79140000     3.71769000    17.64441000
H       12.42042000     4.66032900    16.16159000
--
0 1
C       12.16300000     1.29300000    13.66400000
C       11.59100000     0.68700000    12.37600000
C       13.52300000     0.73900000    14.09700000
H       12.23400000     2.37600000    13.56200000
H       11.46600000     1.08000000    14.46900000
H       11.57300000    -0.39900000    12.47600000
H       13.77500000     1.13800000    15.08000000
H       14.30000000     1.03700000    13.39600000
H       13.48000000    -0.34900000    14.15700000
H       10.55922000     1.05334700    12.27010000
H       12.21928000     0.93372380    11.50745000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '005VAL-039SER-1')] = qcdb.Molecule("""
0 1
C        8.68500000     6.88700000    21.08200000
C        9.68800000     5.82100000    20.64400000
H        8.74100000     7.68800000    20.35900000
H        7.65400000     6.54300000    21.01600000
H        8.91100000     7.26900000    22.07400000
H        9.39400000     5.48700000    19.64800000
H        9.66871200     4.95946500    21.32766000
H       10.69869000     6.25047200    20.58029000
--
0 1
C        9.76900000    10.13500000    21.65000000
C        9.76400000    11.58000000    22.13800000
O        9.14300000    10.03000000    20.38500000
H       10.79100000     9.75800000    21.59000000
H        9.21400000     9.52700000    22.36500000
H        8.72700000    11.91900000    22.13900000
H        9.74700000    10.39600000    19.71600000
H       10.35181000    12.22493000    21.46826000
H       10.11459000    11.60308000    23.18038000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006ALA-078GLU-1')] = qcdb.Molecule("""
0 1
C        2.18900000   -12.17500000    15.82500000
C        2.99200000   -11.58700000    16.98100000
H        1.12100000   -12.07700000    16.01500000
H        2.44000000   -11.66500000    14.89300000
H        2.41900000   -13.23300000    15.71300000
H        4.05200000   -11.77000000    16.79200000
H        2.69353800   -12.06710000    17.92462000
H        2.81323200   -10.50354000    17.04541000
--
0 1
C       -0.48200000    -9.71500000    14.88200000
C       -1.39900000   -10.45100000    13.90300000
C       -1.06000000    -8.40000000    15.42500000
H       -0.31900000   -10.36400000    15.73900000
H        0.48200000    -9.52000000    14.41000000
H       -2.39600000   -10.52000000    14.33700000
H       -0.39400000    -8.02200000    16.20300000
H       -1.06700000    -7.65300000    14.63000000
H       -1.02470400   -11.46695000    13.70870000
H       -1.49681300    -9.89745200    12.95748000
H       -2.07216900    -8.53361500    15.83446000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006ARG-090TYR-1')] = qcdb.Molecule("""
1 1
C       14.52500000     7.77200000     5.24700000
C       14.71900000     5.50500000     6.22300000
N       13.99900000     6.58300000     5.93600000
N       15.99600000     5.45000000     5.89200000
N       14.16400000     4.48400000     6.84500000
H       13.02300000     6.58200000     6.19800000
H       16.40900000     6.19900000     5.36200000
H       16.52100000     4.60100000     6.02900000
H       13.18400000     4.51200000     7.07500000
H       14.71200000     3.68600000     7.14000000
H       14.73400000     7.52100000     4.20400000
H       15.45300000     8.08900000     5.72700000
H       13.82573000     8.62075600     5.27215400
--
0 1
C       17.22800000     5.96400000    10.10200000
C       14.02100000     7.82100000     9.21900000
C       15.28900000     7.24900000     9.12300000
C       13.33500000     7.78900000    10.43400000
C       15.88400000     6.64100000    10.23300000
C       13.91900000     7.19100000    11.55300000
C       15.19000000     6.62100000    11.44700000
O       12.08900000     8.33200000    10.52200000
H       13.57500000     8.29200000     8.36000000
H       15.82600000     7.28800000     8.18500000
H       11.78700000     8.60800000     9.62500000
H       13.37900000     7.16000000    12.48800000
H       17.71900000     5.93000000    11.07500000
H       17.84800000     6.57900000     9.44700000
H       15.63000000     6.14000000    12.31000000
H       17.15464000     4.94704600     9.68917700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006ASP-010THR-1')] = qcdb.Molecule("""
-1 1
C        9.38500000    19.15700000    29.30700000
C       10.32200000    18.79000000    30.49000000
O       10.62300000    17.58800000    30.67700000
O       10.83100000    19.69100000    31.17700000
H        9.84400000    19.87800000    28.64900000
H        8.50500000    19.63600000    29.73500000
H        9.03825600    18.28482000    28.73335000
--
0 1
C        9.74400000    16.24900000    34.39200000
O       10.07200000    17.45100000    33.78200000
H       10.48100000    18.01300000    34.44700000
H        9.05900000    16.43300000    35.22100000
H        9.26860100    15.56976000    33.66907000
H       10.67276000    15.80501000    34.77966000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006ASP-116VAL-1')] = qcdb.Molecule("""
-1 1
C        9.38500000    19.15700000    29.30700000
C        8.89600000    17.92700000    28.49800000
C       10.32200000    18.79000000    30.49000000
O       10.62300000    17.58800000    30.67700000
O       10.83100000    19.69100000    31.17700000
H        9.84400000    19.87800000    28.64900000
H        8.50500000    19.63600000    29.73500000
H        8.49000000    18.33300000    27.57100000
H        8.09249900    17.40334000    29.03667000
H        9.74857200    17.29204000    28.21524000
--
0 1
C        7.94200000    22.65200000    28.87700000
C        7.85300000    23.21800000    30.29100000
H        8.11000000    21.58200000    28.89700000
H        7.00100000    22.84100000    28.35600000
H        8.72800000    23.13900000    28.29900000
H        7.77200000    24.30200000    30.21300000
H        8.76701200    22.96591000    30.84870000
H        6.94232800    22.84095000    30.77937000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006GLU-010TYR-1')] = qcdb.Molecule("""
0 1
C       53.01400000    21.29900000     2.29000000
C       52.60500000    22.72200000     1.91600000
C       52.89100000    21.03500000     3.77800000
H       52.36400000    20.60300000     1.76000000
H       54.04200000    21.12400000     1.96900000
H       51.64900000    22.94400000     2.39400000
H       53.47700000    21.78300000     4.31700000
H       51.84500000    21.15700000     4.07000000
H       52.47547000    22.80381000     0.82672100
H       53.36068000    23.44881000     2.24872800
H       53.23770000    20.03261000     4.06957700
--
0 1
C       47.42400000    24.18900000     3.29900000
C       49.32100000    20.66400000     1.65200000
C       48.76400000    20.63100000     2.92100000
C       49.29300000    21.84600000     0.91800000
C       48.14600000    21.77000000     3.44200000
C       48.68300000    22.99000000     1.44200000
C       48.10900000    22.96700000     2.71700000
O       49.91400000    19.53900000     1.14700000
H       48.78500000    19.71600000     3.49400000
H       49.91100000    18.81300000     1.78000000
H       49.75700000    21.86500000    -0.05500000
H       47.70000000    21.72800000     4.42700000
H       48.66300000    23.90200000     0.86200000
H       46.78300000    23.86100000     4.11700000
H       46.76700000    24.62000000     2.54200000
H       48.10428000    24.96431000     3.68125400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006LEU-108PHE-1')] = qcdb.Molecule("""
0 1
C       22.39500000    -9.14400000    -0.66400000
C       23.28800000    -8.18300000     0.13400000
C       21.38000000    -9.92800000     0.17700000
H       21.86000000    -8.57300000    -1.42100000
H       23.02900000    -9.86400000    -1.18200000
H       22.67200000    -7.36900000     0.51900000
H       21.91200000   -10.58100000     0.87000000
H       24.06124000    -7.74989400    -0.51754890
H       23.74797000    -8.69263800     0.99347450
H       20.74112000    -9.24797100     0.75957290
H       20.76342000   -10.56632000    -0.47290880
--
0 1
C       17.56700000    -7.68300000    -2.78100000
C       21.06500000    -6.24100000    -2.62200000
C       20.95300000    -5.34200000    -1.56900000
C       19.97000000    -7.00300000    -3.01200000
C       18.74900000    -6.86100000    -2.36400000
C       19.73900000    -5.20100000    -0.90600000
C       18.64300000    -5.96500000    -1.30600000
H       22.01200000    -6.35500000    -3.13200000
H       21.81100000    -4.75900000    -1.26900000
H       20.07200000    -7.70000000    -3.83000000
H       19.64000000    -4.50300000    -0.08600000
H       17.08000000    -8.07100000    -1.88900000
H       17.92100000    -8.53800000    -3.35800000
H       17.70500000    -5.85700000    -0.78100000
H       16.82709000    -7.13579500    -3.38357300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006LEU-126VAL-1')] = qcdb.Molecule("""
0 1
C       20.49500000    -8.98600000     0.98400000
C       21.38000000    -9.92800000     0.17700000
H       20.00100000    -8.27700000     0.31900000
H       19.73800000    -9.56600000     1.51000000
H       21.07200000    -8.44300000     1.72800000
H       21.91200000   -10.58100000     0.87000000
H       22.10799000    -9.36569100    -0.42619130
H       20.76342000   -10.56632000    -0.47290880
--
0 1
C       18.86500000    -6.16400000     2.95900000
C       18.24800000    -5.65000000     4.25700000
H       19.62500000    -5.47600000     2.59300000
H       19.33400000    -7.13100000     3.14500000
H       18.10700000    -6.30600000     2.18900000
H       17.51000000    -6.38300000     4.58300000
H       17.72541000    -4.69333600     4.10971200
H       19.01145000    -5.57746100     5.04559100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006LEU-319TYR-1')] = qcdb.Molecule("""
0 1
C        1.88900000     9.33600000   -15.32700000
C        2.32000000     9.41200000   -16.78900000
H        0.94700000     8.79900000   -15.23500000
H        2.64700000     8.79300000   -14.76700000
H        1.78800000    10.33400000   -14.91000000
H        2.41200000     8.39500000   -17.16900000
H        1.59303900     9.96135500   -17.40523000
H        3.30254600     9.90002000   -16.86925000
--
0 1
C        4.28800000     9.37000000   -12.48700000
C        5.68700000     8.77700000   -12.65200000
C        4.07600000     9.95000000   -11.10500000
C        4.23200000     9.15300000    -9.96900000
C        3.73900000    11.29100000   -10.93800000
C        4.05000000     9.68100000    -8.69500000
C        3.55800000    11.82800000    -9.66700000
C        3.71000000    11.02200000    -8.54800000
O        3.52400000    11.55300000    -7.30800000
H        4.12500000    10.13700000   -13.24500000
H        3.55100000     8.57900000   -12.63100000
H        5.79800000     8.04700000   -11.85300000
H        4.47300000     8.10200000   -10.07300000
H        3.59400000    11.91500000   -11.80400000
H        4.17000000     9.04200000    -7.83300000
H        3.29900000    12.86500000    -9.53700000
H        3.61000000    10.90200000    -6.61500000
H        6.45627600     9.55232200   -12.52127000
H        5.80193500     8.20376900   -13.58377000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006LEU-323PHE-1')] = qcdb.Molecule("""
0 1
C        1.88900000     9.33600000   -15.32700000
C        2.32000000     9.41200000   -16.78900000
H        0.94700000     8.79900000   -15.23500000
H        2.64700000     8.79300000   -14.76700000
H        1.78800000    10.33400000   -14.91000000
H        2.41200000     8.39500000   -17.16900000
H        1.59303900     9.96135500   -17.40523000
H        3.30254600     9.90002000   -16.86925000
--
0 1
C        4.06000000     3.89800000   -15.10600000
C        1.54800000     6.21200000   -13.43900000
C        0.94600000     5.35700000   -12.52300000
C        2.55500000     5.73900000   -14.27600000
C        2.97200000     4.41400000   -14.20000000
C        1.35100000     4.03300000   -12.44500000
C        2.35600000     3.56400000   -13.28200000
H        1.23400000     7.24400000   -13.49400000
H        0.16400000     5.69500000   -11.86500000
H        3.01800000     6.40800000   -14.98700000
H        0.88000000     3.36700000   -11.73700000
H        4.50800000     4.72100000   -15.66500000
H        3.59800000     3.22400000   -15.82800000
H        2.64300000     2.52400000   -13.21700000
H        4.85152600     3.34615600   -14.57784000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-018ARG-1')] = qcdb.Molecule("""
0 1
C       -6.12300000     4.06600000   -24.65600000
C       -5.30400000     5.66100000   -26.41700000
C       -6.35500000     4.93000000   -25.86500000
C       -5.51100000     6.48600000   -27.52000000
C       -7.62600000     5.04600000   -26.42000000
C       -6.77700000     6.58200000   -28.09000000
C       -7.83800000     5.85400000   -27.54600000
H       -4.31100000     5.58300000   -25.99700000
H       -4.68700000     7.04600000   -27.93900000
H       -5.10200000     3.68800000   -24.69100000
H       -6.78500000     3.20200000   -24.68700000
H       -8.46400000     4.54200000   -25.97400000
H       -6.93800000     7.21800000   -28.95200000
H       -8.82600000     5.93000000   -27.98100000
H       -6.25893800     4.59177100   -23.69940000
--
1 1
C       -3.57700000     1.73300000   -26.47700000
C       -4.45600000     2.73200000   -28.54700000
N       -3.64200000     2.75900000   -27.51100000
N       -5.24700000     1.69700000   -28.74500000
N       -4.45700000     3.74600000   -29.38100000
H       -2.99200000     3.54600000   -27.45100000
H       -5.20600000     0.90800000   -28.12300000
H       -5.85600000     1.67000000   -29.54700000
H       -3.81600000     4.51600000   -29.20900000
H       -5.07700000     3.76700000   -30.17300000
H       -3.23800000     0.78400000   -26.89900000
H       -4.57300000     1.59300000   -26.04900000
H       -2.90055000     2.03606100   -25.66425000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-039THR-2')] = qcdb.Molecule("""
0 1
C       25.51300000    -3.14100000     3.85200000
C       27.43800000    -2.84900000     2.30800000
C       26.92300000    -3.45600000     3.42600000
C       28.71100000    -3.13000000     1.85300000
C       29.52100000    -3.97900000     2.57100000
C       27.74700000    -4.29800000     4.17400000
C       29.05100000    -4.56700000     3.74000000
H       26.82300000    -2.16200000     1.74300000
H       29.08300000    -2.66300000     0.95200000
H       25.01200000    -4.07100000     4.12400000
H       24.96800000    -2.71300000     3.00900000
H       30.52300000    -4.19100000     2.22400000
H       27.37200000    -4.77900000     5.06600000
H       29.68200000    -5.23900000     4.30200000
H       25.46590000    -2.44251600     4.70047000
--
0 1
C       28.95200000     0.65400000     1.76400000
C       29.14300000     0.47900000     3.29000000
H       29.20100000     1.67300000     1.46600000
H       29.60500000    -0.04100000     1.23600000
H       27.92400000     0.43000000     1.48100000
H       28.77500000    -0.50800000     3.58000000
H       28.61418000     1.25029000     3.86918700
H       30.21738000     0.53770070     3.51862400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-050VAL-1')] = qcdb.Molecule("""
0 1
C       25.51300000    -3.14100000     3.85200000
C       27.43800000    -2.84900000     2.30800000
C       26.92300000    -3.45600000     3.42600000
C       28.71100000    -3.13000000     1.85300000
C       29.52100000    -3.97900000     2.57100000
C       27.74700000    -4.29800000     4.17400000
C       29.05100000    -4.56700000     3.74000000
H       26.82300000    -2.16200000     1.74300000
H       29.08300000    -2.66300000     0.95200000
H       25.01200000    -4.07100000     4.12400000
H       24.96800000    -2.71300000     3.00900000
H       30.52300000    -4.19100000     2.22400000
H       27.37200000    -4.77900000     5.06600000
H       29.68200000    -5.23900000     4.30200000
H       25.46590000    -2.44251600     4.70047000
--
0 1
C       26.88100000    -3.13200000    -1.15600000
C       26.37600000    -3.81600000    -2.46100000
H       27.95200000    -2.94100000    -1.23600000
H       26.36900000    -2.18000000    -1.02800000
H       26.68700000    -3.76600000    -0.29400000
H       26.44300000    -3.11300000    -3.29000000
H       26.96673000    -4.71746000    -2.68100800
H       25.31889000    -4.09284400    -2.33496300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-053LEU-1')] = qcdb.Molecule("""
0 1
C       25.51300000    -3.14100000     3.85200000
C       29.52100000    -3.97900000     2.57100000
C       28.71100000    -3.13000000     1.85300000
C       29.05100000    -4.56700000     3.74000000
C       27.43800000    -2.84900000     2.30800000
C       27.74700000    -4.29800000     4.17400000
C       26.92300000    -3.45600000     3.42600000
H       30.52300000    -4.19100000     2.22400000
H       29.08300000    -2.66300000     0.95200000
H       29.68200000    -5.23900000     4.30200000
H       26.82300000    -2.16200000     1.74300000
H       27.37200000    -4.77900000     5.06600000
H       25.01200000    -4.07100000     4.12400000
H       24.96800000    -2.71300000     3.00900000
H       25.46590000    -2.44251600     4.70047000
--
0 1
C       30.07700000    -6.87500000     0.48000000
C       29.99500000    -8.21700000    -0.19900000
H       29.66500000    -6.93600000     1.48800000
H       31.11800000    -6.55800000     0.54100000
H       29.52200000    -6.13000000    -0.09000000
H       30.43100000    -8.12000000    -1.19200000
H       28.93585000    -8.49939200    -0.29097490
H       30.57258000    -8.97024400     0.35689680
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-061PHE-1')] = qcdb.Molecule("""
0 1
C       25.51300000    -3.14100000     3.85200000
C       25.44800000    -2.17700000     5.02300000
C       26.92300000    -3.45600000     3.42600000
C       27.43800000    -2.84900000     2.30800000
C       27.74700000    -4.29800000     4.17400000
C       28.71100000    -3.13000000     1.85300000
C       29.05100000    -4.56700000     3.74000000
C       29.52100000    -3.97900000     2.57100000
H       25.01200000    -4.07100000     4.12400000
H       24.96800000    -2.71300000     3.00900000
H       26.04100000    -1.31500000     4.74100000
H       26.82300000    -2.16200000     1.74300000
H       27.37200000    -4.77900000     5.06600000
H       29.08300000    -2.66300000     0.95200000
H       29.68200000    -5.23900000     4.30200000
H       30.52300000    -4.19100000     2.22400000
H       25.87465000    -2.63012300     5.93000200
H       24.41950000    -1.84919000     5.23451400
--
0 1
C       23.23400000    -7.53700000     4.77600000
C       23.65300000    -6.21600000     2.63400000
C       24.17000000    -6.99000000     3.68600000
C       24.48400000    -5.72300000     1.58400000
C       25.55100000    -7.28300000     3.68100000
C       25.82500000    -6.01900000     1.59700000
C       26.37100000    -6.78000000     2.66100000
H       22.60400000    -5.97700000     2.62400000
H       24.06100000    -5.12400000     0.79000000
H       23.60500000    -8.52200000     5.05100000
H       22.24400000    -7.68000000     4.34200000
H       25.98800000    -7.87000000     4.47600000
H       26.47400000    -5.66200000     0.81200000
H       27.43200000    -6.98900000     2.67600000
H       23.12834000    -6.91800400     5.67914900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006PHE-163LEU-1')] = qcdb.Molecule("""
0 1
C        6.21500000     4.04600000    24.78000000
C        7.96500000     4.91000000    26.38300000
C        6.64300000     4.91100000    25.94100000
C        8.35300000     5.69800000    27.46800000
C        5.71100000     5.70700000    26.60400000
C        7.41500000     6.49700000    28.11600000
C        6.09300000     6.50000000    27.68000000
H        8.72000000     4.37200000    25.84400000
H        9.38100000     5.69000000    27.80400000
H        5.17800000     3.75000000    24.93300000
H        6.80900000     3.13200000    24.76600000
H        4.67700000     5.70900000    26.28700000
H        7.71100000     7.11000000    28.95700000
H        5.35800000     7.11000000    28.18900000
H        6.28969000     4.53651200    23.79826000
--
0 1
C        8.93800000     1.54300000    27.61100000
C        9.16200000     1.45500000    26.09600000
H        7.90200000     1.81300000    27.80900000
H        9.16100000     0.58400000    28.07800000
H        9.58000000     2.31400000    28.03500000
H        8.96100000     2.40800000    25.63600000
H       10.19355000     1.16914100    25.84263000
H        8.47062700     0.73620340    25.63196000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006THR-097VAL-1')] = qcdb.Molecule("""
0 1
C      -18.15300000   -10.05800000   -18.53700000
C      -18.37200000   -10.08600000   -20.07000000
C      -19.37100000    -9.56500000   -17.75400000
O      -17.71500000   -11.35400000   -18.08400000
H      -17.34500000    -9.35900000   -18.34500000
H      -18.39300000    -9.05900000   -20.43800000
H      -20.18400000   -10.29100000   -17.79700000
H      -19.08100000    -9.41200000   -16.71600000
H      -19.71300000    -8.61500000   -18.16600000
H      -18.41400000   -11.74200000   -17.54000000
H      -19.30357000   -10.62079000   -20.30702000
H      -17.52360000   -10.62387000   -20.51823000
--
0 1
C      -15.46400000    -9.09900000   -16.01600000
C      -14.65400000    -7.99400000   -15.24000000
H      -15.91100000    -8.65800000   -16.90400000
H      -14.78100000    -9.89400000   -16.32100000
H      -16.23300000    -9.54300000   -15.38500000
H      -14.28600000    -8.44900000   -14.32000000
H      -15.30968000    -7.15251600   -14.97170000
H      -13.77223000    -7.64665900   -15.79843000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006TRP-026TYR-1')] = qcdb.Molecule("""
0 1
C       41.90800000    35.76100000    31.75300000
C       43.40100000    33.82700000    30.71200000
C       43.03100000    34.74200000    31.76600000
C       44.55700000    33.12000000    31.14600000
C       43.94100000    34.55100000    32.76300000
C       43.50500000    32.56100000    28.65800000
C       44.64800000    31.88400000    29.11400000
C       42.87700000    33.53300000    29.44500000
C       45.18600000    32.15400000    30.36300000
N       44.85400000    33.58800000    32.39800000
H       43.06300000    32.29100000    27.71100000
H       45.10700000    31.13500000    28.48100000
H       41.97700000    34.02000000    29.11300000
H       46.06500000    31.63800000    30.72100000
H       42.07500000    36.44500000    30.92000000
H       41.98100000    36.34500000    32.67200000
H       43.95500000    35.10200000    33.69900000
H       45.63300000    33.29200000    32.97800000
H       40.88733000    35.35831000    31.67504000
--
0 1
C       43.74700000    32.38700000    25.13100000
C       44.66000000    32.59900000    23.91500000
C       42.63400000    31.37200000    24.94100000
C       42.85400000    30.00700000    25.17900000
C       41.35900000    31.78800000    24.54100000
C       41.82100000    29.07500000    25.01700000
C       40.32100000    30.86600000    24.38300000
C       40.55100000    29.50900000    24.61700000
O       39.53800000    28.61200000    24.43800000
H       44.37600000    32.03200000    25.94600000
H       43.32500000    33.34300000    25.44400000
H       45.56500000    33.10800000    24.24400000
H       43.82900000    29.66900000    25.50800000
H       41.17600000    32.83500000    24.33500000
H       42.00000000    28.02600000    25.20300000
H       39.34000000    31.18800000    24.06300000
H       39.84900000    27.70400000    24.52400000
H       44.16913000    33.21183000    23.14461000
H       44.95874000    31.62791000    23.49342000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006TRP-038VAL-1')] = qcdb.Molecule("""
0 1
C       41.90800000    35.76100000    31.75300000
C       44.55700000    33.12000000    31.14600000
C       43.40100000    33.82700000    30.71200000
C       43.03100000    34.74200000    31.76600000
C       43.94100000    34.55100000    32.76300000
C       44.64800000    31.88400000    29.11400000
C       45.18600000    32.15400000    30.36300000
C       43.50500000    32.56100000    28.65800000
C       42.87700000    33.53300000    29.44500000
N       44.85400000    33.58800000    32.39800000
H       45.10700000    31.13500000    28.48100000
H       46.06500000    31.63800000    30.72100000
H       43.06300000    32.29100000    27.71100000
H       41.97700000    34.02000000    29.11300000
H       45.63300000    33.29200000    32.97800000
H       43.95500000    35.10200000    33.69900000
H       42.07500000    36.44500000    30.92000000
H       41.98100000    36.34500000    32.67200000
H       40.88733000    35.35831000    31.67504000
--
0 1
C       43.06400000    28.64400000    28.88900000
C       42.43800000    27.35200000    29.41100000
H       42.97300000    29.44100000    29.63000000
H       44.12200000    28.48300000    28.69500000
H       42.60300000    28.95500000    27.95100000
H       42.38300000    26.63200000    28.59600000
H       41.42130000    27.53893000    29.78700000
H       43.06676000    26.92490000    30.20614000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006TRP-040LYS-1')] = qcdb.Molecule("""
0 1
C       41.90800000    35.76100000    31.75300000
C       43.40100000    33.82700000    30.71200000
C       43.03100000    34.74200000    31.76600000
C       44.55700000    33.12000000    31.14600000
C       43.94100000    34.55100000    32.76300000
C       42.87700000    33.53300000    29.44500000
C       43.50500000    32.56100000    28.65800000
C       44.64800000    31.88400000    29.11400000
C       45.18600000    32.15400000    30.36300000
N       44.85400000    33.58800000    32.39800000
H       41.97700000    34.02000000    29.11300000
H       43.06300000    32.29100000    27.71100000
H       45.10700000    31.13500000    28.48100000
H       42.07500000    36.44500000    30.92000000
H       41.98100000    36.34500000    32.67200000
H       43.95500000    35.10200000    33.69900000
H       45.63300000    33.29200000    32.97800000
H       46.06500000    31.63800000    30.72100000
H       40.88733000    35.35831000    31.67504000
--
0 1
C       40.75700000    34.96500000    26.86700000
C       39.32700000    34.78500000    26.40900000
C       41.50700000    35.90000000    25.93900000
H       40.73500000    35.40600000    27.86500000
H       41.25900000    33.99800000    26.90300000
H       39.30700000    34.29700000    25.43100000
H       38.88800000    35.77900000    26.29300000
H       41.75400000    35.36800000    25.01800000
H       40.88500000    36.76800000    25.70900000
H       38.71716000    34.21759000    27.12743000
H       42.42040000    36.25537000    26.43840000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-020VAL-1')] = qcdb.Molecule("""
0 1
C       -4.74900000    -4.92600000     3.65400000
C       -3.62800000    -5.65900000     4.38600000
H       -5.68700000    -5.47700000     3.74600000
H       -4.87700000    -3.93600000     4.08800000
H       -4.50400000    -4.79600000     2.60300000
H       -2.69600000    -5.11800000     4.22600000
H       -3.51322400    -6.68266000     4.00006500
H       -3.82890500    -5.68718500     5.46713000
--
0 1
C       -6.95700000    -3.21800000     6.16400000
C       -5.93300000    -2.40500000     6.95300000
H       -6.85900000    -3.05600000     5.09200000
H       -6.80300000    -4.27900000     6.36500000
H       -7.96500000    -2.95600000     6.48500000
H       -4.93700000    -2.77400000     6.72000000
H       -5.97086800    -1.34325900     6.66791600
H       -6.08613500    -2.52434500     8.03573100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-023MET-1')] = qcdb.Molecule("""
0 1
C       20.14200000    15.45200000    15.88200000
C       20.80600000    15.99100000    17.17800000
H       19.48200000    16.22400000    15.49100000
H       20.90500000    15.20600000    15.14200000
H       19.56400000    14.55100000    16.09300000
H       21.34200000    15.17400000    17.66100000
H       20.03041000    16.38021000    17.85400000
H       21.53661000    16.77205000    16.92077000
--
0 1
C       18.49800000    15.83000000    12.57800000
C       17.02900000    15.51400000    12.79500000
C       19.32800000    14.61600000    12.22400000
H       18.59100000    16.55100000    11.76300000
H       18.90200000    16.29700000    13.46800000
H       16.96600000    14.81400000    13.63200000
H       19.21000000    13.88100000    13.02100000
H       18.96500000    14.17000000    11.29700000
H       16.60717000    15.06941000    11.88154000
H       16.50458000    16.43953000    13.07498000
H       20.40302000    14.82146000    12.11393000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-024ASP-1')] = qcdb.Molecule("""
0 1
C       -3.90600000    -5.69800000     5.88200000
C       -3.62800000    -5.65900000     4.38600000
H       -3.06800000    -6.14500000     6.41400000
H       -4.04200000    -4.68900000     6.25600000
H       -4.81000000    -6.27400000     6.06700000
H       -2.69600000    -5.11800000     4.22600000
H       -3.51322400    -6.68266000     4.00006500
H       -4.43587300    -5.13074700     3.85846800
--
-1 1
C       -1.11100000    -3.19000000     6.54000000
C        0.12400000    -3.87300000     5.95000000
C       -1.09900000    -1.67500000     6.39000000
O       -0.08000000    -1.09500000     5.95200000
O       -2.12600000    -1.05900000     6.74900000
H       -2.01100000    -3.60600000     6.09400000
H       -1.14600000    -3.40800000     7.60900000
H        1.01500000    -3.31800000     6.24900000
H        0.07569629    -3.91451100     4.85184500
H        0.19400640    -4.88268100     6.38086400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-026LEU-1')] = qcdb.Molecule("""
0 1
C       -3.90600000    -5.69800000     5.88200000
C       -3.62800000    -5.65900000     4.38600000
H       -3.06800000    -6.14500000     6.41400000
H       -4.04200000    -4.68900000     6.25600000
H       -4.81000000    -6.27400000     6.06700000
H       -2.69600000    -5.11800000     4.22600000
H       -3.51322400    -6.68266000     4.00006500
H       -4.43587300    -5.13074700     3.85846800
--
0 1
C       -4.91000000    -6.50600000     9.19200000
C       -3.41500000    -6.35800000     9.48100000
H       -5.48000000    -6.05700000     9.99500000
H       -5.16800000    -5.98500000     8.27400000
H       -5.17500000    -7.55900000     9.09100000
H       -2.87300000    -6.77800000     8.63600000
H       -3.13560700    -6.89595600    10.39890000
H       -3.15807000    -5.29326400     9.58261100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-038ILE-1')] = qcdb.Molecule("""
0 1
C       21.82000000    17.07500000    16.82100000
C       20.80600000    15.99100000    17.17800000
H       22.44500000    17.30100000    17.68300000
H       22.46100000    16.75100000    16.00300000
H       21.28100000    17.97200000    16.54000000
H       21.34200000    15.17400000    17.66100000
H       20.03041000    16.38021000    17.85400000
H       20.33561000    15.60916000    16.25989000
--
0 1
C       20.86200000    18.94000000    13.91200000
C       21.60800000    19.51100000    12.69300000
C       19.53600000    19.63400000    14.26500000
H       20.70000000    17.86900000    13.78700000
H       21.51200000    19.08300000    14.77000000
H       21.58400000    20.60100000    12.74000000
H       18.79200000    19.45500000    13.49000000
H       19.16000000    19.23200000    15.20700000
H       19.69500000    20.70700000    14.37800000
H       22.65356000    19.16972000    12.71122000
H       21.08287000    19.18333000    11.78368000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-053LEU-1')] = qcdb.Molecule("""
0 1
C       -3.90600000    -5.69800000     5.88200000
C       -3.62800000    -5.65900000     4.38600000
H       -3.06800000    -6.14500000     6.41400000
H       -4.04200000    -4.68900000     6.25600000
H       -4.81000000    -6.27400000     6.06700000
H       -2.69600000    -5.11800000     4.22600000
H       -3.51322400    -6.68266000     4.00006500
H       -4.43587300    -5.13074700     3.85846800
--
0 1
C       -6.60000000    -8.44900000     6.14900000
C       -7.59400000    -9.61100000     6.19200000
H       -6.37400000    -8.17400000     5.12300000
H       -7.03500000    -7.58100000     6.64300000
H       -5.68000000    -8.72400000     6.66600000
H       -8.44500000    -9.34300000     5.56700000
H       -7.13325500   -10.53105000     5.80313400
H       -7.98868100    -9.76728800     7.20679100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-055GLU-1')] = qcdb.Molecule("""
0 1
C        3.74700000    31.26800000    12.84300000
C        4.85100000    31.83900000    11.99800000
H        3.85700000    30.18900000    12.94000000
H        3.77600000    31.71900000    13.83500000
H        2.78500000    31.49200000    12.38300000
H        4.71400000    32.92000000    11.96100000
H        4.79280200    31.44034000    10.97444000
H        5.82702700    31.62913000    12.45987000
--
-1 1
C        1.90800000    29.03100000    15.06400000
C        2.85200000    28.82500000    16.23000000
C        1.27300000    30.42400000    15.05800000
O        1.29500000    31.11700000    16.09900000
O        0.75200000    30.82100000    13.98900000
H        2.43800000    28.87500000    14.12600000
H        1.10200000    28.29700000    15.12100000
H        2.28800000    28.89700000    17.16200000
H        3.59400000    29.62600000    16.22200000
H        3.38946300    27.86524000    16.23145000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '006VAL-175PHE-1')] = qcdb.Molecule("""
0 1
C      -16.03000000    21.12500000    -8.36300000
C      -16.38900000    22.21500000    -7.34100000
C      -14.77800000    21.51200000    -9.14700000
C      -15.81900000    19.78000000    -7.67300000
H      -16.85400000    21.01700000    -9.06700000
H      -15.60700000    22.24900000    -6.58300000
H      -13.96400000    21.75600000    -8.46300000
H      -14.47200000    20.68500000    -9.78800000
H      -14.98000000    22.36700000    -9.78900000
H      -16.73300000    19.47400000    -7.16200000
H      -15.57600000    19.01900000    -8.41500000
H      -15.00800000    19.85100000    -6.94700000
H      -17.35960000    22.00955000    -6.86589600
H      -16.47141000    23.19305000    -7.83761500
--
0 1
C      -20.85500000    20.74000000   -11.00400000
C      -17.17700000    20.74300000   -12.01100000
C      -16.75600000    19.49400000   -11.54900000
C      -18.50400000    21.14400000   -11.83400000
C      -19.41800000    20.30900000   -11.18500000
C      -17.66400000    18.65300000   -10.90600000
C      -18.99100000    19.05900000   -10.73200000
H      -16.47800000    21.40100000   -12.51100000
H      -15.73200000    19.17800000   -11.68500000
H      -18.82300000    22.10800000   -12.20500000
H      -17.34300000    17.68400000   -10.54700000
H      -21.49200000    19.85500000   -10.96800000
H      -21.15800000    21.31400000   -11.88200000
H      -19.68800000    18.39800000   -10.23400000
H      -21.03997000    21.35154000   -10.10856000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ALA-011ILE-1')] = qcdb.Molecule("""
0 1
C       17.41500000     9.87500000    15.98200000
C       17.47500000     8.35600000    15.81900000
H       16.37800000    10.16900000    16.14300000
H       17.76900000    10.36600000    15.08100000
H       18.01700000    10.18500000    16.83500000
H       16.86300000     8.08400000    14.95600000
H       17.05810000     7.86861100    16.71267000
H       18.51418000     8.03901100    15.64688000
--
0 1
C       15.13500000    10.69600000    13.00600000
C       16.04300000    11.71300000    12.35300000
H       15.68700000     9.77100000    13.17100000
H       14.28900000    10.48300000    12.36100000
H       14.77800000    11.06800000    13.96600000
H       16.35600000    11.35300000    11.37200000
H       16.91400000    11.75900000    12.99400000
H       15.59887000    12.71498000    12.25931000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ALA-021PHE-1')] = qcdb.Molecule("""
0 1
C       29.32100000    28.98800000    26.69900000
C       28.90800000    28.74300000    25.25600000
H       28.49800000    29.44600000    27.25100000
H       29.59200000    28.04600000    27.17900000
H       30.18500000    29.65100000    26.74300000
H       29.75900000    28.33000000    24.72100000
H       28.62468000    29.68614000    24.76587000
H       28.08537000    28.01337000    25.22572000
--
0 1
C       27.78000000    29.90600000    32.24200000
C       30.41900000    30.77200000    29.65000000
C       31.31700000    29.74100000    29.79000000
C       29.26400000    30.81300000    30.41000000
C       28.99600000    29.82500000    31.35000000
C       31.09300000    28.76600000    30.75200000
C       29.93700000    28.80400000    31.52300000
H       30.61300000    31.53700000    28.91600000
H       32.21300000    29.71600000    29.18400000
H       28.58500000    31.64500000    30.29400000
H       31.82500000    28.00300000    30.90900000
H       27.42600000    28.89400000    32.43700000
H       26.98100000    30.44700000    31.73100000
H       29.77500000    28.04000000    32.27200000
H       27.99937000    30.38691000    33.20668000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ALA-049VAL-1')] = qcdb.Molecule("""
0 1
C       17.41500000     9.87500000    15.98200000
C       17.47500000     8.35600000    15.81900000
H       16.37800000    10.16900000    16.14300000
H       17.76900000    10.36600000    15.08100000
H       18.01700000    10.18500000    16.83500000
H       16.86300000     8.08400000    14.95600000
H       17.05810000     7.86861100    16.71267000
H       18.51418000     8.03901100    15.64688000
--
0 1
C       14.77200000    12.34200000    17.16900000
C       14.51700000    13.47000000    16.18500000
H       15.83100000    12.08900000    17.18600000
H       14.21200000    11.45700000    16.86300000
H       14.44600000    12.63600000    18.16700000
H       14.83900000    13.12400000    15.21300000
H       15.11086000    14.34689000    16.48229000
H       13.44799000    13.72183000    16.12330000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ARG-011GLU-2')] = qcdb.Molecule("""
1 1
C       32.59000000   -10.26800000    58.76100000
C       31.01900000   -11.54600000    60.23100000
N       29.86200000   -11.49700000    60.84900000
N       31.29100000   -10.55900000    59.39400000
N       31.82000000   -12.58200000    60.45800000
H       29.30600000   -10.65300000    60.75300000
H       29.60200000   -12.19700000    61.53200000
H       30.57700000    -9.82700000    59.36500000
H       32.67200000   -12.69900000    59.93600000
H       31.49700000   -13.30000000    61.09500000
H       32.42700000    -9.97000000    57.72400000
H       33.27200000   -11.11900000    58.79900000
H       32.99285000    -9.42516400    59.34181000
--
-1 1
C       28.96100000    -8.00100000    57.60500000
C       28.58100000    -7.95300000    59.06600000
O       29.19200000    -8.71800000    59.83300000
O       27.60300000    -7.24500000    59.37600000
H       28.41800000    -8.82500000    57.13600000
H       30.02700000    -8.20000000    57.49900000
H       28.70165000    -7.06549500    57.08773000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ARG-062TYR-1')] = qcdb.Molecule("""
0 1
C       33.16500000    -9.06500000    59.59000000
C       34.50300000    -8.62100000    59.13700000
C       32.59000000   -10.26800000    58.76100000
H       33.28200000    -9.39400000    60.61700000
H       32.45500000    -8.24000000    59.60000000
H       35.19000000    -9.47000000    59.12600000
H       34.87500000    -7.90200000    59.87000000
H       32.42700000    -9.97000000    57.72400000
H       33.27200000   -11.11900000    58.79900000
H       34.48639000    -8.14448700    58.14571000
H       31.62062000   -10.48516000    59.23338000
--
0 1
C       33.60100000    -6.03400000    64.70400000
C       31.00700000    -7.03200000    62.06500000
C       29.89000000    -7.24500000    62.87100000
C       32.21000000    -6.64100000    62.66700000
C       32.30100000    -6.44800000    64.04600000
C       29.96900000    -7.06700000    64.25200000
C       31.16900000    -6.66700000    64.82400000
O       28.68300000    -7.59300000    62.37700000
H       30.92600000    -7.15300000    60.99700000
H       33.08200000    -6.47600000    62.04800000
H       29.11200000    -7.25100000    64.87000000
H       28.02700000    -7.66100000    63.07000000
H       33.35700000    -5.24800000    65.41600000
H       34.26600000    -5.59600000    63.95800000
H       31.22000000    -6.52400000    65.89400000
H       34.11890000    -6.84640500    65.23483000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ARG-063PRO-1')] = qcdb.Molecule("""
1 1
C       32.59000000   -10.26800000    58.76100000
C       31.01900000   -11.54600000    60.23100000
N       31.29100000   -10.55900000    59.39400000
N       29.86200000   -11.49700000    60.84900000
N       31.82000000   -12.58200000    60.45800000
H       30.57700000    -9.82700000    59.36500000
H       29.30600000   -10.65300000    60.75300000
H       29.60200000   -12.19700000    61.53200000
H       32.67200000   -12.69900000    59.93600000
H       31.49700000   -13.30000000    61.09500000
H       32.42700000    -9.97000000    57.72400000
H       33.27200000   -11.11900000    58.79900000
H       32.99285000    -9.42516400    59.34181000
--
0 1
C       32.63800000   -10.59200000    63.25400000
C       33.95700000   -11.27700000    62.93700000
C       33.00500000    -9.73500000    64.48100000
H       31.85000000   -11.31600000    63.46200000
H       32.32200000    -9.94200000    62.44200000
H       34.16200000   -12.06000000    63.66900000
H       33.97800000   -11.68300000    61.92700000
H       32.29400000    -8.92300000    64.56600000
H       34.67729000   -10.45350000    63.05111000
H       34.00797000    -9.37884000    64.20315000
H       32.95877000   -10.32679000    65.40709000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ASN-109GLU-1')] = qcdb.Molecule("""
0 1
C       17.32800000    21.78800000    14.48300000
C       18.03800000    21.23800000    13.26300000
O       18.09800000    21.88700000    12.22600000
N       18.57100000    20.03200000    13.36400000
H       19.02400000    19.65600000    12.55000000
H       18.58900000    19.51500000    14.23600000
H       17.51800000    21.12800000    15.32900000
H       16.25600000    21.77700000    14.29000000
H       17.65571000    22.80611000    14.74003000
--
-1 1
C       17.61800000    16.27100000    14.64500000
C       18.35800000    17.17300000    15.63800000
O       19.33500000    17.84900000    15.23700000
O       17.94200000    17.21900000    16.81900000
H       16.68600000    16.77000000    14.37200000
H       17.33500000    15.32700000    15.11200000
H       18.17807000    16.09553000    13.71466000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ASP-011GLN-1')] = qcdb.Molecule("""
-1 1
C       12.13900000    67.84200000     8.69800000
C       10.94700000    66.96000000     9.05400000
O       10.21600000    66.47200000     8.16700000
O       10.71800000    66.71100000    10.26000000
H       12.02300000    68.80900000     9.19100000
H       12.16600000    68.01600000     7.62000000
H       13.08565000    67.38530000     9.02246200
--
0 1
C       11.07800000    62.74900000    10.25400000
C        9.60100000    62.70800000     9.92400000
O        9.10400000    63.53100000     9.15100000
N        8.87700000    61.77900000    10.53500000
H       11.16900000    62.62400000    11.33400000
H       11.46000000    63.73700000    10.01700000
H        7.88500000    61.73700000    10.34800000
H        9.30900000    61.13200000    11.18000000
H       11.67255000    61.97962000     9.73963700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ASP-119SER-1')] = qcdb.Molecule("""
-1 1
C       12.98100000    17.69200000    25.94800000
C       12.27400000    16.89500000    27.03500000
C       12.12100000    17.80500000    24.71700000
O       11.25200000    16.92500000    24.47100000
O       12.41100000    18.73500000    23.94100000
H       13.24200000    18.68100000    26.32900000
H       13.90100000    17.18800000    25.64900000
H       11.89300000    15.97400000    26.59000000
H       11.43588000    17.46841000    27.45779000
H       13.01685000    16.56887000    27.77785000
--
0 1
C       16.08700000    18.90100000    24.29800000
C       15.70500000    20.38000000    24.13800000
O       17.49700000    18.78400000    23.98900000
H       15.91000000    18.59300000    25.32900000
H       15.49100000    18.28800000    23.62600000
H       16.32500000    20.92900000    24.84400000
H       17.83900000    17.98200000    24.41500000
H       14.65150000    20.57978000    24.38342000
H       15.98601000    20.70168000    23.12432000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ASP-131ARG-1')] = qcdb.Molecule("""
-1 1
C       12.98100000    17.69200000    25.94800000
C       12.12100000    17.80500000    24.71700000
O       11.25200000    16.92500000    24.47100000
O       12.41100000    18.73500000    23.94100000
H       13.24200000    18.68100000    26.32900000
H       13.90100000    17.18800000    25.64900000
H       12.47004000    17.11600000    26.73359000
--
1 1
C        8.84500000    16.95200000    21.53800000
C        8.10200000    16.85600000    23.92000000
N        9.03900000    16.90300000    22.99400000
N        6.79900000    16.88700000    23.62700000
N        8.51500000    16.76100000    25.16000000
H        9.99800000    16.88400000    23.33800000
H        6.48900000    16.90400000    22.66400000
H        6.11800000    16.85600000    24.36900000
H        9.52200000    16.70500000    25.29100000
H        7.85400000    16.65500000    25.92100000
H        7.80500000    17.12000000    21.26100000
H        9.14600000    15.98800000    21.12300000
H        9.49229100    17.73061000    21.10815000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007GLU-033LYS-1')] = qcdb.Molecule("""
-1 1
C       19.59100000    14.01300000    29.59200000
C       19.92600000    13.24300000    30.90400000
O       20.18700000    12.01800000    30.90000000
O       19.79400000    13.86700000    31.98900000
H       19.97400000    15.03300000    29.67100000
H       18.50300000    14.08300000    29.51800000
H       19.96021000    13.58384000    28.64887000
--
0 1
C       16.35100000    12.22300000    30.85700000
C       15.04800000    12.18400000    31.60700000
C       16.90000000    10.84700000    30.62300000
H       16.20500000    12.70400000    29.88900000
H       17.07000000    12.81200000    31.42700000
H       15.23300000    11.74800000    32.58600000
H       14.34700000    11.52800000    31.08500000
H       16.18300000    10.33700000    29.97700000
H       17.86500000    10.90700000    30.11900000
H       14.57062000    13.15742000    31.79293000
H       16.97719000    10.25422000    31.54639000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007GLU-033LYS-2')] = qcdb.Molecule("""
-1 1
C       19.59100000    14.01300000    29.59200000
C       19.92600000    13.24300000    30.90400000
O       20.18700000    12.01800000    30.90000000
O       19.79400000    13.86700000    31.98900000
H       19.97400000    15.03300000    29.67100000
H       18.50300000    14.08300000    29.51800000
H       19.96021000    13.58384000    28.64887000
--
1 1
C       17.00600000    10.03300000    31.89100000
N       18.18300000    10.39500000    32.71900000
H       18.08400000    11.31700000    33.12800000
H       18.31500000     9.73800000    33.48000000
H       19.03900000    10.41000000    32.17100000
H       16.08300000    10.06700000    32.47600000
H       17.12100000     8.98600000    31.58700000
H       16.92881000    10.62578000    30.96761000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-015LYS-1')] = qcdb.Molecule("""
0 1
C       13.65100000     0.17200000    -3.10700000
C       14.56600000     1.26100000    -3.61100000
H       12.95500000    -0.14800000    -3.87900000
H       14.24300000    -0.69200000    -2.82200000
H       13.10300000     0.50900000    -2.23200000
H       15.13300000     0.86800000    -4.45600000
H       15.27200000     1.47600000    -2.80900000
H       14.06086000     2.18650300    -3.92448800
--
0 1
C       16.61400000    -1.93600000    -1.88200000
C       15.90000000    -2.03400000    -0.54900000
C       17.73700000    -2.98000000    -1.98700000
H       15.89300000    -2.16200000    -2.66800000
H       16.97800000    -0.92500000    -2.04000000
H       15.75600000    -3.08400000    -0.28500000
H       14.90800000    -1.59000000    -0.64900000
H       18.56700000    -2.95500000    -1.31100000
H       17.27000000    -3.95800000    -1.83400000
H       16.43021000    -1.51745500     0.26466680
H       18.18055000    -2.99238100    -2.99353600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-030LEU-1')] = qcdb.Molecule("""
0 1
C       35.13900000    19.14400000    -5.85700000
C       35.04900000    17.61700000    -5.79700000
H       36.17100000    19.44200000    -5.76700000
H       34.74400000    19.51600000    -6.80000000
H       34.54400000    19.62100000    -5.07900000
H       34.00100000    17.33700000    -5.88300000
H       35.45189000    17.25190000    -4.84076400
H       35.60624000    17.16160000    -6.62891900
--
0 1
C       36.86200000    22.21000000    -7.13500000
C       37.92000000    21.50300000    -7.97700000
H       36.14500000    22.71900000    -7.78100000
H       36.32800000    21.49800000    -6.51600000
H       37.33700000    22.94400000    -6.48300000
H       38.63200000    21.03900000    -7.30600000
H       38.43828000    22.24843000    -8.59807000
H       37.45780000    20.73074000    -8.60944300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-030LEU-2')] = qcdb.Molecule("""
0 1
C       35.23500000    17.26900000    -8.32800000
C       35.82600000    16.98200000    -6.95700000
H       35.20800000    18.33200000    -8.55200000
H       35.84000000    16.77200000    -9.08700000
H       34.22100000    16.87200000    -8.37800000
H       36.85100000    17.35700000    -6.94100000
H       35.88500000    15.90800000    -6.83600000
H       35.26876000    17.43740000    -6.12508100
--
0 1
C       37.28200000    20.43700000    -8.85000000
C       37.92000000    21.50300000    -7.97700000
H       38.00300000    20.04500000    -9.56600000
H       36.97200000    19.61900000    -8.20600000
H       36.41300000    20.83400000    -9.36800000
H       38.63200000    21.03900000    -7.30600000
H       38.43828000    22.24843000    -8.59807000
H       37.15727000    22.01269000    -7.36998900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-038TYR-1')] = qcdb.Molecule("""
0 1
C       35.13900000    19.14400000    -5.85700000
C       35.04900000    17.61700000    -5.79700000
H       36.17100000    19.44200000    -5.76700000
H       34.74400000    19.51600000    -6.80000000
H       34.54400000    19.62100000    -5.07900000
H       34.00100000    17.33700000    -5.88300000
H       35.45189000    17.25190000    -4.84076400
H       35.60624000    17.16160000    -6.62891900
--
0 1
C       32.69800000    23.87200000    -5.89300000
C       31.60800000    20.32300000    -6.76900000
C       32.13100000    20.17700000    -8.05200000
C       31.80200000    21.52000000    -6.07400000
C       32.51700000    22.57800000    -6.64800000
C       32.84500000    21.22400000    -8.64000000
C       33.03600000    22.41800000    -7.93400000
O       31.94400000    19.00400000    -8.72300000
H       31.06000000    19.50800000    -6.31900000
H       31.39400000    21.62700000    -5.07700000
H       33.25700000    21.10100000    -9.62800000
H       32.33600000    19.02300000    -9.60300000
H       33.66200000    24.32100000    -6.14000000
H       32.71900000    23.62200000    -4.83400000
H       33.58600000    23.22200000    -8.38600000
H       31.88373000    24.59348000    -6.05556700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-042LYS-1')] = qcdb.Molecule("""
0 1
C      -28.69200000    14.94100000    -9.51300000
C      -29.02700000    13.45300000    -9.45200000
H      -29.58500000    15.50000000    -9.77700000
H      -28.28100000    15.31300000    -8.57500000
H      -27.92500000    15.12000000   -10.26500000
H      -28.09800000    12.89700000    -9.36900000
H      -29.55234000    13.14524000   -10.36813000
H      -29.64100000    13.23587000    -8.56551200
--
0 1
C      -30.17700000    18.19200000    -8.68500000
C      -31.08500000    18.65900000    -7.54500000
C      -30.21700000    19.08700000    -9.91700000
H      -29.14800000    18.11000000    -8.32800000
H      -30.50600000    17.20700000    -9.00200000
H      -32.07000000    18.90800000    -7.93600000
H      -30.00400000    20.11700000    -9.62600000
H      -29.44900000    18.75900000   -10.61600000
H      -30.65606000    19.54095000    -7.04683200
H      -31.29127000    17.83680000    -6.84396900
H      -31.20059000    19.03079000   -10.40627000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007ILE-097VAL-1')] = qcdb.Molecule("""
0 1
C      -11.93800000    -9.01000000   -19.12600000
C      -13.30200000    -9.69800000   -19.32400000
H      -11.96400000    -7.99300000   -19.51600000
H      -11.69600000    -8.97200000   -18.06600000
H      -11.15700000    -9.57700000   -19.63300000
H      -14.08900000    -9.04000000   -18.95400000
H      -13.30000000   -10.60000000   -18.71200000
H      -13.48777000    -9.97771000   -20.37150000
--
0 1
C      -13.40500000    -7.50200000   -16.03100000
C      -14.65400000    -7.99400000   -15.24000000
H      -12.84800000    -6.76300000   -15.45600000
H      -12.75200000    -8.35400000   -16.21000000
H      -13.71100000    -7.06800000   -16.98400000
H      -14.28600000    -8.44900000   -14.32000000
H      -15.30968000    -7.15251600   -14.97170000
H      -15.21987000    -8.76595200   -15.78211000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-017ARG-1')] = qcdb.Molecule("""
0 1
C      -14.85800000     8.62800000    -4.67400000
C      -15.35600000     9.50900000    -5.84100000
H      -14.14600000     9.18000000    -4.06100000
H      -15.70200000     8.33900000    -4.04800000
H      -14.38100000     7.73600000    -5.07800000
H      -15.71400000    10.45400000    -5.43700000
H      -14.54627000     9.68822100    -6.56364200
H      -16.19099000     9.01105000    -6.35562100
--
0 1
C      -13.67700000     6.77700000    -1.59100000
C      -13.47900000     5.85500000    -2.80200000
C      -15.09700000     6.66500000    -1.04400000
H      -12.97200000     6.51900000    -0.80100000
H      -13.49800000     7.81000000    -1.89300000
H      -14.20300000     6.12600000    -3.56800000
H      -13.68200000     4.82200000    -2.51600000
H      -15.22000000     7.38700000    -0.23400000
H      -15.80100000     6.91600000    -1.83800000
H      -12.46553000     5.91537700    -3.22535800
H      -15.26193000     5.65144000    -0.64967130
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-026VAL-1')] = qcdb.Molecule("""
0 1
C       15.49800000    11.18200000    10.19000000
C       16.01200000    12.05800000     9.05200000
H       14.50400000    10.79000000     9.98600000
H       16.16200000    10.32300000    10.29000000
H       15.53400000    11.73500000    11.12800000
H       16.07600000    11.43600000     8.16400000
H       15.31112000    12.88873000     8.88269800
H       17.01929000    12.43771000     9.27824400
--
0 1
C       12.78200000    12.70400000    12.03400000
C       12.60400000    12.06000000    13.41000000
H       13.47700000    12.13600000    11.44000000
H       11.82100000    12.68600000    11.51800000
H       13.10400000    13.74100000    12.09300000
H       11.82100000    12.59400000    13.94900000
H       13.53900000    12.10618000    13.98762000
H       12.29803000    11.01292000    13.26856000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-033LEU-1')] = qcdb.Molecule("""
0 1
C       17.41000000    12.58500000     9.36600000
C       16.01200000    12.05800000     9.05200000
H       17.38200000    13.20400000    10.26300000
H       18.08600000    11.74500000     9.52900000
H       17.77800000    13.17200000     8.52400000
H       16.07600000    11.43600000     8.16400000
H       15.31112000    12.88873000     8.88269800
H       15.64132000    11.42627000     9.87267800
--
0 1
C       21.05400000    13.00600000     9.28200000
C       22.29300000    13.50200000    10.01500000
H       21.16000000    13.16700000     8.20800000
H       20.91600000    11.94600000     9.48800000
H       20.17600000    13.54300000     9.64200000
H       22.17000000    13.28900000    11.07500000
H       22.40749000    14.58605000     9.86759800
H       23.18815000    12.97295000     9.65608000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-090TYR-1')] = qcdb.Molecule("""
0 1
C       15.49800000    11.18200000    10.19000000
C       16.01200000    12.05800000     9.05200000
H       14.50400000    10.79000000     9.98600000
H       16.16200000    10.32300000    10.29000000
H       15.53400000    11.73500000    11.12800000
H       16.07600000    11.43600000     8.16400000
H       15.31112000    12.88873000     8.88269800
H       17.01929000    12.43771000     9.27824400
--
0 1
C       17.22800000     5.96400000    10.10200000
C       14.02100000     7.82100000     9.21900000
C       15.28900000     7.24900000     9.12300000
C       13.33500000     7.78900000    10.43400000
C       15.88400000     6.64100000    10.23300000
C       13.91900000     7.19100000    11.55300000
C       15.19000000     6.62100000    11.44700000
O       12.08900000     8.33200000    10.52200000
H       13.57500000     8.29200000     8.36000000
H       15.82600000     7.28800000     8.18500000
H       11.78700000     8.60800000     9.62500000
H       13.37900000     7.16000000    12.48800000
H       17.71900000     5.93000000    11.07500000
H       17.84800000     6.57900000     9.44700000
H       15.63000000     6.14000000    12.31000000
H       17.15464000     4.94704600     9.68917700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-096TYR-1')] = qcdb.Molecule("""
0 1
C      -16.50800000     8.82200000    -6.55100000
C      -15.35600000     9.50900000    -5.84100000
H      -16.21200000     7.82600000    -6.87200000
H      -17.35400000     8.73200000    -5.86900000
H      -16.82100000     9.40100000    -7.41900000
H      -15.71400000    10.45400000    -5.43700000
H      -14.54627000     9.68822100    -6.56364200
H      -15.00136000     8.88162300    -5.00995700
--
0 1
C      -20.82400000     7.13800000    -5.74600000
C      -19.47400000     7.39200000    -7.86500000
C      -20.62100000     7.69400000    -7.13400000
C      -19.29100000     7.91000000    -9.14500000
C      -20.27300000     8.69400000    -9.73200000
C      -21.59100000     8.50000000    -7.71900000
C      -21.43200000     8.98300000    -9.01800000
O      -20.06100000     9.15900000   -10.99900000
H      -18.70200000     6.77900000    -7.42000000
H      -18.37600000     7.69000000    -9.67500000
H      -21.72000000     7.57500000    -5.30200000
H      -19.97100000     7.45400000    -5.14400000
H      -22.49100000     8.74400000    -7.16900000
H      -19.13400000     9.13100000   -11.25100000
H      -22.19000000     9.60200000    -9.47300000
H      -20.90422000     6.04138200    -5.71448400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LEU-168HIE-1')] = qcdb.Molecule("""
0 1
C       33.27300000     8.11900000    23.71500000
C       34.17500000     7.71300000    24.89400000
H       33.46300000     7.47100000    22.85900000
H       32.22900000     8.01600000    24.00000000
H       33.46600000     9.15500000    23.43600000
H       33.97900000     8.42000000    25.69900000
H       35.22694000     7.79981800    24.58435000
H       33.93596000     6.70428900    25.26192000
--
0 1
C       32.39400000     9.62400000    20.13400000
C       30.48700000     8.93900000    21.71400000
C       31.42800000     8.68900000    20.77100000
C       30.47700000     6.79300000    21.25800000
N       29.90800000     7.71900000    22.02400000
N       31.43400000     7.33500000    20.50100000
H       30.26300000     9.90100000    22.15900000
H       29.20000000     7.55000000    22.74200000
H       33.38200000     9.35100000    20.50600000
H       32.17500000    10.61900000    20.50700000
H       30.26400000     5.74400000    21.31400000
H       32.40412000     9.63340100    19.03409000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LYS-011ASP-1')] = qcdb.Molecule("""
1 1
C       29.28400000   -13.69900000     3.31400000
N       28.55500000   -13.89900000     4.60400000
H       27.65900000   -14.37100000     4.49500000
H       29.11900000   -14.43300000     5.25600000
H       28.39000000   -12.99200000     5.05700000
H       29.72300000   -14.64300000     2.97400000
H       30.10700000   -12.99200000     3.46500000
H       28.63118000   -13.31753000     2.51506400
--
-1 1
C       27.83800000    -9.55300000     7.32400000
C       27.86100000   -11.02600000     6.96800000
O       28.47600000   -11.37600000     5.93600000
O       27.26800000   -11.83800000     7.71800000
H       27.92000000    -8.93700000     6.42600000
H       28.72100000    -9.35800000     7.93400000
H       26.93330000    -9.27374600     7.88394700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LYS-093SER-1')] = qcdb.Molecule("""
0 1
C       28.37700000   -13.16900000     2.20400000
C       27.56600000   -11.97200000     2.69700000
C       29.28400000   -13.69900000     3.31400000
H       27.69600000   -13.96000000     1.88200000
H       28.99200000   -12.87100000     1.35200000
H       28.25600000   -11.20900000     3.06200000
H       26.91200000   -12.28800000     3.50900000
H       29.72300000   -14.64300000     2.97400000
H       30.10700000   -12.99200000     3.46500000
H       26.92865000   -11.54446000     1.90896700
H       28.74767000   -13.84614000     4.26305400
--
0 1
C       29.29500000   -16.57600000    -0.36900000
O       29.79100000   -15.36300000     0.16500000
H       30.72600000   -15.28600000    -0.08100000
H       29.82600000   -17.42100000     0.07300000
H       29.47100000   -16.57900000    -1.44700000
H       28.21524000   -16.67507000    -0.18377560
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007LYS-099THR-1')] = qcdb.Molecule("""
0 1
C        2.57100000    -6.67400000    19.20000000
C        3.87800000    -7.42200000    18.99100000
C        2.02900000    -6.88100000    20.60200000
H        2.70700000    -5.60700000    19.01100000
H        1.82200000    -7.05400000    18.50700000
H        3.74600000    -8.48700000    19.17200000
H        4.62600000    -7.04600000    19.68800000
H        1.04400000    -6.40200000    20.65400000
H        1.87900000    -7.95400000    20.77200000
H        4.26412100    -7.24748200    17.97589000
H        2.69287800    -6.45411600    21.36818000
--
0 1
C       -1.62900000    -5.02600000    18.68200000
O       -0.47100000    -5.82300000    18.44200000
H       -0.77000000    -6.73500000    18.33600000
H       -2.04400000    -5.28500000    19.65700000
H       -1.34241800    -3.96400300    18.68772000
H       -2.38989200    -5.23928000    17.91678000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-019VAL-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        3.27900000     6.99400000    23.24300000
C        3.37400000     8.22800000    20.98200000
C        4.67900000     8.64800000    21.24300000
C        2.80400000     8.55600000    19.76000000
C        5.38200000     9.39700000    20.29700000
C        3.50500000     9.30100000    18.81900000
C        4.79800000     9.71700000    19.09300000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        3.70400000     7.85700000    23.75600000
H        5.14800000     8.47300000    22.18200000
H        1.80000000     8.22700000    19.53200000
H        6.38800000     9.73200000    20.51000000
H        3.05100000     9.51600000    17.86700000
H        5.34500000    10.30200000    18.36700000
H        4.02174400     6.19917400    23.07996000
H        2.49016800     6.54832800    23.86680000
--
0 1
C        1.14700000     4.31000000    20.33800000
C        1.09700000     2.79000000    20.21500000
H        0.64300000     4.75400000    19.47900000
H        0.65200000     4.66000000    21.24200000
H        2.18200000     4.64600000    20.31900000
H        1.63100000     2.48700000    19.31300000
H        1.56426700     2.29701200    21.08023000
H        0.05084895     2.46495400    20.11544000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-021PHE-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        2.80400000     8.55600000    19.76000000
C        3.37400000     8.22800000    20.98200000
C        3.50500000     9.30100000    18.81900000
C        4.67900000     8.64800000    21.24300000
C        4.79800000     9.71700000    19.09300000
C        5.38200000     9.39700000    20.29700000
H        1.80000000     8.22700000    19.53200000
H        3.05100000     9.51600000    17.86700000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        5.14800000     8.47300000    22.18200000
H        5.34500000    10.30200000    18.36700000
H        6.38800000     9.73200000    20.51000000
H        3.07897000     7.11491600    22.88334000
--
0 1
C        7.20800000     3.43200000    16.83200000
C        3.53600000     5.50300000    17.62400000
C        3.60300000     4.57600000    16.59600000
C        4.66100000     5.75200000    18.40200000
C        4.79400000     3.90700000    16.34000000
C        5.85100000     5.08200000    18.14400000
C        5.92100000     4.15100000    17.11400000
H        2.61100000     6.02000000    17.83800000
H        2.73700000     4.34600000    16.00400000
H        4.61500000     6.47300000    19.20400000
H        4.84000000     3.19000000    15.53300000
H        6.72000000     5.29000000    18.75000000
H        8.02900000     4.10000000    17.10000000
H        7.29000000     3.22400000    15.76800000
H        7.32031300     2.47301700    17.35901000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-021PRO-1')] = qcdb.Molecule("""
0 1
C        2.78000000    21.86600000    21.42900000
C        1.65000000    23.66000000    20.08700000
C        2.78400000    22.88800000    20.33500000
C        1.67800000    24.64600000    19.09700000
C        3.94200000    23.10900000    19.59100000
C        2.83800000    24.85500000    18.36300000
C        3.97100000    24.09200000    18.60800000
H        0.75000000    23.50500000    20.66500000
H        0.79800000    25.24600000    18.90400000
H        3.40300000    21.02700000    21.11800000
H        1.76600000    21.48700000    21.55600000
H        4.82800000    22.52200000    19.78300000
H        2.85500000    25.61000000    17.59100000
H        4.87500000    24.26300000    18.04100000
H        3.15613700    22.25436000    22.38696000
--
0 1
C        0.23400000    22.44500000    16.74400000
C        0.42300000    21.15000000    15.97700000
C        0.97500000    23.46500000    15.89100000
H        0.65500000    22.37000000    17.74600000
H       -0.82600000    22.69900000    16.79300000
H        1.39100000    20.70800000    16.21600000
H       -0.39300000    20.46400000    16.20500000
H        2.04900000    23.35100000    16.02700000
H        0.66300000    24.48500000    16.12000000
H        0.40726920    21.48859000    14.93052000
H        0.67381720    23.16671000    14.87596000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-022VAL-1')] = qcdb.Molecule("""
0 1
C        4.54200000    85.33200000    36.06500000
C        3.54900000    86.47500000    38.10400000
C        4.64300000    85.86800000    37.48500000
C        3.59500000    86.91200000    39.42900000
C        4.78700000    86.73500000    40.17500000
C        5.81300000    85.70400000    38.21400000
C        5.89000000    86.13400000    39.56400000
H        2.65300000    86.59300000    37.52800000
H        2.72500000    87.37900000    39.87700000
H        5.56100000    85.20100000    35.69200000
H        4.04500000    86.09400000    35.46600000
H        4.85900000    87.05800000    41.20900000
H        6.66300000    85.23800000    37.73500000
H        6.80300000    85.99700000    40.12800000
H        3.95185300    84.40798000    35.97602000
--
0 1
C        4.54300000    89.34100000    35.75700000
C        5.73900000    89.46100000    34.78800000
H        4.00500000    88.41300000    35.56800000
H        4.89300000    89.34800000    36.79000000
H        3.86700000    90.18400000    35.60900000
H        6.26800000    90.38300000    34.98800000
H        5.40620400    89.45888000    33.73955000
H        6.46918700    88.65172000    34.93594000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-024VAL-1')] = qcdb.Molecule("""
0 1
C        2.78000000    21.86600000    21.42900000
C        3.94200000    23.10900000    19.59100000
C        2.78400000    22.88800000    20.33500000
C        3.97100000    24.09200000    18.60800000
C        2.83800000    24.85500000    18.36300000
C        1.65000000    23.66000000    20.08700000
C        1.67800000    24.64600000    19.09700000
H        4.82800000    22.52200000    19.78300000
H        4.87500000    24.26300000    18.04100000
H        3.40300000    21.02700000    21.11800000
H        1.76600000    21.48700000    21.55600000
H        2.85500000    25.61000000    17.59100000
H        0.75000000    23.50500000    20.66500000
H        0.79800000    25.24600000    18.90400000
H        3.15613700    22.25436000    22.38696000
--
0 1
C        4.64700000    21.59500000    16.64000000
C        5.33500000    21.03100000    15.41300000
H        4.08600000    22.48800000    16.37900000
H        3.94700000    20.86100000    17.03900000
H        5.39100000    21.83800000    17.39800000
H        4.57300000    20.78400000    14.67800000
H        6.01913700    21.77245000    14.97458000
H        5.88177100    20.11254000    15.67275000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-035PHE-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        4.79800000     9.71700000    19.09300000
C        5.38200000     9.39700000    20.29700000
C        3.50500000     9.30100000    18.81900000
C        4.67900000     8.64800000    21.24300000
C        2.80400000     8.55600000    19.76000000
C        3.37400000     8.22800000    20.98200000
H        5.34500000    10.30200000    18.36700000
H        6.38800000     9.73200000    20.51000000
H        3.05100000     9.51600000    17.86700000
H        5.14800000     8.47300000    22.18200000
H        1.80000000     8.22700000    19.53200000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        3.07897000     7.11491600    22.88334000
--
0 1
C       11.10000000    10.19200000    15.52000000
C        7.12500000     8.97500000    16.58600000
C        7.32800000     9.99100000    15.67200000
C        8.20900000     8.36300000    17.17900000
C        8.61100000    10.39000000    15.34400000
C        9.49600000     8.74700000    16.83700000
C        9.70700000     9.77800000    15.92900000
H        6.12200000     8.65700000    16.83000000
H        6.47900000    10.46300000    15.21000000
H        8.05000000     7.57200000    17.89800000
H        8.75100000    11.18400000    14.62400000
H       10.33700000     8.25800000    17.30100000
H       11.05900000    10.52500000    14.48000000
H       11.75700000     9.32100000    15.54800000
H       11.52728000    11.00029000    16.13164000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-084LEU-1')] = qcdb.Molecule("""
0 1
C       27.81800000     3.48700000    31.42600000
C       24.78200000     2.13400000    29.51300000
C       25.86800000     2.20800000    30.36700000
C       24.36700000     3.22200000    28.76600000
C       26.62100000     3.37000000    30.49200000
C       25.11700000     4.39000000    28.87700000
C       26.21800000     4.47200000    29.74400000
H       24.23600000     1.20500000    29.43700000
H       26.14000000     1.33800000    30.94600000
H       23.50900000     3.16100000    28.10900000
H       24.82100000     5.25400000    28.30300000
H       27.60100000     2.93100000    32.33900000
H       27.93600000     4.53200000    31.71700000
H       26.76500000     5.39300000    29.83000000
H       28.77183000     3.13687700    31.00456000
--
0 1
C       21.79700000    -0.15300000    29.80700000
C       20.81500000    -1.31100000    29.88800000
H       22.61800000    -0.31000000    30.49800000
H       22.19000000    -0.07600000    28.79200000
H       21.32000000     0.78500000    30.06700000
H       20.03800000    -1.13000000    29.14800000
H       20.35938000    -1.34784700    30.88853000
H       21.32994000    -2.24568200    29.62115000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-091ILE-1')] = qcdb.Molecule("""
0 1
C       27.81800000     3.48700000    31.42600000
C       24.78200000     2.13400000    29.51300000
C       25.86800000     2.20800000    30.36700000
C       24.36700000     3.22200000    28.76600000
C       26.62100000     3.37000000    30.49200000
C       25.11700000     4.39000000    28.87700000
C       26.21800000     4.47200000    29.74400000
H       24.23600000     1.20500000    29.43700000
H       26.14000000     1.33800000    30.94600000
H       23.50900000     3.16100000    28.10900000
H       24.82100000     5.25400000    28.30300000
H       27.60100000     2.93100000    32.33900000
H       27.93600000     4.53200000    31.71700000
H       26.76500000     5.39300000    29.83000000
H       28.77183000     3.13687700    31.00456000
--
0 1
C       23.38100000     1.77100000    33.04600000
C       23.95100000     2.97700000    33.80500000
H       23.35700000     1.95200000    31.97400000
H       24.02200000     0.91600000    33.24300000
H       22.37800000     1.53300000    33.40200000
H       24.88200000     3.30500000    33.34100000
H       24.16400000     2.64500000    34.82000000
H       23.21298000     3.79267100    33.80286000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-111PHE-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        3.50500000     9.30100000    18.81900000
C        4.79800000     9.71700000    19.09300000
C        2.80400000     8.55600000    19.76000000
C        3.37400000     8.22800000    20.98200000
C        5.38200000     9.39700000    20.29700000
C        4.67900000     8.64800000    21.24300000
H        3.05100000     9.51600000    17.86700000
H        5.34500000    10.30200000    18.36700000
H        1.80000000     8.22700000    19.53200000
H        6.38800000     9.73200000    20.51000000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        5.14800000     8.47300000    22.18200000
H        3.07897000     7.11491600    22.88334000
--
0 1
C        5.26800000    11.40800000    11.96400000
C        3.44900000    11.32900000    15.83900000
C        3.10800000    10.37300000    14.89400000
C        4.37900000    12.30400000    15.52800000
C        3.69700000    10.40000000    13.64100000
C        4.96900000    12.33000000    14.27400000
C        4.63900000    11.37100000    13.32700000
H        2.97000000    11.34400000    16.80600000
H        2.37800000     9.61200000    15.13400000
H        4.64500000    13.04600000    16.26700000
H        3.42900000     9.64700000    12.91300000
H        5.70200000    13.08300000    14.04400000
H        5.35300000    10.39100000    11.57600000
H        6.28300000    11.79900000    12.05300000
H        4.70885000    12.03353000    11.25262000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-157ILE-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        2.80400000     8.55600000    19.76000000
C        3.37400000     8.22800000    20.98200000
C        3.50500000     9.30100000    18.81900000
C        4.67900000     8.64800000    21.24300000
C        4.79800000     9.71700000    19.09300000
C        5.38200000     9.39700000    20.29700000
H        1.80000000     8.22700000    19.53200000
H        3.05100000     9.51600000    17.86700000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        5.14800000     8.47300000    22.18200000
H        5.34500000    10.30200000    18.36700000
H        6.38800000     9.73200000    20.51000000
H        3.07897000     7.11491600    22.88334000
--
0 1
C        2.48700000    12.05100000    20.52200000
C        1.25000000    11.83100000    21.39400000
H        2.24500000    11.78400000    19.49400000
H        2.74600000    13.10700000    20.54400000
H        3.32700000    11.44200000    20.84600000
H        0.98000000    10.77400000    21.34700000
H        0.43700000    12.40900000    20.95600000
H        1.38953100    12.12229000    22.44551000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007PHE-160CYS-1')] = qcdb.Molecule("""
0 1
C        2.56600000     7.42500000    21.96100000
C        4.67900000     8.64800000    21.24300000
C        3.37400000     8.22800000    20.98200000
C        5.38200000     9.39700000    20.29700000
C        4.79800000     9.71700000    19.09300000
C        2.80400000     8.55600000    19.76000000
C        3.50500000     9.30100000    18.81900000
H        5.14800000     8.47300000    22.18200000
H        6.38800000     9.73200000    20.51000000
H        2.18100000     6.55000000    21.44900000
H        1.71200000     8.04200000    22.24400000
H        5.34500000    10.30200000    18.36700000
H        1.80000000     8.22700000    19.53200000
H        3.05100000     9.51600000    17.86700000
H        3.07897000     7.11491600    22.88334000
--
0 1
C        5.96300000    10.16600000    24.34700000
C        6.05500000     9.45200000    25.71000000
S        6.19900000    11.96800000    24.39400000
H        6.68900000     9.72800000    23.66000000
H        4.97300000     9.97200000    23.93900000
H        5.68800000     8.43400000    25.60600000
H        7.49300000    11.92300000    24.75600000
H        5.45289600     9.96493100    26.47444000
H        7.09448600     9.39461400    26.06521000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007SER-010ARG-2')] = qcdb.Molecule("""
0 1
C       24.97000000    -8.42700000   -21.49400000
O       23.64000000    -7.95400000   -21.41000000
H       23.28000000    -7.91800000   -22.31000000
H       25.54600000    -7.82500000   -22.19700000
H       24.94900000    -9.46100000   -21.84400000
H       25.41102000    -8.38420300   -20.48719000
--
1 1
C       22.89800000    -8.91100000   -15.83300000
C       22.53400000    -7.73500000   -17.98100000
N       22.22100000    -7.81300000   -19.24000000
N       22.61400000    -8.84500000   -17.26400000
N       22.71200000    -6.56700000   -17.44600000
H       22.10400000    -8.70900000   -19.68400000
H       22.32800000    -7.01800000   -19.84900000
H       22.37800000    -9.71000000   -17.73000000
H       22.91100000    -6.49900000   -16.46400000
H       22.52000000    -5.73600000   -17.98200000
H       22.34500000    -9.75600000   -15.41800000
H       22.52600000    -8.02400000   -15.31900000
H       23.96196000    -9.04800900   -15.58967000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007SER-100ASN-1')] = qcdb.Molecule("""
0 1
C      -12.77500000    22.68400000    11.02800000
O      -12.50500000    22.34500000     9.68300000
H      -12.24600000    23.15600000     9.22200000
H      -13.35800000    21.88700000    11.49100000
H      -13.35900000    23.60500000    11.06800000
H      -11.83267000    22.81841000    11.57931000
--
0 1
C      -12.13600000    20.42700000     6.87000000
C      -12.84500000    19.38400000     7.69700000
O      -13.28700000    18.36500000     7.17500000
N      -12.88300000    19.58100000     8.99900000
H      -13.46500000    18.97000000     9.56100000
H      -12.54400000    20.46300000     9.37800000
H      -11.06800000    20.37600000     7.08300000
H      -12.50300000    21.40700000     7.17500000
H      -12.31160000    20.29098000     5.79265900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007THR-031LYS-1')] = qcdb.Molecule("""
0 1
C      -16.92900000    26.71000000    -6.10500000
C      -15.69400000    26.88000000    -6.98100000
H      -16.97300000    25.70800000    -5.68200000
H      -16.83600000    27.43300000    -5.29900000
H      -17.83200000    26.92000000    -6.67900000
H      -15.68500000    27.89700000    -7.37100000
H      -15.69544000    26.16253000    -7.81481100
H      -14.79434000    26.71614000    -6.36963500
--
0 1
C      -19.35700000    28.09800000    -3.51900000
C      -19.03900000    27.53400000    -2.13300000
C      -19.45700000    29.62200000    -3.51600000
H      -18.61100000    27.77800000    -4.23300000
H      -20.31800000    27.68600000    -3.83200000
H      -19.08300000    26.44400000    -2.18500000
H      -19.82400000    27.85900000    -1.44700000
H      -20.11100000    29.94300000    -2.70200000
H      -18.46300000    30.04800000    -3.36500000
H      -18.06222000    27.83256000    -1.72463300
H      -19.86410000    29.98579000    -4.47094900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007TYR-053TYR-1')] = qcdb.Molecule("""
0 1
C        9.00600000    32.78400000     8.95700000
C        7.74600000    32.16600000     8.30800000
C        8.78400000    33.53000000    10.23400000
C        8.11800000    34.75900000    10.22500000
C        9.27500000    33.03700000    11.43700000
C        7.91100000    35.45500000    11.40200000
C        9.06600000    33.71800000    12.61100000
C        8.39900000    34.94600000    12.59800000
O        8.19800000    35.60800000    13.76000000
H        9.71600000    31.98500000     9.15200000
H        9.47700000    33.45500000     8.23800000
H        7.22100000    32.95500000     7.76800000
H        7.74200000    35.16000000     9.29200000
H        9.82500000    32.10800000    11.45000000
H        7.38100000    36.39800000    11.38800000
H        9.43600000    33.32100000    13.54600000
H        7.71700000    36.43400000    13.62300000
H        7.05623000    31.69276000     9.02232500
H        8.07978400    31.41372000     7.57816400
--
0 1
C       10.43900000    28.72400000    11.60100000
C       11.68700000    30.24000000    10.03700000
C       11.60700000    29.59200000    11.27500000
C       12.78000000    31.04300000     9.71600000
C       12.65700000    29.73100000    12.17200000
C       13.80000000    31.17900000    10.62300000
C       13.75600000    30.53800000    11.85600000
O       14.86400000    31.95500000    10.27800000
H       10.89800000    30.10700000     9.30900000
H       12.83500000    31.54300000     8.76000000
H       10.77900000    27.71000000    11.80100000
H        9.81400000    28.67100000    10.71100000
H       12.64700000    29.20400000    13.11300000
H       14.57200000    30.64200000    12.55600000
H       15.52600000    31.98500000    10.97800000
H        9.83747000    29.08983000    12.44618000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-022SER-1')] = qcdb.Molecule("""
0 1
C       22.80700000     1.17700000     6.61900000
C       22.55700000     0.21000000     5.45400000
C       23.39400000     0.49700000     7.90200000
C       23.67700000     2.32500000     6.16500000
H       21.85400000     1.60700000     6.91200000
H       21.83700000    -0.53400000     5.80400000
H       24.42800000     0.22500000     7.70000000
H       23.36800000     1.19900000     8.73700000
H       22.80500000    -0.38800000     8.15400000
H       23.16700000     2.91600000     5.40400000
H       23.86700000     2.98400000     7.01500000
H       24.63800000     1.96700000     5.79100000
H       23.47928000    -0.28719010     5.11903500
H       22.07085000     0.75816750     4.63353100
--
0 1
C       19.68600000     0.90200000     8.72400000
C       19.63700000    -0.04700000     9.91400000
O       19.61400000     0.16800000     7.52900000
H       18.88600000     1.63700000     8.78600000
H       20.63500000     1.43600000     8.74300000
H       20.31400000    -0.88300000     9.72100000
H       18.73900000    -0.23200000     7.41900000
H       18.61576000    -0.42556960    10.06812000
H       19.97278000     0.45056130    10.83578000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-026GLU-1')] = qcdb.Molecule("""
0 1
C       15.89900000    15.34900000    20.65900000
C       15.38000000    14.99600000    19.26100000
H       16.61400000    16.16900000    20.59700000
H       15.07600000    15.64900000    21.30600000
H       16.38500000    14.48400000    21.11300000
H       15.02600000    15.89800000    18.76500000
H       16.19834000    14.53793000    18.68612000
H       14.53274000    14.31428000    19.42655000
--
0 1
C       14.12000000    18.64600000    21.15200000
C       14.94100000    19.89500000    21.26000000
C       12.95800000    18.61900000    22.09800000
H       13.72700000    18.56100000    20.13700000
H       14.76000000    17.79100000    21.34800000
H       14.29200000    20.77300000    21.23800000
H       13.32400000    18.61300000    23.12600000
H       12.37300000    19.53100000    21.95500000
H       15.62292000    19.90035000    20.39689000
H       15.51791000    19.89791000    22.19657000
H       12.30416000    17.74865000    21.93995000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-034ALA-1')] = qcdb.Molecule("""
0 1
C       20.52900000    39.39400000    55.12600000
C       19.53200000    38.61600000    55.97500000
H       20.46700000    39.09900000    54.08200000
H       20.29600000    40.45300000    55.18700000
H       21.54200000    39.24100000    55.49300000
H       18.52600000    38.95400000    55.72600000
H       19.59759000    37.53586000    55.77751000
H       19.70345000    38.81711000    57.04278000
--
0 1
C       18.24600000    40.62100000    52.74600000
C       17.67500000    41.40600000    51.57100000
H       17.51500000    39.90400000    53.12400000
H       19.14100000    40.09500000    52.41900000
H       18.52500000    41.30700000    53.54700000
H       18.45800000    42.06200000    51.18700000
H       16.83363000    42.02627000    51.91358000
H       17.39854000    40.71917000    50.75746000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-038VAL-1')] = qcdb.Molecule("""
0 1
C       23.67700000     2.32500000     6.16500000
C       22.80700000     1.17700000     6.61900000
H       23.16700000     2.91600000     5.40400000
H       23.86700000     2.98400000     7.01500000
H       24.63800000     1.96700000     5.79100000
H       21.85400000     1.60700000     6.91200000
H       22.62779000     0.48382830     5.78389600
H       23.21927000     0.69941830     7.52008400
--
0 1
C       26.81200000     2.48500000     8.01100000
C       28.20300000     2.40200000     8.64400000
H       26.42400000     1.48400000     7.82000000
H       26.13600000     2.99500000     8.69900000
H       26.83200000     3.06300000     7.08600000
H       28.61800000     3.40900000     8.68300000
H       28.84945000     1.76359800     8.02387900
H       28.17322000     2.00541900     9.66959100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-040THR-1')] = qcdb.Molecule("""
0 1
C       23.67700000     2.32500000     6.16500000
C       22.80700000     1.17700000     6.61900000
H       23.16700000     2.91600000     5.40400000
H       23.86700000     2.98400000     7.01500000
H       24.63800000     1.96700000     5.79100000
H       21.85400000     1.60700000     6.91200000
H       22.62779000     0.48382830     5.78389600
H       23.21927000     0.69941830     7.52008400
--
0 1
C       25.08700000     5.15400000     4.18000000
C       24.83500000     4.59300000     2.73700000
H       26.15200000     5.13200000     4.41900000
H       24.73600000     6.18500000     4.23600000
H       24.54400000     4.57200000     4.91700000
H       23.77400000     4.69800000     2.51300000
H       25.09925000     3.52679300     2.67890800
H       25.40833000     5.17725400     2.00219700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-154GLN-1')] = qcdb.Molecule("""
0 1
C       19.76900000    38.89400000    57.45100000
C       19.53200000    38.61600000    55.97500000
H       20.79800000    38.66000000    57.72800000
H       19.55500000    39.94200000    57.65500000
H       19.09300000    38.28800000    58.05500000
H       18.52600000    38.95400000    55.72600000
H       19.59759000    37.53586000    55.77751000
H       20.25200000    39.17785000    55.36188000
--
0 1
C       22.00500000    41.69700000    58.49900000
C       23.47100000    41.28000000    58.62600000
C       21.68800000    42.41800000    57.19100000
H       21.37200000    40.82100000    58.61900000
H       21.77900000    42.38400000    59.31700000
H       24.10600000    42.10000000    58.31200000
H       22.31200000    43.30200000    57.13500000
H       21.92700000    41.77000000    56.35100000
H       23.68645000    40.40910000    57.98951000
H       23.70338000    41.05924000    59.67826000
H       20.62787000    42.70119000    57.11403000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-154GLN-2')] = qcdb.Molecule("""
0 1
C       20.52900000    39.39400000    55.12600000
C       19.53200000    38.61600000    55.97500000
H       20.46700000    39.09900000    54.08200000
H       20.29600000    40.45300000    55.18700000
H       21.54200000    39.24100000    55.49300000
H       18.52600000    38.95400000    55.72600000
H       19.59759000    37.53586000    55.77751000
H       19.70345000    38.81711000    57.04278000
--
0 1
C       21.68800000    42.41800000    57.19100000
C       22.00500000    41.69700000    58.49900000
C       20.22800000    42.80800000    57.08500000
O       19.54900000    42.99800000    58.09300000
N       19.73200000    42.94700000    55.86200000
H       22.31200000    43.30200000    57.13500000
H       21.92700000    41.77000000    56.35100000
H       21.37200000    40.82100000    58.61900000
H       21.77900000    42.38400000    59.31700000
H       18.74500000    43.13600000    55.78100000
H       20.32900000    42.85500000    55.03400000
H       23.05938000    41.39709000    58.59034000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-191TYR-1')] = qcdb.Molecule("""
0 1
C       -4.70800000    10.11000000   -18.68900000
C       -4.46100000    11.54100000   -18.21300000
H       -3.88300000     9.44500000   -18.44400000
H       -5.62100000     9.73000000   -18.23000000
H       -4.83600000    10.07400000   -19.76600000
H       -4.62100000    11.55800000   -17.13700000
H       -3.42798600    11.85284000   -18.42663000
H       -5.17988500    12.22816000   -18.68312000
--
0 1
C       -9.77900000     5.95400000   -17.21400000
C       -7.87400000     8.66800000   -19.95700000
C       -8.50000000     9.15800000   -18.82000000
C       -7.86000000     7.30200000   -20.20900000
C       -9.11200000     8.28000000   -17.93300000
C       -8.47600000     6.42800000   -19.31700000
C       -9.11000000     6.90700000   -18.17400000
O       -7.27600000     9.52700000   -20.82600000
H       -8.50600000    10.21600000   -18.63100000
H       -7.37700000    10.44500000   -20.56500000
H       -7.35900000     6.92800000   -21.09100000
H       -9.58100000     8.67400000   -17.04000000
H       -8.43300000     5.36300000   -19.49800000
H       -9.46200000     6.19600000   -16.19900000
H       -9.42000000     4.94300000   -17.41300000
H      -10.87746000     5.96332100   -17.27136000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '007VAL-248MET-1')] = qcdb.Molecule("""
0 1
C       -4.70800000    10.11000000   -18.68900000
C       -4.46100000    11.54100000   -18.21300000
H       -3.88300000     9.44500000   -18.44400000
H       -5.62100000     9.73000000   -18.23000000
H       -4.83600000    10.07400000   -19.76600000
H       -4.62100000    11.55800000   -17.13700000
H       -3.42798600    11.85284000   -18.42663000
H       -5.17988500    12.22816000   -18.68312000
--
0 1
C       -4.43200000     8.05000000   -15.82700000
C       -6.61900000     6.70100000   -14.72900000
S       -6.16100000     7.69800000   -16.16500000
H       -3.84200000     7.14100000   -15.93900000
H       -4.05200000     8.81600000   -16.49100000
H       -4.36500000     8.41800000   -14.81000000
H       -5.80900000     6.00200000   -14.52700000
H       -7.52200000     6.14000000   -14.96600000
H       -6.79812100     7.29782800   -13.82252000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ALA-034ALA-1')] = qcdb.Molecule("""
0 1
C       19.07900000    37.47900000    51.22800000
C       19.51100000    36.22400000    51.99000000
H       19.90800000    38.18000000    51.14200000
H       18.73700000    37.20100000    50.23200000
H       18.25600000    37.96400000    51.74800000
H       18.69000000    35.51500000    52.04000000
H       19.82548000    36.48481000    53.01131000
H       20.33665000    35.71992000    51.46636000
--
0 1
C       18.24600000    40.62100000    52.74600000
C       17.67500000    41.40600000    51.57100000
H       17.51500000    39.90400000    53.12400000
H       19.14100000    40.09500000    52.41900000
H       18.52500000    41.30700000    53.54700000
H       18.45800000    42.06200000    51.18700000
H       16.83363000    42.02627000    51.91358000
H       17.39854000    40.71917000    50.75746000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ALA-035GLU-1')] = qcdb.Molecule("""
0 1
C       19.07900000    37.47900000    51.22800000
C       19.51100000    36.22400000    51.99000000
H       19.90800000    38.18000000    51.14200000
H       18.73700000    37.20100000    50.23200000
H       18.25600000    37.96400000    51.74800000
H       18.69000000    35.51500000    52.04000000
H       19.82548000    36.48481000    53.01131000
H       20.33665000    35.71992000    51.46636000
--
-1 1
C       14.52700000    37.30700000    51.23700000
C       15.51200000    36.16600000    51.04100000
O       15.32500000    35.36600000    50.09700000
O       16.46500000    36.06200000    51.83400000
H       14.82500000    37.93700000    52.08000000
H       13.54400000    36.89300000    51.47800000
H       14.42794000    37.93029000    50.33606000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ALA-038MET-1')] = qcdb.Molecule("""
0 1
C       19.07900000    37.47900000    51.22800000
C       19.51100000    36.22400000    51.99000000
H       19.90800000    38.18000000    51.14200000
H       18.73700000    37.20100000    50.23200000
H       18.25600000    37.96400000    51.74800000
H       18.69000000    35.51500000    52.04000000
H       19.82548000    36.48481000    53.01131000
H       20.33665000    35.71992000    51.46636000
--
0 1
C       20.40800000    38.37300000    48.09200000
C       19.49900000    38.08900000    46.89200000
C       21.94400000    40.70100000    47.83900000
S       22.09600000    38.91000000    47.67300000
H       19.95600000    39.11900000    48.74000000
H       20.49000000    37.44700000    48.66000000
H       18.50400000    37.82500000    47.25200000
H       19.90500000    37.23400000    46.35300000
H       21.55400000    40.95100000    48.82600000
H       22.92300000    41.16300000    47.71500000
H       21.27100000    41.09700000    47.08400000
H       19.43002000    38.93543000    46.19286000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ARG-115SER-1')] = qcdb.Molecule("""
1 1
C       14.67600000    19.22900000    32.51600000
C       12.92300000    20.47700000    33.76400000
N       11.63600000    20.78300000    33.85700000
N       13.31700000    19.69800000    32.76600000
N       13.76200000    20.91900000    34.66800000
H       11.01700000    20.44200000    33.12400000
H       11.31500000    21.47200000    34.52500000
H       12.57800000    19.42000000    32.11900000
H       14.73400000    20.66000000    34.61500000
H       13.42800000    21.48700000    35.43000000
H       15.06000000    18.69800000    33.39000000
H       15.32100000    20.08500000    32.30700000
H       14.69425000    18.55528000    31.64665000
--
0 1
C       10.78700000    24.43000000    34.82400000
O       11.36800000    23.26000000    35.40800000
H       11.43600000    23.40800000    36.36600000
H       11.26900000    24.63900000    33.86800000
H       10.94000000    25.28500000    35.48400000
H        9.70888700    24.26967000    34.67579000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ASN-030LYS-1')] = qcdb.Molecule("""
0 1
C       12.17200000    17.02000000     6.25600000
C       13.27700000    17.94600000     6.71800000
O       13.28100000    18.39900000     7.85900000
N       14.21300000    18.24700000     5.83600000
H       12.45100000    16.52600000     5.32500000
H       11.30400000    17.64900000     6.05100000
H       14.95500000    18.87300000     6.10200000
H       14.19900000    17.82800000     4.92000000
H       11.90835000    16.26773000     7.01400500
--
1 1
C       15.93200000    19.25500000     9.52300000
C       15.76700000    17.97000000    10.32600000
N       14.65900000    20.02600000     9.44700000
H       16.70200000    19.87000000    10.00200000
H       16.28200000    19.00000000     8.51600000
H       15.09300000    17.28400000     9.80700000
H       15.34200000    18.21500000    11.30200000
H       14.34100000    20.31300000    10.36600000
H       14.76500000    20.86400000     8.88700000
H       13.91900000    19.47000000     9.02400000
H       16.74830000    17.49350000    10.46743000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ASP-018ARG-1')] = qcdb.Molecule("""
-1 1
C        0.84100000     6.98500000    27.42200000
C        1.58900000     5.83500000    28.07000000
O        1.64000000     4.74900000    27.48100000
O        2.11300000     6.00900000    29.18000000
H        1.37400000     7.92300000    27.58700000
H       -0.13300000     7.06300000    27.90900000
H        0.68136280     6.83330900    26.34427000
--
0 1
C        1.09800000     2.09200000    25.87400000
C        0.11300000     2.58700000    24.82200000
C        2.56300000     2.16400000    25.43400000
H        0.91700000     2.61200000    26.80600000
H        0.87900000     1.04000000    26.07100000
H        0.24700000     3.66100000    24.71500000
H        2.74300000     1.50400000    24.58600000
H        2.80900000     3.18800000    25.15100000
H       -0.91012010     2.36533700    25.15977000
H        0.33350820     2.11200400    23.85466000
H        3.23742000     1.84126200    26.24084000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ASP-018ARG-2')] = qcdb.Molecule("""
-1 1
C        0.84100000     6.98500000    27.42200000
C        1.58900000     5.83500000    28.07000000
O        1.64000000     4.74900000    27.48100000
O        2.11300000     6.00900000    29.18000000
H        1.37400000     7.92300000    27.58700000
H       -0.13300000     7.06300000    27.90900000
H        0.68136280     6.83330900    26.34427000
--
1 1
C        3.49500000     1.71800000    26.54900000
C        4.10700000     2.46000000    28.82700000
N        3.36200000     2.56200000    27.73900000
N        5.05000000     1.54100000    28.90400000
N        3.90300000     3.27300000    29.84300000
H        2.68400000     3.32700000    27.70400000
H        3.26300000     0.68200000    26.80600000
H        4.52000000     1.76600000    26.17500000
H        5.18100000     0.89500000    28.14500000
H        5.60900000     1.45500000    29.73700000
H        3.22700000     4.02100000    29.73300000
H        4.46400000     3.21400000    30.67500000
H        2.82058000     2.04073800    25.74216000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ASP-058ILE-1')] = qcdb.Molecule("""
-1 1
C        8.76500000    25.05000000    12.45700000
C       10.24600000    24.67900000    12.51100000
C        8.14100000    25.16700000    13.84000000
O        8.81600000    24.86500000    14.85000000
O        6.95200000    25.54200000    13.91400000
H        8.62700000    25.97600000    11.89500000
H        8.23400000    24.25500000    11.93700000
H       10.38200000    23.93400000    13.29600000
H       10.86682000    25.55718000    12.74202000
H       10.55383000    24.17462000    11.58318000
--
0 1
C        7.52600000    23.80400000     9.11400000
C        6.35200000    24.68300000     8.65200000
C        7.82300000    22.62600000     8.19400000
H        8.41700000    24.43100000     9.16200000
H        7.33200000    23.42700000    10.11200000
H        6.64600000    25.09700000     7.69600000
H        7.77000000    22.93300000     7.15000000
H        8.82300000    22.25000000     8.40800000
H        7.11800000    21.82000000     8.37500000
H        5.43993900    24.09101000     8.48559100
H        6.18032700    25.51910000     9.34587700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-012HIE-1')] = qcdb.Molecule("""
0 1
C       17.90600000    19.99100000    26.61800000
C       17.63700000    18.48000000    26.68100000
H       18.72700000    20.20000000    25.93000000
H       17.02000000    20.52800000    26.28200000
H       18.16900000    20.35800000    27.60500000
H       16.77200000    18.32800000    27.32900000
H       18.49258000    17.96608000    27.14346000
H       17.36660000    18.07118000    25.69624000
--
0 1
C       19.42300000    23.11600000    27.83900000
C       19.06900000    24.33900000    28.67700000
C       19.75800000    23.42000000    26.42200000
C       20.95200000    23.37000000    25.78000000
C       19.42400000    23.96400000    24.33300000
N       18.80700000    23.77100000    25.49400000
N       20.72300000    23.72800000    24.47700000
H       20.27200000    22.60200000    28.29000000
H       18.56900000    22.44500000    27.85100000
H       19.87500000    25.06900000    28.59600000
H       21.90400000    23.10500000    26.22500000
H       18.94200000    24.25000000    23.40600000
H       21.41500000    23.79200000    23.73800000
H       18.97074000    24.02170000    29.72565000
H       18.11522000    24.77904000    28.35040000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-015TYR-1')] = qcdb.Molecule("""
0 1
C       17.90600000    19.99100000    26.61800000
C       17.63700000    18.48000000    26.68100000
H       18.72700000    20.20000000    25.93000000
H       17.02000000    20.52800000    26.28200000
H       18.16900000    20.35800000    27.60500000
H       16.77200000    18.32800000    27.32900000
H       18.49258000    17.96608000    27.14346000
H       17.36660000    18.07118000    25.69624000
--
0 1
C       15.42100000    21.29700000    29.05100000
C       14.40600000    21.75300000    27.99700000
C       14.80900000    20.57000000    30.22200000
C       15.05200000    19.20400000    30.42200000
C       14.05300000    21.25100000    31.16600000
C       14.54600000    18.53600000    31.55300000
C       13.54400000    20.58500000    32.26900000
C       13.77000000    19.22800000    32.45800000
O       13.24200000    18.60200000    33.54800000
H       16.13900000    20.63700000    28.57500000
H       15.96400000    22.15700000    29.43800000
H       13.91200000    20.87200000    27.58500000
H       15.66000000    18.65900000    29.71300000
H       13.90800000    22.31800000    31.09800000
H       14.75500000    17.48600000    31.70000000
H       12.96800000    21.12700000    33.00600000
H       13.51600000    17.68200000    33.60900000
H       14.92032000    22.29602000    27.19040000
H       13.63708000    22.39823000    28.44693000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-032MET-1')] = qcdb.Molecule("""
0 1
C       32.11900000    -2.21800000    58.55100000
C       33.05500000    -3.40100000    58.79300000
H       31.10100000    -2.48000000    58.84000000
H       32.44700000    -1.38000000    59.15300000
H       32.14200000    -1.90600000    57.51000000
H       34.07200000    -3.12800000    58.50500000
H       32.72634000    -4.27433800    58.21054000
H       33.01793000    -3.64763200    59.86435000
--
0 1
C       32.78000000     0.40500000    56.00100000
C       34.91600000     1.98200000    56.51800000
S       33.52600000     1.91900000    55.38800000
H       32.26500000     0.57000000    56.94600000
H       32.04600000     0.06100000    55.27600000
H       33.53800000    -0.37300000    56.10000000
H       35.34800000     2.98300000    56.50500000
H       35.66900000     1.27300000    56.17900000
H       34.60774000     1.71363200    57.53925000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-033PHE-1')] = qcdb.Molecule("""
0 1
C       33.72900000    -2.77500000    61.22400000
C       33.00300000    -3.74700000    60.29600000
H       33.22100000    -1.81100000    61.24500000
H       33.74500000    -3.18700000    62.23300000
H       34.75500000    -2.63700000    60.88500000
H       31.96200000    -3.81600000    60.61400000
H       33.43300000    -4.72900000    60.46600000
H       33.04007000    -3.50036800    59.22465000
--
0 1
C       34.23800000     1.85000000    63.27100000
C       35.32200000    -0.40200000    63.60400000
C       35.28900000     0.82300000    62.93300000
C       36.28800000    -1.35000000    63.27300000
C       37.24200000    -1.07300000    62.28700000
C       36.22500000     1.07500000    61.91500000
C       37.21200000     0.14500000    61.60700000
H       34.60300000    -0.62400000    64.36700000
H       36.29900000    -2.30300000    63.78500000
H       34.68400000     2.84400000    63.28300000
H       33.88300000     1.64500000    64.28100000
H       37.99700000    -1.80900000    62.04100000
H       36.20400000     2.01900000    61.38700000
H       37.94900000     0.36200000    60.84500000
H       33.38682000     1.83490300    62.57439000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-034LEU-1')] = qcdb.Molecule("""
0 1
C        8.61300000     2.58400000    21.87500000
C        7.08800000     2.65500000    21.76900000
H        8.99600000     1.78300000    21.25600000
H        9.06200000     3.52200000    21.55200000
H        8.92500000     2.42700000    22.90800000
H        6.74100000     3.40000000    22.48400000
H        6.61835200     1.69016500    22.01092000
H        6.78211600     2.96518200    20.75894000
--
0 1
C        9.30100000    -0.23400000    19.32700000
C       10.21700000    -0.86900000    18.29200000
H        8.78900000    -1.00300000    19.90600000
H        9.92200000     0.35700000    19.99600000
H        8.57600000     0.42300000    18.84700000
H       10.64000000    -0.07800000    17.67400000
H        9.65314100    -1.56452200    17.65301000
H       11.05598000    -1.38131200    18.78560000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-035TRP-1')] = qcdb.Molecule("""
0 1
C       32.11900000    -2.21800000    58.55100000
C       33.05500000    -3.40100000    58.79300000
H       31.10100000    -2.48000000    58.84000000
H       32.44700000    -1.38000000    59.15300000
H       32.14200000    -1.90600000    57.51000000
H       34.07200000    -3.12800000    58.50500000
H       32.72634000    -4.27433800    58.21054000
H       33.01793000    -3.64763200    59.86435000
--
0 1
C       26.69900000     1.86600000    60.49100000
C       28.73800000    -0.36800000    58.27900000
C       27.51500000     0.01300000    58.88600000
C       27.74200000     1.18900000    59.65200000
C       29.06500000     1.47800000    59.51700000
C       28.84900000    -1.48100000    57.45600000
C       27.70300000    -2.23700000    57.23700000
C       26.38100000    -0.77700000    58.66800000
C       26.48600000    -1.89900000    57.84800000
N       29.66400000     0.55400000    58.68200000
H       30.67200000     0.47600000    58.58900000
H       29.78900000    -1.74900000    57.00200000
H       29.59200000     2.28500000    60.00500000
H       27.75600000    -3.11800000    56.61600000
H       25.45400000    -0.52900000    59.15600000
H       26.66200000     1.27300000    61.38700000
H       25.74300000     1.76700000    59.97600000
H       25.61800000    -2.52200000    57.68500000
H       26.87399000     2.91952500    60.75456000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-041TYR-1')] = qcdb.Molecule("""
0 1
C        6.95500000     4.54600000    20.02500000
C        6.66100000     3.08800000    20.35900000
H        8.02600000     4.72900000    19.98700000
H        6.53000000     4.78000000    19.04900000
H        6.50000000     5.19900000    20.77000000
H        7.15100000     2.45200000    19.61900000
H        5.58600000     2.94600000    20.24500000
H        6.96688400     2.77781800    21.36906000
--
0 1
C        6.39400000     7.97000000    18.41300000
C        5.82900000     8.85400000    17.28700000
C        6.69500000     8.70500000    19.71100000
C        5.69200000     8.92800000    20.65900000
C        7.98800000     9.15900000    19.98900000
C        5.97200000     9.59500000    21.85800000
C        8.27400000     9.82900000    21.18400000
C        7.26400000    10.04600000    22.12000000
O        7.53800000    10.70100000    23.28700000
H        5.67600000     7.17600000    18.62400000
H        7.30900000     7.49000000    18.06500000
H        4.87300000     9.26100000    17.61900000
H        4.68800000     8.57500000    20.46800000
H        8.77500000     9.00500000    19.26500000
H        5.20000000     9.74200000    22.59400000
H        9.27400000    10.18300000    21.38700000
H        6.75800000    10.79700000    23.84500000
H        5.66555600     8.25945500    16.37606000
H        6.49922500     9.70362200    17.08966000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-058PHE-1')] = qcdb.Molecule("""
0 1
C       33.72900000    -2.77500000    61.22400000
C       33.00300000    -3.74700000    60.29600000
H       33.22100000    -1.81100000    61.24500000
H       33.74500000    -3.18700000    62.23300000
H       34.75500000    -2.63700000    60.88500000
H       31.96200000    -3.81600000    60.61400000
H       33.43300000    -4.72900000    60.46600000
H       33.04007000    -3.50036800    59.22465000
--
0 1
C       31.86800000    -2.00700000    64.23200000
C       31.39400000    -1.62600000    65.63300000
C       30.75400000    -2.25400000    63.23600000
C       30.27400000    -1.21500000    62.42900000
C       30.21300000    -3.53800000    63.08400000
C       29.26000000    -1.42800000    61.50700000
C       29.21700000    -3.77700000    62.14900000
C       28.73700000    -2.71400000    61.33600000
H       32.50200000    -1.21200000    63.84000000
H       32.47600000    -2.91000000    64.30200000
H       30.71500000    -2.40100000    65.98100000
H       30.68700000    -0.22400000    62.53100000
H       30.58400000    -4.34900000    63.68600000
H       28.90600000    -0.61600000    60.92100000
H       28.85600000    -4.78300000    61.99800000
H       28.09300000    -2.88100000    60.49700000
H       30.86447000    -0.66185270    65.62848000
H       32.29948000    -1.55774400    66.25384000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008ILE-062TYR-1')] = qcdb.Molecule("""
0 1
C       33.00300000    -3.74700000    60.29600000
C       33.05500000    -3.40100000    58.79300000
C       33.72900000    -2.77500000    61.22400000
H       31.96200000    -3.81600000    60.61400000
H       33.43300000    -4.72900000    60.46600000
H       34.07200000    -3.12800000    58.50500000
H       33.22100000    -1.81100000    61.24500000
H       33.74500000    -3.18700000    62.23300000
H       34.75500000    -2.63700000    60.88500000
H       32.72634000    -4.27433800    58.21054000
H       32.38109000    -2.54924800    58.61876000
--
0 1
C       33.60100000    -6.03400000    64.70400000
C       32.21000000    -6.64100000    62.66700000
C       32.30100000    -6.44800000    64.04600000
C       31.00700000    -7.03200000    62.06500000
C       31.16900000    -6.66700000    64.82400000
C       29.89000000    -7.24500000    62.87100000
C       29.96900000    -7.06700000    64.25200000
O       28.68300000    -7.59300000    62.37700000
H       33.08200000    -6.47600000    62.04800000
H       30.92600000    -7.15300000    60.99700000
H       33.35700000    -5.24800000    65.41600000
H       34.26600000    -5.59600000    63.95800000
H       31.22000000    -6.52400000    65.89400000
H       29.11200000    -7.25100000    64.87000000
H       28.02700000    -7.66100000    63.07000000
H       34.11890000    -6.84640500    65.23483000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LEU-017ALA-1')] = qcdb.Molecule("""
0 1
C       37.65000000    12.83000000     4.62100000
C       38.41900000    13.47900000     5.75300000
H       38.31800000    12.62100000     3.78500000
H       37.21500000    11.89300000     4.97000000
H       36.84200000    13.48000000     4.28800000
H       37.74500000    13.68300000     6.58300000
H       38.90896000    14.40162000     5.40845100
H       39.20574000    12.79583000     6.10558100
--
0 1
C       36.22600000    11.04100000     1.92200000
C       34.82400000    10.66200000     2.44700000
H       36.23500000    11.01800000     0.83200000
H       36.48800000    12.04400000     2.25400000
H       36.96700000    10.33600000     2.30200000
H       34.88600000    10.57400000     3.53400000
H       34.53403000     9.68465500     2.03382600
H       34.12359000    11.47687000     2.21160900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LEU-088TYR-1')] = qcdb.Molecule("""
0 1
C        9.35200000     5.97700000    -4.02500000
C       10.68700000     5.83400000    -4.73500000
H        8.85500000     6.89200000    -4.34600000
H        8.71400000     5.12400000    -4.25400000
H        9.51400000     6.00600000    -2.94800000
H       11.14300000     4.91100000    -4.37800000
H       11.33880000     6.68342800    -4.48275900
H       10.54699000     5.75420400    -5.82313200
--
0 1
C        6.53200000     3.98100000     0.52800000
C        6.74000000     6.74600000    -2.05900000
C        6.39500000     5.57100000    -1.40200000
C        7.66100000     7.62000000    -1.48700000
C        6.97200000     5.23300000    -0.18300000
C        8.19200000     7.31900000    -0.24200000
C        7.86500000     6.12800000     0.40800000
O        8.02600000     8.77800000    -2.11900000
H        6.29500000     6.97800000    -3.01600000
H        5.67800000     4.90400000    -1.85700000
H        7.58600000     8.86800000    -2.97300000
H        8.83000000     8.04100000     0.22100000
H        7.17600000     3.79100000     1.38900000
H        6.62400000     3.13900000    -0.15900000
H        8.29000000     5.90800000     1.37900000
H        5.48906700     4.08227700     0.86271530
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LYS-043THR-1')] = qcdb.Molecule("""
1 1
C       16.14100000     2.25700000     1.13600000
N       16.05600000     1.64300000    -0.23400000
H       16.09500000     0.63000000    -0.19900000
H       15.17400000     1.88100000    -0.67800000
H       16.78800000     1.96800000    -0.85700000
H       15.29300000     1.90900000     1.73800000
H       16.04500000     3.34600000     1.05000000
H       17.06600000     2.04021400     1.69041500
--
0 1
C       18.12800000    -0.27900000    -2.98400000
O       17.07900000     0.66500000    -2.86700000
H       16.46500000     0.53000000    -3.60500000
H       17.76400000    -1.19800000    -3.44000000
H       18.94789000     0.15476010    -3.57529100
H       18.52954000    -0.50069060    -1.98419000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LYS-065VAL-1')] = qcdb.Molecule("""
0 1
C       20.13300000   -10.87300000    -0.84600000
C       19.43700000   -11.50900000    -2.05100000
C       21.63300000   -10.73800000    -1.05300000
H       19.71900000    -9.87400000    -0.69800000
H       19.93900000   -11.46900000     0.04700000
H       19.77200000   -12.54300000    -2.15200000
H       19.76400000   -10.96700000    -2.94100000
H       22.07700000   -11.73100000    -1.14700000
H       21.81500000   -10.18500000    -1.97600000
H       18.33799000   -11.47297000    -2.02145300
H       22.09246000   -10.20713000    -0.20620140
--
0 1
C       17.49100000   -10.04500000     1.78400000
C       17.54800000    -8.68200000     2.50700000
H       18.01400000   -10.81200000     2.35300000
H       16.45000000   -10.35300000     1.67600000
H       17.93300000    -9.95800000     0.79400000
H       17.08000000    -8.78100000     3.48300000
H       18.59373000    -8.36177700     2.62493900
H       16.97812000    -7.94222800     1.92564800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LYS-068GLU-1')] = qcdb.Molecule("""
0 1
C       21.63300000   -10.73800000    -1.05300000
C       20.13300000   -10.87300000    -0.84600000
C       22.27000000   -10.00200000     0.12100000
H       22.07700000   -11.73100000    -1.14700000
H       21.81500000   -10.18500000    -1.97600000
H       19.71900000    -9.87400000    -0.69800000
H       19.93900000   -11.46900000     0.04700000
H       21.73200000    -9.06200000     0.28400000
H       22.15700000   -10.61800000     1.01700000
H       19.63261000   -11.33025000    -1.71233300
H       23.33363000    -9.79015700    -0.06289158
--
-1 1
C       22.94600000    -5.48400000    -1.04000000
C       23.00600000    -6.57100000    -2.10700000
O       22.73200000    -7.74300000    -1.79400000
O       23.33600000    -6.26900000    -3.28000000
H       22.11800000    -4.83800000    -1.33300000
H       23.87300000    -4.90600000    -1.06900000
H       22.78038000    -5.83237900    -0.00985393
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008LYS-068GLU-2')] = qcdb.Molecule("""
1 1
C       22.27000000   -10.00200000     0.12100000
N       23.71600000    -9.71400000    -0.12900000
H       23.76400000    -9.04300000    -0.90000000
H       24.16200000    -9.29600000     0.67800000
H       24.23100000   -10.54700000    -0.38800000
H       21.73200000    -9.06200000     0.28400000
H       22.15700000   -10.61800000     1.01700000
H       21.81054000   -10.53287000    -0.72579860
--
-1 1
C       22.94600000    -5.48400000    -1.04000000
C       23.00600000    -6.57100000    -2.10700000
O       22.73200000    -7.74300000    -1.79400000
O       23.33600000    -6.26900000    -3.28000000
H       22.11800000    -4.83800000    -1.33300000
H       23.87300000    -4.90600000    -1.06900000
H       22.78038000    -5.83237900    -0.00985393
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008MET-158LEU-1')] = qcdb.Molecule("""
0 1
C        4.96400000    -0.34700000     4.10900000
C        4.62900000    -1.75500000     4.58700000
C        4.52100000     0.38400000     1.47500000
S        5.79800000    -0.31200000     2.51400000
H        4.08500000     0.26400000     4.06700000
H        5.65100000     0.07400000     4.83700000
H        4.23600000    -1.69800000     5.60300000
H        5.56100000    -2.31900000     4.62800000
H        4.25700000     1.37900000     1.83500000
H        4.88700000     0.45900000     0.45100000
H        3.63700000    -0.25400000     1.49500000
H        3.91540400    -2.30026800     3.95181300
--
0 1
C        5.71700000     2.54600000     5.73600000
C        5.66000000     3.70000000     6.73000000
H        6.48500000     2.73000000     4.98300000
H        5.96000000     1.63200000     6.27900000
H        4.75500000     2.43000000     5.23700000
H        4.92300000     3.46800000     7.49600000
H        5.36780700     4.62119900     6.20462900
H        6.64334300     3.83428900     7.20434400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PHE-042LEU-1')] = qcdb.Molecule("""
0 1
C      -15.48100000   -13.93500000   -17.04000000
C      -12.64000000   -11.76400000   -14.60300000
C      -12.23100000   -12.22600000   -15.83600000
C      -13.91200000   -12.02000000   -14.18900000
C      -13.14500000   -12.89800000   -16.63700000
C      -14.80100000   -12.75000000   -14.94900000
C      -14.46300000   -13.15900000   -16.20900000
H      -11.96000000   -11.21000000   -13.96900000
H      -11.22400000   -12.04100000   -16.18500000
H      -14.23700000   -11.66800000   -13.23100000
H      -12.80900000   -13.21400000   -17.61000000
H      -15.75900000   -13.01200000   -14.53700000
H      -16.47300000   -13.51200000   -16.87700000
H      -15.49400000   -14.96100000   -16.68200000
H      -15.26555000   -13.94076000   -18.11868000
--
0 1
C       -9.65300000   -13.14400000   -12.69400000
C       -8.90400000   -13.89200000   -11.59900000
H      -10.67000000   -12.91700000   -12.37600000
H       -9.13400000   -12.21400000   -12.92300000
H       -9.69100000   -13.74800000   -13.59500000
H       -7.87700000   -14.06700000   -11.92200000
H       -9.41520500   -14.85115000   -11.42957000
H       -8.90833600   -13.24807000   -10.70718000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PHE-044ILE-1')] = qcdb.Molecule("""
0 1
C      -15.48100000   -13.93500000   -17.04000000
C      -15.18200000   -13.94300000   -18.53700000
C      -14.46300000   -13.15900000   -16.20900000
C      -13.14500000   -12.89800000   -16.63700000
C      -14.80100000   -12.75000000   -14.94900000
C      -12.23100000   -12.22600000   -15.83600000
C      -13.91200000   -12.02000000   -14.18900000
C      -12.64000000   -11.76400000   -14.60300000
H      -16.47300000   -13.51200000   -16.87700000
H      -15.49400000   -14.96100000   -16.68200000
H      -14.18700000   -14.36700000   -18.67000000
H      -12.80900000   -13.21400000   -17.61000000
H      -15.75900000   -13.01200000   -14.53700000
H      -11.22400000   -12.04100000   -16.18500000
H      -14.23700000   -11.66800000   -13.23100000
H      -11.96000000   -11.21000000   -13.96900000
H      -15.19682000   -12.93400000   -18.97483000
H      -15.85320000   -14.65206000   -19.04368000
--
0 1
C      -14.75800000   -17.15000000   -15.13800000
C      -14.77000000   -17.90000000   -13.79400000
H      -14.01900000   -16.35000000   -15.14400000
H      -14.51400000   -17.84500000   -15.94000000
H      -15.74900000   -16.73400000   -15.31900000
H      -13.81600000   -18.40700000   -13.65300000
H      -15.55600000   -18.65100000   -13.85500000
H      -14.94940000   -17.22475000   -12.94438000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PHE-097VAL-1')] = qcdb.Molecule("""
0 1
C      -15.48100000   -13.93500000   -17.04000000
C      -14.80100000   -12.75000000   -14.94900000
C      -14.46300000   -13.15900000   -16.20900000
C      -13.91200000   -12.02000000   -14.18900000
C      -13.14500000   -12.89800000   -16.63700000
C      -12.64000000   -11.76400000   -14.60300000
C      -12.23100000   -12.22600000   -15.83600000
H      -15.75900000   -13.01200000   -14.53700000
H      -14.23700000   -11.66800000   -13.23100000
H      -16.47300000   -13.51200000   -16.87700000
H      -15.49400000   -14.96100000   -16.68200000
H      -12.80900000   -13.21400000   -17.61000000
H      -11.96000000   -11.21000000   -13.96900000
H      -11.22400000   -12.04100000   -16.18500000
H      -15.26555000   -13.94076000   -18.11868000
--
0 1
C      -15.46400000    -9.09900000   -16.01600000
C      -14.65400000    -7.99400000   -15.24000000
H      -15.91100000    -8.65800000   -16.90400000
H      -14.78100000    -9.89400000   -16.32100000
H      -16.23300000    -9.54300000   -15.38500000
H      -14.28600000    -8.44900000   -14.32000000
H      -15.30968000    -7.15251600   -14.97170000
H      -13.77223000    -7.64665900   -15.79843000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PHE-099HIE-1')] = qcdb.Molecule("""
0 1
C      -15.48100000   -13.93500000   -17.04000000
C      -14.80100000   -12.75000000   -14.94900000
C      -14.46300000   -13.15900000   -16.20900000
C      -13.91200000   -12.02000000   -14.18900000
C      -13.14500000   -12.89800000   -16.63700000
C      -12.64000000   -11.76400000   -14.60300000
C      -12.23100000   -12.22600000   -15.83600000
H      -15.75900000   -13.01200000   -14.53700000
H      -14.23700000   -11.66800000   -13.23100000
H      -16.47300000   -13.51200000   -16.87700000
H      -15.49400000   -14.96100000   -16.68200000
H      -12.80900000   -13.21400000   -17.61000000
H      -11.96000000   -11.21000000   -13.96900000
H      -11.22400000   -12.04100000   -16.18500000
H      -15.26555000   -13.94076000   -18.11868000
--
0 1
C      -18.47600000   -11.98700000   -14.53100000
C      -19.01700000   -11.21000000   -13.33300000
C      -18.73800000   -13.47200000   -14.49300000
C      -18.38600000   -14.45500000   -13.61700000
C      -19.50300000   -15.37700000   -15.28800000
N      -19.40500000   -14.06900000   -15.54400000
N      -18.89700000   -15.64500000   -14.12900000
H      -18.96000000   -11.59000000   -15.42200000
H      -17.41500000   -11.78900000   -14.64000000
H      -20.08100000   -11.40300000   -13.19700000
H      -17.80800000   -14.33200000   -12.71700000
H      -19.96000000   -16.11200000   -15.94000000
H      -18.78900000   -16.58200000   -13.73900000
H      -18.80936000   -10.13868000   -13.47143000
H      -18.45185000   -11.45013000   -12.42034000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PHE-101HIE-1')] = qcdb.Molecule("""
0 1
C      -15.48100000   -13.93500000   -17.04000000
C      -13.91200000   -12.02000000   -14.18900000
C      -12.64000000   -11.76400000   -14.60300000
C      -14.80100000   -12.75000000   -14.94900000
C      -14.46300000   -13.15900000   -16.20900000
C      -12.23100000   -12.22600000   -15.83600000
C      -13.14500000   -12.89800000   -16.63700000
H      -14.23700000   -11.66800000   -13.23100000
H      -11.96000000   -11.21000000   -13.96900000
H      -15.75900000   -13.01200000   -14.53700000
H      -11.22400000   -12.04100000   -16.18500000
H      -16.47300000   -13.51200000   -16.87700000
H      -15.49400000   -14.96100000   -16.68200000
H      -12.80900000   -13.21400000   -17.61000000
H      -15.26555000   -13.94076000   -18.11868000
--
0 1
C      -13.58500000   -12.81900000   -10.56800000
C      -14.50400000   -13.36300000    -9.45100000
C      -13.48300000   -11.33300000   -10.68000000
C      -12.39700000   -10.50300000   -10.61100000
C      -14.12200000    -9.28800000   -11.20800000
N      -14.53800000   -10.55500000   -11.07600000
N      -12.82600000    -9.21900000   -10.91000000
H      -12.58600000   -13.23900000   -10.44700000
H      -13.97600000   -13.17600000   -11.51800000
H      -14.66500000   -14.42200000    -9.64800000
H      -11.38300000   -10.81000000   -10.38900000
H      -14.73900000    -8.45500000   -11.51300000
H      -12.24900000    -8.38700000   -10.96900000
H      -15.48446000   -12.86863000    -9.38543500
H      -14.00945000   -13.29893000    -8.47053400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008PRO-183ASP-1')] = qcdb.Molecule("""
0 1
C       37.99500000     5.33500000    24.00200000
C       39.10900000     4.52700000    23.37900000
C       39.86100000     6.82700000    23.57800000
C       36.64700000     7.53300000    25.57500000
C       38.04200000     7.65700000    24.99800000
O       38.66300000     8.71100000    25.20600000
N       38.55800000     6.66800000    24.23600000
H       37.16000000     5.40200000    23.30400000
H       37.67600000     4.87500000    24.93500000
H       38.72800000     3.78200000    22.67900000
H       39.70100000     4.05400000    24.16300000
H       40.65000000     6.79100000    24.33100000
H       36.51900000     6.50500000    25.91300000
H       39.71248000     5.29533300    22.87356000
H       39.91769000     5.93575700    22.93576000
H       39.90771000     7.76843900    23.01098000
H       36.51729000     8.22705400    26.41848000
H       35.91749000     7.74798500    24.78027000
--
-1 1
C       34.36300000     2.27500000    25.18000000
C       35.86300000     2.36500000    25.12800000
O       36.51500000     1.85700000    24.18800000
O       36.42800000     2.94200000    26.07900000
H       33.98200000     3.29400000    25.21900000
H       34.08700000     1.80100000    26.12200000
H       33.87816000     1.72171500    24.36219000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008SER-032SER-1')] = qcdb.Molecule("""
0 1
C       42.54800000    29.06800000     1.61900000
O       43.25600000    28.86600000     0.40500000
H       42.86500000    29.45700000    -0.25700000
H       41.50100000    28.78700000     1.50000000
H       42.60000000    30.12600000     1.88500000
H       43.01833000    28.47937000     2.42043600
--
0 1
C       44.32400000    26.20400000    -1.53300000
O       43.08800000    26.52900000    -0.94000000
H       43.20100000    27.36100000    -0.44800000
H       45.10200000    26.83200000    -1.09800000
H       44.27700000    26.39200000    -2.60800000
H       44.57411000    25.14823000    -1.35188800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008SER-093TYR-1')] = qcdb.Molecule("""
0 1
C       -4.93900000   -13.80100000    -4.41600000
C       -3.78600000   -13.99300000    -3.44200000
O       -4.85700000   -12.48900000    -4.97000000
H       -4.89400000   -14.54900000    -5.20900000
H       -5.88200000   -13.91300000    -3.87900000
H       -3.88700000   -14.95300000    -2.93700000
H       -5.71800000   -12.28100000    -5.35300000
H       -3.83947600   -13.15923000    -2.72648000
H       -2.87152600   -13.99011000    -4.05333400
--
0 1
C       -6.13900000   -12.36500000    -7.77800000
C       -6.79400000   -11.48300000    -8.83300000
C       -7.06700000   -13.33900000    -7.09700000
C       -7.13400000   -14.67500000    -7.49700000
C       -7.87000000   -12.91600000    -6.04000000
C       -7.99500000   -15.57500000    -6.84400000
C       -8.73100000   -13.80900000    -5.38900000
C       -8.78300000   -15.13500000    -5.78700000
O       -9.63000000   -15.99000000    -5.14200000
H       -5.32500000   -12.92500000    -8.22400000
H       -5.71200000   -11.68800000    -7.04500000
H       -7.55800000   -10.86700000    -8.35400000
H       -6.51900000   -15.02200000    -8.31800000
H       -7.86100000   -11.87700000    -5.73100000
H       -8.04000000   -16.60600000    -7.16400000
H       -9.35900000   -13.47100000    -4.57700000
H       -9.55900000   -16.88700000    -5.48300000
H       -7.23983000   -12.10565000    -9.62264700
H       -6.02666300   -10.82300000    -9.26381100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008TRP-035PHE-1')] = qcdb.Molecule("""
0 1
C       27.78400000    24.00200000    25.17000000
C       26.18200000    22.25300000    26.25800000
C       27.47100000    22.82900000    26.02700000
C       26.36400000    21.13500000    27.11100000
C       28.35700000    22.07900000    26.73100000
C       24.89700000    22.53100000    25.78300000
C       25.29100000    20.34700000    27.53700000
C       23.83200000    21.74200000    26.19100000
C       24.02800000    20.66700000    27.07000000
N       27.70300000    21.07000000    27.39800000
H       24.76600000    23.32200000    25.07500000
H       27.25500000    23.90000000    24.22300000
H       28.85200000    23.97700000    24.94800000
H       29.43000000    22.23500000    26.74900000
H       28.16500000    20.27500000    27.84600000
H       25.45200000    19.50800000    28.20000000
H       22.83400000    21.95800000    25.83400000
H       23.17800000    20.06900000    27.37300000
H       27.53880000    24.97561000    25.61941000
--
0 1
C       23.03100000    19.14100000    21.70900000
C       26.22800000    20.95700000    22.67300000
C       27.00200000    20.75900000    21.52900000
C       24.92400000    20.44700000    22.73300000
C       24.40800000    19.72400000    21.65100000
C       26.49200000    20.04000000    20.45900000
C       25.19800000    19.53000000    20.51600000
H       26.63500000    21.50500000    23.51100000
H       28.01100000    21.14700000    21.48800000
H       24.33400000    20.59000000    23.62700000
H       27.11000000    19.85300000    19.59200000
H       22.86300000    18.75900000    22.71800000
H       22.97300000    18.29000000    21.03100000
H       24.81600000    18.95000000    19.68800000
H       22.22671000    19.84556000    21.45071000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008TRP-250PHE-1')] = qcdb.Molecule("""
0 1
C       27.78400000    24.00200000    25.17000000
C       28.35700000    22.07900000    26.73100000
C       27.47100000    22.82900000    26.02700000
C       26.36400000    21.13500000    27.11100000
C       26.18200000    22.25300000    26.25800000
C       25.29100000    20.34700000    27.53700000
C       24.89700000    22.53100000    25.78300000
C       24.02800000    20.66700000    27.07000000
C       23.83200000    21.74200000    26.19100000
N       27.70300000    21.07000000    27.39800000
H       29.43000000    22.23500000    26.74900000
H       28.16500000    20.27500000    27.84600000
H       27.25500000    23.90000000    24.22300000
H       28.85200000    23.97700000    24.94800000
H       25.45200000    19.50800000    28.20000000
H       24.76600000    23.32200000    25.07500000
H       23.17800000    20.06900000    27.37300000
H       22.83400000    21.95800000    25.83400000
H       27.53880000    24.97561000    25.61941000
--
0 1
C       32.58900000    22.77700000    24.10700000
C       29.76300000    20.25800000    24.24600000
C       30.47300000    21.42300000    23.97700000
C       30.36400000    19.23800000    24.98400000
C       31.78700000    21.54800000    24.42400000
C       31.66400000    19.34800000    25.40000000
C       32.36200000    20.51300000    25.14700000
H       28.74200000    20.15000000    23.90900000
H       30.00900000    22.21600000    23.40700000
H       29.80500000    18.33900000    25.20500000
H       32.12700000    18.54300000    25.95400000
H       32.37800000    23.06000000    23.07400000
H       33.65600000    22.55700000    24.16600000
H       33.37700000    20.60600000    25.51000000
H       32.34866000    23.63289000    24.75484000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008TRP-252GLU-1')] = qcdb.Molecule("""
0 1
C       27.78400000    24.00200000    25.17000000
C       28.35700000    22.07900000    26.73100000
C       26.36400000    21.13500000    27.11100000
C       27.47100000    22.82900000    26.02700000
C       26.18200000    22.25300000    26.25800000
C       25.29100000    20.34700000    27.53700000
C       24.02800000    20.66700000    27.07000000
C       24.89700000    22.53100000    25.78300000
C       23.83200000    21.74200000    26.19100000
N       27.70300000    21.07000000    27.39800000
H       28.16500000    20.27500000    27.84600000
H       29.43000000    22.23500000    26.74900000
H       25.45200000    19.50800000    28.20000000
H       27.25500000    23.90000000    24.22300000
H       28.85200000    23.97700000    24.94800000
H       23.17800000    20.06900000    27.37300000
H       24.76600000    23.32200000    25.07500000
H       22.83400000    21.95800000    25.83400000
H       27.53880000    24.97561000    25.61941000
--
-1 1
C       30.65800000    18.41500000    29.40600000
C       29.75600000    17.88900000    28.31400000
O       28.61600000    18.39600000    28.18900000
O       30.18600000    16.93000000    27.63800000
H       31.45700000    17.70400000    29.62600000
H       30.07000000    18.54200000    30.31800000
H       31.10090000    19.38453000    29.13424000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008TYR-052TYR-1')] = qcdb.Molecule("""
0 1
C       -7.23900000    -5.08000000    -1.56100000
C       -6.00300000    -4.65700000    -0.75700000
C       -7.12900000    -6.41300000    -2.26700000
C       -6.23200000    -6.58000000    -3.32100000
C       -7.92300000    -7.49800000    -1.87900000
C       -6.11800000    -7.80400000    -3.97400000
C       -7.82400000    -8.72700000    -2.53500000
C       -6.92300000    -8.87600000    -3.58800000
O       -6.81400000   -10.07100000    -4.23800000
H       -8.10500000    -5.11500000    -0.90800000
H       -7.44600000    -4.30900000    -2.30500000
H       -5.28600000    -4.18800000    -1.43200000
H       -5.60900000    -5.75000000    -3.63100000
H       -8.63100000    -7.38400000    -1.06900000
H       -5.41400000    -7.91800000    -4.78600000
H       -8.44000000    -9.56200000    -2.23400000
H       -6.15900000   -10.03600000    -4.94600000
H       -5.54618300    -5.52080000    -0.25185840
H       -6.30955600    -3.92648200     0.00612992
--
0 1
C       -9.23400000    -7.40300000     2.80100000
C       -9.88100000    -5.60400000     1.17200000
C      -10.26500000    -6.62600000     2.03100000
C      -10.83200000    -4.90000000     0.44300000
C      -12.18000000    -5.22000000     0.57900000
C      -11.61400000    -6.93400000     2.15000000
C      -12.57300000    -6.23900000     1.43200000
O      -13.12500000    -4.53300000    -0.12000000
H       -8.83900000    -5.34400000     1.09500000
H      -10.52800000    -4.10500000    -0.22100000
H       -9.58900000    -7.58200000     3.81500000
H       -8.34400000    -6.77700000     2.88500000
H      -11.89600000    -7.73200000     2.81000000
H      -12.73100000    -3.85700000    -0.68400000
H      -13.62100000    -6.48400000     1.52900000
H       -8.97049500    -8.35865400     2.32425000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008VAL-039TRP-1')] = qcdb.Molecule("""
0 1
C        2.94400000    -5.42200000    10.86100000
C        2.58200000    -6.14600000    12.16100000
H        3.95800000    -5.67600000    10.55600000
H        2.25900000    -5.71800000    10.06700000
H        2.87600000    -4.34200000    10.98100000
H        1.65600000    -5.72300000    12.54800000
H        3.37844800    -6.01684600    12.90866000
H        2.41035600    -7.21697300    11.97782000
--
0 1
C        5.08800000   -11.20600000     5.43800000
C        5.69600000    -9.75600000     7.49900000
C        5.98700000   -10.76700000     6.53100000
C        6.82100000    -9.65200000     8.35300000
C        7.23700000   -11.22400000     6.81000000
C        4.63500000    -8.02500000     8.79200000
C        5.76700000    -7.94700000     9.62300000
C        4.59400000    -8.92000000     7.72600000
C        6.87000000    -8.75200000     9.40700000
N        7.73700000   -10.56900000     7.90900000
H        3.78400000    -7.38500000     8.97500000
H        5.77500000    -7.24700000    10.44700000
H        3.72500000    -8.98400000     7.08900000
H        7.74300000    -8.70200000    10.03500000
H        5.68600000   -11.53800000     4.59100000
H        4.49800000   -10.34800000     5.11100000
H        7.75100000   -12.00500000     6.26100000
H        8.66500000   -10.74400000     8.29300000
H        4.40763100   -12.01376000     5.74561400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008VAL-041VAL-1')] = qcdb.Molecule("""
0 1
C      -10.98400000    26.40000000    -7.75900000
C      -11.42000000    26.71200000    -9.19600000
H      -10.22800000    25.61700000    -7.75600000
H      -10.55800000    27.30000000    -7.31500000
H      -11.83600000    26.09400000    -7.15000000
H      -12.03800000    27.60800000    -9.15600000
H      -12.02499000    25.90087000    -9.62733200
H      -10.55322000    26.96242000    -9.82527500
--
0 1
C       -7.32900000    26.76100000    -6.60300000
C       -6.25300000    27.83400000    -6.77700000
H       -7.25900000    26.27900000    -5.63100000
H       -8.31000000    27.22600000    -6.68600000
H       -7.23100000    26.00200000    -7.37700000
H       -6.46700000    28.65700000    -6.09400000
H       -5.25910000    27.42445000    -6.54368700
H       -6.28686100    28.21800000    -7.80724200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008VAL-066LEU-1')] = qcdb.Molecule("""
0 1
C        2.34400000    -7.63100000    11.90700000
C        2.58200000    -6.14600000    12.16100000
H        1.99200000    -8.12400000    12.81300000
H        1.58600000    -7.75800000    11.13300000
H        3.27500000    -8.09000000    11.57900000
H        1.65600000    -5.72300000    12.54800000
H        3.37844800    -6.01684600    12.90866000
H        2.84202200    -5.62595700    11.22722000
--
0 1
C        3.24400000   -10.86200000    11.02700000
C        2.36400000   -11.80700000    10.20000000
C        4.43300000   -11.55000000    11.73600000
H        3.62100000   -10.07500000    10.37600000
H        2.62000000   -10.40800000    11.79800000
H        2.91500000   -12.13300000     9.32000000
H        4.06500000   -12.36800000    12.35200000
H        1.43113300   -11.30340000     9.90648800
H        2.09622900   -12.67944000    10.81413000
H        5.14460500   -11.96516000    11.00713000
H        4.95383300   -10.85916000    12.41532000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008VAL-072SER-1')] = qcdb.Molecule("""
0 1
C       15.15400000    63.66700000     4.25000000
C       14.74500000    64.97500000     4.95100000
H       14.30300000    62.98600000     4.21000000
H       15.47800000    63.85200000     3.24100000
H       15.98800000    63.19000000     4.75900000
H       15.60300000    65.64300000     4.94300000
H       14.43434000    64.77570000     5.98722900
H       13.93036000    65.44247000     4.37843400
--
0 1
C       16.22400000    65.55100000     1.27300000
C       15.98300000    65.88800000    -0.20200000
O       17.57600000    65.22500000     1.55200000
H       15.93600000    66.41000000     1.88200000
H       15.56900000    64.71700000     1.49600000
H       15.00000000    66.35600000    -0.26900000
H       17.65600000    64.94000000     2.46900000
H       15.95888000    64.97436000    -0.81410940
H       16.71665000    66.62310000    -0.56448320
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '008VAL-080PHE-1')] = qcdb.Molecule("""
0 1
C        2.94400000    -5.42200000    10.86100000
C        2.58200000    -6.14600000    12.16100000
H        3.95800000    -5.67600000    10.55600000
H        2.25900000    -5.71800000    10.06700000
H        2.87600000    -4.34200000    10.98100000
H        1.65600000    -5.72300000    12.54800000
H        3.37844800    -6.01684600    12.90866000
H        2.41035600    -7.21697300    11.97782000
--
0 1
C       -0.23800000    -4.31500000    10.21400000
C       -1.76400000    -4.40600000    10.35200000
C        0.30000000    -2.90700000    10.18400000
C        0.15700000    -2.11600000     9.04600000
C        0.96800000    -2.38300000    11.27900000
C        0.65700000    -0.81800000     9.01800000
C        1.46900000    -1.08800000    11.25100000
C        1.30600000    -0.30100000    10.12500000
H        0.19200000    -4.83400000    11.06800000
H        0.08700000    -4.83900000     9.31700000
H       -2.09400000    -3.85200000    11.23300000
H       -0.31600000    -2.51100000     8.15900000
H        1.12400000    -2.98900000    12.16000000
H        0.52700000    -0.21200000     8.13500000
H        1.98600000    -0.69100000    12.11200000
H        1.67100000     0.71300000    10.11600000
H       -2.06622500    -5.46190400    10.41305000
H       -2.23114400    -3.98760800     9.44827200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ALA-084LEU-1')] = qcdb.Molecule("""
0 1
C       24.53900000    -1.57300000    31.78900000
C       25.62400000    -2.37800000    32.50900000
H       24.43500000    -1.93100000    30.76300000
H       23.58500000    -1.67200000    32.30900000
H       24.81200000    -0.51900000    31.75600000
H       25.64600000    -2.09700000    33.56400000
H       26.57216000    -2.12281400    32.01314000
H       25.40675000    -3.45480400    32.45160000
--
0 1
C       21.79700000    -0.15300000    29.80700000
C       20.81500000    -1.31100000    29.88800000
H       22.61800000    -0.31000000    30.49800000
H       22.19000000    -0.07600000    28.79200000
H       21.32000000     0.78500000    30.06700000
H       20.03800000    -1.13000000    29.14800000
H       20.35938000    -1.34784700    30.88853000
H       21.32994000    -2.24568200    29.62115000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ALA-091ILE-1')] = qcdb.Molecule("""
0 1
C       24.53900000    -1.57300000    31.78900000
C       25.62400000    -2.37800000    32.50900000
H       24.43500000    -1.93100000    30.76300000
H       23.58500000    -1.67200000    32.30900000
H       24.81200000    -0.51900000    31.75600000
H       25.64600000    -2.09700000    33.56400000
H       26.57216000    -2.12281400    32.01314000
H       25.40675000    -3.45480400    32.45160000
--
0 1
C       23.38100000     1.77100000    33.04600000
C       23.95100000     2.97700000    33.80500000
H       23.35700000     1.95200000    31.97400000
H       24.02200000     0.91600000    33.24300000
H       22.37800000     1.53300000    33.40200000
H       24.88200000     3.30500000    33.34100000
H       24.16400000     2.64500000    34.82000000
H       23.21298000     3.79267100    33.80286000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-023GLU-1')] = qcdb.Molecule("""
1 1
C       -6.84000000    17.85800000    16.96600000
C       -7.79300000    15.84100000    18.05000000
N       -7.07700000    16.41900000    17.10100000
N       -8.41100000    16.56700000    18.96000000
N       -7.91200000    14.52800000    18.06300000
H       -6.55100000    15.79700000    16.48700000
H       -6.08600000    18.17400000    17.69000000
H       -7.76200000    18.41900000    17.13100000
H       -8.33300000    17.56800000    18.93000000
H       -8.97900000    16.12600000    19.66400000
H       -7.41300000    13.98300000    17.37700000
H       -8.46900000    14.07000000    18.76500000
H       -6.48245800    18.06802000    15.94715000
--
-1 1
C       -5.69800000    14.00000000    13.42900000
C       -4.86700000    14.09900000    14.70900000
O       -5.33000000    14.68700000    15.70700000
O       -3.76100000    13.53000000    14.74600000
H       -6.25000000    13.05800000    13.42400000
H       -5.01000000    13.97400000    12.58200000
H       -6.41646100    14.82397000    13.30698000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-031TRP-1')] = qcdb.Molecule("""
1 1
C       -6.84000000    17.85800000    16.96600000
C       -6.34800000    18.14700000    15.56400000
C       -7.79300000    15.84100000    18.05000000
N       -7.07700000    16.41900000    17.10100000
N       -8.41100000    16.56700000    18.96000000
N       -7.91200000    14.52800000    18.06300000
H       -6.08600000    18.17400000    17.69000000
H       -7.76200000    18.41900000    17.13100000
H       -7.14100000    17.89600000    14.86000000
H       -5.49300000    17.50100000    15.37500000
H       -6.55100000    15.79700000    16.48700000
H       -8.33300000    17.56800000    18.93000000
H       -8.97900000    16.12600000    19.66400000
H       -7.41300000    13.98300000    17.37700000
H       -8.46900000    14.07000000    18.76500000
H       -6.05022800    19.19750000    15.43062000
--
0 1
C      -10.77500000    13.99900000    15.43600000
C      -10.95600000    17.39600000    16.98700000
C      -10.61800000    16.55900000    15.89500000
C      -10.92700000    15.21200000    16.27500000
C      -11.48000000    15.28000000    17.51600000
C      -10.21000000    19.32000000    15.82000000
C      -10.77200000    18.77100000    16.95600000
C       -9.89000000    18.52000000    14.71800000
C      -10.08300000    17.14400000    14.74400000
N      -11.49500000    16.58500000    17.95100000
H      -10.03300000    20.38700000    15.77000000
H      -11.03100000    19.38300000    17.80800000
H       -9.46600000    18.97700000    13.84300000
H       -9.81600000    16.53100000    13.89800000
H      -11.87700000    16.88500000    18.84200000
H      -11.85500000    14.42900000    18.07700000
H      -10.67500000    13.12600000    16.08400000
H       -9.85600000    14.09200000    14.85400000
H      -11.62429000    13.85553000    14.75181000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-092LEU-1')] = qcdb.Molecule("""
1 1
C       30.72200000    -5.45600000   -15.49500000
C       30.45400000    -4.63300000   -13.16600000
N       30.90300000    -5.55700000   -14.02400000
N       29.82400000    -3.57000000   -13.61200000
N       30.60000000    -4.76100000   -11.86400000
H       31.42100000    -6.34100000   -13.65300000
H       29.73100000    -3.42400000   -14.60200000
H       29.48000000    -2.87300000   -12.97100000
H       31.06600000    -5.56900000   -11.48600000
H       30.25700000    -4.05000000   -11.23800000
H       31.49400000    -4.78800000   -15.88300000
H       29.75100000    -5.01900000   -15.73600000
H       30.80308000    -6.40693400   -16.04195000
--
0 1
C       28.03200000    -7.05600000   -12.23800000
C       26.63400000    -7.70600000   -12.42200000
H       28.76700000    -7.81700000   -11.97300000
H       28.32700000    -6.58300000   -13.17300000
H       27.99200000    -6.30100000   -11.45200000
H       26.72300000    -8.49200000   -13.17100000
H       26.35839000    -8.15791100   -11.45773000
H       25.86156000    -6.99605400   -12.75263000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-103GLN-1')] = qcdb.Molecule("""
1 1
C       22.24900000    -3.95600000     1.85000000
C       22.03100000    -1.91600000     0.46800000
N       22.48900000    -1.15600000    -0.50600000
N       22.66400000    -3.03200000     0.78900000
N       20.94200000    -1.55800000     1.11600000
H       23.28900000    -1.49800000    -1.02700000
H       22.00100000    -0.31500000    -0.77400000
H       23.42900000    -3.30900000     0.17300000
H       20.49600000    -2.20100000     1.75800000
H       20.46000000    -0.67800000     0.91600000
H       21.89800000    -4.88100000     1.38600000
H       21.44300000    -3.55700000     2.46500000
H       23.09190000    -4.19122700     2.51647700
--
0 1
C       20.47200000    -3.51400000    -4.98900000
C       21.86200000    -3.47900000    -4.39000000
O       22.77100000    -4.18400000    -4.82900000
N       22.04600000    -2.65000000    -3.38200000
H       22.89500000    -2.79800000    -2.84400000
H       21.24300000    -2.16400000    -2.99300000
H       20.29300000    -2.52200000    -5.40000000
H       19.74800000    -3.70100000    -4.19400000
H       20.36287000    -4.28438200    -5.76656200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-106ASP-1')] = qcdb.Molecule("""
1 1
C       22.24900000    -3.95600000     1.85000000
C       22.03100000    -1.91600000     0.46800000
N       20.94200000    -1.55800000     1.11600000
N       22.66400000    -3.03200000     0.78900000
N       22.48900000    -1.15600000    -0.50600000
H       20.49600000    -2.20100000     1.75800000
H       20.46000000    -0.67800000     0.91600000
H       23.42900000    -3.30900000     0.17300000
H       23.28900000    -1.49800000    -1.02700000
H       22.00100000    -0.31500000    -0.77400000
H       21.89800000    -4.88100000     1.38600000
H       21.44300000    -3.55700000     2.46500000
H       23.09190000    -4.19122700     2.51647700
--
-1 1
C       17.13800000    -0.68000000     0.95100000
C       18.01800000     0.42300000     1.53000000
O       19.19200000     0.57900000     1.12400000
O       17.52400000     1.13800000     2.42700000
H       16.15100000    -0.27200000     0.72600000
H       17.01500000    -1.45100000     1.71200000
H       17.55015000    -1.13092200     0.03623089
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-128ARG-1')] = qcdb.Molecule("""
1 1
C       22.24900000    -3.95600000     1.85000000
C       22.03100000    -1.91600000     0.46800000
N       22.66400000    -3.03200000     0.78900000
N       20.94200000    -1.55800000     1.11600000
N       22.48900000    -1.15600000    -0.50600000
H       23.42900000    -3.30900000     0.17300000
H       20.49600000    -2.20100000     1.75800000
H       20.46000000    -0.67800000     0.91600000
H       23.28900000    -1.49800000    -1.02700000
H       22.00100000    -0.31500000    -0.77400000
H       21.89800000    -4.88100000     1.38600000
H       21.44300000    -3.55700000     2.46500000
H       23.09190000    -4.19122700     2.51647700
--
0 1
C       23.93800000     0.48800000     2.47800000
C       23.99000000     0.48800000     3.99100000
C       24.99900000     1.39700000     1.87000000
H       24.08400000    -0.53300000     2.13200000
H       22.95200000     0.81900000     2.15100000
H       23.61900000     1.43900000     4.37700000
H       25.03200000     0.37800000     4.29800000
H       24.78900000     2.42800000     2.16300000
H       25.98900000     1.13800000     2.25100000
H       23.41523000    -0.34900160     4.41417100
H       24.97347000     1.31966300     0.77301900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ARG-128ARG-2')] = qcdb.Molecule("""
1 1
C       22.24900000    -3.95600000     1.85000000
C       22.03100000    -1.91600000     0.46800000
N       22.48900000    -1.15600000    -0.50600000
N       22.66400000    -3.03200000     0.78900000
N       20.94200000    -1.55800000     1.11600000
H       23.28900000    -1.49800000    -1.02700000
H       22.00100000    -0.31500000    -0.77400000
H       23.42900000    -3.30900000     0.17300000
H       20.49600000    -2.20100000     1.75800000
H       20.46000000    -0.67800000     0.91600000
H       21.89800000    -4.88100000     1.38600000
H       21.44300000    -3.55700000     2.46500000
H       23.09190000    -4.19122700     2.51647700
--
1 1
C       24.99900000     1.39700000     1.87000000
C       25.42800000     0.25700000    -0.27700000
N       24.96500000     1.29400000     0.40900000
N       25.34500000     0.24400000    -1.59200000
N       25.96700000    -0.77600000     0.34700000
H       24.58500000     2.07500000    -0.10800000
H       24.99500000     1.04900000    -2.09100000
H       25.76800000    -0.51400000    -2.10800000
H       26.12800000    -0.74800000     1.33700000
H       26.23900000    -1.60600000    -0.18800000
H       24.78900000     2.42800000     2.16300000
H       25.98900000     1.13800000     2.25100000
H       24.23304000     0.74076910     2.30893100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ASN-024ARG-1')] = qcdb.Molecule("""
0 1
C       12.66500000    14.40600000    12.90800000
C       11.34900000    15.11900000    12.62100000
O       10.92300000    15.28400000    11.49200000
N       10.61600000    15.55800000    13.61400000
H        9.75000000    16.02600000    13.37300000
H       10.91800000    15.40200000    14.55300000
H       13.35300000    15.12400000    13.35600000
H       13.09000000    14.04500000    11.97300000
H       12.50763000    13.56121000    13.59471000
--
1 1
C       11.90200000    16.85000000    16.60900000
C       10.63100000    14.91600000    17.55000000
N       10.04300000    14.60300000    16.39700000
N       11.49200000    15.94100000    17.68900000
N       10.32000000    14.17500000    18.59700000
H        9.61100000    15.39300000    15.93600000
H        9.48900000    13.75900000    16.36300000
H       11.83900000    16.13300000    18.62400000
H       10.68700000    14.43000000    19.50400000
H        9.61500000    13.45700000    18.54200000
H       11.53700000    17.85100000    16.85200000
H       11.47000000    16.57500000    15.65800000
H       12.99639000    16.89494000    16.50753000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ASP-021LYS-1')] = qcdb.Molecule("""
-1 1
C       -6.91100000     0.03800000     0.19000000
C       -5.52800000     0.60800000    -0.10600000
O       -4.49800000     0.03900000     0.31800000
O       -5.48100000     1.66700000    -0.77100000
H       -7.48100000    -0.03100000    -0.73900000
H       -7.42800000     0.73700000     0.85000000
H       -6.89374100    -0.94789670     0.67755500
--
0 1
C       -4.27700000     2.39800000     2.95500000
C       -3.25800000     1.92300000     3.98800000
C       -4.76000000     3.81200000     3.26800000
H       -3.81300000     2.40400000     1.96700000
H       -5.14200000     1.73400000     2.93000000
H       -3.71600000     1.84800000     4.97400000
H       -2.44500000     2.64900000     4.04200000
H       -3.90000000     4.49000000     3.24800000
H       -5.44300000     4.12600000     2.47100000
H       -2.83051700     0.94724040     3.71386100
H       -5.26626100     3.87038600     4.24282900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009GLN-068ILE-1')] = qcdb.Molecule("""
0 1
C       36.01400000    14.79900000     2.27400000
C       36.15000000    13.33400000     2.62200000
O       35.98800000    12.45200000     1.78200000
N       36.46600000    13.06700000     3.87900000
H       37.02100000    15.18700000     2.12100000
H       35.57000000    15.31400000     3.12800000
H       36.67100000    12.11900000     4.14000000
H       36.70100000    13.82600000     4.51500000
H       35.39032000    14.98625000     1.38745400
--
0 1
C       32.45300000    12.59900000     2.76400000
C       31.43500000    13.14500000     3.76800000
H       32.02400000    11.76400000     2.20600000
H       32.74600000    13.36300000     2.05800000
H       33.35800000    12.26600000     3.27400000
H       31.93700000    13.86400000     4.41900000
H       31.03034000    12.32145000     4.37464000
H       30.62021000    13.65523000     3.23340800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009GLN-072ASN-1')] = qcdb.Molecule("""
0 1
C       36.01400000    14.79900000     2.27400000
C       36.15000000    13.33400000     2.62200000
O       35.98800000    12.45200000     1.78200000
N       36.46600000    13.06700000     3.87900000
H       37.02100000    15.18700000     2.12100000
H       35.57000000    15.31400000     3.12800000
H       36.67100000    12.11900000     4.14000000
H       36.70100000    13.82600000     4.51500000
H       35.39032000    14.98625000     1.38745400
--
0 1
C       34.95700000     7.70400000     3.67700000
C       34.58700000     8.71800000     2.61600000
O       33.81900000     8.43000000     1.70100000
N       35.15600000     9.90300000     2.71800000
H       34.98700000    10.61200000     2.01500000
H       35.82500000    10.06500000     3.44800000
H       35.10000000     8.21100000     4.63300000
H       35.90700000     7.25200000     3.38800000
H       34.19461000     6.91933200     3.79125100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-013TYR-1')] = qcdb.Molecule("""
0 1
C      -26.05800000    19.91100000   -11.54200000
C      -26.03500000    18.50700000   -12.14200000
H      -27.08500000    20.20200000   -11.30900000
H      -25.49600000    19.94500000   -10.61500000
H      -25.63000000    20.63800000   -12.23300000
H      -25.01700000    18.27700000   -12.46000000
H      -26.69694000    18.46120000   -13.01934000
H      -26.31948000    17.75100000   -11.39532000
--
0 1
C      -21.34300000    19.70900000    -9.12000000
C      -22.59100000    19.93700000   -12.68500000
C      -22.54300000    19.97400000   -11.30200000
C      -21.45700000    19.58300000   -13.40200000
C      -21.37500000    19.64700000   -10.62200000
C      -20.27600000    19.26300000   -12.73900000
C      -20.23900000    19.29600000   -11.34900000
O      -21.52300000    19.55400000   -14.75600000
H      -23.50000000    20.20000000   -13.20400000
H      -23.40800000    20.27900000   -10.73900000
H      -22.37800000    19.84300000   -15.07700000
H      -19.40300000    18.98700000   -13.31100000
H      -20.48400000    19.15600000    -8.73600000
H      -22.24900000    19.22700000    -8.74900000
H      -19.32300000    19.04400000   -10.83200000
H      -21.30832000    20.74866000    -8.76236800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-038LEU-1')] = qcdb.Molecule("""
0 1
C      -26.05800000    19.91100000   -11.54200000
C      -26.03500000    18.50700000   -12.14200000
H      -27.08500000    20.20200000   -11.30900000
H      -25.49600000    19.94500000   -10.61500000
H      -25.63000000    20.63800000   -12.23300000
H      -25.01700000    18.27700000   -12.46000000
H      -26.69694000    18.46120000   -13.01934000
H      -26.31948000    17.75100000   -11.39532000
--
0 1
C      -25.31300000    22.67500000    -9.36900000
C      -26.10000000    22.77100000    -8.06100000
C      -24.87900000    24.01600000    -9.95800000
H      -24.42900000    22.05700000    -9.20900000
H      -25.94700000    22.18200000   -10.10500000
H      -27.00400000    23.35700000    -8.22900000
H      -24.23700000    24.53900000    -9.25100000
H      -25.49101000    23.26967000    -7.29258800
H      -26.44055000    21.77032000    -7.75660100
H      -24.30037000    23.85202000   -10.87903000
H      -25.76099000    24.64104000   -10.16154000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-052PHE-1')] = qcdb.Molecule("""
0 1
C       27.87900000    21.44300000     0.15700000
C       26.98400000    21.39200000    -1.12600000
H       28.92900000    21.33300000    -0.11100000
H       27.74000000    22.40700000     0.64700000
H       27.59300000    20.65400000     0.85100000
H       27.25300000    22.23500000    -1.76400000
H       25.94800000    21.55300000    -0.82200000
H       27.04079000    20.45960000    -1.70686400
--
0 1
C       26.50700000    18.37800000     5.81800000
C       27.57900000    21.47100000     3.83000000
C       26.95700000    22.46000000     4.53200000
C       27.42700000    20.13500000     4.19300000
C       26.65500000    19.80600000     5.31000000
C       26.19300000    22.17600000     5.62100000
C       26.08900000    20.84800000     6.04800000
H       28.19100000    21.72900000     2.98000000
H       27.06600000    23.48500000     4.21100000
H       27.92500000    19.36000000     3.62600000
H       25.71100000    22.96800000     6.17900000
H       26.43700000    17.70300000     4.96700000
H       25.56700000    18.31400000     6.36700000
H       25.52900000    20.62200000     6.94100000
H       27.32023000    18.06119000     6.48754700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-092LEU-1')] = qcdb.Molecule("""
0 1
C       39.44100000    23.62300000     4.36700000
C       40.06500000    25.02700000     4.31700000
H       40.22400000    22.86500000     4.39500000
H       38.80100000    23.50000000     5.23900000
H       38.81300000    23.45300000     3.49300000
H       39.25600000    25.74100000     4.14500000
H       40.77120000    25.11008000     3.47772700
H       40.54473000    25.28946000     5.27144900
--
0 1
C       35.75200000    24.30300000     4.68300000
C       35.09500000    23.05900000     4.10300000
H       35.01600000    25.09100000     4.82900000
H       36.18700000    24.06400000     5.65400000
H       36.54200000    24.65400000     4.02000000
H       34.26500000    22.78300000     4.75200000
H       34.72609000    23.24274000     3.08312300
H       35.80111000    22.21569000     4.08791500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-092LEU-2')] = qcdb.Molecule("""
0 1
C       39.44100000    23.62300000     4.36700000
C       40.06500000    25.02700000     4.31700000
H       40.22400000    22.86500000     4.39500000
H       38.80100000    23.50000000     5.23900000
H       38.81300000    23.45300000     3.49300000
H       39.25600000    25.74100000     4.14500000
H       40.77120000    25.11008000     3.47772700
H       40.54473000    25.28946000     5.27144900
--
0 1
C       36.07800000    21.88500000     4.08200000
C       35.09500000    23.05900000     4.10300000
H       36.89800000    22.09300000     3.39600000
H       36.47400000    21.72200000     5.08500000
H       35.55700000    20.98100000     3.76200000
H       34.26500000    22.78300000     4.75200000
H       34.72609000    23.24274000     3.08312300
H       35.56993000    23.95825000     4.52226700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-105LEU-1')] = qcdb.Molecule("""
0 1
C       39.71600000    25.66700000     6.74400000
C       40.73400000    25.39300000     5.64800000
H       39.07700000    24.80500000     6.91600000
H       40.24400000    25.88500000     7.67000000
H       39.10100000    26.52500000     6.47300000
H       41.39100000    24.57900000     5.95900000
H       41.34100000    26.29100000     5.54600000
H       40.25427000    25.13054000     4.69355100
--
0 1
C       41.27500000    28.97600000     7.19600000
C       40.29200000    29.92800000     7.86200000
H       41.09400000    27.95400000     7.50800000
H       41.16400000    29.03700000     6.11300000
H       42.29600000    29.24700000     7.46400000
H       39.29300000    29.72500000     7.47400000
H       40.28841000    29.78521000     8.95268700
H       40.55453000    30.95927000     7.58351300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-108PHE-1')] = qcdb.Molecule("""
0 1
C       39.71600000    25.66700000     6.74400000
C       40.73400000    25.39300000     5.64800000
H       39.07700000    24.80500000     6.91600000
H       40.24400000    25.88500000     7.67000000
H       39.10100000    26.52500000     6.47300000
H       41.39100000    24.57900000     5.95900000
H       41.34100000    26.29100000     5.54600000
H       40.25427000    25.13054000     4.69355100
--
0 1
C       39.34700000    23.37100000     9.56600000
C       39.61300000    23.28400000    11.06000000
C       37.99100000    22.83600000     9.19200000
C       37.73600000    21.47300000     9.25700000
C       36.96700000    23.68900000     8.81000000
C       36.46900000    20.96600000     8.94800000
C       35.70600000    23.18200000     8.47200000
C       35.46100000    21.81400000     8.55300000
H       39.44100000    24.41000000     9.25600000
H       40.09400000    22.79600000     9.02100000
H       39.27500000    22.30000000    11.38700000
H       38.51600000    20.79200000     9.56500000
H       37.15700000    24.74500000     8.73700000
H       36.28800000    19.90700000     9.02200000
H       34.91300000    23.84700000     8.16000000
H       34.48400000    21.42200000     8.30900000
H       39.03646000    24.04790000    11.60227000
H       40.69684000    23.30578000    11.24657000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009ILE-155ILE-1')] = qcdb.Molecule("""
0 1
C       -4.17700000     7.98700000    22.24500000
C       -3.07300000     7.21500000    22.98100000
H       -4.37800000     7.51400000    21.28400000
H       -5.10300000     7.97700000    22.82100000
H       -3.87300000     9.02100000    22.07600000
H       -3.49500000     6.25700000    23.28900000
H       -2.73112200     7.74419900    23.88270000
H       -2.22934100     6.99050100    22.31179000
--
0 1
C       -5.48900000    10.58800000    20.00800000
C       -6.48600000    11.74200000    19.84100000
H       -5.31900000    10.14100000    19.04200000
H       -4.51400000    10.93300000    20.35200000
H       -5.87100000     9.84400000    20.71000000
H       -6.21000000    12.32600000    18.96200000
H       -6.47527100    12.40220000    20.72079000
H       -7.49858700    11.33783000    19.69501000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-013VAL-1')] = qcdb.Molecule("""
0 1
C        5.50800000    14.00700000    24.96100000
C        4.36200000    14.09800000    25.96200000
H        6.37100000    14.55900000    25.32700000
H        5.78200000    12.96300000    24.81000000
H        5.20200000    14.42200000    24.00300000
H        3.48200000    13.61700000    25.53700000
H        4.15762600    15.15214000    26.20079000
H        4.60865400    13.54700000    26.88154000
--
0 1
C        3.69500000    12.02600000    22.38800000
C        2.35000000    11.85100000    21.70400000
H        3.91500000    13.07900000    22.54200000
H        3.68200000    11.52900000    23.35800000
H        4.48100000    11.58500000    21.77500000
H        1.57700000    12.24600000    22.36400000
H        2.32643600    12.39440000    20.74788000
H        2.15051900    10.78302000    21.53188000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-033LEU-2')] = qcdb.Molecule("""
0 1
C        5.50800000    14.00700000    24.96100000
C        4.36200000    14.09800000    25.96200000
H        6.37100000    14.55900000    25.32700000
H        5.78200000    12.96300000    24.81000000
H        5.20200000    14.42200000    24.00300000
H        3.48200000    13.61700000    25.53700000
H        4.15762600    15.15214000    26.20079000
H        4.60865400    13.54700000    26.88154000
--
0 1
C        7.10300000    17.35400000    24.29300000
C        8.56100000    17.58200000    23.88900000
H        6.50300000    18.24900000    24.14200000
H        6.69400000    16.53800000    23.69800000
H        7.04500000    17.07900000    25.34200000
H        8.62000000    17.67800000    22.80500000
H        8.96060900    18.49250000    24.35943000
H        9.19016300    16.73591000    24.20250000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-039ARG-1')] = qcdb.Molecule("""
0 1
C       10.12200000    24.99600000     6.42700000
C       10.91300000    25.92900000     7.33700000
H        9.72300000    24.16500000     6.99700000
H        9.29000000    25.54300000     5.98400000
H       10.76700000    24.62200000     5.63000000
H       10.22900000    26.29300000     8.09800000
H       11.75820000    25.41600000     7.81915000
H       11.26834000    26.79641000     6.76137800
--
0 1
C        9.74900000    21.64500000     4.70000000
C        8.42300000    21.01500000     4.27200000
C       10.64900000    22.05700000     3.52800000
H        9.54700000    22.51200000     5.32400000
H       10.28600000    20.92300000     5.31300000
H        8.06000000    20.41200000     5.10400000
H        8.57900000    20.33200000     3.44000000
H       10.20000000    22.86800000     2.96000000
H       11.58000000    22.46500000     3.92700000
H        7.62895700    21.73797000     4.03364300
H       10.87126000    21.22407000     2.84474700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-041VAL-1')] = qcdb.Molecule("""
0 1
C        4.70400000    13.33400000    27.23700000
C        4.36200000    14.09800000    25.96200000
H        3.85600000    13.36100000    27.92200000
H        4.92600000    12.29500000    26.99600000
H        5.57000000    13.78500000    27.72200000
H        3.48200000    13.61700000    25.53700000
H        4.15762600    15.15214000    26.20079000
H        5.18898300    14.03233000    25.23965000
--
0 1
C        8.43200000    13.22700000    27.33300000
C        9.89200000    12.84400000    27.17700000
H        8.27600000    13.87900000    28.18900000
H        8.11500000    13.75700000    26.43800000
H        7.81800000    12.33400000    27.45600000
H       10.47400000    13.73700000    26.94500000
H       10.25294000    12.40087000    28.11687000
H        9.99144500    12.13644000    26.34066000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-041VAL-2')] = qcdb.Molecule("""
0 1
C        5.50800000    14.00700000    24.96100000
C        4.36200000    14.09800000    25.96200000
H        6.37100000    14.55900000    25.32700000
H        5.78200000    12.96300000    24.81000000
H        5.20200000    14.42200000    24.00300000
H        3.48200000    13.61700000    25.53700000
H        4.15762600    15.15214000    26.20079000
H        4.60865400    13.54700000    26.88154000
--
0 1
C        8.43200000    13.22700000    27.33300000
C        9.89200000    12.84400000    27.17700000
H        8.27600000    13.87900000    28.18900000
H        8.11500000    13.75700000    26.43800000
H        7.81800000    12.33400000    27.45600000
H       10.47400000    13.73700000    26.94500000
H       10.25294000    12.40087000    28.11687000
H        9.99144500    12.13644000    26.34066000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-055SER-2')] = qcdb.Molecule("""
0 1
C       -2.59800000     8.39300000    49.16700000
C       -1.82700000     7.65100000    48.07200000
H       -1.90800000     8.99400000    49.75900000
H       -3.33000000     9.05500000    48.70600000
H       -3.10700000     7.68400000    49.81900000
H       -1.31300000     8.39300000    47.46300000
H       -1.08041800     6.98713200    48.53232000
H       -2.51790600     7.08577900    47.42921000
--
0 1
C       -5.91200000     6.47100000    49.14900000
C       -6.87300000     7.34500000    49.96400000
O       -6.53700000     5.23500000    48.84500000
H       -5.64900000     6.98700000    48.22400000
H       -5.00600000     6.29000000    49.72800000
H       -7.10300000     6.81600000    50.88900000
H       -6.05200000     4.81200000    48.12400000
H       -7.80766700     7.50971900    49.40788000
H       -6.39110600     8.29648700    50.23317000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LEU-058ILE-1')] = qcdb.Molecule("""
0 1
C       10.12200000    24.99600000     6.42700000
C       10.91300000    25.92900000     7.33700000
H        9.72300000    24.16500000     6.99700000
H        9.29000000    25.54300000     5.98400000
H       10.76700000    24.62200000     5.63000000
H       10.22900000    26.29300000     8.09800000
H       11.75820000    25.41600000     7.81915000
H       11.26834000    26.79641000     6.76137800
--
0 1
C        7.82300000    22.62600000     8.19400000
C        7.52600000    23.80400000     9.11400000
H        7.77000000    22.93300000     7.15000000
H        8.82300000    22.25000000     8.40800000
H        7.11800000    21.82000000     8.37500000
H        8.41700000    24.43100000     9.16200000
H        7.33200000    23.42700000    10.11200000
H        6.68614600    24.43282000     8.78349500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LYS-137LEU-1')] = qcdb.Molecule("""
1 1
C      -13.40800000    20.22500000   -13.49600000
C      -11.97300000    20.72700000   -13.42600000
N      -13.70100000    19.67500000   -14.84900000
H      -13.55200000    19.45300000   -12.73200000
H      -14.08700000    21.05600000   -13.27400000
H      -11.81800000    21.45900000   -14.22400000
H      -11.28800000    19.89100000   -13.58500000
H      -13.09600000    18.89200000   -15.07600000
H      -14.65600000    19.33800000   -14.91100000
H      -13.58500000    20.37400000   -15.57400000
H      -11.74202000    21.20336000   -12.46177000
--
0 1
C      -13.10200000    17.69400000   -10.62700000
C      -12.72400000    16.42400000    -9.87600000
H      -13.74300000    17.44300000   -11.47400000
H      -13.64200000    18.36900000    -9.96500000
H      -12.19800000    18.19100000   -10.98600000
H      -12.04200000    16.69100000    -9.07300000
H      -12.21495000    15.73161000   -10.56264000
H      -13.61632000    15.96378000    -9.42659600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009LYS-171VAL-1')] = qcdb.Molecule("""
0 1
C      -11.65200000    21.38900000   -12.08600000
C      -10.24800000    21.98300000   -12.11300000
C      -11.97300000    20.72700000   -13.42600000
H      -11.71800000    20.65100000   -11.28600000
H      -12.37700000    22.17700000   -11.89400000
H      -10.21600000    22.65500000   -12.95700000
H       -9.52600000    21.17800000   -12.26200000
H      -11.81800000    21.45900000   -14.22400000
H      -11.28800000    19.89100000   -13.58500000
H       -9.97717300    22.57422000   -11.22581000
H      -13.01020000    20.36416000   -13.47660000
--
0 1
C      -14.31000000    24.07000000   -12.60400000
C      -15.33500000    25.20000000   -12.70300000
H      -13.29500000    24.47000000   -12.62000000
H      -14.45400000    23.52500000   -11.67300000
H      -14.43100000    23.38700000   -13.44600000
H      -15.19800000    25.85000000   -11.84300000
H      -15.18063000    25.78546000   -13.62138000
H      -16.35442000    24.78964000   -12.65404000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009PRO-069TYR-1')] = qcdb.Molecule("""
0 1
C        6.07400000    -5.76500000     2.11100000
C        5.18600000    -4.54200000     2.22300000
C        5.13600000    -6.86800000     2.53500000
H        6.91400000    -5.70400000     2.80100000
H        6.43000000    -5.90800000     1.08900000
H        5.79300000    -3.64500000     2.35200000
H        4.54100000    -4.45500000     1.34700000
H        5.67700000    -7.78300000     2.78100000
H        4.40800000    -7.06100000     1.74500000
H        4.58018600    -4.76168200     3.11447600
H        4.63457200    -6.42581900     3.40852500
--
0 1
C        8.73700000    -3.63400000     3.54000000
C       10.14400000    -4.04000000     3.08700000
C        8.71600000    -2.39300000     4.40500000
C        8.93200000    -1.13200000     3.84400000
C        8.53100000    -2.49200000     5.78900000
C        8.97100000     0.01400000     4.64600000
C        8.56900000    -1.35300000     6.60100000
C        8.79500000    -0.10200000     6.02700000
O        8.86600000     1.00900000     6.80600000
H        8.12300000    -3.45200000     2.65900000
H        8.29500000    -4.45800000     4.10000000
H       10.53900000    -3.25100000     2.47700000
H        9.07600000    -1.04300000     2.77800000
H        8.36100000    -3.46200000     6.23900000
H        9.13400000     0.98000000     4.19200000
H        8.43400000    -1.43300000     7.66900000
H        8.92900000     1.81400000     6.29300000
H       10.10924000    -4.96125700     2.48693600
H       10.78657000    -4.18255100     3.96835600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TRP-111ARG-1')] = qcdb.Molecule("""
0 1
C        5.97300000   -11.79500000    10.86800000
C        3.49700000    -9.50400000    12.48900000
C        4.33900000    -9.83300000    11.39500000
C        5.01000000   -11.05800000    11.72600000
C        4.55400000   -11.42600000    12.95100000
C        2.70900000    -8.36200000    12.50400000
C        2.75700000    -7.53300000    11.39500000
C        4.37000000    -8.97800000    10.28700000
C        3.58000000    -7.83300000    10.29700000
N        3.65000000   -10.49800000    13.41700000
H        3.18600000   -10.55700000    14.31800000
H        2.07500000    -8.13300000    13.35000000
H        4.86000000   -12.32200000    13.48400000
H        2.14900000    -6.63700000    11.37300000
H        4.94700000    -9.25000000     9.42000000
H        6.60100000   -12.43900000    11.48700000
H        6.61800000   -11.06900000    10.37200000
H        3.58600000    -7.16800000     9.44200000
H        5.45357200   -12.39667000    10.10761000
--
1 1
C        6.78200000    -7.23500000    12.27100000
C        6.46600000    -8.64200000    14.27100000
N        7.05000000    -8.40000000    13.11400000
N        5.56200000    -7.80500000    14.73800000
N        6.77800000    -9.72100000    14.95500000
H        7.74900000    -9.06700000    12.80200000
H        5.28300000    -7.01200000    14.18900000
H        5.10100000    -7.98800000    15.61500000
H        7.41400000   -10.39100000    14.54900000
H        6.29600000    -9.94500000    15.81100000
H        5.90600000    -6.65900000    12.57100000
H        6.57700000    -7.60600000    11.26600000
H        7.66339900    -6.58012200    12.20566000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-016GLU-1')] = qcdb.Molecule("""
0 1
C       12.38400000    27.74000000     7.20700000
C       15.44000000    25.54000000     7.95100000
C       16.32200000    26.50200000     8.44300000
C       14.15300000    25.93700000     7.56100000
C       13.75200000    27.28000000     7.66100000
C       15.90900000    27.82900000     8.56200000
C       14.64300000    28.20600000     8.18700000
O       17.57900000    26.18100000     8.84800000
H       15.74700000    24.51000000     7.87300000
H       13.46000000    25.20500000     7.17300000
H       16.58800000    28.57000000     8.95900000
H       18.06900000    26.94900000     9.15100000
H       11.94100000    28.35200000     7.99100000
H       11.74400000    26.86900000     7.06700000
H       14.34300000    29.24100000     8.28700000
H       12.40258000    28.31027000     6.26655100
--
-1 1
C       17.99000000    21.52700000     8.67800000
C       18.61200000    22.90600000     8.80200000
O       18.22100000    23.82800000     8.05000000
O       19.50400000    23.05500000     9.68600000
H       17.35500000    21.37800000     9.55600000
H       18.75300000    20.75700000     8.74100000
H       17.34174000    21.40486000     7.79775100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-029THR-1')] = qcdb.Molecule("""
0 1
C      -12.40100000     8.94800000   -12.89200000
C      -15.66800000     9.59100000   -11.12400000
C      -15.35000000    10.68300000   -10.33100000
C      -14.70700000     9.02300000   -11.93700000
C      -13.44600000     9.58300000   -12.02600000
C      -14.08100000    11.23500000   -10.38900000
C      -13.14100000    10.69100000   -11.24400000
O      -16.30500000    11.18000000    -9.50100000
H      -16.65600000     9.16500000   -11.06500000
H      -14.94100000     8.14500000   -12.52200000
H      -13.82900000    12.08000000    -9.76700000
H      -15.98300000    11.93500000    -8.98300000
H      -11.75400000     9.73200000   -13.27600000
H      -12.89300000     8.47700000   -13.74500000
H      -12.15100000    11.12500000   -11.29300000
H      -11.78995000     8.19813800   -12.36824000
--
0 1
C      -17.47200000     6.88100000   -13.12300000
C      -18.97400000     6.85800000   -13.42700000
H      -16.99400000     5.95400000   -13.42100000
H      -17.00500000     7.70400000   -13.65800000
H      -17.31400000     7.02800000   -12.05500000
H      -19.37000000     7.85700000   -13.25500000
H      -19.50690000     6.13549200   -12.79139000
H      -19.14223000     6.59253400   -14.48115000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-033ASN-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -8.77300000    18.24600000   -17.60400000
C       -7.61800000    18.96300000   -17.86400000
C       -8.72100000    17.15600000   -16.74900000
C       -6.40000000    18.60700000   -17.29600000
C       -7.51600000    16.78100000   -16.16900000
C       -6.36200000    17.50500000   -16.44200000
O       -9.84800000    16.44700000   -16.48800000
H       -9.71900000    18.57100000   -17.99900000
H       -7.70200000    19.85700000   -18.38600000
H      -10.53900000    16.59800000   -17.16900000
H       -7.49800000    15.92100000   -15.53500000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -5.43000000    17.20700000   -15.98300000
H       -4.56368900    18.95435000   -18.43230000
--
0 1
C       -7.22000000    16.75800000   -20.78000000
C       -6.67200000    17.07300000   -22.17700000
C       -7.55800000    15.29300000   -20.59200000
O       -7.50300000    14.49700000   -21.52500000
N       -7.92100000    14.92600000   -19.37400000
H       -6.49800000    17.03800000   -20.01800000
H       -8.13000000    17.33300000   -20.60900000
H       -7.35400000    16.62300000   -22.90100000
H       -8.26800000    13.99200000   -19.25900000
H       -7.98700000    15.60800000   -18.63200000
H       -5.66506100    16.64986000   -22.30749000
H       -6.66838800    18.15746000   -22.36123000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-035SER-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -7.61800000    18.96300000   -17.86400000
C       -6.40000000    18.60700000   -17.29600000
C       -8.77300000    18.24600000   -17.60400000
C       -8.72100000    17.15600000   -16.74900000
C       -6.36200000    17.50500000   -16.44200000
C       -7.51600000    16.78100000   -16.16900000
O       -9.84800000    16.44700000   -16.48800000
H       -7.70200000    19.85700000   -18.38600000
H       -9.71900000    18.57100000   -17.99900000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -5.43000000    17.20700000   -15.98300000
H      -10.53900000    16.59800000   -17.16900000
H       -7.49800000    15.92100000   -15.53500000
H       -4.56368900    18.95435000   -18.43230000
--
0 1
C       -7.98200000    22.68600000   -20.20800000
O       -7.68400000    21.34300000   -19.90600000
H       -7.16600000    20.95500000   -20.62600000
H       -7.05300000    23.25900000   -20.20200000
H       -8.63200000    23.09400000   -19.44300000
H       -8.46589900    22.76834000   -21.19241000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-050PRO-1')] = qcdb.Molecule("""
0 1
C       12.38400000    27.74000000     7.20700000
C       14.15300000    25.93700000     7.56100000
C       13.75200000    27.28000000     7.66100000
C       15.44000000    25.54000000     7.95100000
C       14.64300000    28.20600000     8.18700000
C       16.32200000    26.50200000     8.44300000
C       15.90900000    27.82900000     8.56200000
O       17.57900000    26.18100000     8.84800000
H       13.46000000    25.20500000     7.17300000
H       15.74700000    24.51000000     7.87300000
H       11.94100000    28.35200000     7.99100000
H       11.74400000    26.86900000     7.06700000
H       14.34300000    29.24100000     8.28700000
H       16.58800000    28.57000000     8.95900000
H       18.06900000    26.94900000     9.15100000
H       12.40258000    28.31027000     6.26655100
--
0 1
C       13.67400000    25.08000000    11.18200000
C       13.94400000    26.51100000    11.53400000
C       13.72600000    25.27700000    13.60000000
C       12.96500000    22.26100000    11.40400000
C       13.18200000    23.10300000    12.66300000
O       13.07500000    22.59600000    13.80400000
N       13.47000000    24.40500000    12.47400000
H       12.79400000    25.00800000    10.54200000
H       14.54800000    24.66200000    10.68000000
H       13.01500000    27.07000000    11.45100000
H       14.70100000    26.94800000    10.88700000
H       14.41500000    24.80300000    14.30000000
H       13.50800000    22.70800000    10.57300000
H       14.27582000    26.49933000    12.58269000
H       14.21090000    26.15457000    13.14752000
H       12.79058000    25.54623000    14.11234000
H       13.32572000    21.23339000    11.55860000
H       11.89331000    22.26532000    11.15608000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-053TYR-1')] = qcdb.Molecule("""
0 1
C       12.38400000    27.74000000     7.20700000
C       12.41000000    28.53800000     5.89100000
C       13.75200000    27.28000000     7.66100000
C       14.64300000    28.20600000     8.18700000
C       14.15300000    25.93700000     7.56100000
C       15.90900000    27.82900000     8.56200000
C       15.44000000    25.54000000     7.95100000
C       16.32200000    26.50200000     8.44300000
O       17.57900000    26.18100000     8.84800000
H       11.94100000    28.35200000     7.99100000
H       11.74400000    26.86900000     7.06700000
H       13.07300000    29.39200000     6.03600000
H       14.34300000    29.24100000     8.28700000
H       13.46000000    25.20500000     7.17300000
H       16.58800000    28.57000000     8.95900000
H       15.74700000    24.51000000     7.87300000
H       18.06900000    26.94900000     9.15100000
H       11.41051000    28.89926000     5.60725900
H       12.82692000    27.92608000     5.07753200
--
0 1
C       10.43900000    28.72400000    11.60100000
C       11.68700000    30.24000000    10.03700000
C       11.60700000    29.59200000    11.27500000
C       12.78000000    31.04300000     9.71600000
C       12.65700000    29.73100000    12.17200000
C       13.80000000    31.17900000    10.62300000
C       13.75600000    30.53800000    11.85600000
O       14.86400000    31.95500000    10.27800000
H       10.89800000    30.10700000     9.30900000
H       12.83500000    31.54300000     8.76000000
H       10.77900000    27.71000000    11.80100000
H        9.81400000    28.67100000    10.71100000
H       12.64700000    29.20400000    13.11300000
H       14.57200000    30.64200000    12.55600000
H       15.52600000    31.98500000    10.97800000
H        9.83747000    29.08983000    12.44618000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-111ASP-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -8.72100000    17.15600000   -16.74900000
C       -8.77300000    18.24600000   -17.60400000
C       -7.51600000    16.78100000   -16.16900000
C       -7.61800000    18.96300000   -17.86400000
C       -6.36200000    17.50500000   -16.44200000
C       -6.40000000    18.60700000   -17.29600000
O       -9.84800000    16.44700000   -16.48800000
H      -10.53900000    16.59800000   -17.16900000
H       -9.71900000    18.57100000   -17.99900000
H       -7.49800000    15.92100000   -15.53500000
H       -7.70200000    19.85700000   -18.38600000
H       -5.43000000    17.20700000   -15.98300000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -4.56368900    18.95435000   -18.43230000
--
-1 1
C      -11.84400000    15.23500000   -20.54900000
C      -11.66800000    15.34000000   -19.04000000
O      -11.48900000    16.47500000   -18.54300000
O      -11.69800000    14.29500000   -18.36100000
H      -11.11900000    14.52800000   -20.94900000
H      -11.61900000    16.19500000   -21.00700000
H      -12.85898000    14.91566000   -20.82798000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-121TYR-1')] = qcdb.Molecule("""
0 1
C      -12.40100000     8.94800000   -12.89200000
C      -11.54700000     7.90000000   -12.16000000
C      -13.44600000     9.58300000   -12.02600000
C      -13.14100000    10.69100000   -11.24400000
C      -14.70700000     9.02300000   -11.93700000
C      -14.08100000    11.23500000   -10.38900000
C      -15.66800000     9.59100000   -11.12400000
C      -15.35000000    10.68300000   -10.33100000
O      -16.30500000    11.18000000    -9.50100000
H      -11.75400000     9.73200000   -13.27600000
H      -12.89300000     8.47700000   -13.74500000
H      -12.21200000     7.14400000   -11.75900000
H      -12.15100000    11.12500000   -11.29300000
H      -14.94100000     8.14500000   -12.52200000
H      -13.82900000    12.08000000    -9.76700000
H      -16.65600000     9.16500000   -11.06500000
H      -15.98300000    11.93500000    -8.98300000
H      -10.97022000     8.34936400   -11.33818000
H      -10.86364000     7.40222000   -12.86373000
--
0 1
C      -13.72300000    11.89100000   -14.87200000
C      -13.31400000    12.78300000   -16.05200000
C      -14.71300000    10.81400000   -15.26600000
C      -14.33000000     9.75700000   -16.09500000
C      -16.05400000    10.93900000   -14.90300000
C      -15.26900000     8.80100000   -16.50100000
C      -17.00200000     9.97800000   -15.30100000
C      -16.60100000     8.91000000   -16.08600000
O      -17.54400000     8.00700000   -16.49700000
H      -12.82900000    11.41100000   -14.47600000
H      -14.14400000    12.51100000   -14.08000000
H      -12.92600000    12.11700000   -16.82400000
H      -13.30200000     9.66600000   -16.41700000
H      -16.36900000    11.77800000   -14.30400000
H      -14.96500000     7.98300000   -17.13800000
H      -18.03500000    10.06800000   -15.00100000
H      -17.23300000     7.49800000   -17.27500000
H      -12.50457000    13.47402000   -15.77394000
H      -14.17054000    13.30828000   -16.49967000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-158ALA-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -8.72100000    17.15600000   -16.74900000
C       -8.77300000    18.24600000   -17.60400000
C       -7.51600000    16.78100000   -16.16900000
C       -7.61800000    18.96300000   -17.86400000
C       -6.36200000    17.50500000   -16.44200000
C       -6.40000000    18.60700000   -17.29600000
O       -9.84800000    16.44700000   -16.48800000
H      -10.53900000    16.59800000   -17.16900000
H       -9.71900000    18.57100000   -17.99900000
H       -7.49800000    15.92100000   -15.53500000
H       -7.70200000    19.85700000   -18.38600000
H       -5.43000000    17.20700000   -15.98300000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -4.56368900    18.95435000   -18.43230000
--
0 1
C      -11.45300000    15.41400000   -14.04600000
C      -12.56200000    14.49800000   -13.56300000
H      -11.87300000    16.31400000   -14.49100000
H      -10.79300000    15.67800000   -13.22200000
H      -10.87400000    14.89400000   -14.79300000
H      -12.10600000    13.62900000   -13.10000000
H      -13.18144000    14.17544000   -14.41285000
H      -13.14968000    15.00017000   -12.78040000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-301MET-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -7.51600000    16.78100000   -16.16900000
C       -8.72100000    17.15600000   -16.74900000
C       -6.36200000    17.50500000   -16.44200000
C       -6.40000000    18.60700000   -17.29600000
C       -8.77300000    18.24600000   -17.60400000
C       -7.61800000    18.96300000   -17.86400000
O       -9.84800000    16.44700000   -16.48800000
H       -7.49800000    15.92100000   -15.53500000
H       -5.43000000    17.20700000   -15.98300000
H       -9.71900000    18.57100000   -17.99900000
H      -10.53900000    16.59800000   -17.16900000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -7.70200000    19.85700000   -18.38600000
H       -4.56368900    18.95435000   -18.43230000
--
0 1
C       -7.52700000    15.04500000   -12.92500000
C       -5.85800000    13.87900000   -14.82400000
S       -5.85200000    15.18300000   -13.56000000
H       -7.72200000    14.02300000   -12.60300000
H       -7.64900000    15.72100000   -12.08000000
H       -8.25800000    15.30200000   -13.69000000
H       -5.22300000    14.18200000   -15.65700000
H       -6.87300000    13.78300000   -15.21000000
H       -5.53058900    12.89318000   -14.46212000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009TYR-303TRP-1')] = qcdb.Molecule("""
0 1
C       -5.14600000    19.39000000   -17.60700000
C       -4.33600000    18.78400000   -18.75500000
C       -6.40000000    18.60700000   -17.29600000
C       -7.61800000    18.96300000   -17.86400000
C       -6.36200000    17.50500000   -16.44200000
C       -8.77300000    18.24600000   -17.60400000
C       -7.51600000    16.78100000   -16.16900000
C       -8.72100000    17.15600000   -16.74900000
O       -9.84800000    16.44700000   -16.48800000
H       -4.52200000    19.46100000   -16.71500000
H       -5.43900000    20.40400000   -17.88400000
H       -5.03800000    18.44200000   -19.51100000
H       -7.70200000    19.85700000   -18.38600000
H       -5.43000000    17.20700000   -15.98300000
H       -9.71900000    18.57100000   -17.99900000
H       -7.49800000    15.92100000   -15.53500000
H      -10.53900000    16.59800000   -17.16900000
H       -3.73023800    17.93503000   -18.40529000
H       -3.68530600    19.53335000   -19.22942000
--
0 1
C       -4.43800000    19.88700000   -12.48800000
C       -5.39400000    21.87600000   -13.87500000
C       -4.67900000    21.33100000   -12.75900000
C       -5.37600000    23.28700000   -13.74200000
C       -4.26100000    22.39100000   -12.01900000
C       -6.66600000    22.15200000   -15.89300000
C       -6.63100000    23.54500000   -15.73700000
C       -6.05300000    21.31100000   -14.97000000
C       -5.98700000    24.12800000   -14.66100000
N       -4.67700000    23.56600000   -12.59900000
H       -7.19900000    21.72800000   -16.73400000
H       -7.13300000    24.16800000   -16.46500000
H       -6.12000000    20.23700000   -15.06900000
H       -5.96800000    25.20200000   -14.53400000
H       -5.36200000    19.34900000   -12.70200000
H       -4.21500000    19.74600000   -11.42800000
H       -3.69800000    22.30900000   -11.09700000
H       -4.55700000    24.48000000   -12.17800000
H       -3.64093300    19.45459000   -13.11066000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009VAL-021PHE-1')] = qcdb.Molecule("""
0 1
C       26.34400000    28.20100000    29.31200000
C       26.29600000    26.91800000    30.14900000
H       25.91400000    28.04100000    28.32200000
H       25.77600000    28.98400000    29.81600000
H       27.37800000    28.53400000    29.20900000
H       26.67200000    27.18400000    31.13400000
H       26.97407000    26.15944000    29.73090000
H       25.26521000    26.56056000    30.28940000
--
0 1
C       27.78000000    29.90600000    32.24200000
C       28.08700000    30.57900000    33.59200000
C       28.99600000    29.82500000    31.35000000
C       29.93700000    28.80400000    31.52300000
C       29.26400000    30.81300000    30.41000000
C       31.09300000    28.76600000    30.75200000
C       30.41900000    30.77200000    29.65000000
C       31.31700000    29.74100000    29.79000000
H       27.42600000    28.89400000    32.43700000
H       26.98100000    30.44700000    31.73100000
H       28.93700000    30.05700000    34.03700000
H       29.77500000    28.04000000    32.27200000
H       28.58500000    31.64500000    30.29400000
H       31.82500000    28.00300000    30.90900000
H       30.61300000    31.53700000    28.91600000
H       32.21300000    29.71600000    29.18400000
H       27.22239000    30.50365000    34.26785000
H       28.38308000    31.62821000    33.44540000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009VAL-025ILE-1')] = qcdb.Molecule("""
0 1
C        0.17700000   -12.57900000    -7.71000000
C       -1.10700000   -12.61800000    -6.89100000
H        0.83300000   -13.38900000    -7.39500000
H       -0.06100000   -12.71600000    -8.76500000
H        0.68500000   -11.62300000    -7.57900000
H       -1.59900000   -13.55700000    -7.13300000
H       -0.88513350   -12.62938000    -5.81366700
H       -1.79039100   -11.80222000    -7.16936500
--
0 1
C        3.65800000   -12.84400000    -7.97600000
C        5.09800000   -13.15700000    -8.37500000
H        3.56500000   -11.81300000    -7.63400000
H        2.95400000   -13.05300000    -8.77700000
H        3.33400000   -13.49900000    -7.17700000
H        5.11000000   -14.15500000    -8.81600000
H        5.75146200   -13.17048000    -7.49023700
H        5.45275000   -12.45108000    -9.14039900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009VAL-035ARG-1')] = qcdb.Molecule("""
0 1
C        4.18000000    64.39000000    11.07900000
C        5.52000000    63.94100000    11.65100000
H        4.03400000    63.97100000    10.08300000
H        3.38000000    64.04400000    11.73300000
H        4.12200000    65.47800000    11.02800000
H        5.64700000    64.38300000    12.63600000
H        6.33372300    64.30361000    11.00573000
H        5.53078800    62.84709000    11.76607000
--
0 1
C        0.71400000    65.83600000    10.58900000
C        0.41100000    67.12000000     9.82300000
C       -0.34900000    64.75700000    10.38400000
H        1.70500000    65.46200000    10.33400000
H        0.72200000    66.08800000    11.64900000
H        1.07500000    67.90000000    10.20200000
H       -0.61200000    67.42200000    10.05100000
H       -0.54700000    64.26200000    11.33600000
H       -1.28900000    65.21400000    10.07000000
H        0.53166700    67.06002000     8.73128500
H       -0.02235941    64.02376000     9.63189700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009VAL-084ILE-1')] = qcdb.Molecule("""
0 1
C        0.17700000   -12.57900000    -7.71000000
C       -1.10700000   -12.61800000    -6.89100000
H        0.83300000   -13.38900000    -7.39500000
H       -0.06100000   -12.71600000    -8.76500000
H        0.68500000   -11.62300000    -7.57900000
H       -1.59900000   -13.55700000    -7.13300000
H       -0.88513350   -12.62938000    -5.81366700
H       -1.79039100   -11.80222000    -7.16936500
--
0 1
C        1.15200000   -10.72000000   -10.78200000
C        1.19400000    -9.19400000   -10.68400000
H        1.76500000   -11.06600000   -11.61700000
H        1.47300000   -11.19200000    -9.85900000
H        0.13800000   -11.08600000   -10.92400000
H        0.69400000    -8.90500000    -9.76300000
H        0.66250760    -8.72372300   -11.52445000
H        2.23641400    -8.84460800   -10.64798000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '009VAL-086TYR-1')] = qcdb.Molecule("""
0 1
C       -2.06200000   -11.47800000    -7.28000000
C       -1.10700000   -12.61800000    -6.89100000
H       -1.59600000   -10.51200000    -7.09900000
H       -2.30100000   -11.55000000    -8.34100000
H       -2.99000000   -11.54500000    -6.71400000
H       -1.59900000   -13.55700000    -7.13300000
H       -0.88513350   -12.62938000    -5.81366700
H       -0.17990140   -12.58984000    -7.48235000
--
0 1
C       -3.02300000   -14.12500000    -9.92100000
C       -3.37700000   -14.02000000   -11.40600000
C       -3.08300000   -15.49600000    -9.28000000
C       -3.33800000   -15.61600000    -7.91000000
C       -2.88800000   -16.66100000   -10.03300000
C       -3.34600000   -16.85600000    -7.29200000
C       -2.93300000   -17.91000000    -9.41600000
C       -3.14800000   -18.00300000    -8.04700000
O       -3.16400000   -19.22900000    -7.45100000
H       -2.00300000   -13.76000000    -9.80100000
H       -3.66300000   -13.44900000    -9.36500000
H       -2.62500000   -14.55800000   -11.97800000
H       -3.51500000   -14.73000000    -7.31600000
H       -2.68500000   -16.61500000   -11.09200000
H       -3.52000000   -16.93000000    -6.22700000
H       -2.81600000   -18.80500000    -9.99400000
H       -3.04900000   -19.15100000    -6.49000000
H       -3.39665700   -12.96002000   -11.69935000
H       -4.36756800   -14.45428000   -11.60644000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ARG-039ASP-1')] = qcdb.Molecule("""
1 1
C       19.75100000    33.48400000    45.23400000
C       17.77800000    34.83200000    45.86400000
N       16.93400000    35.24500000    46.78800000
N       18.73000000    33.96500000    46.17100000
N       17.67200000    35.31100000    44.64000000
H       16.94900000    34.87300000    47.72400000
H       16.18800000    35.86800000    46.49500000
H       18.78700000    33.63100000    47.12600000
H       18.19600000    34.89400000    43.87400000
H       16.85700000    35.89100000    44.45500000
H       19.31600000    33.29000000    44.25600000
H       20.14700000    32.53500000    45.59600000
H       20.56566000    34.21748000    45.14276000
--
-1 1
C       15.04200000    38.86200000    43.70500000
C       14.45800000    37.74400000    44.55800000
O       15.14200000    36.71500000    44.76200000
O       13.30100000    37.89100000    45.01100000
H       14.85100000    39.82600000    44.17400000
H       14.52500000    38.85200000    42.74400000
H       16.11950000    38.74371000    43.51789000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ARG-042ASP-1')] = qcdb.Molecule("""
1 1
C       19.75100000    33.48400000    45.23400000
C       17.77800000    34.83200000    45.86400000
N       17.67200000    35.31100000    44.64000000
N       18.73000000    33.96500000    46.17100000
N       16.93400000    35.24500000    46.78800000
H       18.19600000    34.89400000    43.87400000
H       16.85700000    35.89100000    44.45500000
H       18.78700000    33.63100000    47.12600000
H       16.94900000    34.87300000    47.72400000
H       16.18800000    35.86800000    46.49500000
H       19.31600000    33.29000000    44.25600000
H       20.14700000    32.53500000    45.59600000
H       20.56566000    34.21748000    45.14276000
--
-1 1
C       19.13000000    36.34900000    41.00100000
C       19.42100000    34.87900000    41.30400000
O       18.65000000    34.27300000    42.08300000
O       20.40900000    34.32800000    40.76800000
H       18.73200000    36.80200000    41.90700000
H       18.35400000    36.41900000    40.23700000
H       20.02398000    36.89815000    40.67051000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ARG-092LEU-1')] = qcdb.Molecule("""
0 1
C       24.38900000    -9.10300000   -15.49200000
C       24.97000000   -10.35200000   -16.13000000
C       22.89800000    -8.91100000   -15.83300000
H       24.47500000    -9.19600000   -14.41000000
H       24.95000000    -8.22400000   -15.80500000
H       24.98000000   -10.24000000   -17.21600000
H       24.30700000   -11.18500000   -15.88400000
H       22.34500000    -9.75600000   -15.41800000
H       22.52600000    -8.02400000   -15.31900000
H       25.98137000   -10.58861000   -15.76787000
H       22.68409000    -8.86128800   -16.91085000
--
0 1
C       25.57100000    -6.72900000   -12.87700000
C       26.63400000    -7.70600000   -12.42200000
H       25.38000000    -5.99000000   -12.09800000
H       25.92100000    -6.21200000   -13.77100000
H       24.64800000    -7.24500000   -13.13000000
H       26.72300000    -8.49200000   -13.17100000
H       26.35839000    -8.15791100   -11.45773000
H       27.62443000    -7.24550100   -12.29164000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ASN-014GLN-2')] = qcdb.Molecule("""
0 1
C       15.19100000    64.52800000    12.41400000
C       14.92800000    64.15900000    13.86700000
O       15.67900000    63.40500000    14.49500000
N       13.85800000    64.70500000    14.42200000
H       15.80200000    65.43200000    12.42100000
H       14.25000000    64.76700000    11.91500000
H       13.68500000    64.55100000    15.40400000
H       13.27600000    65.34000000    13.89400000
H       15.71821000    63.73574000    11.86230000
--
0 1
C       14.45700000    59.33300000    14.81000000
C       13.21100000    60.11800000    15.18200000
O       12.13000000    59.55000000    15.37000000
N       13.34500000    61.42700000    15.28800000
H       12.53500000    61.97300000    15.53800000
H       14.24400000    61.86200000    15.11700000
H       14.84100000    58.84200000    15.70500000
H       15.22700000    60.01000000    14.44100000
H       14.23093000    58.57870000    14.04193000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ASN-023GLU-1')] = qcdb.Molecule("""
0 1
C       -2.31500000    16.97800000    14.68800000
C       -2.02800000    18.29100000    13.96200000
C       -2.44100000    17.16200000    16.16900000
O       -1.79200000    18.02700000    16.75700000
N       -3.30000000    16.37200000    16.79000000
H       -3.20900000    16.50200000    14.29000000
H       -1.48800000    16.28200000    14.54500000
H       -1.18000000    18.77400000    14.45300000
H       -3.40100000    16.46000000    17.78800000
H       -3.86100000    15.69200000    16.27200000
H       -2.88950700    18.96935000    14.04943000
H       -1.68688100    18.11324000    12.93145000
--
-1 1
C       -5.69800000    14.00000000    13.42900000
C       -4.86700000    14.09900000    14.70900000
O       -5.33000000    14.68700000    15.70700000
O       -3.76100000    13.53000000    14.74600000
H       -6.25000000    13.05800000    13.42400000
H       -5.01000000    13.97400000    12.58200000
H       -6.41646100    14.82397000    13.30698000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ASN-088TYR-1')] = qcdb.Molecule("""
0 1
C       12.70200000    11.37100000    -1.47300000
C       11.79500000    10.15200000    -1.43500000
O       12.17700000     9.09800000    -0.92400000
N       10.59900000    10.28000000    -1.98200000
H        9.96300000     9.49200000    -1.96200000
H       10.33300000    11.14800000    -2.42100000
H       12.35500000    12.09100000    -0.73100000
H       12.61700000    11.83900000    -2.45500000
H       13.75690000    11.11429000    -1.29610500
--
0 1
C        6.53200000     3.98100000     0.52800000
C        7.66100000     7.62000000    -1.48700000
C        6.74000000     6.74600000    -2.05900000
C        8.19200000     7.31900000    -0.24200000
C        6.39500000     5.57100000    -1.40200000
C        7.86500000     6.12800000     0.40800000
C        6.97200000     5.23300000    -0.18300000
O        8.02600000     8.77800000    -2.11900000
H        7.58600000     8.86800000    -2.97300000
H        6.29500000     6.97800000    -3.01600000
H        8.83000000     8.04100000     0.22100000
H        5.67800000     4.90400000    -1.85700000
H        8.29000000     5.90800000     1.37900000
H        7.17600000     3.79100000     1.38900000
H        6.62400000     3.13900000    -0.15900000
H        5.48906700     4.08227700     0.86271530
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010ASP-090TYR-1')] = qcdb.Molecule("""
-1 1
C        9.90100000    10.68300000     9.29800000
C       10.09000000     9.57700000     8.26500000
O        9.13000000     9.27600000     7.51900000
O       11.19200000     8.98800000     8.21100000
H       10.84700000    11.20300000     9.46800000
H        9.59300000    10.22800000    10.23700000
H        9.13452900    11.40921000     8.98954200
--
0 1
C       17.22800000     5.96400000    10.10200000
C       13.33500000     7.78900000    10.43400000
C       14.02100000     7.82100000     9.21900000
C       13.91900000     7.19100000    11.55300000
C       15.28900000     7.24900000     9.12300000
C       15.19000000     6.62100000    11.44700000
C       15.88400000     6.64100000    10.23300000
O       12.08900000     8.33200000    10.52200000
H       11.78700000     8.60800000     9.62500000
H       13.57500000     8.29200000     8.36000000
H       13.37900000     7.16000000    12.48800000
H       15.82600000     7.28800000     8.18500000
H       15.63000000     6.14000000    12.31000000
H       17.71900000     5.93000000    11.07500000
H       17.84800000     6.57900000     9.44700000
H       17.15464000     4.94704600     9.68917700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010GLN-022MET-1')] = qcdb.Molecule("""
0 1
C       12.92700000     9.95000000    10.35200000
C       13.02600000     9.63400000     8.87200000
O       12.51500000    10.35600000     8.01100000
N       13.70100000     8.52400000     8.58000000
H       13.26600000    10.97300000    10.49600000
H       13.63500000     9.30900000    10.87300000
H       13.77200000     8.24800000     7.61200000
H       13.97600000     7.88500000     9.32000000
H       11.91168000     9.86299300    10.76618000
--
0 1
C       16.41800000    11.14000000     8.75000000
C       16.73400000    11.97900000     9.96900000
C       17.24500000     9.49500000     6.81200000
S       17.79200000    10.03000000     8.41600000
H       15.51500000    10.56100000     8.92400000
H       16.26600000    11.78900000     7.88800000
H       17.71000000    12.44800000     9.84100000
H       16.79500000    11.30700000    10.82600000
H       16.96100000    10.33500000     6.19000000
H       18.04700000     8.94500000     6.32000000
H       16.38200000     8.83900000     6.92500000
H       15.97474000    12.75273000    10.15574000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010GLN-102TYR-1')] = qcdb.Molecule("""
0 1
C        2.69200000    -8.99600000    -2.19600000
C        1.92600000    -7.71700000    -2.38600000
O        0.70200000    -7.71700000    -2.38900000
N        2.63100000    -6.60700000    -2.50200000
H        2.13100000    -5.76400000    -2.73500000
H        3.63800000    -6.64600000    -2.51800000
H        2.81100000    -9.15500000    -1.12400000
H        3.68600000    -8.90800000    -2.61600000
H        2.17518100    -9.86795200    -2.62331400
--
0 1
C        5.18100000    -1.90500000    -9.44800000
C        3.56200000    -4.17700000    -6.16500000
C        4.47200000    -3.15200000    -5.92600000
C        3.15700000    -4.46400000    -7.47400000
C        4.98700000    -2.42000000    -6.99300000
C        3.68100000    -3.72000000    -8.53500000
C        4.60600000    -2.70000000    -8.30500000
O        3.10200000    -4.89200000    -5.10600000
H        3.47700000    -4.57500000    -4.28300000
H        4.78900000    -2.92700000    -4.91700000
H        2.45400000    -5.26000000    -7.65600000
H        5.70400000    -1.63200000    -6.79900000
H        3.37800000    -3.94800000    -9.54900000
H        5.00100000    -2.42800000   -10.38900000
H        6.26200000    -1.83700000    -9.31000000
H        4.76357400    -0.88897350    -9.50670100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010GLU-014LYS-1')] = qcdb.Molecule("""
-1 1
C       17.29500000    23.35900000    11.77000000
C       15.95700000    23.99300000    11.38000000
C       18.27400000    23.18300000    10.61000000
O       18.03800000    23.73700000     9.51300000
O       19.29500000    22.48300000    10.79800000
H       17.75600000    23.92000000    12.58700000
H       17.03500000    22.37300000    12.07900000
H       16.13400000    24.90800000    10.81400000
H       15.45100000    24.28600000    12.30000000
H       15.28179000    23.32995000    10.81923000
--
1 1
C       18.23500000    21.01300000    13.87400000
C       17.76500000    19.59600000    14.16600000
N       18.56300000    21.76500000    15.11000000
H       19.06400000    21.01200000    13.15800000
H       17.35600000    21.47500000    13.46100000
H       16.84400000    19.65000000    14.75100000
H       18.51800000    19.05900000    14.74700000
H       19.35100000    21.34600000    15.59000000
H       18.82000000    22.72300000    14.90200000
H       17.78600000    21.78700000    15.76000000
H       17.58173000    19.05268000    13.22727000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010GLU-032SER-1')] = qcdb.Molecule("""
-1 1
C       41.51400000    23.63200000    -1.56100000
C       40.79800000    22.50400000    -0.87100000
C       40.57100000    24.62400000    -2.23100000
O       39.44500000    24.21800000    -2.62300000
O       40.95800000    25.80700000    -2.37800000
H       42.09800000    24.13600000    -0.79600000
H       42.16900000    23.19600000    -2.31800000
H       41.53600000    21.82800000    -0.43400000
H       40.23500000    21.93500000    -1.61200000
H       40.11832000    22.86336000    -0.08430429
--
0 1
C       44.32400000    26.20400000    -1.53300000
C       44.67200000    24.73500000    -1.28100000
O       43.08800000    26.52900000    -0.94000000
H       45.10200000    26.83200000    -1.09800000
H       44.27700000    26.39200000    -2.60800000
H       43.93200000    24.12200000    -1.76800000
H       43.20100000    27.36100000    -0.44800000
H       44.68698000    24.51411000    -0.20351040
H       45.61278000    24.46683000    -1.78400600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010HIE-015TYR-1')] = qcdb.Molecule("""
0 1
C       16.82700000    20.22500000    34.05700000
C       17.27700000    20.75400000    32.68700000
C       17.74200000    20.54800000    35.20200000
C       17.61900000    21.52700000    36.13600000
C       19.42800000    20.37700000    36.58200000
N       18.88800000    19.83400000    35.49500000
N       18.68900000    21.40200000    36.98500000
H       15.84400000    20.64000000    34.28200000
H       16.71100000    19.14200000    33.99600000
H       16.48300000    20.52400000    31.99600000
H       16.81900000    22.25500000    36.19700000
H       20.33500000    20.03400000    37.06900000
H       18.88100000    21.97400000    37.80200000
H       18.17801000    20.23415000    32.32932000
H       17.35399000    21.85130000    32.68916000
--
0 1
C       15.42100000    21.29700000    29.05100000
C       13.54400000    20.58500000    32.26900000
C       13.77000000    19.22800000    32.45800000
C       14.05300000    21.25100000    31.16600000
C       14.80900000    20.57000000    30.22200000
C       14.54600000    18.53600000    31.55300000
C       15.05200000    19.20400000    30.42200000
O       13.24200000    18.60200000    33.54800000
H       12.96800000    21.12700000    33.00600000
H       13.90800000    22.31800000    31.09800000
H       14.75500000    17.48600000    31.70000000
H       13.51600000    17.68200000    33.60900000
H       16.13900000    20.63700000    28.57500000
H       15.96400000    22.15700000    29.43800000
H       15.66000000    18.65900000    29.71300000
H       14.69253000    21.62427000    28.29454000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010HIE-023ASP-1')] = qcdb.Molecule("""
0 1
C        3.44400000    88.42200000    28.09700000
C        2.24600000    87.83600000    30.31200000
C        2.28500000    88.09800000    28.97500000
C        0.23000000    87.54000000    29.49500000
N        0.95400000    87.49100000    30.60900000
N        1.00900000    87.90900000    28.48700000
H        3.02200000    87.85500000    31.06400000
H        0.61400000    87.24200000    31.52700000
H        4.17400000    88.94400000    28.69900000
H        3.07700000    89.09500000    27.31700000
H       -0.82300000    87.32900000    29.35200000
H        3.95632200    87.52959000    27.70824000
--
-1 1
C        1.40200000    91.32600000    31.48000000
C        1.77700000    91.09300000    32.95400000
C        0.44400000    92.49800000    31.28600000
O       -0.04000000    93.09800000    32.27800000
O        0.11400000    92.82800000    30.12100000
H        2.32500000    91.53100000    30.94700000
H        0.94600000    90.42300000    31.07200000
H        2.07800000    92.05100000    33.38500000
H        2.60955800    90.37810000    33.02996000
H        0.91564030    90.68904000    33.50615000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010LEU-091ASN-1')] = qcdb.Molecule("""
0 1
C       22.53600000   -10.04700000     6.01600000
C       23.08200000    -8.76100000     6.64000000
C       21.22500000    -9.82600000     5.25300000
H       23.27400000   -10.40300000     5.30000000
H       22.39000000   -10.81000000     6.77900000
H       22.29100000    -8.27600000     7.21300000
H       21.34900000    -8.99000000     4.56600000
H       23.42573000    -8.08259700     5.84525700
H       23.88735000    -8.95388100     7.36402300
H       20.97025000   -10.70283000     4.63958300
H       20.40156000    -9.57329600     5.93716700
--
0 1
C       23.72400000   -14.08000000     5.93500000
C       24.28400000   -12.91700000     5.12800000
O       23.94600000   -12.72900000     3.96200000
N       25.14700000   -12.12500000     5.74300000
H       22.74800000   -13.77800000     6.31700000
H       24.37900000   -14.28100000     6.78500000
H       25.54800000   -11.36300000     5.21100000
H       25.53200000   -12.34100000     6.65600000
H       23.61392000   -14.99298000     5.33138400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010LEU-096TRP-1')] = qcdb.Molecule("""
0 1
C       20.87200000   -11.04100000     4.40300000
C       21.22500000    -9.82600000     5.25300000
H       20.75200000   -11.92000000     5.03700000
H       19.94200000   -10.85700000     3.86400000
H       21.66400000   -11.22000000     3.67500000
H       21.34900000    -8.99000000     4.56600000
H       22.16578000    -9.98459000     5.80053000
H       20.40156000    -9.57329600     5.93716700
--
0 1
C       23.57200000   -14.97400000    -2.01100000
C       22.08300000   -14.13100000     1.33000000
C       21.92600000   -14.56700000    -0.01100000
C       23.23500000   -14.58400000    -0.61000000
C       24.10100000   -14.17500000     0.35400000
C       21.01300000   -13.98800000     2.19700000
C       19.75200000   -14.29600000     1.72100000
C       19.56000000   -14.72500000     0.40200000
C       20.63400000   -14.86100000    -0.47200000
N       23.41900000   -13.90200000     1.51600000
H       21.16000000   -13.64900000     3.21000000
H       18.89700000   -14.16000000     2.36900000
H       23.83200000   -13.49100000     2.35100000
H       18.55700000   -14.92700000     0.05000000
H       25.17200000   -14.08200000     0.21600000
H       20.44800000   -15.14500000    -1.49300000
H       24.65600000   -15.06100000    -2.09800000
H       23.24600000   -14.17000000    -2.67200000
H       23.10966000   -15.91590000    -2.34124100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010LEU-132ILE-1')] = qcdb.Molecule("""
0 1
C       20.07800000    -9.47400000     6.20600000
C       21.22500000    -9.82600000     5.25300000
H       20.25900000    -8.53100000     6.71900000
H       19.15500000    -9.36900000     5.63400000
H       19.94300000   -10.27000000     6.94100000
H       21.34900000    -8.99000000     4.56600000
H       22.16578000    -9.98459000     5.80053000
H       20.97025000   -10.70283000     4.63958300
--
0 1
C       17.13100000    -9.07400000     8.57300000
C       16.97100000    -7.67400000     7.96400000
H       16.65100000    -9.82400000     7.94600000
H       18.19200000    -9.31600000     8.64700000
H       16.69600000    -9.09800000     9.57200000
H       17.32800000    -7.68100000     6.93300000
H       17.62900000    -7.02400000     8.53800000
H       15.93446000    -7.30790800     8.00348000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010PHE-028ILE-2')] = qcdb.Molecule("""
0 1
C       14.35300000    21.96900000    11.63900000
C       14.23600000    18.31700000    12.65700000
C       15.19500000    17.75600000    11.83300000
C       13.96900000    19.68300000    12.59900000
C       14.64700000    20.49500000    11.69800000
C       15.87500000    18.55300000    10.93200000
C       15.60400000    19.91500000    10.86500000
H       13.69100000    17.69100000    13.34900000
H       15.40300000    16.69600000    11.88700000
H       13.22200000    20.11300000    13.25100000
H       16.62200000    18.11600000    10.28600000
H       14.80700000    22.46000000    12.49700000
H       13.27200000    22.08500000    11.73600000
H       16.16700000    20.48500000    10.14700000
H       14.66898000    22.46020000    10.70686000
--
0 1
C       11.40000000    17.63600000    10.39200000
C       10.63500000    18.83500000     9.83900000
C       11.82400000    16.70500000     9.28700000
H       12.26900000    17.96700000    10.95400000
H       10.75600000    17.06100000    11.05900000
H       10.10100000    18.50900000     8.94400000
H       12.57800000    17.18700000     8.66600000
H       12.21400000    15.79100000     9.72700000
H       10.96900000    16.43600000     8.66800000
H        9.85862400    19.15215000    10.55080000
H       11.29274000    19.66308000     9.53625300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-022LEU-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -1.54600000    23.08900000   -25.24600000
C       -2.67100000    22.56200000   -24.56500000
C       -2.18900000    21.57200000   -23.64500000
C       -0.83900000    21.53100000   -23.79600000
C       -1.65500000    24.08100000   -26.20800000
C       -2.91900000    24.55600000   -26.50400000
C       -3.94000000    23.06000000   -24.88100000
C       -4.05200000    24.05200000   -25.85000000
N       -0.44900000    22.43900000   -24.75000000
H        0.51200000    22.66500000   -25.00200000
H       -0.77100000    24.48500000   -26.67200000
H       -0.17100000    20.87500000   -23.24700000
H       -3.04100000    25.33700000   -27.24100000
H       -4.80800000    22.68800000   -24.36400000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -5.02600000    24.43900000   -26.11100000
H       -3.11526600    21.15985000   -21.70627000
--
0 1
C       -1.54200000    20.39000000   -27.68300000
C       -1.24200000    20.96000000   -29.06800000
H       -0.89800000    20.83800000   -26.93200000
H       -2.57100000    20.62700000   -27.41000000
H       -1.41400000    19.30800000   -27.68300000
H       -1.28600000    22.04700000   -28.99600000
H       -0.24129710    20.66466000   -29.41638000
H       -2.00740400    20.63640000   -29.78872000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-025VAL-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -0.83900000    21.53100000   -23.79600000
C       -2.18900000    21.57200000   -23.64500000
C       -1.54600000    23.08900000   -25.24600000
C       -2.67100000    22.56200000   -24.56500000
C       -1.65500000    24.08100000   -26.20800000
C       -3.94000000    23.06000000   -24.88100000
C       -2.91900000    24.55600000   -26.50400000
C       -4.05200000    24.05200000   -25.85000000
N       -0.44900000    22.43900000   -24.75000000
H       -0.17100000    20.87500000   -23.24700000
H        0.51200000    22.66500000   -25.00200000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -0.77100000    24.48500000   -26.67200000
H       -4.80800000    22.68800000   -24.36400000
H       -3.04100000    25.33700000   -27.24100000
H       -5.02600000    24.43900000   -26.11100000
H       -3.11526600    21.15985000   -21.70627000
--
0 1
C        2.20800000    19.72200000   -24.97300000
C        3.08700000    18.47300000   -24.95700000
H        2.48000000    20.36800000   -25.80500000
H        1.16200000    19.43400000   -25.09000000
H        2.32700000    20.27800000   -24.04200000
H        2.92900000    17.92800000   -25.88700000
H        4.14844700    18.75102000   -24.87930000
H        2.78409400    17.81179000   -24.13174000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-032ILE-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -3.15600000    21.32000000   -21.31400000
C       -2.18900000    21.57200000   -23.64500000
C       -0.83900000    21.53100000   -23.79600000
C       -2.67100000    22.56200000   -24.56500000
C       -1.54600000    23.08900000   -25.24600000
C       -3.94000000    23.06000000   -24.88100000
C       -1.65500000    24.08100000   -26.20800000
C       -4.05200000    24.05200000   -25.85000000
C       -2.91900000    24.55600000   -26.50400000
N       -0.44900000    22.43900000   -24.75000000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -2.15700000    21.46300000   -20.90400000
H       -0.17100000    20.87500000   -23.24700000
H        0.51200000    22.66500000   -25.00200000
H       -4.80800000    22.68800000   -24.36400000
H       -0.77100000    24.48500000   -26.67200000
H       -5.02600000    24.43900000   -26.11100000
H       -3.04100000    25.33700000   -27.24100000
H       -3.73406700    20.61541000   -20.69805000
H       -3.68880800    22.28195000   -21.34155000
--
0 1
C       -2.73100000    17.71000000   -24.48400000
C       -2.69000000    16.19100000   -24.66100000
H       -2.22500000    17.95000000   -23.55400000
H       -2.20900000    18.20200000   -25.30600000
H       -3.75200000    18.09300000   -24.47300000
H       -3.14500000    15.94400000   -25.62200000
H       -3.26449900    15.68858000   -23.86883000
H       -1.64927200    15.83479000   -24.65957000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-032PHE-1')] = qcdb.Molecule("""
0 1
C       -1.74800000    -4.46400000     0.95600000
C       -0.75200000    -5.61200000     0.76800000
C       -2.06900000    -4.16200000     2.40000000
C       -3.17800000    -4.53500000     3.05500000
C       -1.28200000    -3.42700000     3.34300000
C       -1.99400000    -3.39100000     4.55300000
C       -0.07100000    -2.73800000     3.26000000
C       -1.54000000    -2.72000000     5.66800000
C        0.40700000    -2.11200000     4.37900000
C       -0.32300000    -2.10000000     5.56200000
N       -3.14300000    -4.07800000     4.33700000
H       -1.36800000    -3.55800000     0.48300000
H       -2.67800000    -4.70000000     0.44700000
H       -0.83000000    -5.93700000    -0.27200000
H       -3.99900000    -5.09500000     2.61500000
H       -3.91200000    -4.17900000     4.99000000
H        0.47900000    -2.71300000     2.33300000
H       -2.12900000    -2.63400000     6.56700000
H        1.35600000    -1.59800000     4.33600000
H        0.07300000    -1.56500000     6.41500000
H       -1.01424900    -6.45602100     1.42287000
H        0.27751210    -5.24218900     0.88352040
--
0 1
C       -3.68400000    -0.65600000    -3.38900000
C       -4.98000000    -2.42900000     0.31600000
C       -5.78600000    -2.56100000    -0.80400000
C       -3.76800000    -1.76100000     0.24200000
C       -5.35100000    -2.01200000    -2.01700000
C       -3.35000000    -1.18900000    -0.94400000
C       -4.14900000    -1.28000000    -2.08400000
H       -5.29800000    -2.85300000     1.25900000
H       -6.73100000    -3.08200000    -0.73900000
H       -3.14900000    -1.67700000     1.12500000
H       -5.97000000    -2.10700000    -2.89700000
H       -2.40700000    -0.66100000    -0.97800000
H       -2.93100000     0.10200000    -3.17200000
H       -4.53100000    -0.15100000    -3.84700000
H       -3.26802200    -1.39058400    -4.09422900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-034VAL-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -2.67100000    22.56200000   -24.56500000
C       -2.18900000    21.57200000   -23.64500000
C       -1.54600000    23.08900000   -25.24600000
C       -0.83900000    21.53100000   -23.79600000
C       -3.94000000    23.06000000   -24.88100000
C       -4.05200000    24.05200000   -25.85000000
C       -2.91900000    24.55600000   -26.50400000
C       -1.65500000    24.08100000   -26.20800000
N       -0.44900000    22.43900000   -24.75000000
H       -4.80800000    22.68800000   -24.36400000
H       -5.02600000    24.43900000   -26.11100000
H       -3.04100000    25.33700000   -27.24100000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -0.17100000    20.87500000   -23.24700000
H        0.51200000    22.66500000   -25.00200000
H       -0.77100000    24.48500000   -26.67200000
H       -3.11526600    21.15985000   -21.70627000
--
0 1
C       -7.47800000    21.93200000   -25.97600000
C       -7.32200000    20.47700000   -25.56900000
H       -6.63500000    22.52800000   -25.63600000
H       -7.53100000    21.99400000   -27.06400000
H       -8.40700000    22.34600000   -25.58400000
H       -8.23000000    19.94600000   -25.85800000
H       -7.18111700    20.39333000   -24.48127000
H       -6.47216000    20.02510000   -26.10150000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-052TYR-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -1.54600000    23.08900000   -25.24600000
C       -2.67100000    22.56200000   -24.56500000
C       -2.18900000    21.57200000   -23.64500000
C       -0.83900000    21.53100000   -23.79600000
C       -2.91900000    24.55600000   -26.50400000
C       -1.65500000    24.08100000   -26.20800000
C       -4.05200000    24.05200000   -25.85000000
C       -3.94000000    23.06000000   -24.88100000
N       -0.44900000    22.43900000   -24.75000000
H       -3.04100000    25.33700000   -27.24100000
H       -0.77100000    24.48500000   -26.67200000
H       -5.02600000    24.43900000   -26.11100000
H       -4.80800000    22.68800000   -24.36400000
H        0.51200000    22.66500000   -25.00200000
H       -0.17100000    20.87500000   -23.24700000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -3.11526600    21.15985000   -21.70627000
--
0 1
C       -0.67200000    29.32600000   -30.08700000
C       -0.72100000    25.58000000   -29.45400000
C       -0.10700000    25.09600000   -30.60300000
C       -0.90000000    26.95000000   -29.28700000
C       -0.45900000    27.84500000   -30.25700000
C        0.32500000    25.97900000   -31.58500000
C        0.14400000    27.34600000   -31.41200000
O        0.06700000    23.75700000   -30.76900000
H       -1.08400000    24.88100000   -28.72400000
H       -1.38100000    27.31900000   -28.39200000
H        0.79700000    25.60100000   -32.48000000
H        0.37600000    23.55500000   -31.68000000
H        0.09000000    29.85700000   -30.65900000
H       -0.54400000    29.60400000   -29.03900000
H        0.48500000    28.02700000   -32.18200000
H       -1.66302400    29.64506000   -30.44207000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-058PHE-1')] = qcdb.Molecule("""
0 1
C       -3.01000000    20.74600000   -22.72000000
C       -1.54600000    23.08900000   -25.24600000
C       -2.67100000    22.56200000   -24.56500000
C       -2.18900000    21.57200000   -23.64500000
C       -0.83900000    21.53100000   -23.79600000
C       -2.91900000    24.55600000   -26.50400000
C       -1.65500000    24.08100000   -26.20800000
C       -4.05200000    24.05200000   -25.85000000
C       -3.94000000    23.06000000   -24.88100000
N       -0.44900000    22.43900000   -24.75000000
H       -3.04100000    25.33700000   -27.24100000
H       -0.77100000    24.48500000   -26.67200000
H       -5.02600000    24.43900000   -26.11100000
H       -4.80800000    22.68800000   -24.36400000
H        0.51200000    22.66500000   -25.00200000
H       -0.17100000    20.87500000   -23.24700000
H       -2.54400000    19.78000000   -22.63200000
H       -3.99500000    20.59100000   -23.16100000
H       -3.11526600    21.15985000   -21.70627000
--
0 1
C       -4.89800000    24.34400000   -33.57900000
C       -4.07700000    23.74600000   -29.92200000
C       -3.99300000    24.18400000   -31.23900000
C       -5.16300000    22.98500000   -29.51200000
C       -4.99200000    23.86300000   -32.15600000
C       -6.16400000    22.66300000   -30.41900000
C       -6.07700000    23.10200000   -31.73600000
H       -3.29400000    23.99000000   -29.22100000
H       -3.14700000    24.78200000   -31.54800000
H       -5.22800000    22.64400000   -28.48700000
H       -7.01500000    22.07900000   -30.09700000
H       -4.64500000    25.40500000   -33.54800000
H       -5.86800000    24.25500000   -34.07100000
H       -6.86400000    22.84800000   -32.43100000
H       -4.13140900    23.82097000   -34.16957000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-081VAL-1')] = qcdb.Molecule("""
0 1
C       -1.74800000    -4.46400000     0.95600000
C       -1.99400000    -3.39100000     4.55300000
C       -1.28200000    -3.42700000     3.34300000
C       -2.06900000    -4.16200000     2.40000000
C       -3.17800000    -4.53500000     3.05500000
C       -1.54000000    -2.72000000     5.66800000
C       -0.32300000    -2.10000000     5.56200000
C       -0.07100000    -2.73800000     3.26000000
C        0.40700000    -2.11200000     4.37900000
N       -3.14300000    -4.07800000     4.33700000
H       -3.91200000    -4.17900000     4.99000000
H       -2.12900000    -2.63400000     6.56700000
H       -3.99900000    -5.09500000     2.61500000
H        0.07300000    -1.56500000     6.41500000
H        0.47900000    -2.71300000     2.33300000
H       -1.36800000    -3.55800000     0.48300000
H       -2.67800000    -4.70000000     0.44700000
H        1.35600000    -1.59800000     4.33600000
H       -1.03258800    -5.28859100     0.82096240
--
0 1
C       -4.34800000    -0.67600000     3.78400000
C       -3.56400000     0.33700000     4.62400000
H       -4.72700000    -0.20200000     2.87800000
H       -3.69800000    -1.49800000     3.49600000
H       -5.17900000    -1.08800000     4.35500000
H       -3.33800000    -0.12500000     5.58600000
H       -4.15413700     1.24935100     4.79533000
H       -2.61514200     0.57890830     4.12285300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TRP-081VAL-2')] = qcdb.Molecule("""
0 1
C       -1.74800000    -4.46400000     0.95600000
C       -1.99400000    -3.39100000     4.55300000
C       -1.28200000    -3.42700000     3.34300000
C       -2.06900000    -4.16200000     2.40000000
C       -3.17800000    -4.53500000     3.05500000
C       -0.32300000    -2.10000000     5.56200000
C       -1.54000000    -2.72000000     5.66800000
C        0.40700000    -2.11200000     4.37900000
C       -0.07100000    -2.73800000     3.26000000
N       -3.14300000    -4.07800000     4.33700000
H        0.07300000    -1.56500000     6.41500000
H       -2.12900000    -2.63400000     6.56700000
H        1.35600000    -1.59800000     4.33600000
H        0.47900000    -2.71300000     2.33300000
H       -3.91200000    -4.17900000     4.99000000
H       -3.99900000    -5.09500000     2.61500000
H       -1.36800000    -3.55800000     0.48300000
H       -2.67800000    -4.70000000     0.44700000
H       -1.03258800    -5.28859100     0.82096240
--
0 1
C       -2.25000000     0.67200000     3.93000000
C       -3.56400000     0.33700000     4.62400000
H       -1.64900000     1.33400000     4.55200000
H       -1.68300000    -0.24200000     3.75500000
H       -2.44400000     1.15500000     2.97100000
H       -3.33800000    -0.12500000     5.58600000
H       -4.15413700     1.24935100     4.79533000
H       -4.12699600    -0.39044270     4.02079000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TYR-017GLU-1')] = qcdb.Molecule("""
0 1
C      -10.13700000    -2.84600000     3.96000000
C      -14.23900000    -3.06100000     5.25300000
C      -13.89500000    -3.37200000     3.94600000
C      -13.25200000    -2.69100000     6.16800000
C      -12.56800000    -3.30900000     3.55200000
C      -11.91600000    -2.63200000     5.76000000
C      -11.56500000    -2.95200000     4.44700000
O      -15.54700000    -3.13100000     5.61200000
H      -16.10900000    -3.38100000     4.87600000
H      -14.65600000    -3.65400000     3.23200000
H      -13.53000000    -2.45500000     7.18300000
H      -12.30800000    -3.53100000     2.52900000
H      -11.15200000    -2.33700000     6.46400000
H       -9.89200000    -3.72800000     3.36800000
H       -9.46100000    -2.80700000     4.81100000
H      -10.01230000    -1.94297900     3.34436900
--
-1 1
C      -15.88600000    -2.72800000    10.21100000
C      -16.65200000    -2.53700000     8.92000000
O      -16.05800000    -2.03800000     7.94800000
O      -17.85400000    -2.88400000     8.89500000
H      -15.51700000    -3.75500000    10.25200000
H      -16.52500000    -2.59300000    11.07600000
H      -15.02251000    -2.05026700    10.28211000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TYR-049PRO-1')] = qcdb.Molecule("""
0 1
C      -10.13700000    -2.84600000     3.96000000
C      -14.23900000    -3.06100000     5.25300000
C      -13.89500000    -3.37200000     3.94600000
C      -13.25200000    -2.69100000     6.16800000
C      -12.56800000    -3.30900000     3.55200000
C      -11.91600000    -2.63200000     5.76000000
C      -11.56500000    -2.95200000     4.44700000
O      -15.54700000    -3.13100000     5.61200000
H      -14.65600000    -3.65400000     3.23200000
H      -16.10900000    -3.38100000     4.87600000
H      -13.53000000    -2.45500000     7.18300000
H      -12.30800000    -3.53100000     2.52900000
H      -11.15200000    -2.33700000     6.46400000
H       -9.89200000    -3.72800000     3.36800000
H       -9.46100000    -2.80700000     4.81100000
H      -10.01230000    -1.94297900     3.34436900
--
0 1
C      -14.41500000    -6.87900000     4.91100000
C      -13.26800000    -6.43100000     5.78300000
C      -14.13200000    -8.34700000     4.63200000
H      -14.46600000    -6.30000000     3.98900000
H      -15.35200000    -6.80200000     5.44600000
H      -12.42800000    -6.12700000     5.15700000
H      -13.58800000    -5.61500000     6.42800000
H      -13.52800000    -8.46700000     3.74300000
H      -15.06600000    -8.89300000     4.49100000
H      -13.00957000    -7.33886700     6.34779500
H      -13.60934000    -8.71056000     5.52902200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TYR-052TYR-1')] = qcdb.Molecule("""
0 1
C      -10.13700000    -2.84600000     3.96000000
C      -12.56800000    -3.30900000     3.55200000
C      -11.56500000    -2.95200000     4.44700000
C      -13.89500000    -3.37200000     3.94600000
C      -14.23900000    -3.06100000     5.25300000
C      -11.91600000    -2.63200000     5.76000000
C      -13.25200000    -2.69100000     6.16800000
O      -15.54700000    -3.13100000     5.61200000
H      -12.30800000    -3.53100000     2.52900000
H      -14.65600000    -3.65400000     3.23200000
H       -9.89200000    -3.72800000     3.36800000
H       -9.46100000    -2.80700000     4.81100000
H      -11.15200000    -2.33700000     6.46400000
H      -16.10900000    -3.38100000     4.87600000
H      -13.53000000    -2.45500000     7.18300000
H      -10.01230000    -1.94297900     3.34436900
--
0 1
C       -9.23400000    -7.40300000     2.80100000
C      -12.57300000    -6.23900000     1.43200000
C      -12.18000000    -5.22000000     0.57900000
C      -11.61400000    -6.93400000     2.15000000
C      -10.26500000    -6.62600000     2.03100000
C      -10.83200000    -4.90000000     0.44300000
C       -9.88100000    -5.60400000     1.17200000
O      -13.12500000    -4.53300000    -0.12000000
H      -13.62100000    -6.48400000     1.52900000
H      -11.89600000    -7.73200000     2.81000000
H      -10.52800000    -4.10500000    -0.22100000
H      -12.73100000    -3.85700000    -0.68400000
H       -9.58900000    -7.58200000     3.81500000
H       -8.34400000    -6.77700000     2.88500000
H       -8.83900000    -5.34400000     1.09500000
H       -8.97049500    -8.35865400     2.32425000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010TYR-163TYR-1')] = qcdb.Molecule("""
0 1
C       47.42400000    24.18900000     3.29900000
C       48.14600000    21.77000000     3.44200000
C       48.10900000    22.96700000     2.71700000
C       48.76400000    20.63100000     2.92100000
C       49.32100000    20.66400000     1.65200000
C       48.68300000    22.99000000     1.44200000
C       49.29300000    21.84600000     0.91800000
O       49.91400000    19.53900000     1.14700000
H       47.70000000    21.72800000     4.42700000
H       48.78500000    19.71600000     3.49400000
H       46.78300000    23.86100000     4.11700000
H       46.76700000    24.62000000     2.54200000
H       48.66300000    23.90200000     0.86200000
H       49.91100000    18.81300000     1.78000000
H       49.75700000    21.86500000    -0.05500000
H       48.10428000    24.96431000     3.68125400
--
0 1
C       44.51500000    20.69400000     5.37000000
C       46.22600000    18.89200000     4.94500000
C       44.90400000    19.32000000     4.87800000
C       46.58500000    17.60500000     4.50400000
C       45.61100000    16.74500000     4.01700000
C       43.93400000    18.43800000     4.39600000
C       44.28300000    17.15700000     3.95400000
O       45.97400000    15.49400000     3.62700000
H       46.98600000    19.55800000     5.32800000
H       47.61600000    17.28400000     4.55400000
H       43.43900000    20.83300000     5.25100000
H       45.02600000    21.43500000     4.75500000
H       42.89900000    18.75000000     4.36500000
H       46.92500000    15.35900000     3.61800000
H       43.53700000    16.47300000     3.57800000
H       44.79207000    20.87273000     6.41942200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010VAL-027ALA-1')] = qcdb.Molecule("""
0 1
C        6.89300000    68.14300000     6.81100000
C        7.59800000    68.46800000     8.12100000
H        5.92100000    68.63200000     6.74500000
H        7.49500000    68.51200000     5.98000000
H        6.77400000    67.06600000     6.70300000
H        7.67600000    69.55300000     8.18400000
H        7.00338900    68.13056000     8.98272500
H        8.62493900    68.07380000     8.11955900
--
0 1
C        9.42100000    67.07600000     4.36000000
C       10.34200000    66.57900000     3.25100000
H        8.37700000    66.89000000     4.10300000
H        9.66000000    66.57200000     5.29500000
H        9.56300000    68.14800000     4.50400000
H       11.37100000    66.63800000     3.61400000
H       10.24582000    67.22576000     2.36643800
H       10.13804000    65.52699000     3.00266800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010VAL-028LEU-1')] = qcdb.Molecule("""
0 1
C       -5.63900000    23.96600000    -8.75400000
C       -5.47100000    22.52500000    -9.21400000
H       -6.69300000    24.23800000    -8.76500000
H       -5.25300000    24.07700000    -7.74100000
H       -5.09300000    24.63600000    -9.42200000
H       -5.98700000    21.87200000    -8.51400000
H       -5.92215000    22.38482000   -10.20738000
H       -4.40494500    22.25508000    -9.18815600
--
0 1
C       -8.78200000    22.78500000    -7.05000000
C       -9.06700000    22.96400000    -5.55900000
H       -9.01400000    23.70000000    -7.59200000
H       -7.72500000    22.56100000    -7.17500000
H       -9.36100000    21.96100000    -7.46100000
H       -8.41500000    23.76800000    -5.21800000
H      -10.09768000    23.29373000    -5.36159000
H       -8.78642100    22.06270000    -4.99425400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010VAL-034TYR-1')] = qcdb.Molecule("""
0 1
C        6.89300000    68.14300000     6.81100000
C        7.59800000    68.46800000     8.12100000
H        5.92100000    68.63200000     6.74500000
H        7.49500000    68.51200000     5.98000000
H        6.77400000    67.06600000     6.70300000
H        7.67600000    69.55300000     8.18400000
H        7.00338900    68.13056000     8.98272500
H        8.62493900    68.07380000     8.11955900
--
0 1
C        3.98700000    66.35100000     5.52800000
C        3.76000000    65.54200000     6.82500000
C        3.13100000    65.87800000     4.36700000
C        1.87700000    66.45300000     4.13100000
C        3.56900000    64.84600000     3.52100000
C        1.07200000    66.01600000     3.08200000
C        2.75700000    64.38900000     2.46800000
C        1.50500000    64.98000000     2.25700000
O        0.70100000    64.54800000     1.24100000
H        3.77400000    67.40300000     5.72600000
H        5.03700000    66.28000000     5.24300000
H        4.35800000    65.99500000     7.61100000
H        1.52400000    67.25200000     4.77000000
H        4.53800000    64.39000000     3.68600000
H        0.11300000    66.47500000     2.91600000
H        3.08900000    63.58800000     1.82200000
H       -0.12900000    65.03600000     1.20300000
H        4.07545800    64.49374000     6.71708000
H        2.70740700    65.59123000     7.14063300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010VAL-040PHE-1')] = qcdb.Molecule("""
0 1
C       -5.47100000    22.52500000    -9.21400000
C       -6.10500000    22.32800000   -10.61000000
C       -3.98600000    22.14900000    -9.17800000
C       -5.63900000    23.96600000    -8.75400000
H       -5.98700000    21.87200000    -8.51400000
H       -5.83900000    23.17500000   -11.23300000
H       -3.43400000    22.71400000    -9.92700000
H       -3.57700000    22.38100000    -8.19400000
H       -3.83400000    21.08500000    -9.34700000
H       -6.69300000    24.23800000    -8.76500000
H       -5.25300000    24.07700000    -7.74100000
H       -5.09300000    24.63600000    -9.42200000
H       -7.19990800    22.24678000   -10.54232000
H       -5.71555700    21.41882000   -11.09137000
--
0 1
C       -4.66900000    24.66100000    -2.82500000
C       -4.75400000    21.93700000    -5.48200000
C       -3.76500000    21.06600000    -5.02900000
C       -5.03700000    23.10200000    -4.77000000
C       -4.33100000    23.41300000    -3.60500000
C       -3.05600000    21.36500000    -3.86300000
C       -3.34600000    22.53300000    -3.15000000
H       -5.31300000    21.69300000    -6.37200000
H       -3.54700000    20.15900000    -5.57700000
H       -5.81200000    23.76600000    -5.12600000
H       -2.28900000    20.69000000    -3.51100000
H       -4.63300000    24.42100000    -1.76100000
H       -5.69500000    24.95600000    -3.05300000
H       -2.80200000    22.75100000    -2.24300000
H       -3.99510900    25.50894000    -3.01702600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '010VAL-044ALA-1')] = qcdb.Molecule("""
0 1
C       -3.98600000    22.14900000    -9.17800000
C       -5.47100000    22.52500000    -9.21400000
H       -3.43400000    22.71400000    -9.92700000
H       -3.57700000    22.38100000    -8.19400000
H       -3.83400000    21.08500000    -9.34700000
H       -5.98700000    21.87200000    -8.51400000
H       -5.92215000    22.38482000   -10.20738000
H       -5.59242400    23.56650000    -8.88153000
--
0 1
C       -1.83100000    24.93100000    -8.52500000
C       -0.52600000    25.70200000    -8.37800000
H       -2.67300000    25.61300000    -8.62800000
H       -1.77700000    24.30400000    -9.41500000
H       -1.98700000    24.29600000    -7.65200000
H        0.28700000    24.97500000    -8.33000000
H       -0.52902020    26.28187000    -7.44325900
H       -0.34774800    26.32876000    -9.26422900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ALA-016GLU-1')] = qcdb.Molecule("""
0 1
C       16.48200000    22.63900000     4.01200000
C       16.77900000    24.03200000     4.52900000
H       16.57000000    22.61800000     2.92600000
H       17.19000000    21.92700000     4.42900000
H       15.47600000    22.34200000     4.29100000
H       16.63600000    24.03400000     5.61100000
H       16.08550000    24.76108000     4.08458600
H       17.82853000    24.28380000     4.31665600
--
0 1
C       17.09300000    21.35800000     7.46000000
C       16.50800000    19.94900000     7.37000000
C       17.99000000    21.52700000     8.67800000
H       17.67100000    21.56800000     6.56100000
H       16.27500000    22.07600000     7.52900000
H       16.02900000    19.71300000     8.31300000
H       17.35500000    21.37800000     9.55600000
H       18.75300000    20.75700000     8.74100000
H       17.31882000    19.22735000     7.19166600
H       15.74686000    19.90228000     6.57723300
H       18.44077000    22.52637000     8.76786300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ASP-091ASN-1')] = qcdb.Molecule("""
-1 1
C       27.83800000    -9.55300000     7.32400000
C       27.86100000   -11.02600000     6.96800000
O       28.47600000   -11.37600000     5.93600000
O       27.26800000   -11.83800000     7.71800000
H       27.92000000    -8.93700000     6.42600000
H       28.72100000    -9.35800000     7.93400000
H       26.93330000    -9.27374600     7.88394700
--
0 1
C       23.72400000   -14.08000000     5.93500000
C       24.28400000   -12.91700000     5.12800000
O       23.94600000   -12.72900000     3.96200000
N       25.14700000   -12.12500000     5.74300000
H       25.54800000   -11.36300000     5.21100000
H       25.53200000   -12.34100000     6.65600000
H       22.74800000   -13.77800000     6.31700000
H       24.37900000   -14.28100000     6.78500000
H       23.61392000   -14.99298000     5.33138400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011CYS-042VAL-1')] = qcdb.Molecule("""
0 1
C        3.20200000    70.66800000    10.76100000
C        4.07300000    70.66400000     9.50900000
S        1.74100000    71.73800000    10.62600000
H        2.87300000    69.64500000    10.95000000
H        3.80900000    71.00200000    11.60500000
H        3.48600000    70.28000000     8.67000000
H        1.37700000    71.71500000    11.91400000
H        4.97135200    70.05021000     9.67096100
H        4.41791600    71.68350000     9.28171900
--
0 1
C        2.50400000    68.03500000    13.21000000
C        3.65400000    68.03500000    14.21900000
H        1.68700000    67.40700000    13.56700000
H        2.12500000    69.04800000    13.08900000
H        2.85100000    67.65600000    12.24700000
H        3.27700000    68.39800000    15.17400000
H        4.03252200    67.01085000    14.35255000
H        4.44770900    68.72279000    13.89193000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011CYS-042VAL-2')] = qcdb.Molecule("""
0 1
C        3.20200000    70.66800000    10.76100000
C        4.07300000    70.66400000     9.50900000
S        1.74100000    71.73800000    10.62600000
H        2.87300000    69.64500000    10.95000000
H        3.80900000    71.00200000    11.60500000
H        3.48600000    70.28000000     8.67000000
H        1.37700000    71.71500000    11.91400000
H        4.97135200    70.05021000     9.67096100
H        4.41791600    71.68350000     9.28171900
--
0 1
C        4.76300000    68.99600000    13.76200000
C        3.65400000    68.03500000    14.21900000
H        5.21600000    68.64000000    12.83500000
H        4.34200000    69.98600000    13.59200000
H        5.52900000    69.10100000    14.53200000
H        3.27700000    68.39800000    15.17400000
H        4.03252200    67.01085000    14.35255000
H        2.82714600    68.03500000    13.49353000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011GLU-062TYR-1')] = qcdb.Molecule("""
-1 1
C       28.96100000    -8.00100000    57.60500000
C       28.58100000    -7.95300000    59.06600000
O       27.60300000    -7.24500000    59.37600000
O       29.19200000    -8.71800000    59.83300000
H       28.41800000    -8.82500000    57.13600000
H       30.02700000    -8.20000000    57.49900000
H       28.70165000    -7.06549500    57.08773000
--
0 1
C       33.60100000    -6.03400000    64.70400000
C       29.89000000    -7.24500000    62.87100000
C       29.96900000    -7.06700000    64.25200000
C       31.00700000    -7.03200000    62.06500000
C       31.16900000    -6.66700000    64.82400000
C       32.21000000    -6.64100000    62.66700000
C       32.30100000    -6.44800000    64.04600000
O       28.68300000    -7.59300000    62.37700000
H       28.02700000    -7.66100000    63.07000000
H       29.11200000    -7.25100000    64.87000000
H       30.92600000    -7.15300000    60.99700000
H       31.22000000    -6.52400000    65.89400000
H       33.08200000    -6.47600000    62.04800000
H       33.35700000    -5.24800000    65.41600000
H       34.26600000    -5.59600000    63.95800000
H       34.11890000    -6.84640500    65.23483000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011GLU-100THR-1')] = qcdb.Molecule("""
-1 1
C       28.96100000    -8.00100000    57.60500000
C       28.58100000    -7.95300000    59.06600000
O       27.60300000    -7.24500000    59.37600000
O       29.19200000    -8.71800000    59.83300000
H       28.41800000    -8.82500000    57.13600000
H       30.02700000    -8.20000000    57.49900000
H       28.70165000    -7.06549500    57.08773000
--
0 1
C       25.69000000   -10.21700000    59.42400000
C       25.84000000    -9.82700000    60.88400000
C       26.53400000   -11.43900000    59.02600000
O       24.30000000   -10.49700000    59.20200000
H       25.98200000    -9.37800000    58.79300000
H       26.86000000    -9.49000000    61.06300000
H       26.19800000   -12.32600000    59.56400000
H       26.44100000   -11.61300000    57.95400000
H       27.58000000   -11.24800000    59.25800000
H       24.23600000   -10.96600000    58.35700000
H       25.55267000   -10.63287000    61.57539000
H       25.15321000    -8.99033300    61.07971000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011HIE-015ASN-1')] = qcdb.Molecule("""
0 1
C       -3.11000000    25.98700000   -19.92100000
C       -2.06600000    25.62200000   -16.46700000
C       -2.87100000    25.53500000   -18.51200000
C       -3.30200000    24.43100000   -17.84600000
N       -2.10000000    26.26100000   -17.62900000
N       -2.79400000    24.51400000   -16.56800000
H       -1.58900000    25.98900000   -15.56600000
H       -3.20200000    24.04300000   -15.76000000
H       -3.99400000    23.68400000   -18.21900000
H       -2.14200000    26.19100000   -20.37800000
H       -3.66200000    26.92300000   -19.87300000
H       -3.67930100    25.28815000   -20.55148000
--
0 1
C       -3.23000000    30.31500000   -15.45200000
C       -2.30200000    29.14100000   -15.19300000
O       -1.21400000    29.04900000   -15.76100000
N       -2.71900000    28.23700000   -14.32200000
H       -3.62600000    30.65600000   -14.49500000
H       -4.07500000    30.00000000   -16.05600000
H       -2.07200000    27.51800000   -14.05500000
H       -3.61300000    28.34700000   -13.86600000
H       -2.72031500    31.15753000   -15.94228000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011HIE-304SER-1')] = qcdb.Molecule("""
0 1
C       -3.11000000    25.98700000   -19.92100000
C       -3.30200000    24.43100000   -17.84600000
C       -2.87100000    25.53500000   -18.51200000
C       -2.06600000    25.62200000   -16.46700000
N       -2.79400000    24.51400000   -16.56800000
N       -2.10000000    26.26100000   -17.62900000
H       -3.99400000    23.68400000   -18.21900000
H       -3.20200000    24.04300000   -15.76000000
H       -2.14200000    26.19100000   -20.37800000
H       -3.66200000    26.92300000   -19.87300000
H       -1.58900000    25.98900000   -15.56600000
H       -3.67930100    25.28815000   -20.55148000
--
0 1
C       -2.08400000    21.33800000   -15.89400000
C       -1.36400000    20.08600000   -15.39200000
O       -1.23800000    22.46500000   -15.74300000
H       -2.36400000    21.23300000   -16.93500000
H       -2.99400000    21.49200000   -15.31500000
H       -1.94800000    19.20700000   -15.63900000
H       -1.61700000    23.22200000   -16.21400000
H       -1.18205400    20.17547000   -14.31085000
H       -0.39814630    19.99043000   -15.90968000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011HIE-306ASN-1')] = qcdb.Molecule("""
0 1
C       -3.11000000    25.98700000   -19.92100000
C       -3.90100000    25.01600000   -20.79700000
C       -2.87100000    25.53500000   -18.51200000
C       -3.30200000    24.43100000   -17.84600000
C       -2.06600000    25.62200000   -16.46700000
N       -2.10000000    26.26100000   -17.62900000
N       -2.79400000    24.51400000   -16.56800000
H       -2.14200000    26.19100000   -20.37800000
H       -3.66200000    26.92300000   -19.87300000
H       -4.89200000    24.89700000   -20.35300000
H       -3.99400000    23.68400000   -18.21900000
H       -1.58900000    25.98900000   -15.56600000
H       -3.20200000    24.04300000   -15.76000000
H       -3.40909700    24.03445000   -20.86480000
H       -4.01686700    25.48599000   -21.78477000
--
0 1
C        0.88500000    24.58400000   -18.16700000
C        0.26700000    24.51800000   -19.54700000
O        0.49500000    25.37900000   -20.39000000
N       -0.51200000    23.47500000   -19.80900000
H        0.10400000    24.55700000   -17.41700000
H        1.40800000    25.53600000   -18.08500000
H       -0.63700000    23.30300000   -20.79900000
H       -0.79400000    22.83000000   -19.09600000
H        1.60657500    23.77394000   -17.98499000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-017LEU-1')] = qcdb.Molecule("""
0 1
C       15.13500000    10.69600000    13.00600000
C       16.04300000    11.71300000    12.35300000
H       15.68700000     9.77100000    13.17100000
H       14.28900000    10.48300000    12.36100000
H       14.77800000    11.06800000    13.96600000
H       16.35600000    11.35300000    11.37200000
H       16.91400000    11.75900000    12.99400000
H       15.59887000    12.71498000    12.25931000
--
0 1
C       12.01300000     9.60100000    11.23300000
C       10.65700000     9.45900000    10.53700000
H       12.70700000    10.15300000    10.59900000
H       12.42700000     8.61700000    11.45900000
H       11.88400000    10.15100000    12.16600000
H       10.29500000    10.45500000    10.28900000
H       10.74544000     8.84850300     9.62624600
H        9.93016200     8.99567700    11.22040000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-018ALA-1')] = qcdb.Molecule("""
0 1
C      -11.80700000   -18.17900000   -19.18900000
C      -12.52600000   -17.07800000   -19.97000000
H      -11.12700000   -18.72700000   -19.84300000
H      -11.23900000   -17.75300000   -18.36200000
H      -12.52900000   -18.86600000   -18.75600000
H      -13.25400000   -16.61600000   -19.30300000
H      -13.05486000   -17.51361000   -20.83055000
H      -11.83655000   -16.30308000   -20.33627000
--
0 1
C       -7.98900000   -18.35600000   -19.34200000
C       -6.84600000   -18.67800000   -20.30000000
H       -8.54500000   -19.26100000   -19.09100000
H       -7.60200000   -17.90600000   -18.42700000
H       -8.66900000   -17.64300000   -19.81200000
H       -6.26900000   -17.77600000   -20.51500000
H       -7.26041800   -19.11995000   -21.21812000
H       -6.18301800   -19.43168000   -19.85009000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-024ILE-1')] = qcdb.Molecule("""
0 1
C       34.89900000    23.50400000    -0.48200000
C       35.31600000    22.08100000    -0.87900000
H       35.76500000    24.16700000    -0.46300000
H       34.16500000    23.90800000    -1.17400000
H       34.43200000    23.50800000     0.50400000
H       34.45800000    21.42200000    -0.74500000
H       36.14413000    21.74047000    -0.24005820
H       35.62709000    22.04301000    -1.93341000
--
0 1
C       37.98500000    24.99000000    -2.17900000
C       39.12800000    25.84000000    -1.62000000
H       37.91600000    24.07900000    -1.58700000
H       37.04000000    25.53100000    -2.12800000
H       38.14200000    24.73400000    -3.22700000
H       39.20700000    26.74200000    -2.22300000
H       40.07497000    25.28140000    -1.65504600
H       38.91315000    26.12240000    -0.57880250
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-024ILE-2')] = qcdb.Molecule("""
0 1
C       35.75000000    22.02800000    -2.35000000
C       35.31600000    22.08100000    -0.87900000
C       34.64100000    22.36500000    -3.33500000
H       36.57500000    22.70800000    -2.52800000
H       36.11300000    21.03900000    -2.60000000
H       34.45800000    21.42200000    -0.74500000
H       34.40700000    23.42700000    -3.29100000
H       34.97900000    22.13400000    -4.34600000
H       33.75000000    21.77400000    -3.11700000
H       36.14413000    21.74047000    -0.24005820
H       35.01719000    23.10070000    -0.59451710
--
0 1
C       37.98500000    24.99000000    -2.17900000
C       39.12800000    25.84000000    -1.62000000
H       37.91600000    24.07900000    -1.58700000
H       37.04000000    25.53100000    -2.12800000
H       38.14200000    24.73400000    -3.22700000
H       39.20700000    26.74200000    -2.22300000
H       40.07497000    25.28140000    -1.65504600
H       38.91315000    26.12240000    -0.57880250
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-028LEU-1')] = qcdb.Molecule("""
0 1
C      -11.80700000   -18.17900000   -19.18900000
C      -12.52600000   -17.07800000   -19.97000000
H      -11.12700000   -18.72700000   -19.84300000
H      -11.23900000   -17.75300000   -18.36200000
H      -12.52900000   -18.86600000   -18.75600000
H      -13.25400000   -16.61600000   -19.30300000
H      -13.05486000   -17.51361000   -20.83055000
H      -11.83655000   -16.30308000   -20.33627000
--
0 1
C      -13.21300000   -21.05100000   -17.15400000
C      -12.59000000   -21.72600000   -15.95100000
H      -13.46300000   -20.01700000   -16.91200000
H      -12.49900000   -21.05500000   -17.97900000
H      -14.10800000   -21.58600000   -17.47100000
H      -11.61100000   -21.29500000   -15.74800000
H      -13.24141000   -21.61954000   -15.07104000
H      -12.47854000   -22.77659000   -16.25733000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-037LEU-1')] = qcdb.Molecule("""
0 1
C        4.71500000    -2.40400000    18.95200000
C        4.97600000    -3.24600000    20.20500000
H        5.02600000    -2.94100000    18.05700000
H        3.64800000    -2.19300000    18.87500000
H        5.26900000    -1.46900000    19.02400000
H        4.56400000    -4.24500000    20.05300000
H        4.41700000    -2.78700000    21.01800000
H        6.03737200    -3.32196600    20.48378000
--
0 1
C        3.23700000     0.72200000    17.83800000
C        3.67000000     1.25400000    16.47600000
H        2.86300000     1.54000000    18.45400000
H        2.44900000    -0.02100000    17.71000000
H        4.08500000     0.26500000    18.34100000
H        3.89500000     0.40500000    15.83200000
H        4.58073300     1.85900200    16.59657000
H        2.84780200     1.82349100    16.01810000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-038TYR-1')] = qcdb.Molecule("""
0 1
C       34.64100000    22.36500000    -3.33500000
C       35.75000000    22.02800000    -2.35000000
H       34.40700000    23.42700000    -3.29100000
H       34.97900000    22.13400000    -4.34600000
H       33.75000000    21.77400000    -3.11700000
H       36.57500000    22.70800000    -2.52800000
H       36.11300000    21.03900000    -2.60000000
H       35.43891000    22.06599000    -1.29559000
--
0 1
C       32.69800000    23.87200000    -5.89300000
C       31.56600000    24.87500000    -6.11900000
C       32.51700000    22.57800000    -6.64800000
C       33.03600000    22.41800000    -7.93400000
C       31.80200000    21.52000000    -6.07400000
C       32.84500000    21.22400000    -8.64000000
C       31.60800000    20.32300000    -6.76900000
C       32.13100000    20.17700000    -8.05200000
O       31.94400000    19.00400000    -8.72300000
H       33.66200000    24.32100000    -6.14000000
H       32.71900000    23.62200000    -4.83400000
H       30.64500000    24.31900000    -6.31000000
H       33.58600000    23.22200000    -8.38600000
H       31.39400000    21.62700000    -5.07700000
H       33.25700000    21.10100000    -9.62800000
H       31.06000000    19.50800000    -6.31900000
H       32.33600000    19.02300000    -9.60300000
H       31.78679000    25.53737000    -6.96900800
H       31.41027000    25.46677000    -5.20491100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-042LEU-1')] = qcdb.Molecule("""
0 1
C       34.89900000    23.50400000    -0.48200000
C       35.31600000    22.08100000    -0.87900000
H       35.76500000    24.16700000    -0.46300000
H       34.16500000    23.90800000    -1.17400000
H       34.43200000    23.50800000     0.50400000
H       34.45800000    21.42200000    -0.74500000
H       36.14413000    21.74047000    -0.24005820
H       35.62709000    22.04301000    -1.93341000
--
0 1
C       31.29700000    23.40800000    -1.03100000
C       29.81500000    23.63600000    -1.29500000
H       31.48700000    23.36500000     0.04300000
H       31.61300000    22.47100000    -1.49100000
H       31.86900000    24.22600000    -1.47100000
H       29.67000000    23.68100000    -2.37100000
H       29.49910000    24.58085000    -0.82866520
H       29.21559000    22.79740000    -0.91100170
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011ILE-045VAL-1')] = qcdb.Molecule("""
0 1
C       14.28300000    13.15600000    11.20100000
C       15.42200000    13.11400000    12.22200000
H       13.85500000    14.15500000    11.12500000
H       13.48300000    12.48100000    11.50800000
H       14.64500000    12.84600000    10.21900000
H       15.01400000    13.40800000    13.18100000
H       16.18523000    13.84918000    11.92707000
H       15.86613000    12.11202000    12.31569000
--
0 1
C       11.24600000    14.99900000    12.27300000
C       10.19600000    14.25100000    13.08800000
H       12.22300000    14.85800000    12.73800000
H       11.04100000    16.06800000    12.26000000
H       11.28600000    14.62300000    11.25100000
H       10.24500000    14.62100000    14.11200000
H        9.17083400    14.41058000    12.72253000
H       10.41303000    13.17305000    13.11828000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011LEU-062HIE-2')] = qcdb.Molecule("""
0 1
C       12.26100000    21.30600000    14.22300000
C       13.26300000    20.83900000    13.16000000
C       11.78700000    20.24400000    15.22500000
H       12.71900000    22.12200000    14.78500000
H       11.38700000    21.71600000    13.71500000
H       14.15000000    20.45000000    13.66200000
H       11.30700000    19.42600000    14.69700000
H       13.58005000    21.68847000    12.53720000
H       12.84020000    20.02000000    12.55959000
H       12.63607000    19.81910000    15.78047000
H       11.04663000    20.68087000    15.91130000
--
0 1
C        5.34000000    19.61000000    12.78600000
C        8.93100000    20.05100000    12.96000000
C        6.75400000    20.08500000    12.67900000
C        7.27600000    21.15000000    12.02000000
N        7.80900000    19.40000000    13.24700000
N        8.63600000    21.11500000    12.22200000
H        9.92400000    19.72000000    13.21300000
H        9.31700000    21.75400000    11.81800000
H        6.72300000    21.89700000    11.48300000
H        4.66300000    20.45800000    12.69200000
H        5.21200000    19.19900000    13.78900000
H        5.09520000    18.83672000    12.04296000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011LEU-069TYR-1')] = qcdb.Molecule("""
0 1
C       10.29700000    -3.97500000     8.83500000
C       10.75200000    -5.28700000     9.45900000
H        9.31900000    -3.68300000     9.21500000
H       11.02900000    -3.23000000     9.12400000
H       10.27600000    -4.04200000     7.75000000
H       11.67800000    -5.60800000     8.98000000
H        9.97612700    -6.05497100     9.32394100
H       10.93369000    -5.14064200    10.53397000
--
0 1
C        8.73700000    -3.63400000     3.54000000
C        8.53100000    -2.49200000     5.78900000
C        8.71600000    -2.39300000     4.40500000
C        8.56900000    -1.35300000     6.60100000
C        8.93200000    -1.13200000     3.84400000
C        8.79500000    -0.10200000     6.02700000
C        8.97100000     0.01400000     4.64600000
O        8.86600000     1.00900000     6.80600000
H        8.36100000    -3.46200000     6.23900000
H        8.43400000    -1.43300000     7.66900000
H        8.12300000    -3.45200000     2.65900000
H        8.29500000    -4.45800000     4.10000000
H        9.07600000    -1.04300000     2.77800000
H        9.13400000     0.98000000     4.19200000
H        8.92900000     1.81400000     6.29300000
H        9.74667400    -3.92534900     3.21492400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011LEU-071GLU-1')] = qcdb.Molecule("""
0 1
C       10.29700000    -3.97500000     8.83500000
C       10.75200000    -5.28700000     9.45900000
H        9.31900000    -3.68300000     9.21500000
H       11.02900000    -3.23000000     9.12400000
H       10.27600000    -4.04200000     7.75000000
H       11.67800000    -5.60800000     8.98000000
H        9.97612700    -6.05497100     9.32394100
H       10.93369000    -5.14064200    10.53397000
--
-1 1
C       11.24700000    -0.42600000     8.69400000
C       12.67000000    -0.40500000     9.23900000
C       10.21400000    -0.01300000     9.73300000
O       10.40400000    -0.31300000    10.93100000
O        9.20000000     0.61300000     9.35500000
H       11.22600000     0.30100000     7.88000000
H       10.99000000    -1.38100000     8.25200000
H       12.74800000    -1.16900000    10.00000000
H       12.86700000     0.57000000     9.68500000
H       13.42597000    -0.59507290     8.46286900
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011LEU-102TYR-1')] = qcdb.Molecule("""
0 1
C        5.27400000    -7.52000000    -6.44000000
C        5.12100000    -8.96400000    -5.94300000
C        6.67600000    -7.13900000    -6.92300000
H        4.56700000    -7.34500000    -7.25100000
H        5.00600000    -6.85300000    -5.62100000
H        5.34800000    -9.66900000    -6.74200000
H        7.39700000    -7.35400000    -6.13500000
H        4.07853500    -9.10385200    -5.62096200
H        5.80450200    -9.11957100    -5.09528400
H        6.95241400    -7.72358200    -7.81286400
H        6.73409600    -6.05812800    -7.11880500
--
0 1
C        5.18100000    -1.90500000    -9.44800000
C        3.15700000    -4.46400000    -7.47400000
C        3.56200000    -4.17700000    -6.16500000
C        3.68100000    -3.72000000    -8.53500000
C        4.60600000    -2.70000000    -8.30500000
C        4.47200000    -3.15200000    -5.92600000
C        4.98700000    -2.42000000    -6.99300000
O        3.10200000    -4.89200000    -5.10600000
H        2.45400000    -5.26000000    -7.65600000
H        3.37800000    -3.94800000    -9.54900000
H        4.78900000    -2.92700000    -4.91700000
H        3.47700000    -4.57500000    -4.28300000
H        5.00100000    -2.42800000   -10.38900000
H        6.26200000    -1.83700000    -9.31000000
H        5.70400000    -1.63200000    -6.79900000
H        4.76357400    -0.88897350    -9.50670100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011LEU-102TYR-2')] = qcdb.Molecule("""
0 1
C        6.75700000    -5.63200000    -7.19600000
C        6.67600000    -7.13900000    -6.92300000
H        6.41600000    -5.08400000    -6.32000000
H        7.78200000    -5.35700000    -7.37400000
H        6.13800000    -5.36800000    -8.05200000
H        7.39700000    -7.35400000    -6.13500000
H        5.66870500    -7.41273700    -6.57597900
H        6.95241400    -7.72358200    -7.81286400
--
0 1
C        5.18100000    -1.90500000    -9.44800000
C        3.15700000    -4.46400000    -7.47400000
C        3.56200000    -4.17700000    -6.16500000
C        3.68100000    -3.72000000    -8.53500000
C        4.60600000    -2.70000000    -8.30500000
C        4.47200000    -3.15200000    -5.92600000
C        4.98700000    -2.42000000    -6.99300000
O        3.10200000    -4.89200000    -5.10600000
H        2.45400000    -5.26000000    -7.65600000
H        3.37800000    -3.94800000    -9.54900000
H        4.78900000    -2.92700000    -4.91700000
H        3.47700000    -4.57500000    -4.28300000
H        5.00100000    -2.42800000   -10.38900000
H        6.26200000    -1.83700000    -9.31000000
H        5.70400000    -1.63200000    -6.79900000
H        4.76357400    -0.88897350    -9.50670100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011PHE-044TYR-1')] = qcdb.Molecule("""
0 1
C        3.03500000    -4.98400000     3.67700000
C        5.77500000    -2.32800000     3.82400000
C        4.52800000    -2.95800000     3.62300000
C        6.81000000    -3.04300000     4.38700000
C        4.34400000    -4.30300000     3.95100000
C        6.64300000    -4.37900000     4.67200000
C        5.42000000    -5.02300000     4.45900000
H        5.90500000    -1.28400000     3.57400000
H        3.70900000    -2.38700000     3.21400000
H        7.76300000    -2.56700000     4.57200000
H        7.47200000    -4.93900000     5.08300000
H        2.24400000    -4.41900000     4.17100000
H        3.04000000    -5.98900000     4.10100000
H        5.31300000    -6.07400000     4.69300000
H        2.81830300    -5.03925100     2.59997200
--
0 1
C        5.64900000     3.52600000     3.18400000
C        7.20300000     0.73500000     5.24600000
C        6.95200000     1.17100000     6.52500000
C        6.78600000     1.49400000     4.15100000
C        6.11700000     2.69100000     4.33800000
C        6.26200000     2.34600000     6.72000000
C        5.84200000     3.09500000     5.63400000
O        7.37100000     0.41700000     7.58400000
H        7.73100000    -0.19400000     5.09900000
H        6.98600000     1.13900000     3.15000000
H        6.05000000     2.68900000     7.72200000
H        7.12200000     0.80900000     8.42800000
H        5.19500000     4.43800000     3.56600000
H        4.87200000     2.96800000     2.66100000
H        5.31500000     4.02400000     5.81000000
H        6.43701200     3.79658700     2.46579400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011PRO-020ILE-1')] = qcdb.Molecule("""
0 1
C        4.86100000     2.07600000     6.44000000
C        5.06800000     0.93900000     7.41300000
C        4.62900000     3.29600000     7.31000000
H        3.98700000     1.88700000     5.81900000
H        5.74400000     2.23500000     5.82400000
H        4.53900000     0.04600000     7.07700000
H        6.13500000     0.73800000     7.52200000
H        4.04200000     4.06300000     6.80800000
H        5.59300000     3.71100000     7.61100000
H        4.65750200     1.31659900     8.36110900
H        4.11831300     2.89734400     8.19897300
--
0 1
C        5.43200000    -0.19400000     3.96600000
C        5.89300000    -0.53900000     2.53600000
H        5.81100000     0.78400000     4.23900000
H        4.34700000    -0.20200000     4.01400000
H        5.80200000    -0.93400000     4.67700000
H        5.62700000    -1.58000000     2.34300000
H        6.98575500    -0.43731500     2.46152700
H        5.36401400     0.05727217     1.77795400
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011SER-223GLU-1')] = qcdb.Molecule("""
0 1
C       16.29700000    11.69300000    -0.74200000
O       16.97800000    12.75700000    -0.08500000
H       17.03700000    12.56000000     0.87600000
H       15.86800000    12.06600000    -1.67400000
H       15.48500000    11.33600000    -0.10700000
H       16.97504000    10.85866000    -0.97467390
--
-1 1
C       17.27500000    11.54800000     4.70400000
C       17.04400000    11.65200000     3.21500000
O       17.35700000    12.72700000     2.65600000
O       16.57600000    10.67400000     2.58000000
H       17.53900000    12.52600000     5.11300000
H       18.12000000    10.88600000     4.88600000
H       16.40024000    11.16460000     5.24971500
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011THR-017ALA-1')] = qcdb.Molecule("""
0 1
C       23.31000000    23.07900000    32.69300000
C       23.48300000    21.61800000    32.31600000
H       22.64600000    23.60900000    32.03100000
H       22.91300000    23.14200000    33.70700000
H       24.28000000    23.57600000    32.68600000
H       24.26300000    21.18300000    32.94200000
H       23.77734000    21.53134000    31.25966000
H       22.55420000    21.05395000    32.48683000
--
0 1
C       22.27100000    26.36500000    33.28200000
C       22.54100000    27.55900000    34.18100000
H       21.60500000    26.64700000    32.46400000
H       23.21100000    25.99900000    32.86900000
H       21.80400000    25.56600000    33.85900000
H       23.21200000    27.24000000    34.98000000
H       21.59342000    27.90688000    34.61811000
H       23.03940000    28.35875000    33.61355000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011THR-166GLU-1')] = qcdb.Molecule("""
0 1
C       51.76600000    25.18900000     7.23000000
C       50.79200000    24.15000000     7.76300000
H       51.26100000    25.89100000     6.57100000
H       52.20800000    25.73500000     8.06400000
H       52.56300000    24.69000000     6.67900000
H       51.34200000    23.46200000     8.40700000
H       50.33136000    23.58850000     6.93684700
H       50.02084000    24.65897000     8.35987900
--
-1 1
C       49.48400000    28.18000000     6.01200000
C       49.67300000    28.49700000     7.48800000
O       49.69100000    27.53300000     8.29200000
O       49.82300000    29.69200000     7.84200000
H       48.80700000    27.33300000     5.90200000
H       50.44800000    27.87500000     5.59700000
H       49.11931000    29.02565000     5.41044000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011THR-166GLU-2')] = qcdb.Molecule("""
0 1
C       50.79200000    24.15000000     7.76300000
O       49.79200000    24.81000000     8.53700000
H       49.84700000    25.77100000     8.34800000
H       51.34200000    23.46200000     8.40700000
H       50.33136000    23.58850000     6.93684700
H       51.49658000    24.90160000     7.37743400
--
-1 1
C       49.48400000    28.18000000     6.01200000
C       49.67300000    28.49700000     7.48800000
O       49.69100000    27.53300000     8.29200000
O       49.82300000    29.69200000     7.84200000
H       48.80700000    27.33300000     5.90200000
H       50.44800000    27.87500000     5.59700000
H       49.11931000    29.02565000     5.41044000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011TYR-018ARG-1')] = qcdb.Molecule("""
0 1
C        6.81500000    87.03700000    23.65900000
C        7.47800000    85.92500000    24.44700000
C        8.81900000    86.05200000    24.87300000
C        6.75300000    84.77900000    24.80400000
C        9.44100000    85.06300000    25.66200000
C        7.36700000    83.78700000    25.58300000
C        8.69500000    83.92600000    26.01100000
O        9.20600000    82.89500000    26.76300000
H        6.00000000    86.62200000    23.06200000
H        7.55100000    87.48300000    22.98700000
H        9.36900000    86.93700000    24.58200000
H        5.72400000    84.65700000    24.48400000
H       10.46400000    85.16000000    26.00500000
H        6.81900000    82.89700000    25.86400000
H       10.12200000    83.02600000    27.02500000
H        6.42595500    87.86140000    24.27463000
--
1 1
C        9.25000000    85.75100000    20.85900000
C        9.72500000    83.68900000    22.27800000
N       10.02700000    84.92100000    21.82000000
N        8.61100000    83.05700000    21.92300000
N       10.60000000    83.03700000    23.04200000
H       10.83900000    85.38000000    22.20700000
H        7.96400000    83.49200000    21.28100000
H        8.40800000    82.13700000    22.28600000
H       11.49300000    83.45600000    23.26300000
H       10.38800000    82.11400000    23.39400000
H        8.37200000    86.13600000    21.38100000
H        8.91900000    85.11000000    20.04000000
H        9.78265900    86.60933000    20.42363000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011TYR-023ARG-1')] = qcdb.Molecule("""
0 1
C       -3.84200000    20.09800000   -14.23200000
C       -3.84700000    20.09400000   -12.69900000
C       -3.17400000    21.30100000   -14.86100000
C       -3.91300000    22.45300000   -15.12200000
C       -1.81700000    21.28200000   -15.19800000
C       -3.32300000    23.57000000   -15.70300000
C       -1.21200000    22.40000000   -15.78200000
C       -1.97100000    23.54600000   -16.02900000
O       -1.40900000    24.65200000   -16.59500000
H       -3.33700000    19.19700000   -14.57600000
H       -4.87300000    20.04500000   -14.58300000
H       -4.34100000    19.18200000   -12.39200000
H       -4.95300000    22.47600000   -14.84100000
H       -1.22500000    20.39500000   -15.01000000
H       -3.91700000    24.45300000   -15.90100000
H       -0.16400000    22.38400000   -16.04700000
H       -2.05400000    25.34900000   -16.75700000
H       -4.40238000    20.95081000   -12.28981000
H       -2.81605400    20.06796000   -12.31628000
--
1 1
C       -3.74600000    17.22200000   -16.78100000
C       -3.30500000    16.28200000   -15.67700000
C       -2.79000000    19.24200000   -17.83600000
N       -2.64200000    18.08000000   -17.22000000
N       -1.73000000    19.94200000   -18.17600000
N       -3.99700000    19.70700000   -18.10500000
H       -4.13400000    16.64400000   -17.62400000
H       -4.55300000    17.83700000   -16.37700000
H       -4.19700000    15.88100000   -15.19900000
H       -2.73400000    16.84400000   -14.93700000
H       -1.68300000    17.75200000   -17.08100000
H       -0.82200000    19.64000000   -17.81200000
H       -1.82100000    20.84400000   -18.60700000
H       -4.80900000    19.14900000   -17.90900000
H       -4.10500000    20.59600000   -18.56800000
H       -2.70236500    15.44769000   -16.06528000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011TYR-051GLU-1')] = qcdb.Molecule("""
0 1
C       10.76900000   -10.82200000     4.28200000
C       11.86500000    -7.82400000     2.17600000
C       11.26300000    -8.59000000     3.17700000
C       12.62800000    -8.44300000     1.18900000
C       11.41100000    -9.97800000     3.19600000
C       12.78600000    -9.82000000     1.20500000
C       12.17900000   -10.57900000     2.20000000
O       13.23100000    -7.72000000     0.19800000
H       11.75700000    -6.75300000     2.17800000
H       10.68400000    -8.10000000     3.95000000
H       13.07100000    -6.77500000     0.30000000
H       13.37800000   -10.29800000     0.43700000
H       11.04700000   -10.41300000     5.25500000
H       11.17500000   -11.83300000     4.22600000
H       12.30300000   -11.65500000     2.19300000
H        9.67205300   -10.88098000     4.22517500
--
-1 1
C       12.29800000    -3.49200000     2.30300000
C       10.93500000    -4.12800000     2.39600000
O       10.28200000    -3.99500000     3.45400000
O       10.52800000    -4.76700000     1.40300000
H       12.67300000    -3.54800000     1.27900000
H       12.99100000    -4.04500000     2.93800000
H       12.26892000    -2.43842000     2.61783800
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011TYR-102GLN-1')] = qcdb.Molecule("""
0 1
C       10.76900000   -10.82200000     4.28200000
C       12.17900000   -10.57900000     2.20000000
C       11.41100000    -9.97800000     3.19600000
C       12.78600000    -9.82000000     1.20500000
C       11.26300000    -8.59000000     3.17700000
C       12.62800000    -8.44300000     1.18900000
C       11.86500000    -7.82400000     2.17600000
O       13.23100000    -7.72000000     0.19800000
H       12.30300000   -11.65500000     2.19300000
H       13.37800000   -10.29800000     0.43700000
H       11.04700000   -10.41300000     5.25500000
H       11.17500000   -11.83300000     4.22600000
H       10.68400000    -8.10000000     3.95000000
H       11.75700000    -6.75300000     2.17800000
H       13.07100000    -6.77500000     0.30000000
H        9.67205300   -10.88098000     4.22517500
--
0 1
C       14.41700000   -11.80800000     5.45400000
C       14.51300000   -12.49900000     4.11100000
O       13.74800000   -13.41600000     3.82800000
N       15.45600000   -12.07400000     3.27200000
H       13.61600000   -12.25300000     6.04600000
H       14.17700000   -10.75900000     5.27500000
H       15.53500000   -12.52200000     2.37000000
H       16.05400000   -11.30000000     3.51600000
H       15.36828000   -11.87966000     6.00166200
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011TYR-169ILE-1')] = qcdb.Molecule("""
0 1
C       -3.84200000    20.09800000   -14.23200000
C       -3.91300000    22.45300000   -15.12200000
C       -3.17400000    21.30100000   -14.86100000
C       -3.32300000    23.57000000   -15.70300000
C       -1.97100000    23.54600000   -16.02900000
C       -1.81700000    21.28200000   -15.19800000
C       -1.21200000    22.40000000   -15.78200000
O       -1.40900000    24.65200000   -16.59500000
H       -4.95300000    22.47600000   -14.84100000
H       -3.91700000    24.45300000   -15.90100000
H       -3.33700000    19.19700000   -14.57600000
H       -4.87300000    20.04500000   -14.58300000
H       -1.22500000    20.39500000   -15.01000000
H       -2.05400000    25.34900000   -16.75700000
H       -0.16400000    22.38400000   -16.04700000
H       -3.84558800    20.09513000   -13.13201000
--
0 1
C       -7.59500000    22.96200000   -16.06900000
C       -8.87500000    23.55400000   -15.46700000
C       -7.53400000    21.43900000   -16.02500000
H       -7.49300000    23.29400000   -17.10300000
H       -6.73300000    23.33500000   -15.52900000
H       -9.08800000    22.98200000   -14.57800000
H       -8.34300000    21.00500000   -16.61200000
H       -6.58400000    21.10400000   -16.44100000
H       -7.60800000    21.09100000   -14.99300000
H       -8.71977800    24.60567000   -15.18432000
H       -9.71901100    23.45664000   -16.16569000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011VAL-144PHE-1')] = qcdb.Molecule("""
0 1
C       11.11000000     9.53900000   -23.26000000
C        9.86100000     9.15500000   -24.03900000
H       11.65900000     8.63800000   -22.99000000
H       11.76000000    10.16300000   -23.87200000
H       10.83700000    10.07400000   -22.35100000
H       10.17000000     8.62000000   -24.93700000
H        9.27663400    10.04160000   -24.32616000
H        9.24099200     8.47110400   -23.44077000
--
0 1
C       11.61900000     9.23400000   -17.62000000
C       12.80900000     6.94800000   -21.06000000
C       13.65600000     7.89700000   -20.51300000
C       11.57600000     6.74300000   -20.49400000
C       13.27500000     8.63600000   -19.40000000
C       11.18300000     7.48800000   -19.38800000
C       12.03000000     8.44000000   -18.83000000
H       13.12100000     6.36000000   -21.91400000
H       14.64300000     8.01400000   -20.92000000
H       10.90900000     5.99800000   -20.90700000
H       13.95600000     9.35900000   -18.97200000
H       10.21200000     7.31500000   -18.94900000
H       10.53900000     9.17100000   -17.48200000
H       11.86100000    10.28000000   -17.81700000
H       12.12699000     8.90836600   -16.70027000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011VAL-153LYS-1')] = qcdb.Molecule("""
0 1
C      -11.09300000     9.92500000    23.35100000
C       -9.84500000     9.42200000    24.08300000
H      -11.67100000     9.07500000    22.98900000
H      -11.72000000    10.49800000    24.03100000
H      -10.80200000    10.54400000    22.50200000
H      -10.17400000     8.84100000    24.94600000
H       -9.22061400    10.25954000    24.42749000
H       -9.25984500     8.74575600    23.44246000
--
0 1
C      -14.40300000    11.26100000    22.91300000
C      -14.30100000    12.26900000    21.78300000
C      -15.78500000    11.28700000    23.55100000
H      -14.15400000    10.26000000    22.55900000
H      -13.69900000    11.53500000    23.69900000
H      -14.77300000    13.19900000    22.10200000
H      -14.81700000    11.89400000    20.89800000
H      -15.76800000    10.65300000    24.44300000
H      -16.00600000    12.31000000    23.87500000
H      -13.25014000    12.47975000    21.53544000
H      -16.55801000    10.92903000    22.85507000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011VAL-153LYS-2')] = qcdb.Molecule("""
0 1
C      -11.09300000     9.92500000    23.35100000
C       -9.84500000     9.42200000    24.08300000
H      -11.67100000     9.07500000    22.98900000
H      -11.72000000    10.49800000    24.03100000
H      -10.80200000    10.54400000    22.50200000
H      -10.17400000     8.84100000    24.94600000
H       -9.22061400    10.25954000    24.42749000
H       -9.25984500     8.74575600    23.44246000
--
0 1
C      -12.84500000    12.56100000    21.44000000
C      -12.67500000    13.83100000    20.60800000
C      -14.30100000    12.26900000    21.78300000
H      -12.41800000    11.70600000    20.91200000
H      -12.28900000    12.69600000    22.37000000
H      -13.18300000    14.66400000    21.10000000
H      -14.77300000    13.19900000    22.10200000
H      -14.81700000    11.89400000    20.89800000
H      -13.05744000    13.67878000    19.58792000
H      -11.61201000    14.09584000    20.50841000
H      -14.37493000    11.53841000    22.60201000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '011VAL-155ILE-1')] = qcdb.Molecule("""
0 1
C       24.68700000    14.22100000    -2.44400000
C       25.41700000    12.89300000    -2.66800000
H       25.01900000    14.94400000    -3.18400000
H       23.61100000    14.08200000    -2.55200000
H       24.91400000    14.61200000    -1.46100000
H       25.37500000    12.69600000    -3.74000000
H       26.47249000    12.95264000    -2.36406900
H       24.91490000    12.04950000    -2.17161300
--
0 1
C       24.67800000    14.12200000     1.20500000
C       24.95900000    14.66600000     2.63300000
H       25.53800000    13.60100000     0.79200000
H       23.85000000    13.41800000     1.25000000
H       24.38800000    14.95700000     0.57000000
H       25.09100000    13.81600000     3.30300000
H       24.07700000    15.20800000     2.97500000
H       25.83781000    15.32280000     2.71244000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ALA-055PHE-1')] = qcdb.Molecule("""
0 1
C       28.99500000     8.74000000     3.95600000
C       29.67400000     8.34800000     5.27100000
H       29.47300000     8.24700000     3.11600000
H       27.93700000     8.48300000     3.97000000
H       29.07900000     9.82000000     3.83700000
H       29.05800000     8.68600000     6.10500000
H       30.66729000     8.81794200     5.32135100
H       29.82432000     7.25980200     5.32781900
--
0 1
C       29.03400000    13.75900000    -2.03400000
C       28.33600000    10.90400000     1.14100000
C       29.63400000    11.32300000     0.83600000
C       27.24900000    11.44000000     0.43600000
C       29.87300000    12.26100000    -0.16800000
C       27.49200000    12.38400000    -0.58600000
C       28.79100000    12.79600000    -0.89600000
H       28.15500000    10.16000000     1.89600000
H       30.46800000    10.91100000     1.39000000
H       26.24000000    11.11900000     0.65700000
H       30.88700000    12.56300000    -0.39100000
H       26.65400000    12.77500000    -1.14700000
H       29.80700000    14.44000000    -1.73300000
H       28.12700000    14.33600000    -2.22100000
H       29.35303000    13.25057000    -2.95580100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ALA-059PHE-1')] = qcdb.Molecule("""
0 1
C       28.99500000     8.74000000     3.95600000
C       29.67400000     8.34800000     5.27100000
H       29.47300000     8.24700000     3.11600000
H       27.93700000     8.48300000     3.97000000
H       29.07900000     9.82000000     3.83700000
H       29.05800000     8.68600000     6.10500000
H       30.66729000     8.81794200     5.32135100
H       29.82432000     7.25980200     5.32781900
--
0 1
C       27.88800000     7.87400000    -1.92000000
C       27.26200000     6.34000000     1.51900000
C       27.79400000     7.12100000     0.46700000
C       26.23200000     5.43800000     1.25100000
C       27.29600000     7.01700000    -0.83200000
C       25.73200000     5.31800000    -0.06500000
C       26.26200000     6.11100000    -1.09800000
H       27.65800000     6.42800000     2.52100000
H       28.58800000     7.82200000     0.68300000
H       25.80900000     4.84300000     2.05000000
H       24.89800000     4.66200000    -0.25700000
H       28.32100000     8.76800000    -1.46800000
H       27.09000000     8.20100000    -2.58800000
H       25.84700000     6.03400000    -2.09300000
H       28.66444000     7.34653800    -2.49351600
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ALA-108PHE-1')] = qcdb.Molecule("""
0 1
C       37.68500000    19.00300000     6.26600000
C       38.14600000    18.06300000     5.16600000
H       36.62400000    19.22800000     6.15400000
H       37.85000000    18.54600000     7.24000000
H       38.25100000    19.93500000     6.21800000
H       39.20600000    17.87400000     5.29100000
H       37.97447000    18.50387000     4.17291800
H       37.59471000    17.11282000     5.22287900
--
0 1
C       39.34700000    23.37100000     9.56600000
C       36.46900000    20.96600000     8.94800000
C       37.73600000    21.47300000     9.25700000
C       35.46100000    21.81400000     8.55300000
C       37.99100000    22.83600000     9.19200000
C       35.70600000    23.18200000     8.47200000
C       36.96700000    23.68900000     8.81000000
H       36.28800000    19.90700000     9.02200000
H       38.51600000    20.79200000     9.56500000
H       34.48400000    21.42200000     8.30900000
H       34.91300000    23.84700000     8.16000000
H       39.44100000    24.41000000     9.25600000
H       40.09400000    22.79600000     9.02100000
H       37.15700000    24.74500000     8.73700000
H       39.53950000    23.30804000    10.64719000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ALA-139ALA-1')] = qcdb.Molecule("""
0 1
C       28.99500000     8.74000000     3.95600000
C       29.67400000     8.34800000     5.27100000
H       29.47300000     8.24700000     3.11600000
H       27.93700000     8.48300000     3.97000000
H       29.07900000     9.82000000     3.83700000
H       29.05800000     8.68600000     6.10500000
H       30.66729000     8.81794200     5.32135100
H       29.82432000     7.25980200     5.32781900
--
0 1
C       26.00300000    11.12200000     4.05800000
C       25.02800000    12.30400000     4.10100000
H       25.73200000    10.44200000     3.24800000
H       27.01900000    11.48700000     3.89800000
H       25.96700000    10.58200000     5.00500000
H       25.32400000    12.97000000     4.91200000
H       23.99452000    11.95427000     4.24104400
H       25.07137000    12.87067000     3.15919300
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ASN-048PHE-1')] = qcdb.Molecule("""
0 1
C       -6.85400000    26.24200000   -24.46800000
C       -6.97500000    26.82900000   -25.85900000
O       -6.05200000    26.73100000   -26.66200000
N       -8.11100000    27.43700000   -26.15800000
H       -6.84800000    25.15700000   -24.57300000
H       -7.72600000    26.51600000   -23.87400000
H       -8.23600000    27.83300000   -27.08300000
H       -8.83400000    27.53300000   -25.46500000
H       -5.93499100    26.56729000   -23.95848000
--
0 1
C      -12.93500000    25.00800000   -28.62000000
C       -9.46800000    24.66100000   -27.12700000
C      -10.83800000    24.85700000   -27.24500000
C       -8.70100000    24.40000000   -28.25700000
C      -11.45300000    24.78600000   -28.49000000
C       -9.30900000    24.33100000   -29.50300000
C      -10.67900000    24.52700000   -29.61700000
H       -9.00000000    24.70700000   -26.15400000
H      -11.42900000    25.06100000   -26.36300000
H       -7.63300000    24.25600000   -28.16800000
H       -8.71600000    24.13200000   -30.38600000
H      -13.43600000    24.57600000   -27.75300000
H      -13.28600000    24.47400000   -29.49700000
H      -11.14200000    24.47300000   -30.59200000
H      -13.21356000    26.06841000   -28.70903000
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ASP-024LYS-2')] = qcdb.Molecule("""
-1 1
C        8.74900000   -11.50000000    -4.04300000
C       10.04000000   -11.66700000    -3.28100000
O       11.11100000   -11.36500000    -3.85200000
O        9.98700000   -12.13300000    -2.13300000
H        7.97200000   -12.14200000    -3.63100000
H        8.93700000   -11.83900000    -5.05300000
H        8.37862100   -10.46423000    -4.04084700
--
1 1
C       12.06000000   -14.45200000    -4.89000000
C       11.56400000   -15.36200000    -6.00900000
N       13.30900000   -14.99100000    -4.27400000
H       12.25700000   -13.45400000    -5.29300000
H       11.27300000   -14.35800000    -4.13300000
H       11.29900000   -16.33400000    -5.59000000
H       12.36700000   -15.51800000    -6.73400000
H       14.06000000   -15.05600000    -4.95100000
H       13.63000000   -14.38800000    -3.52500000
H       13.16300000   -15.91400000    -3.88100000
H       10.68808000   -14.95817000    -6.53785700
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ASP-026TYR-1')] = qcdb.Molecule("""
-1 1
C        8.74900000   -11.50000000    -4.04300000
C        8.23300000   -10.05700000    -4.04000000
C       10.04000000   -11.66700000    -3.28100000
O       11.11100000   -11.36500000    -3.85200000
O        9.98700000   -12.13300000    -2.13300000
H        7.97200000   -12.14200000    -3.63100000
H        8.93700000   -11.83900000    -5.05300000
H        7.89300000    -9.83300000    -3.02800000
H        7.40035500    -9.97222200    -4.75380400
H        9.02154300    -9.33416900    -4.29634900
--
0 1
C        3.99900000   -14.06500000    -2.80900000
C        6.80100000   -12.23200000    -0.96600000
C        5.72900000   -12.50000000    -1.83000000
C        7.33800000   -13.25900000    -0.19300000
C        5.19300000   -13.79200000    -1.92900000
C        6.80700000   -14.54900000    -0.27500000
C        5.74100000   -14.81000000    -1.13800000
O        8.37000000   -12.97200000     0.64700000
H        7.20300000   -11.23200000    -0.89800000
H        5.31000000   -11.69700000    -2.42100000
H        8.72000000   -12.10200000     0.43800000
H        7.23000000   -15.33500000     0.33000000
H        3.46700000   -13.13000000    -2.98000000
H        3.32200000   -14.69900000    -2.23400000
H        5.32700000   -15.80800000    -1.19000000
H        4.18680900   -14.55836000    -3.77405100
units angstrom
""")

GEOS['%s-%s-dimer' % (dbse, '012ASP-069TYR-1')] = qcdb.Molecule("""
-1 1
C        8.74900000   -11.50000000    -4.04300000
C        8.23300000   -10.05700000    -4.04000000
C       10.04000000   -11.66700000    -3.28100000
O       11.11100000   -11.36500000    -3.85200000
O        9.98700000   -12.13300000    -2.13300000
H        7.97200000   -12.14200000    -3.63100000
H        8.93700000   -11.83900000    -5.05300000
H        7.89300000    -9.83300000    -3.02800000
H        7.40035500    -9.97222200    -4.75380400
H        9.02154300    -9.33416900    -4.29634900
--
0 1
C        8.54800000   -18.36900000    -5.44800000
C        8.66300000   -15.23800000    -3.24700000
C        9.65000000   -15.59600000    -2.32400000
C        8.29700000   -16.13100000    -4.25700000
C        8.90100000   -17.39200000    -4.34800000
C       10.26300000   -16.84900000    -2.41200000
C        9.88100000   -17.73800000    -3.41100000
O       10.02100000   -14.70600000    -1.35400000
H        8.18100000   -14.27900000    -3.1590