#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: StringSetDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import Pmw

class StringSetDialog(Pmw.Dialog):

    def __init__(self, master, title="", 
                 available_strings=[], selected_strings=[], allowmultiselect=0,
                 **kws):
        Pmw.Dialog.__init__(self, master=master, title=title,
            buttons=('Ok','Cancel'), defaultbutton='Ok', **kws)  

        self.allowmultiselect = allowmultiselect    
            
        self.interior().columnconfigure(0, weight=1)  
        self.interior().columnconfigure(2, weight=1)  
        self.interior().rowconfigure(1, weight=1)  
        self.interior().rowconfigure(2, weight=1)  
          
        lbl = Label(self.interior(), text="Available:")
        lbl.grid(padx=2, pady=2)
        lbl = Label(self.interior(), text="Selected:")
        lbl.grid(row=0, column=2, padx=2, pady=2)

        b = Button(self.interior(), text="Add >>", command=self.add)
        b.grid(row=1, column=1, padx=2, pady=2, sticky=W+E+S)
        b = Button(self.interior(), text="<< Remove", command=self.remove)
        b.grid(row=2, column=1, padx=2, pady=2, sticky=W+E+N)
        
        self.avail_listbox = avail = Pmw.ScrolledListBox(self.interior(),
            listbox_highlightthickness=0)
        avail.grid(row=1, rowspan=2, column=0, padx=2, pady=2, sticky=W+E+S+N)
        
        self.sel_listbox = sel = Pmw.ScrolledListBox(self.interior(),
            listbox_highlightthickness=0)
        sel.grid(row=1, rowspan=2, column=2, padx=2, pady=2, sticky=W+E+S+N)

        avail.setlist(available_strings[:])
        sel.setlist(selected_strings[:])

    def add(self):
        list = self.sel_listbox.get()
        item = self.avail_listbox.get(ACTIVE)
        if not item in list or self.allowmultiselect:
            self.sel_listbox.insert(END, item)

    def remove(self):
        self.sel_listbox.delete(ACTIVE)

    def getvalue(self):
        return self.sel_listbox.get()

if __name__ == "__main__":
    # Unit Test:
    tk = Tk()
    avail = ["Orange", "Cherry", "Apple", "Banana"]
    sel = ["Orange", "Apple"]       
    dlg = StringSetDialog(tk, title="Test",
        available_strings=avail, selected_strings=sel)
    def printres(btn, dlg=dlg):
        if btn=='Ok': 
            print dlg.getvalue()
        dlg.deactivate()
    dlg['command'] = printres       
    dlg.activate()
    tk.destroy()
