#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# threaded.py - threaded use of pyinotify
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
# usage: ./threaded.py [path-to-watch]

from process import PExample
# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import ThreadedNotifier, WatchManager, \
         EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import  ThreadedNotifier, WatchManager, EventsCodes


if __name__ == '__main__':
    #
    # - watch for selected events and do processing with PExample()
    # - The watched path is '/tmp' (by default) or the first
    #   command line argument if given.
    # - A separate thread is instanciated and the monitoring thread
    #   serve forever, type c^c to stop it.
    # - You can read a non-threaded version of this example in
    #   simple_example.py
    #
    import sys

    path = '/tmp'  # default watched path
    if sys.argv[1:]:
        path = sys.argv[1]

    # only watch those events
    mask = EventsCodes.IN_MODIFY | EventsCodes.IN_DELETE | \
           EventsCodes.IN_OPEN | EventsCodes.IN_ATTRIB | \
           EventsCodes.IN_CREATE

    # watch manager instance
    wm = WatchManager()
    # notifier instance and init, give an instance of PExample as
    # processing function.
    notifier = ThreadedNotifier(wm, PExample())
    # start notifier's thread
    notifier.start()

    # watch path for events handled by mask.
    wm.add_watch(path, mask)

    print 'start monitoring %s with mask 0x%08x' % (path, mask)

    # keep artificially the main thread alive forever
    while True:
        try:
            import time
            time.sleep(5)
        except KeyboardInterrupt:
            # ...until c^c signal
            print 'stop monitoring...'
            # stop monitoring
            notifier.stop()
            break
        except Exception, err:
            # otherwise keep on looping
            print err
