
#### I18N stuff
try:
	import gettext
	import commands
except ImportError:
	# python 1.5.2. no i18n stuff
	def _dummy(s):
		return s
	import __builtin__
	__builtin__.__dict__['_'] = _dummy
else:
	try:
		domain = 'pyne'

		data_dir = commands.getoutput('gnome-config --datadir')
		locale_dir = data_dir + '/locale'

		gettext.bindtextdomain(domain, locale_dir)
		gettext.textdomain(domain)

	except IOError:
		pass
	import __builtin__
	__builtin__.__dict__['_'] = gettext.gettext

