'''OpenGL extension NV.fragment_program_option

Overview (from the spec)
	
	This extension provides additional fragment program functionality
	to extend the standard ARB_fragment_program language and execution
	environment.  ARB programs wishing to use this added functionality
	need only add:
	
	    OPTION NV_fragment_program;
	
	to the beginning of their fragment programs.
	
	The functionality provided by this extension, which is roughly
	equivalent to that provided by the NV_fragment_program extension,
	includes:
	
	  * increased control over precision in arithmetic computations and
	    storage,
	
	  * data-dependent conditional writemasks,
	
	  * an absolute value operator on scalar and swizzled operand loads,
	
	  * instructions to compute partial derivatives, and perform texture
	    lookups using specified partial derivatives,
	
	  * fully orthogonal "set on" instructions,
	
	  * instructions to compute reflection vector and perform a 2D
	    coordinate transform, and
	
	  * instructions to pack and unpack multiple quantities into a single
	    component.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/fragment_program_option.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_fragment_program_option'



def glInitFragmentProgramOptionNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
